// TextPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TextPropDlg.h"
#include "PropertyDlg.h"
#include "ReportDict.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextPropDlg dialog


CTextPropDlg::CTextPropDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CTextPropDlg::IDD, pParent)
	, m_bShowTopLine(FALSE)
	, m_bHideForOnePage(FALSE)
{
	//{{AFX_DATA_INIT(CTextPropDlg)
	m_text = _T("");
	m_size_font = 0;
	m_name_font = _T("");
	m_hide_frame = FALSE;
	m_fit_to_rect = FALSE;
	m_bCreateTableContent = FALSE;
	//}}AFX_DATA_INIT
	m_align = 0;
	m_direction = HORIZ_TEXT;
}


void CTextPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTextPropDlg)
	DDX_Control(pDX, IDC_VERT_TEXT, m_vert_btn);
	DDX_Control(pDX, IDC_RVERT_TEXT, m_rvert_btn);
	DDX_Control(pDX, IDC_RHORZ_TEXT, m_rhorz_btn);
	DDX_Control(pDX, IDC_HORZ_TEXT, m_horz_btn);
	DDX_Control(pDX, IDC_FONT_SELECT, m_font_btn);
	DDX_Control(pDX, IDC_TEXT_COLOR, m_TextColorCtrl);
	DDX_Control(pDX, IDC_WORD_BREAK, m_word_break_btn);
	DDX_Control(pDX, IDC_SPACE2, m_space2_btn);
	DDX_Control(pDX, IDC_SPACE15, m_space15_btn);
	DDX_Control(pDX, IDC_SPACE1, m_space1_btn);
	DDX_Control(pDX, IDC_TOP_RIGHT, m_tr_btn);
	DDX_Control(pDX, IDC_TOP_LEFT, m_tl_btn);
	DDX_Control(pDX, IDC_TOP_CENTER, m_tc_btn);
	DDX_Control(pDX, IDC_CENTER_RIGHT, m_cr_btn);
	DDX_Control(pDX, IDC_CENTER_LEFT, m_cl_btn);
	DDX_Control(pDX, IDC_CENTER, m_center_btn);
	DDX_Control(pDX, IDC_BOTTOM_LEFT, m_bl_btn);
	DDX_Control(pDX, IDC_BOTTOM_CENTER, m_bc_btn);
	DDX_Control(pDX, IDC_BOTTEM_RIGHT, m_br_btn);
	DDX_Control(pDX, IDC_SHOW_TEXT, m_show_text);
	DDX_Control(pDX, IDC_SHOW_PARAM, m_show_param);
	DDX_Text(pDX, IDC_TEXT, m_text);
	DDX_Text(pDX, IDC_SIZE_FONT, m_size_font);
	DDX_Text(pDX, IDC_NAME_FONT, m_name_font);
	DDX_Check(pDX, IDC_HIDE_FRAME, m_hide_frame);
	DDX_Check(pDX, IDC_FIT_TO_RECT, m_fit_to_rect);
	DDX_Check(pDX, IDC_CREATE_TABLE_CONTENT, m_bCreateTableContent);
	//}}AFX_DATA_MAP
	DDX_Check(pDX, IDC_SHOW_TOP_LINE, m_bShowTopLine);
	DDX_Control(pDX, IDC_USE_EVEN_CHECK, m_use_even_check);
	DDX_Control(pDX, IDC_USE_EVEN_COMBO, m_use_even_combo);
	DDX_Check(pDX, IDC_HIDE_FOR_ONE_PAGE, m_bHideForOnePage);
}


BEGIN_MESSAGE_MAP(CTextPropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CTextPropDlg)
	ON_BN_CLICKED(IDC_FONT_SELECT, OnFontSelect)
	ON_BN_CLICKED(IDC_SHOW_PARAM, OnShowParam)
	ON_BN_CLICKED(IDC_SHOW_TEXT, OnShowText)
	ON_BN_CLICKED(IDC_TOP_LEFT, OnTopLeft)
	ON_BN_CLICKED(IDC_TOP_CENTER, OnTopCenter)
	ON_BN_CLICKED(IDC_TOP_RIGHT, OnTopRight)
	ON_BN_CLICKED(IDC_CENTER_LEFT, OnCenterLeft)
	ON_BN_CLICKED(IDC_CENTER, OnCenter)
	ON_BN_CLICKED(IDC_CENTER_RIGHT, OnCenterRight)
	ON_BN_CLICKED(IDC_BOTTOM_LEFT, OnBottomLeft)
	ON_BN_CLICKED(IDC_BOTTOM_CENTER, OnBottomCenter)
	ON_BN_CLICKED(IDC_BOTTEM_RIGHT, OnBottemRight)
	ON_BN_CLICKED(IDC_SPACE1, OnSpace1)
	ON_BN_CLICKED(IDC_SPACE15, OnSpace15)
	ON_BN_CLICKED(IDC_SPACE2, OnSpace2)
	ON_BN_CLICKED(IDC_FIT_TO_RECT, OnFitToRect)
	ON_BN_CLICKED(IDC_RVERT_TEXT, OnRvertText)
	ON_BN_CLICKED(IDC_HORZ_TEXT, OnHorzText)
	ON_BN_CLICKED(IDC_VERT_TEXT, OnVertText)
	ON_BN_CLICKED(IDC_RHORZ_TEXT, OnRhorzText)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_USE_EVEN_CHECK, &CTextPropDlg::OnBnClickedUseEvenCheck)
	ON_CBN_SELCHANGE(IDC_USE_EVEN_COMBO, &CTextPropDlg::OnCbnSelchangeUseEvenCombo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextPropDlg message handlers

BOOL CTextPropDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	CImageList Buttons_il;
	CBitmap bm;
	bm.LoadBitmap(IDB_TEXT_FORMAT);
	Buttons_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
	Buttons_il.Add(&bm, RGB(192,192,192));
	bm.DeleteObject();

	m_font_btn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_font_btn.SetWindowText(_T(""));
	
	m_space2_btn.SetIcon(Buttons_il.ExtractIcon(11));
	m_space2_btn.SetWindowText(_T(""));
	m_space15_btn.SetIcon(Buttons_il.ExtractIcon(10));
	m_space15_btn.SetWindowText(_T(""));
	m_space1_btn.SetIcon(Buttons_il.ExtractIcon(9));
	m_space1_btn.SetWindowText(_T(""));

	m_tl_btn.SetIcon(Buttons_il.ExtractIcon(0));
	m_tl_btn.SetWindowText(_T(""));

	m_tc_btn.SetIcon(Buttons_il.ExtractIcon(1));
	m_tc_btn.SetWindowText(_T(""));

	m_tr_btn.SetIcon(Buttons_il.ExtractIcon(2));
	m_tr_btn.SetWindowText(_T(""));

	m_cr_btn.SetIcon(Buttons_il.ExtractIcon(5));
	m_cr_btn.SetWindowText(_T(""));

	m_cl_btn.SetIcon(Buttons_il.ExtractIcon(3));
	m_cl_btn.SetWindowText(_T(""));

	m_center_btn.SetIcon(Buttons_il.ExtractIcon(4));
	m_center_btn.SetWindowText(_T(""));
	
	m_bl_btn.SetIcon(Buttons_il.ExtractIcon(6));
	m_bl_btn.SetWindowText(_T(""));

	m_bc_btn.SetIcon(Buttons_il.ExtractIcon(7));
	m_bc_btn.SetWindowText(_T(""));

	m_br_btn.SetIcon(Buttons_il.ExtractIcon(8));
	m_br_btn.SetWindowText(_T(""));


	CTextValue* val = &elem->m_value;
	m_text = val->GetText();
	m_lf = val->m_font;
	m_Color = val->m_color;
	m_direction = val->m_direction;
	m_hide_frame = !val->m_border_visible;

	m_bCreateTableContent = elem->m_bCreateTableContent?TRUE:FALSE;

	m_TextColorCtrl.SetBkColor(m_Color);

	m_align = val->m_align;

	m_use_even_combo.AddString(ID_STRING_EVEN);
	m_use_even_combo.AddString(ID_STRING_ODD);

	m_use_even_combo.SelectString(0,ID_STRING_EVEN);
	m_use_even_check.SetCheck((val->m_align&AT_USE_EVEN)!=0);
	m_use_even_combo.EnableWindow((val->m_align&AT_USE_EVEN)!=0);
	
	SetCheck(m_align,false);
	SetSpaceState(val->m_space_para);

	m_name_font = m_lf.lfFaceName;
	m_size_font = m_lf.lfHeight/10;
	CButton* btn = (CButton*)GetDlgItem(IDC_WORD_BREAK);
	btn->SetCheck(!(val->m_text_params&APL_TP_NOTBREAKSTRING));
	if(val->m_text_params&APL_TP_FITTORECT)
		m_fit_to_rect = TRUE;
	if(val->m_text_params&APL_TP_HIDE_FOR_ONE_PAGE)
		m_bHideForOnePage = TRUE;
	btn->EnableWindow(!m_fit_to_rect);
	LoadParams();
	if(elem->m_value.GetType()==INST_VAL)
		OnShowParam();
	else 
		OnShowText();

	m_bShowTopLine = elem->m_Flags&APL_RRE_SHOW_TOP_LINE;



	//  
	SetTextDirectionsButtonsIco(&m_horz_btn, HORIZ_TEXT);
	SetTextDirectionsButtonsIco(&m_vert_btn, VERT_TEXT);
	SetTextDirectionsButtonsIco(&m_rhorz_btn, RHORZ_TEXT);
	SetTextDirectionsButtonsIco(&m_rvert_btn, RVERT_TEXT);

	SetTextDirection(m_direction);

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTextPropDlg::OnFontSelect() 
{
	UpdateData();
	CDC *pDC = GetDC();
	CFontDialog	dlg(&m_lf);
	int old = m_lf.lfHeight;
	m_lf.lfHeight = -MulDiv(-old/10, ::GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 72);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	dlg.m_cf.lpLogFont = &m_lf;
	dlg.m_cf.rgbColors = m_Color;
	if(dlg.DoModal()==IDOK)
	{
		m_size_font = dlg.GetSize()/10;
		m_name_font = m_lf.lfFaceName;
		m_lf.lfHeight = dlg.GetSize();
		m_Color = dlg.m_cf.rgbColors;
		m_TextColorCtrl.SetBkColor(m_Color);
		UpdateData(FALSE);
	}
	else m_lf.lfHeight = old;

	ReleaseDC(pDC);
}

bool CTextPropDlg::UpdateDlg(BOOL UPD)
{
	if(!UpdateData(UPD)) return false;
	if(m_show_param.GetCheck())
	{
		CComboBox* cb = (CComboBox*)GetDlgItem(IDC_PARAMS);
		int cur = cb->GetCurSel();
		if(cur<0)
		{
			AfxMessageBox(APL_T("    "));
			return false;
		}
		CReportParam* par = (CReportParam*)cb->GetItemData(cur);
		par->Update(true);
		elem->m_value.SetText(par);
	}
	else
	{
		elem->m_value.SetText(m_text);
	}

	elem->m_value.m_font = m_lf;
	elem->m_value.m_color = m_Color;
	elem->m_value.m_align = 0;
	elem->m_value.m_text_params = 0;

	elem->m_value.m_align = GetAlign();
	elem->m_value.m_space_para = GetSpacePara();
	elem->m_bCreateTableContent = (bool)(m_bCreateTableContent==TRUE);

	elem->m_Flags = 0;
	if(m_bShowTopLine)
		elem->m_Flags|=APL_RRE_SHOW_TOP_LINE;

	elem->m_value.m_border_visible = !m_hide_frame;
	elem->m_value.m_direction = m_direction;
	CButton* btn = (CButton*)GetDlgItem(IDC_WORD_BREAK);
	if(m_fit_to_rect)
		elem->m_value.m_text_params |= APL_TP_FITTORECT;
	if(m_bHideForOnePage)
		elem->m_value.m_text_params |= APL_TP_HIDE_FOR_ONE_PAGE;
	//   fit_text  
	if(btn->GetCheck()==0)
		elem->m_value.m_text_params |= APL_TP_NOTBREAKSTRING;

	return true;
}

void CTextPropDlg::OnOK()
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnOK();
}

void CTextPropDlg::OnCancel()
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnCancel();
}

void CTextPropDlg::OnShowParam() 
{
	m_show_text.SetCheck(0);
	m_show_param.SetCheck(1);
	CEdit* edit = (CEdit*)GetDlgItem(IDC_TEXT);
	edit->SetReadOnly(TRUE);
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_PARAMS);
	cb->EnableWindow();
}

void CTextPropDlg::OnShowText() 
{
	m_show_param.SetCheck(0);
	m_show_text.SetCheck(1);
	CEdit* edit = (CEdit*)GetDlgItem(IDC_TEXT);
	edit->SetReadOnly(FALSE);
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_PARAMS);
	cb->EnableWindow(FALSE);
}

void CTextPropDlg::LoadParams()
{
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_PARAMS);
	if(cb==0) return;
	cb->ResetContent();
	int cnt = elem->m_ReportMgr->m_data_source.m_params.GetSize();
	for(int i=0; i<cnt;i++)
	{
		CReportParam* par = elem->m_ReportMgr->m_data_source.m_params.GetAt(i);
		int ind = cb->AddString(par->m_name);
		cb->SetItemData(ind, DWORD(par));
		if(elem->m_value.GetParam()==par)
			cb->SetCurSel(ind);
	}
}

void CTextPropDlg::SetCheck(UINT align, bool bChange)
{
	CString sEven;
	BOOL bCheck;
	BOOL bEven;
	m_tl_btn.SetState(0);
	m_tc_btn.SetState(0);
	m_tr_btn.SetState(0);
	m_cl_btn.SetState(0);
	m_center_btn.SetState(0);
	m_cr_btn.SetState(0);
	m_bl_btn.SetState(0);
	m_bc_btn.SetState(0);
	m_br_btn.SetState(0);
	m_use_even_combo.GetWindowText(sEven);
	bCheck = m_use_even_check.GetCheck();
	bEven = sEven.CompareNoCase(ID_STRING_EVEN);

	m_align&=07777;
	if(bCheck)
		m_align|=010000;

	if (bChange)
	{
		if (bEven)
		{
			m_align&=010077;
			m_align|=align<<6;
		}
		else
		{
			m_align&=017700;
			m_align|=align;
		}
	}
	else
	{
		if (bEven)
			align = m_align>>6;
		else
			align = m_align;
	}

	if(align&AT_TOP && align&AT_LEFT)
		m_tl_btn.SetState(1);
	else if(align&AT_TOP && align&AT_CENTER)
		m_tc_btn.SetState(1);
	else if(align&AT_TOP && align&AT_RIGHT)
		m_tr_btn.SetState(1);
	else if(align&AT_VCENTER && align&AT_LEFT)
		m_cl_btn.SetState(1);
	else if(align&AT_VCENTER && align&AT_CENTER)
		m_center_btn.SetState(1);
	else if(align&AT_VCENTER && align&AT_RIGHT)
		m_cr_btn.SetState(1);
	else if(align&AT_BOTTOM&& align&AT_LEFT)
		m_bl_btn.SetState(1);
	else if(align&AT_BOTTOM&& align&AT_CENTER)
		m_bc_btn.SetState(1);
	else if(align&AT_BOTTOM&& align&AT_RIGHT)
		m_br_btn.SetState(1);

}

UINT CTextPropDlg::GetAlign()
{
	return m_align;
}

void CTextPropDlg::OnTopLeft() 
{
	SetCheck(AT_TOP|AT_LEFT);
}

void CTextPropDlg::OnTopCenter() 
{
	SetCheck(AT_TOP|AT_CENTER);
}

void CTextPropDlg::OnTopRight() 
{
	SetCheck(AT_TOP|AT_RIGHT);
}

void CTextPropDlg::OnCenterLeft() 
{
	SetCheck(AT_VCENTER|AT_LEFT);
}

void CTextPropDlg::OnCenter() 
{
	SetCheck(AT_VCENTER|AT_CENTER);
}

void CTextPropDlg::OnCenterRight() 
{
	SetCheck(AT_VCENTER|AT_RIGHT);
}

void CTextPropDlg::OnBottomLeft() 
{
	SetCheck(AT_BOTTOM|AT_LEFT);
}

void CTextPropDlg::OnBottomCenter() 
{
	SetCheck(AT_BOTTOM|AT_CENTER);
}

void CTextPropDlg::OnBottemRight() 
{
	SetCheck(AT_BOTTOM|AT_RIGHT);
}

void CTextPropDlg::SetSpaceState(UINT space)
{
	m_space15_btn.SetState(0);
	m_space1_btn.SetState(0);
	m_space2_btn.SetState(0);

	if(space==aplSpacePara1)
		m_space1_btn.SetState(1);
	else if(space==aplSpacePara15)
		m_space15_btn.SetState(1);
	else if(space==aplSpacePara2)
		m_space2_btn.SetState(1);
}

UINT CTextPropDlg::GetSpacePara()
{
	if(m_space1_btn.GetState()>0)
		return aplSpacePara1;
	else if(m_space15_btn.GetState()>0)
		return aplSpacePara15;
	else if(m_space2_btn.GetState()>0)
		return aplSpacePara2;

	return aplSpacePara15;
}

void CTextPropDlg::OnSpace1() 
{
	SetSpaceState(aplSpacePara1);
}

void CTextPropDlg::OnSpace15() 
{
	SetSpaceState(aplSpacePara15);
}

void CTextPropDlg::OnSpace2() 
{
	SetSpaceState(aplSpacePara2);
}

void CTextPropDlg::OnFitToRect() 
{
	UpdateData();
	m_word_break_btn.EnableWindow(m_fit_to_rect==TRUE? FALSE:TRUE);
	if(m_fit_to_rect)
		m_word_break_btn.SetCheck(0);
	
}

bool CTextPropDlg::TestUpdate()
{
	if(!UpdateData()) return false;
	if(m_show_param.GetCheck())
	{
		CComboBox* cb = (CComboBox*)GetDlgItem(IDC_PARAMS);
		int cur = cb->GetCurSel();
		if(cur<0)
		{
			AfxMessageBox(APL_T("    "));
			return false;
		}
	}

	return true;
}

void CTextPropDlg::OnRvertText() 
{
	SetTextDirection(VERT_TEXT);
}

void CTextPropDlg::OnHorzText() 
{
	SetTextDirection(HORIZ_TEXT);
}

void CTextPropDlg::OnVertText() 
{
	SetTextDirection(RVERT_TEXT);
}

void CTextPropDlg::OnRhorzText() 
{
	SetTextDirection(RHORZ_TEXT);
}

void CTextPropDlg::SetTextDirection(UINT Direction)
{
	m_horz_btn.SetState(FALSE);
	m_rhorz_btn.SetState(FALSE);
	m_vert_btn.SetState(FALSE);
	m_rvert_btn.SetState(FALSE);
	switch(Direction)
	{
	case HORIZ_TEXT: m_horz_btn.SetState(TRUE);
		break;
	case RHORZ_TEXT: m_rhorz_btn.SetState(TRUE);
		break;
	case VERT_TEXT: m_rvert_btn.SetState(TRUE);
	    break;
	case RVERT_TEXT: m_vert_btn.SetState(TRUE);
	    break;
	}

	m_direction = Direction;
}

void CTextPropDlg::SetTextDirectionsButtonsIco(CaplButton *btn, UINT Direction)
{
	btn->SetWindowText(_T(""));

	CBitmap bm, *pOldBm;
	CImageList tmp_il;
	CRect cl_rect;
	CDC *pDC = GetDC();
	CDC BmpDC;
	CFont font, *pOldFont;
	LOGFONT lf;
	memset(&lf, 0, sizeof(LOGFONT));
	
	lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfQuality = DEFAULT_QUALITY;
	lf.lfPitchAndFamily = DEFAULT_PITCH;
	lf.lfWidth = 0;
	lf.lfOrientation = 0;
	lf.lfStrikeOut = 0;
	lf.lfItalic = 0;
	lf.lfUnderline = 0;
	lf.lfEscapement = 0;
	lf.lfHeight = 120;
	lf.lfWeight = FW_NORMAL;
	lf.lfCharSet = RUSSIAN_CHARSET;

	BmpDC.CreateCompatibleDC(pDC);
	m_vert_btn.GetClientRect(&cl_rect);
	bm.CreateCompatibleBitmap(pDC, cl_rect.Width(), cl_rect.Height());
	pOldBm = BmpDC.SelectObject(&bm);
	BmpDC.FillSolidRect(cl_rect, RGB(255, 255, 255));

	//   
	int x = 0, y = 0;
	switch(Direction)
	{
	case HORIZ_TEXT:
		lf.lfEscapement=0;
		lf.lfOrientation=0;
		x = cl_rect.Width()/2-BmpDC.GetTextExtent(APL_T("")).cx/2;
		y = cl_rect.Height()/2-BmpDC.GetTextExtent(APL_T("")).cy/2;
		break;
	case VERT_TEXT:
		lf.lfEscapement=-900;
		lf.lfOrientation=-900;
		y = cl_rect.Height()/2-BmpDC.GetTextExtent(APL_T("")).cx/2;
		x = cl_rect.Width()/2+BmpDC.GetTextExtent(APL_T("")).cy/2;
		break;
	case RHORZ_TEXT:
		lf.lfEscapement=1800;
		lf.lfOrientation=1800;
		x = cl_rect.right-cl_rect.Width()/2+BmpDC.GetTextExtent(APL_T("")).cx/2;
		y = cl_rect.bottom-cl_rect.Height()/2+BmpDC.GetTextExtent(APL_T("")).cy/2;
		break;
	case RVERT_TEXT:
		lf.lfEscapement=900;
		lf.lfOrientation=900;
		y = cl_rect.bottom-cl_rect.Height()/2+BmpDC.GetTextExtent(APL_T("")).cx/2;
		x = cl_rect.left+cl_rect.Width()/2-BmpDC.GetTextExtent(APL_T("")).cy/2;
		break;
	}
	
	font.CreatePointFontIndirect(&lf, &BmpDC);
	pOldFont = BmpDC.SelectObject(&font);

	BmpDC.TextOut(x, y, APL_T(""));
	BmpDC.SelectObject(pOldBm);
	BmpDC.SelectObject(pOldFont);
	tmp_il.Create(cl_rect.Width(), cl_rect.Height(), ILC_COLOR24|ILC_MASK, 1, 1);
	tmp_il.Add(&bm, RGB(255, 255, 255));
	btn->SetIcon(tmp_il.ExtractIcon(0));
	bm.DeleteObject();
	tmp_il.DeleteImageList();
	
	ReleaseDC(pDC);
}

void CTextPropDlg::OnBnClickedUseEvenCheck()
{
	m_use_even_combo.EnableWindow(m_use_even_check.GetCheck());
	m_use_even_combo.SelectString(0,ID_STRING_EVEN);
	m_align&=01000777;
	SetCheck(m_align,false);
}

void CTextPropDlg::OnCbnSelchangeUseEvenCombo()
{
	SetCheck(m_align,false);	
}
