// FilterStruct.cpp: implementation of the CFilterStruct class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "FilterStruct.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFilterStruct::CFilterStruct()
{
	m_api=0;
	m_project_mgr=0;
	m_bEnabled=false;

	m_customer=0;
	m_kurator=0;
	m_executor=0;
	m_filter_by_customer=false;
	m_filter_by_kurator=false;
	m_filter_by_executor=false;
	m_filter_out_of_time=false;
	m_date_planned_begin=_T("");
	m_date_planned_end=_T("");
	m_date_actual_begin=_T("");
	m_date_actual_end=_T("");
	m_filter_type=0;

	//bShowAdminVersion=true;
}

CFilterStruct::~CFilterStruct()
{

}

bool CFilterStruct::FilterProject(CaplInstance *project)
{
	if(!m_bEnabled) return true;
	if(!project) return false;
	if(project->GetAccessmode()>aplRO) return false;
	if(m_filter_type==APL_FILTER_ELEMENTS_EXPANDING)
	{
		bool use_ass_prj=false;
		if(m_api->m_project_mgr->m_show_ass_projects==1) use_ass_prj=true;
		if(m_project_mgr->IsProjectHaveChildren(project, use_ass_prj)) return true;
	}

	CaplInstance *lock=m_project_mgr->CheckMyLock(project,false);

	//     
	if(m_filter_out_of_time)
	{
		COleDateTime time(COleDateTime::GetCurrentTime());
		CString sPlannedEndDate, sActualEndDate, sCurrDate;

		aplDate2String(time, sCurrDate);

		if(!lock) m_api->m_data.GetAttr(project, m_api->m_project_mgr->a_project_date_planned_end, sPlannedEndDate);
		else m_api->m_data.GetAttr(lock, m_api->m_project_mgr->a_project_adm_ver_date_planned_end, sPlannedEndDate);								

		m_api->m_data.GetAttr(project, m_api->m_project_mgr->a_project_date_actual_end, sActualEndDate);
		
		// ,  ,     
		bool bOutOfDate = (!sPlannedEndDate.IsEmpty() && !sActualEndDate.IsEmpty() && sActualEndDate>sPlannedEndDate);
		bool bOutOfDate2 = (!sPlannedEndDate.IsEmpty() && sActualEndDate.IsEmpty() && sCurrDate>sPlannedEndDate);

		if(!bOutOfDate && !bOutOfDate2) return false;
	}

	CString buf=_T("");
	bool m_all_result=false;
	bool m_states_result=false;
	if(!m_states.GetSize()) 
		m_states_result=true;
	else
	{
		m_api->m_data.GetAttr(project,m_project_mgr->a_project_state,buf);
		for(int i=0;i<m_states.GetSize();i++)
		{
			if(m_states[i]==buf) {m_states_result=true;break;}
		}
	}
	bool m_types_result=false;
	CaplInstance *inst=0;
	if(!m_types.GetSize()) 
		m_types_result=true;
	else
	{
		m_api->m_data.GetAttr(project,m_project_mgr->a_project_type,inst);
		for(int i=0;i<m_types.GetSize();i++)
		{
			if(m_types[i]==inst) {m_types_result=true;break;}
		}
	}

	bool m_number_result=true;
	if(m_number!=_T(""))
	{
		if(lock) m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_number,buf);
		else m_api->m_data.GetAttr(project,m_project_mgr->a_project_number,buf);

		buf.MakeLower();
		CString buf1=m_number;
		buf1.MakeLower();

		if(buf.Find(buf1)<0) m_number_result=false;

	}

	bool m_prj_id_result=true;
	if(m_id!=_T(""))
	{
		if(lock) m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_id,buf);
		else m_api->m_data.GetAttr(project,m_project_mgr->a_project_id,buf);

		buf.MakeLower();
		CString buf1=m_id;
		buf1.MakeLower();

		if(buf.Find(buf1)<0) m_prj_id_result=false;
	}

	bool m_prj_name_result=true;
	if(m_name!=_T(""))
	{
		if(lock) m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_name,buf);
		else m_api->m_data.GetAttr(project,m_project_mgr->a_project_name,buf);

		buf.MakeLower();
		CString buf1=m_name;
		buf1.MakeLower();

		if(buf.Find(buf1)<0) m_prj_name_result=false;
	}


	bool m_customer_result=false;
	if(m_filter_by_customer)
	{
		if(lock) m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_customer,inst);
		else m_api->m_data.GetAttr(project,m_project_mgr->a_project_customer,inst);
		if(inst==m_customer) m_customer_result=true;
	}
	else
		m_customer_result=true;
	bool m_kurator_result=false;
	if(m_filter_by_kurator)
	{
		if(lock) m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_kurator,inst);
		else m_api->m_data.GetAttr(project,m_project_mgr->a_project_kurator,inst);
		if(inst==m_kurator) m_kurator_result=true;
	}
	else
		m_kurator_result=true;
	bool m_executor_result=false;
	if(m_filter_by_executor)
	{
		aplExtent ext;
		if(lock) m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_executors,ext); 
		else m_api->m_data.GetAttr(project,m_project_mgr->a_project_executors,ext);
		if(!m_executor) // ,     
		{
			if(!ext.GetSize()) m_executor_result=true;
		}
		else
		{
			for(int i=0;i<ext.GetSize();i++)
			{
				if(ext[i]==m_executor) {m_executor_result=true;break;}
			}
		}
	}
	else
		m_executor_result=true;
	bool m_planned_dates_result=false;
	if(m_date_planned_begin==_T("") && m_date_planned_end==_T(""))
	{
		m_planned_dates_result=true;
	}
	else
	{
		CString planned_date_begin=_T("");
		CString planned_date_end=_T("");
		if(lock) 
		{
			m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_date_planned_begin,planned_date_begin);
			m_api->m_data.GetAttr(lock,m_project_mgr->a_project_adm_ver_date_planned_end,planned_date_end);
		}
		else
		{
			m_api->m_data.GetAttr(project,m_project_mgr->a_project_date_planned_begin,planned_date_begin);
			m_api->m_data.GetAttr(project,m_project_mgr->a_project_date_planned_end,planned_date_end);
		}
		bool begin_ok=false;
		if(m_date_planned_begin!=_T(""))
		{
			if((planned_date_begin>=m_date_planned_begin || planned_date_begin==_T(""))&&(planned_date_end>=m_date_planned_begin || planned_date_end==_T("")))
				begin_ok=true;
		}
		else
		{
			begin_ok=true;
		}
		bool end_ok=false;
		if(m_date_planned_end!=_T(""))
		{
			if((planned_date_end<=m_date_planned_end || planned_date_end==_T(""))&&(planned_date_begin<=m_date_planned_end || planned_date_begin==_T("")))
				end_ok=true;
		}
		else
		{
			end_ok=true;
		}
		if(begin_ok && end_ok) 
			m_planned_dates_result=true;
	}

	bool m_actual_dates_result=false;

	if(m_date_actual_begin==_T("") && m_date_actual_end==_T(""))
	{
		m_actual_dates_result=true;
	}
	else
	{
		CString actual_date_begin=_T("");
		CString actual_date_end=_T("");

		m_api->m_data.GetAttr(project,m_project_mgr->a_project_date_actual_begin,actual_date_begin);
		m_api->m_data.GetAttr(project,m_project_mgr->a_project_date_actual_end,actual_date_end);

		bool begin_ok=false;
		if(m_date_actual_begin!=_T(""))
		{
			if((actual_date_begin>=m_date_actual_begin || actual_date_begin==_T(""))&&(actual_date_end>=m_date_actual_begin || actual_date_end==_T("")))
				begin_ok=true;
		}
		else
		{
			begin_ok=true;
		}
		bool end_ok=false;
		if(m_date_actual_end!=_T(""))
		{
			if((actual_date_end<=m_date_actual_end || actual_date_end==_T(""))&&(actual_date_begin<=m_date_actual_end || actual_date_begin==_T("")))
				end_ok=true;
		}
		else
		{
			end_ok=true;
		}
		if(begin_ok && end_ok) 
			m_actual_dates_result=true;
	}

	if(m_states_result && m_types_result && m_number_result && m_prj_id_result && m_prj_name_result &&
		m_customer_result && m_kurator_result && m_executor_result && 
			m_planned_dates_result && m_actual_dates_result)  
		m_all_result=true;
	return m_all_result;
}

bool CFilterStruct::Initialize(CaplAPI *api, CaplProjectManager *project_mgr)
{
	if(!api || !project_mgr) return false;

	if(m_api!=api || m_project_mgr!=project_mgr ) {m_customer=0; m_kurator=0; m_executor=0;}

	m_api=api;
	m_project_mgr=project_mgr;
	m_bEnabled=false;
	return true;
}

bool CreateQuery(CString &query)
{

	return false;
}