// FilterStruct.h: interface for the CFilterStruct class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILTERSTRUCT_H__A7282E8E_736D_4F54_A29D_185B33950D42__INCLUDED_)
#define AFX_FILTERSTRUCT_H__A7282E8E_736D_4F54_A29D_185B33950D42__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "apl_api.h"
#include "aplProjectMgr.h"

#define APL_FILTER_ALL                 0x00000
#define APL_FILTER_ALL_EXPANDING       0x00001
#define APL_FILTER_ELEMENTS_EXPANDING  0x00002
#define APL_FILTER_TO_ROOT             0x00003
#define APL_RECURS_TO_ROOT_ALL         0x00004  //  

class CFilterStruct  
{
public:

	// 
	//bool bShowAdminVersion; //     ,  
	CStringArray m_states;
	aplExtent m_types;
	CaplInstance *m_customer;
	CaplInstance *m_kurator;
	CaplInstance *m_executor;
	bool m_filter_by_customer;
	bool m_filter_by_kurator;
	bool m_filter_by_executor;
	bool m_filter_out_of_time;
	CString m_date_planned_begin;
	CString m_date_planned_end;
	CString m_date_actual_begin;
	CString m_date_actual_end;
	CString m_number;
	CString m_id;
	CString m_name;
	long m_filter_type;

	CaplAPI *m_api;
	CaplProjectManager *m_project_mgr;

	bool m_bEnabled; //    ,       ,    .      .    .
	
	CFilterStruct();
	virtual ~CFilterStruct();
	bool FilterProject(CaplInstance *project);
	bool Initialize(CaplAPI *api,CaplProjectManager *project_mgr);
	bool CreateQuery(CString &query);

};

#endif // !defined(AFX_FILTERSTRUCT_H__A7282E8E_736D_4F54_A29D_185B33950D42__INCLUDED_)
