// GanttCtrl.h: interface for the CGanttCtrl class.
//
//////////////////////////////////////////////////////////////////////
#include "resource.h"
#include <apl_gui.h>
#include "apl_api.h"
#include "aplProjectMgr.h"

#pragma once


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#ifdef APL_PROGECT_MGR
#define APL_PM_CLASS_EXPORT		_declspec(dllexport)
#else
#define APL_PM_CLASS_EXPORT		_declspec(dllimport)
#endif

class CGanttView;

#define tItemsAplTAggt CaplTAggr <CGanttItem*,CGanttItem*,APLAGGR_LIST>

class APL_PM_CLASS_EXPORT CGanttItem
{
	public:
		CaplInstance *prj;
		CString id;
		CString name;
		COleDateTime pl_date_begin;
		COleDateTime pl_date_end;
		COleDateTime act_date_begin;
		COleDateTime act_date_end;
		COleDateTime act_date_begin_prognoz;
		COleDateTime act_date_end_prognoz;
		COLORREF color;
		double percentage;
		DWORD itemData;

		CaplInstance *instMyLock;

		//      
		HTREEITEM hTreeItem;
		int pos; //    (       )
		RECT rect_plan; //   
		int sub_items_count; //  item-   

		CaplInstance *prev_progn_prj;  //  ,      
		CGanttItem   *prev_progn_item; // ,       . (  prev_prj_from_prognoz    CGanttCtrl::UpdateRelations())

		CaplInstance *first_progn_sub_prj;  //   
		CGanttItem   *first_progn_sub_item;
		CaplInstance *last_progn_sub_prj;   //   
		CGanttItem   *last_progn_sub_item;

	public:
		CGanttItem();
};

class APL_PM_CLASS_EXPORT CGanttItemRel
{
public:
	CGanttItem *prev;
	CGanttItem *next;
};



	#define APL_MODE_OPEN      0x00000
	#define APL_MODE_EDIT      0x00001
	#define APL_MODE_PRINT     0x00002
	#define APL_MODE_SAVE      0x00003

	#define APL_MODE_YEARS      0x00000
	#define APL_MODE_MONTHS     0x00001
	#define APL_MODE_WEEKS      0x00002

class APL_PM_CLASS_EXPORT CGanttCtrl : public CWnd 
{
public:
	int m_nOffset;
	//CArray<CGanttItem,CGanttItem> m_items;
	CArray<CGanttItemRel,CGanttItemRel> m_items_rels;

	CGanttView *m_gantt_view;

	tItemsAplTAggt m_visible_items;

	bool m_bShowVerLiles;
	int m_blockHeight;
	int m_headerHeight;
	int m_project_id_width;
	CaplAPI *m_api;
	CaplProjectManager *m_project_mgr;
	CaplResizableDialog *m_dlg;
	CaplToolTip m_ToolTip;
	CFont m_pFont;
//	CBitmap m_pattern_bmp;
	int m_view_mode;
	int m_max_id_length;
	bool m_bShowRelations;

	//  drag&drop
	CGanttItem *m_grag_item;
	int m_grag_item_mode; //-1 -    +1 -    0 - 
	POINT m_first_drag_point, m_last_drag_point;
	HCURSOR m_hCursor;
	bool bIsLine; //   
	bool bIsRect; //   
	RECT m_prevRect;

public:
	CGanttCtrl();
	virtual ~CGanttCtrl();

	bool SetPixelsInDay(int pixelsInDay);
	int GetPixelsInDay(){ return m_pixelsInDay; };

	int GetDlitDays(COleDateTime &date_begin, COleDateTime& date_end);
	//int GetFirstDays(COleDateTime &date_begin);

	int Date2Pos(COleDateTime &date_begin);
	//-int InsertItem(CGanttItem &new_item);
	bool PointToVal(CPoint *point, CGanttItem **gItem,HTREEITEM &hItem,CaplInstance **inst, bool bFullRow=true);
	
	//-void RemoveAllItems();
	void UpdateCalendar(bool resetScrollBar=true);
	void ResetVertScrollBar();
	int GetColumnsWidth() { return m_nColumnsWidth; };
	void RecalcColumnsWidth();
	void AutoResizeDiagram(bool bReduce=false,bool bInvalidate=true);

	
	void GetMaxDate(COleDateTime &odt){odt=m_max_date;};
	void GetMinDate(COleDateTime &odt){odt=m_min_date;};

	//-CGanttItem* FindItem(HTREEITEM hItem);
	bool ExportDiagramBmp(CString &bmp_f_name);
	bool Paint2DC(CDC &memDC, CBitmap &bm);

	void UpdateRelations();
	void HideToolTip();

	void GetAllSubItems(HTREEITEM hItem, tItemsAplTAggt &items);
	void RenumGanttItems(HTREEITEM hItem, int &counter);

protected:
	void PaintDiagram(CDC &dc,long mode);
	void PaintCalendar(CDC &dc,long mode);
	void CheckSetPixelsInDay(int pixelsInDay);
	void GetActualRect(CGanttItem &item,CRect &rect,int top,int height,int *xPosPrognoz=0);
	int m_pixelsInDay;

	int m_col_days;
	//COleDateTime m_max_dt;
	//COleDateTime m_min_dt;
	COleDateTime m_min_date;
	COleDateTime m_max_date;
	int m_nColumnsWidth;

protected:
	void CalcMaxMinDates();
	void DisplayToolTip(CPoint point,CGanttItem &gItem);
	LRESULT OnMouseLeave(WPARAM wParam, LPARAM lParam);
	/*      
	  @param   
  		  APL_MODE_EDIT -   
		  APL_MODE_PRINT -     */
	//{{AFX_MSG(CaplTreeListCtrl)
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point); 
	afx_msg void OnMouseMove(UINT nFlags, CPoint point); 
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
};


