// Transaction.cpp: implementation of the CaplProjectManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplProjectMgr.h"
#include <apl_api.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
bool CaplProjectManager::CTransaction::Load(CaplProjectManager *pProjectMgr, CaplInstance* inst, CaplInstance *project)
{
	if(inst==NULL || pProjectMgr==NULL) return false;
	if(!pProjectMgr->m_api->m_data.IsDictLoad()) return false;

	m_inst= inst;
	m_project = project;

	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_id, m_sId);
	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_name, m_sName);
	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_descr, m_sDescr);
	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_date, m_sDate);
	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_type, m_sType);
	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_summ, m_dSumm);
	pProjectMgr->m_api->m_data.GetAttr(m_inst, pProjectMgr->a_money_transaction_nds, m_dNDS);

	pProjectMgr->m_api->m_data.GetAttr(m_project, pProjectMgr->a_project_id, m_sProjectId);
	pProjectMgr->m_api->m_data.GetAttr(m_project, pProjectMgr->a_project_name, m_sProjectName);

	return true;
}
