// TransactionListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TransactionListDlg.h"
#include "TransactionDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTransactionListDlg dialog


CTransactionListDlg::CTransactionListDlg(CaplProjectManager *pProjectMgr, CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CTransactionListDlg::IDD, pParent)
{
	ASSERT(pProjectMgr);
	m_pProjectMgr = pProjectMgr;
	m_api = pProjectMgr->m_api;

	//{{AFX_DATA_INIT(CTransactionListDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_inst = NULL;
}


void CTransactionListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTransactionListDlg)
	DDX_Control(pDX, IDC_EDIT, m_edit_btn);
	DDX_Control(pDX, IDC_DEL, m_del_btn);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_LIST, m_TransactionsListCtrl);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_ADD2, m_Add2Btn);
}


BEGIN_MESSAGE_MAP(CTransactionListDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CTransactionListDlg)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	ON_BN_CLICKED(IDC_REPORT, OnReport)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_ADD2, &CTransactionListDlg::OnBnClickedAdd2)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTransactionListDlg message handlers

BOOL CTransactionListDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	if(0==m_inst) return FALSE;
	if(m_inst->GetAccessmode()>aplRO) return FALSE;

	if(m_api->m_data.IsKindOf(m_inst,m_pProjectMgr->e_project_adm_ver))
	{
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_project_adm_ver_project, m_inst);
		if(m_inst==NULL) return FALSE;
		if(m_inst->GetAccessmode()>aplRO) return FALSE;
	}


	AddAnchor(IDC_LIST, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDC_ADD, TOP_RIGHT);
	AddAnchor(IDC_DEL, TOP_RIGHT);
	AddAnchor(IDC_EDIT, TOP_RIGHT);
	AddAnchor(IDC_REPORT, BOTTOM_LEFT);

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_add_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_Add2Btn.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	//m_add_btn.SetWindowText(_T(""));
	m_del_btn.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	//m_del_btn.SetWindowText(_T(""));
	m_edit_btn.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	//m_edit_btn.SetWindowText(_T(""));

	if(m_pProjectMgr->m_role_to_edit_fact==_T(""))
	{
		if(m_inst->GetAccessmode()>aplRW )
		{
			m_add_btn.EnableWindow(FALSE);
			m_del_btn.EnableWindow(FALSE);
			m_Add2Btn.EnableWindow(FALSE);
		}
	}
	else
	{
		if(!(m_inst->GetAccessmode()<=aplRW || m_pProjectMgr->m_has_role_edit_fact))
		{
			m_add_btn.EnableWindow(FALSE);
			m_del_btn.EnableWindow(FALSE);
			m_Add2Btn.EnableWindow(FALSE);
		}
	}

	
	// 
	CRect cl_rect;
	m_TransactionsListCtrl.GetClientRect(&cl_rect);
	cl_rect.right-=::GetSystemMetrics(SM_CXVSCROLL)+1;

	m_TransactionsListCtrl.InsertColumn(0, APL_T("ID "), LVCFMT_LEFT, (int)(cl_rect.Width()*0.2));
	m_TransactionsListCtrl.InsertColumn(1, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.4));
	m_TransactionsListCtrl.InsertColumn(2, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.1));
	m_TransactionsListCtrl.InsertColumn(3, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.1));
	m_TransactionsListCtrl.InsertColumn(4, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.2));

	m_TransactionsListCtrl.SetColumnNumeric(4);
	m_TransactionsListCtrl.SetColumnDate(3);



	int i, ind;
	aplExtent ext;
	double dVal;
	COleDateTime time;
	CString sId, sName, sType, sDate, sSumm;
	m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_project_transactions, ext);
	m_pProjectMgr->LoadTransactionsInfo(ext);

	for(i=0; i<ext.Size; i++)
	{
		m_api->m_data.GetAttr(ext[i], m_pProjectMgr->a_money_transaction_id, sId);
		m_api->m_data.GetAttr(ext[i], m_pProjectMgr->a_money_transaction_name, sName);
		m_api->m_data.GetAttr(ext[i], m_pProjectMgr->a_money_transaction_type, sType);
		m_api->m_data.GetAttr(ext[i], m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.GetAttr(ext[i], m_pProjectMgr->a_money_transaction_summ, dVal);

		sSumm.Format(_T("%.2f"), dVal);
		aplString2Date(sDate, time);

		ind =	m_TransactionsListCtrl.InsertItem(m_TransactionsListCtrl.GetItemCount(), sId);
				m_TransactionsListCtrl.SetItemText(ind, 1, sName);
				m_TransactionsListCtrl.SetItemText(ind, 2, sType);
				m_TransactionsListCtrl.SetItemText(ind, 3, time.Format(VAR_DATEVALUEONLY));
				aplFormatNumericString(sSumm);
				m_TransactionsListCtrl.SetItemText(ind, 4, sSumm);
				m_TransactionsListCtrl.SetItemData(ind, (DWORD)ext[i]);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTransactionListDlg::OnEdit() 
{
	int ind;
	ind = m_TransactionsListCtrl.GetNextItem(-1, LVNI_SELECTED);
	if(ind<0) return;

	CaplInstance *inst = (CaplInstance*)m_TransactionsListCtrl.GetItemData(ind);
	if(inst==NULL) return;

	CTransactionDlg dlg(m_pProjectMgr, this);
	dlg.m_project = m_inst;
	dlg.m_inst = inst;
	if(dlg.DoModal()==IDOK)
	{
		double dVal;
		COleDateTime time;
		CString sId, sName, sType, sDate, sSumm;
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_id, sId);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_name, sName);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_type, sType);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_summ, dVal);
		
		sSumm.Format(_T("%.2f"), dVal);
		aplString2Date(sDate, time);
		
		m_TransactionsListCtrl.SetItemText(ind, 0, sId);
		m_TransactionsListCtrl.SetItemText(ind, 1, sName);
		m_TransactionsListCtrl.SetItemText(ind, 2, sType);
		m_TransactionsListCtrl.SetItemText(ind, 3, time.Format(VAR_DATEVALUEONLY));
		aplFormatNumericString(sSumm);
		m_TransactionsListCtrl.SetItemText(ind, 4, sSumm);
		m_TransactionsListCtrl.SetItemData(ind, (DWORD)dlg.m_inst);
	}
}

void CTransactionListDlg::OnAdd() 
{
	CTransactionDlg dlg(m_pProjectMgr, this);
	dlg.m_project = m_inst;
	if(dlg.DoModal()==IDOK)
	{
		int ind;
		double dVal;
		COleDateTime time;
		CString sId, sName, sType, sDate, sSumm;
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_id, sId);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_name, sName);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_type, sType);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_summ, dVal);
		
		sSumm.Format(_T("%.2f"), dVal);
		aplString2Date(sDate, time);
		
		ind =	m_TransactionsListCtrl.InsertItem(m_TransactionsListCtrl.GetItemCount(), sId);
				m_TransactionsListCtrl.SetItemText(ind, 1, sName);
				m_TransactionsListCtrl.SetItemText(ind, 2, sType);
				m_TransactionsListCtrl.SetItemText(ind, 3, time.Format(VAR_DATEVALUEONLY));
				aplFormatNumericString(sSumm);
				m_TransactionsListCtrl.SetItemText(ind, 4, sSumm);
				m_TransactionsListCtrl.SetItemData(ind, (DWORD)dlg.m_inst);
	}
}

void CTransactionListDlg::OnBnClickedAdd2()
{
	LPCTSTR sNotSel=APL_T("  ! (       .)");
	int ind;
	ind = m_TransactionsListCtrl.GetNextItem(-1, LVNI_SELECTED);
	if(ind<0)
	{
		AfxMessageBox(sNotSel);
		return;
	}

	CaplInstance *inst = (CaplInstance*)m_TransactionsListCtrl.GetItemData(ind);
	if(inst==NULL) 
	{
		AfxMessageBox(sNotSel);
		return;
	}

	CTransactionDlg dlg(m_pProjectMgr, this);
	dlg.m_project = m_inst;
	dlg.m_inst = 0;
	dlg.m_base_inst = inst;

	if(dlg.DoModal()==IDOK)
	{
		int ind;
		double dVal;
		COleDateTime time;
		CString sId, sName, sType, sDate, sSumm;
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_id, sId);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_name, sName);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_type, sType);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.GetAttr(dlg.m_inst, m_pProjectMgr->a_money_transaction_summ, dVal);
		
		sSumm.Format(_T("%.2f"), dVal);
		aplString2Date(sDate, time);
		
		ind =	m_TransactionsListCtrl.InsertItem(m_TransactionsListCtrl.GetItemCount(), sId);
				m_TransactionsListCtrl.SetItemText(ind, 1, sName);
				m_TransactionsListCtrl.SetItemText(ind, 2, sType);
				m_TransactionsListCtrl.SetItemText(ind, 3, time.Format(VAR_DATEVALUEONLY));
				aplFormatNumericString(sSumm);
				m_TransactionsListCtrl.SetItemText(ind, 4, sSumm);
				m_TransactionsListCtrl.SetItemData(ind, (DWORD)dlg.m_inst);
	}
}

void CTransactionListDlg::OnDel() 
{
	int ind;
	ind = m_TransactionsListCtrl.GetNextItem(-1, LVNI_SELECTED);
	if(ind<0) return;
	
	CaplInstance *inst = (CaplInstance*)m_TransactionsListCtrl.GetItemData(ind);
	if(inst==NULL) return;


	if(m_pProjectMgr->m_role_to_edit_fact==_T(""))
	{
		if( m_inst->GetAccessmode()>aplRW)
		{
			AfxMessageBox(APL_T("      !"),MB_OK|MB_ICONSTOP);
			return;
		}
	}
	else
	{
		CString sType;
		m_api->m_data.GetAttr(inst, m_pProjectMgr->a_money_transaction_type, sType);

		if(sType==APL_T(""))
		{
			if(!m_pProjectMgr->m_has_role_edit_fact)
			{
				AfxMessageBox(APL_T("        !"),MB_OK|MB_ICONSTOP);
				return;
			}
		}
		else
		{
			if( m_inst->GetAccessmode()>aplRW)
			{
				AfxMessageBox(APL_T("      !"),MB_OK|MB_ICONSTOP);
				return;
			}
		}
	}


	if(AfxMessageBox(APL_T("  ?"), MB_YESNO|MB_ICONQUESTION)!=IDYES) return;

	if(m_pProjectMgr->DeleteTransaction(m_inst, inst))
	{
		m_TransactionsListCtrl.DeleteItem(ind);
		if(ind>=m_TransactionsListCtrl.GetItemCount()) ind = m_TransactionsListCtrl.GetItemCount()-1;
		m_TransactionsListCtrl.SetItemState(ind, LVIS_SELECTED|LVIS_FOCUSED, LVIS_SELECTED|LVIS_FOCUSED);
	}
}

void CTransactionListDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CaplResizableDialog::OnOK();
}

void CTransactionListDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnEdit();
	
	*pResult = 0;
}

void CTransactionListDlg::OnReport() 
{
	CaplProjectManager::STransactionFilter Filter;
	if(m_pProjectMgr->SelectTransactionFilter(Filter))
	m_pProjectMgr->ReportTransactions(m_inst, Filter);
}


