// TransactionsReportList.cpp : implementation file
//

#include "stdafx.h"
#include "TransactionsReportList.h"
#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTransactionsReportList dialog


CTransactionsReportList::CTransactionsReportList(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CTransactionsReportList::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTransactionsReportList)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_AllTransactions=0;
	m_FilteredTransactions=0;

	m_prj_mgr=0;
}


void CTransactionsReportList::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTransactionsReportList)
	DDX_Control(pDX, IDC_SAVE_TO_FILE, m_save_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_LIST, m_TransactionsListCtrl);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_SUMLIST, m_sumlist);
	DDX_Control(pDX, IDC_FILTER, m_FilterBtn);
}


BEGIN_MESSAGE_MAP(CTransactionsReportList, CaplResizableDialog)
	//{{AFX_MSG_MAP(CTransactionsReportList)
	ON_BN_CLICKED(IDC_FILTER, OnFilter)
	ON_BN_CLICKED(IDC_SAVE_TO_FILE, OnSaveToFile)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, OnItemchangedList)
	//}}AFX_MSG_MAP
	ON_WM_SIZE()
//	ON_NOTIFY(HDN_ENDFILTEREDIT, 0, &CTransactionsReportList::OnHdnEndFilterEditSumlist)
//	ON_NOTIFY(LVN_ITEMCHANGED, IDC_SUMLIST, &CTransactionsReportList::OnLvnItemchangedSumlist)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTransactionsReportList message handlers

BOOL CTransactionsReportList::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	AddAnchor(IDC_LIST, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_SUMLIST, BOTTOM_LEFT, BOTTOM_RIGHT);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDC_FILTER,BOTTOM_LEFT);
	AddAnchor(IDC_SAVE_TO_FILE,BOTTOM_LEFT);

	AddAnchor(IDC_STATIC_H1,BOTTOM_LEFT);
	AddAnchor(IDC_STATIC_H2,BOTTOM_LEFT);

	/*AddAnchor(IDC_STATIC_SUM_PLANE,BOTTOM_LEFT);
	AddAnchor(IDC_STATIC_SUM_FAKT,BOTTOM_LEFT);
	AddAnchor(IDC_STATIC_SUM_ALL,BOTTOM_LEFT);
	AddAnchor(IDC_STATIC_SUM_SEL,BOTTOM_LEFT);
	AddAnchor(IDC_STATIC_SUM_SPRAV,BOTTOM_LEFT);

	AddAnchor(IDC_SUM_PLANE,BOTTOM_LEFT);
	AddAnchor(IDC_SUM_FAKT,BOTTOM_LEFT);
	AddAnchor(IDC_SUM_PLANE_ALL,BOTTOM_LEFT);
	AddAnchor(IDC_SUM_FAKT_ALL,BOTTOM_LEFT);
	AddAnchor(IDC_SUM_SPRAV,BOTTOM_LEFT);
	AddAnchor(IDC_SUM_SPRAV_ALL,BOTTOM_LEFT);*/


	
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_ok_btn.SetFlat(FALSE);

	m_save_btn.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_save_btn.SetFlat(FALSE);

	m_FilterBtn.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_FilterBtn.SetFlat(FALSE);


	CRect cl_rect;
	m_TransactionsListCtrl.GetClientRect(&cl_rect);
	cl_rect.right-=::GetSystemMetrics(SM_CXVSCROLL)+1;
	
	m_TransactionsListCtrl.InsertColumn(0, APL_T(" "), LVCFMT_LEFT, (int)(cl_rect.Width()*0.1));
	m_TransactionsListCtrl.InsertColumn(1, APL_T(" "), LVCFMT_LEFT, (int)(cl_rect.Width()*0.2));
	m_TransactionsListCtrl.InsertColumn(2, APL_T("ID "), LVCFMT_LEFT, (int)(cl_rect.Width()*0.1));
	m_TransactionsListCtrl.InsertColumn(3, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.3));
	m_TransactionsListCtrl.InsertColumn(4, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.07));
	m_TransactionsListCtrl.InsertColumn(5, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.1));
	m_TransactionsListCtrl.InsertColumn(6, APL_T(""), LVCFMT_RIGHT, (int)(cl_rect.Width()*0.13));
	
	m_TransactionsListCtrl.SetColumnNumeric(6);
	m_TransactionsListCtrl.SetColumnDate(5);

	if(m_AllTransactions==NULL || m_FilteredTransactions==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	m_sumlist.InsertColumn(0, _T(""), LVCFMT_LEFT, 100);
	m_sumlist.InsertColumn(1, APL_T(".  ()"), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(2, APL_T(".  ()"), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(3, APL_T(" ()"), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(4, APL_T(" ()"), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(5, APL_T(" ()"), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(6, APL_T(" ()"), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(7, APL_T(" "), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(8, APL_T(" "), LVCFMT_RIGHT, 120);
	m_sumlist.InsertColumn(9, APL_T(" ( )"), LVCFMT_RIGHT, 120);

	int i,count=m_sumlist.GetHeaderCtrl()->GetItemCount()-1;
	RECT rect;
	m_sumlist.GetHeaderCtrl()->GetClientRect(&rect);
	int width=(rect.right-rect.left-100)/count;
	for(i=1;i<=count;i++) m_sumlist.CListCtrl::SetColumnWidth(i,width);
	m_sumlist.InsertItem(0, APL_T(":"));
	m_sumlist.InsertItem(1, APL_T(":"));


	UpdateList();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}


void CTransactionsReportList::UpdateList()
{
	m_TransactionsListCtrl.DeleteAllItems();

	int i, ind;
	COleDateTime time;
	CString sSumm;
	
	double sum_plus_plan=0, sum_minus_plan=0, sum_plus_fakt=0, sum_minus_fakt=0, sum_sprav=0;
	
	for(i=0; i<m_FilteredTransactions->GetSize(); i++)
	{
		CaplProjectManager::CTransaction *trs=m_FilteredTransactions->GetAt(i);

		ind =	m_TransactionsListCtrl.InsertItem(m_TransactionsListCtrl.GetItemCount(), trs->m_sProjectId);

			    m_TransactionsListCtrl.SetItemData(ind,(long)trs);
				m_TransactionsListCtrl.SetItemText(ind, 1, trs->m_sProjectName);
				m_TransactionsListCtrl.SetItemText(ind, 2, trs->m_sId);
				m_TransactionsListCtrl.SetItemText(ind, 3, trs->m_sName);
				m_TransactionsListCtrl.SetItemText(ind, 4, trs->m_sType);
				aplString2Date(trs->m_sDate, time);
				m_TransactionsListCtrl.SetItemText(ind, 5, time.Format(VAR_DATEVALUEONLY));
				sSumm.Format(_T("%.2f"), trs->m_dSumm);
				aplFormatNumericString(sSumm);
				m_TransactionsListCtrl.SetItemText(ind, 6, sSumm);

				if(trs->m_sType==APL_T(""))
				{
					if(trs->m_dSumm>0) sum_plus_fakt+=trs->m_dSumm;
					else sum_minus_fakt+=trs->m_dSumm;
				}
				else if(trs->m_sType==APL_T(""))
				{
					if(trs->m_dSumm>0) sum_plus_plan+=trs->m_dSumm;
					else sum_minus_plan+=trs->m_dSumm;					
				}
				else sum_sprav+=trs->m_dSumm;
	}

	int k=1;
	//
	sSumm.Format(_T("%.2f"), sum_plus_plan+sum_minus_plan);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,1,sSumm);
	sSumm.Format(_T("%.2f"), sum_plus_fakt+sum_minus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,2,sSumm);
	
	//
	sSumm.Format(_T("%.2f"), sum_plus_plan);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,3,sSumm);
	sSumm.Format(_T("%.2f"), sum_plus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,4,sSumm);
	
	//
	sSumm.Format(_T("%.2f"), sum_minus_plan);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,5,sSumm);
	sSumm.Format(_T("%.2f"), sum_minus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,6,sSumm);

	//
	sSumm.Format(_T("%.2f"), sum_plus_plan-sum_plus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,7,sSumm);
	sSumm.Format(_T("%.2f"), -(sum_minus_plan-sum_minus_fakt));aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,8,sSumm);	

	// 
	sSumm.Format(_T("%.2f"), sum_sprav); aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,9,sSumm);

	CalcSelected();
}


void CTransactionsReportList::CalcSelected()
{
	double sum_plus_plan=0, sum_minus_plan=0, sum_plus_fakt=0, sum_minus_fakt=0, sum_sprav=0;

	int nItem= m_TransactionsListCtrl.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	while( nItem!= -1){
		
		CaplProjectManager::CTransaction *trs=(CaplProjectManager::CTransaction *)m_TransactionsListCtrl.GetItemData(nItem);
		if(trs!=0)
		{
				if(trs->m_sType==APL_T(""))
				{
					if(trs->m_dSumm>0) sum_plus_fakt+=trs->m_dSumm;
					else sum_minus_fakt+=trs->m_dSumm;
				}
				else if(trs->m_sType==APL_T(""))
				{
					if(trs->m_dSumm>0) sum_plus_plan+=trs->m_dSumm;
					else sum_minus_plan+=trs->m_dSumm;					
				}
				else sum_sprav+=trs->m_dSumm;
		}
		nItem= m_TransactionsListCtrl.GetNextItem( nItem , LVNI_ALL | LVNI_SELECTED );
	}

	CString sSumm;
	int k=0;
	//
	sSumm.Format(_T("%.2f"), sum_plus_plan+sum_minus_plan);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,1,sSumm);
	sSumm.Format(_T("%.2f"), sum_plus_fakt+sum_minus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,2,sSumm);
	
	//
	sSumm.Format(_T("%.2f"), sum_plus_plan);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,3,sSumm);
	sSumm.Format(_T("%.2f"), sum_plus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,4,sSumm);
	
	//
	sSumm.Format(_T("%.2f"), sum_minus_plan);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,5,sSumm);
	sSumm.Format(_T("%.2f"), sum_minus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,6,sSumm);

	//
	if(sum_plus_plan-sum_plus_fakt==0)sSumm=_T("0.00");
	else sSumm.Format(_T("%.2f"), sum_plus_plan-sum_plus_fakt);aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,7,sSumm);
	if(sum_minus_plan-sum_minus_fakt==0)sSumm=_T("0.00");
	else sSumm.Format(_T("%.2f"), -(sum_minus_plan-sum_minus_fakt));aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,8,sSumm);	

	// 
	sSumm.Format(_T("%.2f"), sum_sprav); aplFormatNumericString(sSumm);
	m_sumlist.SetItemText(k,9,sSumm);
}

void CTransactionsReportList::OnFilter() 
{
	if(m_prj_mgr==0) return;
	if(!m_prj_mgr->SelectTransactionFilter(m_Filter)) return;
	m_prj_mgr->FilterTransactions(*m_AllTransactions,*m_FilteredTransactions,m_Filter);

	UpdateList();
}

void CTransactionsReportList::OnSaveToFile() 
{
	apl_SaveListCtrlToFile(&m_TransactionsListCtrl,_T(""));
}


void CTransactionsReportList::OnItemchangedList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	HD_NOTIFY *phdn = (HD_NOTIFY *) pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;

	if(phdn->pitem!=0) CalcSelected();
}

void CTransactionsReportList::OnSize(UINT nType, int cx, int cy)
{
	CaplResizableDialog::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
	if(cx>100 && m_sumlist.m_hWnd!=0)
	{
		int i,count=m_sumlist.GetHeaderCtrl()->GetItemCount()-1;
		RECT rect;
		m_sumlist.GetHeaderCtrl()->GetClientRect(&rect);
		int width=(rect.right-rect.left-100)/count;
		for(i=1;i<=count;i++) m_sumlist.CListCtrl::SetColumnWidth(i,width);
	}
}

