// aplProjectMgr.h: interface for the CaplProjectManager class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "aplStepManager.h"


#ifndef APL_RRJ_MGR_NOAUTOLIB
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"aplProjectManager_ud.lib")
#else
#pragma comment (lib,"aplProjectManagerD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"aplProjectManager_u.lib")
#else
#pragma comment (lib,"aplProjectManager.lib")
#endif
#endif
#endif


#ifdef APL_PROGECT_MGR
#define APL_PM_CLASS_EXPORT		_declspec(dllexport)
#else
#define APL_PM_CLASS_EXPORT		_declspec(dllimport)
#endif


bool AFX_EXT_API isAggrChanged(CaplAggr &aggr,CaplAggr &aggr1);
bool AFX_EXT_API isExtentChanged(aplExtent &ext,aplExtent &ext1);

class CaplProjectManager;

class APL_PM_CLASS_EXPORT CaplProjectManager : public CaplPreProjectManager 
{
public:
	class APL_PM_CLASS_EXPORT CTransaction
	{
	public:
		CaplInstance	*m_inst;
		CaplInstance	*m_project;
		
		CString	m_sId;
		CString	m_sName;
		CString	m_sDescr;
		CString	m_sType;
		CString	m_sDate;
		double	m_dSumm;
		double	m_dNDS;

		CString	m_sProjectId;
		CString	m_sProjectName;

		CTransaction()
		{
			m_dSumm = 0;
			m_dNDS=0;
			m_inst = NULL;
			m_project=0;
		};
		
		CTransaction(CTransaction *trs)
		{
			if(trs!=0)
			{
				m_sId=trs->m_sId;
				m_sName=trs->m_sName;
				m_sDescr=trs->m_sDescr;
				m_sType=trs->m_sType;
				m_sDate=trs->m_sDate;
				m_dSumm=trs->m_dSumm;
				m_dNDS=trs->m_dNDS;

				m_sProjectId=trs->m_sProjectId;
				m_sProjectName=trs->m_sProjectName;

				m_inst =trs->m_inst;
				m_project=trs->m_project;
			}
		};
		CTransaction(CaplProjectManager *pProjectMgr, CaplInstance* inst, CaplInstance *project)
		{
			Load(pProjectMgr, inst, project);
		};


		virtual ~CTransaction(){};

		bool Load(CaplProjectManager *pProjectMgr, CaplInstance* inst, CaplInstance *project);
	};

	struct STransactionFilter
	{
		STransactionFilter()
		{
			bShowFact = true;
			bShowPlan = true;
			bShowFHelp = true;

			sDateMax.Empty();
			sDateMin.Empty();
		};

		bool	bShowFact;
		bool	bShowPlan;
		bool	bShowFHelp;

		CString sDateMin;
		CString sDateMax;
	};

	class CPrjPrognozItem
	{
	public:
		CaplInstance *prj;
		COleDateTime prognoz_begin;
		COleDateTime prognoz_end;
		CaplInstance *prev_progn_prj;
		CaplInstance *first_progn_sub_prj;
		CaplInstance *last_progn_sub_prj;

		CPrjPrognozItem(){prj=0; prev_progn_prj=0; first_progn_sub_prj=0; last_progn_sub_prj=0;};
		CPrjPrognozItem(CaplInstance *inst_prj, COleDateTime &end_odt){prj=inst_prj; prev_progn_prj=0; prognoz_end=end_odt;first_progn_sub_prj=0; last_progn_sub_prj=0;};
	};

	CaplProjectManager();
	virtual ~CaplProjectManager();
	CStringArray	m_saMoneyTransactionTypes;

	static bool m_bShowId;
	static bool m_bShowName;
	static bool m_bRecursive;
	CString m_role_to_edit_fact; //       
	bool m_has_role_edit_fact;
	//static bool m_bShowMessages;

	static COLORREF  RGB_DEFAULT;
	static COLORREF  RGB_POFIG;
	static COLORREF  RGB_ENDED;
	static COLORREF  RGB_NOTSTART_OVERDUE;
	static COLORREF  RGB_NOTSTART_NO_OVERDUE;
	static COLORREF  RGB_WORK_GOOD_PROGN;
	static COLORREF  RGB_WORK_BAD_PROGN;
	static COLORREF  RGB_WORK_OVERDUE;


	
	CaplInstance *FindProjectTypeBN(LPCTSTR name,bool bLoadFromBase=false); //   
	CaplInstance *CreateProjectType(LPCTSTR name);							//   			

	void GetIdPersOrOrg(CaplInstance *item, CString &id); //        ..


	virtual CaplInstance *CreateProject(CaplInstance *base_project=0,LPCTSTR id=0,bool add_to_contents=true,CaplInstance *item=0,CaplInstance **rel=0);
	
	bool DeleteProject(CaplInstance *project,bool delete_sub_projects=true,bool delete_associated_projects=true,bool recalc_parent_labor=true);
		
	virtual bool ShowProjectProperties(CaplInstance *project,bool b_read_only=false); //   
	
	bool IsProjectIdUnique(LPCTSTR id,CaplInstance *project=0,bool bShowMessage=true); //    

	CaplInstance *FindProjectById(LPCTSTR id,bool bLoadFromBase=false);  //    
	CaplInstance *FindProjectBN(LPCTSTR name,bool bLoadFromBase=false);        //     ( )

	//     ext_prj ,       ext_po 
	//    ( bCustomer==true)     ( bKurator==true)    ( bExecutor==true) 
	//   bLoadFromBase==true -      
	bool FindProject(aplExtent &ext_po, bool bCustomer, bool bKurator, bool bExecutor, LPCTSTR sState, aplExtent &ext_prj,bool bLoadFromBase=false);        //     ( )



	//*************************************************************
	//******     () *********************
	//*************************************************************

	///   
	bool GetAllSubProject(CaplInstance *project,aplExtent &ext_out,bool recursive=false,bool include_associated=false, bool from_base=true);
	virtual void GetAllSubProject(aplExtent &project_ext,aplExtent &ext_out,bool recursive=false,bool include_associated=false, bool from_base=true);

	/*      nlevel  
	 nlevel==0 -     project_ext   */
	bool LoadAllSubProjectNlevel(aplExtent &project_ext,aplExtent &ext_out,int nlevel);

	//    
	bool LoadSubProjects(CaplInstance *project,aplExtent &ext_out);

	//  ,     project
	bool WhereUsedProject(CaplInstance *project,aplExtent &ext_out);
	
	///    
	bool AddToParentContent(CaplInstance *project,CaplInstance *parent_project);

	///    
	bool RemoveFromParentContent(CaplInstance *project,CaplInstance *parent_project);

	///        
	bool RemoveProjectFromParent(CaplInstance *project,CaplInstance *parent_project);

	/*  
	@param project 
	@param parent_project  
	@param add_to_content      ()   
	@param remove_from_old_content      
	@param make_main_parent         " " (          )
	@return true     false    */
	virtual bool InsertProjectIntoParent(CaplInstance *project,CaplInstance *parent_project,bool add_to_content=false,bool remove_from_old_content=true,bool make_main_parent=false);
	
	///    
	bool IsProjectHaveChildren(CaplInstance *project,bool include_associated=false);


	//*************************************************************
	//******    ********************************
	//*************************************************************

	CaplInstance* CreateProjectSequence(CaplInstance *prev_prj, CaplInstance *next_prj); //    


	//*************************************************************
	//******    ******************************************
	//*************************************************************

	/*  
	@param project 
	@param new_state ,   
	@param recursive     
	@return true     false    */
	bool ChangeProjectState(CaplInstance *project,LPCTSTR new_state,bool recursive,COleDateTimeSpan &span);

	/*        (  -)
	@param project 
	@return true     false    */
	bool UpdateProjectState(CaplInstance *project);


	//*************************************************************************
	//******     ******************************************
	//*************************************************************************

	/*     
	@param inst   .
	@param attr       (actual_end  actual_end2
	@return ,   .*/
	CString GetProjectActualDate(CaplInstance *inst=NULL, CaplAttr *attr=NULL);
	
	/*        (  -)
	@param project 
	@return true     false    */
	bool RecalcProjectLabor(CaplInstance *project,bool recursive=true,bool load_prj_info=true);
	bool RecalcParentDates(CaplInstance *project, bool recursive=true,bool load_prj_info=true);

	//       
	bool GetWorkedProjectEndPrognoz(CaplInstance *prj, COleDateTime &date_end_prognoz);


	/*typedef CArray <COleDateTime, COleDateTime&> apl_COleDateTime_array;
	//       
	bool GetProjectsEndPrognoz(aplExtent &ext_prj, apl_COleDateTime_array &prognoz_dates, aplExtent &ext_prev_prognoz);

	bool GetProjectsEndPrognoz4Recursive(CaplInstance *prj, aplExtent &ext_prj, apl_COleDateTime_array &prognoz_dates, CaplAggrMap &prev_prj_aggr_map, COleDateTime &result_dt, aplExtent &ext_prev_prognoz);*/

	typedef CaplTAggr <CPrjPrognozItem*,CPrjPrognozItem*,APLAGGR_LIST|APLAGGR_AUTOKILLREF> apl_CPrjPrognozItem_array;

	bool CalcProjectsEndPrognoz(aplExtent &ext, CaplMap &map_prj_index, apl_CPrjPrognozItem_array &_array_progn_items, bool bLoadFrobDB);
	CPrjPrognozItem *CalcProjectEndPrognoz(CaplInstance *prj, COleDateTime &prjEndPrognoz, CaplMap &map_prj_index, apl_CPrjPrognozItem_array &_array_progn_items, bool bLoadFrobDB);


	//      (     )
	bool GetProjectColor(CaplInstance *prj, COleDateTime &endPrognozDate, COLORREF &color);

	//      
	static void ShowColorLegend();

	//*************************************************************************
	//******           ******************************************
	//*************************************************************************
	
	/**      
		@param project 
		@param outExt     ()
		@return true     false    */
	bool GetAllProjectVersion(CaplInstance *project,aplExtent &outExt);
	/**     
		@param project      */
	bool CheckOut( CaplInstance *project,bool recursive=false);
	/**     c   
		@param project      
		@param recursive       */
	bool CheckOutWithRequest( CaplInstance *project,bool &recursive=m_bRecursive);

	/**      
		@param project  
		@param recursive      
		@param make_new_version_active     */
	bool CheckIn(CaplInstance *project,bool recursive=false,bool make_new_version_active=true);
	/**    c   
		@param project  
		@param recursive      */
	bool CheckInWithRequest( CaplInstance *project,bool &recursive=m_bRecursive);

	/**    */
	bool UndoCheckOut( CaplInstance *project,bool recursive=false);
	/**    c   
		@param project   */
	bool UndoCheckOutWithRequest(CaplInstance *project,bool &recursive=m_bRecursive);

	/** ,      
		@param project      
		@param recursive       
		@return true,   ,false -   .  ,    */
	bool CheckMyLockAndCheckOut(CaplInstance *project,bool recursive=true);

	bool IsProjectChanged(CaplInstance *project,CaplInstance *project_ver);


	//*************************************************************************
	//******     ******************************************
	//*************************************************************************

	typedef CaplTAggr<CTransaction*, CTransaction*, APLAGGR_LIST_OR_AUTOKILLREF> aplTransactionsArray;

	CaplInstance* CreateTransaction(CaplInstance* Project, LPCTSTR lpszId, LPCTSTR lpszName, LPCTSTR lpszDescr, LPCTSTR lpszDate, LPCTSTR lpszType, double summ);
	CaplInstance* CreateTransaction(CaplInstance* Project, LPCTSTR lpszId, LPCTSTR lpszName, LPCTSTR lpszDescr, COleDateTime Date, LPCTSTR lpszType, double summ);

	/**        */
	bool LoadTransactionsInfo(CaplInstance *inst);
	/**        */
	bool LoadTransactionsInfo(aplExtent &ext);

	/**        */
	bool DeleteTransaction(CaplInstance* Project, CaplInstance* inst);

	/**    */
	bool SelectTransactionFilter(STransactionFilter &Filter);
	
	/**    */
	bool FilterTransactions(aplTransactionsArray &InTransactions, aplTransactionsArray &OutTransactions, STransactionFilter &Filter);

	/**       */
	bool ReportTransactions(CaplInstance* Project, STransactionFilter &Filter, bool bShowTable = true, bool bRecursive = true, aplTransactionsArray *pArray = NULL);



	//*************************************************************************
	//******     ******************************************
	//*************************************************************************

	//   . ext -   
	bool ShowProjectsMonitor(aplExtent &ext, bool bLoadFromBD=true);

	//     . ext -   
	// ext -  
	// bLoadFromBD -        
	// bExpandAll -  true,   " "   
	// prj4select -     
	bool ShowGanttDlg(aplExtent &ext, bool bLoadFromBD=true, bool bExpandAll=false, CaplInstance *prj4select=0);


	//     ( )
	// prj_src -  
	// parent -   (  )
	CaplInstance *CreateProjectTreeCopy(CaplInstance *prj_src, CaplInstance *parent=0);


	//*************************************************************************
	//******     ******************************************
	//*************************************************************************
	
	//       bPrjIsParent -      (  )
	bool GetPrjDateRestrictions(CaplInstance *prj,  COleDateTime &odt_begin,  COleDateTime &odt_end, bool bPrjIsParent);

	//    .      - null -   
	bool SetProjectNewPlanedDate(CaplInstance *prj, COleDateTime &odtNewBeginDate, COleDateTime &odtNewEndDate);  

	//bool SetProjectPlanedBeginDate(CaplInstance *prj, COleDateTime &odtNewBeginDate);  //    


};


