// AboutDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"
#include "AboutDlg.h"
#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog


CAboutDlg::CAboutDlg(CaplAPI *api, UINT nIDTemplate, CWnd* pParent)
	: CaplTranslateDialog(nIDTemplate, pParent)
{
	m_logo_icon=0;
	m_api = api;
	//{{AFX_DATA_INIT(CAboutDlg)
	m_sModLic = _T("");
	m_sSrvLic = _T("");
	m_sModuleName = _T("");
	m_sVer = _T("");
	//}}AFX_DATA_INIT
	
	m_sTitle =  APL_T(" ");
}

CAboutDlg::CAboutDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CAboutDlg::IDD, pParent)
{
	m_api = api;
	//{{AFX_DATA_INIT(CAboutDlg)
	m_sModLic = _T("");
	m_sSrvLic = _T("");
	m_sModuleName = _T("");
	m_sVer = _T("");
	//}}AFX_DATA_INIT
	
	m_sTitle =  APL_T(" ");
}


void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_WWW_CALS_RU, m_www_cals_ru);
	DDX_Control(pDX, IDC_INFO_CALS_RU, m_info_cals_ru);
	DDX_Control(pDX, IDC_STATIC_LOGO, m_logo);
	DDX_Text(pDX, IDC_MOD_LIC, m_sModLic);
	DDX_Text(pDX, IDC_STATIC_LIC, m_sSrvLic);
	DDX_Text(pDX, IDC_STATIC_MODULE, m_sModuleName);
	DDX_Text(pDX, IDC_STATIC_VER, m_sVer);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_PHONE, m_phone_ctrl);
}


BEGIN_MESSAGE_MAP(CAboutDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

#ifdef _DEMO
	LPCTSTR TCHAR psm_licenze_text= _T(" . \n\n : \n"\
							"\n -    = %i."\
							"\n -    ."\
							"\n -   ."\
							"\n -    .");
#else
	LPCTSTR psm_licenze_text=  _T("  ");
#endif

#define DEMO_PDF_COUNT 100

BOOL CAboutDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	//m_sModLic.Format(APL_T(psm_licenze_text), DEMO_PDF_COUNT);
	m_sModLic = CaplTranslate::Translate(psm_licenze_text);
	m_sModLic.Replace(_T('\n'),_T(' '));
	m_sModLic.Replace(_T('-'),_T(' '));

#ifdef _MOMA_

	
	//   ,  
	m_www_cals_ru.SetWindowText(_T("")); // (_T("http://cadpro.co.rs"));
	m_www_cals_ru.SetURL(_T("")); // (_T("http://cadpro.co.rs"));
	m_www_cals_ru.ShowWindow(SW_HIDE);

	RECT r;
	m_info_cals_ru.GetWindowRect(&r);
	r.left-=100;
	ScreenToClient(&r);
	m_info_cals_ru.MoveWindow(&r);
	m_info_cals_ru.SetWindowText(_T("office@cadpro.co.rs"));
	m_info_cals_ru.SetURL(_T("mailto:office@cadpro.co.rs"));
	
	m_phone_ctrl.SetWindowText(_T("+381 11 3115231"));
	m_phone_ctrl.GetWindowRect(&r);
	r.right+=20;
	ScreenToClient(&r);
	m_phone_ctrl.MoveWindow(&r);

#else 

	m_info_cals_ru.SetURL(_T("mailto:info@cals.ru"));
	m_www_cals_ru.SetURL(_T("http://www.cals.ru"));

#endif

	m_sVer =  APL_T(": ")+GetVersion();
	CString ver_serv=_T(""),type_serv=_T("");

	if(m_api)
	{
		long a=0;
		if(m_api->m_data.IsConnected())
		{
			m_api->m_data.GetVersionServer(ver_serv,type_serv);
			m_sVer+= APL_T("\r\n: ")+ver_serv+ APL_T("  : ")+type_serv;
			
			/*       
			CString buf;
			buf.Format( APL_T("\r\n : %s v%i"),LPCTSTR(m_api->m_data.m_CurSchema), m_api->m_data.m_CurSchemaVersion);
			m_sVer+=buf;

			if(m_api->m_data.m_CurSchema2!=_T(""))
			{
				buf.Format( APL_T(" + %s v%i"),LPCTSTR(m_api->m_data.m_CurSchema2),m_api->m_data.m_CurSchemaVersion2);
				m_sVer+=buf;
			}*/

			 m_sVer+=APL_T("\r\n : ");
			 m_sVer+=m_api->m_data.GetDictionaryDescription();

			m_api->m_data.NET_GetLicenseStatus(m_sSrvLic, a);
		}
		if(m_sSrvLic.IsEmpty()) m_sSrvLic= APL_T("  ");
		else {if(a==-1) m_sSrvLic+=_T(" | Demo Server");}
	}

	SetWindowText(m_sTitle);

	CenterWindow(AfxGetMainWnd());

	if(0!=m_logo_icon)
	{
		m_logo.ModifyStyle(SS_BITMAP,SS_ICON);
		m_logo.SetIcon(m_logo_icon);
	}
	else
	{
		if(0==m_bmp.m_hObject) aplGetLogoBmp(m_bmp,this);
		if(0!=m_bmp.m_hObject)
		{
			m_logo.ModifyStyle(SS_ICON,SS_BITMAP);
			m_logo.SetBitmap(m_bmp);
		}
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

CString CAboutDlg::GetVersion()
{
	CString buf, ver_sys = _T("?");

	//  
	CString ininame;
	HMODULE hModule = GetModuleHandle(NULL);
	if (hModule)
	{
		TCHAR *pBuf = new TCHAR[2048];
		GetModuleFileName(hModule, pBuf, 2048);
		ininame = pBuf;
		delete pBuf;
		ininame = ininame.Left(ininame.ReverseFind(_T('\\')) + 1);
	}

	ininame += _T("pss.ver");
	
	CStdioFile f;
	if (f.Open(ininame, CFile::modeRead | CFile::shareDenyRead | CFile::typeText))
	{
		while (f.ReadString(buf))
		{
			int i = buf.Find(_T("pssver="));
			if (i >= 0)
			{
				ver_sys = buf.Right(buf.GetLength() - 7);
				break;
			}
		}

		f.Close();
	}
	
	return ver_sys;
}

void CAboutDlg::SetTitle(const TCHAR* title)
{
	if (title)
		m_sTitle = title;
}

void CAboutDlg::SetText(const TCHAR* text)
{
	if (text)
		m_sModuleName = text;
}

void CAboutDlg::SetLogoIcon(HICON ico)
{
	m_logo_icon = ico;
}
