// AddDateSn.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "AddDateSn.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddDateSn dialog

extern bool (*funcGetAppByPdf)(CaplAPI*, CaplInstance*, aplExtent&);
extern bool (*funcGetComplectationByPdf)(CaplAPI*, CaplInstance*, aplExtent&);
extern bool (*funcLoadAppsInfo)(CaplAPI*, aplExtent&);
extern bool (*funcLoadComplectationsInfo)(CaplAPI*, aplExtent&);
extern bool (*funcFilterByAppOrComplectation)(CaplAPI*, aplExtent&, CaplInstance*, aplExtent&, bool, LPCTSTR);
//extern bool (*funcFilterByApp)(CaplAPI*, aplExtent&, CaplInstance*, aplExtent&, bool);
//extern bool (*funcFilterByComplectation)(CaplAPI*, aplExtent&, CaplInstance*, aplExtent&, bool);

CAddDateSn::CAddDateSn(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CAddDateSn::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddDateSn)
	//}}AFX_DATA_INIT
	m_context=0;
	m_api = NULL;
	m_pProductPDF = NULL;
	m_pSelectedItem = NULL;
}


void CAddDateSn::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddDateSn)
	DDX_Control(pDX, IDC_SEL_CONTEXT, m_sel_context);
	DDX_Control(pDX, IDC_DATETIME2, m_time);
	DDX_Control(pDX, IDC_DATETIME1, m_date);
	DDX_Control(pDX, IDC_EDITSN, m_editsn);
	DDX_Control(pDX, IDC_CHECSN, m_checkSn);
	DDX_Control(pDX, IDC_CHECKDATE, m_checkDate);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_SEL_CONFIGURATION, m_cbSelectConfiguration);
	DDX_Control(pDX, IDC_CONFIG_STATIC, m_statConfigStatic);
	DDX_Control(pDX, IDOK, m_btnOk);
	DDX_Control(pDX, IDCANCEL, m_btnCancel);
	DDX_Control(pDX, IDC_LOAD_CHOSEN_PRODUCT_CONFIGURATIONS_BUTTON, m_btnLoadProductConfigs);
}


BEGIN_MESSAGE_MAP(CAddDateSn, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CAddDateSn)
	ON_BN_CLICKED(IDC_CHECKDATE, OnCheckdate)
	ON_BN_CLICKED(IDC_CHECSN, OnChecsn)
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(IDC_SEL_CONFIGURATION, &CAddDateSn::OnCbnSelchangeSelConfiguration)	
	ON_BN_CLICKED(IDC_LOAD_CHOSEN_PRODUCT_CONFIGURATIONS_BUTTON, &CAddDateSn::OnBnClickedLoadChosenProductConfigurationsButton)
	ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddDateSn message handlers

void CAddDateSn::OnCheckdate() 
{
	if(m_checkDate.GetCheck()) 
	{
		m_time.EnableWindow(true);
		m_date.EnableWindow(true);
	}
	else
	{
		m_time.EnableWindow(false);
		m_date.EnableWindow(false);
	}
}

void CAddDateSn::OnChecsn() 
{
	if(m_checkSn.GetCheck()) m_editsn.EnableWindow(true);
	else m_editsn.EnableWindow(false);
}

BOOL CAddDateSn::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	if(m_api==0) return FALSE;

	m_editsn.EnableWindow(false);
	m_time.EnableWindow(false);
	m_date.EnableWindow(false);
	m_cbSelectConfiguration.EnableToolTips();	

	if(m_dt.GetStatus()==COleDateTime::valid)
	{
		m_time.SetTime(m_dt);
		m_date.SetTime(m_dt);
		m_checkDate.SetCheck(1);
		m_time.EnableWindow(true);
		m_date.EnableWindow(true);
	}
	if(!m_sn.IsEmpty())
	{
		m_editsn.EnableWindow(true);
		m_editsn.SetWindowText(m_sn);
		m_checkSn.SetCheck(1);
	}

	//  
	int i,j,k=-1;
	CString buf;
	aplExtent ext_contexts;
	m_api->m_data.GetEntityExtent(m_api->m_prd_mgr.e_pd_context,ext_contexts);
	for(i=0;i<ext_contexts.Size;i++)
	{
		m_api->m_data.GetAttr(ext_contexts[i],m_api->m_prd_mgr.a_pd_context_name,buf);
		j=m_sel_context.AddString(buf);
		m_sel_context.SetItemData(j,(long)ext_contexts[i]);
	}
	j=m_sel_context.AddString( APL_T(" "));
	m_sel_context.SetItemData(j,0);
	m_sel_context.SetCurSel(j);

	if(m_context!=0)
	{
		for(i=0;i<m_sel_context.GetCount();i++)
		{
			if((DWORD)(m_context)==m_sel_context.GetItemData(i)) 
			{
				m_sel_context.SetCurSel(i);
				break;
			}
		}
	}

	// 

	BOOL bIsAppAvailable = (funcGetAppByPdf != NULL);
	BOOL bIsComplectationAvailable = (funcGetComplectationByPdf != NULL);

	m_cbSelectConfiguration.EnableWindow(bIsAppAvailable || bIsComplectationAvailable);
	m_statConfigStatic.EnableWindow(bIsAppAvailable || bIsComplectationAvailable);
	m_btnLoadProductConfigs.EnableWindow(bIsAppAvailable || bIsComplectationAvailable);

	if ((bIsAppAvailable || bIsComplectationAvailable) && (m_pProductPDF != NULL))
	{		
		if ((funcGetAppByPdf == NULL) || 
			(funcGetComplectationByPdf == NULL) || 
			(funcLoadAppsInfo == NULL) || 
			(funcLoadComplectationsInfo == NULL) || 
			(funcFilterByAppOrComplectation == NULL))
			return false;

		aplExtent extApps;
		CaplStrMap mapApps;
		aplExtent extComplectations;		
		CaplStrMap mapComplectations;

		funcGetAppByPdf(m_api, m_pProductPDF, extApps);
		funcGetComplectationByPdf(m_api, m_pProductPDF, extComplectations);
		funcLoadAppsInfo(m_api, extApps);
		funcLoadComplectationsInfo(m_api, extComplectations);
		m_cbSelectConfiguration.AddString( APL_T("  / "));

		//////////////////////////////////////////////////////////////////////////
		//  

		for (int iIndex = 0; iIndex < extApps.GetSize(); iIndex++)
		{
			CaplInstance *pApp = extApps[iIndex];
			CString strAppCode;
			CString strAppName;
			CString strAppInfo;

			m_api->m_data.GetAttrBN(pApp, _T("code"), strAppCode);
			m_api->m_data.GetAttrBN(pApp, _T("name"), strAppName);

			strAppInfo = CString(_T("(")) + strAppCode + CString(_T(" : ")) + strAppName + CString(_T(")"));
			mapApps.Add(strAppInfo, pApp);
		}

		mapApps.Sort();

		for (int iIndex = 0; iIndex < mapApps.GetSize(); iIndex++)
		{
			CaplInstance *pApp = (CaplInstance*)mapApps.GetAt(iIndex)->val;
			CString strAppCode;
			CString strAppName;
			CString strAppInfo;

			m_api->m_data.GetAttrBN(pApp, _T("code"), strAppCode);
			m_api->m_data.GetAttrBN(pApp, _T("name"), strAppName);

			strAppInfo = CString(_T("(")) + strAppCode + CString(_T(" : ")) + strAppName + CString(_T(")"));
			m_cbSelectConfiguration.AddString(strAppInfo);
			m_cbSelectConfiguration.SetItemData(iIndex + 1, (DWORD)pApp);

			//////////////////////////////////////////////////////////////////////////
			//   ,   
			if ((m_pSelectedItem != NULL) && (m_api->m_data.IsKindOfBN(m_pSelectedItem, _T("apl_product_appearance"))) && (pApp == m_pSelectedItem))
				m_cbSelectConfiguration.SetCurSel(iIndex + 1);
		}

		//////////////////////////////////////////////////////////////////////////
		// 

		for (int iIndex = 0; iIndex < extComplectations.GetSize(); iIndex++)
		{
			CaplInstance *pComplectation = extComplectations[iIndex];
			CString strCompCode;
			CString strCompName;
			CString strComplectationInfo;

			m_api->m_data.GetAttrBN(pComplectation, _T("code"), strCompCode);
			m_api->m_data.GetAttrBN(pComplectation, _T("name"), strCompName);

			strComplectationInfo = strCompCode + CString(_T(" : ")) + strCompName;
			mapComplectations.Add(strComplectationInfo, pComplectation);
		}

		mapComplectations.Sort();

		for (int iIndex = 0; iIndex < mapComplectations.GetSize(); iIndex++)
		{
			CaplInstance *pComplectation = (CaplInstance*)mapComplectations.GetAt(iIndex)->val;
			CString strCompCode;
			CString strCompName;
			CString strComplectationInfo;

			m_api->m_data.GetAttrBN(pComplectation, _T("code"), strCompCode);
			m_api->m_data.GetAttrBN(pComplectation, _T("name"), strCompName);

			strComplectationInfo = strCompCode + CString(_T(" : ")) + strCompName;
			m_cbSelectConfiguration.AddString(strComplectationInfo);
			m_cbSelectConfiguration.SetItemData(mapApps.GetSize() + iIndex + 1, (DWORD)pComplectation);

			//////////////////////////////////////////////////////////////////////////
			//   ,   
			if ((m_pSelectedItem != NULL) && (m_api->m_data.IsKindOfBN(m_pSelectedItem, _T("apl_appearence_composition"))) &&  (pComplectation == m_pSelectedItem))
				m_cbSelectConfiguration.SetCurSel(mapApps.GetSize() + iIndex + 1);
		}

		if (m_pSelectedItem == NULL)
			m_cbSelectConfiguration.SetCurSel(0);
	}
	else
	{
		CRect rectDlg;
		CRect rectCtrls;

		GetWindowRect(&rectDlg);
				
		rectDlg.bottom -= 65;
		MoveWindow(&rectDlg);

		m_btnOk.GetWindowRect(&rectCtrls);
		ScreenToClient(&rectCtrls);
		rectCtrls.top -= 65;
		rectCtrls.bottom -= 65;
		m_btnOk.MoveWindow(&rectCtrls);

		m_btnCancel.GetWindowRect(&rectCtrls);
		ScreenToClient(&rectCtrls);
		rectCtrls.top -= 65;
		rectCtrls.bottom -= 65;
		m_btnCancel.MoveWindow(&rectCtrls);

		m_statConfigStatic.ShowWindow(SW_HIDE);
		m_cbSelectConfiguration.ShowWindow(SW_HIDE);
		m_btnLoadProductConfigs.ShowWindow(SW_HIDE);
	}
	
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAddDateSn::OnOK() 
{
	bool bModified=false;;
	
	if(m_checkSn.GetCheck())
	{
		CString buf;
		m_editsn.GetWindowText(buf);
		if(buf==_T(""))
		{
			AfxMessageBox( APL_T("   "));
			return;
		}
		if(m_sn!=buf) {m_sn=buf; bModified=true;}
	}
	else { if(m_sn!=_T("")) { m_sn=_T("");bModified=true;}}

	if(m_checkDate.GetCheck())
	{
		COleDateTime d_time,t_time,dt;

		m_date.GetTime(d_time);	
		m_time.GetTime(t_time);

		dt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
			t_time.GetHour(),t_time.GetMinute(),t_time.GetSecond());
		if(dt!=m_dt) {m_dt=dt; bModified=true;}
	}
	else 
	{
		if(m_dt.GetStatus()!=COleDateTime::null)
		{
			m_dt.SetStatus(COleDateTime::null);
			bModified=true;
		}
	}
	CaplInstance *context=(CaplInstance *)m_sel_context.GetItemData(m_sel_context.GetCurSel());
	if(context!=m_context)
	{
		m_context=context;bModified=true;
	}

	bModified = true;

	CaplTranslateDialog::OnOK();
}

void CAddDateSn::OnCbnSelchangeSelConfiguration()
{
	int iSelItem = m_cbSelectConfiguration.GetCurSel();

	if (iSelItem == -1)
		return;

	m_pSelectedItem = (CaplInstance*)m_cbSelectConfiguration.GetItemData(iSelItem);
}

void CAddDateSn::OnBnClickedLoadChosenProductConfigurationsButton()
{
	if ((funcGetAppByPdf == NULL) || 
		(funcGetComplectationByPdf == NULL) || 
		(funcFilterByAppOrComplectation == NULL))
		return;	

	CaplInstance *pSelectedProductPDF = m_api->m_prd_mgr.SelectInstance(APL_MODE_SELECT_PDF, CString( APL_T("  ")));
	aplExtent extApps;
	CaplStrMap mapApps;
	aplExtent extComplectations;	
	CaplStrMap mapComplectations;

	if (pSelectedProductPDF == NULL)
		return;

	int nCount = m_cbSelectConfiguration.GetCount();

	for (int iIndex = 0; iIndex < (nCount - 1); iIndex++)
		m_cbSelectConfiguration.DeleteString(1);

	m_cbSelectConfiguration.SetCurSel(0);

	//////////////////////////////////////////////////////////////////////////
	// 
	
	funcGetAppByPdf(m_api, pSelectedProductPDF, extApps);
	funcLoadAppsInfo(m_api, extApps);	

	for (int iIndex = 0; iIndex < extApps.GetSize(); iIndex++)
	{
		CaplInstance *pApp = extApps[iIndex];
		CString strAppCode;
		CString strAppName;
		CString strAppInfo;

		m_api->m_data.GetAttrBN(pApp, _T("code"), strAppCode);
		m_api->m_data.GetAttrBN(pApp, _T("name"), strAppName);

		strAppInfo = CString(_T("(")) + strAppCode + CString(_T(" : ")) + strAppName + CString(_T(")"));
		mapApps.Add(strAppInfo, pApp);
	}

	mapApps.Sort();

	for (int iIndex = 0; iIndex < mapApps.GetSize(); iIndex++)
	{
		CaplInstance *pApp = (CaplInstance*)mapApps.GetAt(iIndex)->val;
		CString strAppCode;
		CString strAppName;
		CString strAppInfo;

		m_api->m_data.GetAttrBN(pApp, _T("code"), strAppCode);
		m_api->m_data.GetAttrBN(pApp, _T("name"), strAppName);

		strAppInfo = CString(_T("(")) + strAppCode + CString(_T(" : ")) + strAppName + CString(_T(")"));
		m_cbSelectConfiguration.AddString(strAppInfo);
		m_cbSelectConfiguration.SetItemData(iIndex + 1, (DWORD)pApp);

		//////////////////////////////////////////////////////////////////////////
		//   ,   
		if (pApp == m_pSelectedItem)
			m_cbSelectConfiguration.SetCurSel(iIndex + 1);
	}

	//////////////////////////////////////////////////////////////////////////
	// 

	funcGetComplectationByPdf(m_api, pSelectedProductPDF, extComplectations);
	funcLoadComplectationsInfo(m_api, extComplectations);

	for (int iIndex = 0; iIndex < extComplectations.GetSize(); iIndex++)
	{
		CaplInstance *pComplectation = extComplectations[iIndex];
		CString strCompCode;
		CString strCompName;
		CString strComplectationInfo;

		m_api->m_data.GetAttrBN(pComplectation, _T("code"), strCompCode);
		m_api->m_data.GetAttrBN(pComplectation, _T("name"), strCompName);

		strComplectationInfo = strCompCode + CString(_T(" : ")) + strCompName;
		mapComplectations.Add(strComplectationInfo, pComplectation);
	}

	mapComplectations.Sort();

	for (int iIndex = 0; iIndex < mapComplectations.GetSize(); iIndex++)
	{
		CaplInstance *pComplectation = (CaplInstance*)mapComplectations.GetAt(iIndex)->val;
		CString strCompCode;
		CString strCompName;
		CString strComplectationInfo;

		m_api->m_data.GetAttrBN(pComplectation, _T("code"), strCompCode);
		m_api->m_data.GetAttrBN(pComplectation, _T("name"), strCompName);

		strComplectationInfo = strCompCode + CString(_T(" : ")) + strCompName;
		m_cbSelectConfiguration.AddString(strComplectationInfo);
		m_cbSelectConfiguration.SetItemData(extApps.GetSize() + iIndex + 1, (DWORD)pComplectation);

		//////////////////////////////////////////////////////////////////////////
		//   ,   
		if (pComplectation == m_pSelectedItem)
			m_cbSelectConfiguration.SetCurSel(extApps.GetSize() + iIndex + 1);
	}	
}

void CAddDateSn::OnMouseMove(UINT nFlags, CPoint point)
{
	m_ttToolTip.Hide();
	m_cbSelectConfiguration.Invalidate(TRUE);

	CaplTranslateDialog::OnMouseMove(nFlags, point);
}

BOOL CAddDateSn::PreTranslateMessage(MSG* pMsg)
{
	if ((pMsg->message == WM_MOUSEMOVE) && (pMsg->hwnd == m_cbSelectConfiguration.m_hWnd))
	{
		CRect rect;
		CPoint point = pMsg->pt;

		m_ttToolTip.Hide();
		m_cbSelectConfiguration.GetWindowRect(&rect);

		if (rect.PtInRect(point))
		{
			CString strValue;

			m_cbSelectConfiguration.GetWindowText(strValue);
//			m_ttToolTip.m_delay_time = 2000;
			m_ttToolTip.Show(rect.left, rect.top, strValue);			
		}	
	}

	return CaplTranslateDialog::PreTranslateMessage(pMsg);
}
