// AddRuleDate.cpp : implementation file
//

#include "stdafx.h"
#include "AddRuleDate.h"
#include "StepData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddRuleDate dialog



CAddRuleDate::CAddRuleDate(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CAddRuleDate::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddRuleDate)
	m_start_date = COleDateTime::GetCurrentTime();
	//}}AFX_DATA_INIT
	m_eff=0;
	m_data=0;
	flag=0;
	m_PrMan=0;
	m_RO=false;
	m_rel=0;
} 

void CAddRuleDate::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddRuleDate)
	DDX_Control(pDX, IDC_END_CHECK, m_end_check);
	DDX_Control(pDX, IDC_START_CHECK, m_start_check);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_STOP_DATE, m_stop_date_ctrl);
	DDX_Control(pDX, IDC_START_DATE, m_start_date_ctrl);
	DDX_Control(pDX, IDC_EFF_ID, m_eff_id_ctrl);
	DDX_DateTimeCtrl(pDX, IDC_START_DATE, m_start_date);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddRuleDate, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CAddRuleDate)
	ON_BN_CLICKED(IDC_START_CHECK, OnStartCheck)
	ON_BN_CLICKED(IDC_END_CHECK, OnEndCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddRuleDate message handlers

void CAddRuleDate::OnOK() 
{
	if(m_data==0) return;
	if(m_start_check.GetCheck()==0 && m_end_check.GetCheck()==0)
	{
		AfxMessageBox( APL_T("  ,   !")); 
		return;	
	}

	CString pde_id;
	m_eff_id_ctrl.GetWindowText(pde_id);

	/*
	if(pde_id==""){ AfxMessageBox("  "); return;}

  //     
	CaplAttrValue tst_values[1];
	tst_values[0].value.Set(LPCTSTR(pde_id));
	tst_values[0].attr=m_PrMan->a_pde_id;
	if(!m_data->NET_TestUniqueAttrValues(m_PrMan->e_pd_eff,m_eff,1,&tst_values[0], false))
	{
		AfxMessageBox("        !!!");return;
	}
	*/
	CString start_dt_s=_T(""),end_dt_s=_T("");
	COleDateTime odt;
	if(m_start_check.GetCheck()==1)
	{
		m_start_date_ctrl.GetTime(odt);	
		odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),
			0,0,0);
		aplDate2String(odt,start_dt_s);
	}
	if(m_end_check.GetCheck()==1)
	{
		m_stop_date_ctrl.GetTime(odt);	
		odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),
			0,0,0);
		aplDate2String(odt,end_dt_s);
	}
	if(m_start_check.GetCheck()==1 && m_end_check.GetCheck()==1)
	{
		if(start_dt_s>=end_dt_s)
		{
			//        
			//      
			AfxMessageBox( APL_T("   !!!\n\n (  <=  )"),MB_OK|MB_ICONSTOP);
			return;
		}
	}
	//      
	CString buf,eff_s_dt_s,eff_e_dt_s;
	aplExtent ext_eff;
	m_data->GetEntityExtent(m_PrMan->e_dat_eff,ext_eff);
	for(int i=0;i<ext_eff.GetSize();i++)
	{
		if(ext_eff[i]==m_eff) continue;
		CaplInstance *pdr;
		m_data->GetAttr(ext_eff[i],m_PrMan->a_pde_usage,pdr);
		if(pdr!=m_rel) continue;
		bool b_inactive;
		m_data->GetAttr(ext_eff[i],m_PrMan->a_pde_not_active,b_inactive);
		if(b_inactive) continue;
		m_data->GetAttr(ext_eff[i],m_PrMan->a_dat_eff_start_s,eff_s_dt_s);
		m_data->GetAttr(ext_eff[i],m_PrMan->a_dat_eff_end_s,eff_e_dt_s);
		bool b_error=false;
		if(start_dt_s==_T(""))
		{
			if(end_dt_s>=eff_s_dt_s) 
				b_error=true;
		}
		else if(end_dt_s==_T(""))
		{
			if(start_dt_s<eff_e_dt_s || eff_e_dt_s==_T("")) 
				b_error=true;
		}
		else
		{
			if(start_dt_s>eff_s_dt_s && (start_dt_s<eff_e_dt_s || eff_e_dt_s==_T(""))) 
				b_error=true;
			if(end_dt_s>eff_s_dt_s && (end_dt_s<=eff_e_dt_s || eff_e_dt_s==_T(""))) 
				b_error=true;
		}
		if(b_error)
		{
			m_data->GetAttr(ext_eff[i],m_PrMan->a_pde_id,buf);
			if(buf==_T("")) buf= APL_T(" < > ");
			buf= APL_T("       ( '")+buf+_T("')");
			AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
			return;
		}
	}

	if(m_eff==0)
	{//   
		//    
		m_eff=m_data->CreateInstance(m_PrMan->e_dat_eff);
		if(m_rel) m_data->PutAttr(m_eff,m_PrMan->a_pde_usage,m_rel);
	}
	//  
	m_data->GetAttr(m_eff,m_PrMan->a_pde_id,buf);
	if(buf!=pde_id) m_data->PutAttr(m_eff,m_PrMan->a_pde_id,pde_id);
	
	m_data->GetAttr(m_eff,m_PrMan->a_dat_eff_start_s,buf);
	if(buf!=start_dt_s)	m_data->PutAttr(m_eff,m_PrMan->a_dat_eff_start_s,start_dt_s);

	m_data->GetAttr(m_eff,m_PrMan->a_dat_eff_end_s,buf);
	if(buf!=end_dt_s) m_data->PutAttr(m_eff,m_PrMan->a_dat_eff_end_s,end_dt_s);
	
	CaplTranslateDialog::OnOK();
}

BOOL CAddRuleDate::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	if(m_data==0) return FALSE;
	COleDateTime start_t, end_t;
	if (!m_eff)
	{
		m_start_check.SetCheck(1);
		m_start_date_ctrl.EnableWindow(true);
	}
	else 
	{	//  
		CString buf;
		//m_eff_id_ctrl.EnableWindow(false);
		m_data->GetAttr(m_eff,m_PrMan->a_pde_id,buf);
		m_eff_id_ctrl.SetWindowText(buf);
		
		COleDateTime odt;
		m_data->GetAttr(m_eff,m_PrMan->a_dat_eff_start_s,s_dt);
		if(s_dt==_T("19010101000000")) s_dt=_T("");
		if(s_dt!=_T(""))
		{
			m_start_check.SetCheck(1);
			m_start_date_ctrl.EnableWindow(true);
			aplString2Date(s_dt,odt);
			m_start_date_ctrl.SetTime(odt);
		}
		
		m_data->GetAttr(m_eff,m_PrMan->a_dat_eff_end_s,s_dt);
		if(s_dt!=_T(""))
		{
			m_end_check.SetCheck(1);
			m_stop_date_ctrl.EnableWindow(true);
			aplString2Date(s_dt,odt);
			m_stop_date_ctrl.SetTime(odt);
		}
	}
	if(m_RO)
	{
		m_ok_btn.EnableWindow(false);
		m_start_check.EnableWindow(FALSE);
		m_end_check.EnableWindow(false);
		
		m_eff_id_ctrl.SetReadOnly(TRUE);

		m_stop_date_ctrl.EnableWindow(false);
		m_start_date_ctrl.EnableWindow(false);
	}
				
	return TRUE;
}

void CAddRuleDate::OnStartCheck() 
{
	if(m_start_check.GetCheck()) 
	{		
		m_start_date_ctrl.EnableWindow(true);
	}
	else 
	{
		m_start_date_ctrl.EnableWindow(false);
	}
	
}

void CAddRuleDate::OnEndCheck() 
{
	if(m_end_check.GetCheck()) 
	{		
		m_stop_date_ctrl.EnableWindow(true);
	}
	else 
	{
		m_stop_date_ctrl.EnableWindow(false);
	}
	
}
