#pragma once
#include "resource.h"
#include <apl_gui.h>
#include "apl_api.h"
#include "afxcmn.h"
#include "afxwin.h"
#include "afxdtctl.h"

// CImportStructPss2IlsDlg dialog

class CImportStructPss2IlsDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CImportStructPss2IlsDlg)

public:
	CImportStructPss2IlsDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CImportStructPss2IlsDlg();

	CaplAPI *m_api;
	CaplInstance *m_top_pdf;

	aplExtent m_ext_pdf, m_ext_nauo;

	HTREEITEM m_top_pdf_hItem;

	bool BuildStructTree();
	HTREEITEM InsertItemInTree(HTREEITEM hParent, CaplInstance *item);
	bool InsertItemStructInTree(HTREEITEM hItem, CaplInstance *pdf);

	void SetCheckSubItems(HTREEITEM hItem, BOOL bCheck, bool bRecursive);

	bool GetInstancesFromTree(HTREEITEM hitem, aplExtent &ext_pdf, aplExtent &ext_nauo);

// Dialog Data
	enum { IDD = IDD_IMP_STUCT_PSS2ILS };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	bool m_bFilterByDate;
	COleDateTime m_odt_filter;

	DECLARE_MESSAGE_MAP()
protected:
	virtual void OnOK();
public:
	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;
	CaplButton m_build_tree_btn;
	CTreeCtrl m_tree;
	virtual BOOL OnInitDialog();
	afx_msg void OnNMClickTreeStruct(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRClickTreeStruct(NMHDR *pNMHDR, LRESULT *pResult);
	CButton m_filter_check;
	CDateTimeCtrl m_date_filter;
	afx_msg void OnBnClickedCheckFilter();
	afx_msg void OnBnClickedBuildTree();
	CaplButton m_find_btn;
	afx_msg void OnBnClickedFind1();
	afx_msg void OnTvnItemexpandingTreeStruct(NMHDR *pNMHDR, LRESULT *pResult);
};
