#pragma once

typedef std::map<CString, CString> TStrStrMap;
typedef std::map<CString, CaplInstance*> TStrInstMap;

class CaplNrmmManager
{
public:
	CaplNrmmManager(CaplAPI *api);
	~CaplNrmmManager(void);

	//     
	bool GenerateLimitByPdf(CaplInstance *nrm, CaplInstance *pdf);

	//        
	bool DeleteLimit(CaplInstance *nrm);

protected:
	//  
	bool DeleteLimitRecursive(aplExtent &parentPdf, const CString &pdfId);

	//       
	bool CanGenerateNrm(CaplInstance *nrm, CaplInstance *pdf);

	//       ,   
	bool FindMaterials(CaplInstance *parentPdf, aplExtent &materials, aplExtent &nrmItems);

	//  pdf       material
	void FindMaterialRelations(aplExtent &parentPdfs, aplExtent &structureRelations, aplExtent &nrmItems);

	//   (   ,     ..)
	bool TestMaterialRelation(CaplInstance *relation);

	//   
	CaplInstance* IsPreFabricated(CaplInstance *relation);

	//     
	void SaveDisassembly(CaplInstance *pdf, aplExtent &structureRelations);

	//   pdfToCount  topPdf
	double GetCountForCustomPdf(CaplInstance *topPdf, CaplInstance *pdfToCount);

	//    ,   
	void LoadAttrsMaterialRelations(aplExtent &materialRelations, bool bLoadFromDb);

	//  
	void LoadCharacts(aplExtent &materialRelations);

	//      
	bool LoadClassifiers(TStrStrMap &classifiers);

	//   
	CaplInstance* AddChild(CaplInstance *parent, LPCTSTR id, LPCTSTR name);

	//    
	CaplInstance* GetBasePrdUnit();

	//   
	void FindExistingNrm(aplExtent &pdfs, aplExtent &nrmItems);

	//    "  "
	bool SetNewItemsAccess(aplExtent &accessItems);

	//      
	bool GetMaterialCountByShop(std::map<CString, double> &info, CaplInstance *material, CaplInstance *pdf);
	bool SynchronizeCount(std::map<CaplInstance*, CaplInstance*> &nrmmMaterial, long dId, CaplInstance *pdf);
	bool SynchronizeCount(CaplInstance *nrmm, CaplInstance *material, CaplInstance *pdf, double koeff);

	//     
	void GroupRelationsByShop(aplExtent &materialRelations, std::map<CString, std::vector<CaplInstance*>> &groupedMaterialRelations);

	//          
	void GetTotalMaterialCount(std::map<CaplInstance*, std::vector<CaplInstance*>> &relationsOrderedByEdItem,
								std::map<CString, std::vector<CaplInstance*>> &groupedMaterialRelations,
								std::map<CString, double> &info,
								CaplInstance *topPdf);

	//      
	double GetTotalPdfCount(CaplInstance *item, std::map<CaplInstance*, std::vector<CaplInstance*>> &relationsOrderedByEdItem, CaplInstance *topPdf);

	void ParseRasc(CString& csInRasc,CString csDepotSep,CString csGrpSep,
		CStringArray* csapOutDepots,CStringArray* csapOutGrps);

protected:
	CaplAPI *m_api;
	CaplInstance *m_baseUnit;
	CaplInstance *m_shopCharact;
	CaplInstance *m_rascCharact;	
	CaplInstance *m_warehouseCharact;

	std::set<CaplInstance*> m_pdfWithLoadedAttrs;
	std::set<CaplInstance*> m_relationsWithLoadedCharacts;
	std::map<CaplInstance*, std::vector<CaplInstance*>> m_disassembliedPdfs;	
	std::map<CaplInstance*, CaplInstance*> m_nrmForAssembly;
};
