#include "stdafx.h"
#include <finder.h>
#include "dictionary.h"
#include "resource.h"
#include "apl_api.h"
#include "ChangeDlg.h"
#include "ChangedStructItem.h"
#include "DelPdrDlg.h"
#include "ChangesTreeDlg.h"
#include "ChangeDocVerDlg.h"
#include "ChangeParamDlg.h"
#include "ChangeAssemblyDlg.h"

bool CaplChangeManager::Attach(CaplAPI *api)
{
	if(api==0) {Detach();return false;}
	CaplStepManager::Attach(api);

	e_chng= m_api->m_data.GetEntityBN(_T("apl_change"));
	a_chng_id= m_api->m_data.GetAttrDefinition(e_chng, _T("id"));
	a_chng_pdf= m_api->m_data.GetAttrDefinition(e_chng, _T("pdf"));
	a_chng_dscr= m_api->m_data.GetAttrDefinition(e_chng, _T("description"));
	a_chng_name= m_api->m_data.GetAttrDefinition(e_chng, _T("name"));
	a_chng_user= m_api->m_data.GetAttrDefinition(e_chng, _T("user"));
	a_chng_autor= m_api->m_data.GetAttrDefinition(e_chng, _T("autor"));
	a_chng_apply_date= m_api->m_data.GetAttrDefinition(e_chng, _T("apply_date"));
	a_chng_state= m_api->m_data.GetAttrDefinition(e_chng, _T("state"));
	a_chng_items= m_api->m_data.GetAttrDefinition(e_chng, _T("items"));
	a_chng_basis= m_api->m_data.GetAttrDefinition(e_chng, _T("basis"));
	a_chng_stock= m_api->m_data.GetAttrDefinition(e_chng, _T("stock"));
	a_chng_stock_ceh= m_api->m_data.GetAttrDefinition(e_chng, _T("stock_ceh"));
	a_chng_asm_pdf= m_api->m_data.GetAttrDefinition(e_chng, _T("assembly_pdf"));
	a_chng_create_user= m_api->m_data.GetAttrDefinition(e_chng, _T("create_user"));
	a_chng_create_autor= m_api->m_data.GetAttrDefinition(e_chng, _T("create_autor"));
	a_chng_create_date= m_api->m_data.GetAttrDefinition(e_chng, _T("create_date"));
	a_chng_changed_assemlies= m_api->m_data.GetAttrDefinition(e_chng, _T("changed_assemlies"));
	a_chng_is_modify= m_api->m_data.GetAttrDefinition(e_chng, _T("is_modify"));
	a_chng_eff_type= m_api->m_data.GetAttrDefinition(e_chng, _T("effectivity_type"));
	a_chng_start_date= m_api->m_data.GetAttrDefinition(e_chng, _T("start_date"));
	a_chng_end_date= m_api->m_data.GetAttrDefinition(e_chng, _T("end_date"));
	a_chng_start_num= m_api->m_data.GetAttrDefinition(e_chng, _T("start_condition"));
	a_chng_end_num= m_api->m_data.GetAttrDefinition(e_chng, _T("end_condition"));
	a_chng_export_num = m_api->m_data.GetAttrDefinition(e_chng, _T("export_num"));
	a_chng_order_directive = m_api->m_data.GetAttrDefinition(e_chng, _T("order_directive"));
	a_chng_type = m_api->m_data.GetAttrDefinition(e_chng, _T("type"));
	a_chng_event_number = m_api->m_data.GetAttrDefinition(e_chng, _T("event_number"));
	a_chng_rejection_reason = m_api->m_data.GetAttrDefinition(e_chng, _T("rejection_reason"));
	a_chng_helicopter_usage = m_api->m_data.GetAttrDefinition(e_chng, _T("helicopter_usage"));
	a_chng_handmade_copy = m_api->m_data.GetAttrDefinition(e_chng, _T("handmade_copy"));
	a_chng_base = m_api->m_data.GetAttrDefinition(e_chng, _T("base"));
	a_chng_src_pi = m_api->m_data.GetAttrDefinition(e_chng, _T("src_pi"));
	a_chng_urgency = m_api->m_data.GetAttrDefinition(e_chng, _T("urgency"));
	a_chng_issue_date= m_api->m_data.GetAttrDefinition(e_chng, _T("issue_date"));
	a_chng_validity_pi_date= m_api->m_data.GetAttrDefinition(e_chng, _T("validity_pi_date"));
	a_chng_validity_pi_date_actual= m_api->m_data.GetAttrDefinition(e_chng, _T("validity_pi_date_actual"));
	a_chng_group_id= m_api->m_data.GetAttrDefinition(e_chng, _T("group_id"));			
	a_chng_dependent_items= m_api->m_data.GetAttrDefinition(e_chng, _T("dependent_items"));			
	a_chng_notice= m_api->m_data.GetAttrDefinition(e_chng, _T("notice"));			
	a_chng_org_code= m_api->m_data.GetAttrDefinition(e_chng, _T("org_code"));				/**   */
	a_chng_grp_num= m_api->m_data.GetAttrDefinition(e_chng, _T("grp_num"));					/**   */
	a_chng_doc_id= m_api->m_data.GetAttrDefinition(e_chng, _T("doc_id"));					/**   */
	a_chng_basis_code= m_api->m_data.GetAttrDefinition(e_chng, _T("basis_code"));			/**    */
	a_chng_usage= m_api->m_data.GetAttrDefinition(e_chng, _T("usage"));						/**  */
	a_chng_complect_num= m_api->m_data.GetAttrDefinition(e_chng, _T("complect_num"));		/**   . . */
	a_chng_list= m_api->m_data.GetAttrDefinition(e_chng, _T("list"));						/**   */
	a_chng_stock_introd= m_api->m_data.GetAttrDefinition(e_chng, _T("stock_introd"));		/**    */
	a_chng_stock_introd_type= m_api->m_data.GetAttrDefinition(e_chng, _T("stock_introd_type"));		/**    */	
	a_chng_to_date= m_api->m_data.GetAttrDefinition(e_chng, _T("to_date"));					/**    */
	a_chng_otd_date= m_api->m_data.GetAttrDefinition(e_chng, _T("otd_date"));				/**     */
	a_chng_critical_date= m_api->m_data.GetAttrDefinition(e_chng, _T("critical_date"));		/**   */
	a_chng_plan_lead_date= m_api->m_data.GetAttrDefinition(e_chng, _T("plan_lead_date"));	/**      */
	a_chng_plan_otd_date= m_api->m_data.GetAttrDefinition(e_chng, _T("plan_otd_date"));		/**      */
	a_chng_date_of= m_api->m_data.GetAttrDefinition(e_chng, _T("date_of"));					/**   */
	a_chng_usage_ing= m_api->m_data.GetAttrDefinition(e_chng, _T("usage_ing"));				/**  (   ) */

	CHECK_ZERO_ATTR(e_rasc_chng_log,                           m_data->GetEntityBN(_T("apl_rasc_change_log")));
	CHECK_ZERO_ATTR(a_rasc_chng_log_pdf,                       m_data->GetAttrDefinition(e_rasc_chng_log, _T("pdf")));
	CHECK_ZERO_ATTR(a_rasc_chng_log_change,                    m_data->GetAttrDefinition(e_rasc_chng_log, _T("change")));
	CHECK_ZERO_ATTR(a_rasc_chng_log_position,                  m_data->GetAttrDefinition(e_rasc_chng_log, _T("position")));
	CHECK_ZERO_ATTR(a_rasc_chng_log_shop,                      m_data->GetAttrDefinition(e_rasc_chng_log, _T("shop")));
	CHECK_ZERO_ATTR(a_rasc_chng_log_date,                      m_data->GetAttrDefinition(e_rasc_chng_log, _T("date")));

	CHECK_ZERO_ATTR(e_stock_introd_signal,                     m_data->GetEntityBN(_T("apl_stock_introd_signal")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_pdf,                   m_data->GetAttrDefinition(e_stock_introd_signal, _T("pdf")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_stock_introd,          m_data->GetAttrDefinition(e_stock_introd_signal, _T("stock_introd")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_event_number,          m_data->GetAttrDefinition(e_stock_introd_signal, _T("event_number")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_blank_changed,         m_data->GetAttrDefinition(e_stock_introd_signal, _T("blank_changed")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_change,                m_data->GetAttrDefinition(e_stock_introd_signal, _T("change")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_pdf_from,              m_data->GetAttrDefinition(e_stock_introd_signal, _T("pdf_from")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_stock_introd_series,   m_data->GetAttrDefinition(e_stock_introd_signal, _T("stock_introd_series")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_rasc,                  m_data->GetAttrDefinition(e_stock_introd_signal, _T("rasc")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_signal_number,         m_data->GetAttrDefinition(e_stock_introd_signal, _T("signal_number")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_notes,                 m_data->GetAttrDefinition(e_stock_introd_signal, _T("notes")));
	CHECK_ZERO_ATTR(a_stock_intr_signal_production_series,     m_data->GetAttrDefinition(e_stock_introd_signal, _T("production_series")));

	CHECK_ZERO_ATTR(e_apl_introd_change_by_shop,               m_data->GetEntityBN(_T("apl_introduction_change_by_shop")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_tech,                m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_tech")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_master,              m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_master")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_pdb,                 m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_pdb")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_btk,                 m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_btk")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_tech,              m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_tech")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_master,            m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_master")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_pdb,               m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_pdb")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_btk,               m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_btk")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_customer,          m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_customer")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_is_printed,               m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("is_printed")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_date,                     m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_change,                   m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("change")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_shop,                     m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("shop")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_short_descr,              m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("short_descr")));	
	CHECK_ZERO_ATTR(a_intr_chng_shop_result_check,             m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("result_check")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_tech_date,           m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_tech_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_master_date,         m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_master_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_pdb_date,            m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_pdb_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_view_btk_date,            m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("view_btk_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_tech_date,         m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_tech_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_master_date,       m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_master_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_pdb_date,          m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_pdb_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_introd_btk_date,          m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("introd_btk_date")));
	CHECK_ZERO_ATTR(a_intr_chng_shop_result_check_date,        m_data->GetAttrDefinition(e_apl_introd_change_by_shop, _T("result_check_date")));

	CHECK_ZERO_ATTR(e_apl_chng_rel,                            m_data->GetEntityBN(_T("apl_change_relation")));
	CHECK_ZERO_ATTR(a_chng_rel_related,                        m_data->GetAttrDefinition(e_apl_chng_rel, _T("related")));
	CHECK_ZERO_ATTR(a_chng_rel_relating,                       m_data->GetAttrDefinition(e_apl_chng_rel, _T("relating")));
	
	e_chng_item= m_api->m_data.GetEntityBN(_T("apl_changed_item"));
	a_chng_item_id= m_api->m_data.GetAttrDefinition(e_chng_item, _T("id"));
	a_chng_item_name= m_api->m_data.GetAttrDefinition(e_chng_item, _T("name"));
	a_chng_item_dscr= m_api->m_data.GetAttrDefinition(e_chng_item, _T("description"));
	a_chng_item_notes= m_api->m_data.GetAttrDefinition(e_chng_item, _T("notes"));
	a_chng_item_basis= m_api->m_data.GetAttrDefinition(e_chng_item, _T("basis"));
	a_chng_item_stock= m_api->m_data.GetAttrDefinition(e_chng_item, _T("stock"));
	a_chng_item_attachment= m_api->m_data.GetAttrDefinition(e_chng_item, _T("attachment"));
 	a_chng_item_autor= m_api->m_data.GetAttrDefinition(e_chng_item, _T("autor"));
 	a_chng_item_user= m_api->m_data.GetAttrDefinition(e_chng_item, _T("user"));
 	a_chng_item_accept_date= m_api->m_data.GetAttrDefinition(e_chng_item, _T("accept_date"));
	a_chng_item_of_chng= m_api->m_data.GetAttrDefinition(e_chng_item, _T("of_change"));
	a_chng_item_item= m_api->m_data.GetAttrDefinition(e_chng_item, _T("item_of_basis"));
	a_chng_item_replace_state= m_api->m_data.GetAttrDefinition(e_chng_item, _T("replace_state"));
	
	e_basis_item= m_api->m_data.GetEntityBN(_T("apl_basis_item"));
	a_basis_item_parent= m_api->m_data.GetAttrDefinition(e_basis_item, _T("parent_basis"));
	a_basis_item_old_rasc= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_rasc")); 
	a_basis_item_new_rasc= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_rasc"));
	a_basis_item_old_count= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_count"));
	a_basis_item_new_count= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_count"));
	a_basis_item_old_unit= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_unit"));
	a_basis_item_new_unit= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_unit"));
	a_basis_item_old_mat= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_mat"));
	a_basis_item_new_mat= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_mat"));
	a_basis_item_pdf= m_api->m_data.GetAttrDefinition(e_basis_item, _T("pdf"));
	a_basis_item_pdr= m_api->m_data.GetAttrDefinition(e_basis_item, _T("pdr"));
	a_basis_item_old_cust= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_customer"));
	a_basis_item_new_cust= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_customer"));	
	a_basis_item_old_gab= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_gabarit"));
	a_basis_item_new_gab= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_gabarit"));
	a_basis_item_old_fw= m_api->m_data.GetAttrDefinition(e_basis_item, _T("old_from_waste"));
	a_basis_item_new_fw= m_api->m_data.GetAttrDefinition(e_basis_item, _T("new_from_waste"));	
	a_basis_item_mat_owner= m_api->m_data.GetAttrDefinition(e_basis_item, _T("mat_owner"));
	a_basis_item_rasc_owner= m_api->m_data.GetAttrDefinition(e_basis_item, _T("rasc_owner"));
	
	e_psc= m_api->m_data.GetEntityBN(_T("apl_product_structure_change"));
	a_psc_changed_product= m_api->m_data.GetAttrDefinition(e_psc, _T("changed_product"));
	a_psc_changing_product= m_api->m_data.GetAttrDefinition(e_psc, _T("changing_product"));
	a_psc_value= m_api->m_data.GetAttrDefinition(e_psc, _T("value"));
	a_psc_unit= m_api->m_data.GetAttrDefinition(e_psc, _T("unit"));
	a_psc_eff_type= m_api->m_data.GetAttrDefinition(e_psc, _T("effectivity_type"));
	a_psc_start_date= m_api->m_data.GetAttrDefinition(e_psc, _T("start_date"));
	a_psc_end_date= m_api->m_data.GetAttrDefinition(e_psc, _T("end_date"));
	a_psc_start_num= m_api->m_data.GetAttrDefinition(e_psc, _T("start_number"));
	a_psc_end_num= m_api->m_data.GetAttrDefinition(e_psc, _T("end_number"));
	a_psc_addit = m_api->m_data.GetAttrDefinition(e_psc, _T("additional"));
	a_psc_position= m_api->m_data.GetAttrDefinition(e_psc, _T("position"));
	a_psc_position_num= m_api->m_data.GetAttrDefinition(e_psc, _T("position_number"));
	a_psc_frames_of_reference= m_api->m_data.GetAttrDefinition(e_psc, _T("apl_frames_of_reference"));
	a_psc_cancel_set= m_api->m_data.GetAttrDefinition(e_psc, _T("canceled_effectivities"));
	a_psc_add_set= m_api->m_data.GetAttrDefinition(e_psc, _T("added_effectivities"));
	a_psc_modif_set= m_api->m_data.GetAttrDefinition(e_psc, _T("modified_effectivities"));
	a_psc_created_pdr= m_api->m_data.GetAttrDefinition(e_psc, _T("created_pdr"));
	
	e_mat= m_api->m_data.GetEntityBN(_T("apl_material_change"));
	a_mat_renking= m_api->m_data.GetAttrDefinition(e_mat, _T("ranking"));
	a_mat_der_value= m_api->m_data.GetAttrDefinition(e_mat, _T("derive_value"));
	a_mat_der_unit= m_api->m_data.GetAttrDefinition(e_mat, _T("derive_unit"));
	a_mat_assort= m_api->m_data.GetAttrDefinition(e_mat, _T("assortment"));
	a_mat_size= m_api->m_data.GetAttrDefinition(e_mat, _T("billet_size"));
	a_mat_requir= m_api->m_data.GetAttrDefinition(e_mat, _T("requirements"));

	e_avc= m_api->m_data.GetEntityBN(_T("apl_document_change_item"));
	a_avc_new_rev= m_api->m_data.GetAttrDefinition(e_avc, _T("new_revision"));
	a_avc_old_rev= m_api->m_data.GetAttrDefinition(e_avc, _T("old_revision"));
	a_avc_doc= m_api->m_data.GetAttrDefinition(e_avc, _T("document"));
	a_avc_method= m_api->m_data.GetAttrDefinition(e_avc, _T("method"));
	a_avc_items_for_add_relation= m_api->m_data.GetAttrDefinition(e_avc, _T("items_for_add_relation"));
	a_avc_items_for_del_relation= m_api->m_data.GetAttrDefinition(e_avc, _T("items_for_del_relation"));

	e_abpc= m_api->m_data.GetEntityBN(_T("apl_business_process_change"));
	a_abpc_new_rev= m_api->m_data.GetAttrDefinition(e_abpc, _T("new_revision"));
	a_abpc_old_rev= m_api->m_data.GetAttrDefinition(e_abpc, _T("old_revision"));
	a_abpc_bp= m_api->m_data.GetAttrDefinition(e_abpc, _T("business_process"));

	e_char_change= m_api->m_data.GetEntityBN(_T("apl_characteristic_change_item"));
	a_char_change_new_rev= m_api->m_data.GetAttrDefinition(e_char_change, _T("new_revision"));
	a_char_change_old_rev= m_api->m_data.GetAttrDefinition(e_char_change, _T("old_revision"));
	a_char_change_val= m_api->m_data.GetAttrDefinition(e_char_change, _T("characteristic"));
	
	e_cmf_change_item=m_api->m_data.GetEntityBN(_T("apl_component_make_from_change_item"));
	a_cmf_comp_mf=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("comp_mf"));
	a_cmf_pdf=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("product_defnintion"));
	a_cmf_mat=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("material"));
	a_cmf_unit=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("unit"));
	a_cmf_value=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("value"));
	a_cmf_derived_unit=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("derived_unit"));
	a_cmf_derived_value=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("derived_value"));
	a_cmf_type_id=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("type_id"));
	a_cmf_type=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("type"));
	a_cmf_descr=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("description"));
	a_cmf_id=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("id"));
	a_cmf_author=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("author"));
	a_cmf_new_mat=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_material"));
	a_cmf_new_unit=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_unit"));
	a_cmf_new_value=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_value"));
	a_cmf_new_derived_unit=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_derived_unit"));
	a_cmf_new_derived_value=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_derived_value"));
	a_cmf_new_type_id=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_type_id"));
	a_cmf_new_type=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_type"));
	a_cmf_new_descr=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_description"));
	a_cmf_new_id=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("new_id"));
	a_cmf_of_change=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("of_change"));
	a_cmf_action=m_api->m_data.GetAttrDefinition(e_cmf_change_item, _T("action"));

	e_cmf_chng=m_api->m_data.GetEntityBN(_T("apl_component_make_from_change"));
	a_cmf_chng_of_change=m_api->m_data.GetAttrDefinition(e_cmf_chng, _T("of_change"));
	a_cmf_chng_items=m_api->m_data.GetAttrDefinition(e_cmf_chng, _T("items"));

	e_cmf_char_ch_item=m_api->m_data.GetEntityBN(_T("apl_component_make_from_characteristic_change_item"));
	a_cmf_char_ch_of_change=m_api->m_data.GetAttrDefinition(e_cmf_char_ch_item, _T("of_change"));
	a_cmf_char_ch_pdf=m_api->m_data.GetAttrDefinition(e_cmf_char_ch_item, _T("product_definition"));
	a_cmf_char_ch_old_rev=m_api->m_data.GetAttrDefinition(e_cmf_char_ch_item, _T("old_revision"));
	a_cmf_char_ch_new_rev=m_api->m_data.GetAttrDefinition(e_cmf_char_ch_item, _T("new_revision"));
	a_cmf_char_ch_char=m_api->m_data.GetAttrDefinition(e_cmf_char_ch_item, _T("characteristic"));

	CHECK_ZERO_ATTR(e_order_directive,                         m_data->GetEntityBN(_T("apl_order_directive")));
	CHECK_ZERO_ATTR(a_order_directive_numbers,                 m_data->GetAttrDefinition(e_order_directive, _T("numbers")));
	CHECK_ZERO_ATTR(a_order_directive_org,                     m_data->GetAttrDefinition(e_order_directive, _T("org")));
	CHECK_ZERO_ATTR(a_order_directive_id,                      m_data->GetAttrDefinition(e_order_directive, _T("id")));
	CHECK_ZERO_ATTR(a_order_directive_name,                    m_data->GetAttrDefinition(e_order_directive, _T("name")));
	CHECK_ZERO_ATTR(a_order_directive_description,             m_data->GetAttrDefinition(e_order_directive, _T("description")));

	CHECK_ZERO_ATTR(e_order_number,                            m_data->GetEntityBN(_T("apl_order_number")));
	CHECK_ZERO_ATTR(a_order_number_directive,                  m_data->GetAttrDefinition(e_order_number, _T("directive")));
	CHECK_ZERO_ATTR(a_order_number_id,                         m_data->GetAttrDefinition(e_order_number, _T("id")));

	return true;
}

void CaplChangeManager::Detach()
{
	e_chng= 0;
	a_chng_id= 0;
	a_chng_name= 0;
	a_chng_dscr= 0;
	a_chng_user= 0;
	a_chng_autor= 0;
	a_chng_apply_date= 0;
	a_chng_items= 0;
	a_chng_basis= 0;
	a_chng_stock= 0;
	a_chng_stock_ceh= 0;
	a_chng_asm_pdf =0;
	a_chng_create_user= 0;
	a_chng_create_autor= 0;
	a_chng_create_date= 0;
	a_chng_changed_assemlies= 0;
	a_chng_eff_type= 0;
	a_chng_start_date= 0;
	a_chng_end_date= 0;
	a_chng_start_num= 0;
	a_chng_end_num= 0;
	a_chng_export_num = 0;
	a_chng_order_directive = 0;
	a_chng_user = 0;
	a_chng_event_number = 0;
	a_chng_rejection_reason = 0;
	a_chng_helicopter_usage = 0;
	a_chng_handmade_copy = 0;
	a_chng_plan_lead_date = 0;
	a_chng_date_of = 0;
	a_chng_usage_ing = 0;
	a_chng_base=0;
	a_chng_src_pi=0;
	a_chng_urgency=0;
	a_chng_issue_date=0;	
	a_chng_validity_pi_date=0;
	a_chng_notice=0;
	a_chng_dependent_items=0;

	e_apl_chng_rel = 0;
	a_chng_rel_related = 0;
	a_chng_rel_relating = 0;

	e_rasc_chng_log = 0;
	a_rasc_chng_log_pdf = 0;
	a_rasc_chng_log_change = 0;
	a_rasc_chng_log_position = 0;
	a_rasc_chng_log_shop = 0;
	a_rasc_chng_log_date = 0;

	e_stock_introd_signal = 0;
	a_stock_intr_signal_pdf = 0;
	a_stock_intr_signal_stock_introd = 0;
	a_stock_intr_signal_event_number = 0;
	a_stock_intr_signal_blank_changed = 0;
	a_stock_intr_signal_change = 0;
	a_stock_intr_signal_pdf_from = 0;
	a_stock_intr_signal_stock_introd_series = 0;
	a_stock_intr_signal_rasc = 0;
	a_stock_intr_signal_signal_number = 0;
	a_stock_intr_signal_notes = 0;
	a_stock_intr_signal_production_series = 0;

	e_apl_introd_change_by_shop = 0;
	a_intr_chng_shop_view_tech = 0;
	a_intr_chng_shop_view_master = 0;
	a_intr_chng_shop_view_pdb = 0;
	a_intr_chng_shop_view_btk = 0;
	a_intr_chng_shop_introd_tech = 0;
	a_intr_chng_shop_introd_master = 0;
	a_intr_chng_shop_introd_pdb = 0;
	a_intr_chng_shop_introd_btk = 0;
	a_intr_chng_shop_introd_customer = 0;
	a_intr_chng_shop_is_printed = 0;
	a_intr_chng_shop_date = 0;
	a_intr_chng_shop_change = 0;
	a_intr_chng_shop_shop = 0;
	a_intr_chng_shop_short_descr = 0;
	a_intr_chng_shop_result_check = 0;
	a_intr_chng_shop_view_tech_date = 0;
	a_intr_chng_shop_view_master_date = 0;
	a_intr_chng_shop_view_pdb_date = 0;
	a_intr_chng_shop_view_btk_date = 0;
	a_intr_chng_shop_introd_tech_date = 0;
	a_intr_chng_shop_introd_master_date = 0;
	a_intr_chng_shop_introd_pdb_date = 0;
	a_intr_chng_shop_introd_btk_date = 0;
	a_intr_chng_shop_result_check_date = 0;

	e_chng_item= 0;
	a_chng_item_basis= 0;
	a_chng_item_notes= 0;
	a_chng_item_stock= 0;
	a_chng_item_id= 0;
	a_chng_item_name= 0;
	a_chng_item_dscr= 0;
	a_chng_item_attachment= 0;
 	a_chng_item_autor= 0;
 	a_chng_item_user= 0;
 	a_chng_item_accept_date= 0;
	a_chng_item_of_chng= 0;
	a_chng_item_item= 0;
	a_chng_item_replace_state= 0;	

	e_basis_item= 0;
	a_basis_item_old_rasc= 0;
	a_basis_item_new_rasc= 0;
	a_basis_item_old_count= 0;
	a_basis_item_new_count= 0;
	a_basis_item_old_unit= 0;
	a_basis_item_new_unit= 0;
	a_basis_item_pdf= 0;
	a_basis_item_parent= 0;
	
	e_psc= 0;
	a_psc_changed_product= 0;
	a_psc_changing_product= 0;
	a_psc_position= 0;
	a_psc_position_num= 0;
	a_psc_frames_of_reference= 0;
	a_psc_value= 0;
	a_psc_unit= 0;
	a_psc_eff_type= 0;
	a_psc_start_date= 0;
	a_psc_end_date= 0;	
	a_psc_start_num= 0;
	a_psc_end_num= 0;	
	a_psc_addit = 0;
	a_psc_cancel_set= 0;
	a_psc_add_set= 0;
	a_psc_modif_set= 0;
	a_psc_created_pdr= 0;

	e_avc= 0;
	a_avc_new_rev= 0;
	a_avc_old_rev= 0;
	a_avc_doc = 0;
	a_avc_method = 0;
	a_avc_items_for_add_relation=0;
	a_avc_items_for_add_relation=0;

	e_abpc=0;
	a_abpc_new_rev=0;
	a_abpc_old_rev=0;
	a_abpc_bp=0;

	e_char_change = 0;
	a_char_change_new_rev = 0;
	a_char_change_old_rev = 0;
	a_char_change_val = 0;

	e_order_directive = 0;        
	a_order_directive_numbers = 0;
	a_order_directive_org = 0;
	a_order_directive_id = 0;    
	a_order_directive_name = 0;     
	a_order_directive_description = 0;

	e_order_number = 0;
	a_order_number_directive = 0;
	a_order_number_id = 0; 
}

CaplInstance *CaplChangeManager::FindRepaymentChange(CaplInstance *pi_change)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return NULL;
	if(0==pi_change) return 0;
	if(pi_change->IsDeleted()) return 0;
	if(pi_change->GetAccessmode()>=aplRO) {AfxMessageBox(S::NoAccessRight(),MB_OK|MB_ICONSTOP); return 0;}

	CaplAttrValue find_values[4];
	aplExtent ext;

	find_values[0].value.Set(pi_change);
	find_values[0].attr= a_chng_src_pi;
	m_api->m_data.NET_FindInstancesWithAttrValues(e_chng, 1, &find_values[0], ext, true);


	if(0==ext.GetSize()) return 0;
	if(ext.GetSize()>1 && m_api->m_ModeInteractive)
	{
		CString buf;
		buf.Format(APL_T(" %i  ,    !"),ext.GetSize());
		AfxMessageBox(buf,MB_ICONWARNING|MB_OK);
	}

	return ext[0];
}
//*********************************************************************************
CaplInstance* CaplChangeManager::CreateLinkedChange(CaplInstance *old_change)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return NULL;
	if(0==old_change) return 0;
	if(old_change->IsDeleted()) return 0;
	if(old_change->GetAccessmode()>=aplRO) {AfxMessageBox(S::NoAccessRight(),MB_OK|MB_ICONSTOP); return 0;}

	LoadChangeInfo(old_change);

	CString sState1,sId;
	m_api->m_data.GetAttr(old_change, m_api->m_change_mgr.a_chng_state, sState1);
	if(sState1==_T("applied")) {AfxMessageBox(APL_T("  ,   !"),MB_OK|MB_ICONSTOP); return 0; }

	aplExtent ext;
	m_api->m_data.GetAttr(old_change, m_api->m_change_mgr.a_chng_id, sId);
	CaplInstance *new_change=m_api->m_change_mgr.CreateChange(sId,0,0,0,0,ext,0);

	if(0==new_change) return 0;

	// 
	CString sGroupCode;
	m_api->m_data.GetAttr(old_change, m_api->m_change_mgr.a_chng_group_id, sGroupCode);
	if(sGroupCode==_T(""))
	{
		CaplAPI::CreateGuid(sGroupCode);
		if(sGroupCode==_T("")) {AfxMessageBox(APL_T("  GUID!    !"),MB_OK|MB_ICONSTOP); return new_change; }
		m_api->m_data.PutAttr(old_change, m_api->m_change_mgr.a_chng_group_id, sGroupCode);
	}
	m_api->m_data.PutAttr(new_change, m_api->m_change_mgr.a_chng_group_id, sGroupCode);

	m_api->SaveChanges();

	return new_change;
}
//*********************************************************************************
CaplInstance* CaplChangeManager::CreateRepaymentChange(CaplInstance *pi_change)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return NULL;
	if(0==pi_change) return 0;
	if(pi_change->IsDeleted()) return 0;
	if(pi_change->GetAccessmode()>=aplRO) {AfxMessageBox(S::NoAccessRight(),MB_OK|MB_ICONSTOP); return 0;}

	LoadChangeInfo(pi_change);

	CString m_sType;
	m_api->m_data.GetAttr(pi_change, a_chng_type, m_sType);
	if(m_sType!=APL_T("")) {AfxMessageBox(APL_T("      !"),MB_ICONWARNING|MB_OK); return 0;}

	CaplInstance *rep_chng=FindRepaymentChange(pi_change);
	if(0!=rep_chng) {AfxMessageBox(APL_T("   !"),MB_ICONWARNING|MB_OK); return 0;}

	CString sNewId;
	m_api->m_change_mgr.GenerateChangeId(sNewId);

	while(true)
	{
		if(!aplInputStrValue(APL_T("    "),APL_T(" "),sNewId)) return 0;
		if(sNewId==_T("")) {AfxMessageBox(APL_T("  !"),MB_ICONSTOP|MB_OK); continue;}

		CaplAttrValue find_values[2];
		aplExtent ext;

		find_values[0].value.Set(sNewId);
		find_values[0].attr= a_chng_id;
		m_api->m_data.NET_FindInstancesWithAttrValues(e_chng, 1, &find_values[0], ext, true);

		if(ext.GetSize()>0) {AfxMessageBox(APL_T("       !"),MB_ICONSTOP|MB_OK); continue;}

		break;
	}
	//     
	CString buf,sCurDate;
	COleDateTime odt; 	m_api->m_data.NET_GetServerDateTime(odt); 	aplDate2String(odt,sCurDate);

	CaplInstance* change = m_api->m_data.CreateInstance(e_chng);
	m_api->m_data.PutAttr(change, a_chng_id, sNewId);
	m_api->m_data.PutAttr(change, a_chng_type, APL_T(""));
	m_api->m_data.PutAttr(change, a_chng_src_pi, pi_change);
	m_api->m_data.PutAttr(change, a_chng_state, _T("not_applied"));
	m_api->GetItemName(m_api->m_data.GetCurrUser(), buf);
	m_api->m_data.PutAttr(change, a_chng_create_user, buf);
	m_api->m_data.PutAttr(change, a_chng_create_autor, m_api->m_appr_mgr.GetCurrentPerson());
	m_api->m_data.PutAttr(change, a_chng_create_date, sCurDate);
	m_api->m_data.PutAttr(change, a_chng_is_modify, false);

	m_api->m_data.GetAttr(pi_change, a_chng_name, buf);
	m_api->m_data.PutAttr(change, a_chng_name, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_dscr, buf);
	m_api->m_data.PutAttr(change, a_chng_dscr, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_basis, buf);
	m_api->m_data.PutAttr(change, a_chng_basis, buf);
	
	m_api->m_data.GetAttr(pi_change, a_chng_stock, buf);
	m_api->m_data.PutAttr(change, a_chng_stock, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_stock_ceh, buf);
	m_api->m_data.PutAttr(change, a_chng_stock_ceh, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_issue_date, buf);
	m_api->m_data.PutAttr(change, a_chng_issue_date, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_org_code, buf);
	m_api->m_data.PutAttr(change, a_chng_org_code, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_doc_id, buf);
	m_api->m_data.PutAttr(change, a_chng_doc_id, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_usage, buf);
	m_api->m_data.PutAttr(change, a_chng_usage, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_complect_num, buf);
	m_api->m_data.PutAttr(change, a_chng_complect_num, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_list, buf);
	m_api->m_data.PutAttr(change, a_chng_list, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_stock_introd, buf);
	m_api->m_data.PutAttr(change, a_chng_stock_introd, buf);	

	m_api->m_data.GetAttr(pi_change, a_chng_to_date, buf);
	m_api->m_data.PutAttr(change, a_chng_to_date, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_usage, buf);
	m_api->m_data.PutAttr(change, a_chng_usage, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_basis_code, buf);
	m_api->m_data.PutAttr(change, a_chng_basis_code, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_complect_num, buf);
	m_api->m_data.PutAttr(change, a_chng_complect_num, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_otd_date, buf);
	m_api->m_data.PutAttr(change, a_chng_otd_date, buf);

	m_api->m_data.GetAttr(pi_change, a_chng_critical_date, buf);
	m_api->m_data.PutAttr(change, a_chng_critical_date, buf);

	//m_api->m_data.GetAttr(pi_change, , buf);
	//m_api->m_data.PutAttr(change, , buf);

	//m_api->m_data.PutAttr(change, a_chng_grp_num, sGrpNum);

	//  

	int i,j,k;
	aplExtent ext_items, ext_pi_items,ext_atachment, ext_pi_atachment;
	CaplInstance *item, *pi_item;
	CaplValue *pVal;

	m_api->m_data.GetAttr(pi_change, a_chng_items, ext_pi_items);
	for(i=0;i<ext_pi_items.GetSize();i++)
	{
		pi_item=ext_pi_items[i];
		CaplEntity *ent=pi_item->GetType();
		item=m_api->m_data.CreateInstance(ent);
		ext_items.Add(item);
		m_api->m_data.PutAttr(item, a_chng_item_of_chng, change);
		for(j=0;j<ent->all_attrs.GetSize();j++)
		{
			CaplAttr *attr=ent->all_attrs[j];
			if(attr==a_chng_item_of_chng || attr==a_chng_item_attachment
				|| attr==a_chng_item_attachment || attr==a_chng_item_autor
				|| attr==a_chng_item_user || attr==a_chng_item_of_chng
				|| attr==a_avc_old_rev || attr==a_abpc_old_rev
				|| attr==a_psc_cancel_set || attr==a_psc_created_pdr 
				|| attr==a_psc_modif_set || attr==a_psc_add_set
				) continue;

			m_api->m_data.GetAttr(pi_item,attr,&pVal);
			if(0!=pVal)	m_api->m_data.PutAttr(item,attr,*pVal);
		}

		//  
		m_api->m_data.GetAttr(pi_item,a_chng_item_attachment,ext_pi_atachment);
		ext_atachment.Clear();
		for(k=0;k<ext_pi_atachment.GetSize();k++)
		{
			CaplInstance *inst0=ext_pi_atachment[k];
			CaplEntity *ent=inst0->GetType();
			CaplInstance *inst1=m_api->m_data.CreateInstance(ent);
			ext_atachment.Add(inst1);
			int j;
			for(j=0;j<ent->all_attrs.GetSize();j++)
			{
				CaplAttr *attr=ent->all_attrs[j];
				if(attr==m_api->m_doc_mgr.a_apl_stored_document_source)
				{
					long blob_size;
					if(m_api->m_data.NET_GetBlobSize(inst0,attr,blob_size))
					{
						if(blob_size>0)
						{
							BYTE *membuf=new BYTE[blob_size];
							m_api->m_data.NET_LoadBlob2Memory(inst0,attr,membuf,blob_size);
							long code=0;
							m_api->m_data.NET_SaveFileFromMemory(inst1,attr,membuf,blob_size,code);
							delete membuf;
						}
					}
				}
				else
				{
					m_api->m_data.GetAttr(inst0,attr,&pVal);
					m_api->m_data.PutAttr(inst1,attr,*pVal);
				}
			}
		}
		if(ext_atachment.GetSize()>0) m_api->m_data.PutAttr(item,a_chng_item_attachment,ext_atachment);
	}
	m_api->m_data.PutAttr(change, a_chng_items, ext_items);

	//aplExtent ext_items;
	//rep_chng=CreateChange(0,0,0,0,0,ext_items,pi_change,true);
	m_api->SaveChanges();

	CString csAccPat;
	aplExtent aet; aet.Add(change);
	if (TRUE == m_api->m_options_mgr.GetDefPatern(e_chng, csAccPat))
		apidata.NET_SetAccessFromPattern(&aet, csAccPat);

	return change;
}


CaplInstance* CaplChangeManager::CreateChange(const TCHAR* id, const TCHAR* name, const TCHAR* dscr,
	const TCHAR* user, CaplInstance* person, aplExtent &chngItems, CaplInstance *base_change)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return NULL;

	int i, j;
	CString sId, sName, sDscr, sUser, sBasis, sStock,sStock_ceh, buf, buf1, sDate, sUrgency,sIssue_date, sValidity_pi_date,sType;
	CString sOrgCode, sOrgName, sGrpNum, sDocId;
	CString sBasisCode, sUsage, sComplNum, sList, sStockIntr, sTOdate;
	CString sOTDdate, sCritDate;
	CaplInstance* inst= NULL;
	CaplAggr aggr0;
	aplExtent  aggr;
	COleDateTime odt;
	CString sCurrDate;
	aplExtent dependent_items;
	
	m_api->m_data.NET_GetServerDateTime(odt);
	aplDate2String(odt, sCurrDate);

	if(!person)
		person= m_api->m_appr_mgr.GetCurrentPerson();

	bool bShowDlg = false;
	if (id == NULL || name == NULL)
		bShowDlg = true;

	if (0 == chngItems.GetSize())
		bShowDlg = true;

	sUser = user;
	if (sUser.IsEmpty())
		sUser = m_api->m_data.GetNameCurrUser();
	

	if (bShowDlg)
	{
		CaplSetResourceHandle setres(module_inst);
		
		CChangeDlg dlg;
		dlg.m_api = m_api;

		dlg.m_sId=id;

		if(0!=base_change)
		{
			m_api->m_data.GetAttr(base_change, a_chng_id, dlg.m_sId);
			m_api->m_data.GetAttr(base_change, a_chng_name, dlg.m_sName);
			m_api->m_data.GetAttr(base_change, a_chng_dscr, dlg.m_sDscr);
			m_api->m_data.GetAttr(base_change, a_chng_items, dlg.m_sStock);
			m_api->m_data.GetAttr(base_change, a_chng_type, dlg.m_sType);
			
			if(dlg.m_sType==APL_T("")) {dlg.m_sType=APL_T(""); dlg.m_sId+=APL_T("");}
			else if(dlg.m_sType==APL_T("")) {dlg.m_sType=APL_T(""); dlg.m_sId.Replace(APL_T(""),APL_T(""));};
			
			m_api->m_data.GetAttr(base_change, a_chng_basis, dlg.m_sBasis);
			m_api->m_data.GetAttr(base_change, a_chng_stock, dlg.m_sStock);
			m_api->m_data.GetAttr(base_change, a_chng_stock_ceh, dlg.m_sStock_ceh);
			//m_api->m_data.GetAttr(base_change, a_chng_urgency, dlg.m_sUrgency);
			m_api->m_data.GetAttr(base_change, a_chng_issue_date, dlg.m_sIssue_date);
			m_api->m_data.GetAttr(base_change, a_chng_validity_pi_date, dlg.m_sValidity_pi_date);

			m_api->m_data.GetAttr(base_change, a_chng_org_code,  dlg.m_sOrgCode);
			m_api->m_data.GetAttr(base_change, a_chng_grp_num,  dlg.m_sGrpNum);
			m_api->m_data.GetAttr(base_change, a_chng_doc_id, dlg.m_sDocId);
			m_api->m_data.GetAttr(base_change, a_chng_basis_code, dlg.m_sBasisCode);
			m_api->m_data.GetAttr(base_change, a_chng_usage, dlg.m_sUsage);
			m_api->m_data.GetAttr(base_change, a_chng_complect_num, dlg.m_sComplNum);
			m_api->m_data.GetAttr(base_change, a_chng_list, dlg.m_sList);
			m_api->m_data.GetAttr(base_change, a_chng_stock_introd, dlg.m_sStockIntr);
			m_api->m_data.GetAttr(base_change, a_chng_to_date, dlg.m_sTOdate);
			m_api->m_data.GetAttr(base_change, a_chng_otd_date, dlg.m_sOTDdate);
			m_api->m_data.GetAttr(base_change, a_chng_critical_date, dlg.m_sCritDate);
		}

		if (IDOK == dlg.DoModal())
		{
			sId		= dlg.m_sId;
			sName	= dlg.m_sName;
			sDscr	= dlg.m_sDscr;
			sStock	= dlg.m_sStock;
			sStock_ceh	= dlg.m_sStock_ceh;
			sBasis	= dlg.m_sBasis;
			sOrgCode= dlg.m_sOrgCode;
			sGrpNum= dlg.m_sGrpNum;
			sDocId= dlg.m_sDocId;
			sBasisCode= dlg.m_sBasisCode;
			sUsage= dlg.m_sUsage;
			sComplNum= dlg.m_sComplNum;
			sList= dlg.m_sList;
			sStockIntr= dlg.m_sStockIntr;
			sTOdate= dlg.m_sTOdate;
			sOTDdate= dlg.m_sOTDdate;
			sCritDate= dlg.m_sCritDate;
			sUrgency= dlg.m_sUrgency;
			sIssue_date= dlg.m_sIssue_date;
			sValidity_pi_date= dlg.m_sValidity_pi_date;
			sType=dlg.m_sType;

			dependent_items=dlg.m_dependent_items;


			for (j = 0; j < dlg.m_items.GetSize(); j++)
				aggr.Add(dlg.m_items[j]);
			
			for (j = 0; j < dlg.m_docs.GetSize(); j++)
				aggr.Add(dlg.m_docs[j]);

			for (j = 0; j < dlg.m_bps.GetSize(); j++)
				aggr.Add(dlg.m_bps[j]);

			for (j = 0; j < dlg.m_maters.GetSize(); j++)
				aggr.Add(dlg.m_maters[j]);

			for (j = 0; j < dlg.m_chars.GetSize(); j++)
				aggr.Add(dlg.m_chars[j]);

			//odt.SetDateTime(dlg.m_oleDate.GetYear(), dlg.m_oleDate.GetMonth(), dlg.m_oleDate.GetDay(),
			//	dlg.m_oleTime.GetHour(), dlg.m_oleTime.GetMinute(), dlg.m_oleTime.GetSecond());

			aplDate2String(odt, sDate);
		}
		else 
		{
			return NULL;
		}
	}
	else
	{
		CaplAttrValue find_vals[4];
		find_vals[0].attr= a_chng_id;
		find_vals[0].value.Set(id);

		aplExtent result;

		m_api->m_data.NET_FindInstancesWithAttrValues2(e_chng, 1, &find_vals[0], result, false, false,0,aplSBMiddle,false,DEF_SOURCE);
		if(result.GetSize())
		{
			if(m_api->m_ModeInteractive)
				AfxMessageBox( APL_T("     ."), MB_OK, MB_ICONERROR);
			return NULL;
		}

		sId		= id;
		sName	= name;
		sDscr	= dscr;
		sUser	= user;
		sStock=_T("");
		sBasis=_T("");

		for (i = 0; i<chngItems.GetSize(); i++)
			aggr.Add(chngItems[i]);
		
		m_api->m_data.NET_GetServerDateTime(odt);
		aplDate2String(odt, sDate);
	}
	
	CaplInstance* change = m_api->m_data.CreateInstance(e_chng);
	if (change)
	{
		m_api->m_data.PutAttr(change, a_chng_id, sId);
		m_api->m_data.PutAttr(change, a_chng_name, sName);
		m_api->m_data.PutAttr(change, a_chng_dscr, sDscr);
		m_api->m_data.PutAttr(change, a_chng_items, aggr);

		// 
		if(sType==_T(""))
		{
			sId.MakeUpper();
			if(sId.Find(APL_T(""))>0) sType = APL_T("");
			else if(sId.Find(APL_T(""))>0) sType = APL_T("");
			else if(sId.Find(APL_T(""))>0) sType = APL_T("");
			else if(sId.Find(APL_T(""))>0) sType = APL_T("");
			else if(sId.Find(APL_T(""))>0) sType = APL_T("");
			else sType = APL_T("");
		}
		m_api->m_data.PutAttr(change, a_chng_type, sType);

		for (int j = 0; j < aggr.GetSize(); j++)
			if (aggr[j])
				m_api->m_data.PutAttr(aggr[j], a_chng_item_of_chng, change);

		m_api->m_data.PutAttr(change, a_chng_state, _T("not_applied"));
		m_api->m_data.PutAttr(change, a_chng_basis, sBasis);
		m_api->m_data.PutAttr(change, a_chng_stock, sStock);
		m_api->m_data.PutAttr(change, a_chng_stock_ceh, sStock_ceh);
		m_api->m_data.PutAttr(change, a_chng_urgency, sUrgency);
		m_api->m_data.PutAttr(change, a_chng_issue_date, sIssue_date);
		m_api->m_data.PutAttr(change, a_chng_validity_pi_date, sValidity_pi_date);

		m_api->m_data.PutAttr(change, a_chng_create_user, sUser);
		m_api->m_data.PutAttr(change, a_chng_create_autor, person);
		m_api->m_data.PutAttr(change, a_chng_create_date, sCurrDate);
		m_api->m_data.PutAttr(change, a_chng_is_modify, false);

		m_api->m_data.PutAttr(change, a_chng_org_code, sOrgCode);
		m_api->m_data.PutAttr(change, a_chng_grp_num, sGrpNum);
		m_api->m_data.PutAttr(change, a_chng_doc_id, sDocId);
		m_api->m_data.PutAttr(change, a_chng_basis_code, sBasisCode);
		m_api->m_data.PutAttr(change, a_chng_usage, sUsage);
		m_api->m_data.PutAttr(change, a_chng_complect_num, sComplNum);
		m_api->m_data.PutAttr(change, a_chng_list, sList);
		m_api->m_data.PutAttr(change, a_chng_stock_introd, sStockIntr);
		m_api->m_data.PutAttr(change, a_chng_to_date, sTOdate);
		m_api->m_data.PutAttr(change, a_chng_otd_date, sOTDdate);
		m_api->m_data.PutAttr(change, a_chng_critical_date, sCritDate);

		if(0!=base_change)  m_api->m_data.PutAttr(change, a_chng_base, base_change);

		if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T("")))
		{
			m_api->m_data.PutAttr(change, a_chng_dependent_items, dependent_items);
		}


		if(m_api->m_AutoSave) m_api->SaveChanges();
		
		if (true == m_AutoUsurpire)
		{
			CaplEntity*	et = NULL;
			aplExtent	aet;
			CString		csAccPat;

			et = e_chng;

			if (aplOWN == change->GetAccessmode())
				aet.Add(change);

			if (TRUE == m_api->m_options_mgr.GetDefPatern(et, csAccPat))
				apidata.NET_SetAccessFromPattern(&aet, csAccPat);
		}
	}

	return change;
}

bool CaplChangeManager::DeleteChange(CaplInstance* change)
{
	if(m_data==NULL) return false;
	if(change==NULL) return false;
	if(change->GetId()==0) return false;
	if(change->GetType()==0) return false;
	
	if(change->GetAccessmode()>aplOWN)
	{
		AfxMessageBox(S::NoAccessRight(), MB_OK|MB_ICONSTOP);
		return false;
	}

	if (IDNO == AfxMessageBox( APL_T("    ?"), MB_ICONQUESTION|MB_YESNO)) return false;
	
	LoadChangeInfo(change);

	aplExtent items;
	aplExtent baseItems;
	CaplAggr aggr0;
	CaplInstance* blob = NULL;
	int i, j;

	m_api->m_data.GetAttr(change, a_chng_items, items);
	for (i = 0; i < items.GetSize(); i++)
	{
		if (items[i])
		{
			//   -  -
			if (m_api->m_data.IsKindOf(items[i], e_avc) || m_api->m_data.IsKindOf(items[i], e_abpc) ||
				m_api->m_data.IsKindOf(items[i], e_char_change))
			{
				if (items[i]->GetAccessmode() > aplOWN)
					continue;
								
				m_api->m_data.GetAttr(items[i], a_chng_item_attachment, aggr0);
				for (int j = 0; j < aggr0.GetSize(); j++)
				{
					aggr0.GetByIndex(j, blob);
					if (blob)
					{
						m_api->m_data.NET_DeleteBlob(blob, m_api->m_doc_mgr.a_apl_stored_document_source);
						m_api->m_data.DeleteInstance(blob);
					}
				}
			}

			m_api->m_data.GetAttr(items[i], a_chng_item_item, baseItems);
			for(j= 0; j<baseItems.GetSize(); j++)
				m_api->m_data.DeleteInstance(baseItems[j], false);

			m_api->m_data.DeleteInstance(items[i], false);
		}
	}

	//    
	m_api->m_classifier_mgr.DeleteClassifierAssociation(change,0);

	m_api->m_data.DeleteInstance(change);
	if(m_AutoSave)
		m_api->SaveChanges();

	return true;
}

CaplInstance* CaplChangeManager::CreateProductStructureChange(
	const TCHAR* id, const TCHAR* basis, const TCHAR* stock,
	CaplInstance* pdr_or_pd, CaplInstance* pdf, CaplInstance* value, CaplInstance* unit, 
	const TCHAR* effType, const TCHAR* start_cond, const TCHAR* end_cond)
{
	if(!m_data || !m_api->m_data.IsConnected()) return NULL;

	CaplSetResourceHandle setres(module_inst);
	
	

	return NULL;
}

bool CaplChangeManager::SetChangeEffectivity(CaplInstance* change, CString& sEffType, CString& sStartCond, CString& sEndCond)
{
// 	if(!change) return false;
// 	if(!change->GetType()) return false;
	if(!m_api->m_data.IsConnected()) return false;

	CaplSetResourceHandle setres(module_inst);
	CChangeParamDlg dlg;	
	dlg.m_sType= _T("eff_type");
	if(e_chng && m_api->m_data.IsKindOf(change, e_chng))
		dlg.m_change= change;
	dlg.m_api= m_api;
	if(IDOK==dlg.DoModal())
	{
		sEffType= dlg.m_sEffType;
		sStartCond= dlg.m_sStart;
		sEndCond= dlg.m_sEnd;
		return true;
	}
	return false;	
}

int CaplChangeManager::ShowPSCItemProperty(CaplInstance* item)
{
	if(!item) return 0;
	if(!item->GetType()) return 0;
	if(!m_api->m_data.IsConnected()) return 0;

	CaplSetResourceHandle setres(module_inst);
	
	if(m_api->m_data.IsKindOf(item, e_avc))
	{
		CChangeDocVerDlg dlg;
		dlg.m_api= m_api;
		dlg.m_avc = item;
		dlg.DoModal();	
	}
	else if(m_api->m_data.IsKindOf(item, e_psc))
	{
		CChangeParamDlg dlg;
		dlg.m_api= m_api;
		dlg.m_psc= item;
		dlg.m_bReadOnly = true;
		dlg.DoModal();		
	}
	else if(m_api->m_data.IsKindOf(item, e_chng))
	{
		CChangeParamDlg dlg;	
		dlg.m_api= m_api;
		dlg.m_sType= _T("eff_type");
		dlg.m_change= item;
		dlg.DoModal();
	}
	return 1;
}

bool CaplChangeManager::ShowAssemblyChanges(CaplInstance* pdf, CaplInstance* change, aplExtent&newItems)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return false;
	if(pdf==NULL) return false;
	if(pdf->GetId()==0) return false;
	if(pdf->GetType()==0) return false;
	if(change==NULL) return false;
	if(change->GetId()==0) return false;
	if(change->GetType()==0) return false;
	if(!m_api->m_data.IsKindOf(pdf, m_api->m_prd_mgr.e_pdf)) return false;
	if(!m_api->m_data.IsKindOf(change, e_chng)) return false;

	newItems.Clear();
	LoadChangeInfo(change);

	CaplSetResourceHandle setres(module_inst);
	
	aplExtent items, allItems;
	aplExtent delItems;
	int i;
	CArray<CPSCItemInfo, CPSCItemInfo> newPSCItems;
	m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_items, allItems);
	for(i= 0; i<allItems.GetSize(); i++)
		if(m_api->m_data.IsKindOf(allItems[i], e_psc))
			items.Add(allItems[i]);
	
	CChangeAssemblyDlg dlg;
	dlg.m_api= m_api;
	dlg.m_change= change;
	dlg.m_assPdf= pdf;
	dlg.m_items= &items;
	dlg.m_delItems= &delItems;
	dlg.m_newItems= &newPSCItems;

	CString sState;
	bool bReadOnly= false;
	m_api->m_data.GetAttr(change, a_chng_state, sState);
	if(sState!=_T("not_applied"))
	{
		bReadOnly= true;
		dlg.m_bNotShow= FALSE;
	}
	dlg.m_bReadOnly= bReadOnly;

	if(IDOK==dlg.DoModal())
	{
		CaplInstance* newItem= NULL;
		for (i = 0; i < newPSCItems.GetSize(); i++)
		{
			newItem= apidata.CreateInstance(m_api->m_change_mgr.e_psc);
			if (newItem)
			{
				if(newPSCItems[i].m_sId.IsEmpty())
					m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_id, m_api->m_change_mgr.GetPSCId(newPSCItems[i].m_pdr));
				else
					m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_id, newPSCItems[i].m_sId);				
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_name, newPSCItems[i].m_sName);				
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_dscr, newPSCItems[i].m_sDscr);				
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_basis, newPSCItems[i].m_sBasis);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_stock, newPSCItems[i].m_sStock);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_changed_product, newPSCItems[i].m_pdr);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_eff_type, newPSCItems[i].m_sEffType);
				if(newPSCItems[i].m_sEffType==_T("dated"))
				{
					m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_start_date, newPSCItems[i].m_sStartCond);
					m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_end_date, newPSCItems[i].m_sEndCond);
				}
				else if(newPSCItems[i].m_sEffType==_T("numbered"))
				{
					m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_start_num, newPSCItems[i].m_sStartCond);
					m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_end_num, newPSCItems[i].m_sEndCond);				
				}
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_changing_product, newPSCItems[i].m_pdf);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_value, newPSCItems[i].m_value);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_unit, newPSCItems[i].m_unit);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_position, newPSCItems[i].m_sPosition);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_position_num, newPSCItems[i].m_sPositionNum);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_psc_frames_of_reference, newPSCItems[i].m_contexts);
				m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_of_chng, change);

				allItems.Add(newItem);
				newItems.Add(newItem);
			}
		}

		m_api->m_data.PutAttr(change, m_api->m_change_mgr.a_chng_items, allItems);
		m_api->SaveChanges();
	}
	return true;
}

bool CaplChangeManager::GetLinkedChange(CaplInstance* change, aplExtent &ext_linked_chagesext_linked_chages)
{
	ext_linked_chagesext_linked_chages.Clear();
	if(m_data==NULL || !m_api->m_data.IsConnected()) return false;
	if(change==NULL) return false;
	if(change->GetType()==0) return false;

	CString sGroupCode1;
	m_data->GetAttr(change, a_chng_group_id, sGroupCode1);
	if(sGroupCode1==_T("")) return true; //   -  

	CaplAttrValue find_vals[2];
	find_vals[0].attr= a_chng_group_id;
	find_vals[0].value.Set(sGroupCode1);

	aplExtent result;

	m_api->m_data.NET_FindInstancesWithAttrValues2(e_chng, 1, &find_vals[0], result, false, false,0,aplSBMiddle,false,DEF_SOURCE);
	int i;
	bool old_unique=ext_linked_chagesext_linked_chages.Unique;
	ext_linked_chagesext_linked_chages.Unique=false;
	for(i=0;i<result.GetSize();i++)
	{
		if(result[i]!=change) ext_linked_chagesext_linked_chages.Add(result[i]);
	}
	ext_linked_chagesext_linked_chages.Unique=old_unique;
	return true;
}

bool CaplChangeManager::GetPdfChangeItems(CaplInstance* pdf, CaplInstance* change, aplExtent& items)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return false;
	if(pdf==NULL) return false;
	if(pdf->GetId()==0) return false;
	if(pdf->GetType()==0) return false;
	if(change==NULL) return false;
	if(change->GetId()==0) return false;
	if(change->GetType()==0) return false;
	if(!m_api->m_data.IsKindOf(pdf, m_api->m_prd_mgr.e_pdf)) return false;
	if(!m_api->m_data.IsKindOf(change, e_chng)) return false;

	items.Clear();
	LoadChangeInfo(change);
	
	aplExtent docs, rels, subPdfs;
	aplExtent changeItems;
	aplExtent basisItems;
	CaplInstance* inst;
	CaplInstance* doc;
	CaplInstance* charact;
	CaplMap strc_map;
	CString sType;
	CString sSource;
	int i, j;

	/*    
	,       
	 :         */
	m_api->m_prd_mgr.LoadAllSubProduct(NULL, NULL, pdf, rels, subPdfs);
	for(i= 0; i<rels.GetSize(); i++)
	{
		strc_map.Add((long)rels[i], 100);
		m_api->m_data.GetAttr(rels[i], m_api->m_prd_mgr.a_pdr_r_ted, inst);
		//if(sDistrCode.CompareNoCase(_T("KVZ")))
		if(!m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
		{
			m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_apl_pdf_type, sType);
			m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_pdfwss_source, sSource);

			if(sType==_T("assembly") && sSource==_T("made")) continue;
		}
		strc_map.Add((long)inst, 10);
	}
	strc_map.Add((long)pdf, 10);
	
	subPdfs.Add(pdf);
	m_api->m_doc_mgr.FindAssociatedDocuments(subPdfs, docs, rels);
	for(i= 0; i<rels.GetSize(); i++)
	{
		m_api->m_data.GetAttr(rels[i], m_api->m_doc_mgr.a_apl_doc_ref_doc, doc);
		m_api->m_data.GetAttr(rels[i], m_api->m_doc_mgr.a_apl_doc_ref_item, inst);
		if(-1!=strc_map.QGetByIn((long)inst))
			strc_map.Add((long)doc, 50);
	}

	/*   */
	m_api->m_data.GetAttr(change, a_chng_items, changeItems);
	for(i= 0; i<changeItems.GetSize(); i++)
	{
		if(m_api->m_data.IsKindOf(changeItems[i], e_mat))
		{
			continue;
		}
		else if(m_api->m_data.IsKindOf(changeItems[i], e_psc))
		{
			m_api->m_data.GetAttr(changeItems[i], a_psc_changed_product, inst);
			if(inst)
			{
				if(-1!=strc_map.QGetByIn((long)inst))
					items.Add(changeItems[i]);
			}
		}
		else if(m_api->m_data.IsKindOf(changeItems[i], e_char_change))
		{
			m_api->m_data.GetAttr(changeItems[i], a_char_change_val, charact);
			if(charact)
			{
				m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_item, inst);
				if(inst)
				{
					if(-1!=strc_map.QGetByIn((long)inst))
						items.Add(changeItems[i]);
				}
			}
		}
		else if(m_api->m_data.IsKindOf(changeItems[i], e_avc))
		{
			m_api->m_data.GetAttr(changeItems[i], a_avc_doc, doc);
			if(doc)
			{
				if(-1!=strc_map.QGetByIn((long)doc))
					items.Add(changeItems[i]);
			}
		}
		else if(m_api->m_data.IsKindOf(changeItems[i], e_abpc))
		{
			continue;
		}
		else if(m_api->m_data.IsKindOf(changeItems[i], e_chng_item))
		{
			m_api->m_data.GetAttr(changeItems[i], a_chng_item_item, basisItems);
			for(j= 0; j<basisItems.GetSize(); j++)
			{
				m_api->m_data.GetAttr(basisItems[j], a_basis_item_pdr, inst);
				if(!inst)
					m_api->m_data.GetAttr(basisItems[j], a_basis_item_pdf, inst);
				if(inst)
				{
					if(-1!=strc_map.QGetByIn((long)inst))
						items.Add(changeItems[i]);
				}
			}
		}
	}

	return true;
}

int CaplChangeManager::ShowChangeProperties(CaplInstance* change)
{
	if(m_data==NULL || !m_api->m_data.IsConnected()) return 0;
	if(change==NULL) return 0;
	if(change->GetId()==0) return 0;
	if(change->GetType()==0) return 0;
	if(!m_api->m_data.IsKindOf(change, e_chng)) return 0;
	
	CaplSetResourceHandle setres(module_inst);

	CChangeDlg dlg;
	dlg.m_api= m_api;
	dlg.m_change= change;	

	if(IDOK==dlg.DoModal())
	{		 
		//  , ... ... 
		aplExtent ext;
		bool bSave= false;
		m_api->m_data.GetAttr(change, a_chng_items, ext);
		for(int i= 0; i<ext.GetSize(); i++)
		{
			CaplInstance* inst= NULL;
			m_api->m_data.GetAttr(ext[i], a_chng_item_of_chng, inst);
			if(!inst)
			{
				m_api->m_data.PutAttr(ext[i], a_chng_item_of_chng, change);	
				bSave= true;
			}
		}

		// 
		{
			CString type, sId;
			m_api->m_data.GetAttr(dlg.m_change, a_chng_type, type);
			if(type!=_T(""))
			{
				m_api->m_data.GetAttr(dlg.m_change, a_chng_id, sId);
				sId.MakeUpper();
				if(sId.Find(APL_T(""))>0) type = APL_T("");
				else if(sId.Find(APL_T(""))>0) type = APL_T("");
				else if(sId.Find(APL_T(""))>0) type = APL_T("");
				else if(sId.Find(APL_T(""))>0) type = APL_T("");
				else if(sId.Find(APL_T(""))>0) type = APL_T("");
				else type = APL_T("");
				m_api->m_data.PutAttr(dlg.m_change, a_chng_type, type);
			}

		}
		
		if(bSave && m_api->m_AutoSave) m_api->SaveChanges();
	}
	return 1;
}

bool CaplChangeManager::LoadChangeInfo(aplExtent& changes, bool bFullLoad)
{
	if(m_data==0) return false;
	if(e_chng==0) return false;

	int iItemsCounte= 0;
	int i= 0;
	int ind0, ind1, ind2, ind3, ind4;
	int ind5, ind6, ind7, ind8;
	int ind9, ind10, ind11, ind12, ind13;
	CaplLoadData ld(m_data,DEF_SOURCE);

	for(i= 0; i<changes.GetSize(); i++)
	{
		ld.AddQuery(0,changes[i], true);
		iItemsCounte++;
		
		if(iItemsCounte==m_MaxItemsLoad || i+1==changes.GetSize())
		{
			ind0= ld.AddQuery(_T('d'), 0, 0, a_chng_changed_assemlies, true, true);
				ld.AddQuery(ind0,_T('d'), 0, 0, a_chng_dependent_items, true, true);
				ld.AddQuery(_T('d'), ind0, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);

			if(bFullLoad)
			{
				ind1= ld.AddQuery(_T('r'), 0, e_chng_item, a_chng_item_of_chng, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_chng_item_attachment, true,true);
						ld.AddQuery(_T('d'), ind1, 0, a_psc_add_set, true,true);
						ld.AddQuery(_T('d'), ind1, 0, a_psc_cancel_set, true,true);
						ld.AddQuery(_T('d'), ind1, 0, a_psc_modif_set, true,true);
						
				ind2=	ld.AddQuery(_T('d'), ind1, 0, a_psc_changed_product, true, true);
							ld.AddQuery(_T('d'), ind2, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind3=		ld.AddQuery(_T('d'), ind2, 0, m_api->m_prd_mgr.a_pdr_r_ting, true, true);
								ld.AddQuery(_T('d'), ind3, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind4=		ld.AddQuery(_T('d'), ind2, 0, m_api->m_prd_mgr.a_pdr_r_ted, true, true);
								ld.AddQuery(_T('d'), ind4, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind5=	ld.AddQuery(_T('d'), ind1, 0, a_psc_changing_product, true, true);
								ld.AddQuery(_T('d'), ind5, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
							
//				ind6=	ld.AddQuery(_T('r'), ind1, e_basis_item, a_basis_item_parent, true, true);
				ind6=	ld.AddQuery(_T('d'), ind1, 0, a_chng_item_item, true, true);
				ind7=		ld.AddQuery(_T('d'), ind6, 0, a_basis_item_new_mat, true, true);
								ld.AddQuery(_T('d'), ind7, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind8=		ld.AddQuery(_T('d'), ind6, 0, a_basis_item_old_mat, true, true);
								ld.AddQuery(_T('d'), ind8, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind9=		ld.AddQuery(_T('d'), ind6, 0, a_basis_item_pdf, true, true);
								ld.AddQuery(_T('d'), ind9, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind10=		ld.AddQuery(_T('d'), ind6, 0, a_basis_item_pdr, true, true);
				ind11=			ld.AddQuery(_T('d'), ind10, 0, m_api->m_prd_mgr.a_pdr_r_ting, true, true);
									ld.AddQuery(_T('d'), ind11, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
				ind12=			ld.AddQuery(_T('d'), ind10, 0, m_api->m_prd_mgr.a_pdr_r_ted, true, true);
									ld.AddQuery(_T('d'), ind12, 0, m_api->m_prd_mgr.a_pdf_prd, true, true);
					
						ld.AddQuery(_T('d'), ind1, 0, a_avc_doc, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_avc_new_rev, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_avc_old_rev, true, true);

						ld.AddQuery(_T('d'), ind1, 0, a_abpc_bp, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_abpc_new_rev, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_abpc_old_rev, true, true);

				ind13=	ld.AddQuery(_T('d'), ind1, 0, a_char_change_val, true, true);
							ld.AddQuery(_T('d'), ind13, 0, m_api->m_charact_mgr.a_apl_charact_val_item, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_char_change_new_rev, true, true);
						ld.AddQuery(_T('d'), ind1, 0, a_char_change_old_rev, true, true);
			}

			ld.LoadEx(true);
			iItemsCounte= 0;
		}
	}

	return true;
}

bool CaplChangeManager::LoadChangeInfo(CaplInstance* change, bool bFullLoad)
{
	if(change==0) return false;
	if(change->GetId()==0) return false;
	if(change->GetType()==0) return false;
	if(e_chng==0) return false;
	
	aplExtent changes;
	changes.Add(change);
	return LoadChangeInfo(changes, bFullLoad);

	bool bRes= false;
	
	if(m_data==0) return bRes;
	if(change==0) return bRes;
	if(change->GetId()==0) return bRes;
	if(change->GetType()==0) return bRes;
	if(e_chng==0) return bRes;
	
	int i;
	CaplLoadData ld(m_data,DEF_SOURCE);
	
i=	ld.AddQuery(-1,change, true);

	if(ld.LoadEx())
		bRes= true;

	return bRes;
}

bool CaplChangeManager::LoadItemInfo(aplExtent& items)
{
	bool bRes= false;

	CaplLoadData ld(m_data, DEF_SOURCE);
	bool bLoad = false;

	for (int i = 0, count = 0; i<items.GetSize(); i++, ++count)
	{
		if(!items[i]) continue;
		if(!items[i]->GetId()) continue;
		if(!items[i]->GetType()) continue;
		
		ld.AddQuery(0, items[i],true);
		bLoad = true;

		if(count == 3000 || i == items.Size - 1)
		{
			if(bLoad)
			{
				ld.AddQuery(_T('d'), 0, 0, a_chng_item_attachment, true,true);
				if(ld.LoadEx())
					bRes = true;
			}

			count = 0;
		}
	}

	

	return bRes;	

}

bool CaplChangeManager::LoadItemInfo(CaplInstance* item)
{
	if(!m_data || !m_api->m_data.IsConnected()) return false;
	if(item==0) return false;
	if(item->GetId()==0) return false;
	if(item->GetType()==0) return false;
	
	aplExtent ext;
	ext.Add(item);
	return LoadItemInfo(ext);
}

bool bPrepareGrpzFraction(CString &id, CString &core_id, int &a, int &b ) // a -   b - 
{
	core_id=_T("");	a=0; b=0;
	if(id==_T("")) return false;
	int i,j,k;
	i= id.ReverseFind(_T('/'));
	if(i<1) return false;

	CString buf=id.Right(id.GetLength()-(i+1));
	b=_atoi(buf);
	if(b<1) return false;

	j=i; k=-1;
	while( j>0)
	{
		j--;
		TCHAR c=id[j];
		if(c>_T('9') || c<_T('0')) {k=j+1; break;}
	}
	if(k<0) return false;
	buf=id.Mid(k,i-k);
	a=_atoi(buf);
	if(a<1) return false;

	core_id=id.Left(k-1);
	core_id.TrimRight();
	if(core_id==_T(""))  return false;
	return true;
}

bool CaplChangeManager::CheckGrpzChangeGroupById(aplExtent &ext_ch, CString &sErr)
{
	sErr=_T("");
	if(ext_ch.GetSize()<1) return false;
	int i,j,k;
	CString sId,buf,buf1;
	CaplStrMap sMapId;
	CaplStrMap sMapDrob;

	//    
	for(i=0;i<ext_ch.GetSize();i++)
	{
		m_api->m_data.GetAttr(ext_ch[i], m_api->m_change_mgr.a_chng_id, sId);
		m_api->m_data.GetAttr(ext_ch[i], m_api->m_change_mgr.a_chng_type, buf);
		if(buf==_T(""))
		{
			buf1.Format(APL_T("\n  '%s'   !"),LPCTSTR(sId));
			sErr+=buf1;
		}
		sId.MakeUpper();
		j=sId.ReverseFind(_T('/'));
		if(j<0) continue;

		int a,b;
		if(!bPrepareGrpzFraction(sId,buf,a,b))
		{
			buf1.Format(APL_T("\n   '%s'   !"),LPCTSTR(sId));
			sErr+=buf1;
			continue;
		}

		k=sMapDrob.Find(buf);
		if(k<0) sMapDrob.Add(buf,b);
		else 
		{
			if(b!=sMapDrob.GetAt(k)->val)
			{
				buf1.Format(APL_T("\n  '%s'   !"),LPCTSTR(buf));
				sErr+=buf1;
				if(b>sMapDrob.GetAt(k)->val) sMapDrob.GetAt(k)->val=b;

			}
		}
		sId.Format(_T("%s %i/%i"),LPCTSTR(buf),a,b);
		sMapId.Add(sId,(long)ext_ch[i]);
	}

	// 
	for(i=0;i<sMapDrob.GetSize();i++)
	{
		buf=sMapDrob.GetAt(i)->str;
		int n=sMapDrob.GetAt(i)->val;

		if(n<2)
		{
			buf1.Format(APL_T("\n  '%s'     !"),LPCTSTR(buf));
			sErr+=buf1;
		}

		for(j=1;j<=n;j++)
		{
			sId.Format(_T("%s %i/%i"),LPCTSTR(buf),j,n);

			if(sMapId.Find(sId)<0)
			{
				buf1.Format(APL_T("\n    '%s'"),LPCTSTR(sId));
				sErr+=buf1;
			}
		}
	}
	if(sErr!=_T("")) return false;
	return true;
}

int CaplChangeManager::ApplyChangeGrpz(CaplInstance* change) //    ,   ApplyChange
{
	int i;
	CString sErr,buf, buf1, sId,sGroupId ;
	aplExtent ext_ch;
	//m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_id, sId);
	m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_group_id, sGroupId);
	
	if(sGroupId==_T("")){AfxMessageBox (APL_T("    !"),MB_OK|MB_ICONSTOP); return 0;}
	
	m_api->m_change_mgr.GetLinkedChange(change,ext_ch);
	ext_ch.Add(change);
	LoadChangeInfo(ext_ch);

	//      
	CheckGrpzChangeGroupById(ext_ch,sErr);

	CString state,sLog;	

	//  
	//m_api->m_appr_mgr.

	aplExtent ext4Apply;

	CaplInstance *status=m_api->m_appr_mgr.FindApprovalStatusBN(APL_T(""));
	CaplInstance *status1=m_api->m_appr_mgr.FindApprovalStatusBN(APL_T("  "));

	int iNeedNormorontol=0;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     "), iNeedNormorontol, 0);
	if(0!=iNeedNormorontol)
	{
		if(0==status) {AfxMessageBox(APL_T("     \"\"!"),MB_OK|MB_ICONERROR); return APL_CH_STD_ERR;}
		if(0!=status1) {AfxMessageBox(APL_T("     \"  \"!"),MB_OK|MB_ICONERROR); return APL_CH_STD_ERR;}
	}

	CString sId1;
	for(i=0;i<ext_ch.Size;i++)
	{
		CaplInstance *inst=ext_ch[i];
		m_api->m_data.GetAttr(inst, m_api->m_change_mgr.a_chng_id, sId1);
		m_api->m_data.GetAttr(inst, m_api->m_change_mgr.a_chng_state, state);
		if(0 == state.CompareNoCase(_T("canceled")))
		{
			buf.Format(APL_T(" '%s'      !"), LPCTSTR(sId1));
			if(sLog!=_T("")) sLog+=_T("\n");
			sLog+=buf;
			continue;
		}
		else if(0 == state.CompareNoCase(_T("applied")))
		{
			buf.Format(APL_T(" '%s'  !"), LPCTSTR(sId1));
			if(sLog!=_T("")) sLog+=_T("\n");
			sLog+=buf;
			continue;
		}

		if(0==iNeedNormorontol)ext4Apply.Add(inst);
		else
		{
			if(m_api->m_appr_mgr.CheckItemStatus(inst,status)) ext4Apply.Add(inst);
			else 
			{
				bool bIsOk=false;
				CString sType;
				m_api->m_data.GetAttr(inst, m_api->m_change_mgr.a_chng_type, sType);
				if(sType==APL_T(""))
				{
					CaplInstance *src_pi;
					m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_src_pi, src_pi);
					if(0!=src_pi)

					{
						if(m_api->m_appr_mgr.CheckItemStatus(change,status1))bIsOk =true;
					}
				}

				if(!bIsOk)
				{
					buf.Format(APL_T(" '%s'   !"), LPCTSTR(sId1));
					if(sErr!=_T("")) sErr+=_T("\n");
					sErr+=buf;
					continue;
				}
			}
		}
	}

	if(sErr!=_T(""))
	{
		buf=APL_T("  , ..:\n\n");
		buf+=sErr;
		AfxMessageBox(buf,MB_ICONERROR|MB_OK);
		return  APL_CH_STD_ERR;
	}
	//!!!!!!!!!!!!!!!!!!!!
	//AfxMessageBox(APL_T("!"));
	//return  APL_CH_STD_ERR;

	CaplAdminModeProvider adminmode(&(m_api->m_data),-1, -1,DEF_SOURCE);

	aplExtent extAccess;
	for(i=0;i<ext4Apply.GetSize();i++)
	{
		CaplInstance *inst=ext4Apply[i];
		
		if(APL_CH_STD_ERR!=ApplyChangeContent(extAccess,inst))
		{
			buf.Format(APL_T(" '%s'  !"), LPCTSTR(sId1));
			if(sLog!=_T("")) sLog+=_T("\n");
			sLog+=buf;
			continue;
		}
		else
		{
			buf.Format(APL_T(" '%s'   !"), LPCTSTR(sId1));
			if(sLog!=_T("")) sLog+=_T("\n");
			sLog+=buf;
			continue;
		}
	}
	//if(sDistrCode.CompareNoCase(_T("KVZ")))
	//if(!bKVZ)
		m_api->m_data.NET_SetSpecialInstancesAccess(&extAccess, (CaplInstance*)-1, aplRO,  APL_T(" ..."), -1, -1);

	adminmode.ExitAdminMode();

	aplShowBigMsg(sLog);
	return APL_CN_NO_ERR;
}


int CaplChangeManager::ApplyChange(CaplInstance* change, aplExtent *paeWrongRels, DWORD flag)
{
	if (!change)	return APL_CH_STD_ERR;
	if (change->GetId() == 0)	return APL_CH_STD_ERR;
	if (change->GetType() == 0) 	return APL_CH_STD_ERR;

	if (!m_data || !m_api->m_data.IsConnected())
		return APL_CH_STD_ERR;

	CaplInstance* curPerson = m_api->m_appr_mgr.GetCurrentPerson();
	if(0==curPerson)
	{
		if(m_api->m_ModeInteractive)
			AfxMessageBox( APL_T("     !"), MB_OK|MB_ICONERROR);
		return APL_CH_STD_ERR;
	}

	CString state;		
	m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_state, state);
	if(0 == state.CompareNoCase(_T("canceled")))
	{
		if(m_api->m_ModeInteractive)
			AfxMessageBox(APL_T("      !"), MB_OK|MB_ICONERROR);
		return APL_CH_STATE_ERR;
	}
	else if(0 == state.CompareNoCase(_T("applied")))
	{
		if(m_api->m_ModeInteractive)
			AfxMessageBox(APL_T("  !"), MB_OK|MB_ICONINFORMATION);

		return APL_CN_NO_ERR;
	}


	CString buf;
	int iVal;
	bool bIsGoodBoy = true;
	if(!m_api->m_data.IsAdmin())
	{
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\  \" \""), iVal, 0);
		if(0!=iVal)bIsGoodBoy=m_api->m_appr_mgr.CheckPersonRole(0,APL_NO_T(" "));

		if(!bIsGoodBoy )
		{
			if(m_api->m_ModeInteractive)
				AfxMessageBox( APL_T("       ."), MB_OK|MB_ICONERROR);

			return APL_CH_STD_ERR;
		}

		if(bIsGoodBoy) //   1  (  )
		{
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "), iVal, 0);
			if(0!=iVal)
			{
				//     
				bool bInTask=false;
				aplExtent ext_task;
				m_api->m_wf_mgr->GetUserTaskList(m_api->m_appr_mgr.GetCurrentPerson(),ext_task,false,false,false);
				int i;
				for(i=0;i<ext_task.GetSize();i++)
				{
					aplExtent ext_wo;
					CaplInstance *task=ext_task[i];
					m_api->m_wf_mgr->GetWorkObjects(task,ext_wo);
					int j;
					for(j=0;j<ext_wo.GetSize();j++)
					{
						if(ext_wo[j]!=change) continue;
						CString sRole;
						CaplInstance *task_templ=0, *role=0;
						m_api->m_data.GetAttrBN(task,_T("of_activity"),task_templ);
						if(0!=task_templ) m_api->m_data.GetAttrBN(task_templ,_T("role"),role);
						if(0!=role) m_api->m_data.GetAttr(role, m_api->m_appr_mgr.a_po_role_name, sRole);
						sRole.MakeLower();
						if(sRole!=_T(" ")) continue;
						bInTask=true;
						i=ext_task.GetSize();
						break;
					}
				}
				if(!bInTask) 
				{
					AfxMessageBox(APL_T("    c  \" \" \n       .\n\n  !"),MB_OK|MB_ICONERROR);
					return APL_CN_NO_ERR;
				}
			}
		}
	}

	//   
	if(!m_api->m_data.IsAdmin())
	{
		/*     */
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\  \" \"\\  "), iVal, 0);
		if(0!=iVal)
		{
			CString sQuery;
			aplExtent objs;
			sQuery.Format(_T("SELECT Ext1 or Ext2 FROM ")
// 				_T("Ext {apl_process(.state!='terminated' AND .state!='completed' AND .work_objects->apl_work_object.object= #%i)} ")
				_T("Ext1 {apl_work_object(.object= #%i AND .action->apl_process(.state!='terminated' AND .state!='completed'))}.action ")
				_T("Ext2 {apl_work_object(.object= #%i AND .action->apl_task.of_process->apl_process(.state!='terminated' AND .state!='completed'))}.action ")
				_T("END_SELECT"), change->GetId());

			if(m_api->m_data.NET_QueryEditParse(sQuery))
				m_api->m_data.NET_QueryExecute(objs);
			
			if(objs.GetSize())/*    */
			{
				CString sKey, sVal;
				int n= 1, m= 1, i;
				int iIndex;
				CString sTmplProc;
				CString sTask;
	//			CString sSql(_T("SELECT Ext_0 OR Ext_A FROM "));
				CString sSql(_T(""));
 				CString sStrTmpl(_T(" Ext_%i{apl_task(.of_activity->apl_activity(.id = '%s' AND .of_process_template->apl_process_template.id='%s') AND ")\
					_T("(.state!='complete' AND .state!='cancel' AND .state!='suspend') AND .performer = #%i AND .of_process IN #Ext_0)} "));
	// 			CString sStrTmpl(_T("Ext_%i{apl_task(.of_activity->apl_activity(.id = '%s' AND .of_process_template->apl_process_template.id='%s') AND ")\
	// 				_T("(.state!='complete' AND .state!='cancel' AND .state!='suspend') AND .performer = #%i)}.of_process "));
	// 			CString sStrTmpl2(_T("Ext_%i{apl_task(.of_activity->apl_activity(.id = '%s' AND .of_process_template->apl_process_template.id='%s') AND ")\
	// 				_T("(.state!='complete' AND .state!='cancel' AND .state!='suspend') AND .performer = #%i)}"));
				CString sSubSql;
				CString sSubSql0;
				CString sSubSql1;
				CString sSubSql2;
				CaplInstance* ciProc(NULL);
				
				for(i= 0; i<objs.GetSize(); i++)
				{
					if(m_api->m_data.IsKindOfBN(objs[i], _T("apl_task")))
						m_api->m_data.GetAttrBN(objs[i], _T("of_process"), ciProc);
					else
						ciProc= objs[i];

					if(!ciProc) continue;

					buf.Format(_T("#%i"), ciProc->GetId());
					if(!sSubSql0.IsEmpty()) sSubSql0+= _T(", ");
					sSubSql0+=buf;
				}
				sSubSql0= _T("Ext_0{")+sSubSql0+_T("}");

	// 			_T("SELECT Ext_0 FROM ")
	// 				_T("Ext_1{apl_task(.of_activity->apl_activity(.id = '012' AND .of_process_template->apl_process_template.id='') AND ")
	// 				_T("(.state!='complete' AND .state!='cancel' AND .state!='suspend') AND .performer = #4151998)}.of_process ")
	// 				_T("Ext_2{apl_task(.of_activity->apl_activity(.id = '006' AND .of_process_template->apl_process_template.id='') AND ")
	// 				_T("(.state!='complete' AND .state!='cancel' AND .state!='suspend') AND .performer = #4151998)}.of_process ")
	// 				_T("Ext_0{apl_work_object(.object=#5634117 AND (.action IN #Ext_1 OR .action IN #Ext_2))} ")
	// 			_T("END_SELECT	");

				while(true)
				{
					sKey.Format( APL_NO_T("\\  \" \"\\  \\%i"), m);
					m_api->m_options_mgr.GetOptionValueBN(sKey, sVal, _T(""));
					if(!sVal.IsEmpty())
					{
						/*[]-[012]*/
						iIndex= sVal.Find(_T('-'));
						sTmplProc= sVal.Mid(1, iIndex-2);
						sTask= sVal.Mid(iIndex+2, sVal.GetLength()-iIndex-3);

						sSubSql.Format(sStrTmpl, n, sTask, sTmplProc, curPerson->GetId());
						sSql+=sSubSql;
						
						buf.Format(_T("Ext_%i"), n);
						if(!sSubSql1.IsEmpty()) sSubSql1+=_T(" OR ");
						sSubSql1+=buf;
				
						n++;m++;
						continue;
					}
					break;
				}

				sSql= _T("SELECT ")+sSubSql1 + _T(" FROM ") + sSubSql0 +_T(" ")+ sSql + _T(" END_SELECT");

				aplExtent taskExt;
				if(m_api->m_data.NET_QueryEditParse(sSql))
					m_api->m_data.NET_QueryExecute(taskExt,  APL_T("  ..."));

				if(!taskExt.GetSize())/* */
				{
					CString sMessage;
					m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_id, buf);
					sMessage=  APL_T("       \"")+buf+_T("\".");
					AfxMessageBox(sMessage, MB_OK|MB_ICONERROR);
					return false;
				}
			}
		}
	}	

	if (change->GetAccessmode() > aplRW)
	{
		if(!bIsGoodBoy)
		{
			if(m_api->m_ModeInteractive)
				AfxMessageBox(S::NoAccessRight(), MB_OK|MB_ICONERROR);
			return APL_CH_STD_ERR;
		}
	}
	if(m_api->m_ModeInteractive && IDNO==AfxMessageBox( APL_T("    ?"), MB_YESNO|MB_ICONWARNING|MB_DEFBUTTON2))
		return APL_CH_STD_ERR;

	CString sDistrCode;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" "), sDistrCode, _T(""));
	sDistrCode.MakeUpper();
	bool bKVZ=false;
	if(sDistrCode==_T("KVZ")) bKVZ=true;


	CString sDllExtenderName;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\.   "), sDllExtenderName, _T(""));
	//sDllExtenderName=_T("ApplyChangeExtender.dll");
	
	static HINSTANCE hDllExtender=0;
	static bool (*pPreApplyChange)(CaplAPI *, CaplInstance *) = NULL;
	static bool (*pPostApplyChange)(CaplAPI *, CaplInstance *) = NULL;

	bool bContinue=true;
	if(sDllExtenderName!=_T(""))
	{

		if(0==hDllExtender) hDllExtender=AfxLoadLibrary(sDllExtenderName);
		if(0==hDllExtender)
		{
			buf.Format(APL_T("  .  \"%s\""),LPCTSTR(sDllExtenderName));
			AfxMessageBox(buf,MB_ICONSTOP);
		}
		else
		{
			if(0==pPreApplyChange) (FARPROC&)pPreApplyChange = ::GetProcAddress(hDllExtender, "PreApplyChange");
			if(0==pPostApplyChange) (FARPROC&)pPostApplyChange = ::GetProcAddress(hDllExtender, "PostApplyChange");
		}

		if(0!=pPreApplyChange) bContinue=(pPreApplyChange)(m_api,change);
	}
	if(!bContinue) return false;


	/*       */
	CaplAdminModeProvider adminmode(&(m_api->m_data),-1, -1,DEF_SOURCE);

	int rez=0;
	//    
	{
		if(m_api->m_options_mgr.CheckInstallCode(_T("grpz")))
		{
			int iNeedNormorontol=0;
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     "), iNeedNormorontol, 0);


			CString sId,sGroupId;
			m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_group_id, sGroupId);
			m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_id, sId);
			if(sId.Find(_T('/'))>0 && sGroupId==_T(""))
			{
				AfxMessageBox(APL_T("      !\n\n       !"), MB_OK|MB_ICONERROR);
				return APL_CH_STD_ERR;
			}

			if(sGroupId!=_T(""))
			{
				return ApplyChangeGrpz(change); 
			}
			else
			{
				if(0!=iNeedNormorontol)
				{
					CaplInstance *status=m_api->m_appr_mgr.FindApprovalStatusBN(APL_T(""));
					if(!m_api->m_appr_mgr.CheckItemStatus(change,status))
					{
						bool bIsOk=false;
						CString sType;
						m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_type, sType);

						if(sType==APL_T(""))
						{
							//CaplInstance *rep_change=m_api->m_change_mgr.FindRepaymentChange(change);
							CaplInstance *src_pi;
							m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_src_pi, src_pi);
							if(0!=src_pi)
							{
								CaplInstance *status1=m_api->m_appr_mgr.FindApprovalStatusBN(APL_T("  "));
								if(0!=status1)
								{
									if(m_api->m_appr_mgr.CheckItemStatus(change,status1))bIsOk =true;
								}
								
							}
						}

						if(!bIsOk)
						{
							buf=APL_T("   !\n\n !");
							AfxMessageBox(buf, MB_OK|MB_ICONERROR);
							return APL_CH_STD_ERR;
						}
					}
				}
			}
		}
	}

	//  "" psc
	aplExtent items;
	m_api->m_data.GetAttr(change, a_chng_items, items);
	int iNumErrChangeItem=0;

	for(int i=0; i<items.Size; ++i)
	{
		if(m_api->m_data.IsKindOf(items[i], e_psc))
		{
			CaplInstance *edItem = 0, *ingItem = 0;
			m_api->m_data.GetAttr(items[i], a_psc_changed_product, edItem);
			m_api->m_data.GetAttr(items[i], a_psc_changing_product, ingItem);

			//    
			if(edItem == 0 ||
				//   ,   
				edItem && m_api->m_data.IsKindOf(edItem, m_api->m_prd_mgr.e_pdf) && ingItem == 0)
			{
				items.Remove(i--);
				iNumErrChangeItem++;
			}						
		}
	}
	if(iNumErrChangeItem>0)
	{
		if(!bKVZ)
		{
			buf.Format(APL_T("  %i  !\n     .\n\n  ?"),iNumErrChangeItem);
			if(IDYES!=AfxMessageBox(buf,MB_ICONSTOP|MB_ICONSTOP)) return APL_CH_STD_ERR;
		}

		m_api->m_data.PutAttr(change, a_chng_items, items);
		if(m_AutoSave || m_api->m_AutoSave)
			m_api->SaveChanges();
	}

	aplExtent extAccess;
	rez= ApplyChangeContent(extAccess, change,paeWrongRels,flag,bKVZ);

	//if(sDistrCode.CompareNoCase(_T("KVZ")))
	if(!bKVZ)
		m_api->m_data.NET_SetSpecialInstancesAccess(&extAccess, (CaplInstance*)-1, aplRO,  APL_T(" ..."), -1, -1);


	if(0!=pPostApplyChange) bContinue=(pPostApplyChange)(m_api,change);

	return rez;

}

int CaplChangeManager::ApplyChangeContent(aplExtent &extAccess, CaplInstance* change, aplExtent *paeWrongRels, DWORD flag, bool bKVZ)
{
	m_sAdditionalMakeChangeLog.Empty();

	CString sCnangeType;
	m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_type, sCnangeType);


	aplExtent aggr;
	m_api->m_data.GetAttr(change, a_chng_items, aggr);



	// ,       
	if ( (!aggr.GetSize()) && (sCnangeType==_T("") || sCnangeType==APL_T("") || sCnangeType==APL_T("")  ) )
	{	
 		if(m_api->m_ModeInteractive && bKVZ)
		{
			if(IDNO==AfxMessageBox( APL_T(" . ?"), MB_YESNO | MB_ICONQUESTION))
			{
				return APL_CH_STD_ERR;
			}
		}
	}

	LoadItemInfo(aggr);
	
	//  :
	//-        
	//-   pdr (),  pdr  pdf (),  pdf  pdf ()

	
	int v, v1, i;
	CString buf;
	aplExtent items, docs, bps, ext, characts;
	CaplInstance* inst= NULL, *inst1= NULL, *inst2= NULL;
	CString str, name, cond1, cond2;

	//-      
	for(i= 0; i<aggr.GetSize(); i++)// 
	{
		inst= aggr[i];
		if(!inst) continue;
		if(!inst->GetType()) continue;

		CaplInstance *ciNewEntry;
		if(m_api->m_data.IsKindOf(inst, e_avc))
		{
			//GetEntryBN      .    DocMgr
			CaplInstance *ciEntry = m_api->m_doc_mgr.GetEntryBN( APL_NO_T("  "));
			if(!ciEntry) 
			{
				ciNewEntry = m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_entry);
				if(ciNewEntry) m_api->m_data.PutAttr(ciNewEntry, m_api->m_doc_mgr.a_entry_name,  APL_NO_T("  "));								
			}
			
			ciEntry = m_api->m_doc_mgr.GetEntryBN( APL_NO_T(" ,     "));
			if(!ciEntry) 
			{
				ciNewEntry = m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_entry);
				if(ciNewEntry) m_api->m_data.PutAttr(ciNewEntry, m_api->m_doc_mgr.a_entry_name,  APL_NO_T(" ,     "));
			}

			ciEntry = m_api->m_doc_mgr.GetEntryBN( APL_NO_T("  "));
			if(!ciEntry) 
			{
				ciNewEntry = m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_entry);
				if(ciNewEntry) m_api->m_data.PutAttr(ciNewEntry, m_api->m_doc_mgr.a_entry_name,  APL_NO_T("  "));
			}

			if(m_api->m_AutoSave)
				m_api->SaveChanges();
			break;
		}
	}
		
	long dlgHandle= aplStartWaitDlg( APL_T("  ..."));
	
	CaplAttrValue find_values[3];
	m_api->m_data.GetAttr(change, a_chng_id, name);
	find_values[0].value.Set(name);
	find_values[0].attr= a_chng_id;

	if(!m_api->m_data.NET_TestUniqueAttrValues(e_chng, change, 1, find_values, false))
	{
		aplEndWaitDlg(dlgHandle);
		dlgHandle = 0;

		if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("     ."), MB_OK);
		return APL_CH_STD_ERR;
	}
		
	CaplLoadData ld(m_data,DEF_SOURCE);
	bool bError= false;
	bool bCheckForTechChange= false;

	CaplInstance* cur_assembly;
	CaplInstance* cur_unit;

	double dCurValue;
	CString sCurPos, sLabel;

	CString sCurrDate, buf1, sPdfName;
	COleDateTime odt;
	m_api->m_data.NET_GetServerDateTime(odt);
	aplDate2String(odt, sCurrDate);

	CString sUser = m_api->m_data.GetNameCurrUser(); //
	CaplInstance* person= NULL; //
	person= m_api->m_appr_mgr.GetCurrentPerson();

	//   09.07.2008.      
	//sCurrDate= sCurrDate.Left(8)+_T("000000");

	bool bAplly=true;
	if(m_api->m_options_mgr.CheckInstallCode(_T("grpz")))
	{
		if(!(sCnangeType==APL_T("") || sCnangeType==_T(""))) bAplly=false; //      ,    
	}

	if(bAplly)
	{
		CString sChEffType, sChStart, sChEnd;

		m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_eff_type, sChEffType);
		m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_start_num, sChStart);
		m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_end_num, sChEnd);		

		for(i= 0; i<aggr.GetSize(); i++)// 
		{
			inst= aggr[i];
			if(!inst) continue;
			if(!inst->GetType()) continue;

			if(m_api->m_data.IsKindOf(inst, e_psc))
			{
				m_api->m_data.GetAttr(inst, a_chng_item_id, name);
				if(name.IsEmpty())
				{
					m_api->m_data.GetAttr(inst, a_psc_changed_product, inst2);
					name= GetPSCId(inst2);
					m_api->m_data.PutAttr(inst, a_chng_item_id, name);
					
	// 				aplEndWaitDlg(dlgHandle);
	// 				dlgHandle = 0;
	// 				
	// 				if(m_api->m_ModeInteractive)AfxMessageBox(APL_T("    ."), MB_OK);
	// 				bError= true;
	// 				break;
				}
				
	/*			find_values[0].value.Set(name);
				find_values[0].attr= a_psc_id;
				if(!m_api->m_data.NET_TestUniqueAttrValues(e_chng_item, inst, 1, find_values, false))
				{
					MessageBox(NULL, APL_T(" : ")+name+APL_T("\n\n     ."), APL_T(" "),
						MB_OK);
					AfxSetResourceHandle(hInstOld);
					return false;		
				}*/

				m_api->m_data.GetAttr(inst, a_psc_eff_type, str);
				cond1= _T(""); cond2= _T("");
				if(str==_T("dated"))
				{
					m_api->m_data.GetAttr(inst, a_psc_start_date, cond1);
					m_api->m_data.GetAttr(inst, a_psc_end_date, cond2);
					if(!cond2.IsEmpty() && cond1>cond2)
					{
						aplEndWaitDlg(dlgHandle);
						dlgHandle = 0;

						if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n   ."), MB_OK);
						bError= true;
						break;
					}
				}
				else if(str==_T("numbered"))
				{
					m_api->m_data.GetAttr(inst, a_psc_start_num, cond1);
					m_api->m_data.GetAttr(inst, a_psc_end_num, cond2);
					if(!cond2.IsEmpty() && m_api->m_prd_mgr.funcCompareSN(cond1,cond2)==1)
					{
						aplEndWaitDlg(dlgHandle);
						dlgHandle = 0;

						if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n   ."), MB_OK);
						bError= true;
						break;
					}
				}
				else //    
				{
					cond1= sCurrDate;
	//				aplEndWaitDlg(dlgHandle);
	//				dlgHandle = 0;
	//				
	//				AfxMessageBox(APL_T("  : ")+name+APL_T("\n\n   ."), MB_OK);
	//
	//				bError= true;
	//				break;
				}
				
				if(cond1.IsEmpty() && cond2.IsEmpty())
				{
					aplEndWaitDlg(dlgHandle);
					dlgHandle = 0;

					if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n   ."), MB_OK);
					bError= true;
					break;
				}

				m_api->m_data.GetAttr(inst, a_psc_changed_product, inst2);// () 
				if(!inst2) continue; // psc
				m_api->m_data.GetAttr(inst, a_psc_changing_product, inst1);//  (  )
				m_api->m_data.GetAttr(inst, a_psc_position, sCurPos);
				m_api->m_data.GetAttr(inst, a_psc_value, dCurValue);
				m_api->m_data.GetAttr(inst, a_psc_unit, cur_unit);

				if(m_api->m_data.IsKindOf(inst2, m_api->m_prd_mgr.e_apl_pdf) && !inst1)
				{
					aplEndWaitDlg(dlgHandle);
					dlgHandle = 0;

					if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n   ."), MB_OK);
					bError= true;
					break;
				}
				if(!m_api->m_data.IsKindOf(inst2, m_api->m_prd_mgr.e_apl_pdf) && !m_api->m_data.IsKindOf(inst2, m_api->m_prd_mgr.e_pdr))
				{
					aplEndWaitDlg(dlgHandle);
					dlgHandle = 0;
					
					if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n:   ,    ."), MB_OK);
					bError= true;
					break;
				}
				
				CaplInstance* pd_test_ing= NULL, *pd_test_ed= NULL;

				if(m_api->m_data.IsKindOf(inst2, m_api->m_prd_mgr.e_pdr) && inst1)
				{
					ld.ClearQuery();
				 v= ld.AddQuery(0,inst2);
					ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_r_ted, true);
				v1=	ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_r_ting, true);
					ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_id, true);
					ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_inner_id, true);
					ld.LoadEx();

					m_api->m_data.GetAttr(inst2, m_api->m_prd_mgr.a_pdr_r_ting, pd_test_ing);
					
				}
				else if(m_api->m_data.IsKindOf(inst2, m_api->m_prd_mgr.e_apl_pdf))
				{
					pd_test_ing= inst2;
					cur_assembly= inst2;
				}

				if(inst1) pd_test_ed=inst1;

				if(pd_test_ing && pd_test_ed)//  
				{
					if(pd_test_ing==pd_test_ed || !m_api->m_data.TestCycleInRelation(m_api->m_prd_mgr.e_acu, m_api->m_prd_mgr.a_pdr_r_ting,
						m_api->m_prd_mgr.a_pdr_r_ted, pd_test_ing, pd_test_ed))
					{
						aplEndWaitDlg(dlgHandle);
						dlgHandle = 0;

						if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n      ."), MB_OK);
						bError= true;

						CString pdfFullName = m_api->GetItemName(pd_test_ed);
						m_sAdditionalMakeChangeLog = APL_T("       [" + pdfFullName + "]");
						break;
					}
				}		
/*				for(iIndex= 0; iIndex<items.GetSize(); iIndex++)
				{
					m_api->m_data.GetAttr(items[iIndex], a_psc_changed_product, cur_assembly);// () 
					if(inst2!=cur_assembly) continue;
					m_api->m_data.GetAttr(items[iIndex], a_psc_changing_product, cur_pdf);//  (  )
					if(inst1!=cur_pdf) continue;
					m_api->m_data.GetAttr(items[iIndex], a_psc_value, buf);
					if(buf.CompareNoCase(sCurPos)) continue;
					
					m_api->m_data.GetAttr(items[iIndex], a_psc_unit, inst1);
					m_api->m_data.GetAttr(items[iIndex], a_psc_value, dValue);
	// 				if(cur_unit!=inst1 || dValue!=dCurValue)
	// 				{
	// 					m_api->LoadItemInfo(cur_pdf);
	// 					m_api->GetItemName(cur_pdf, sPdfName);
	// 
	// 					if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n \"")+sPdfName+ APL_T("\"   \"")
	// 						+sCurPos+ APL_T("\"    ."), MB_OK);
	// 					bError= true;
	// 					break;
	// 				}
				}*/
				if(bError) break; 

				items.Add(inst);
			}
			// 
			else if(m_api->m_data.IsKindOf(inst, e_avc))
			{
				CaplInstance* doc= NULL, *act_rev= NULL, *rev= NULL;

				m_api->m_data.GetAttr(inst, a_chng_item_id, name);
				m_api->m_data.GetAttr(inst, a_avc_new_rev, rev);
				if(!rev)
				{
					aplEndWaitDlg(dlgHandle);
					dlgHandle = 0;
					bError= true;
					break;
				}
				
				m_api->m_data.GetAttr(rev, m_api->m_doc_mgr.a_apl_doc_rev_label, sLabel);
				if((flag&APL_CH_NO_DRAFT_CHECK)==0)
				{
					if(sLabel.CompareNoCase(APL_T(""))==0)
					{
						if(m_api->m_ModeInteractive)
							AfxMessageBox(APL_T("    ."), MB_OK|MB_ICONERROR);

						aplEndWaitDlg(dlgHandle);
						dlgHandle = 0;
						bError= true;
						break;
					}
					else if(sLabel.CompareNoCase(APL_T("-"))==0)
					{
						if(m_api->m_ModeInteractive)
							AfxMessageBox(APL_T("     ."), MB_OK|MB_ICONERROR);

						aplEndWaitDlg(dlgHandle);
						dlgHandle = 0;
						bError= true;
						break;
					}
				}

				m_api->m_data.GetAttr(rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, doc);
				if(!doc && !rev->attrs)
				{
					m_api->m_doc_mgr.LoadDocInfo(rev);
					m_api->m_data.GetAttr(rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, doc);
				}

				//     ,    
				//      
				aplExtent aeDTEntries;
				COleDateTime time(COleDateTime::GetCurrentTime());
				CString sEntryName, sValue;
				CaplInstance *ciDT, *ciEntry;
				bool bChangeNum = false;
				bool bDocNum = false;
				bool bDate = false;			

				// ,       
				m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_doc_kind, ciDT);
				if(ciDT)
					m_api->m_data.GetAttr(ciDT, m_api->m_doc_mgr.a_dt_entries, aeDTEntries);
				
				for(int q=0; q<aeDTEntries.Size; ++q)
				{
					m_api->m_data.GetAttr(aeDTEntries[q], m_api->m_doc_mgr.a_dt_entry_entry, ciEntry);
					if(!ciEntry) continue;

					m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_name, sEntryName);
					sEntryName.MakeLower();

					if(sEntryName ==  APL_NO_T("  ")) bChangeNum = true;
					if(sEntryName ==  APL_NO_T(" ,     ")) bDocNum = true;
					if(sEntryName ==  APL_NO_T("  ")) bDate = true;
				}

				//       ,   
				// +     
				if(!bChangeNum)	m_api->m_doc_mgr.AddEntryToDocType(m_api->m_doc_mgr.GetEntryBN( APL_T("  ")), ciDT);
				m_api->m_doc_mgr.CreateEntryVal(rev,  APL_NO_T("  "), name);
				
				if(!bDocNum) m_api->m_doc_mgr.AddEntryToDocType(m_api->m_doc_mgr.GetEntryBN( APL_T(" ,     ")), ciDT);
				m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_id, sValue);
				m_api->m_doc_mgr.CreateEntryVal(rev,  APL_NO_T(" ,     "), sValue);
								
				if(!bDate) m_api->m_doc_mgr.AddEntryToDocType(m_api->m_doc_mgr.GetEntryBN( APL_NO_T("  ")), ciDT);
				sValue.Format(_T("%.2d.%.2d.%.4d"), time.GetDay(), time.GetMonth(), time.GetYear());
				m_api->m_doc_mgr.CreateEntryVal(rev,  APL_NO_T("  "), sValue);	
				
				if(name.IsEmpty())
				{
					/*   */
					name= GetAVCId(rev);
					m_api->m_data.PutAttr(inst, a_chng_item_id, name);

	// 				aplEndWaitDlg(dlgHandle);
	// 				dlgHandle = 0;

	// 				if(m_api->m_ModeInteractive)AfxMessageBox(APL_T("   :\n    ."), MB_OK);
	// 				bError= true;
	// 				break;
				}

				m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_apl_doc_active, act_rev);

				/*ayatsk 21.03.2011    
				if(rev==act_rev)
				{
					aplEndWaitDlg(dlgHandle);
					dlgHandle = 0;
					//      () 
					if(sDistrCode.CompareNoCase(_T("KVZ")))
					{
						if(m_api->m_ModeInteractive)
							AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n   ."), MB_OK);
						bError= true;
						break;
					}
				}*/

				docs.Add(inst);

				//:     
				{
					aplExtent ext_items_for_add_relation, ext_items_for_del_relation;
					apidata.GetAttr(inst, m_api->m_change_mgr.a_avc_items_for_add_relation, ext_items_for_add_relation);
					apidata.GetAttr(inst, m_api->m_change_mgr.a_avc_items_for_del_relation, ext_items_for_del_relation);
					if(ext_items_for_add_relation.GetSize()>0 || ext_items_for_del_relation.GetSize()>0)
					{
						aplExtent ext_doc,ext_rel,ext_out; 
						ext_doc.Add(doc);
						m_api->m_doc_mgr.FindAssociatingDocuments(ext_doc,ext_out,ext_rel);

						int i,j;
						//  
						for(i=0;i<ext_items_for_add_relation.GetSize();i++)
						{
							CaplInstance *inst=ext_items_for_add_relation[i];
							bool bExist=false;
							for(j=0;j<ext_rel.GetSize();j++)
							{
								CaplInstance *inst1=0;
								apidata.GetAttr(ext_rel[j], m_api->m_doc_mgr.a_apl_doc_ref_item, inst1);
								if(inst1==inst) {bExist=true; break;}
							}
							if(!bExist)
							{
								CaplInstance *rel=m_api->m_doc_mgr.CreateAssociation(inst,doc,0,0,APL_DOCUMENT_RELATION,false);
								apidata.PutAttr(rel, m_api->m_doc_mgr.a_apl_doc_ref_start_date, sCurrDate);
							}
						}
						//  
						for(i=0;i<ext_items_for_del_relation.GetSize();i++)
						{
							CaplInstance *inst=ext_items_for_del_relation[i];
							for(j=0;j<ext_rel.GetSize();j++)
							{
								CaplInstance *inst1=0;
								apidata.GetAttr(ext_rel[j], m_api->m_doc_mgr.a_apl_doc_ref_item, inst1);
								if(inst1==inst)
								{
									apidata.GetAttr(ext_rel[j], m_api->m_doc_mgr.a_apl_doc_ref_end_date, buf);
									if(buf==_T("")) apidata.PutAttr(ext_rel[j], m_api->m_doc_mgr.a_apl_doc_ref_end_date, sCurrDate);
								}
							}
						}
					}
				}
			}
			// -
			else if(m_api->m_data.IsKindOf(inst, e_abpc))
			{
				CaplInstance* rev= NULL, *newRev= NULL, *bp= NULL;
				m_api->m_data.GetAttr(inst, a_abpc_new_rev, rev);
				if(!rev)
				{
					bError= true;
					break;
				}
				m_api->m_data.GetAttr(inst, a_chng_item_id, name);
				if(name.IsEmpty())
				{
					name= GetBPCId(rev);
					m_api->m_data.PutAttr(inst, a_chng_item_id, name);
	// 				aplEndWaitDlg(dlgHandle);
	// 				dlgHandle = 0;
	// 
	// 				if(m_api->m_ModeInteractive)AfxMessageBox(APL_T("   -:\n    ."), MB_OK);
	// 				bError= true;
	// 				break;
				}
				
				m_api->m_data.GetAttr(rev, m_api->m_bp_mgr.a_bp_ver_bp, bp);
				if(!bp)
				{
					m_api->m_bp_mgr.LoadBPInfo(rev);
					m_api->m_data.GetAttr(rev, m_api->m_bp_mgr.a_bp_ver_bp, bp);
				}

				m_api->m_data.GetAttr(bp, m_api->m_bp_mgr.a_bp_act, newRev);
				/*ayatsk 21.03.2011    
				if(rev==newRev)
				{
					aplEndWaitDlg(dlgHandle);
					dlgHandle = 0;
					
					if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n -  ."), MB_OK);
					bError= true;
					break;
				}
				*/
				
				bps.Add(inst);
			}
			// -
			else if (m_api->m_data.IsKindOf(inst, e_char_change))
			{
				CaplInstance* rev = NULL, *newRev = NULL, *charact = NULL, *oldRev = NULL;
				m_api->m_data.GetAttr(inst, a_char_change_new_rev, rev);
				m_api->m_data.GetAttr(inst, a_chng_item_id, name);
				if (name.IsEmpty())
				{
					name= GetCHCId(rev);
					m_api->m_data.PutAttr(inst, a_chng_item_id, name);

	// 				aplEndWaitDlg(dlgHandle);
	// 				dlgHandle = 0;
	// 				
	// 				if(m_api->m_ModeInteractive)AfxMessageBox(APL_T("   -:\n    ."), MB_OK);
	// 				bError = true;
	// 				break;
				}

				m_api->m_data.GetAttr(inst, a_char_change_old_rev, oldRev);
				if ((!oldRev)&&(!rev))
					continue;
				if (!rev)
				{
					bError = true;
					break;
				}

				m_api->m_data.GetAttr(rev, m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, charact);
				if (!charact)
				{
					m_api->m_charact_mgr.LoadCharacteristic(rev);
					m_api->m_data.GetAttr(rev, m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, charact);
				}

				if(!charact) //-V581
				{
					continue;
				}

				if (charact->GetAccessmode() > aplRW)
				{
					if(m_api->m_ModeInteractive)AfxMessageBox(S::NoAccessRight(), MB_OK|MB_ICONERROR);
					bError = true;
					break;
				}

				m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_act_ver, newRev);
				/*ayatsk 21.03.2011    
				if (rev == newRev)
				{
					if(m_api->m_ModeInteractive)AfxMessageBox( APL_T("  : ")+name+ APL_T("\n\n -  ."), MB_OK);
					bError = true;
					break;
				}*/
				
				characts.Add(inst);
			}
			else if(m_api->m_data.IsKindOf(inst, e_chng_item))
			{
				bCheckForTechChange= true;
			}
		}
		
		aplEndWaitDlg(dlgHandle);
		dlgHandle = 0;
		
		/*<  */
		HINSTANCE hLibrary= NULL;
		bool (*pIsChangeCorrect)(CaplAPI *api, CaplInstance *ciChng, aplExtent &aeWrongRels);
		bool (*pApplyTechnologChange)(CaplAPI *api, CaplInstance *ciChng, bool bApplyChng, bool bLoadFromBase);

		HINSTANCE hLibraryKTS= NULL;
		bool (*pValidateRasc)(aplExtent& assembls, CaplInstance* ciChange, CaplAPI* api);
		bool (*pValidateMats)(aplExtent& assembls, CaplInstance* ciChange, CaplAPI* api);

		HINSTANCE hLibraryOGMet = NULL;
		bool (*pValidateOGMetChange)(CaplAPI* api, CaplInstance* ciChange, aplExtent& aeAssemblies);
		bool (*pApplyOGMetChange)(CaplAPI* api, CaplInstance* ciChange, aplExtent& aeAssemblies);

		pIsChangeCorrect= NULL;
		pApplyTechnologChange= NULL;
		pValidateRasc = NULL;
		pValidateMats = NULL;
		pValidateOGMetChange = NULL;
		pApplyOGMetChange = NULL;

		//if(!sDistrCode.CompareNoCase(_T("KVZ")))
		if(bKVZ)
		{
			hLibrary= AfxLoadLibrary(_T("aplchangemodule.dll"));
			if(hLibrary)
			{
				(FARPROC&)pIsChangeCorrect = ::GetProcAddress(hLibrary, "IsChangeCorrect");
				(FARPROC&)pApplyTechnologChange = ::GetProcAddress(hLibrary, "ApplyTechnologChange");
			}
			hLibraryKTS= AfxLoadLibrary(_T("KTS_EditAddIn3.dll"));
			if(hLibraryKTS)
			{
				(FARPROC&)pValidateRasc = ::GetProcAddress(hLibraryKTS, "ValidateShopChains");
				(FARPROC&)pValidateMats = ::GetProcAddress(hLibraryKTS, "ValidateMat");
			}
			hLibraryOGMet = AfxLoadLibrary(_T("aplOGMet.dll"));
			if (hLibraryOGMet)
			{
				(FARPROC&)pValidateOGMetChange = ::GetProcAddress(hLibraryOGMet, "CheckOGMetChange");
				(FARPROC&)pApplyOGMetChange = ::GetProcAddress(hLibraryOGMet, "DoOGMetChange");
			}
		}
		/*</  */
		
		/* */
		aplExtent pdf_lockers;
		CString sChangeDscr;
		CaplMap pdf_locker_map;
		m_api->m_data.GetAttr(change, a_chng_dscr, sChangeDscr);
		sChangeDscr.MakeLower();
		
		int iRetCode= APL_CN_NO_ERR;
		if(bError)
			iRetCode= APL_CH_STD_ERR;

		//if(!sDistrCode.CompareNoCase(_T("KVZ")))
		if(bKVZ)
		{
			CaplInstance* locker;
			
			find_values[0].attr= m_api->m_prd_mgr.a_apl_pdf_locker;
			find_values[0].value.Set(change);

	//		m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_prd_mgr.e_apl_pdf, 1, &find_values[0], pdf_lockers, false);
			

			m_api->m_data.GetAttr(change, a_chng_changed_assemlies, pdf_lockers);
			
			for(i= 0; i<pdf_lockers.GetSize(); i++)
			{
				m_api->m_data.GetAttr(pdf_lockers[i], m_api->m_prd_mgr.a_apl_pdf_locker, locker);
				if(locker!=change)
				{
					m_api->m_data.PutAttr(pdf_lockers[i], m_api->m_prd_mgr.a_apl_pdf_locker, change);
					pdf_locker_map.Add((long)pdf_lockers[i], (long)locker);
				}
			}

 			//int t= flag&APL_CH_NO_TECH_APPLY;
 			//int t1= flag&APL_CH_NO_TECH_CHECK; 
			
			if((flag&APL_CH_NO_TECH_APPLY)==0&&(flag&APL_CH_NO_TECH_CHECK)==0)		
			{
				if(pValidateRasc && !bError)
				{
					if(!pValidateRasc(pdf_lockers, change, m_api))
					{
						bError = true;
						iRetCode= APL_CH_SHOP_CH_ERR;
					}
				}
				if(pValidateMats && !bError)
				{
					if(!pValidateMats(pdf_lockers, change, m_api))
					{
						bError = true;
						iRetCode= APL_CH_MAT_CH_ERR;
					}
				}
				if (pValidateOGMetChange && !bError)
				{
					if (!pValidateOGMetChange(m_api,change,pdf_lockers))
					{
						bError = true;
						iRetCode= APL_CH_OGM_ERR;
					}
				}
			}
		}

		/*<     -*/
		if(pIsChangeCorrect && !bError)
		{
			aplExtent WrongRels;
			if((flag&APL_CH_NO_TECH_APPLY)==0&&(flag&APL_CH_NO_TECH_CHECK)==0)
			{
				if(!pIsChangeCorrect(m_api, change, WrongRels))
				{
					if(paeWrongRels)
						paeWrongRels->Append(WrongRels);
					bError = true;
					iRetCode= APL_CH_SHOP_CH_ERR;
				}
			}
		}

		if (bError)
		{
			for(i=0; i<pdf_locker_map.Size; i++)
				m_api->m_data.PutAttr((CaplInstance*)(pdf_locker_map[i].in), m_api->m_prd_mgr.a_apl_pdf_locker, (CaplInstance*)(pdf_locker_map[i].out));
			return iRetCode;
		}
		
		bError = false;

		bool bOldAutoSave= m_api->m_AutoSave;
		m_api->SetAutoSave(false);
		
		dlgHandle= aplStartWaitDlg( APL_T("  ..."));		
		
		bool bDR= false;
		CaplStrMap inner_id_map;

		for(i= 0; i<items.GetSize(); i++)
		{
			m_addedEffSet.Clear();
			m_chngedEffSet.Clear();
			m_deletedEffSet.Clear();

			CaplInstance* pdr_pdf, *pdr= NULL, *pd_ing, *pd_ed, *pdf_ing, 
				*unit, *der_unit/*, *pdf_ed*/, *assortm;
			CaplInstance* newPdr= NULL;
			double val, derVal; int iPrior;
			CString sPdrInnerId, sId, sPosNum, sName, sDscr,
				sType, sStart, sEnd, sPos, sRequir, sShap, sBufStart, sBufEnd;
			aplExtent contexts;
			
			m_api->m_data.GetAttr(items[i], a_chng_item_id, sId);
			m_api->m_data.GetAttr(items[i], a_chng_item_name, sName);
			m_api->m_data.GetAttr(items[i], a_chng_item_dscr, sDscr);
			m_api->m_data.GetAttr(items[i], a_psc_changed_product, pdr_pdf);
			m_api->m_data.GetAttr(items[i], a_psc_changing_product, pdf_ing);
			m_api->m_data.GetAttr(items[i], a_psc_position, sPos);
			m_api->m_data.GetAttr(items[i], a_psc_position_num, sPosNum);
			m_api->m_data.GetAttr(items[i], a_psc_value, val);
			m_api->m_data.GetAttr(items[i], a_psc_unit, unit);
			m_api->m_data.GetAttr(items[i], a_psc_frames_of_reference, contexts);
			
			if(m_api->m_data.IsKindOf(items[i], e_mat))
			{
				m_api->m_data.GetAttr(items[i], a_mat_size, sShap);
				m_api->m_data.GetAttr(items[i], a_mat_requir, sRequir);
				m_api->m_data.GetAttr(items[i], a_mat_renking, iPrior);
				m_api->m_data.GetAttr(items[i], a_mat_assort, assortm);
				m_api->m_data.GetAttr(items[i], a_mat_der_unit, der_unit);
				m_api->m_data.GetAttr(items[i], a_mat_der_value, derVal);
			}
			else if(m_api->m_data.IsKindOf(items[i], e_psc))
			{
				m_api->m_data.GetAttr(items[i], a_psc_position, sPos);	
			}
					
			m_api->m_data.GetAttr(items[i], a_psc_eff_type, sType);
			if(sType==_T("dated"))
			{
				m_api->m_data.GetAttr(items[i], a_psc_end_date, sEnd);
				m_api->m_data.GetAttr(items[i], a_psc_start_date, sStart);			
			}
			else if(sType==_T("numbered"))
			{
				m_api->m_data.GetAttr(items[i], a_psc_start_num, sStart);
				m_api->m_data.GetAttr(items[i], a_psc_end_num, sEnd);			
				m_api->m_data.GetAttr(items[i], a_psc_addit, bDR);
	//			if(bDR && (sStart==_T("") || sEnd==_T("")))
	//			{
	//				CString sTemp;
	//				sTemp= sStart;sStart= sEnd;sEnd= sTemp;
	//			}
			}
			else if(!sChEffType.IsEmpty() && sChEffType!=_T("none"))
			{
				sType= sChEffType;
				sStart= sChStart;
				sEnd= sChEnd;
			}
			else //   
			{
				sType= _T("dated");
				sStart= sCurrDate;
				sEnd= _T("");
			}

			sBufStart = sStart;
			sBufEnd = sEnd;
			if(m_api->m_prd_mgr.funcGetPrevSN == NULL || m_api->m_prd_mgr.funcGetNextSN == NULL)
			{
				aplEndWaitDlg(dlgHandle);
				return false;
			}

			sBufStart = m_api->m_prd_mgr.funcGetPrevSN(sBufStart);
			sBufEnd = m_api->m_prd_mgr.funcGetNextSN(sBufEnd);

			CaplAttrValue find_values[4];
			aplExtent pdr_ext, //prd   
				pdr_ext_new, //pdr,       
				eff_ext, //   
				eff_ext_add, //    
				ext; //

			//    PSC
			aplExtent addEff, chngEff, delEff;

			CaplInstance* eff1= NULL;

			if(m_api->m_data.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdr))
			{
				//  pdr   
				pd_ed=pdf_ing;

				m_api->m_data.GetAttr(pdr_pdf, m_api->m_prd_mgr.a_pdr_r_ting, pd_ing);

				double optionValue = 0;
				m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("       "), optionValue, 0);
				m_api->m_data.GetAttr(pdr_pdf, m_api->m_prd_mgr.a_pdr_inner_id, sPdrInnerId);
				
				if(!sPdrInnerId.IsEmpty() && optionValue != 0)//  pdr
				{
	/*				find_values[2].value.Set(pd_ed);
					find_values[2].attr= m_api->m_prd_mgr.a_pdr_r_ted;*/
					find_values[1].value.Set(pd_ing);
					find_values[1].attr= m_api->m_prd_mgr.a_pdr_r_ting;
					find_values[0].value.Set(sPdrInnerId); //    
					find_values[0].attr= m_api->m_prd_mgr.a_pdr_inner_id;
					
					if(m_api->m_data.IsKindOf(items[i], e_mat))
						m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_prd_mgr.e_make_from, 2, &find_values[0], pdr_ext, false);
					else if(m_api->m_data.IsKindOf(items[i], e_psc))
						m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_prd_mgr.e_nauo, 2, &find_values[0], pdr_ext, false);
				}
				else// id  ,      
				{
					aplExtent same_rels, same_pdfs;
					if(m_api->m_data.IsKindOf(items[i], e_mat))
						m_api->m_prd_mgr.LoadAllZagotov(pd_ing, same_rels, same_pdfs);
					else if(m_api->m_data.IsKindOf(items[i], e_psc))
						m_api->m_prd_mgr.LoadAllSubProduct(0, 0, pd_ing, same_rels, same_pdfs);
					
					int num= 0;

					for(int n= 0; n<same_rels.GetSize(); n++)
					{
						m_api->m_data.GetAttr(same_rels[n], m_api->m_prd_mgr.a_pdr_inner_id, buf);
						if(!buf.IsEmpty()) buf.Delete(0);// #
						int ind= _atoi(buf);
						if(ind>num) num= ind;
					}

					num++;
					sPdrInnerId.Format(_T("#%i"), num);

					pdr_ext.Add(pdr_pdf);
				}

				if(pdf_ing)//
				{
					//  (  )  ( )
					m_api->m_data.PutAttr(pdr_pdf, m_api->m_prd_mgr.a_pdr_inner_id, sPdrInnerId);
					if(!contexts.GetSize())
						m_api->m_data.GetAttr(pdr_pdf, m_api->m_prd_mgr.a_pdr_frames_of_reference, contexts);
					
					double r;
					pdr= NULL;
					for(int j= 0; j<pdr_ext.GetSize(); j++)
					{
						//  eff   
						GetPrdEffectivity( pdr_ext[j], sType, sStart, sEnd, eff_ext);
						
						if(!m_api->m_data.IsKindOf(items[i], e_mat))
						{
							ld.ClearQuery();
						v=	ld.AddQuery(0, pdr_ext[j], true);
	// 						ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_r_ted, true);
	// 						ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_frames_of_reference, true);
	// 						ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_apl_qacu_value, true);
	// 						ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_apl_qacu_unit, true);
							ld.LoadEx();
							
							m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_pdr_r_ted, inst);
							if(inst==pd_ed)
							{
								CString strId, strNum;
								m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_pdr_id, strId);
								m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_acu_ref_des, strNum);
								m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_apl_qacu_value, r);
								m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_apl_qacu_unit, inst);
								if(r==val && inst==unit && strId==sPos && strNum==sPosNum)
								{
									// .    - pdr
									aplExtent cnts;
									m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_pdr_frames_of_reference, cnts);
									bool bNotNew= false;
									
									if(cnts.GetSize()==contexts.GetSize()){bNotNew= true;}

									for(int r= 0; r<cnts.GetSize(); r++)
									{
										bNotNew= false;
										for(int t= 0; t<contexts.GetSize(); t++)
										{
											if(cnts[r]==contexts[t]){bNotNew= true; break;}
										}
									}
									if(bNotNew)
									{
										pdr= pdr_ext[j];
										continue;
									}
								}						
							}
						}
					}
					if(!pdr)//  
					{
						if(m_api->m_data.IsKindOf(items[i], e_mat))
						{
							pdr= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_make_from);
							if(pdr)
							{
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ting, pd_ing);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ted, pd_ed);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_id, sShap);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_name, sRequir);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_assortment, assortm);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_ranking, iPrior);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_unit, unit);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_value, val);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_derive_value, derVal);
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_derive_unit, der_unit);
							}
						}
						else if(m_api->m_data.IsKindOf(items[i], e_psc))
						{
							pdr= m_api->m_prd_mgr.CreatePdfRelation(NULL, pd_ing, pd_ed, /*sPdrId*/sPos, _T(""), val, unit);
							if(pdr)
							{
								m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_acu_ref_des, sPosNum);
							}
						}
						
						//
						m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_frames_of_reference, contexts);
						newPdr= pdr;
					}
					
					if(!pdr) continue;
					
					// id  name  
					if(sName!=_T(""))
						m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_name, sName);
					if(sDscr!=_T(""))
						m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_descr, sDscr);
					
					// pdr' ( )
					m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_inner_id, sPdrInnerId);

					BOOL bReset = FALSE;
					for(int k= 0; k<eff_ext.GetSize(); k++)// eff
					{
						ResetPrdEffectivity( eff_ext[k], sType, sStart, sEnd, pdr_ext_new, eff_ext_add);
						bReset = TRUE;
					}
					if(bReset)
						inner_id_map.Add(sPdrInnerId, bReset);

					if(sType==_T("dated"))// eff  
					{
						CreateDatedEffSet( bReset, sId, sStart, sEnd, pdr_pdf, pdr_ext_new, eff_ext_add, pdr);
					}
					else if(sType==_T("numbered"))//eff   
					{
						if(!bReset)
						{
							aplExtent eff_ext1;
							if(GetPrdEffectivity(pdr_pdf, sType, sStart, sEnd, eff_ext1) && eff_ext1.GetSize()==0)
								bReset= TRUE;//      
						}

						CreateNumedEffSet( bReset, sId, sStart, sEnd, pdr_pdf, pdr_ext_new, eff_ext_add, pdr);
					}
				}
				else//
				{
					if(pdr_pdf->GetId() == 44341742)
						int h = 0;									 

					//pdr_pdf
					pdr= NULL;
					BOOL bReset = FALSE;
					aplExtent ext_eff_rev;
					aplExtent pdr_eff_set;
					for(int j= 0; j<pdr_ext.GetSize(); j++)
					{
						aplExtent pdrEff;

						//  eff   
						GetPrdEffectivity(pdr_ext[j], sType, sStart, sEnd, eff_ext, &pdrEff);

						if(optionValue == 0)
						{
							m_deletedEffSet.Append(pdrEff);

							for(int m=0; m<pdrEff.Size; ++m)
								m_api->m_data.PutAttr(pdrEff[m], m_api->m_prd_mgr.a_pde_not_active, true);
						}
					}

					if(bDR)
					{
						GetPrdEffectivity(pdr_pdf, sType, _T(""), _T(""), pdr_eff_set);
						for(int k= 0; k<pdr_eff_set.GetSize(); k++)// eff
						{
							m_api->m_data.PutAttr(pdr_eff_set[k], m_api->m_prd_mgr.a_pde_not_active, true); 
							eff_ext.Remove(eff_ext.Find(pdr_eff_set[k]));
							m_deletedEffSet.Add(pdr_eff_set[k]);
							bReset = TRUE;
						}
						CaplInstance* eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
						if(eff3)
						{
							m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
							m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_sn_eff_start, sStart);
							m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_sn_eff_end, sEnd);
							m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_pdf);
						}
						m_addedEffSet.Add(eff3);
					}

					for(int k= 0; k<eff_ext.GetSize(); k++)// eff
					{
						ResetPrdEffectivity( eff_ext[k], sType, sStart, sEnd, pdr_ext_new, eff_ext_add);
						bReset = TRUE;
					}
					/*        a_pdr_inner_id,   */
					if(bReset)
						inner_id_map.Add(sPdrInnerId, 1);
					else if(optionValue != 0)
						bReset= (-1==inner_id_map.Get(sPdrInnerId))?FALSE:TRUE;
					//      ...
					if(sType==_T("dated"))
					{
						CreateDatedEffSet(bReset, sId, sStart, sEnd, pdr_pdf, pdr_ext_new, eff_ext_add, pdr);
					}
					else if(sType==_T("numbered"))
					{
						if(sStart.IsEmpty())
							CreateNumedEffSet(bReset, sId, sEnd, sStart, pdr_pdf, pdr_ext_new, eff_ext_add, pdr);
						else
							CreateNumedEffSet(bReset, sId, sStart, sEnd, pdr_pdf, pdr_ext_new, eff_ext_add, pdr);
					}
				}
				
				//    01.01.1900  01.01.1901
				//  ""  " "
				CreateFictiveEff(pdr_ext, sType);
			}
			else if(m_api->m_data.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdf))//
			{
				pdr= NULL;
				pd_ed=pdf_ing;
				pd_ing=pdr_pdf;
				
				if(!pd_ed || !pd_ing) continue;
				int j;
				
				find_values[0].value.Set(pd_ing);
				find_values[0].attr= m_api->m_prd_mgr.a_pdr_r_ting;
				find_values[1].value.Set(pd_ed);
				find_values[1].attr= m_api->m_prd_mgr.a_pdr_r_ted;
				
				//  
				if(!m_api->m_data.IsKindOf(items[i], e_mat))
				{
					m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_prd_mgr.e_acu, 2, &find_values[0], pdr_ext, true);

					double r;
					ld.ClearQuery();
					for(j= 0; j<pdr_ext.GetSize(); j++)
					{
						if(pdr_ext[j]->GetId())
							ld.AddQuery(0, pdr_ext[j]);
					}
					if(ld.m_queries.GetSize())
					{
						ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_pdr_frames_of_reference, true);
						ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_apl_qacu_value, true);
						ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_apl_qacu_unit, true);
						ld.LoadEx();
					}
					for(j= 0; j<pdr_ext.GetSize(); j++)
					{
						CString strId, strNum;
						m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_pdr_id, strId);
						m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_acu_ref_des, strNum);
						m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_apl_qacu_value, r);
						m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_apl_qacu_unit, inst);
						if(r==val && inst==unit && strId==sPos && strNum==sPosNum)
						{
							// .    -  pdr
							aplExtent cnts;
							m_api->m_data.GetAttr(pdr_ext[j], m_api->m_prd_mgr.a_pdr_frames_of_reference, cnts);
							bool bNotNew= false;
							
							if(cnts.GetSize()==contexts.GetSize()){bNotNew= true;}

							for(int r= 0; r<cnts.GetSize(); r++)
							{
								bNotNew= false;
								for(int t= 0; t<contexts.GetSize(); t++)
								{
									if(cnts[r]==contexts[t]){bNotNew= true; break;}
								}
							}
							if(bNotNew)
							{
								pdr= pdr_ext[j]; break;
							}
						}
					}				
				}
				else
				{
					
				}

				if(!pdr)
				{
					if(m_api->m_data.IsKindOf(items[i], e_mat))
					{
						pdr= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_make_from);
						if(pdr)
						{
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ting, pd_ing);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ted, pd_ed);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_id, sShap);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_name, sRequir);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_assortment, assortm);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_ranking, iPrior);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_unit, unit);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_value, val);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_derive_value, derVal);
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_make_from_derive_unit, der_unit);
						}					
					}
					else if(m_api->m_data.IsKindOf(items[i], e_psc))
					{
						pdr= m_api->m_prd_mgr.CreatePdfRelation(NULL, pd_ing, pd_ed, sPos, _T(""), val, unit);
						if(pdr)
						{
							m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_acu_ref_des, sPosNum);
						}
					}
					//
					m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_frames_of_reference, contexts);	
					newPdr= pdr;
				}
				if(!pdr) continue;

				// id  name  
				if(sName!=_T(""))
					m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_name, sName);
				if(sDscr!=_T(""))
					m_api->m_data.PutAttr(pdr, m_api->m_prd_mgr.a_pdr_descr, sDscr);

				//    
				GetPrdEffectivity( pdr, sType, sStart, sEnd, eff_ext);
				for(j= 0; j<eff_ext.GetSize(); j++)
				{
					ResetPrdEffectivity( eff_ext[j], sType, sStart, sEnd, pdr_ext_new, eff_ext_add);
				}
				//  eff  
				if(sType==_T("dated"))
				{
					eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);//   
					if(eff1)
					{
						m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
						m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sStart);
						m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
						if(!sEnd.IsEmpty())
						{
							m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, sEnd);						
							//-  , - 
							for(j= 0; j<eff_ext_add.GetSize(); j++)//  ,    
							{
								if(!eff_ext_add[i] || !eff_ext_add[i]->GetId() || !eff_ext_add[i]->GetType()) continue;
								
								CaplInstance* new_eff= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
								if(new_eff)
								{
									CaplInstance* eff_pdr= NULL; 
									CString sDate;
									m_api->m_data.GetAttr(eff_ext_add[i], m_api->m_prd_mgr.a_pde_id, sDate);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, sDate);
									m_api->m_data.GetAttr(eff_ext_add[i], m_api->m_prd_mgr.a_dat_eff_start_s, sDate);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_dat_eff_start_s, sDate);
									m_api->m_data.GetAttr(eff_ext_add[i], m_api->m_prd_mgr.a_pde_usage, eff_pdr);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_dat_eff_end_s, sEnd);
									m_api->m_data.PutAttr(eff_ext[j], m_api->m_prd_mgr.a_pde_not_active, true); 
									
									m_deletedEffSet.Add(eff_ext[j]);//eff_dell!!!
									m_addedEffSet.Add(new_eff);//eff_add!!!
								}

	/*							m_api->m_data.PutAttr(eff_ext[j], m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
								m_chngedEffSet.Add(eff_ext[j]);//eff_chng!!!*/
							}
							for(j= 0; j<pdr_ext_new.GetSize(); j++)
							{
								CaplInstance* eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
								if(eff3)
								{
									m_addedEffSet.Add(eff3);//eff_add!!!
									
									m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
									m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
									m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_ext_new[j]);
								}
							}
						}

						m_addedEffSet.Add(eff1);//eff_add!!!
					}
				}
				else if(sType==_T("numbered"))
				{
					eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
					if(eff1)
					{
						m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
						m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, sStart);
						m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
						if(!sEnd.IsEmpty())
						{
							m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, sEnd);						
							for(j= 0; j<eff_ext_add.GetSize(); j++)
							{
								if(!eff_ext_add[i] || !eff_ext_add[i]->GetId() || !eff_ext_add[i]->GetType()) continue;
								
								CaplInstance* new_eff= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
								if(new_eff)
								{
									CaplInstance* eff_pdr= NULL; 
									CString sDate;
									m_api->m_data.GetAttr(eff_ext_add[i], m_api->m_prd_mgr.a_pde_id, sDate);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, sDate);
									m_api->m_data.GetAttr(eff_ext_add[i], m_api->m_prd_mgr.a_sn_eff_start, sDate);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_start, sDate);
									m_api->m_data.GetAttr(eff_ext_add[i], m_api->m_prd_mgr.a_pde_usage, eff_pdr);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
									m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_end, sEnd);
									m_api->m_data.PutAttr(eff_ext[j], m_api->m_prd_mgr.a_pde_not_active, true); 
									
									m_deletedEffSet.Add(eff_ext[j]);//eff_dell!!!
									m_addedEffSet.Add(new_eff);//eff_add!!!
								}
	/*							m_api->m_data.PutAttr(eff_ext[j], m_api->m_prd_mgr.a_sn_eff_start, sEnd);							
								m_chngedEffSet.Add(eff_ext[j]);//eff_chng!!!*/
							}
							for(j= 0; j<pdr_ext_new.GetSize(); j++)
							{
								CaplInstance* eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
								if(eff3)
								{
									m_addedEffSet.Add(eff3);//eff_add!!!
									m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
									m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_sn_eff_start, sBufEnd);
									m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_ext_new[j]);
								}
							}
						}
						m_addedEffSet.Add(eff1);//eff_add!!!
					}
				}
			}

			m_api->m_data.PutAttr(items[i], a_psc_add_set, m_addedEffSet);
			m_api->m_data.PutAttr(items[i], a_psc_cancel_set, m_deletedEffSet);
			m_api->m_data.PutAttr(items[i], a_psc_modif_set, m_chngedEffSet);
			if(newPdr)
			{
				aplExtent chars;
				CaplInstance *new_char;
				CaplInstance *char_lock;
				CString sLocalDscr;

				m_api->m_data.PutAttr(items[i], a_psc_created_pdr, newPdr);
				
				m_api->m_data.GetAttr(items[i], a_chng_item_dscr, sLocalDscr);
				m_api->m_data.PutAttr(newPdr, m_api->m_prd_mgr.a_pdr_descr, sLocalDscr);
				
				m_api->m_charact_mgr.FindAssociatedCharacteristics(items[i], chars);
				
				for(int n= 0; n<chars.GetSize(); n++)
				{
					new_char=m_api->m_charact_mgr.CreateCopyCharacteristicVal(chars[n]);
					if(new_char) 
					{
						m_api->m_data.PutAttr(new_char, m_api->m_charact_mgr.a_apl_charact_val_item, newPdr);
						char_lock=m_api->m_charact_mgr.CreateCharValVersion(new_char,_T("0"),true);
					}
				}
			}
			m_api->m_data.PutAttr(items[i], a_chng_item_accept_date, sCurrDate);

			//   ...
			aplExtent effs;
			effs.Append(m_addedEffSet);effs.Append(m_chngedEffSet);
			FillEffChain(effs);

			//   		
			CaplInstance* ch_pdf= NULL;
			if(m_api->m_data.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdr))
			{
				m_api->m_data.GetAttr(pdr_pdf, m_api->m_prd_mgr.a_pdr_r_ting, inst);
				if(inst) ch_pdf=inst;
			}
			else if(m_api->m_data.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdf))
			{
				ch_pdf= pdr_pdf;
			}

			if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T(""))) 
			{
				m_api->m_appr_mgr.ChangeWFState(ch_pdf, _T("approved"), APL_NOT_TEST_POSSIBLE_STATES);
			}

			CString sSubject, sContent, buf;
			
			if(m_api->m_data.IsKindOf(items[i], e_mat))
			{
				sSubject=  APL_T("     ");
				sContent=  APL_T("    .");
			}
			else if(m_api->m_data.IsKindOf(items[i], e_psc))
			{
				sSubject=  APL_T("   ");
				sContent=  APL_T("   .");		
			}

			m_api->GetItemName(ch_pdf, buf);
			sSubject+=buf;

			aplExtent sbscr_ext;
			m_api->m_message_mgr.GetItemsSubscribers(ch_pdf, sbscr_ext);
			aplExtent wo;
			wo.Add(ch_pdf);
			m_api->m_message_mgr.SendNotifyMessage(NULL, sbscr_ext, sSubject, sContent, wo);

	//		m_api->SaveChanges();	//  ,    
										// ...   .
		}
		aplEndWaitDlg(dlgHandle);
		dlgHandle= 0;
		
		CString sId, sBasis, sStock;
		CString sSubject =  APL_T("  ");
		CString sContent =  APL_T("   .");

		dlgHandle = aplStartWaitDlg( APL_T(" ..."));		
		
		CaplInstance* doc, *old_rev, *new_rev;
		CString sState;
		
		for (i = 0; i < docs.GetSize(); i++)
		{
			doc= NULL;
			old_rev= NULL;
			new_rev= NULL;
			sState= _T("");

			m_api->m_data.GetAttr(docs[i], a_avc_new_rev, new_rev);
			m_api->m_data.GetAttr(docs[i], a_avc_doc, doc);
			m_api->m_data.GetAttr(docs[i], a_chng_item_replace_state, sState);
			// ayatsk:  -   
			// sState= _T("approved");
			m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_apl_doc_active, old_rev);

			//++[12.03.2012 ]            .
	// 		if(sDistrCode.CompareNoCase(_T("KVZ")))
	// 		{
	// 			if (new_rev&&old_rev)
	// 			{
	// 				CString sOldId;
	// 				CString sNewId;
	// 				m_api->m_data.GetAttr(old_rev,m_api->m_doc_mgr.a_apl_doc_rev_id,sOldId);
	// 				m_api->m_data.GetAttr(new_rev,m_api->m_doc_mgr.a_apl_doc_rev_id,sNewId);
	// 				if (sNewId<sOldId)
	// 				{
	// 					continue;
	// 				}
	// 			}
	// 		}

			m_api->m_data.PutAttr(docs[i], a_avc_old_rev, old_rev);
			
			/* :         */
			//if(sDistrCode.CompareNoCase(_T("KVZ")))
			if(!bKVZ)
				m_api->m_data.PutAttr(doc, m_api->m_doc_mgr.a_apl_doc_active, new_rev);
			m_api->m_data.PutAttr(docs[i], a_chng_item_accept_date, sCurrDate);
		
			m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_apl_doc_wf_state, buf);
			
			CString sVal;
			m_api->m_options_mgr.GetOptionValueBN(APL_NO_T(" \\      "), sVal, _T(""));
			if(!sVal.IsEmpty())
			{
				sVal= GetWFStateNameEng(sVal);
				if(sVal==_T("approved") || sVal==_T("not_change") || sVal==_T("canceled"))//     
					sState= sVal;
			}

			if(sState.IsEmpty())//   
			{
				if(buf==_T("approving") || buf==_T("changing") || buf==_T("approving_change"))
				{
					/* */
					ChangeWFState(doc, _T("approved"), APL_NOT_TEST_POSSIBLE_STATES);
	//				m_api->m_data.PutAttr(doc, m_api->m_doc_mgr.a_apl_doc_wf_state, _T("approved"));		
				}
			}
			else if(sState!=_T("not_change"))
			{
				ChangeWFState(doc, sState, APL_NOT_TEST_POSSIBLE_STATES);
			}

			//   
			m_api->m_doc_mgr.FromEntryValToDoc(new_rev);

			m_api->GetItemName(doc, buf);
			sSubject=  APL_T("  ") +buf;

			aplExtent sbscr_ext;
			m_api->m_message_mgr.GetItemsSubscribers(doc, sbscr_ext);
			aplExtent wo;
			wo.Add(doc);
			m_api->m_message_mgr.SendNotifyMessage(NULL, sbscr_ext,
				sSubject, sContent, wo);		
		}
		aplEndWaitDlg(dlgHandle);
		dlgHandle = 0;

		dlgHandle = aplStartWaitDlg( APL_T(" -..."));		
		for (i = 0; i < bps.GetSize(); i++)
		{
			CaplInstance* bp, *old_rev, *new_rev;

			m_api->m_data.GetAttr(bps[i], a_abpc_new_rev, new_rev);
			m_api->m_data.GetAttr(bps[i], a_abpc_bp, bp);
			
			m_api->m_data.GetAttr(bp, m_api->m_bp_mgr.a_bp_act, old_rev);
			m_api->m_data.PutAttr(bps[i], a_abpc_old_rev, old_rev);
			m_api->m_data.PutAttr(bps[i], a_chng_item_accept_date, sCurrDate);
			
			SetActive(bp, new_rev);
			
			CString sSubject=  APL_T(" - "), sContent=  APL_T("   -."),
				buf;
			
			m_api->GetItemName(bp, buf);
			sSubject+=buf;
				
			aplExtent sbscr_ext;
			m_api->m_message_mgr.GetItemsSubscribers(bp, sbscr_ext);
			aplExtent wo;
			wo.Add(bp);
			m_api->m_message_mgr.SendNotifyMessage(NULL, sbscr_ext,
				sSubject, sContent, wo);		
		}
 		aplEndWaitDlg(dlgHandle);
		dlgHandle = 0;

		dlgHandle = aplStartWaitDlg( APL_T(" ..."));
		for (i = 0; i < characts.GetSize(); i++)
		{
			CaplInstance* charact, *old_rev, *new_rev;

			m_api->m_data.GetAttr(characts[i], a_char_change_new_rev, new_rev);
			m_api->m_data.GetAttr(characts[i], a_char_change_val, charact);
			
			m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_act_ver, old_rev);
			m_api->m_data.PutAttr(characts[i], a_char_change_old_rev, old_rev);
			m_api->m_data.PutAttr(characts[i], a_chng_item_accept_date, sCurrDate);

			m_api->m_charact_mgr.MakeCharValVersionActive(new_rev);

			CString sSubject=  APL_T(" - ");
			CString sContent=  APL_T("   -.");
			CString buf;
			
			m_api->GetItemName(charact, buf);
			sSubject += buf;
				
			aplExtent sbscr_ext;
			m_api->m_message_mgr.GetItemsSubscribers(charact, sbscr_ext);
			aplExtent wo;
			wo.Add(charact);
			m_api->m_message_mgr.SendNotifyMessage(NULL, sbscr_ext,
				sSubject, sContent, wo);		
		}
		aplEndWaitDlg(dlgHandle);
		
		dlgHandle = aplStartWaitDlg( APL_T("  ..."));
		/*<  */

		if((flag&APL_CH_NO_TECH_APPLY)==0)
		{
			if(pApplyTechnologChange)
				pApplyTechnologChange(m_api, change, true, true);
			if (pApplyOGMetChange)
				pApplyOGMetChange(m_api,change,pdf_lockers);
		}

		aplEndWaitDlg(dlgHandle);
		dlgHandle = 0;

		m_api->SetAutoSave(bOldAutoSave);


		for(i= 0; i<pdf_lockers.GetSize(); i++)
			m_api->m_data.PutAttr(pdf_lockers[i], m_api->m_prd_mgr.a_apl_pdf_locker, (CaplInstance*)NULL);
		for(i=0; i<pdf_locker_map.Size; i++)
			m_api->m_data.PutAttr((CaplInstance*)(pdf_locker_map[i].in), m_api->m_prd_mgr.a_apl_pdf_locker, (CaplInstance*)(pdf_locker_map[i].out));

		//   - "   ",  ,         (LimitsEditor.exe)
		CaplInstance *needRecalcLimitscharact = m_api->m_charact_mgr.GetCharacteristicBN(APL_T("   "));
		if(needRecalcLimitscharact)
			m_api->m_charact_mgr.CreateDescriptiveCharacteristic(change, needRecalcLimitscharact, 0, 0);
	}	
	m_api->m_data.PutAttr(change, a_chng_user, sUser);
	m_api->m_data.PutAttr(change, a_chng_autor, person);
	m_api->m_data.PutAttr(change, a_chng_apply_date, sCurrDate);
	m_api->m_data.PutAttr(change, a_chng_state, _T("applied"));

	m_api->m_data.GetAttr(change, a_chng_validity_pi_date, buf);
	apidata.PutAttr(change, m_api->m_change_mgr.a_chng_validity_pi_date_actual, buf);

	if(0!=dlgHandle) aplEndWaitDlg(dlgHandle);
	if(m_api->m_AutoSave)
	{
		m_api->SaveChanges();
	
		// 
 		extAccess.Add(change);
	}

	if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T(""))) //    
	{
		CString sChangeId;//  

		aplExtent ext_esi_docs;  //  esi

		aplExtent ext_changed_pdf; //        (  )
		CStringArray  str_array_changed_pdf_num_izm;  //    ext_changed_pdf
		int index_ext_changed_pdf=0;
		CString sChangeNums,tmp_num;

		//   
		m_api->m_data.GetAttr(change, a_chng_items, aggr);
		for(i= 0; i<aggr.GetSize(); i++)// 
		{
			inst= aggr[i];
			if(!inst) continue;
			if(!inst->GetType()) continue;

			if(i==0)
			{
				CaplInstance *change;
				m_api->m_data.GetAttr(inst, a_chng_item_of_chng, change);
				m_api->m_data.GetAttr(change, a_chng_id, sChangeId);
			}

			if(!m_api->m_data.IsKindOf(inst, e_psc)) continue;
			m_api->m_data.GetAttr(inst, a_chng_item_id, buf);
			buf+=_T(",");

			m_api->m_data.GetAttr(inst, a_psc_changed_product, inst);
			if(!m_api->m_data.IsKindOf(inst, m_api->m_prd_mgr.e_pdf))
			{
				m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_pdr_r_ting, inst);
			}

			//       ( )
			index_ext_changed_pdf=ext_changed_pdf.Add(inst);
			tmp_num=_T(",")+buf;
			if(index_ext_changed_pdf>=str_array_changed_pdf_num_izm.GetSize()) str_array_changed_pdf_num_izm.SetSize(index_ext_changed_pdf+1);
			sChangeNums=str_array_changed_pdf_num_izm[index_ext_changed_pdf];
			if(sChangeNums.Find(tmp_num)<0)
			{
				if(sChangeNums==_T("")) sChangeNums=_T(",");
				sChangeNums+=buf;
				str_array_changed_pdf_num_izm.SetAt(index_ext_changed_pdf,sChangeNums);
			}
		}

		for(i=0;i<ext_changed_pdf.GetSize();i++)
		{
			CaplInstance *pdf=ext_changed_pdf[i];
			buf=str_array_changed_pdf_num_izm[i];
			sChangeNums=buf.Mid(1,buf.GetLength()-2); //     
			buf=sChangeId+_T(" (")+sChangeNums+_T(")"); 		

			CaplInstance *doc_rev=m_api->m_prd_mgr.GenerateESI(pdf,buf,false);
			ext_esi_docs.Add(doc_rev);
		}
		m_api->SaveChanges();

		if(ext_esi_docs.GetSize()>0) //   
		{
			bool bSave=false;
			CaplInstance *proc;
			aplExtent ext_proc;
			CaplDeclareWorkflowManager *wf_mgr =m_api->m_wf_mgr;
			wf_mgr->FindProcessContained(change,ext_proc);
			wf_mgr->LoadProcessInfo(ext_proc);
			for(i=0;i<ext_proc.GetSize();i++)
			{
				proc=ext_proc[i];
				if(proc->GetAccessmode()>aplRW) continue;
				m_api->m_data.GetAttrBN(proc, _T("state")/*wf_mgr->a_proc_state*/, buf);
				if(buf!=_T("running") && buf!=_T("initiated") ) continue;

				aplExtent ext_wo;
				m_api->m_data.GetAttrBN(proc, _T("work_objects")/*wf_mgr.a_proc_wo*/, ext_wo);

				int k;
				for(k=0;k<ext_esi_docs.GetSize();k++)
				{
					CaplInstance *w_new_item=ext_esi_docs[k];

					bool bIsNew=true;
					for(int j= 0; j<ext_wo.GetSize(); j++)
					{
						CaplInstance* wo= ext_wo[j];
						CaplInstance*w_item=0;
						if(wo)
							m_api->m_data.GetAttrBN(wo, _T("object")/*wf_mgr.a_wo_object*/, w_item);
						if(w_new_item==w_item) {bIsNew= false; break;}
					}
					if(bIsNew)
					{
						CaplInstance* wo= m_api->m_data.CreateInstanceBN(_T("apl_work_object")/*m_doc->m_wf_mgr.e_wo*/);
						if(wo)
						{
							m_api->m_data.PutAttrBN(wo, _T("object") /* wf_mgr.a_wo_object*/, w_new_item);
							m_api->m_data.PutAttrBN(wo, _T("action") /*wf_mgr.a_wo_action*/, proc);
							ext_wo.Add(wo);
							m_api->m_data.PutAttrBN(proc,_T("work_objects") /*wf_mgr.a_proc_wo*/, ext_wo);
							bSave=true;
						}
					}
				}
			}
			if(bSave) m_api->m_data.NET_SaveChanges();
		}
	}
	return APL_CN_NO_ERR;
}

bool CaplChangeManager::GetAllChanges(CaplInstance* pdf_or_doc, aplExtent &changes, bool bNotAppliedOnly)
{
	if (pdf_or_doc==NULL) return false;
	if (pdf_or_doc->GetId()==0) return false;
	if (pdf_or_doc->GetType()==0) return false;
	if (!m_data || !m_api->m_data.IsConnected()) return false; 	

	aplExtent psc_ext, ext, pdr_ext;
	int i, count;
	CString sQueryTmpl= _T("SELECT Ext1 OR Ext2 FROM ")
		_T("Ext0{%s} ")
		_T("Ext1{apl_product_structure_change(.changed_product IN #Ext0 ");		

	if(bNotAppliedOnly)
	{
		sQueryTmpl+=_T(" and .of_change->apl_change.state != 'applied' ");		
		sQueryTmpl+=_T(" and .of_change->apl_change.state != 'canceled' ");		
	}
	sQueryTmpl+=_T(")}.of_change ");
	sQueryTmpl+=_T("Ext2{apl_change(.changed_assemlies LIKE #%i ");
	if(bNotAppliedOnly)
	{
		sQueryTmpl+=_T(" and .state != 'applied' ");
		sQueryTmpl+=_T(" and .state != 'canceled' ");
	}
	sQueryTmpl+=_T(")} END_SELECT");
	CString sQuery;
	CString sAssemblyData;
	CString buf;

	changes.Clear();
	CaplAttrValue find_values[4];

	aplExtent tmpExt;
	
	if (m_api->m_data.IsKindOf(pdf_or_doc, m_api->m_prd_mgr.e_apl_pdf) /*???*/|| m_api->m_data.IsKindOf(pdf_or_doc, m_api->m_prd_mgr.e_pdr))
	{
		sAssemblyData.Format(_T("#%i"), pdf_or_doc->GetId());	
		m_api->m_prd_mgr.LoadAllSubProduct(NULL, NULL, pdf_or_doc, pdr_ext, ext);

		for(i=0,count=0; i<pdr_ext.GetSize(); i++, ++count)
		{
			sAssemblyData+=_T(", ");
			buf.Format(_T("#%i"), pdr_ext[i]->GetId());
			sAssemblyData+=buf;

			if(count == 150 || count == pdr_ext.Size-1)
			{
				sQuery.Format(sQueryTmpl, sAssemblyData, pdf_or_doc->GetId());
				if(m_api->m_data.NET_QueryEditParse(sQuery))
					m_api->m_data.NET_QueryExecute(tmpExt);

				sAssemblyData.Format(_T("#%i"), pdf_or_doc->GetId());
				changes.Append(tmpExt);
				tmpExt.Clear();
				count = 0;
			}
		}
		
		sQuery.Format(sQueryTmpl, sAssemblyData, pdf_or_doc->GetId());
		if(m_api->m_data.NET_QueryEditParse(sQuery))
		{
			m_api->m_data.NET_QueryExecute(tmpExt);
			changes.Append(tmpExt);
		}
		

		// pdf
// 		find_values[0].value.Set(pdf_or_doc);
// 		find_values[0].attr = a_psc_changed_product;
// 		m_api->m_data.NET_FindInstancesWithAttrValues(e_psc, 1, &find_values[0], psc_ext, true);	
// 		for(i= 0; i<psc_ext.GetSize(); i++)
// 		{
// 			find_values[0].value.Set(psc_ext[i]);
// 			find_values[0].attr= a_chng_items;
// 			m_api->m_data.NET_FindInstancesWithAttrValues(e_chng, 1, &find_values[0], ext, true);	
// 			for(j= 0; j<ext.GetSize(); j++)
// 			{
// 				if(-1==changes.Find(ext[j]))
// 				{
// 					changes.Add(ext[j]);
// 				}
// 			}
// 		}
// 		
// 		// pdr
// 		m_api->m_prd_mgr.LoadAllSubProduct(NULL, NULL, pdf_or_doc, pdr_ext, ext);
// 		for(i= 0; i<pdr_ext.GetSize(); i++)
// 		{
// 			find_values[0].value.Set(pdr_ext[i]);
// 			find_values[0].attr= a_psc_changed_product;
// 			m_api->m_data.NET_FindInstancesWithAttrValues(e_psc, 1, &find_values[0], psc_ext, true);	
// 			
// 			for(j= 0; j<psc_ext.GetSize(); j++)
// 			{
// 				find_values[0].value.Set(psc_ext[j]);
// 				find_values[0].attr= a_chng_items;
// 				m_api->m_data.NET_FindInstancesWithAttrValues(e_chng, 1, &find_values[0], ext, true);	
// 				for(int k= 0; k<ext.GetSize(); k++)
// 				{
// 					if(-1==changes.Find(ext[k]))
// 					{
// 						changes.Add(ext[k]);
// 					}
// 				}
// 			}
// 		}
		if(changes.GetSize())
		{
			CaplLoadData ld(m_data,DEF_SOURCE);

			for(i= 0; i<changes.GetSize(); i++)
			{
				ld.AddQuery(0, changes[i], true);
			}
			ld.LoadEx();
		}
	}
	else if(m_api->m_data.IsKindOf(pdf_or_doc, m_api->m_doc_mgr.e_doc))
	{
		CaplLoadData ld(m_data,DEF_SOURCE);
	int i=	ld.AddQuery(_T('b'), pdf_or_doc->GetId(), e_avc, a_avc_doc, true, true);
			ld.AddQuery(_T('d'), i, 0, a_chng_item_attachment, true, true);
			ld.AddQuery(_T('d'), i, 0, a_avc_new_rev, true, true);
			ld.AddQuery(_T('d'), i, 0, a_avc_old_rev, true, true);
			ld.LoadEx();

		aplExtent ext;
		m_api->m_data.GetEntityExtent(e_avc, ext);
		for(i= 0; i<ext.GetSize(); i++)
		{
			CaplInstance* doc= NULL;
			m_api->m_data.GetAttr(ext[i], a_avc_doc, doc);
			if(doc==pdf_or_doc) changes.Add(ext[i]);
		}
	}
	else if(m_api->m_data.IsKindOf(pdf_or_doc, m_api->m_bp_mgr.e_bp))
	{
		CaplLoadData ld(m_data,DEF_SOURCE);
	int i=	ld.AddQuery(_T('b'), pdf_or_doc->GetId(), e_abpc, a_abpc_bp, true, true);
			ld.AddQuery(_T('d'), i, 0, a_chng_item_attachment, true, true);
			ld.AddQuery(_T('d'), i, 0, a_abpc_new_rev, true, true);
			ld.AddQuery(_T('d'), i, 0, a_abpc_old_rev, true, true);		
			ld.LoadEx();

		aplExtent ext;
		m_api->m_data.GetEntityExtent(e_abpc, ext);
		for(i= 0; i<ext.GetSize(); i++)
		{
			CaplInstance* bp= NULL;
			m_api->m_data.GetAttr(ext[i], a_abpc_bp, bp);
			if(bp==pdf_or_doc) changes.Add(ext[i]);
		}		
	}
	else if (m_api->m_data.IsKindOf(pdf_or_doc, m_api->m_charact_mgr.e_apl_charact_value))
	{
		CaplLoadData ld(m_data, DEF_SOURCE);
	int i =	ld.AddQuery(_T('b'), pdf_or_doc->GetId(), e_char_change, a_char_change_val, true, true);
			ld.AddQuery(_T('d'), i, 0, a_chng_item_attachment, true, true);
			ld.AddQuery(_T('d'), i, 0, a_char_change_new_rev, true, true);
			ld.AddQuery(_T('d'), i, 0, a_char_change_old_rev, true, true);		
			ld.LoadEx();

		aplExtent ext;
		m_api->m_data.GetEntityExtent(e_char_change, ext);
		for (i = 0; i<ext.GetSize(); i++)
		{
			CaplInstance* charact = NULL;
			m_api->m_data.GetAttr(ext[i], a_char_change_val, charact);
			if (charact == pdf_or_doc)
				changes.Add(ext[i]);
		}
	}

	return true;
}

bool CaplChangeManager::ReturnChangeToEdit(CaplInstance* change)
{
	if (m_data == NULL)		return false;
	if (change == NULL)		return false;
	if (change->GetId() == 0) 		return false;
	if (change->GetType() == 0)		return false;

	CString sStr;
	CString sDate;
	CString buf;
	aplExtent apprs;
	CaplInstance* status;
	int i;
	COleDateTime odt;


	CString sVal;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\      "), sVal, _T(""));
	if(sVal!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,sVal)) {AfxMessageBox(APL_T("    !"));	return false; }
	}
	if(m_api->m_options_mgr.CheckInstallCode(_T("grpz")))
	{
		if(!m_api->m_appr_mgr.CheckPersonInWgApproval(0,change,APL_T(""),APL_T("")) )
		{AfxMessageBox(APL_T("     !"), MB_ICONSTOP|MB_OK); return false;} 
	}


	m_api->m_appr_mgr.LoadItemApproval(change, apprs);
	if(apprs.GetSize() && IDNO==AfxMessageBox( APL_T("   .     .\n ?"), MB_YESNO|MB_ICONWARNING|MB_DEFBUTTON2))
		return false;

	m_api->m_data.NET_GetServerDateTime(odt);
	aplDate2String(odt, sDate);


	int iValue=0;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\       "), iValue, 0);
	if(1!=iValue)
	{ //   
		m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_id, buf);
		CaplInstance *doc=m_api->m_doc_mgr.FindDocById(buf);
		if(doc!=0)
		{
			m_api->m_doc_mgr.LoadDocInfo(doc);
			CaplInstance *rev=0;
			m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_apl_doc_active, rev);
			if(0!=rev)
			{
				aplExtent apprs1; 
				m_api->m_appr_mgr.LoadItemApproval(rev, apprs1);
				apprs.Append(apprs1);
			}
		}
	}

	for(i= 0; i<apprs.GetSize(); i++)
	{
		if(apprs[i]->GetAccessmode()>aplRW)
		{
			m_api->m_data.GetAttr(apprs[i], m_api->m_appr_mgr.a_appr_revocation_date_time, buf);		
			if(buf==_T(""))
			{
				if(apprs[i]->GetAccessmode()==aplRO)
				{
					m_api->m_data.GetAttr(apprs[i], m_api->m_appr_mgr.a_appr_status, status);
					m_api->m_data.GetAttr(status, m_api->m_appr_mgr.a_appr_status_name, buf);
					sStr= _T(" \"")+buf+_T(" ");

					m_api->m_data.GetAttr(apprs[i], m_api->m_appr_mgr.a_appr_role, buf);
					sStr+=buf+_T(" ");

					m_api->m_data.GetAttr(apprs[i], m_api->m_appr_mgr.a_appr_pers_org, status);
					m_api->m_appr_mgr.GetPersonName(status, buf);
					sStr+=buf+_T("\"");
				}

				AfxMessageBox( APL_T("       ")+sStr+_T("!"), MB_OK|MB_ICONERROR);
				return false;
			}
		}
	}

	for(i= 0; i<apprs.GetSize(); i++)
	{
		m_api->m_data.GetAttr(apprs[i], m_api->m_appr_mgr.a_appr_revocation_date_time, buf);		
		if(buf==_T(""))
			m_api->m_data.PutAttr(apprs[i], m_api->m_appr_mgr.a_appr_revocation_date_time, sDate);		
	}

	sStr= _T("not_applied");
	m_api->m_data.PutAttr(change, m_api->m_change_mgr.a_chng_state, sStr);

	if(m_api->m_options_mgr.CheckInstallCode(_T("grpz"))) 
	{
		m_api->m_data.PutAttr(change,m_api->m_change_mgr.a_chng_to_date, _T(""));
		m_api->m_data.PutAttr(change, m_api->m_change_mgr.a_chng_complect_num, _T(""));

	}

	m_api->SaveChanges();
	return true;
}

bool CaplChangeManager::UndoChange(CaplInstance* change)
{
	if (m_data == NULL)		return false;
	if (change == NULL)		return false;
	if (change->GetId() == 0) 		return false;
	if (change->GetType() == 0)		return false;

	bool bIsGoodBoy = true;

	if(!m_api->m_data.IsAdmin())
	{
		int iVal;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\  \" \""), iVal, 0);
		if(0!=iVal) bIsGoodBoy=m_api->m_appr_mgr.CheckPersonRole(0,APL_NO_T(" "));

		if(bIsGoodBoy)
		{
			CString sVal;
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "), sVal, _T(""));
			if(sVal!=_T(""))bIsGoodBoy=m_api->m_appr_mgr.CheckPersonRole(0,sVal);
		}
	}


	if(!bIsGoodBoy)
	{
		if(m_api->m_ModeInteractive)
			AfxMessageBox( APL_T("       ."), MB_OK|MB_ICONERROR);

		return false;
	}

	if(m_api->m_ModeInteractive)
	{
		if(IDNO==AfxMessageBox( APL_T("     ?"), MB_YESNO|MB_ICONWARNING))
			return false;
	}

	CaplAdminModeProvider adminmode(&(m_api->m_data),-1, -1,DEF_SOURCE);

	aplExtent items;
	m_api->m_data.GetAttr(change, a_chng_items, items);
	LoadItemInfo(items);

	//////////////////////////////////////////////////////////////////////////

	aplExtent extCreatedPdr;
	aplExtent extTechAsmUsedCreatedPdr;

	for (int iChangeIndex = 0; iChangeIndex < items.GetSize(); iChangeIndex++)
	{
		CaplInstance *pChangedItem = items[iChangeIndex];

		if (m_api->m_data.IsKindOf(pChangedItem, m_api->m_change_mgr.e_psc)) 
		{
			CaplInstance *pCreatedPdr = NULL;

			m_api->m_data.GetAttr(pChangedItem, m_api->m_change_mgr.a_psc_created_pdr, pCreatedPdr);

			if (pCreatedPdr != NULL)
				extCreatedPdr.Add(pCreatedPdr);
		}
	}

	CString strInstanceList;
	CString strInstance;
	CString strQuery;
	CString strQueryRelationFormat = 
		_T("SELECT ")		
		_T("Ext_1 ")
		_T("FROM ")
		_T("Ext_0 {%s} ")
		_T("Ext_1 {product_definition_relationship (.relating_product_definition-> ")
		_T("apl_product_definition_formation.formation_type LIKE 'kit' AND ")
		_T(" .parent_reference IN #Ext_0)} ")
		_T("END_SELECT");
/*
	CString strQueryRelationFormat = 
		_T("SELECT ")		
		_T("Ext_1 ")
		_T("FROM ")
		_T("Ext_0 {%s} ")
		_T("Ext_1 { product_definition_relationship (.relating_product_definition-> ")
		_T("apl_product_definition_formation.formation_type LIKE 'kit' AND ")
		_T(".parent_reference IN #Ext_0)} ")
		_T("END_SELECT");
*/

	for (int iIndex = 0; iIndex < extCreatedPdr.GetSize(); iIndex++)
	{
		if (iIndex > 0)
			strInstanceList += CString(_T(", "));

		strInstance.Format(_T("#%d"), extCreatedPdr[iIndex]->GetId());
		strInstanceList += strInstance;		
	}

	if (!strInstanceList.IsEmpty())
	{
		strQuery.Format(strQueryRelationFormat, strInstanceList);	

		if (!m_api->m_data.NET_QueryEditParse(strQuery, FALSE))
		{
			return FALSE;
		}

		if (!m_api->m_data.NET_QueryExecute(extTechAsmUsedCreatedPdr,  APL_T(" ...")))
		{
			return FALSE;
		}
	}

	m_api->LoadExtentInfo(extTechAsmUsedCreatedPdr);
	CaplLoadData ld1(&m_api->m_data, DEF_SOURCE);
	for(int i=0; i<extTechAsmUsedCreatedPdr.Size; ++i)
	{
		ld1.AddQuery(0, extTechAsmUsedCreatedPdr[i], true);		
		int ingIndex =	ld1.AddQuery(_T('d'), 0, m_api->m_prd_mgr.e_pdr, m_api->m_prd_mgr.a_pdr_r_ting, true, true);
						ld1.AddQuery(_T('d'), ingIndex, m_api->m_prd_mgr.e_pdf, m_api->m_prd_mgr.a_pdf_prd, true, true);
	}
	ld1.LoadEx();

	for (int iIndex = 0; iIndex < extTechAsmUsedCreatedPdr.GetSize(); iIndex++)
	{
		CaplInstance *pComponentPDF = NULL;
		CaplInstance *pComponentPRD = NULL;
		CString strDescr;
		CString strName;

		m_api->m_data.GetAttr(extTechAsmUsedCreatedPdr[iIndex], m_api->m_prd_mgr.a_pdr_r_ting, pComponentPDF);
		m_api->m_data.GetAttr(pComponentPDF, m_api->m_prd_mgr.a_pdf_prd, pComponentPRD);
		m_api->m_data.GetAttr(pComponentPRD, m_api->m_prd_mgr.a_prd_id, strDescr);
		m_api->m_data.GetAttr(pComponentPRD, m_api->m_prd_mgr.a_prd_name, strName);
	}

	if(m_api->m_ModeInteractive)
	{
		if (extTechAsmUsedCreatedPdr.GetSize() > 0)
		{
			if (AfxMessageBox( APL_T("  ,        ,    .\n?"), MB_YESNO | MB_ICONQUESTION) == IDNO)
			{
				return FALSE;
			}
		}
	}


	//////////////////////////////////////////////////////////////////////////
	
	long dlgHandle= aplStartWaitDlg( APL_T(" ..."));

	CaplLoadData ld(m_data,DEF_SOURCE);

	//
	bool bLastChange= true;
	bool bShowChangeTree= false;
	
	aplExtent doc_bp_del_changes;	//  ,   ""  
								//   - 
								// ,   .
	aplExtent all_deleted_effs; //   ,    
	aplExtent effs;
	bool bHided;
	bool bCheckForTechChange= false;
	int i, k;

	for(i= 0; i<items.GetSize(); i++)
	{
		m_api->m_data.GetAttr(items[i], a_psc_cancel_set, effs);			
		all_deleted_effs.Append(effs);
	}
	
	CSortClass::SortExtentByInst(all_deleted_effs);

	for(i= 0; i<items.GetSize(); i++)
	{		
		if(!bLastChange) break;
		
		if(m_api->m_data.IsKindOf(items[i], e_psc))
		{
			//   
			// -  -    
			m_api->m_data.GetAttr(items[i], a_psc_add_set, effs);			
			if(!effs.GetSize()) continue;

			ld.ClearQuery();
			for(k= 0; k<effs.GetSize(); k++)
			{
				ld.AddQuery(0, effs[k]);
			}			
		int t= ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_pde_usage, true);
				ld.AddQuery(_T('d'), t, 0, m_api->m_prd_mgr.a_pdr_r_ted, true);
			ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_pde_not_active, true);
			ld.LoadEx();

			for(k= 0; k<effs.GetSize(); k++)
			{
				bHided= false;
				m_api->m_data.GetAttr(effs[k], m_api->m_prd_mgr.a_pde_not_active, bHided);

				if(bHided)
				{
					if(-1!=all_deleted_effs.Find(effs[k])) continue;

					bLastChange= false;
					CString sMessage, sName;
					
					// _ed    effectivity
					CaplInstance *prd= NULL, *pdf= NULL, *pdr= NULL;
					m_api->m_data.GetAttr(effs[k], m_api->m_prd_mgr.a_pde_usage, pdr);
					m_api->m_data.GetAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ted, pdf);
					m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
					if(!prd)
					{
						m_api->m_prd_mgr.LoadPrdInfo(pdf);
						m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
					}

					if(pdf) m_api->GetItemName(pdf, sName);

					aplEndWaitDlg(dlgHandle); dlgHandle= 0;
					
					if(m_api->m_ModeInteractive)
					{
						sMessage.Format( APL_T("   ,     \"%s\".\n  .\n\n  ?"), sName);

						if(IDYES==AfxMessageBox(sMessage, MB_YESNO|MB_ICONERROR))
							bShowChangeTree= true;
					}
					break;
				}
			}
		}
		// 
		else if(m_api->m_data.IsKindOf(items[i], e_avc))
		{
			/*    */
			//if(!sDistrCode.CompareNoCase(_T("KVZ")))
			if(m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
				continue;

			CaplInstance* act= NULL, *doc= NULL;
			m_api->m_data.GetAttr(items[i], a_avc_new_rev, act);
			if(act && act->attrs==0) m_api->m_doc_mgr.LoadDocInfo(act);
			m_api->m_data.GetAttr(act, m_api->m_doc_mgr.a_apl_doc_rev_doc, doc);
			
			bool bAddedToDel= false;			
			aplExtent doc_changes;
			GetAllChanges(doc, doc_changes);
			//  .
			aplSortByDate(&m_api->m_data, doc_changes, 
				0, doc_changes.GetSize()-1, a_chng_item_accept_date);
			for(k= doc_changes.GetSize(); k>0; k--)
			{
				CaplInstance* chng= NULL;
				m_api->m_data.GetAttr(doc_changes[k-1], a_chng_item_of_chng, chng);
				if(!chng)
				{
					//    ...
					doc_bp_del_changes.Add(doc_changes[k]);
					bAddedToDel= true; continue;
				}
//				if(chng!=items[i]) bLastChange= false;
				if(chng!=change) bLastChange= false;
				break;
			}

			if(!bLastChange)
			{
				if(m_api->m_ModeInteractive)
				{
					CString sName, sMessage;
					m_api->GetItemName(doc, sName);
					sMessage.Format( APL_T("   ,     \"%s\".\n  .\n\n  ?"), sName);
					if(IDYES==AfxMessageBox(sMessage, MB_YESNO|MB_ICONERROR))
						bShowChangeTree= true;
				}
			}
			else if(bAddedToDel)
			{
				//,     , ...
			}
		}
		// -
		else if(m_api->m_data.IsKindOf(items[i], e_abpc))
		{
			CaplInstance* act= NULL, *bp= NULL;
			m_api->m_data.GetAttr(items[i], a_abpc_new_rev, act);
			m_api->m_data.GetAttr(act, m_api->m_bp_mgr.a_bp_ver_bp, bp);
			
			bool bAddedToDel= false;			
			aplExtent bp_changes;
			GetAllChanges(bp, bp_changes);
			//  .
			aplSortByDate(&m_api->m_data, bp_changes, 0, bp_changes.GetSize()-1, a_chng_item_accept_date);
			for(k= bp_changes.GetSize(); k>0; k--)
			{
				CaplInstance* chng= NULL;
				m_api->m_data.GetAttr(bp_changes[k-1], a_chng_item_of_chng, chng);
				if(!chng)
				{
					//    ...
					doc_bp_del_changes.Add(bp_changes[k]);
					bAddedToDel= true; continue;
				}
//				if(chng!=items[i]) bLastChange= false;
				if(chng!=change) bLastChange= false;
				break;
			}

			if(!bLastChange)
			{
					if(m_api->m_ModeInteractive)
				{
					CString sName, sMessage;
					m_api->GetItemName(bp, sName);
					sMessage.Format( APL_T("   ,      \"%s\".\n  .\n\n  ?"), sName);
					if(IDYES==AfxMessageBox(sMessage, MB_YESNO|MB_ICONERROR))
						bShowChangeTree= true;
				}

			}
			else if(bAddedToDel)
			{
				//,     , ...
			}
		}
		// -
		else if (m_api->m_data.IsKindOf(items[i], e_char_change))
		{
			CaplInstance* act = NULL, *charact = NULL;
			m_api->m_data.GetAttr(items[i], a_char_change_new_rev, act);
			m_api->m_data.GetAttr(act, m_api->m_charact_mgr.a_apl_charact_val_act_ver, charact);

			bool bAddedToDel = false;			
			aplExtent charact_changes;
			GetAllChanges(charact, charact_changes);
			
			//  .
			aplSortByDate(&m_api->m_data, charact_changes, 0, charact_changes.GetSize() - 1, a_chng_item_accept_date);
			for (k = charact_changes.GetSize(); k > 0; k--)
			{
				CaplInstance* chng = NULL;
				m_api->m_data.GetAttr(charact_changes[k - 1], a_chng_item_of_chng, chng);
				if (!chng)
				{
					//     ...
					doc_bp_del_changes.Add(charact_changes[k]);
					bAddedToDel = true;
					continue;
				}

				if (chng != change)
					bLastChange= false;

				break;
			}

			if (!bLastChange)
			{
				if(m_api->m_ModeInteractive)
				{
					CString sName, sMessage;
					m_api->GetItemName(charact, sName);
					sMessage.Format( APL_T("   ,    - \"%s\".\n  .\n\n  ?"), sName);
					if(IDYES==AfxMessageBox(sMessage, MB_YESNO|MB_ICONERROR))
						bShowChangeTree = true;
				}

			}
			else if (bAddedToDel)
			{
				//,     , ...
			}
		}
		else if(m_api->m_data.IsKindOf(items[i], e_chng_item))
		{
			bCheckForTechChange= true;
		}
	}//

	if (dlgHandle)
	{
		aplEndWaitDlg(dlgHandle);
		dlgHandle= 0;
	}
	
	if (!bLastChange)
	{
		if (bShowChangeTree)
			ShowChangesTree(change);
		
		return false;
	}

	/*<  */
	HINSTANCE hLibrary= NULL;
	bool (*pIsChangeCorrect)(CaplAPI *api, CaplInstance *ciChng, aplExtent &aeWrongRels);
	bool (*pApplyTechnologChange)(CaplAPI *api, CaplInstance *ciChng, bool bApplyChng, bool bLoadFromBase);

	HINSTANCE hLibraryOGMet = NULL;
	bool (*pUndoOGMetChange)(CaplAPI* api, CaplInstance* ciChange, aplExtent& aeAssemblies);


	pIsChangeCorrect= NULL;
	pApplyTechnologChange= NULL;
	pUndoOGMetChange= NULL;

	//if(bCheckForTechChange && !sDistrCode.CompareNoCase(_T("KVZ")))
	if(bCheckForTechChange && m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
	{
#ifdef _DEBUG
		hLibrary= AfxLoadLibrary(_T("aplchangemodule.dll"));
#else
		hLibrary= AfxLoadLibrary(_T("aplchangemodule.dll"));
#endif
		if(hLibrary)
		{
			(FARPROC&)pIsChangeCorrect = ::GetProcAddress(hLibrary, "IsChangeCorrect");
			(FARPROC&)pApplyTechnologChange = ::GetProcAddress(hLibrary, "ApplyTechnologChange");
		}

	}
	//if(!sDistrCode.CompareNoCase(_T("KVZ")))
	if(m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
	{
		hLibraryOGMet = AfxLoadLibrary(_T("aplOGMet.dll"));
		if (hLibraryOGMet)
		{
			(FARPROC&)pUndoOGMetChange = ::GetProcAddress(hLibraryOGMet, "UndoOGMetChange");
		}
	}



	for (i = 0; i < doc_bp_del_changes.GetSize(); i++)
	{
		if(doc_bp_del_changes[i])
			m_api->m_data.DeleteInstance(doc_bp_del_changes[i]);
	}

	CString str;
	aplExtent newPdrs;
	aplExtent aePdfLockers;
	CaplInstance *cit = NULL, *ciPdf = NULL;
	
	for (i= 0; i < items.GetSize(); i++)
	{		 
		bool bCanDelete = true;
		if(m_api->m_data.IsKindOf(items[i], e_psc))
		{
			CaplInstance* pdr_pdf= NULL, *pdr= NULL, *pd_ing= NULL, *pd_ed= NULL, *unit= NULL, *newPdr= NULL;
			double val;
			CString sPdrInnerId, sId, sType, sStart, sEnd, sPos;
			CaplAggr contexts;


			///////////////////////////////////////////     
			m_api->m_data.GetAttr(items[i], m_api->m_change_mgr.a_psc_changed_product, pd_ed);
			m_api->m_data.GetAttr(items[i], m_api->m_change_mgr.a_psc_changing_product, pd_ing);

			if(m_api->m_data.IsKindOf(pd_ed, m_api->m_prd_mgr.e_pdf))
				ciPdf = pd_ed;
			else if(m_api->m_data.IsKindOf(pd_ed, m_api->m_prd_mgr.e_pdr)/* && pd_ing*/)
				m_api->m_data.GetAttr(pd_ed, m_api->m_prd_mgr.a_pdr_r_ting, ciPdf);

			if(ciPdf)
			{
				m_api->m_data.PutAttr(ciPdf, m_api->m_prd_mgr.a_apl_pdf_locker, change);
				aePdfLockers.Add(ciPdf);
			}
			/////////////////////////////////////////// ///////////////////////////////////////////  
								
			
			//  
			m_api->m_data.GetAttr(items[i], a_psc_value, val);
			m_api->m_data.GetAttr(items[i], a_psc_unit, unit);
			m_api->m_data.GetAttr(items[i], a_psc_eff_type, sType);
			if(sType==_T("dated"))
			{
				m_api->m_data.GetAttr(items[i], a_psc_end_date, sEnd);
				m_api->m_data.GetAttr(items[i], a_psc_start_date, sStart);			
			}
			else if(sType==_T("numbered"))
			{
				m_api->m_data.GetAttr(items[i], a_psc_start_num, sStart);
				m_api->m_data.GetAttr(items[i], a_psc_end_num, sEnd);			
			}
			m_api->m_data.GetAttr(items[i], a_psc_position, sPos);
			
			CaplLoadData ld(m_data, DEF_SOURCE);

			m_api->m_data.GetAttr(items[i], a_psc_changed_product, pdr_pdf);
			if(m_api->m_data.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdr))
			{
		 int v= ld.AddQuery(-1,pdr_pdf);
				ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_r_ted, true);
				ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_r_ting, true);
				ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_id, true);
				ld.AddQuery(_T('d'), v, 0, m_api->m_prd_mgr.a_pdr_inner_id, true);
				ld.LoadEx();
				
				m_api->m_data.GetAttr(pdr_pdf, m_api->m_prd_mgr.a_pdr_r_ting, pd_ing);
			}
			else if(m_api->m_data.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdf))
			{
				pd_ing= pdr_pdf;
			}

			m_api->m_data.GetAttr(items[i], a_psc_changing_product, pd_ed);
			m_api->m_data.GetAttr(items[i], a_psc_created_pdr, pdr);
			if(pdr){
				newPdr= pdr;/*  ,   pdr  - - , 
							    ...*/ 
				bCanDelete= true;
			}

			if(!pdr)
			{
				if(pd_ed)
				//  .  
				{
					CaplAttrValue valSTRUST[6];
					aplExtent ext;
					valSTRUST[0].attr= m_api->m_prd_mgr.a_pdr_r_ting;
					valSTRUST[0].value.Set(pd_ing);
					valSTRUST[1].attr= m_api->m_prd_mgr.a_pdr_r_ted;
					valSTRUST[1].value.Set(pd_ed);
					valSTRUST[2].attr= m_api->m_prd_mgr.a_apl_qacu_value;
					valSTRUST[2].value.Set(val);
					valSTRUST[3].attr= m_api->m_prd_mgr.a_apl_qacu_unit;
					valSTRUST[3].value.Set(unit);
					valSTRUST[4].attr= m_api->m_prd_mgr.a_pdr_id;
					valSTRUST[4].value.Set(sPos);
					
					m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_prd_mgr.e_qacu_nauo, 
						5, &valSTRUST[0], ext, true);
					
					if(ext.GetSize()) pdr= ext[0];
				}
				else//
				{
					if(!pd_ed) pdr= pdr_pdf;
				}
			}
			
			if(!pdr) continue;
			
			//,   ...
			aplExtent pdfs, rels;
			if(!pd_ing) continue;
			m_api->m_prd_mgr.LoadAllSubProduct(0, 0, pd_ing, rels, pdfs);

			m_api->m_data.GetAttr(pdr, m_api->m_prd_mgr.a_pdr_inner_id, sPdrInnerId);
			
			aplExtent samePdrs;/*pdr   */
			int n;
			for(n= 0; n<rels.GetSize(); n++)
			{
				CString buf;
				m_api->m_data.GetAttr(rels[n], m_api->m_prd_mgr.a_pdr_inner_id, buf);
				if(!buf.CompareNoCase(sPdrInnerId))samePdrs.Add(rels[n]);
			}

			//       
			// pdr   inner_id (  )
			aplExtent curEffExt;
			for(n= 0; n<samePdrs.GetSize(); n++)
			{
				if(sType==_T("dated"))
					GetPrdEffectivity(samePdrs[n], sType, _T("19010101000000"), _T(""), curEffExt);
				else if(sType==_T("numbered"))
					GetPrdEffectivity(samePdrs[n], sType, _T(""), _T(""), curEffExt);
			}

			// ,  
			m_api->m_data.GetAttr(items[i], a_psc_add_set, m_addedEffSet);
			m_api->m_data.GetAttr(items[i], a_psc_cancel_set, m_deletedEffSet);
			m_api->m_data.GetAttr(items[i], a_psc_modif_set, m_chngedEffSet);

			//  ,      
			// ,    
			for(n= 0; n<m_addedEffSet.GetSize(); n++)
			{
				bool bHide= false;
				m_api->m_data.GetAttr(m_addedEffSet[n], m_api->m_prd_mgr.a_pde_not_active, bHide);
				if(!bHide)
				{
					curEffExt.Remove(curEffExt.Find(m_addedEffSet[n]));//     
					m_api->m_data.PutAttr(m_addedEffSet[n], m_api->m_prd_mgr.a_pde_not_active, true);
				}
				//  
//				m_api->m_data.DeleteInstance(m_addedEffSet[n]);
			}

			//  ,       
			//
			// ,  ...
			for(n= 0; n<m_deletedEffSet.GetSize(); n++)
			{
				CString sSt, sEn;
				if(sType==_T("dated"))
				{
					m_api->m_data.GetAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_dat_eff_start_s, sSt);
					m_api->m_data.GetAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_dat_eff_end_s, sEn);
				}
				else if(sType==_T("numbered"))
				{
					m_api->m_data.GetAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_sn_eff_start, sSt);
					m_api->m_data.GetAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_sn_eff_end, sEn);					
				}
				
/*				aplExtent effExt;
				for(int nn= 0; nn<samePdrs.GetSize(); nn++)
				{
					if(sType==_T("dated"))
						GetPrdEffectivity(samePdrs[nn], sType, sSt, sEn, effExt);
					else if(sType==_T("numbered"))
						GetPrdEffectivity(samePdrs[nn], sType, sSt, sEn, effExt);
				}*/
				
				bool bRestore= true;
				CString sRight= sEn, sLeft= sSt;

/*				for(int m= 0; m<effExt.GetSize(); m++)
				{
					CString sSt1, sEn1;
					if(sType==_T("dated"))
					{
						m_api->m_data.GetAttr(effExt[m], m_api->m_prd_mgr.a_dat_eff_start_s, sSt1);
						m_api->m_data.GetAttr(effExt[m], m_api->m_prd_mgr.a_dat_eff_end_s, sEn1);						
					}
					else if(sType==_T("numbered"))
					{
						m_api->m_data.GetAttr(effExt[m], m_api->m_prd_mgr.a_sn_eff_start, sSt1);
						m_api->m_data.GetAttr(effExt[m], m_api->m_prd_mgr.a_sn_eff_end, sEn1);					
					}
					
					if((!sEn.IsEmpty() && sEn<sEn1) || sEn1.IsEmpty())
					{
						sRight= sSt1;
						sLeft= sSt;
						
						if(sSt<=sSt1){bRestore= false; break;}
						
						int ind= 0;
						CaplInstance* prevEff= effExt[m];
						while(prevEff)
						{
							CaplInstance* inst= NULL;
							m_api->m_data.GetAttr(prevEff, m_api->m_prd_mgr.a_pde_prev, inst);
							effExt.Remove(effExt.Find(prevEff));
							prevEff= NULL;
							
							bool bHide= false;
							m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_pde_not_active, bHide);
							if(bHide) inst= NULL;
							
							if(inst)
							{
								CString sSt2, sEn2;
								if(sType==_T("dated"))
								{
									m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_dat_eff_start_s, sSt2);
									m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_dat_eff_end_s, sEn2);						
								}
								else if(sType==_T("numbered"))
								{
									m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_sn_eff_start, sSt2);
									m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_sn_eff_end, sEn2);					
								}
								if(sSt2<sSt){bRestore= false; break;}
								sRight= sSt2;						
							}
							else
							{
								//
								for(int j= 0; j<effExt.GetSize(); j++)
								{
									//   sRight
									CString sSt2, sEn2;
									if(sType==_T("dated"))
									{
										m_api->m_data.GetAttr(effExt[j], m_api->m_prd_mgr.a_dat_eff_start_s, sSt2);
										m_api->m_data.GetAttr(effExt[j], m_api->m_prd_mgr.a_dat_eff_end_s, sEn2);						
									}
									else if(sType==_T("numbered"))
									{
										m_api->m_data.GetAttr(effExt[j], m_api->m_prd_mgr.a_sn_eff_start, sSt2);
										m_api->m_data.GetAttr(effExt[j], m_api->m_prd_mgr.a_sn_eff_end, sEn2);					
									}
									
									if(!sEn2.IsEmpty() && sEn2<sRight && sEnd>sLeft)
										sLeft= sEn2;
								}
							}
							prevEff= inst;
						}
						break;						
					}
				}*/
				if(bRestore)
				{
					m_api->m_data.PutAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_pde_not_active, false);
					if(sType==_T("dated"))
					{
						m_api->m_data.PutAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_dat_eff_start_s, sLeft);
						m_api->m_data.PutAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_dat_eff_end_s, sRight);						
					}
					else if(sType==_T("numbered"))
					{
						m_api->m_data.PutAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_sn_eff_start, sLeft);
						m_api->m_data.PutAttr(m_deletedEffSet[n], m_api->m_prd_mgr.a_sn_eff_end, sRight);					
					}
					curEffExt.Add(m_deletedEffSet[n]);
				}
			}
			
			//  . 
			//,      ,     .
			//,  
			for(n= 0; n<m_chngedEffSet.GetSize(); n++)
			{
				bool bFindActive= false;//     
				//   
				for(int j= 0; j<curEffExt.GetSize(); j++)
				{
					CaplInstance* inst= NULL;
					CString sSt, sEn;
					m_api->m_data.GetAttr(curEffExt[j], m_api->m_prd_mgr.a_pde_prev, inst);
					if(inst==m_chngedEffSet[n])
					{
						bFindActive= true;
						if(sType==_T("dated"))
						{
							m_api->m_data.GetAttr(curEffExt[j], m_api->m_prd_mgr.a_dat_eff_start_s, sSt);
							m_api->m_data.PutAttr(m_chngedEffSet[n], m_api->m_prd_mgr.a_dat_eff_end_s, sSt);						
						}
						else if(sType==_T("numbered"))
						{
							m_api->m_data.GetAttr(curEffExt[j], m_api->m_prd_mgr.a_sn_eff_start, sSt);
							m_api->m_data.PutAttr(m_chngedEffSet[n], m_api->m_prd_mgr.a_sn_eff_end, sSt);					
						}
						break;
					}
				}

				if(!bFindActive)
				{
					//   
					CaplInstance* prevEff= m_chngedEffSet[n];
					CaplInstance* nextEff= NULL;// " " 
					while(prevEff)
					{
						CaplInstance* inst1= NULL, 
							*inst= NULL;
						for(int j= 0; j<m_addedEffSet.GetSize(); j++)
						{
							m_api->m_data.GetAttr(m_addedEffSet[j], m_api->m_prd_mgr.a_pde_prev, inst1);
							if(prevEff==inst1)
							{
								inst= nextEff= m_addedEffSet[j];//   
								break;
							}
						}
						prevEff= inst;// 
					}
					if(nextEff)//      (   ...)
					{
						CString sSt;
						if(sType==_T("dated"))
						{
							m_api->m_data.GetAttr(nextEff, m_api->m_prd_mgr.a_dat_eff_end_s, sSt);
							m_api->m_data.PutAttr(m_chngedEffSet[n], m_api->m_prd_mgr.a_dat_eff_end_s, sSt);						
						}
						else if(sType==_T("numbered"))
						{
							m_api->m_data.GetAttr(nextEff, m_api->m_prd_mgr.a_sn_eff_end, sSt);
							m_api->m_data.PutAttr(m_chngedEffSet[n], m_api->m_prd_mgr.a_sn_eff_end, sSt);					
						}
						//   !
						m_api->m_data.PutAttr(nextEff, m_api->m_prd_mgr.a_pde_prev, m_chngedEffSet[n]);
					}
				}
			}
			if(bCanDelete)// 
			{
//				m_api->m_data.DeleteInstance(pdr);
			}

			for(int k= 0; k<m_addedEffSet.GetSize(); k++)
			{
				m_api->m_data.DeleteInstance(m_addedEffSet[k]);
			}
		
			m_api->SaveChanges();

			//   
			if(newPdr)
			{
				newPdrs.Add(newPdr);
			}
		}//if(m_api->m_data.IsKindOf(items[i], e_psc))
		else if(m_api->m_data.IsKindOf(items[i], e_avc))
		{
			CaplInstance* doc, *newVer, *oldVer/*   */;
			
			m_api->m_data.GetAttr(items[i], a_avc_doc, doc);
			m_api->m_data.GetAttr(items[i], a_avc_new_rev, newVer);
			m_api->m_data.GetAttr(items[i], a_avc_old_rev, oldVer);
			
			//
			/*    */
			//if(sDistrCode.CompareNoCase(_T("KVZ")))
			if(!m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
				m_api->m_data.PutAttr(doc, m_api->m_doc_mgr.a_apl_doc_active, oldVer);
			
			oldVer= NULL;
			m_api->m_data.PutAttr(items[i], a_avc_old_rev, oldVer);

			//:      
			{
				aplExtent ext_items_for_add_relation, ext_items_for_del_relation;
				apidata.GetAttr(items[i], m_api->m_change_mgr.a_avc_items_for_add_relation, ext_items_for_add_relation);
				apidata.GetAttr(items[i], m_api->m_change_mgr.a_avc_items_for_del_relation, ext_items_for_del_relation);
				if(ext_items_for_add_relation.GetSize()>0 || ext_items_for_del_relation.GetSize()>0)
				{
					aplExtent ext_doc,ext_rel,ext_out; 
					ext_doc.Add(doc);
					m_api->m_doc_mgr.FindAssociatingDocuments(ext_doc,ext_out,ext_rel);

					CString sDate, sChangeDate;
					m_api->m_data.GetAttr(items[i], a_chng_item_accept_date, sChangeDate);
					int i,j;
					//   
					for(i=0;i<ext_items_for_add_relation.GetSize();i++)
					{
						CaplInstance *inst=ext_items_for_add_relation[i];
						bool bExist=false;
						for(j=0;j<ext_rel.GetSize();j++)
						{
							CaplInstance *inst1=0;
							CaplInstance *rel=ext_rel[j];
							apidata.GetAttr(rel, m_api->m_doc_mgr.a_apl_doc_ref_item, inst1);
							if(inst1==inst)
							{
								apidata.GetAttr(rel, m_api->m_doc_mgr.a_apl_doc_ref_start_date, sDate);
								if(sDate!=_T("") && sDate==sChangeDate)
								{
									apidata.DeleteInstance(rel);
									break;
								}
							}
						}
					}
					//   
					for(i=0;i<ext_items_for_del_relation.GetSize();i++)
					{
						CaplInstance *inst=ext_items_for_del_relation[i];
						for(j=0;j<ext_rel.GetSize();j++)
						{
							CaplInstance *inst1=0;
							CaplInstance *rel=ext_rel[j];
							if(0==rel->GetType()) continue;
							apidata.GetAttr(rel, m_api->m_doc_mgr.a_apl_doc_ref_item, inst1);
							if(inst1==inst)
							{
								apidata.GetAttr(rel, m_api->m_doc_mgr.a_apl_doc_ref_end_date, sDate);
								if(sDate!=_T("") && sDate==sChangeDate) apidata.PutAttr(ext_rel[j], m_api->m_doc_mgr.a_apl_doc_ref_end_date, _T(""));
							}
						}
					}
				}
			}
			
		}//if(m_api->m_data.IsKindOf(items[i], e_avc))
		else if(m_api->m_data.IsKindOf(items[i], e_abpc))
		{
			CaplInstance* bp, *newVer, *oldVer/*   */;
			
			m_api->m_data.GetAttr(items[i], a_abpc_bp, bp);
			m_api->m_data.GetAttr(items[i], a_abpc_new_rev, newVer);
			m_api->m_data.GetAttr(items[i], a_abpc_old_rev, oldVer);
			
			SetActive(bp, oldVer);
			
			oldVer= NULL;
			m_api->m_data.PutAttr(items[i], a_abpc_old_rev, oldVer);
		}//if(m_api->m_data.IsKindOf(items[i], e_abpc))
		else if (m_api->m_data.IsKindOf(items[i], e_char_change))
		{
			CaplInstance* charact, *newVer, *oldVer/*   */;
			
			m_api->m_data.GetAttr(items[i], a_char_change_val, charact);
			m_api->m_data.GetAttr(items[i], a_char_change_new_rev, newVer);
			m_api->m_data.GetAttr(items[i], a_char_change_old_rev, oldVer);
			
			m_api->m_charact_mgr.MakeCharValVersionActive(oldVer);
			
			oldVer = NULL;
			m_api->m_data.PutAttr(items[i], a_char_change_old_rev, oldVer);
		}
	}
	
	aplExtent newPrds4Delete;
	if(newPdrs.GetSize())
	{
		if(m_api->m_ModeInteractive)
		{
			CaplSetResourceHandle setres(module_inst);
			
			CDelPdrDlg dlg;
			dlg.m_api= m_api;
			dlg.m_change= change;
			dlg.m_pdrs.Append(newPdrs);
			
			if(IDOK==dlg.DoModal())
			{
				newPrds4Delete.Append(dlg.m_pdrs);
			}
		}
		else
		{
			newPrds4Delete.Append(newPdrs);
		}
		for(int t= 0; t<newPrds4Delete.GetSize(); t++)
		{
			m_data->DeleteInstance(newPrds4Delete[t], false);
		}

			//       
		if(m_api->m_ModeInteractive)
			CreateFictiveEff(newPdrs, _T("dated"));		
	}

	if(pApplyTechnologChange)
		pApplyTechnologChange(m_api, change, false, true);

	//++  16.04.2009
	if (pUndoOGMetChange)
		pUndoOGMetChange(m_api,change,aePdfLockers);
	//++  
	aplExtent aeAss;
	CaplInstance* ciInst = NULL;
	m_api->m_data.GetAttr(change,m_api->m_change_mgr.a_chng_changed_assemlies,aeAss);
	for (i=0;i<aeAss.Size;i++)
	{
		
		m_api->m_data.GetAttr(aeAss[i],m_api->m_prd_mgr.a_apl_pdf_locker,ciInst);
		//      
		if (ciInst)
			continue;
		//    
		m_api->m_data.PutAttr(aeAss[i],m_api->m_prd_mgr.a_apl_pdf_locker,change);
	}


	CaplInstance* person= NULL;
	
	COleDateTime odt;
	CString sDate;

	m_api->m_data.NET_GetServerDateTime(odt);
	aplDate2String(odt, sDate);

	//   ,   
//	m_api->m_data.PutAttr(change, a_chng_user, m_api->m_data.GetNameCurrUser());
//	m_api->m_data.PutAttr(change, a_chng_autor, m_api->m_appr_mgr.GetCurrentPerson());
//	m_api->m_data.PutAttr(change, a_chng_apply_date, sDate);
	m_api->m_data.PutAttr(change, a_chng_state, _T("not_applied"));

	UndoAptc(change);

	if(m_api->m_AutoSave) 
		m_api->SaveChanges();

	aplExtent extAccess;
	extAccess.Add(change);
	extAccess.Append(items);

	if(m_api->m_AutoSave)
	{
		/*    ,   ,    ...*/
		//if(sDistrCode.CompareNoCase(_T("KVZ")))
		if(!m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
		{
			m_api->m_data.NET_SetSpecialInstancesAccess(&extAccess, (CaplInstance*)-1, aplOWN,  APL_T(" ..."), -1, -1);
		}
	}

	return true;// ,      .
}

bool CaplChangeManager::UndoAptc(CaplInstance *change)
{	
	if(change && m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
	{
		//     
		CString docId;
		m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_doc_id, docId);
		docId.Replace(_T("aptc"), _T(""));
		m_api->m_data.PutAttr(change, m_api->m_change_mgr.a_chng_doc_id, docId);

		//  
		CaplInstance *approvedStatus = m_api->m_appr_mgr.FindApprovalStatusBN(_T(""), true);
		if(approvedStatus)
		{
			CaplInstance *appr = m_api->m_appr_mgr.FindRoleApproval(change, _T(". "), approvedStatus);
			if(appr)
				m_api->m_data.DeleteInstance(appr, false);
		}
	}

	return true;
}

bool CaplChangeManager::ShowChangesTree(CaplInstance* change)
{
	CaplSetResourceHandle setres(module_inst);
	
	CChangesTreeDlg dlg;
	dlg.m_api= m_api;
	dlg.m_change= change;

	dlg.DoModal();
	return true;
}

CString	CaplChangeManager::GetMFCId(CaplInstance *pdf_pdr)
{
	CString sId, buf;
	CaplInstance* pdf= NULL;	
	aplExtent ext, ext1;
	int i;
	
	if(m_api->m_data.IsKindOf(pdf_pdr, m_api->m_prd_mgr.e_make_from))
		m_api->m_data.GetAttr(pdf_pdr, m_api->m_prd_mgr.a_pdr_r_ting, pdf);
	else if(m_api->m_data.IsKindOf(pdf_pdr, m_api->m_prd_mgr.e_pdf))
		pdf= pdf_pdr;

	if(pdf)
	{
		CaplAttrValue find_values[4];
		aplExtent psc_ext, pdr_ext;
		
		// pdf
		find_values[0].value.Set(pdf);
		find_values[0].attr= a_psc_changed_product;
		m_api->m_data.NET_FindInstancesWithAttrValues(e_psc, 1, &find_values[0], ext, true);
		
		// pdr
		m_api->m_prd_mgr.LoadAllZagotov(pdf, pdr_ext, ext1);
		for(i= 0; i<pdr_ext.GetSize(); i++)
		{
			find_values[0].value.Set(pdr_ext[i]);
			find_values[0].attr= a_psc_changed_product;
			m_api->m_data.NET_FindInstancesWithAttrValues(e_psc, 1, &find_values[0], psc_ext, true);	
			
			for(int j= 0; j<psc_ext.GetSize(); j++)
			{
				if(m_api->m_data.IsKindOf(psc_ext[j], m_api->m_change_mgr.e_mat))
					ext.Add(psc_ext[j]);
			}		
		}
		
		int id= 0;

		CaplLoadData ld(m_data,DEF_SOURCE);

		for(i= 0; i<ext.GetSize(); i++)
			if(ext[i]->GetType())
				if(ext[i]->GetId())
					ld.AddQuery(0, ext[i]);
		if(ld.m_queries.GetSize())
		{
			ld.AddQuery(_T('d'), 0, 0, a_chng_item_id, true);
			ld.LoadEx();
		}

		for(i= 0; i<ext.GetSize(); i++)
		{
			if(!ext[i] || !ext[i]->GetType()) continue;
			m_api->m_data.GetAttr(ext[i], a_chng_item_id, buf);
			int n= _atoi(buf);
			if(n>id) id= n;
		}
		
		id++;
		sId.Format(_T("%i"), id);	
	}
	return sId;
}

CString CaplChangeManager::GetPSCId(CaplInstance *pdf_pdr)
{
	CString sId, buf;
	CaplInstance* pdf= NULL;	
	aplExtent ext, ext1;
	int i;
	
	if(m_api->m_data.IsKindOf(pdf_pdr, m_api->m_prd_mgr.e_pdr))
		m_api->m_data.GetAttr(pdf_pdr, m_api->m_prd_mgr.a_pdr_r_ting, pdf);
	else if(m_api->m_data.IsKindOf(pdf_pdr, m_api->m_prd_mgr.e_apl_pdf))
		pdf= pdf_pdr;

	if(pdf)
	{
		CaplAttrValue find_values[4];
		aplExtent psc_ext, pdr_ext;
		
		// pdf
		find_values[0].value.Set(pdf);
		find_values[0].attr= a_psc_changed_product;
		m_api->m_data.NET_FindInstancesWithAttrValues(e_psc, 1, &find_values[0], ext, true);
		
		// pdr
		m_api->m_prd_mgr.LoadAllSubProduct(NULL, NULL, pdf, pdr_ext, ext1);
		CaplFinder ff(DEF_SOURCE);

		int index = ff.CreateExt(e_psc);
		ff.AddAttr(index, a_psc_changed_product, ff.CreateExt(pdr_ext, true));
		ff.AddToResult(index);
		ff.Find(m_api->m_data, true, false, false, true, true);

		for(i=0; i<ff.m_innerExtent.Size; ++i)
		{
			if(m_api->m_data.IsKindOf(ff.m_innerExtent[i], m_api->m_change_mgr.e_mat))
				continue;
			ext.Add(ff.m_innerExtent[i]);
		}		
		
		int id= 0;		

		for(i= 0; i<ext.GetSize(); i++)
		{
			if(!ext[i] || !ext[i]->GetType()) continue;
			m_api->m_data.GetAttr(ext[i], a_chng_item_id, buf);
			int n= _atoi(buf);
			if(n>id) id= n;
		}
		
		id++;
		sId.Format(_T("%i"), id);	
	}

	return sId;
}

CString CaplChangeManager::GetAVCId(CaplInstance* doc_rev)
{
	int id= 0;
	CString sId, buf;
	CaplInstance* ch_doc= NULL;
	
	if(m_api->m_data.IsKindOf(doc_rev, m_api->m_doc_mgr.e_apl_doc_rev))
	{
		m_api->m_data.GetAttr(doc_rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, ch_doc);
	}
	else if(m_api->m_data.IsKindOf(doc_rev, m_api->m_doc_mgr.e_apl_doc))
	{
		ch_doc= doc_rev;
	}
	if(ch_doc)
	{
		aplExtent ext;
		GetAllChanges(ch_doc, ext);
		for(int i= 0; i<ext.GetSize(); i++)
		{
			m_api->m_data.GetAttr(ext[i], a_chng_item_id, buf);
			int n= _atoi(buf);
			if(n>id) id= n;
		}
	}

	id++;
	sId.Format(_T("%i"), id);

	return sId;	
}

CString	CaplChangeManager::GetBPCId(CaplInstance *bp_ver)
{
	int id= 0;
	CString sId, buf;
	
	CaplInstance* bp= NULL;

	if(m_api->m_data.IsKindOf(bp_ver, m_api->m_bp_mgr.e_apl_bp_ver))
	{
		m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_bp, bp);
	}
	else if(m_api->m_data.IsKindOf(bp_ver, m_api->m_bp_mgr.e_bp))
	{
		bp= bp_ver;
	}
	
	if(bp)
	{
		aplExtent ext;
		GetAllChanges(bp, ext);
		
		for(int i= 0; i<ext.GetSize(); i++)
		{
			m_api->m_data.GetAttr(ext[i], a_chng_item_id, buf);
			int n= _atoi(buf);
			if(n>id) id= n;
		}		
	}

	id++;
	sId.Format(_T("%i"), id);

	return sId;
}

CString CaplChangeManager::GetCHCId(CaplInstance* ch_ver)
{
	int id = 0;
	CString sId, buf;
	
	CaplInstance* charact = NULL;

	if (m_api->m_data.IsKindOf(ch_ver, m_api->m_charact_mgr.e_apl_charact_value_ver))
	{
		m_api->m_data.GetAttr(ch_ver, m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, charact);
	}
	else if(m_api->m_data.IsKindOf(ch_ver, m_api->m_charact_mgr.e_apl_charact_value))
	{
		charact = ch_ver;
	}
	
	if (charact)
	{
		aplExtent ext;
		GetAllChanges(charact, ext);
		
		for (int i = 0; i < ext.GetSize(); i++)
		{
			m_api->m_data.GetAttr(ext[i], a_chng_item_id, buf);
			int n= _atoi(buf);
			if (n > id)
				id= n;
		}		
	}

	id++;
	sId.Format(_T("%i"), id);

	return sId;
}

bool CaplChangeManager::SetActive(CaplInstance* bp, CaplInstance* bp_ver)
{
	int i;
	//
	CString sId, sName, sDescr, sCode, sLabel;
	CaplInstance* type= NULL, *activeVer= NULL, *charact;
	aplExtent resources, subBP; //    
	aplExtent charactOld, charactNew; //  
	bool bCustomized=false, bOptional=false;

	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_id, sId);
	if(sId.IsEmpty())
	{
		aplExtent ext; ext.Add(bp); ext.Add(bp_ver);
		m_api->m_bp_mgr.LoadBPInfo(ext);
		m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_id, sId);
	}
	
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_name, sName);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_descr, sDescr);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_code, sCode);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_label, sLabel);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_type, type);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_customized, bCustomized);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_optional, bOptional);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_elements, subBP);
	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_ver_res, resources);

	m_api->m_data.GetAttr(bp, m_api->m_bp_mgr.a_bp_act, activeVer);	
	if(!activeVer) return false;
	
	aplExtent oldGroups, newGroups;
	m_api->m_charact_mgr.FindAssociatedCharacteristic(activeVer, charactOld, oldGroups);
	m_api->m_charact_mgr.FindAssociatedCharacteristic(bp_ver, charactNew, newGroups);
//	m_api->m_data.GetAttr(activeVer, m_api->m_bp_mgr.a_bp_act, charactOld);	
//	m_api->m_data.GetAttr(bp_ver, m_api->m_bp_mgr.a_bp_act, charactNew);
	
	aplExtent extAccess;
	extAccess.Append(charactOld); extAccess.Append(charactNew);

	//  
	for(i= 0; i<charactOld.GetSize(); i++)
	{
		charact= NULL;
		CaplInstance* charactActVer= NULL;
		m_api->m_data.GetAttr(charactOld[i], m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, charact);
		if(charact)
		{
			m_api->m_data.PutAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_item, (CaplInstance*)NULL);
			m_api->m_data.PutAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_base_item, bp);
		}
	}

	//,  
	for(i= 0; i<charactNew.GetSize(); i++)
	{
		charact= NULL;
		CaplInstance* charactActVer= NULL;
		m_api->m_data.GetAttr(charactNew[i], m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, charact);
		if(charact)
		{
			m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_act_ver, charactActVer);
			if(charactActVer && charactActVer!=charactNew[i])
			{
				m_api->m_charact_mgr.CopyValVersionToVal(charactNew[i], charact);
				m_api->m_data.PutAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_act_ver, charactNew[i]);
			}
			// 
			m_api->m_data.PutAttr(charact, m_api->m_charact_mgr.a_apl_charact_val_item, bp);
		}
	}
	
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_id, sId);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_name, sName);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_descr, sDescr);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_code, sCode);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_label, sLabel);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_type, type);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_customized, bCustomized);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_optional, bOptional);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_elements, subBP);
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_res, resources);
	
	//  
	m_api->m_data.PutAttr(bp, m_api->m_bp_mgr.a_bp_act, bp_ver);
	
	if(m_api->m_AutoSave) m_api->m_data.NET_SaveChanges();
	return true;
}

bool CaplChangeManager::GetPrdEffectivity(CaplInstance* pdr, CString sType, CString sStart, CString sEnd, aplExtent &eff_ext, aplExtent *pdrEff)
{
	int k;

	bool bHasFictiveEff= false;

	// entity  attr	
	CaplEntity* e_con_eff= m_api->m_data.GetEntityBN(_T("apl_configuration_effectivity"));

	CaplAttrValue find_values[4];
	aplExtent ext;
	
	CString buf, buf1;

	//  eff   
	find_values[0].value.Set(pdr);
	find_values[0].attr= m_api->m_prd_mgr.a_pde_usage;
	m_api->m_data.NET_FindInstancesWithAttrValues(e_con_eff, 1, &find_values[0], ext, true);
	bool bAdd;
	
	if(!ext.GetSize()) return bHasFictiveEff;

	CaplLoadData ld(m_data,DEF_SOURCE);	
	for(k= 0; k<ext.GetSize(); k++)
	{
		if(!ext[k]) continue;
		if(!ext[k]->GetId()) continue;
		if(!ext[k]->GetType()) continue;
		
		ld.AddQuery(0, ext[k]);
	}
	
	if(ld.m_queries.GetSize()!=0)
	{
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_dat_eff_start_s, true);
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_dat_eff_end_s, true);
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_sn_eff_start, true);
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_sn_eff_end, true);
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_pde_usage, true);
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_pde_prev, true);
		ld.AddQuery(_T('d'), 0, 0, m_api->m_prd_mgr.a_pde_not_active, true);
		ld.LoadEx();
	}
	bool bIsNotActive;
	for(k= 0; k<ext.GetSize(); k++)
	{
		bAdd= false;

		if(ext[k]->GetType()==NULL) continue;

		if(sType==_T("dated") && m_api->m_data.IsKindOf(ext[k], 
			m_api->m_prd_mgr.e_dat_eff))
		{			
			m_api->m_data.GetAttr(ext[k], m_api->m_prd_mgr.a_dat_eff_start_s, buf);
			m_api->m_data.GetAttr(ext[k], m_api->m_prd_mgr.a_dat_eff_end_s, buf1);
			
			if(buf==_T("19000101000000")) 
			{bHasFictiveEff= true;continue;}

			m_api->m_data.GetAttr(ext[k], m_api->m_prd_mgr.a_pde_not_active, bIsNotActive);
			if(bIsNotActive) continue;

			if(sEnd.IsEmpty())
			{
				// 
				if(buf1.IsEmpty()){bAdd= true;}
				//    ( -    )
				else if(sStart>=buf && (sStart<buf1 || buf1.IsEmpty())){bAdd= true;}
				//  
				else if(sStart<=buf){bAdd= true;}
			}
			else
			{
				//    
				if(sStart>=buf && (sStart<buf1  || buf1.IsEmpty())){bAdd= true;}
				//    ( , 
				//       )
				else if(sStart<buf && sEnd>buf1 && !buf1.IsEmpty()){bAdd= true;}
				//    
				else if(sStart<=buf && sEnd>=buf){bAdd= true;}
			}
		}
		else if(sType==_T("numbered") && m_api->m_data.IsKindOf(ext[k], 
			m_api->m_prd_mgr.e_sn_eff))
		{
			m_api->m_data.GetAttr(ext[k], m_api->m_prd_mgr.a_sn_eff_start, buf);
			m_api->m_data.GetAttr(ext[k], m_api->m_prd_mgr.a_sn_eff_end, buf1);

			if(buf==_T(" ")||buf1==_T(" "))
			{bHasFictiveEff= true;continue;}

			m_api->m_data.GetAttr(ext[k], m_api->m_prd_mgr.a_pde_not_active, bIsNotActive);
			if(bIsNotActive) continue;

			if (m_api->m_prd_mgr.funcCompareSN==NULL)
				continue;
			//     
			if(!buf1.IsEmpty() && m_api->m_prd_mgr.funcCompareSN(buf1, sStart)==-1) continue;
			//     
			if(!sEnd.IsEmpty() && m_api->m_prd_mgr.funcCompareSN(sEnd, buf)==-1) continue;
			
			bAdd = true;

/*			if(sEnd.IsEmpty())
			{
				// 
				if(buf1.IsEmpty()){bAdd= true;}
				//    
//				else if(sStart>=buf && (sStart<buf1 || buf1.IsEmpty())){bAdd= true;}
				else if ((m_api->m_prd_mgr.funcCompareSN(sStart, buf) != -1) &&
						 ((m_api->m_prd_mgr.funcCompareSN(sStart, buf1) == -1) || buf1.IsEmpty()))
					 bAdd = true;
				//  
//				else if(sStart<buf){bAdd= true;}
				else if (m_api->m_prd_mgr.funcCompareSN(sStart, buf) == -1)
					bAdd = true;
			}
			else
			{

				//     
//				if(sStart>=buf && (sStart<buf1 || buf1.IsEmpty())){bAdd= true;}
				if ((m_api->m_prd_mgr.funcCompareSN(sStart, buf) != -1) &&
					((m_api->m_prd_mgr.funcCompareSN(sStart, buf1) == -1) || buf1.IsEmpty()))
					bAdd = true;
				//    
//				else if(sStart<buf && sEnd>buf1){bAdd= true;}
				else if ((sStart.IsEmpty() || m_api->m_prd_mgr.funcCompareSN(sStart, buf) == -1) &&
						 (m_api->m_prd_mgr.funcCompareSN(sEnd, buf1) == 1))
					bAdd = true;
				//    
//				else if(sStart<=buf && sEnd>=buf){bAdd= true;}
				else if (( sStart.IsEmpty() || m_api->m_prd_mgr.funcCompareSN(sStart, buf) != 1) &&
					     (m_api->m_prd_mgr.funcCompareSN(sEnd, buf) != -1))
					bAdd = true;
			}*/
		}
		if(bAdd)
		{
			eff_ext.Add(ext[k]);//eff,      
		}
	}

	if(pdrEff)
	{
		pdrEff->Clear();
		pdrEff->Append(ext);
	}
	return bHasFictiveEff;
}

/* 
//   
bool CaplChangeManager::ResetPrdEffectivity(CaplInstance* eff, 
							CString sType, CString sStart, CString sEnd, 
							aplExtent &pdr_ext, aplExtent &eff_ext)
{
	CString str1, str2;	
	CString sId;
	CaplInstance* pdr= NULL;

	if(sType==_T("dated"))
	{
		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_start_s, str1);
		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_end_s, str2);
	}
	else if(sType==_T("numbered"))
	{
		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_start, str1);
		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_end, str2);							
	}

	m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, sId);
	m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, pdr);
	
	if(sStart>str1)//   
	{
		CString sTempEnd;		
		CaplInstance* new_eff= NULL;

		if(sType==_T("dated"))
		{
			new_eff= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
			if(new_eff)
			{
				CaplInstance* eff_pdr= NULL; 
				CString sDate;
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, sDate);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, sDate);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_start_s, sDate);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_dat_eff_start_s, sDate);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_end_s, sTempEnd);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_dat_eff_end_s, sStart);
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
			}
		}
		else if(sType==_T("numbered"))
		{
			new_eff= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
			if(new_eff)
			{
				CaplInstance* eff_pdr= NULL; 
				CString sDate;
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, sDate);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, sDate);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_start, sDate);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_start, sDate);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_end, sTempEnd);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_end, sStart);
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
			}
		}
		
		m_deletedEffSet.Add(eff);//eff_del!!!
		m_addedEffSet.Add(new_eff);//eff_add!!!

//		m_chngedEffSet.Add(eff);//eff_chng!!!
		
		if(str2.IsEmpty())
		{
//			m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, inst);
			pdr_ext.Add(pdr);
		}
		else if(sEnd<str2 && !sEnd.IsEmpty())//    
		{
			CaplInstance* eff1= NULL;
			if(sType==_T("dated"))
			{
				eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, sTempEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}
			}
			else if(sType==_T("numbered"))
			{
				eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, sTempEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}
			}
			
			if(eff1)m_addedEffSet.Add(eff1);//eff_add!!!
		}
	}
	else
	{
		if(sEnd.IsEmpty() || sEnd>str2)//      ->
		{
			if(str2.IsEmpty())
			{
				if(!sEnd.IsEmpty())
					eff_ext.Add(eff);
				else
				{
					m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
					m_deletedEffSet.Add(eff);//eff_dell!!!
//					m_api->m_data.DeleteInstance(eff);
				}
			}
			else
			{
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
				m_deletedEffSet.Add(eff);//eff_dell!!!
//				m_api->m_data.DeleteInstance(eff);
			}
		}
		else//     
		{
			//    
/*			if(sType==_T("dated"))
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);									
			else if(sType==_T("numbered"))
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_sn_eff_start, sEnd);
			
			m_chngedEffSet.Add(eff);//eff_chng!!!*//*
		
			//   ,    			
			m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
			m_deletedEffSet.Add(eff);//eff_dell!!!
			
			CaplInstance* eff1= NULL;
			if(sType==_T("dated"))
			{
				eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, str2);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}
			}
			else if(sType==_T("numbered"))
			{
				eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, str2);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}
			}

			if(eff1)m_addedEffSet.Add(eff1);//eff_add!!!
		}
	}
	return true;
}
*/

bool CaplChangeManager::ResetPrdEffectivity(CaplInstance* eff, CString sType, CString sStart, CString sEnd, aplExtent &pdr_ext, aplExtent &eff_ext)
{	
	CString strId;
	CaplInstance *pdr = NULL;

	m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, strId);
	m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, pdr);

	if (sType == _T("dated"))
	{
		CString strStartDate, strEndDate;

		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_start_s, strStartDate);
		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_end_s, strEndDate);

		if (sStart > strStartDate) //   
		{
			CString strTempEnd;		
			CaplInstance *new_eff = NULL;

			new_eff = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
			
			if (new_eff != NULL)
			{
				CaplInstance *eff_pdr = NULL; 
				CString strValue;

				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, strValue);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, strValue);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_start_s, strValue);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_dat_eff_start_s, strValue);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_dat_eff_end_s, strTempEnd);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_dat_eff_end_s, sStart);
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
			}

			m_deletedEffSet.Add(eff);//eff_del!!!
			m_addedEffSet.Add(new_eff);//eff_add!!!

			if (strEndDate.IsEmpty())
			{
				pdr_ext.Add(pdr);
			}
			else if (!sEnd.IsEmpty() && (sEnd < strEndDate)) //    
			{
				CaplInstance *eff1 = NULL;

				eff1 = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);

				if (eff1 != NULL)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, strId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, strTempEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}

				if (eff1 != NULL)
					m_addedEffSet.Add(eff1); //eff_add!!!
			}
		}
		else
		{
			if (sEnd.IsEmpty() || (sEnd > strEndDate)) //      ->
			{
				if (strEndDate.IsEmpty())
				{
					if (!sEnd.IsEmpty())
						eff_ext.Add(eff);
					else
					{
						m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
						m_deletedEffSet.Add(eff);//eff_dell!!!
					}
				}
				else
				{
					m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
					m_deletedEffSet.Add(eff);//eff_dell!!!
				}
			}
			else //     
			{
				//   ,    			
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
				m_deletedEffSet.Add(eff);//eff_dell!!!

				CaplInstance *eff1 = NULL;

				eff1 = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);

				if (eff1 != NULL)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, strId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, strEndDate);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}

				if (eff1 != NULL)
					m_addedEffSet.Add(eff1);//eff_add!!!
			}
		}
	}
	else if (sType == _T("numbered"))
	{
		CString strStartSN, strEndSN;
		CString sBufStart = sStart;
		CString sBufEnd = sEnd;
		if(m_api->m_prd_mgr.funcGetPrevSN == NULL || m_api->m_prd_mgr.funcGetNextSN == NULL || m_api->m_prd_mgr.funcCompareSN==NULL)
			return false;

		sBufStart = m_api->m_prd_mgr.funcGetPrevSN(sBufStart);
		sBufEnd = m_api->m_prd_mgr.funcGetNextSN(sBufEnd);

		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_start, strStartSN);
		m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_end, strEndSN);

		if(sStart.IsEmpty())
		{
			// sEnd ,     
			if(m_api->m_prd_mgr.funcCompareSN(sEnd, strEndSN)<1)
			{
				CaplInstance *new_eff = NULL;
				new_eff = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);

				if (new_eff != NULL)
				{
					CaplInstance *eff_pdr = NULL; 
					CString strValue;

					m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, strValue);
					m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, strValue);
					m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
					m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
					
					m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_start, sEnd);
					m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_end, strEndSN);
					
					m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
				}

				m_deletedEffSet.Add(eff);//eff_del!!!
				m_addedEffSet.Add(new_eff);//eff_add!!!				
			}
			else // sEnd ,   
			{
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
				m_deletedEffSet.Add(eff);//eff_dell!!!			
			}
		}
		else if (m_api->m_prd_mgr.funcCompareSN(sStart, strStartSN) == 1 ||
			(strEndSN.IsEmpty() && !sStart.IsEmpty()) ) //   
		{
			
			CString strTempEnd;
			CaplInstance *new_eff = NULL;

			new_eff = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);

			if (new_eff != NULL)
			{
				CaplInstance *eff_pdr = NULL; 
				CString strValue;

				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_id, strValue);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_id, strValue);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_start, strValue);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_start, strValue);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_pde_usage, eff_pdr);
				m_api->m_data.GetAttr(eff, m_api->m_prd_mgr.a_sn_eff_end, strTempEnd);
				m_api->m_data.PutAttr(new_eff, m_api->m_prd_mgr.a_sn_eff_end, sBufStart);
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
			}

			m_deletedEffSet.Add(eff);//eff_del!!!
			m_addedEffSet.Add(new_eff);//eff_add!!!

			if (strEndSN.IsEmpty())
			{
				pdr_ext.Add(pdr);
			}
			else if (!sEnd.IsEmpty() && (m_api->m_prd_mgr.funcCompareSN(sEnd, strEndSN) == -1)) //    
			{
				CaplInstance *eff1 = NULL;

				eff1 = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
				
				if (eff1 != NULL)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, strId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, sBufEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, strTempEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}

				if (eff1 != NULL)
					m_addedEffSet.Add(eff1);//eff_add!!!
			}
		}
		else if (m_api->m_prd_mgr.funcCompareSN(sStart, strStartSN) != 1)
		{			
			if (sEnd.IsEmpty() || (m_api->m_prd_mgr.funcCompareSN(sEnd, strEndSN) == 1)) //      ->
			{	
				if (strEndSN.IsEmpty())
				{
					if (!sEnd.IsEmpty())
						eff_ext.Add(eff);
					else
					{
						m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
						m_deletedEffSet.Add(eff);//eff_dell!!!
					}
				}
				else
				{
					m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
					m_deletedEffSet.Add(eff);//eff_dell!!!
				}
			}
			else //     
			{
				//   ,    			
				m_api->m_data.PutAttr(eff, m_api->m_prd_mgr.a_pde_not_active, true); 
				m_deletedEffSet.Add(eff);//eff_dell!!!

				CaplInstance *eff1 = NULL;

				eff1 = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);

				if (eff1 != NULL)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, strId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, sBufEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, strEndSN);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr);
				}

				if (eff1 != NULL)
					m_addedEffSet.Add(eff1); //eff_add!!!
			}
		}
	}

	return true;
}

bool CaplChangeManager::CreateDatedEffSet(BOOL bReset, 
		CString sId, CString sStart, CString sEnd, CaplInstance* pdr_ed, 
		aplExtent &pdr_ext, aplExtent &eff_ext, CaplInstance* pdr_ing)
{	
	int m;
	CaplInstance* eff1= NULL, *eff2= NULL, *eff3= NULL;

	if(!bReset)//  .  -  
	{	
		//,     
		aplExtent ext;
		GetPrdEffectivity(pdr_ed, _T("dated"), _T("19000101000000"), _T(""), ext);
		if(!ext.GetSize())
		{
			eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);//   
			if(eff1)//      ""
					//  ,       . ,
					//    . :  ""   sStart
			{
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, _T("19010101000000"));
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, sStart);
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr_ed);

//				m_chngedEffSet.Add(eff1);//eff_chng!!!
				//  :      ..
				m_addedEffSet.Add(eff1);//eff_add!!!
			}
		}
	}
	
	if(pdr_ing)
	{
		eff2= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);//   
		if(eff2)
		{
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_pde_id, sId);
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_dat_eff_start_s, sStart);
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_pde_usage, pdr_ing);

			m_addedEffSet.Add(eff2);//eff_add!!!
		}
	}

	if(!sEnd.IsEmpty())//  
	{
		if(pdr_ing)
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_dat_eff_end_s, sEnd);
		
		if(!bReset)//  
		{
			eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
			if(eff3)
			{
				m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
				m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
				m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_ed);

				m_addedEffSet.Add(eff3);//eff_add!!!
			}
		}
		else//    eff,   c__  ->
		{
			for(m= 0; m<eff_ext.GetSize(); m++)
			{			
/*				m_api->m_data.PutAttr(eff_ext[m], m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);							
				m_chngedEffSet.Add(eff_ext[m]);//eff_chng!!!*/

				//   ,    			
				m_api->m_data.PutAttr(eff_ext[m], m_api->m_prd_mgr.a_pde_not_active, true); 
				m_deletedEffSet.Add(eff_ext[m]);//eff_dell!!!
			
				CaplInstance* eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, _T(""));
					CaplInstance* inst1= NULL;
					m_api->m_data.GetAttr(eff_ext[m], m_api->m_prd_mgr.a_pde_usage, inst1);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, inst1);
					
					m_addedEffSet.Add(eff1);//eff_add!!!
				}
			}
			for(m= 0; m<pdr_ext.GetSize(); m++)
			{
				eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
				if(eff3)
				{
					m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_dat_eff_start_s, sEnd);
					m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_ext[m]);

					m_addedEffSet.Add(eff3);//eff_add!!!
				}
			}
		}
	}
	return true;
}

bool CaplChangeManager::CreateNumedEffSet(BOOL bReset, 
		CString sId, CString sStart, CString sEnd, CaplInstance* pdr_ed, 
		aplExtent &pdr_ext, aplExtent &eff_ext, CaplInstance* pdr_ing)
{		
	int m;
	CaplInstance* eff1= NULL, *eff2= NULL, *eff3= NULL;

	CString sBufStart = sStart;
	CString sBufEnd = sEnd;

	if(m_api->m_prd_mgr.funcGetPrevSN == NULL || m_api->m_prd_mgr.funcGetNextSN == NULL)
		return false;

	sBufStart = m_api->m_prd_mgr.funcGetPrevSN(sBufStart);
	sBufEnd = m_api->m_prd_mgr.funcGetNextSN(sBufEnd);

	if(!bReset)//  
	{
		aplExtent ext;
		GetPrdEffectivity(pdr_ed, _T("numbered"), _T(""), _T(""), ext);
		if(!ext.GetSize())
		{
			eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
			if(eff1)
			{
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, _T(""));
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, sBufStart);
				m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr_ed);
				
				m_addedEffSet.Add(eff1);//eff_add!!!
//				m_chngedEffSet.Add(eff1);//eff_chng!!!
			}
		}
	}

	if(pdr_ing)
	{
		eff2= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
		if(eff2)
		{
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_pde_id, sId);
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_sn_eff_start, sStart);
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_pde_usage, pdr_ing);

			m_addedEffSet.Add(eff2);//eff_add!!!
		}
	}

	if(!sEnd.IsEmpty())//  
	{
		if(pdr_ing)
			m_api->m_data.PutAttr(eff2, m_api->m_prd_mgr.a_sn_eff_end, sEnd);
		
		if(!bReset)//  
		{
			eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
			if(eff3)
			{
				m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
				m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_sn_eff_start, sBufEnd);
				m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_ed);

				m_addedEffSet.Add(eff3);//eff_add!!!
			}
		}
		else //c__  ->
		{
			for(m= 0; m<eff_ext.GetSize(); m++)
			{
/*				m_api->m_data.PutAttr(eff_ext[m], m_api->m_prd_mgr.a_sn_eff_start, sEnd);				
				m_chngedEffSet.Add(eff_ext[m]);//eff_chng!!!*/
				
				m_api->m_data.PutAttr(eff_ext[m], m_api->m_prd_mgr.a_pde_not_active, true); 
				m_deletedEffSet.Add(eff_ext[m]);//eff_dell!!!
			
				CaplInstance* eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, sBufEnd);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, _T(""));
					CaplInstance* inst1= NULL;
					m_api->m_data.GetAttr(eff_ext[m], m_api->m_prd_mgr.a_pde_usage, inst1);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, inst1);
					
					m_addedEffSet.Add(eff1);//eff_add!!!
				}
			}
			for(m= 0; m<pdr_ext.GetSize(); m++)
			{
				eff3= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
				if(eff3)
				{
					m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_id, sId);
					m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_sn_eff_start, sBufEnd);
					m_api->m_data.PutAttr(eff3, m_api->m_prd_mgr.a_pde_usage, pdr_ext[m]);

					m_addedEffSet.Add(eff3);//eff_add!!!
				}
			}
		}
	}

	return true;
}

bool CaplChangeManager::CreateFictiveEff(aplExtent &pdr_ext, CString sType)
{	
	aplExtent ext;
	CaplInstance* eff1;
	bool bHasFictiveEff;

	for(int j= 0; j<pdr_ext.GetSize(); j++)
	{
		if(!pdr_ext[j] || !pdr_ext[j]->GetType()) continue;

		ext.Clear();
		
		if(sType==_T("dated"))
			bHasFictiveEff= GetPrdEffectivity(pdr_ext[j], sType, _T("19000101000000"), _T(""), ext);
		else if(sType==_T("numbered"))
			bHasFictiveEff= GetPrdEffectivity(pdr_ext[j], sType, _T(""), _T(""), ext);

		if(ext.GetSize()==0 && !bHasFictiveEff)//     !!!
		{
			if(sType==_T("dated"))
			{
				eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_dat_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, _T("fictive"));
//  					m_api->m_data.PutAttrBN(eff1, _T("is_not_active"), true);
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_start_s, _T("19000101000000"));// ..
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_dat_eff_end_s, _T("19010101000000"));						
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr_ext[j]);
				}
			}
			else if(sType==_T("numbered"))
			{
				eff1= m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_sn_eff);
				if(eff1)
				{
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_id, _T("fictive"));
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, _T(" "));
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, _T(" "));						
//  					m_api->m_data.PutAttrBN(eff1, _T("is_not_active"), true);
//					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_start, _T("2D95D2BA-83CF-4e1e-8B7C-AB9407023D6C"));
//					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_sn_eff_end, _T("1D633C71-31FC-466e-82F4-39ECD0C8A9A2"));						
					m_api->m_data.PutAttr(eff1, m_api->m_prd_mgr.a_pde_usage, pdr_ext[j]);
				}				
			}
		}
	}

	return false;
}

/*
bool CaplChangeManager::FillEffChain(aplExtent &eff_set)
{
	CString sEnd, sStart;

	for(int i= 0; i<eff_set.GetSize(); i++)
	{
		if(m_api->m_data.IsKindOf(eff_set[i], m_api->m_prd_mgr.e_dat_eff))
			m_api->m_data.GetAttr(eff_set[i], m_api->m_prd_mgr.a_dat_eff_end_s, sEnd);
		else if(m_api->m_data.IsKindOf(eff_set[i], m_api->m_prd_mgr.e_sn_eff))
			m_api->m_data.GetAttr(eff_set[i], m_api->m_prd_mgr.a_sn_eff_end, sEnd);			
		
		bool bFind= false;

		CaplInstance* nearestEff= NULL;
		CString sCurSt, sCurEnd;

		for(int j= 0; j<eff_set.GetSize(); j++)
		{
			if(m_api->m_data.IsKindOf(eff_set[j], m_api->m_prd_mgr.e_dat_eff))
				m_api->m_data.GetAttr(eff_set[j], m_api->m_prd_mgr.a_dat_eff_start_s, sStart);
			else if(m_api->m_data.IsKindOf(eff_set[j], m_api->m_prd_mgr.e_sn_eff))
				m_api->m_data.GetAttr(eff_set[j], m_api->m_prd_mgr.a_sn_eff_start, sStart);
			
			if(!sEnd.CompareNoCase(sStart))
			{
				nearestEff= eff_set[j];
				break;
			}
			else
			{
				if((!sEnd.IsEmpty() && sEnd<sStart) && 
					(sCurSt.IsEmpty() || sCurSt>sStart))
				{
					sCurSt= sStart;
					nearestEff= eff_set[j];
				}
			}
		}

		if(nearestEff)
			m_api->m_data.PutAttr(nearestEff, m_api->m_prd_mgr.a_pde_prev, eff_set[i]);

	}
	return true;
}
*/

bool CaplChangeManager::FillEffChain(aplExtent &eff_set)
{
	CString strStart, strEnd;
	CString strCurStart, strCurEnd;

	for (int iIndex = 0; iIndex < eff_set.GetSize(); iIndex++)
	{
		CaplInstance *nearestEff = NULL;

		for (int j = 0; j<eff_set.GetSize(); j++)
		{
			if ((m_api->m_data.IsKindOf(eff_set[iIndex], m_api->m_prd_mgr.e_dat_eff)) &&
				(m_api->m_data.IsKindOf(eff_set[j], m_api->m_prd_mgr.e_dat_eff)))
			{				
				m_api->m_data.GetAttr(eff_set[iIndex], m_api->m_prd_mgr.a_dat_eff_end_s, strEnd);
				m_api->m_data.GetAttr(eff_set[j], m_api->m_prd_mgr.a_dat_eff_start_s, strStart);

				if (strEnd.CompareNoCase(strStart) == 0)
				{
					nearestEff = eff_set[j];
					break;
				}
				else
				{
					if ((!strEnd.IsEmpty() && (strEnd < strStart)) && 
					    (strCurStart.IsEmpty() || (strCurStart > strStart)))
					{
						strCurStart = strStart;
						nearestEff = eff_set[j];
					}
				}
			}
			else if ((m_api->m_data.IsKindOf(eff_set[iIndex], m_api->m_prd_mgr.e_sn_eff)) &&
					 (m_api->m_data.IsKindOf(eff_set[j], m_api->m_prd_mgr.e_sn_eff)))
			{				
				m_api->m_data.GetAttr(eff_set[iIndex], m_api->m_prd_mgr.a_sn_eff_end, strEnd);				
				m_api->m_data.GetAttr(eff_set[j], m_api->m_prd_mgr.a_sn_eff_start, strStart);

				if (strEnd.CompareNoCase(strStart) == 0)
				{
					nearestEff = eff_set[j];
					break;
				}
				else
				{
					if ((!strEnd.IsEmpty() && (m_api->m_prd_mgr.funcCompareSN(strEnd, strStart) == -1)) && 
						(strCurStart.IsEmpty() || (m_api->m_prd_mgr.funcCompareSN(strCurStart, strStart) == 1)))
					{
						strCurStart = strStart;
						nearestEff = eff_set[j];
					}
				}
			}			
		}

		if (nearestEff)
			m_api->m_data.PutAttr(nearestEff, m_api->m_prd_mgr.a_pde_prev, eff_set[iIndex]);
	}

	return true;
}


/**     change   */
bool CaplChangeManager::GetSubChanges(CaplInstance *change, aplExtent &ext_subchanges)
{
	ext_subchanges.Clear();
	if(0==change) return false;
	if(0==change->GetType()) return false;

	CaplAttrValue find_values[4];
	aplExtent ext;

	find_values[0].value.Set(change);
	find_values[0].attr= a_chng_base;
	m_api->m_data.NET_FindInstancesWithAttrValues(e_chng, 1, &find_values[0], ext_subchanges, true);
	return true;
}

bool CaplChangeManager::IsChangeAptc(CaplInstance *change)
{
	if(0 == change) return false;
	if(0 == change->attrs) return false;

	CString docId;
	m_api->m_data.GetAttr(change, m_api->m_change_mgr.a_chng_doc_id, docId);		

	return (docId.Find(_T("aptc")) != -1);
}

bool CaplChangeManager::GenerateChangeId(CString &change_id)
{
	change_id=_T("");
	if(0==m_api) return false;

	CString  buf, sId, sCode, sYear, sNumber, sTemplate;

	//  
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\  "), sTemplate);
	if(sTemplate==_T("")) sTemplate=_T("%e-%4i-%y");
	sTemplate.MakeLower();

	//  
	CaplInstance *cit;
	cit = m_api->m_options_mgr.FindOptionBN( APL_NO_T(" \\ "));
	if(!cit) m_api->m_options_mgr.CreateOption( APL_NO_T(" \\ "), _T("000"));

	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\ "), sCode, _T("000"));
	sTemplate.Replace(_T("%e"),sCode);

	// 
	/*cit = m_api->m_options_mgr.FindOptionBN( APL_NO_T(" \\"));

	COleDateTime time(COleDateTime::GetCurrentTime());
	buf.Format(_T("%d"), time.GetYear());
	if(!cit) m_api->m_options_mgr.CreateOption( APL_NO_T(" \\"), buf);

	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\"), sYear);
	*/
	COleDateTime time(COleDateTime::GetCurrentTime());
	sYear.Format(_T("%d"), time.GetYear());
	sTemplate.Replace(_T("%y"),sYear);


	//  
	/*cit = m_api->m_options_mgr.FindOptionBN( APL_NO_T(" \\"));
	if(!cit) cit = m_api->m_options_mgr.CreateOption( APL_NO_T(" \\"), 1);
	int nNumber = m_api->m_options_mgr.GetIntOptionValueBN( APL_NO_T(" \\"), 1);*/

	CString sNumOption=APL_NO_T("\\\\"); sNumOption+=sYear;
	int nNumber = m_api->m_options_mgr.GetCounterWithIncrementBN(sNumOption);
	if(nNumber<1) nNumber=1;
	if(1==nNumber && sYear==_T("2017"))//       
	{
		int nNumber1 = m_api->m_options_mgr.GetCounterWithIncrementBN(APL_NO_T("\\\\"));
		if(nNumber1>nNumber)nNumber=nNumber1;
	}

	int i=sTemplate.Find(_T("%"));
	sTemplate.Insert(i+1,_T('0'));  //   


	//   
	aplExtent aeExt;
	CaplAttrValue attr;
	attr.attr = m_api->m_change_mgr.a_chng_id;
	while(true)
	{
		aeExt.Clear();
		sId.Format(sTemplate,nNumber);

		//    
		attr.value.Set(sId);
		m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_change_mgr.e_chng, 1, &attr, aeExt, false);

		if(0==aeExt.GetSize()) break;

		nNumber++;
	}
	m_api->m_options_mgr.CreateOption(sNumOption, nNumber);

	change_id=sId;
	return true;
}

//*************************************************************************
bool CaplChangeManager::AddItemsToChange(aplExtent &extItems, CaplInstance *change)
{
	if(0==extItems.GetSize()) return true;

	aplExtent extDocRev;

	long trd0=aplStartWaitDlg( APL_T("..."));

	int i,j;
	for(i=0;i<extItems.GetSize(); i++)
	{
		CaplInstance *inst=extItems[i];
		if(m_api->m_data.IsKindOf(inst, m_api->m_doc_mgr.e_apl_doc_rev)) { extDocRev.Add(inst); continue;}
		
		if(!m_api->m_data.IsKindOf(inst, m_api->m_doc_mgr.e_doc)) continue;

		// 
		//CaplInstance *act_rev;
		//m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_active,act_rev);
		//if(0!=rev) { extDocRev.Add(rev); continue;}

		//   

		CaplInstance *lastRev=m_api->m_doc_mgr.GetLasRevision(inst);
		if(0!=lastRev) 	extDocRev.Add(lastRev);
	}

	aplEndWaitDlg(trd0);

	if(0==extDocRev.GetSize())	{AfxMessageBox(APL_T("       !"),MB_ICONWARNING|MB_OK); return false;}

	if(0==change) change=m_api->m_change_mgr.SelectInstance(APL_MODE_SELECT_CHANGE,APL_T("  "));
	if(0==change) return false;
	if(change->GetAccessmode()>aplRW) {AfxMessageBox(APL_T("      !"),MB_ICONSTOP|MB_OK); return false;}

	m_api->m_change_mgr.LoadChangeInfo(change);
	
	CString state;
	m_api->m_data.GetAttr(change,m_api->m_change_mgr.a_chng_state,state);

	if( !( state==_T("") || state==_T("not_applied"))) {AfxMessageBox(APL_T("    !"),MB_ICONSTOP|MB_OK); return false;}

	aplExtent changeItems;
	m_api->m_data.GetAttr(change,m_api->m_change_mgr.a_chng_items,changeItems);


	CString sBuf;

	long trd1=aplStartWaitDlg( APL_T("..."));

	//CaplInstance *CurUser=m_api->m_data.GetCurrUser();
	CaplInstance *CurPerson=m_api->m_appr_mgr.GetCurrentPerson();
	CString sUserName;
	m_api->m_appr_mgr.GetPersonName(CurPerson,sUserName);
	sUserName += _T(" (");
	sUserName += m_api->m_data.GetNameCurrUser();
	sUserName += _T(")");	
	
	//m_api->m_appr_mgr.GetUserName(CurPerson,sUserName);


	//   
	int iCurNum=0;
	for(j=0; j<changeItems.GetSize();j++)
	{
		m_api->m_data.GetAttr(changeItems[j], m_api->m_change_mgr.a_chng_item_id, sBuf);
		int num=_atoi(sBuf);
		if(num>iCurNum) iCurNum=num;
	}

	bool bNeedSave=false;
	CaplInstance *rev, *rev_doc;
	int iAdded=0, iReplaced=0, iExist=0;

	//   
	for(i=0; i<extDocRev.GetSize(); i++)
	{
		rev=extDocRev[i];
		m_api->m_data.GetAttr(rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, rev_doc);

		// 
		bool bNeedAdd=true;
		for(j=0; j<changeItems.GetSize();j++)
		{
			CaplInstance *chng_item=changeItems[j];
			if(!m_api->m_data.IsKindOf(chng_item, m_api->m_change_mgr.e_avc)) continue;

			CaplInstance *chng_item_doc, *chng_item_rev;
			m_api->m_data.GetAttr(chng_item, m_api->m_change_mgr.a_avc_doc, chng_item_doc);
			m_api->m_data.GetAttr(chng_item, m_api->m_change_mgr.a_avc_new_rev, chng_item_rev);

			if(rev==chng_item_rev){iExist++; bNeedAdd=false; break;} //   

			if(chng_item_doc==rev_doc) //  
			{
				if(rev->GetId() > chng_item_rev->GetId()) //     
				{
					m_api->m_data.PutAttr(chng_item, m_api->m_change_mgr.a_avc_new_rev, rev);
					iReplaced++;
					bNeedAdd=false;
					bNeedSave=true;
				}
				break;
			}
		}

		if(!bNeedAdd) continue;
		
		iAdded++;
		bNeedSave=true;

		CaplInstance *newItem=m_api->m_data.CreateInstance(m_api->m_change_mgr.e_avc);
		changeItems.Add(newItem);
		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_of_chng, change);
		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_autor, CurPerson);
		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_user, sUserName);
		iCurNum++;
		sBuf.Format(_T("%i"),iCurNum);
		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_id, sBuf);


		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_avc_doc, rev_doc);
		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_avc_new_rev, rev);
		m_api->m_data.PutAttr(newItem, m_api->m_change_mgr.a_chng_item_replace_state, _T("approved"));
	}

	if( bNeedSave)
	{
		m_api->m_data.PutAttr(change,m_api->m_change_mgr.a_chng_items,changeItems);
		m_api->SaveChanges();
	}

	aplEndWaitDlg(trd1);

	
	sBuf.Format(APL_T("!\n\n: %i\n: %i\n : %i"),iAdded, iReplaced, iExist);
	AfxMessageBox(sBuf,MB_OK|MB_ICONINFORMATION);

	return true;
}



//     
bool CaplChangeManager::LoadChangeFields(CaplInstance *change, CaplStrStrMap &map_params)
{
	if(0==change) return false;
	if(change->GetAccessmode()>aplRO) return false;
	if(!m_api->m_data.IsKindOf(change,e_chng)) return false;

	m_api->m_change_mgr.LoadChangeInfo(change);

	CString buf,str;

	// 
	m_api->m_data.GetAttr(change,a_chng_id, str);
	map_params.Add(_T("id"), str);

	CaplInstance *src_pi;
	m_api->m_data.GetAttr(change, a_chng_src_pi, src_pi);


	//    
	m_api->m_data.GetAttr(change,a_chng_basis, str);
	map_params.Add(_T("basis"), str);
	m_api->m_data.GetAttr(change,a_chng_basis_code, str);
	map_params.Add(_T("basis_code"), str);

	//    ()
	m_api->m_data.GetAttr(change,a_chng_stock_ceh, str);
	map_params.Add(_T("stok_ceh"), str);

	//   
	m_api->m_data.GetAttr(change,a_chng_stock, str);
	map_params.Add(_T("stok"), str);	str.MakeLower();

	if(str.Find(APL_T(" "))>=0 || str.Find(APL_T(" "))>=0 || str.Find(APL_T("  "))>=0 )
	{
		map_params.Add(APL_NO_T("status:name:. 103"), APL_NO_T(".103"));
		map_params.Add(APL_NO_T("status:fio:. 103"), _T(""));
	}

	//   
	m_api->m_data.GetAttr(change,a_chng_stock_introd, str);
	map_params.Add(_T("stock_introd"), str);


	if(0!=src_pi)
	{
		LoadChangeInfo(src_pi);
		m_api->m_data.GetAttr(src_pi, a_chng_id, buf);
		map_params.Add(_T("pi_id"), buf);
		m_api->m_data.GetAttr(src_pi,a_chng_validity_pi_date, buf);
		COleDateTime odt;
		aplString2Date(buf,odt);
		buf=odt.Format(_T("%d.%m.%Y"));
		map_params.Add(_T("validity_pi_date"), buf);
	}
	else
	{
		//   
		m_api->m_data.GetAttr(change,a_chng_validity_pi_date, str);
		COleDateTime odt;
		aplString2Date(str,odt);
		str=odt.Format(_T("%d.%m.%Y"));
		map_params.Add(_T("validity_pi_date"), str);
	}


	// 
	m_api->m_data.GetAttr(change,a_chng_usage, str);
	map_params.Add(_T("usage"), str);

	// 
	m_api->m_data.GetAttr(change,a_chng_list, str);
	map_params.Add(_T("list"), str);

	// 
	m_api->m_data.GetAttr(change,a_chng_critical_date, str);
	m_api->m_data.GetAttr(change,a_chng_urgency, buf);
	if(buf!=_T("")) {str+=_T("\n"); str+=buf;}	
	map_params.Add(_T("crit_date"), str);

	m_api->m_data.GetAttr(change,a_chng_otd_date, str);
	map_params.Add(_T("otd_date"), str);

	m_api->m_data.GetAttr(change,a_chng_issue_date, str);
	map_params.Add(_T("issue_date"), str);

	m_api->m_data.GetAttr(change,a_chng_to_date, str);
	if(str.GetLength()<11) map_params.Add(_T("to_date_2"), str);
	else
	{  
		//   
		int i,j=1;
		CString tmp;
		for(i=0;i<str.GetLength();i++)
		{
			TCHAR c=str[i];
			if(c==_T(' ')|| c==_T('\n') || c==_T('\r'))
			{
				if(tmp.GetLength()>3)
				{
					buf.Format(_T("to_date_%i"),j);
					map_params.Add(buf, tmp);
					tmp=_T("");
					j++;
				}
				else tmp+=_T(' ');

				continue;
			}
			else tmp+=c;
		}
		if(tmp!=_T(""))
		{
			buf.Format(_T("to_date_%i"),j);
			map_params.Add(buf, tmp);	
		}
	}

	//m_api->m_data.GetAttr(change,a_chng_dscr, str);
	//map_params.Add(_T("chng_descr"), str);

	//m_api->m_data.GetAttr(change,a_chng_complect_num, str);
	//map_params.Add(_T("complect_num"), str);

	//  " "
	m_api->m_data.GetAttr(change,a_chng_state, str);
	if(str==_T("applied"))
	{
		CString sDate,sPerson;
		CaplInstance *person;
		m_api->m_data.GetAttr(change, a_chng_autor, person);
		if(0!=person) m_api->m_data.GetAttr(person, m_api->m_appr_mgr.a_pers_last_name, sPerson);

		m_api->m_data.GetAttr(change, a_chng_apply_date, buf);
		sDate=buf.Mid(6,2);
		sDate+=_T(".");
		sDate+=buf.Mid(4,2);
		sDate+=_T(".");
		sDate+=buf.Mid(2,2);

		buf=sPerson+_T(" ")+sDate;
		map_params.Add(_T("change_apply"), buf);

		map_params.Add(_T("control_copy_correct"), _T(""));
	}


	CString s_top_field,sGroupId;
	m_api->m_data.GetAttr(change,a_chng_name, s_top_field);

	m_api->m_data.GetAttr(change,a_chng_group_id, sGroupId);
	if(sGroupId!=_T(""))
	{
		aplExtent ext_ch;
		GetLinkedChange(change,ext_ch);
		if(ext_ch.GetSize()>0)
		{
			m_api->m_data.GetAttr(change,a_chng_id, str);
			CString sMainId;
			int j=str.ReverseFind(_T('/'));
			if(j>0)
			{
				sMainId=str.Left(j);
				j=sMainId.ReverseFind(_T(' '));
				if(j>0) 
				{
					str=sMainId.Left(j);
					sMainId=str;
				}
			}
			else sMainId =str;
			int i;
			CaplStrMap map_str;

			LoadChangeInfo(ext_ch);
			for(i=0;i<ext_ch.GetSize();i++)
			{
				m_api->m_data.GetAttr(ext_ch[i],a_chng_id, str);
				j=str.ReverseFind(_T('/'));
				if(j>0)
				{
					buf=str.Left(j);
					j=buf.ReverseFind(_T(' '));
					if(j>0) 
					{
						str=buf.Left(j);
						buf=str;
					}
				}
				else buf=str;
				if(buf==sMainId) continue;
				map_str.Add(buf,(void*)0);
			}

			CString sList;
			for(i=0;i<map_str.GetSize();i++)
			{
				if(sList!=_T("")) sList+=_T(", ");
				sList+=map_str.GetAt(i)->str;

			}
			if(sList!=_T("")) {s_top_field+=APL_T("   "); s_top_field+=sList;}
		}
	}
	map_params.Add(_T("top_field"), s_top_field);

	return true;
}
