#if !defined(AFX_CHANGEWHEREUSED_H__F8CA25AD_2F2B_4FFC_9C27_F9919BBE3DA6__INCLUDED_)
#define AFX_CHANGEWHEREUSED_H__F8CA25AD_2F2B_4FFC_9C27_F9919BBE3DA6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ChangeWhereUsed.h : header file
//

#include "ResizableDialog.h"

#include "resource.h"
#include "apl_gui.h"
#include "CommonChangeClasses.h"
#include "apl_api.h"

class CChangeParamDlg;

/////////////////////////////////////////////////////////////////////////////
// CChangeWhereUsed dialog

class CChangeWhereUsed : public CResizableDialog
{
// Construction
public:
	CChangeWhereUsed(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CChangeWhereUsed)
	enum { IDD = IDD_CHANGE_WHERE_USED_DLG };
	CEdit			m_sn;
	CaplButton		m_setEffBtn;
	CaplButton		m_itemPropBtn;
	CaplButton		m_itemDeleteBtn;
	CaplButton		m_itemChngBtn;
	CDateTimeCtrl	m_dateCtrl;
	CComboBox		m_contCtrl;
	CaplButton		m_itemClearBtn;
	CaplButton		m_selectBtn;
	CaplButton		m_refreshBtn;
	CaplButton		m_CancelBtn;
	CaplButton		m_okBtn;
	CSortListCtrl	m_WhereUsedList;
	CString			m_sProductId;
	CString			m_sProductName;
	CString			m_sProductVer;
	int				m_iCont;
	BOOL			m_bDateSelected;
	COleDateTime	m_oleDate;
	BOOL			m_bSNSelected;
	CString			m_sSN;
	BOOL			m_bNotShow;
	//}}AFX_DATA

	CImageList		m_ImageList;
	CImageList		m_btnImageList;

	CaplAPI*		m_api;
	
	CaplInstance*	m_change;
	
	CaplInstance*	m_psc;		//  
	CPSCItemInfo	m_pscInfo;	//  
	
	aplExtent*		m_items;	// ,     
	
	CArray<CPSCItemInfo, CPSCItemInfo> *m_newItems;		//  
	CArray<CPSCItemInfo, CPSCItemInfo> m_newestItems;	//  
	
	aplExtent*		m_delItems;		//  
	
	aplExtent		m_contexts;		//  
	
	CaplInstance*	m_assPdf;		//  
	
	aplExtent		m_extPdfs;		//  
	aplExtent		m_extRels;		// 
	aplRealArray	m_extCounts;	// -
	aplExtent		m_extUnits;		// ..

	//     
	CString m_sEffType;		//   
	CString m_sStartCond;	//   
	CString m_sEndCond;		//   
	
	bool	m_bReadOnly;	//  " "

	CaplInstance*	m_curItem;	//      "   "
	int				m_index;	//   

	CaplInstance*	m_curPSC;
	CPSCItemInfo*	m_curPSCInfo;

	bool m_bFilteredByDate;		//   
	bool m_bFilteredBySN;		//    
	bool m_bFilteredByContext;	//   

	struct sWhereUsedListItem
	{
		CaplInstance*	m_iRel;		// 
		COLORREF		m_Color;	// ,   
		bool			m_bActive;	//      
		
		sWhereUsedListItem()
		{
			m_Color		= ::GetSysColor(COLOR_WINDOWTEXT);
			m_bActive	= true;
		}
	};
	
	CaplTAggr <sWhereUsedListItem*, sWhereUsedListItem*,
				APLAGGR_LIST | APLAGGR_AUTOKILLREF> m_WhereUsedItems;
	
	CaplInstance* m_iDefaultPdf;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChangeWhereUsed)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	void CreateImageLists();

	void SetAnchors();
	void SetList();
	void SetButtons();

	void LoadContexts();

	CString PrintEffectivityInString(CString type, CString start, CString end);
	void InsertText(int num, CaplInstance* newPdf, double dCount, CaplInstance* unit, 
					CString sPos, CString sPosNum, CString sEffType, CString sStart, CString sEnd,
					CString sPrior);

	bool FindItem(CChangeParamDlg *dlg, bool bDelete = false);

	void FillWhereUsedList();

	/**        
		rel -  (NAUO)
		date -  
	*/
	bool IsPrdEffByDate(CaplInstance* rel, COleDateTime date);
	
	/**         
		rel -  (NAUO)
		sn -   
	*/
	bool IsPrdEffBySN(CaplInstance* rel, const TCHAR* sn);

	// Generated message map functions
	//{{AFX_MSG(CChangeWhereUsed)
	virtual BOOL OnInitDialog();
	afx_msg void OnChg2AssSelect();
	afx_msg void OnChg2AssRefresh();
	afx_msg void OnChg2ItemChange();
	afx_msg void OnItemchangedChgWhereUsedList(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	afx_msg void OnChg2ItemDelete();
	afx_msg void OnChg2Clear();
	afx_msg void OnChg2Prop();
	afx_msg void OnChg2SetEff();
	afx_msg void OnChg2SnCheck();
	afx_msg void OnChg2DateCheck();
	afx_msg void OnDatetimechangeChg2DateCtrl(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCloseupChg2ContextCombo();
	afx_msg void OnDblclkChgWhereUsedList(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG

	afx_msg void OnCustomdrawWhereUsedList( NMHDR* pNMHDR, LRESULT* pResult );
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHANGEWHEREUSED_H__F8CA25AD_2F2B_4FFC_9C27_F9919BBE3DA6__INCLUDED_)
