// CharactGroupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "CharactGroupDlg.h"
#include "stdafx.h"
#include "dictionary.h"
#include "CharacteristicDlg.h"
#include "StrValueDlg.h"
#include "RealValueDlg.h"
#include "MoneraryValDlg.h"
#include "EnumValDlg.h"
#include "DataTimeDlg.h"
#include "TableValDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCharactGroupDlg dialog


CCharactGroupDlg::CCharactGroupDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CCharactGroupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCharactGroupDlg)
	//}}AFX_DATA_INIT
	m_aggr_val.SetUniqueName(_T("apl_psm_charact_group"));
	m_ReadOnly=false;
	m_api=0;
	m_item=0;
	m_group=0; m_union_def=0;
}


void CCharactGroupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCharactGroupDlg)
	DDX_Control(pDX, IDC_CHOOSE_GROUP, m_choose_group_btn);
	DDX_Control(pDX, IDC_CHARACTERISTIC_GROUP, m_char_group);
	DDX_Control(pDX, IDC_SAVE_TO_FILE, m_save_to_file);
	DDX_Control(pDX, IDC_TBL_RECT, m_tbl_rect);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCharactGroupDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CCharactGroupDlg)
	ON_BN_CLICKED(IDC_SAVE_TO_FILE, OnSaveToFile)
	ON_NOTIFY(NM_DBLCLK, IDC_AGGR_VAL, OnDblclkList2)
	ON_BN_CLICKED(IDC_CHOOSE_GROUP, OnChooseGroup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCharactGroupDlg message handlers
void CCharactGroupDlg::OnSaveToFile() 
{
	apl_SaveListCtrlToFile(&m_aggr_val,LPCTSTR(m_group_name));
}

BOOL CCharactGroupDlg::OnInitDialog() 
{
	RECT rect={5,5,10,10},rect1;
	m_aggr_val.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDC_AGGR_VAL);
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

//	CResizableDialog::OnInitDialog();

	m_tbl_rect.GetWindowRect(&rect1);
	ScreenToClient(&rect1);
	m_aggr_val.MoveWindow(&rect1);
/*
	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	m_name_bmp.LoadMappedBitmap(IDB_CHARACT_NAME,0,&cm,1);
	HBITMAP hBmpOld=m_st_charact_name.SetBitmap(HBITMAP(m_name_bmp));	
	::DeleteObject(hBmpOld);
*/
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	//AddAnchor(IDC_CHARACTERYSTIC,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_AGGR_VAL, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_SAVE_TO_FILE, BOTTOM_LEFT);

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	//m_characterystic_ctrl.SetReadOnly(TRUE);	
	// TODO: Add extra initialization here
	
	//m_characterystic_ctrl.SetReadOnly(TRUE);

	m_save_to_file.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_save_to_file.SetFlat(FALSE);

//	m_top_btn.SetIcon(GetAplTableIco(APL_TABLE_TOP));
//	m_bottom_btn.SetIcon(GetAplTableIco(APL_TABLE_BOTTOM));

    ListView_SetExtendedListViewStyle(m_aggr_val.m_hWnd,
		ListView_GetExtendedListViewStyle(m_aggr_val.m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_INFOTIP);

	m_aggr_val.InsertColumn(0, APL_T(" "),LVCFMT_LEFT,80);
	m_aggr_val.CListCtrl::SetColumnWidth(0,130);
	m_aggr_val.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,140);
	m_aggr_val.CListCtrl::SetColumnWidth(0,130);
	m_aggr_val.InsertColumn(2, APL_T(""),LVCFMT_LEFT,50);
	m_aggr_val.CListCtrl::SetColumnWidth(0,100);
	m_aggr_val.InsertColumn(3, APL_T(""),LVCFMT_LEFT,140);
	m_aggr_val.CListCtrl::SetColumnWidth(0,200);
	m_aggr_val.InsertColumn(4, APL_T(".."),LVCFMT_LEFT,100);
	m_aggr_val.CListCtrl::SetColumnWidth(0,200);

	m_aggr_val.LoadColumnWidths();

	int i;
	CString buf;
	aplExtent ext0;
//	CaplInstance *inst;

	if(m_group!=0)
	{
		apidata.GetAttr(m_group,m_api->m_charact_mgr.a_charact_val_group_item,m_item);
		apidata.GetAttr(m_group,m_api->m_charact_mgr.a_charact_val_group_def,m_union_def);

	}
	if(m_union_def!=0)
	{
		UpdateCharacteristicList();
		m_choose_group_btn.EnableWindow(FALSE);
	}

	if(m_group!=0)
	{
		m_api->m_charact_mgr.GetGroupContents(m_group,m_ext_val);
		for(i=0;i<m_ext_val.Size;i++)
		{
			PrintValue(m_ext_val[i]);
		}
	}
	//if(m_ext_val.Size>0) m_characterystic_ctrl.EnableWindow(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCharactGroupDlg::OnDblclkList2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	*pResult = 0;

	if(m_ReadOnly) return;
	if(lpnmitem==0) return;
	
	int idx=lpnmitem->iItem;
	if(idx<0||idx>m_aggr_val.GetItemCount()-1) return;
	CaplInstance *inst=(CaplInstance*)m_aggr_val.GetItemData(idx);
	if(inst==0) return;

	int i;
	CaplInstance *charact=0,*val=0;
	for(i=0;i<m_ext_val.Size;i++)
	{
		apidata.GetAttr(m_ext_val[i],m_api->m_charact_mgr.a_apl_charact_val_charact,charact);
		if(charact==inst)
		{
			val=m_ext_val[i]; break;
		}
	}
	if(val==0)
	{
		bool prev_Usurpire=m_api->m_charact_mgr.m_AutoUsurpire;
		m_api->m_charact_mgr.m_AutoUsurpire=false;
		if(m_api->m_charact_mgr.CreateCharacteristic(m_item,0,&val,inst,0,true))
		{
			aplExtent ext;ext.Add(val);
			m_api->m_data.NET_CopyGroupeAccess(m_group,ext);
			m_ext_val.Add(val); 
			m_cancel_btn.EnableWindow(FALSE);
		}
		m_api->m_charact_mgr.m_AutoUsurpire=prev_Usurpire;
	}
	else
	{
		if(m_api->m_charact_mgr.ShowProperties(val)) m_cancel_btn.EnableWindow(FALSE);
	}

	PrintValue(val);
}

void CCharactGroupDlg::OnOK() 
{
	if(m_union_def==0){	AfxMessageBox( APL_T("  ")); return;	}
	if(m_group==0)
	{
		m_group=apidata.CreateInstance(m_api->m_charact_mgr.e_charact_val_group);
		apidata.PutAttr(m_group,m_api->m_charact_mgr.a_charact_val_group_def,m_union_def);
		apidata.PutAttr(m_group,m_api->m_charact_mgr.a_charact_val_group_item,m_item);
	}

	int i;
	CaplInstance *inst;
	for(i=0;i<m_ext_val.Size;i++)
	{
		apidata.GetAttr(m_ext_val[i],m_api->m_charact_mgr.a_apl_charact_val_group,inst);
		if(inst!=m_group)
			apidata.PutAttr(m_ext_val[i],m_api->m_charact_mgr.a_apl_charact_val_group,m_group);
	}
	CDialog::OnOK();
}

void CCharactGroupDlg::PrintValue(CaplInstance *val)
{
	if(val==0) return;
	CString buf;
	CaplInstance *charact,*inst;
	apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_charact,charact);

	int i,k=m_aggr_val.GetItemCount();
	for(i=0;i<k;i++)
	{
		inst=(CaplInstance*)m_aggr_val.GetItemData(i);
		if(inst==charact)
		{
			CaplInstance *lock=m_api->m_charact_mgr.CheckMyLock(val,false);
			if(lock)
			{
				m_api->m_charact_mgr.PrintCharacteristicValue(lock,0,buf);
				apidata.GetAttr(lock,m_api->m_charact_mgr.a_apl_charact_val_ver_type,inst);
			}
			else
			{
				m_api->m_charact_mgr.PrintCharacteristicValue(val,0,buf);
				apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_type,inst);
			}
			m_aggr_val.SetItemText(i,3,buf);
			buf=_T("");
			if(inst!=0) apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_charact_type_name,buf);
			m_aggr_val.SetItemText(i,2,buf);

		}
	}
}


void CCharactGroupDlg::OnChooseGroup() 
{
	if(m_ext_val.Size>0) return;
	CaplInstance *inst=m_api->m_charact_mgr.SelectCharactUnionGroup(m_union_def,m_group);
	if(inst==(CaplInstance *)-1)inst=0;
	if(inst==0) return;

	if(m_group==0)
	{
		CaplAttrValue tst_values[2];
		tst_values[0].value.Set(inst);
		tst_values[0].attr=m_api->m_charact_mgr.a_charact_val_group_def;
		tst_values[1].value.Set(m_item);
		tst_values[1].attr=m_api->m_charact_mgr.a_charact_val_group_item;
		
		if(!apidata.NET_TestUniqueAttrValues(m_api->m_charact_mgr.e_charact_val_group,m_group,2,&tst_values[0], false))
		{
			AfxMessageBox( APL_T("       !!!"),MB_OK|MB_ICONSTOP);
			return;
		}
	}
	m_union_def=inst;
	UpdateCharacteristicList();

	
}

void CCharactGroupDlg::UpdateCharacteristicList()
{
	m_aggr_val.DeleteAllItems();
	CString buf;
	apidata.GetAttrBN(m_union_def,S::name,m_group_name);
	m_char_group.SetWindowText(m_group_name);
	int i,k;
	CaplAggr aggr0;
	CaplInstance *inst1,*inst2;;
	apidata.GetAttr(m_union_def,m_api->m_charact_mgr.a_apl_charact_union_characteristics,aggr0);
	for(i=0;i<aggr0.GetSize();i++)
	{
		aggr0.GetByIndex(i,inst1);
		if(inst1==0) continue;
		apidata.GetAttr(inst1,m_api->m_charact_mgr.a_apl_charact_id,buf);
		k=m_aggr_val.InsertItem(m_aggr_val.GetItemCount(),buf);
		
		apidata.GetAttr(inst1,m_api->m_charact_mgr.a_apl_charact_name,buf);
		m_aggr_val.SetItemText(k,1,buf);
		apidata.GetAttr(inst1,m_api->m_charact_mgr.a_apl_charact_unit,inst2);
		m_api->m_charact_mgr.GetUnitName(inst2,buf);
		m_aggr_val.SetItemText(k,4,buf);
		m_aggr_val.SetItemData(k,(long)inst1);
	}
}
