#if !defined(AFX_CLASSIFIERTREEVIEW_H__175EA752_73EB_4626_94A3_B5496FA157F2__INCLUDED_)
#define AFX_CLASSIFIERTREEVIEW_H__175EA752_73EB_4626_94A3_B5496FA157F2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CClassifierTreeView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CClassifierTree view
#include "apl_api.h"

class CClassifierTreeItem;
class CClassifierTableItemsView;
class CPictureView;
class CSelectClassifierItemDlg;

typedef CArray<CClassifierTreeItem*, CClassifierTreeItem*> TClassifierItemsArray;

class CClassifierTreeItem : public CaplTreeItemData
{
protected:
	CaplAPI					*m_api;
	TClassifierItemsArray	*m_ItemsArray;
	CaplTreeView			*m_pTreeView;
	HTREEITEM				m_fictive_item;
	bool					m_bExpanded;
public:
	void CollapseItems();
	bool Create(CaplInstance* inst, HTREEITEM parent = TVI_ROOT);
    virtual bool Expand(UINT action);
	void Sort();
	bool Refresh();
	static void Sort(CTreeCtrl* tree);
    static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);

	CClassifierTreeItem(CaplAPI *api, TClassifierItemsArray* array, CaplTreeView* pTreeView);
	virtual ~CClassifierTreeItem();

	CaplInstance			*m_inst;
};

class CClassifierTreeView : public CaplTreeView
{
protected:
	CClassifierTreeView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CClassifierTreeView)
	
// Attributes
	aplExtent m_BaseSystems;
	TClassifierItemsArray	m_ItemsArray;

	COleDropTarget	m_OleDropTarget;
public:

	static CaplStrStrMap st_mapLastLevels;
	CString st_sTitle; //       

// Operations
public:
	bool RestoreSelectedClassifierItem();
	bool Update(CaplInstance* inst);
	void LoadData();

	CaplInstance *GetSelectedInstance();

	CaplAPI *m_api;
	CClassifierTableItemsView	*m_pTableView;
	CPictureView				*m_pPictureView;
	CSelectClassifierItemDlg	*m_pClassifDlg;
	static CString m_LastClassifierElement;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CClassifierTreeView)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point);
	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual void OnDragLeave();
	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CClassifierTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CClassifierTreeView)
	afx_msg void OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemSelChange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnUpdateAddClassifierSystem(CCmdUI* pCmdUI);
	afx_msg void OnAddClassifierSystem();
	afx_msg void OnAddClassifierLevel();
	afx_msg void OnUpdateAddClassifierLevel(CCmdUI* pCmdUI);
	afx_msg void OnDbConnect();
	afx_msg void OnDeleteElement();
	afx_msg void OnUpdateDeleteElement(CCmdUI* pCmdUI);
	afx_msg void OnEditElement();
	afx_msg void OnUpdateEditElement(CCmdUI* pCmdUI);
	afx_msg void OnRefresh();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CLASSIFIERTREEVIEW_H__175EA752_73EB_4626_94A3_B5496FA157F2__INCLUDED_)
