// DlgFirewallProperties.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DlgFirewallProperties.h"
#include "DlgIPDiapazon.h"
#include "aplSocketTransport.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgFirewallProperties dialog


CDlgFirewallProperties::CDlgFirewallProperties(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CDlgFirewallProperties::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgFirewallProperties)
	m_OnFirewall = FALSE;
	//}}AFX_DATA_INIT
}


void CDlgFirewallProperties::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgFirewallProperties)
	DDX_Control(pDX, IDC_LIST_PATTERN_ST, m_st_list);
	DDX_Check(pDX, IDC_CHECK_ON_FIREWALL, m_OnFirewall);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDC_PROP, m_BtnProp);
	DDX_Control(pDX, IDC_DEL, m_BtnDel);
	DDX_Control(pDX, IDC_ADD, m_BtnAdd);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgFirewallProperties, CResizableDialog)
	//{{AFX_MSG_MAP(CDlgFirewallProperties)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_PROP, OnProperty)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnProperty1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgFirewallProperties message handlers

BOOL CDlgFirewallProperties::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	// TODO: Add extra initialization here
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);

	m_BtnProp.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_BtnDel.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	m_BtnAdd.SetIcon(GetAplTableIco(APL_TABLE_NEW));

	CRect rect;
	//RECT rect={5,5,10,10};
	m_list.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS|LVS_SINGLESEL,rect,this,IDC_LIST);
	
	m_st_list.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_list.MoveWindow(&rect);
	
	ListView_SetExtendedListViewStyle(m_list.m_hWnd,
		ListView_GetExtendedListViewStyle(m_list.m_hWnd)
		|LVS_EX_UNDERLINECOLD |LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	AddAnchor(IDC_ADD,TOP_RIGHT);
	AddAnchor(IDC_DEL,TOP_RIGHT);
	AddAnchor(IDC_PROP,TOP_RIGHT);
	
	AddAnchor(IDC_LIST,TOP_LEFT,BOTTOM_RIGHT);
	
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);

	m_list.InsertColumn(0, APL_T(" "),LVCFMT_LEFT,rect.Width()*49/100);
	m_list.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,rect.Width()*49/100);

	ParseListIpDiapazon(m_white_list,m_map_of_ip);

	FeelList();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgFirewallProperties::FeelList() 
{
	int i,pos;
	CString buf;

	m_list.DeleteAllItems();

	for(i=0;i<m_map_of_ip.Size;i++)
	{
		Ip2String(m_map_of_ip.Data[i].in,buf);
		pos=m_list.InsertItem(i,buf);
		m_list.SetItemData(pos,i);
		Ip2String(m_map_of_ip.Data[i].out,buf);
		m_list.SetItemText(pos,1,buf);
	}
}

void CDlgFirewallProperties::OnAdd() 
{
	// TODO: Add your control notification handler code here
	CDlgIPDiapazon dlgIPdiapazon;
	if(dlgIPdiapazon.DoModal()==IDOK){
		m_map_of_ip.Add(dlgIPdiapazon.m_IP1,dlgIPdiapazon.m_IP2);
		FeelList();
	}
}

void CDlgFirewallProperties::OnProperty1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnProperty();
}

void CDlgFirewallProperties::OnProperty() 
{
	// TODO: Add your control notification handler code here
	int pos,indx;
	pos= m_list.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( pos== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	indx=m_list.GetItemData(pos);
	CDlgIPDiapazon dlgIPdiapazon;
	dlgIPdiapazon.m_IP1=m_map_of_ip.Data[indx].in;
	dlgIPdiapazon.m_IP2=m_map_of_ip.Data[indx].out;

	if(dlgIPdiapazon.DoModal()==IDOK){
		m_map_of_ip.Data[indx].in	=dlgIPdiapazon.m_IP1;
		m_map_of_ip.Data[indx].out	=dlgIPdiapazon.m_IP2;
		FeelList();
	}

}

void CDlgFirewallProperties::OnDel() 
{
	// TODO: Add your control notification handler code here
	int pos,indx;
	pos= m_list.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( pos== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	indx=m_list.GetItemData(pos);
	if(AfxMessageBox( APL_T("    ?"),MB_YESNO)==IDYES){
		m_map_of_ip.Remove(indx);
		FeelList();
	}
	
}

void CDlgFirewallProperties::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);

	MakeListIpDiapazon(m_map_of_ip,m_white_list);

	if(m_OnFirewall && m_white_list.IsEmpty()==TRUE)
	{
		if(IDYES==AfxMessageBox( APL_T("      \n         (localhost)\n   ?"),
			MB_YESNO | MB_ICONEXCLAMATION))
		{
			return;
		}
	}
	
	CResizableDialog::OnOK();
}


