// ExportProductAttrsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ExportProductAttrsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExportProductAttrsDlg dialog


CExportProductAttrsDlg::CExportProductAttrsDlg(CaplAPI* api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CExportProductAttrsDlg::IDD, pParent)
{
	ASSERT(api);
	m_api = api;

	m_Inst=NULL;
	m_CreatedInst=NULL;
	m_DefLang = NULL;
	m_bCreateMode = true;

	//{{AFX_DATA_INIT(CExportProductAttrsDlg)
	m_sExportId = _T("");
	m_sExportName = _T("");
	m_sPrdCode = _T("");
	m_sPrdId = _T("");
	m_sPrdName = _T("");
	m_sExportCode = _T("");
	//}}AFX_DATA_INIT
}


void CExportProductAttrsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExportProductAttrsDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_LANGUAGE, m_LanguageCombo);
	DDX_Text(pDX, IDC_EXPORT_ID, m_sExportId);
	DDX_Text(pDX, IDC_EXPORT_NAME, m_sExportName);
	DDX_Text(pDX, IDC_PRD_CODE, m_sPrdCode);
	DDX_Text(pDX, IDC_PRD_ID, m_sPrdId);
	DDX_Text(pDX, IDC_PRD_NAME, m_sPrdName);
	DDX_Text(pDX, IDC_EXPORT_CODE, m_sExportCode);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExportProductAttrsDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CExportProductAttrsDlg)
	ON_CBN_SELCHANGE(IDC_LANGUAGE, OnSelchangeLanguage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExportProductAttrsDlg message handlers

void CExportProductAttrsDlg::OnOK() 
{
	if(!m_bCreateMode)
	{
		CaplTranslateDialog::OnOK();
		return;
	}

	if(!UpdateData()) return;

	m_sExportId.TrimLeft();
	m_sExportId.TrimRight();
	m_sExportName.TrimLeft();
	m_sExportName.TrimRight();
	m_sExportCode.TrimLeft();
	m_sExportCode.TrimRight();

	if(m_sExportId.IsEmpty() && !m_sPrdId.IsEmpty())
	{
		AfxMessageBox( APL_T("     !"));
		return;
	}
	if(m_sExportName.IsEmpty() && !m_sPrdName.IsEmpty())
	{
		AfxMessageBox( APL_T("     !"));
		return;
	}
	int cur = m_LanguageCombo.GetCurSel();
	if(cur<0)
	{
		AfxMessageBox( APL_T("  ,     !"));
		return;
	}
	//  
	aplExtent ext;
	CaplAttrValue tst_vals[2];
	CaplInstance* lang;
	lang = (CaplInstance*)m_LanguageCombo.GetItemData(cur);
	tst_vals[0].attr = m_api->m_prd_mgr.a_apl_export_product_ofproduct;
	tst_vals[0].value.Set(m_Inst);
	tst_vals[1].attr = m_api->m_prd_mgr.a_apl_export_product_language;
	tst_vals[1].value.Set(lang);
	if(m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_prd_mgr.e_apl_export_product, 2, &tst_vals[0], ext, false)>0)
	{
		AfxMessageBox( APL_T("      !"), MB_OK|MB_ICONSTOP);
		return;
	}

	m_CreatedInst = m_api->m_prd_mgr.CreateExportProduct(m_Inst, lang, m_sExportId, m_sExportName, m_sExportCode);
	
	CaplTranslateDialog::OnOK();
}

BOOL CExportProductAttrsDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if(m_Inst==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	if(!m_api->m_data.IsDictLoad())
	{
		EndDialog(0);
		return FALSE;
	}

	aplExtent langs, ExPrds;
	int i;
	CString buf;
	
	if(m_api->m_data.IsKindOf(m_Inst, m_api->m_prd_mgr.e_prd))
	{
		m_api->m_data.GetAttr(m_Inst, m_api->m_prd_mgr.a_prd_id, m_sPrdId);
		m_api->m_data.GetAttr(m_Inst, m_api->m_prd_mgr.a_prd_name, m_sPrdName);
		m_api->m_data.GetAttr(m_Inst, m_api->m_prd_mgr.a_prd_code, m_sPrdCode);
	}
	else
	{
		AfxMessageBox( APL_T("     !"), MB_OK|MB_ICONSTOP);
		EndDialog(0);
		return FALSE;
	}

	if(m_bCreateMode)
	{
		m_api->m_data.GetEntityExtent(m_api->m_prd_mgr.e_apl_language, langs);
		if(langs.GetSize()==0)
		{
			AfxMessageBox( APL_T("     .       !"), MB_OK|MB_ICONSTOP);
			EndDialog(0);
			return FALSE;
		}
		for(i=0; i<langs.GetSize(); i++)
		{
			m_api->m_data.GetAttr(langs[i], m_api->m_prd_mgr.a_apl_language_name, buf);
			m_LanguageCombo.SetItemData(m_LanguageCombo.AddString(buf), (DWORD)langs[i]);
		}
		m_LanguageCombo.SetCurSel(0);
		
	}
	else
	{
		m_api->m_prd_mgr.FindExportProducts(m_Inst, ExPrds, &langs);
		if(ExPrds.GetSize()==0)
		{
			AfxMessageBox( APL_T("        !"), MB_OK|MB_ICONSTOP);
			EndDialog(0);
			return FALSE;
		}
		int ind;
		bool bSet = false;
		for(i=0; i<langs.GetSize(); i++)
		{
			m_api->m_data.GetAttr(langs[i], m_api->m_prd_mgr.a_apl_language_name, buf);
			ind = m_LanguageCombo.AddString(buf);
			m_LanguageCombo.SetItemData(ind, (DWORD)langs[i]);
			if(m_DefLang!=NULL && m_DefLang==langs[i])
			{
				m_LanguageCombo.SetCurSel(ind);
				bSet = true;
			}
		}
		if(!bSet)
			m_LanguageCombo.SetCurSel(0);
		CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EXPORT_CODE);
		pEdit->SetReadOnly(TRUE);
		pEdit = (CEdit*)GetDlgItem(IDC_EXPORT_ID);
		pEdit->SetReadOnly(TRUE);
		pEdit = (CEdit*)GetDlgItem(IDC_EXPORT_NAME);
		pEdit->SetReadOnly(TRUE);

		OnSelchangeLanguage();
	}

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CExportProductAttrsDlg::OnSelchangeLanguage() 
{
	if(m_bCreateMode) return;

	int cur = m_LanguageCombo.GetCurSel();
	if(cur<0) return;
	CaplInstance* lang;
	lang = (CaplInstance*)m_LanguageCombo.GetItemData(cur);
	m_CreatedInst = m_api->m_prd_mgr.GetExportProduct(m_Inst, lang, false);
	FillExportProductData();
}

void CExportProductAttrsDlg::FillExportProductData()
{
	if(m_CreatedInst==NULL) return;

	m_api->m_data.GetAttr(m_CreatedInst, m_api->m_prd_mgr.a_apl_export_product_name, m_sExportName);
	m_api->m_data.GetAttr(m_CreatedInst, m_api->m_prd_mgr.a_apl_export_product_id, m_sExportId);
	m_api->m_data.GetAttr(m_CreatedInst, m_api->m_prd_mgr.a_apl_export_product_code, m_sExportCode);

	UpdateData(FALSE);
}
