// FindAdjustDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "FindAdjustApprDlg.h"
#include "FindQueryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustApprDlg dialog


CFindAdjustApprDlg::CFindAdjustApprDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindAdjustApprDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindAdjustApprDlg)
	m_chk_date_beg = FALSE;
	m_chk_date_end = FALSE;
	m_chk_revoc_beg = FALSE;
	m_chk_revoc_end = FALSE;
	m_chk_person = FALSE;
	m_chk_role = FALSE;
	m_chk_status = FALSE;
	m_chk_dig_sign = FALSE;
	m_role_eq = TRUE;
	m_chk_date = FALSE;
	m_chk_descr = FALSE;
	m_EdtPO = _T("");
	m_EdtDescr = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_el=0;
	m_po=0;
	m_read_only=false;
	m_mode_slave=false;
}


void CFindAdjustApprDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindAdjustApprDlg)
	DDX_Control(pDX, IDC_CHK_STATUS, m_chk_st_status);
	DDX_Control(pDX, IDC_CHK_DIGITAL_SIGN, m_chk_st_dig_sign);
	DDX_Control(pDX, IDC_CHK_ROLE, m_chk_st_role);
	DDX_Control(pDX, IDC_CHK_PERSON, m_chk_st_person);
	DDX_Control(pDX, IDC_CHK_DATE, m_chk_st_date);
	DDX_Control(pDX, IDC_PO, m_CtrlPO);
	DDX_Control(pDX, IDC_DESCR, m_CtrlDescr);
	DDX_Control(pDX, IDC_SEL_PO, m_BtnSelPO);
	DDX_Control(pDX, IDC_EXIST_APPROVAL, m_ExistApproval);
	DDX_Control(pDX, IDC_CHK_DATE_END, m_chk_date_end_ctrl);
	DDX_Control(pDX, IDC_CHK_DATE_BEG, m_chk_date_beg_ctrl);
	DDX_Control(pDX, IDC_CHK_REVOCATION_END, m_chk_revoc_date_end_ctrl);
	DDX_Control(pDX, IDC_CHK_REVOCATION_BEG, m_chk_revoc_date_beg_ctrl);
	DDX_Control(pDX, IDC_TYPE_DATE, m_type_date);
	DDX_Control(pDX, IDC_DATE_END, m_date_end_ctrl);
	DDX_Control(pDX, IDC_DATE_BEG, m_date_beg_ctrl);
	DDX_Control(pDX, IDC_TIME_END, m_time_end_ctrl);
	DDX_Control(pDX, IDC_TIME_BEG, m_time_beg_ctrl);
	DDX_Control(pDX, IDC_REVOCATION_DATE_END, m_revoc_date_end_ctrl);
	DDX_Control(pDX, IDC_REVOCATION_DATE_BEG, m_revoc_date_beg_ctrl);
	DDX_Control(pDX, IDC_REVOCATION_TIME_END, m_revoc_time_end_ctrl);
	DDX_Control(pDX, IDC_REVOCATION_TIME_BEG, m_revoc_time_beg_ctrl);
	DDX_Control(pDX, IDC_STATUS, m_status);
	DDX_Control(pDX, IDC_EXIST_DIG_SIGN, m_dig_sign);
	DDX_Control(pDX, IDC_ROLE, m_po_role);
	DDX_Check(pDX, IDC_CHK_DATE_BEG, m_chk_date_beg);
	DDX_Check(pDX, IDC_CHK_DATE_END, m_chk_date_end);
	DDX_Check(pDX, IDC_CHK_REVOCATION_BEG, m_chk_revoc_beg);
	DDX_Check(pDX, IDC_CHK_REVOCATION_END, m_chk_revoc_end);
	DDX_Check(pDX, IDC_CHK_PERSON, m_chk_person);
	DDX_Check(pDX, IDC_CHK_ROLE, m_chk_role);
	DDX_Check(pDX, IDC_CHK_STATUS, m_chk_status);
	DDX_Check(pDX, IDC_CHK_DIGITAL_SIGN, m_chk_dig_sign);
	DDX_Check(pDX, IDC_CHK_DATE, m_chk_date);
	DDX_Check(pDX, IDC_CHK_DESCR, m_chk_descr);
	DDX_Text(pDX, IDC_PO, m_EdtPO);
	DDX_Text(pDX, IDC_DESCR, m_EdtDescr);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOk);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_CMBX_DESCR_REL, m_CmbxDescrRel);
}


BEGIN_MESSAGE_MAP(CFindAdjustApprDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindAdjustApprDlg)
	ON_WM_CANCELMODE()
	ON_BN_CLICKED(IDC_CHK_STATUS, OnChk)
	ON_BN_CLICKED(IDC_CHK_DIGITAL_SIGN, OnChk)
	ON_CBN_SELCHANGE(IDC_TYPE_DATE, OnSelchangeTypeDate)
	ON_CBN_SELCHANGE(IDC_EXIST_APPROVAL, OnSelchangeExistApproval)
	ON_BN_CLICKED(IDC_SEL_PO, OnSelPo)
	ON_BN_CLICKED(IDC_CHK_PERSON, OnChk)
	ON_BN_CLICKED(IDC_CHK_ROLE, OnChk)
	ON_BN_CLICKED(IDC_CHK_DESCR, OnChk)
	ON_BN_CLICKED(IDC_CHK_DATE_BEG, OnChk)
	ON_BN_CLICKED(IDC_CHK_DATE_END, OnChk)
	ON_BN_CLICKED(IDC_CHK_DATE, OnChk)
	ON_BN_CLICKED(IDC_CHK_REVOCATION_BEG, OnChk)
	ON_BN_CLICKED(IDC_CHK_REVOCATION_END, OnChk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustApprDlg message handlers

void FeelCmbxRelation(CComboBox &CmbxDescrRel, CaplQLQuery::aplQLLogRelation added_relation, CaplQLQuery::aplQLLogRelation cur_log_relation)
{
	int pos = CmbxDescrRel.AddString(CaplQLQuery::LogOp2String(added_relation, true));
	CmbxDescrRel.SetItemData(pos, added_relation);
	if(added_relation==cur_log_relation)
		CmbxDescrRel.SetCurSel(pos);

}

BOOL CFindAdjustApprDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	// TODO: Add extra initialization here
	if(m_api==0) return FALSE;

	m_ExistApproval.ResetContent();
	m_ExistApproval.InsertString(0,APL_T(""));
	m_ExistApproval.InsertString(1,APL_T(""));

	m_type_date.ResetContent();
	m_type_date.InsertString(0,APL_T(" "));
	m_type_date.InsertString(1,APL_T(""));

	m_dig_sign.ResetContent();
	m_dig_sign.InsertString(0,APL_T(""));
	m_dig_sign.InsertString(1,APL_T(""));

	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);

	int i,k;
	aplExtent ext0;
	CaplAggr aggr0;
	CString buf,buf1;
//	CaplInstance *inst,*inst1;

	COleDateTime odt; odt.GetCurrentTime();

	m_ExistApproval.SetCurSel(0);
	//  
	apidata.GetEntityExtentBN(_T("approval_status"),ext0);
	for(i=0;i<ext0.Size;i++)
	{
		apidata.GetAttrBN(ext0[i],_T("name"),buf);
		k=m_status.AddString(buf);
		m_status.SetItemData(k,(long)ext0[i]);
	}

	//  
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_po_role,ext0);
	for(i=0;i<ext0.Size;i++)
	{
		apidata.GetAttrBN(ext0[i],_T("name"),buf);
		k=m_po_role.AddString(buf);
		m_po_role.SetItemData(k,(long)ext0[i]);

	}
	m_type_date.SetCurSel(0);
	CaplQLQuery::aplQLLogRelation cur_log_relation = CaplQLQuery::aplLIKE;

	//  
	if(m_el!=0)
	{
		if(m_el->is_exist){
			m_ExistApproval.SetCurSel(0);
		}else{
			m_ExistApproval.SetCurSel(1);
		}
		if(m_el->is_dig_sign==0){
			m_dig_sign.SetCurSel(0);
			m_chk_dig_sign=TRUE;
		}else if(m_el->is_dig_sign==1){
			m_dig_sign.SetCurSel(1);
			m_chk_dig_sign=TRUE;
		}else
		{
			m_chk_dig_sign=FALSE;
		}

		if(m_el->status!=0)
		{
			apidata.GetAttrBN(m_el->status,_T("name"),buf);
			m_status.SelectString(0,buf);
			m_chk_status=TRUE;
		}
		if(m_el->pers_org_role!=_T("")){
			m_po_role.SelectString(0,m_el->pers_org_role);
			m_chk_role=TRUE;
		}
		
		if(m_el->person!=0){
			m_po=m_el->person;
			m_api->m_appr_mgr.GetPersonName(m_po,m_EdtPO);
			m_chk_person=TRUE;
		}
		if(m_el->descr!=_T("")){
			m_EdtDescr=m_el->descr;
			cur_log_relation = m_el->descr_relation;
			m_chk_descr=TRUE;
		}
		if(m_el->is_single_date){
			m_type_date.SetCurSel(0);
		}else{
			m_type_date.SetCurSel(1);
		}
		if(m_el->date_time_beg!=0 || m_el->date_time_end!=0){
			m_chk_date=TRUE;
			if(m_el->date_time_beg!=0){
				m_date_beg_ctrl.SetTime(*(m_el->date_time_beg));
				m_time_beg_ctrl.SetTime(*(m_el->date_time_beg));
				m_chk_date_beg=TRUE;
			}
			if(m_el->date_time_end!=0){
				m_date_end_ctrl.SetTime(*(m_el->date_time_end));
				m_time_end_ctrl.SetTime(*(m_el->date_time_end));
				m_chk_date_end=TRUE;
			}
			MakeDateState();
		}
		if(m_el->revoc_date_time_beg!=0 || m_el->revoc_date_time_end!=0){
			if(m_el->revoc_date_time_beg!=0){
				m_revoc_date_beg_ctrl.SetTime(*(m_el->revoc_date_time_beg));
				m_revoc_time_beg_ctrl.SetTime(*(m_el->revoc_date_time_beg));
				m_chk_revoc_beg=TRUE;
			}
			if(m_el->revoc_date_time_end!=0){
				m_revoc_date_end_ctrl.SetTime(*(m_el->revoc_date_time_end));
				m_revoc_time_end_ctrl.SetTime(*(m_el->revoc_date_time_end));
				m_chk_revoc_end=TRUE;
			}
			MakeDateState();
		}
	}
	else
	{
		m_dig_sign.SetCurSel(0);
	}

	while(m_CmbxDescrRel.GetCount()>0)
	{
		m_CmbxDescrRel.DeleteItem(0);
	}

	FeelCmbxRelation(m_CmbxDescrRel, CaplQLQuery::aplLIKE, cur_log_relation);
	FeelCmbxRelation(m_CmbxDescrRel, CaplQLQuery::aplNOTLIKE, cur_log_relation);
	FeelCmbxRelation(m_CmbxDescrRel, CaplQLQuery::aplEQUAL, cur_log_relation);
	FeelCmbxRelation(m_CmbxDescrRel, CaplQLQuery::aplNOTEQUAL, cur_log_relation);


	UpdateData(FALSE);
	OnChk();
	
	if(m_read_only){
		m_CtrlPO.EnableWindow(FALSE);
		m_BtnSelPO.EnableWindow(FALSE);
		m_ExistApproval.EnableWindow(FALSE);
		m_chk_date_end_ctrl.EnableWindow(FALSE);
		m_chk_date_beg_ctrl.EnableWindow(FALSE);
		m_type_date.EnableWindow(FALSE);
//		m_role_eq_ctrl.EnableWindow(FALSE);
		m_date_end_ctrl.EnableWindow(FALSE);
		m_date_beg_ctrl.EnableWindow(FALSE);
		m_time_end_ctrl.EnableWindow(FALSE);
		m_time_beg_ctrl.EnableWindow(FALSE);
		m_revoc_date_end_ctrl.EnableWindow(FALSE);
		m_revoc_date_beg_ctrl.EnableWindow(FALSE);
		m_revoc_time_end_ctrl.EnableWindow(FALSE);
		m_revoc_time_beg_ctrl.EnableWindow(FALSE);
		m_status.EnableWindow(FALSE);
		m_dig_sign.EnableWindow(FALSE);
		m_po_role.EnableWindow(FALSE);
		m_chk_st_date.EnableWindow(FALSE);
		m_chk_st_person.EnableWindow(FALSE);
		m_chk_st_role.EnableWindow(FALSE);
		m_chk_st_status.EnableWindow(FALSE);
		m_chk_st_dig_sign.EnableWindow(FALSE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CFindAdjustApprDlg::MakeRevoceState()
{
	m_revoc_date_end_ctrl.EnableWindow(m_chk_revoc_end);
	m_revoc_time_end_ctrl.EnableWindow(m_chk_revoc_end);
	m_revoc_date_beg_ctrl.EnableWindow(m_chk_revoc_beg);
	m_revoc_time_beg_ctrl.EnableWindow(m_chk_revoc_beg);
}

void CFindAdjustApprDlg::MakeDateState()
{
	int i=m_type_date.GetCurSel();
	switch(i){
	case 0:
		//  
		m_chk_date_beg_ctrl.EnableWindow(false);
		m_date_beg_ctrl.EnableWindow(m_chk_date);
		m_time_beg_ctrl.EnableWindow(m_chk_date);
		m_chk_date_end_ctrl.EnableWindow(false);
		m_date_end_ctrl.EnableWindow(false);
		m_time_end_ctrl.EnableWindow(false);
		break;
	default:
		// 
		m_chk_date_beg_ctrl.EnableWindow(m_chk_date);
		m_date_beg_ctrl.EnableWindow(m_chk_date_beg && m_chk_date);
		m_time_beg_ctrl.EnableWindow(m_chk_date_beg && m_chk_date);
		m_chk_date_end_ctrl.EnableWindow(m_chk_date);
		m_date_end_ctrl.EnableWindow(m_chk_date_end && m_chk_date);
		m_time_end_ctrl.EnableWindow(m_chk_date_end && m_chk_date);
	}
}


void CFindAdjustApprDlg::OnCancelMode() 
{
	CaplTranslateDialog::OnCancelMode();
	
	// TODO: Add your message handler code here
	
}

void CFindAdjustApprDlg::OnOK() 
{
	// TODO: Add extra validation here
	CaplAggr aggr;
	CString buf,sval,role;
	CaplInstance *status,*inst;
	COleDateTime /*odt_b,odt_e,*/odt_d,odt_t; 
	
	CaplLoadData ld(&apidata,DEF_SOURCE);
	aplExtent ext;
	long aplError= 0;
	bool bNoError= false;

	UpdateData(TRUE);

	if(!m_mode_slave && !m_chk_status && !m_chk_person && !m_chk_descr && !m_chk_role && !m_chk_date && !m_chk_revoc_beg && !m_chk_revoc_end && !m_chk_dig_sign){
		AfxMessageBox( APL_T("    !!!"));
		return;
	}

	status=(CaplInstance*)m_status.GetItemData(m_status.GetCurSel());
	if(status==(CaplInstance*)-1)status=0;
	if(status==0 && m_chk_status)
	{
		AfxMessageBox( APL_T("   !!!"));
		return;
	}
	if(m_po==0 && m_chk_person)
	{
		AfxMessageBox( APL_T("   !!!"));
		return;
	}
	if(m_EdtDescr==_T("") && m_chk_descr)
	{
		AfxMessageBox( APL_T("   !!!"));
		return;
	}
	m_po_role.GetWindowText(role);
	if(role==_T("") && m_chk_role)
	{
		AfxMessageBox( APL_T("   !!!"));
		return;
	}
	int i_date=m_type_date.GetCurSel();
	if(m_chk_date && i_date==1 && !m_chk_date_beg && !m_chk_date_end){
		AfxMessageBox( APL_T("     !!!"));
		return;

	}

	if(m_el==0){
		m_el=new ElValApproval();
	}

	m_el->is_exist=m_ExistApproval.GetCurSel()==0;
	if(m_chk_date){
		switch(i_date){
		case 0:
			//  
			m_el->is_single_date=true;
			if(m_el->date_time_beg==0){
				m_el->date_time_beg=new COleDateTime();
			}

			m_date_beg_ctrl.GetTime(odt_d);
			m_time_beg_ctrl.GetTime(odt_t);
			m_el->date_time_beg->SetDateTime(odt_d.GetYear(),odt_d.GetMonth(),odt_d.GetDay(),
					odt_t.GetHour(),odt_t.GetMinute(),odt_t.GetSecond());
//			date_mgr.Put(odt_b,&(m_el->date_time_beg));
			break;
		default:
			// 
			m_el->is_single_date=false;
			if(m_chk_date_beg){
				if(m_el->date_time_beg==0){
//					m_el->date_time_beg=new CaplInstance(apidata.GetEntityBN(_T("apl_date_and_time")));
					m_el->date_time_beg=new COleDateTime();
				}
//				m_date_beg_ctrl.GetTime(odt_b);
//				date_mgr.Put(odt_b,&(m_el->date_time_beg));
				m_date_beg_ctrl.GetTime(odt_d);
				m_time_beg_ctrl.GetTime(odt_t);
				m_el->date_time_beg->SetDateTime(odt_d.GetYear(),odt_d.GetMonth(),odt_d.GetDay(),
						odt_t.GetHour(),odt_t.GetMinute(),odt_t.GetSecond());
			}else{
				if(m_el->date_time_beg!=0){
					delete m_el->date_time_beg;
					m_el->date_time_beg=0;
				}
			}
			if(m_chk_date_end){
//				m_date_end_ctrl.GetTime(odt_e);
				if(m_el->date_time_end==0){
//					m_el->date_time_end=new CaplInstance(apidata.GetEntityBN(_T("apl_date_and_time")));
					m_el->date_time_end=new COleDateTime();
				}
//				date_mgr.Put(odt_e,&(m_el->date_time_end));
				m_date_end_ctrl.GetTime(odt_d);
				m_time_end_ctrl.GetTime(odt_t);
				m_el->date_time_end->SetDateTime(odt_d.GetYear(),odt_d.GetMonth(),odt_d.GetDay(),
						odt_t.GetHour(),odt_t.GetMinute(),odt_t.GetSecond());
				if(m_chk_date_beg){
//					if(odt_e<odt_b){
					if(*(m_el->date_time_end)<*(m_el->date_time_beg)){
						AfxMessageBox( APL_T("        !!!"));
						return;
					}
				}
			}else{
				if(m_el->date_time_end!=0){
					delete m_el->date_time_end;
					m_el->date_time_end=0;
				}
			}
		}
	}else{
		if(m_el->date_time_beg!=0){delete m_el->date_time_beg;m_el->date_time_beg=0;}
		if(m_el->date_time_end!=0){delete m_el->date_time_end;m_el->date_time_end=0;}
		m_el->is_single_date=true;
	}
	if(m_chk_dig_sign){
		m_el->is_dig_sign=m_dig_sign.GetCurSel();
	}else{
		m_el->is_dig_sign=-1;
	}	

	if(m_chk_status){
		m_el->status=status;
	}else{
		m_el->status=0;
	}	
	if(m_chk_person){
		m_el->person=m_po;
	}else{
		m_el->person=0;
	}
	if(m_chk_descr)
	{
		m_el->descr = m_EdtDescr;
		m_el->descr_relation = (CaplQLQuery::aplQLLogRelation)m_CmbxDescrRel.GetItemData(m_CmbxDescrRel.GetCurSel());
	}

	if(m_chk_role){
		m_el->pers_org_role=role;
//		m_el->pers_org_role_eq=(m_role_eq==1);
		m_el->pers_org_role_eq=false;
		for(int i=0;i<m_po_role.GetCount();i++)
		{
			inst=(CaplInstance*)m_po_role.GetItemData(i);
			apidata.GetAttrBN(inst,_T("name"),buf);
			if(buf==role){
				m_el->pers_org_role_eq=true;
				break;
			}
		}
	}else{
		m_el->pers_org_role=_T("");
	}

	if(m_chk_revoc_beg){
		if(m_el->revoc_date_time_beg==0){
			m_el->revoc_date_time_beg=new COleDateTime();
		}
		m_revoc_date_beg_ctrl.GetTime(odt_d);
		m_revoc_time_beg_ctrl.GetTime(odt_t);
		m_el->revoc_date_time_beg->SetDateTime(odt_d.GetYear(),odt_d.GetMonth(),odt_d.GetDay(),
			odt_t.GetHour(),odt_t.GetMinute(),odt_t.GetSecond());
	}else{
		if(m_el->revoc_date_time_beg!=0){
			delete m_el->revoc_date_time_beg;
			m_el->revoc_date_time_beg=0;
		}
	}
	if(m_chk_revoc_end){
		if(m_el->revoc_date_time_end==0){
			m_el->revoc_date_time_end=new COleDateTime();
		}
		m_revoc_date_end_ctrl.GetTime(odt_d);
		m_revoc_time_end_ctrl.GetTime(odt_t);
		m_el->revoc_date_time_end->SetDateTime(odt_d.GetYear(),odt_d.GetMonth(),odt_d.GetDay(),
			odt_t.GetHour(),odt_t.GetMinute(),odt_t.GetSecond());
		if(m_chk_revoc_beg){
			//					if(odt_e<odt_b){
			if(*(m_el->revoc_date_time_end)<*(m_el->revoc_date_time_beg)){
				AfxMessageBox( APL_T("          !!!"));
				return;
			}
		}
	}else{
		if(m_el->revoc_date_time_end!=0){
			delete m_el->revoc_date_time_end;
			m_el->revoc_date_time_end=0;
		}
	}
	CaplTranslateDialog::OnOK();
}

void CFindAdjustApprDlg::OnChk() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
//	m_person.EnableWindow(m_chk_person);
//	m_person.UpdateWindow();
//	m_person.SetReadOnly(!m_chk_person);
//	m_role_eq_ctrl.EnableWindow(m_chk_role);
//	if(!m_chk_date_beg)m_chk_date_end = FALSE;
	m_BtnSelPO.EnableWindow(m_chk_person);
	m_CtrlPO.EnableWindow(m_chk_person);
	m_CtrlDescr.EnableWindow(m_chk_descr);
	m_CmbxDescrRel.EnableWindow(m_chk_descr);
	m_po_role.EnableWindow(m_chk_role);
	m_status.EnableWindow(m_chk_status);
	m_dig_sign.EnableWindow(m_chk_dig_sign);
	m_date_beg_ctrl.EnableWindow(m_chk_date_beg);
	m_date_end_ctrl.EnableWindow(m_chk_date_end);
	m_type_date.EnableWindow(m_chk_date);
	MakeDateState();
	MakeRevoceState();
	UpdateData(FALSE);
}



void CFindAdjustApprDlg::OnSelchangeTypeDate() 
{
	// TODO: Add your control notification handler code here
	
	MakeDateState();
	UpdateData(FALSE);
}

void CFindAdjustApprDlg::OnSelchangeExistApproval() 
{
	// TODO: Add your control notification handler code here
	
}

void CFindAdjustApprDlg::OnSelPo() 
{
	// TODO: Add your control notification handler code here
	aplExtent ext;
	m_po=m_api->m_appr_mgr.SelectPersonOrOrganization
		(APL_MODE_SELECT_PERSON,ext, APL_T(" "), APL_T("   "));

	if(m_po!=0)
	{
		m_api->m_appr_mgr.GetPersonName(m_po,m_EdtPO);
	}else{
		m_EdtPO=_T("");
	}

	UpdateData(FALSE);
	
}
