// FindDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FindDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindDlg dialog

CFindDlg::CFindDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindDlg)
	m_id_str = _T("");
	m_name_str = _T("");
	m_id = TRUE;
	m_id_equ = FALSE;
	m_name = FALSE;
	m_FindType = -1;
	//}}AFX_DATA_INIT
	m_mode=_T("product");
}


void CFindDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindDlg)
	DDX_Control(pDX, IDC_FIND_TYPE, m_FindType_ctrl);
	DDX_Control(pDX, IDOK, m_btn_ok);
	DDX_Control(pDX, IDC_ID_EQU, m_id_equ_ctrl);
	DDX_Control(pDX, IDC_NAME, m_name_ctrl);
	DDX_Control(pDX, IDC_ID, m_id_ctrl);
	DDX_Control(pDX, IDC_ID_STR, m_id_str_ctrl);
	DDX_Control(pDX, IDC_NAME_STR, m_name_str_ctrl);
	DDX_Text(pDX, IDC_ID_STR, m_id_str);
	DDX_Text(pDX, IDC_NAME_STR, m_name_str);
	DDX_Check(pDX, IDC_ID, m_id);
	DDX_Check(pDX, IDC_ID_EQU, m_id_equ);
	DDX_Check(pDX, IDC_NAME, m_name);
	DDX_CBIndex(pDX, IDC_FIND_TYPE, m_FindType);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
}


BEGIN_MESSAGE_MAP(CFindDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindDlg)
	ON_BN_CLICKED(IDC_ID, OnId)
	ON_BN_CLICKED(IDC_NAME, OnName)
	ON_CBN_SELCHANGE(IDC_FIND_TYPE, OnSelchangeFindType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindDlg message handlers

void CFindDlg::OnId() 
{
	m_btn_ok.EnableWindow(TRUE);
	int i=m_id_ctrl.GetCheck();
	BOOL style=FALSE;
	if(i==1) style=TRUE;
	m_id_str_ctrl.EnableWindow(style);
	if(i==0)
	{
		int j=m_name_ctrl.GetCheck();
		if(j==0)m_btn_ok.EnableWindow(FALSE);
	}
}

void CFindDlg::OnName() 
{
	m_btn_ok.EnableWindow(TRUE);
	int i=m_name_ctrl.GetCheck();
	BOOL style=FALSE;
	if(i==1) style=TRUE;
	m_name_str_ctrl.EnableWindow(style);
	if(i==0)
	{
		int j=m_id_ctrl.GetCheck();
		if(j==0) m_btn_ok.EnableWindow(FALSE);
	}
}


BOOL CFindDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_btn_ok.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_btn_ok.SetFlat(FALSE);

	int nStrCount = 7;
	CString strs[] = { APL_T("")
		, APL_T("")
		, APL_T(" ")
		, APL_T(" ")
		, APL_T("-")
		, APL_T("")
		, APL_T(" ") };

	for(int i=0; i<nStrCount; ++i)
		m_FindType_ctrl.InsertString(i, strs[i]);

	OnId();
	OnName();
	if(m_mode==_T("product"))m_FindType_ctrl.SetCurSel(0);
	else if(m_mode==_T("document"))m_FindType_ctrl.SetCurSel(1);
	else if(m_mode==_T("lot"))m_FindType_ctrl.SetCurSel(2);
	else if(m_mode==_T("product_instance"))m_FindType_ctrl.SetCurSel(3);
	else if(m_mode==_T("bp"))m_FindType_ctrl.SetCurSel(4);
	else if(m_mode==_T("process"))m_FindType_ctrl.SetCurSel(5);
	else if(m_mode==_T("change"))m_FindType_ctrl.SetCurSel(6);
	else m_FindType_ctrl.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	bool bMsg=true;
	if(m_id==TRUE)
	{
		if(m_id_str==_T("") && m_id_equ==FALSE)
		{
			if(MessageBox( APL_T("         \n\n     ?"),
				0,MB_ICONQUESTION|MB_YESNO)!=IDYES) return;
			bMsg=false;
		}
	}
	if(bMsg)
	{
		if(m_name==TRUE)
		{
			if(m_name_str==_T(""))
			{
				if(MessageBox( APL_T("         \n\n     ?"),
					0,MB_ICONQUESTION|MB_YESNO)!=IDYES) return;
			}
		}
	}
	CaplTranslateDialog::OnOK();
}

void CFindDlg::OnSelchangeFindType() 
{
	// TODO: Add your control notification handler code here
	int i=m_FindType_ctrl.GetCurSel();
	switch(i)
	{
	case 0: // Product
		m_name_ctrl.SetWindowText( APL_T(""));
		m_name_ctrl.EnableWindow(TRUE);
		m_mode=_T("product");
		break;
	case 1: // Doc
		m_name_ctrl.SetWindowText( APL_T(""));
		m_name_ctrl.EnableWindow(TRUE);
		m_mode=_T("document");

		break;
	case 2: // Lot
		m_name_ctrl.EnableWindow(TRUE);
		m_name_ctrl.SetWindowText(_T(""));
		m_name_ctrl.SetCheck(0);
		OnName(); 
		m_name_ctrl.EnableWindow(FALSE);
		m_mode=_T("lot");
		break;
	case 3: // Product Inst
		m_name_ctrl.SetWindowText( APL_T(" :"));
		m_name_ctrl.EnableWindow(TRUE);
		m_mode=_T("product_instance");
		break;
	case 4: // bp
		m_name_ctrl.SetWindowText( APL_T(":"));
		m_name_ctrl.EnableWindow(TRUE);
		m_mode=_T("bp");
		break;
	case 5: // process
		m_name_ctrl.SetWindowText( APL_T(":"));
		m_name_ctrl.EnableWindow(TRUE);
		m_mode=_T("process");
		break;
	case 6: // change
		m_name_ctrl.SetWindowText( APL_T(":"));
		m_name_ctrl.EnableWindow(TRUE);
		m_mode=_T("change");
		break;	
	default:
		m_mode=_T("");
	}
}


///////////////////////////////////////////////////////////////////////
//    -   

bool CFindDlg::SaveDataToBuf(CaplDataBuf &dbuf){
	BYTE type;
	int length;
	dbuf.Clear();
	
	// 
	dbuf.Add(STD_HEADER_FIND_FIND_DLG,(_strlen(STD_HEADER_FIND_FIND_DLG)+1)*sizeof(TCHAR));
	//  
	length=(m_mode.GetLength()+1)*sizeof(TCHAR);
	if(length>250)length=250;
	type=(BYTE)length;
	dbuf.Add(&type,1);
	dbuf.Add(m_mode.GetBuffer(length),length);
	
	//m_id;
	type=(m_id==TRUE)?1:0;
	dbuf.Add(&type,1);

	if(m_id==TRUE){
		//m_id_str
		length=(m_id_str.GetLength()+1)*sizeof(TCHAR);
		if(length>250)length=250;
		type=(BYTE)length;
		dbuf.Add(&type,1);
		dbuf.Add(m_id_str.GetBuffer(length),length);
	}
	
	//m_name;
	type=(m_name==TRUE)?1:0;
	dbuf.Add(&type,1);

	if(m_name==TRUE){
		//m_name_str;
		length=(m_name_str.GetLength()+1)*sizeof(TCHAR);
		if(length>250)length=250;
		type=(BYTE)length;
		dbuf.Add(&type,1);
		dbuf.Add(m_name_str.GetBuffer(length),length);
	}
	//m_id_equ;
	type=(m_id_equ==TRUE)?1:0;
	dbuf.Add(&type,1);
	
	return true;
}

bool CFindDlg::LoadDataFromBuf(CaplDataBuf &dbuf)
{
	BYTE type;
	int k;
	TCHAR* cbuf;
	dbuf.Reset();
	// 
	k=_strlen(STD_HEADER_FIND_FIND_DLG)+1;
	cbuf=new TCHAR[k];
	dbuf.Read(cbuf,k*sizeof(TCHAR));
	if(CString(cbuf)!=STD_HEADER_FIND_FIND_DLG){
		delete cbuf;
		return false;
	}
	delete cbuf;
	//  

	dbuf.Read(&type,1);
	cbuf=new TCHAR[type];
	dbuf.Read(cbuf,type);
	m_mode=cbuf;
	delete cbuf;

	//m_id;
	dbuf.Read(&type,1);
	m_id=(type==1)?TRUE:FALSE;
	
	if(m_id==TRUE){
		//m_id_str
		dbuf.Read(&type,1);
		cbuf=new TCHAR[type];
		dbuf.Read(cbuf,type);
		m_id_str=cbuf;
		delete cbuf;
	}
	
	//m_name;
	dbuf.Read(&type,1);
	m_name=(type==1)?TRUE:FALSE;
	
	if(m_name==TRUE){
		//m_name_str;
		dbuf.Read(&type,1);
		cbuf=new TCHAR[type];
		dbuf.Read(cbuf,type);
		m_name_str=cbuf;
		delete cbuf;
	}
	//m_id_equ;
	dbuf.Read(&type,1);
	m_id_equ=(type==1)?TRUE:FALSE;

	return true;
}
