// FolderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "FolderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFolderDlg dialog


CFolderDlg::CFolderDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFolderDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFolderDlg)
	m_name = _T("");
	m_descr = _T("");
	//}}AFX_DATA_INIT
	bReadOnly=false;
	m_parent=0;
	m_data=0;
}


void CFolderDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFolderDlg)
	DDX_Control(pDX, IDC_ST_ICO, m_st_ico);
	DDX_Control(pDX, IDC_ST_NAME, m_st_name);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_NAME, m_name_ctrl);
	DDX_Control(pDX, IDC_DESCR, m_descr_ctrl);
	DDX_Text(pDX, IDC_NAME, m_name);
	DDX_Text(pDX, IDC_DESCR, m_descr);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFolderDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFolderDlg)
	ON_BN_CLICKED(IDC_ST_NAME, OnStName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFolderDlg message handlers

void CFolderDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	if(m_name==_T("")) 
	{
		AfxMessageBox( APL_T(" \"\"    !"),MB_OK|MB_ICONSTOP);
		return;
	}
	CaplTranslateDialog::OnOK();
}

BOOL CFolderDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);


	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(aplGetBitPerPixel(this)>8)
	{
		//if(!aplLoadMappedBitmap(m_name_bmp,IDB_FOLDER_NAME,RGB(0,0,0),GetSysColor(COLOR_BTNFACE),10))
		m_name_bmp.LoadMappedBitmap(IDB_FOLDER_NAME,0,&cm,1);
	}
	else
		m_name_bmp.LoadMappedBitmap(IDB_FOLDER_NAME_16,0,&cm,1);

	if(aplGetBitPerPixel(this)>8)
	{
		//if(!aplLoadMappedBitmap(m_ico_bmp,IDB_FOLD_ICO,RGB(0,0,0),GetSysColor(COLOR_BTNFACE),0))
		m_ico_bmp.LoadMappedBitmap(IDB_FOLD_ICO,0,&cm,1);
	}
	else
		m_ico_bmp.LoadMappedBitmap(IDB_FOLD_ICO_16,0,&cm,1);

	HBITMAP hBmpOld=m_st_name.SetBitmap(HBITMAP(m_name_bmp));	
	::DeleteObject(hBmpOld);

	hBmpOld=m_st_ico.SetBitmap(HBITMAP(m_ico_bmp));	
	::DeleteObject(hBmpOld);

	if(bReadOnly)
	{
		m_descr_ctrl.SetReadOnly(TRUE);
		m_name_ctrl.SetReadOnly(TRUE);
		m_ok_btn.EnableWindow(FALSE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFolderDlg::OnStName() 
{
	// TODO: Add your control notification handler code here
	CString text,buf;
//	if(((GetKeyState(VK_LMENU) & 0xff00)!=0)&&((GetKeyState(VK_RMENU) & 0xff00)!=0)){
	if(((GetKeyState(VK_LMENU) )!=0)&&((GetKeyState(VK_RMENU) )!=0)){
		text.Format(_T("\n"));
		if(m_folder!=0){buf.Format(_T("m_folder->id %i;\n"),m_folder->GetId());text+=buf;}else{buf.Format(_T("m_folder==0;\n"));}
		if(m_parent!=0){buf.Format(_T("m_parent->id %i;\n"),m_parent->GetId());text+=buf;}else{buf.Format(_T("m_parent==0;\n"));}
		AfxMessageBox(text);
	}
}

BOOL CFolderDlg::DestroyWindow() 
{
	m_name_bmp.DeleteObject();
	m_ico_bmp.DeleteObject();
	
	return CaplTranslateDialog::DestroyWindow();
}
