// ListEff.cpp : implementation file
//

#include "stdafx.h"
#include "ListEff.h"
#include "ManagerEffectivityDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/////////////////////////////////////////////////////////////////////////////
// ListEff


ListEff::ListEff()
{
	m_list1=0;
	is_sender=false;
	isMouseDown=false;
	prevPos=0;
	size.cy=0;
	size.cx=0;
	maindlg=0;
}

BEGIN_MESSAGE_MAP(ListEff, CListCtrl)
	//{{AFX_MSG_MAP(ListEff)
	ON_WM_VSCROLL()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONUP()
	ON_WM_NCMOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ListEff message handlers

#if _MSC_VER >= 1400
void ListEff::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
#else
void ListEff::OnVScroll(UINT nSBCode, int nPos, CScrollBar* pScrollBar) 
#endif
{	
	//    
	if(nSBCode==SB_THUMBTRACK)
	{
		if(m_list1!=0)
		{	
			int temp=nPos;
			nPos=nPos-prevPos;
			CRect rect;
			CListCtrl::GetItemRect(1,&rect,LVIR_BOUNDS);
			size.cx=0;
			size.cy=nPos*(rect.bottom-rect.top);
			m_list1->Scroll(size);
			CListCtrl::Scroll(size);
			prevPos=temp;
		}
	}
	//      ""/""
	else
	{
		if(m_list1!=0)
			if(!is_sender)
			{
				is_sender=true;
				m_list1->OnVScroll(nSBCode, nPos, /*m_list1->GetScrollBarCtrl(SB_VERT)*/NULL);
				CListCtrl::OnVScroll(nSBCode, nPos,/* pScrollBar*/NULL);
				is_sender=false;
			}
	}
}

BOOL ListEff::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{//      
	switch (((NMHDR*)lParam)->code)
    {
		case HDN_ENDTRACKW:
		case HDN_ENDTRACKA:maindlg->RedrawWindow();
	}
	return CListCtrl::OnNotify(wParam, lParam, pResult);
}

void ListEff::OnLButtonUp(UINT nFlags, CPoint point) 
{
	isMouseDown=false;
	const MSG* msg = GetCurrentMessage();
	//       
	if(msg->hwnd==maindlg->m_prHwnd)
	{ 
		POSITION pos;
		pos=GetFirstSelectedItemPosition();
		//m_numRow -   
		maindlg->m_numRow=GetNextSelectedItem(pos);
		m_list1->RedrawWindow();
		return;
	}
	//       
	//  
	SetItemState(-1,0, LVIS_SELECTED);
	CListCtrl::OnLButtonUp(nFlags, point);
}

void ListEff::OnRButtonUp(UINT nFlags, CPoint point) 
{
	isMouseDown=false;
	const MSG* msg = GetCurrentMessage();
	//       
	if(msg->hwnd==maindlg->m_prHwnd)
	{ 
		POSITION pos;
		pos=GetFirstSelectedItemPosition();
		//m_numRow -   
		maindlg->m_numRow=GetNextSelectedItem(pos);
		m_list1->RedrawWindow();
		return;
	}
	//       
	//  
	SetItemState(-1,0, LVIS_SELECTED);
	CListCtrl::OnRButtonUp(nFlags, point);
}

void ListEff::OnNcMouseMove(UINT nHitTest, CPoint point) 
{//       
 //     
	const MSG* msg = GetCurrentMessage();
	if(isMouseDown==true)
	{
		//     
		EnsureVisible(GetTopIndex(),false);
		EnsureVisible((GetCountPerPage()+GetTopIndex()-1),false);
		isMouseDown=false;
		//       
		if(msg->hwnd==maindlg->m_prHwnd)
		{ 
			POSITION pos;
			pos=GetFirstSelectedItemPosition();
			//m_numRow -   
			maindlg->m_numRow=GetNextSelectedItem(pos);
			m_list1->RedrawWindow();
			return;
		}
		//       
		//  
	}
	if(msg->hwnd==maindlg->m_efHwnd)
	{ 
		SetItemState(-1,0, LVIS_SELECTED);
	}
}

void ListEff::OnLButtonDown(UINT nFlags, CPoint point) 
{	//isMouseDown-,      
	isMouseDown=true;
	CListCtrl::OnLButtonDown(nFlags, point);
}

void ListEff::OnRButtonDown(UINT nFlags, CPoint point) 
{
	isMouseDown=true;	
	CListCtrl::OnRButtonDown(nFlags, point);
}

void ListEff::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

}
