// OfficialHistDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OfficialHistDlg.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COfficialHistDlg dialog


COfficialHistDlg::COfficialHistDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(COfficialHistDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COfficialHistDlg)
	//}}AFX_DATA_INIT
	
	m_hist_type =	0; // OWNER TYPE 
	m_pInstance = NULL;
	m_list_obj.SetUniqueName(_T("Official_history_dlg"));
}


void COfficialHistDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COfficialHistDlg)
	DDX_Control(pDX, IDCANCEL, m_btn_cancel);
	DDX_Control(pDX, IDOK, m_btn_ok);
	DDX_Control(pDX, IDC_LIST_STATIC, m_list_static);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COfficialHistDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(COfficialHistDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COfficialHistDlg message handlers

BOOL COfficialHistDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	e_off_hist = m_auth_mgr->e_official_hist; //GetEntityBN(_T("apl_official_history"));
	a_hist_person = m_auth_mgr->a_off_hist_person; //GetAttrDefinition(e_off_hist,_T("person"));
	a_hist_date = m_auth_mgr->a_off_hist_date; //GetAttrDefinition(e_off_hist,_T("date"));
	a_hist_user = m_auth_mgr->a_off_hist_user; //GetAttrDefinition(e_off_hist,_T("user"));
	a_hist_descr = m_auth_mgr->a_off_hist_descr; //GetAttrDefinition(e_off_hist,_T("description"));	

	m_btn_cancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_btn_cancel.SetFlat(FALSE);
	m_btn_ok.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_btn_ok.SetFlat(FALSE);
	
	RECT rect={5,5,10,10};
	
	m_list_obj.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SORTASCENDING,rect,this,IDC_OFFICIAL_HIST_LIST);
	m_list_static.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_list_obj.MoveWindow(&rect);

	//m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	//m_list_obj.SetImageList(&m_imageList, LVSIL_SMALL);
	m_list_obj.SetImageList(aplGetInstImageList(), LVSIL_SMALL);

//	DWORD style = m_list_obj.GetExtendedStyle();
//	m_list_obj.SetExtendedStyle(style | LVS_EX_INFOTIP);
	//  CSortListCtrl      "...",    
	m_list_obj.DeleteAllColumns();

	m_list_obj.InsertColumn(0, APL_T(""),LVCFMT_LEFT,100);
	m_list_obj.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,100);
	m_list_obj.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	m_list_obj.InsertColumn(3, APL_T(""),LVCFMT_LEFT,100);

	m_list_obj.LoadColumnWidths();

//	m_list_obj.CListCtrl::SetColumnWidth(0,250);

	switch (m_hist_type)
	{
	case 0 : SetWindowText( APL_T("  ")); break;

	case 1 : SetWindowText( APL_T("  ")); break;
	}


	FillList();
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COfficialHistDlg::FillList()
{
	int i,j;
	CaplInstance * inst;
	CString str;
	aplExtent ext0;
	COleDateTime odt;

	switch (m_hist_type)
	{
	case 0 : m_data->GetAttrBN(m_pInstance,_T("owner_history"),ext0); break;

	case 1 : m_data->GetAttrBN(m_pInstance,_T("actual_person_history"),ext0); break;
	}

	for(i=0; i < ext0.GetSize(); i++)
	{
		m_data->GetAttr(ext0[i],a_hist_person,inst);

		m_auth_mgr->GetPersonName(inst,str);
		j = m_list_obj.InsertItem(i, str, ICON_PERSON);

		m_list_obj.SetItemData(j,(DWORD)ext0[i]);
		
		m_data->GetAttr(ext0[i],a_hist_date,str);
		
		aplString2Date(str,odt);

		m_list_obj.SetItemText(j,1,odt.Format(_T("%d.%m.%Y  %H:%M:%S")));

		m_data->GetAttr(ext0[i],a_hist_user,str);

		m_list_obj.SetItemText(j,2,str);

		m_data->GetAttr(ext0[i],a_hist_descr,str);

		m_list_obj.SetItemText(j,3,str);
	}
	
}
