// Options4AutoAccess.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "Options4AutoAccess.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptions4AutoAccess dialog


COptions4AutoAccess::COptions4AutoAccess(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(COptions4AutoAccess::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptions4AutoAccess)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api=0;
	m_is_edited_opt=0;
}


void COptions4AutoAccess::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptions4AutoAccess)
	DDX_Control(pDX, IDC_COMBO_PROP, m_CmbProp);
	DDX_Control(pDX, IDC_WFSH_LIST, m_OptionsList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptions4AutoAccess, CaplResizableDialog)
	//{{AFX_MSG_MAP(COptions4AutoAccess)
	ON_NOTIFY(NM_DBLCLK, IDC_WFSH_LIST, OnDblclkWfshList)
	ON_NOTIFY(NM_RCLICK, IDC_WFSH_LIST, OnRclickWfshList)
	ON_NOTIFY(NM_CLICK, IDC_WFSH_LIST, OnClickWfshList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptions4AutoAccess message handlers

BOOL COptions4AutoAccess::OnInitDialog() 
{
	if(m_api==0){
		return FALSE;
	}
	CaplResizableDialog::OnInitDialog();

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	SetWindowText( APL_T("   "));

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_CmbProp.ResetContent();
	m_CmbProp.AddString(APL_T(""));
	m_CmbProp.AddString(APL_T(""));

	m_CmbProp.SetParent(&m_OptionsList);
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDC_WFSH_LIST,TOP_LEFT,BOTTOM_RIGHT);
	
	// TODO: Add extra initialization here
	CRect rect;
	m_OptionsList.GetClientRect(&rect);
	m_OptionsList.InsertColumn(0, APL_T(" "),LVCFMT_LEFT,rect.Width()*7/10);
	m_OptionsList.InsertColumn(1, APL_T(" "),LVCFMT_CENTER,rect.Width()*3/10);
	

	//  , 
	//    
	
	m_api->m_options_mgr.InitDefaultOptions();

	FeelTable();

	int i;
	aplExtent AccessPatterns;
	CString name;
	m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_apl_acc_pat,AccessPatterns);
	for(i=0;i<AccessPatterns.GetSize();i++){
		m_api->m_data.GetAttr(AccessPatterns[i],m_api->m_appr_mgr.a_apl_acc_pat_name,name);
		m_AccessPatternsMap.Add(name,(long)AccessPatterns[i]);
	}

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

bool COptions4AutoAccess::FeelTable()
{
	int i,pos,ival;
	CString opt_name,opt_val;
	CaplInstance* inst;


	m_OptionsList.DeleteAllItems();

	for(i=0;i<m_api->m_options_mgr.m_params.GetSize();i++){
		opt_name=m_api->m_options_mgr.m_params.GetAt(i)->str;
		if(opt_name.Find( APL_NO_T("   "),0)!=-1){
			inst=(CaplInstance*)m_api->m_options_mgr.m_params.GetAt(i)->val;
			pos=m_OptionsList.InsertItem(i,CaplTranslate::Translate(opt_name));
			m_OptionsList.SetItemData(pos,(DWORD)inst);
			if(opt_name.CompareNoCase( APL_NO_T("   "))==0){
				m_api->m_data.GetAttr(inst,m_api->m_options_mgr.a_int_value,ival);
				if(ival==1){opt_val= APL_NO_T("");}else{opt_val= APL_NO_T("");};
			}else{
				m_api->m_data.GetAttr(inst,m_api->m_options_mgr.a_str_value,opt_val);
			}
			m_OptionsList.SetItemText(pos,1,CaplTranslate::Translate(opt_val));
		}
	}
	

	return true;
}

void COptions4AutoAccess::OnDblclkWfshList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
//	CaplInstance *pattern;
	CaplInstance *val;
	CaplInstance *curr_pat,*new_pat;
	CString opt_name,opt_val;
	CRect rect,rectc;
	BOOL res=true;
	int ival;
	
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	*pResult = 0;
	
	TestEdited();
	if(lpnmitem==0) return;
	
	int k=lpnmitem->iItem;
	if(k<0||k>m_OptionsList.GetItemCount()-1) return;
	val=(CaplInstance*)m_OptionsList.GetItemData(k);
	if(val==0) return;
//	m_api->m_data.GetAttr(val,m_api->m_options_mgr.a_str_name,opt_name);
	if(m_api->m_data.IsKindOf(val,m_api->m_options_mgr.e_int)){
		m_api->m_data.GetAttr(val,m_api->m_options_mgr.a_int_name,opt_name);
		if(opt_name.CompareNoCase( APL_NO_T("   "))==0){
			m_OptionsList.GetItemRect(k,rect,LVIR_BOUNDS);
			m_OptionsList.GetClientRect(&rectc);
			if(rectc.right<rect.right)rect.right=rectc.right;
			int col1size=m_OptionsList.GetColumnWidth(0);
			rect.left+=col1size;
			
			m_api->m_data.GetAttr(val,m_api->m_options_mgr.a_int_value,ival);
			if(ival==1){m_CmbProp.SetCurSel(1);}else{m_CmbProp.SetCurSel(0);};
			
			//res=m_CmbProp.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),
			res=m_CmbProp.SetWindowPos(&wndTop,rect.left,rect.top-3,rect.Width(),rect.Height(),
				SWP_SHOWWINDOW|SWP_NOCOPYBITS);
			m_is_edited_opt=val;
		}		


	}else{
		m_api->m_data.GetAttr(val,m_api->m_options_mgr.a_str_value,opt_val);
		curr_pat=(CaplInstance*)m_AccessPatternsMap.Get(opt_val);
		new_pat=SelectAccessPattern(m_api,curr_pat);
		if(new_pat!=curr_pat)
		{
			if(new_pat!=0){
				m_api->m_data.GetAttr(new_pat,m_api->m_appr_mgr.a_apl_acc_pat_name,opt_val);
			}else{
				opt_val=_T("");
			}
			m_api->m_data.PutAttr(val,m_api->m_options_mgr.a_str_value,opt_val);
			FeelTable();
		}
	}
}

void COptions4AutoAccess::TestEdited()
{
	int ival;
	if(m_is_edited_opt!=0){
		ival=m_CmbProp.GetCurSel();
		m_api->m_data.PutAttr(m_is_edited_opt,m_api->m_options_mgr.a_int_value,ival);
		m_CmbProp.ShowWindow(SW_HIDE);
		m_is_edited_opt=0;
		FeelTable();
	}
}

void COptions4AutoAccess::OnOK() 
{
	// TODO: Add extra validation here
	TestEdited();

	
	CaplResizableDialog::OnOK();
}

void COptions4AutoAccess::OnClickWfshList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	TestEdited();
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
//	SetCurrList(pNMListView->ptAction);
	
	*pResult = 0;
}

void COptions4AutoAccess::OnRclickWfshList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	TestEdited();
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
//	ContextMenuProcessed( pNMListView->ptAction);
	*pResult = 0;
}

