// PrdInstDlg.cpp : implementation file
//

#include "stdafx.h"
#include "aplLotDlg.h"
#include "dictionary.h"
#include "SelectInstDlg.h"
#include "apl_api.h"
#include "PrdInstDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrdInstDlg dialog


CPrdInstDlg::CPrdInstDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CPrdInstDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrdInstDlg)
	m_id = _T("");
	m_sn = _T("");
	m_prd_id = _T("");
	m_descr = _T("");
	m_rel_descr = _T("");
	m_rel_id = _T("");
	m_rel_name = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_pdf=0; m_inst=0; m_lot=0;
	m_base_inst=0;
	bTestPdfInLot=false;
	m_inst_rel=0; m_par_inst=0;
	m_context_changed=false;
	m_customer=0;
}


void CPrdInstDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrdInstDlg)
	DDX_Control(pDX, IDC_STATES, m_states_ctrl);
	DDX_Control(pDX, IDC_REL_PROPERTY, m_rel_prop_btn);
	DDX_Control(pDX, IDC_SEL_CONTEXT, m_sel_context_btn);
	DDX_Control(pDX, IDC_NAMES_CONTEXTS, m_rel_context);
	DDX_Control(pDX, IDC_ST_CONTEXTS, m_st_5);
	DDX_Control(pDX, IDC_REL_DESCR, m_rel_descr_ctrl);
	DDX_Control(pDX, IDC_REL_NAME, m_rel_name_ctrl);
	DDX_Control(pDX, IDC_REL_ID, m_rel_id_ctrl);
	DDX_Control(pDX, IDC_STATIC_R4, m_st_4);
	DDX_Control(pDX, IDC_STATIC_R3, m_st_3);
	DDX_Control(pDX, IDC_STATIC_R2, m_st_2);
	DDX_Control(pDX, IDC_STATIC_R1, m_st_1);
	DDX_Control(pDX, IDC_STATIC_R0, m_st_0);
	DDX_Control(pDX, IDC_TIME_REM, m_time_rem_ctrl);
	DDX_Control(pDX, IDC_TIME_INST, m_time_inst_ctrl);
	DDX_Control(pDX, IDC_HAS_REMOVED, m_date_has_removed_ctrl);
	DDX_Control(pDX, IDC_DATE_REM, m_date_rem_ctrl);
	DDX_Control(pDX, IDC_DATE_INST, m_date_inst_ctrl);
	DDX_Control(pDX, IDC_LOT, m_lot_ctrl);
	DDX_Control(pDX, IDC_DESCR, m_descr_ctrl);
	DDX_Control(pDX, IDC_SN, m_sn_ctrl);
	DDX_Control(pDX, IDC_ID, m_id_ctrl);
	DDX_Control(pDX, IDC_PDF_DEL, m_pdf_del_btn);
	DDX_Control(pDX, IDC_PDF_BROWSE, m_pdf_browse_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_PRD_ID, m_prd_id_ctrl);
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	DDX_Control(pDX, IDC_B_PROPS_PROPS, m_bPropsProps);
	DDX_Control(pDX, IDC_B_PROPS_DEL, m_bPropsDel);
	DDX_Control(pDX, IDC_B_PROPS_ADD, m_bPropsAdd);
	DDX_Text(pDX, IDC_ID, m_id);
	DDX_Text(pDX, IDC_SN, m_sn);
	DDX_Text(pDX, IDC_PRD_ID, m_prd_id);
	DDX_Text(pDX, IDC_DESCR, m_descr);
	DDX_Text(pDX, IDC_REL_DESCR, m_rel_descr);
	DDX_Text(pDX, IDC_REL_ID, m_rel_id);
	DDX_Text(pDX, IDC_REL_NAME, m_rel_name);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_DATE_MANUFACT, m_date_manuf_ctrl);
	DDX_Control(pDX, IDC_DATE_SHIPMENT, m_date_shipment_ctrl);
	DDX_Control(pDX, IDC_CUSTOMER, m_customer_ctrl);
	DDX_Control(pDX, IDC_SEL_CUSTOMER, m_customer_sel_btn);
	DDX_Control(pDX, IDC_DEL_CUSTOMER, m_customer_del_btn);
	DDX_Control(pDX, IDC_ST_SHIPMENT, m_st_date_shipment_ctrl);
}


BEGIN_MESSAGE_MAP(CPrdInstDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CPrdInstDlg)
	ON_BN_CLICKED(IDC_PDF_BROWSE, OnPdfBrowse)
	ON_BN_CLICKED(IDC_PDF_DEL, OnPdfDel)
	ON_BN_CLICKED(IDC_HAS_REMOVED, OnHasRemoved)
	ON_BN_CLICKED(IDC_SEL_CONTEXT, OnSelContext)
	ON_BN_CLICKED(IDC_REL_PROPERTY, OnRelProperty)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_BN_CLICKED(IDC_B_PROPS_ADD, OnBPropsAdd)
	ON_BN_CLICKED(IDC_B_PROPS_DEL, OnBPropsDel)
	ON_BN_CLICKED(IDC_B_PROPS_PROPS, OnBPropsProps)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_DEL_CUSTOMER, &CPrdInstDlg::OnBnClickedDelCustomer)
	ON_BN_CLICKED(IDC_SEL_CUSTOMER, &CPrdInstDlg::OnBnClickedSelCustomer)
END_MESSAGE_MAP()

BOOL CPrdInstDlg::SetAnchors(void)
{
	AddAnchor(IDC_B_PROPS_ADD,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_DEL,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_PROPS,TOP_RIGHT);

	AddAnchor(IDC_PDF_BROWSE,TOP_RIGHT);
	AddAnchor(IDC_PDF_DEL,TOP_RIGHT);
	AddAnchor(IDC_PRD_ID,TOP_LEFT,TOP_RIGHT);	
	AddAnchor(IDC_T_BV_ID,TOP_LEFT);

	AddAnchor(IDC_TAB1,TOP_LEFT,BOTTOM_RIGHT);


	AddAnchor(IDC_T_ID,TOP_LEFT);
	AddAnchor(IDC_ID,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_T_SN,TOP_LEFT);
	AddAnchor(IDC_SN,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_T_DESCR,TOP_LEFT);
	AddAnchor(IDC_DESCR,TOP_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDC_T_LOT,BOTTOM_LEFT);
	AddAnchor(IDC_LOT,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_T_STATE,BOTTOM_LEFT);
	AddAnchor(IDC_STATES,BOTTOM_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDC_STATIC_R0,BOTTOM_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_STATIC_R1,BOTTOM_LEFT);
		AddAnchor(IDC_REL_ID,BOTTOM_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_STATIC_R2,BOTTOM_LEFT);
		AddAnchor(IDC_REL_NAME,BOTTOM_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_STATIC_R3,BOTTOM_LEFT);
		AddAnchor(IDC_REL_DESCR,BOTTOM_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_ST_CONTEXTS,BOTTOM_LEFT);
		AddAnchor(IDC_NAMES_CONTEXTS,BOTTOM_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_SEL_CONTEXT,BOTTOM_RIGHT);
		AddAnchor(IDC_REL_PROPERTY,BOTTOM_RIGHT);
		AddAnchor(IDC_STATIC_R4,BOTTOM_LEFT);
		AddAnchor(IDC_DATE_INST,BOTTOM_LEFT);
		AddAnchor(IDC_TIME_INST,BOTTOM_LEFT);
		AddAnchor(IDC_HAS_REMOVED,BOTTOM_RIGHT);
		AddAnchor(IDC_DATE_REM,BOTTOM_RIGHT);
		AddAnchor(IDC_TIME_REM,BOTTOM_RIGHT);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);

	return TRUE;
}

void CPrdInstDlg::SetSize(int cy)
{
	CRect rt;
	CSize sz;

	GetWindowRect(rt);
	sz.cx=rt.right-rt.left;
	sz.cy=rt.bottom-rt.top-cy;
	SetMinTrackSize(sz);

	m_Tab.GetWindowRect(rt);
	ScreenToClient(rt);
	rt.bottom-=cy;
	m_Tab.MoveWindow(rt);
}

BOOL CPrdInstDlg::InitViews(void)
{
	CaplCharactView*	pCharView	=NULL;
	CaplApprovalView*	pApprView	=NULL;
	CaplDocsView*		pDocsView	=NULL;
	CaplAccessView*		pAccView	=NULL;

	CWnd*				pWnd		=NULL;

	CArray<int,int>		caExcludes;

	CRect				rt;

	DWORD				dwStyles=WS_CHILD|WS_BORDER;

	CaplInstance*		cit			=m_inst;

	m_Tab.SetImageList(aplGetTabCtrlImageList());

	m_Tab.InsertItem(0, APL_T(""),0);
	m_Tab.AddTab(0,NULL);
	m_Tab.SetCurSel(0);

	caExcludes.Add(IDC_B_PROPS_ADD);
	caExcludes.Add(IDC_B_PROPS_DEL);
	caExcludes.Add(IDC_B_PROPS_PROPS);
	m_Tab.AddExcludeIDs(caExcludes);

	//pWnd=GetDlgItem(IDC_T_VIEW_FRAME);
	//pWnd->GetClientRect(rt);
	//pWnd->ClientToScreen(rt);
	m_Tab.GetWindowRect(rt);
	rt.DeflateRect(8,65,8,8);
	ScreenToClient(rt);

	if(NULL!=m_inst)
	{
		m_Tab.InsertItem(1, APL_T(""),1);
		pCharView=(CaplCharactView*)(RUNTIME_CLASS(CaplCharactView)->CreateObject());
		pCharView->Create(NULL,NULL,dwStyles,rt,this,0);
		pCharView->m_inst=cit;
		pCharView->m_api=m_api;

		pCharView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pCharView->OnInitialUpdate();
		m_Tab.AddTab(1,pCharView);
		AddAnchor(pCharView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(2, APL_T(""),2);
		pDocsView=(CaplDocsView*)(RUNTIME_CLASS(CaplDocsView)->CreateObject());
		pDocsView->Create(NULL,NULL,dwStyles,rt,this,0);
		pDocsView->m_inst=cit;
		pDocsView->m_api=m_api;

		pDocsView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pDocsView->OnInitialUpdate();
		m_Tab.AddTab(2,pDocsView);
		AddAnchor(pDocsView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(3, APL_T(" "),3);
		pApprView=(CaplApprovalView*)(RUNTIME_CLASS(CaplApprovalView)->CreateObject());
		pApprView->Create(NULL,NULL,dwStyles,rt,this,0);
		pApprView->m_inst=cit;
		pApprView->m_api=m_api;

		pApprView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pApprView->OnInitialUpdate();
		m_Tab.AddTab(3,pApprView);
		AddAnchor(pApprView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);
	}

	if(NULL!=m_base_inst)
	{
		if(NULL==m_inst)
			m_Tab.InsertItem(1, APL_T(""),17);
		else
			m_Tab.InsertItem(4, APL_T(""),17);
		
		pAccView=(CaplAccessView*)(RUNTIME_CLASS(CaplAccessView)->CreateObject());
		pAccView->Create(NULL,NULL,dwStyles|LVS_NOSORTHEADER,rt,this,0);
		pAccView->m_inst=cit;
		pAccView->m_api=m_api;
		
		pAccView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pAccView->OnInitialUpdate();
		if(NULL==m_inst)
		{
			m_Tab.AddTab(1,pAccView);
			
			CString	csAccPatName;
			
			CaplEntity* et=NULL;
			
			et=m_api->m_prd_inst_mgr.e_prd_inst;
			if(true==m_api->m_prd_inst_mgr.m_AutoUsurpire)
				if(TRUE==m_api->m_options_mgr.GetDefTmplName(et,csAccPatName))
					pAccView->SetDefaultTemplate(csAccPatName);
		}
		else
			m_Tab.AddTab(4,pAccView);
		AddAnchor(pAccView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);
	}


	return TRUE;
}

void CPrdInstDlg::ChangeViewBtnsState(BOOL bDis,BOOL bHide)
{
	CWnd*	pwnd	=NULL;

	int		iIDs[]={IDC_B_PROPS_ADD,IDC_B_PROPS_DEL,IDC_B_PROPS_PROPS};
	int		iShow=SW_SHOW;
	int		i;

	if(TRUE==bHide)
		iShow=SW_HIDE;	

	for(i=0;i<sizeof(iIDs)/sizeof(int);i++)
	{
		pwnd=GetDlgItem(iIDs[i]);
		pwnd->EnableWindow(bDis);
		pwnd->ShowWindow(iShow);
	}
}

void CPrdInstDlg::GetAccessString(void)
{
	CaplAccessView*	pAccView	=NULL;

	CWnd*			pwnd		=NULL;

	int				i;
	
	for(i=0;i<m_Tab.GetItemCount();i++)
	{
		m_Tab.GetTabView(i,pwnd);
		if(pwnd!=NULL)
			if(pwnd->IsKindOf(RUNTIME_CLASS(CaplAccessView)))
			{
				pAccView=(CaplAccessView*)pwnd;
				pAccView->GetAccessString(m_csAccessString);
			}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CPrdInstDlg message handlers

void CPrdInstDlg::OnPdfBrowse() 
{
	// TODO: Add your control notification handler code here
	CaplInstance *pdf=m_api->m_prd_inst_mgr.SelectInstance(APL_MODE_SELECT_PDF);
	if(pdf==0) return;
	if(pdf!=m_pdf)
	{
		CString buf;
		m_api->GetItemName(pdf,buf);
		m_prd_id_ctrl.SetWindowText(buf);
		m_pdf=pdf;
		UpdateLotInfo();
	}
}

void CPrdInstDlg::OnPdfDel() 
{
	m_prd_id_ctrl.SetWindowText(_T(""));
	m_pdf=0;
}
//**********************************************************************
BOOL CPrdInstDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	m_states_ctrl.ResetContent();

	m_states_ctrl.InsertString(0,APL_T(""));
	m_states_ctrl.InsertString(1,APL_T(" "));
	m_states_ctrl.InsertString(2,APL_T(" "));
	m_states_ctrl.InsertString(3,APL_T(" "));
	m_states_ctrl.InsertString(4,APL_T(" "));
	m_states_ctrl.InsertString(5,APL_T(" "));
	m_states_ctrl.InsertString(6,APL_T(""));

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	//m_customer_sel_btn.SetIcon(GetAplTableIco(APL_TABLE_EDIT));
	m_customer_sel_btn.SetFlat(FALSE);
	m_customer_del_btn.SetIcon(GetAplStdIco16(APLSTDICO_DELETE));
	m_customer_del_btn.SetFlat(FALSE);

	m_pdf_browse_btn.SetFlat(FALSE);
	m_pdf_del_btn.SetFlat(FALSE);
	m_pdf_del_btn.SetIcon(GetAplStdIco16(APLSTDICO_DELETE));

	if(0==m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer)
	{
		m_customer_sel_btn.ShowWindow(SW_HIDE);
		m_customer_del_btn.ShowWindow(SW_HIDE);
	}
	
	if(0==m_api->m_prd_inst_mgr.a_prd_inst_vniis_shipment_date)
	{
		m_date_shipment_ctrl.ShowWindow(SW_HIDE);
		m_st_date_shipment_ctrl.ShowWindow(SW_HIDE);
	}


	COleDateTime dt=COleDateTime::GetCurrentTime();
	m_time_inst_ctrl.SetTime(dt);
	m_date_inst_ctrl.SetTime(dt);
	m_date_has_removed_ctrl.SetCheck(0);
	m_time_rem_ctrl.EnableWindow(FALSE);
	m_date_rem_ctrl.EnableWindow(FALSE);

	m_bPropsAdd.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_bPropsAdd.SetFlat(FALSE);
	m_bPropsDel.SetIcon(GetAplStdIco16(APLSTDICO_MINUS));
	m_bPropsDel.SetFlat(FALSE);
	m_bPropsProps.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_bPropsProps.SetFlat(FALSE);


	{	//  Tab-   
		CRect rectTab,rectCancel;
		m_Tab.GetWindowRect(rectTab);
		m_cancel_btn.GetWindowRect(rectCancel);
		rectTab.bottom=rectCancel.top-5;
		rectTab.right=rectCancel.right;
		ScreenToClient(rectTab);
		m_Tab.MoveWindow(rectTab);
	}

	InitViews();
	
	CaplInstance *inst_unit=0;
	CString buf;

	if(m_base_inst!=0)
	{
		apidata.GetAttrBN(m_base_inst,S::id,m_id);
		apidata.GetAttrBN(m_base_inst,S::description,m_descr);
		apidata.GetAttrBN(m_base_inst,_T("serial_number"),m_sn);

		COleDateTime odt;
		CString s_dt;
		apidata.GetAttrBN(m_base_inst,_T("date_time"),s_dt);
		if(s_dt==_T("")) odt.SetStatus(COleDateTime::null);
		else aplString2Date(s_dt,odt);
		m_date_manuf_ctrl.SetTime(odt);

		if(m_pdf==0)
			apidata.GetAttrBN(m_base_inst,S::formation,m_pdf);
		if(m_lot==0)
			apidata.GetAttrBN(m_base_inst,_T("lot"),m_lot);
		CString state=_T("");
		apidata.GetAttrBN(m_base_inst,_T("state"),state);
		m_states_ctrl.SelectString(-1,state);

	}
	else if(m_inst!=0)
	{
		apidata.GetAttrBN(m_inst,S::id,m_id);
		apidata.GetAttrBN(m_inst,S::description,m_descr);
		apidata.GetAttrBN(m_inst,_T("serial_number"),m_sn);

		COleDateTime odt;
		CString s_dt;
		apidata.GetAttrBN(m_inst,_T("date_time"),s_dt);
		if(s_dt==_T("")) odt.SetStatus(COleDateTime::null);
		else aplString2Date(s_dt,odt);
		m_date_manuf_ctrl.SetTime(odt);

		if(0!=m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer)
		{
			apidata.GetAttr(m_inst,m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer,m_customer);
			if(0!=m_customer)
			{
				m_api->m_appr_mgr.GetItemName(m_customer,buf);
				m_customer_ctrl.SetWindowText(buf);
			}
		}
		if(0!=m_api->m_prd_inst_mgr.a_prd_inst_vniis_shipment_date)
		{
			COleDateTime odt;
			apidata.GetAttr(m_inst,m_api->m_prd_inst_mgr.a_prd_inst_vniis_shipment_date,buf);
			if(buf==_T("")) odt.SetStatus(COleDateTime::null);
			else aplString2Date(buf,odt);
			m_date_shipment_ctrl.SetTime(odt);
		}

		if(m_pdf==0)
			apidata.GetAttrBN(m_inst,S::formation,m_pdf);
		if(m_lot==0)
			apidata.GetAttrBN(m_inst,_T("lot"),m_lot);
		CString state=_T("");
		apidata.GetAttrBN(m_inst,_T("state"),state);
		m_states_ctrl.SelectString(-1,state);
		if(m_inst->GetAccessmode()>aplRW)
		{
			m_id_ctrl.SetReadOnly(TRUE);
			m_sn_ctrl.SetReadOnly(TRUE);
			m_date_manuf_ctrl.EnableWindow(FALSE);
			m_date_shipment_ctrl.EnableWindow(FALSE);
			m_descr_ctrl.SetReadOnly(TRUE);
			m_pdf_browse_btn.EnableWindow(FALSE);
			m_sel_context_btn.EnableWindow(FALSE);
			m_pdf_del_btn.EnableWindow(FALSE);
			m_ok_btn.EnableWindow(FALSE);

			RECT r1,r2;
			m_pdf_del_btn.GetWindowRect(&r1);
			m_prd_id_ctrl.GetWindowRect(&r2);
			r2.right=r1.right;
			ScreenToClient(&r2);
			m_prd_id_ctrl.MoveWindow(&r2);

			m_pdf_browse_btn.ShowWindow(SW_HIDE);
			m_pdf_del_btn.ShowWindow(SW_HIDE);
			m_customer_sel_btn.ShowWindow(SW_HIDE);
			m_customer_del_btn.ShowWindow(SW_HIDE);
		}
	}
	if(m_lot!=0)
	{
		m_api->m_prd_inst_mgr.LoadLotInfo(m_lot);
		if(m_pdf==0)apidata.GetAttrBN(m_lot,S::formation,m_pdf);
	}
	if(m_pdf!=0)
	{
		m_api->GetItemName(m_pdf,m_prd_id);
	
		RECT r1,r2;
		m_pdf_del_btn.GetWindowRect(&r1);
		m_prd_id_ctrl.GetWindowRect(&r2);
		r2.right=r1.right;
		ScreenToClient(&r2);
		m_prd_id_ctrl.MoveWindow(&r2);		
		
		m_pdf_browse_btn.EnableWindow(FALSE);
		m_pdf_del_btn.EnableWindow(FALSE);
		m_pdf_browse_btn.ShowWindow(SW_HIDE);
		m_pdf_del_btn.ShowWindow(SW_HIDE);
	}
	if(m_inst_rel!=0)
	{
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_id,m_rel_id);
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_name,m_rel_name);
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_descr,m_rel_descr);
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,m_rel_contexts);
		m_api->m_doc_mgr.PrintItemContextInString(m_rel_contexts,buf);
		m_rel_context.SetWindowText(buf);

		COleDateTime odt;
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
		
		if(buf==_T(""))
			odt.m_status=COleDateTime::null;
		else
			aplString2Date(buf,odt);

		m_time_inst_ctrl.SetTime(odt);
		m_date_inst_ctrl.SetTime(odt);

		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
		if(buf==_T(""))
		{
			//odt.SetDate(0,0,0);
			m_date_has_removed_ctrl.SetCheck(0);
		}
		else
		{
			aplString2Date(buf,odt);
			m_date_has_removed_ctrl.SetCheck(1);
			m_time_rem_ctrl.EnableWindow(TRUE);
			m_date_rem_ctrl.EnableWindow(TRUE);
			m_sel_context_btn.EnableWindow(TRUE);
		}
		m_time_rem_ctrl.SetTime(odt);
		m_date_rem_ctrl.SetTime(odt);

		CaplInstance *inst;
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_relating,inst);
		if(inst->GetAccessmode()>=aplRO)
		{
			m_rel_id_ctrl.SetReadOnly(TRUE);
			m_rel_name_ctrl.SetReadOnly(TRUE);
			m_rel_descr_ctrl.SetReadOnly(TRUE);
		}
		CImageList icons;
		icons.Create(IDR_SEL_CMD_TB,16,2,RGB(255,0,255));
		m_rel_prop_btn.SetIcon(icons.ExtractIcon(2));
		m_rel_prop_btn.SetFlat(FALSE);
		m_rel_prop_btn.SetTooltipText( APL_T(" "));
	}

	int i=m_lot_ctrl.AddString(_T(""));
	m_lot_ctrl.SetCurSel(i);
	m_lot_ctrl.SetItemData(i,0);

	if(m_lot!=0)
	{
		m_lot_ctrl.EnableWindow(FALSE);
		apidata.GetAttrBN(m_lot,S::id,buf);
		i=m_lot_ctrl.AddString(buf);
		m_lot_ctrl.SetItemData(i,(long)m_lot);
		m_lot_ctrl.SetCurSel(i);
	}
	else
	{
		//     

		UpdateLotInfo();
	}
	if(m_inst==0)
	{
		m_states_ctrl.SelectString(-1, APL_T(""));
	}
	if(m_inst_rel==0 && m_par_inst==0)
	{
		m_st_0.ShowWindow(SW_HIDE);
		m_st_1.ShowWindow(SW_HIDE);
		m_st_2.ShowWindow(SW_HIDE);
		m_st_3.ShowWindow(SW_HIDE);
		m_st_4.ShowWindow(SW_HIDE);
		m_st_5.ShowWindow(SW_HIDE);
		m_time_rem_ctrl.ShowWindow(SW_HIDE);
		m_time_inst_ctrl.ShowWindow(SW_HIDE);
		m_date_has_removed_ctrl.ShowWindow(SW_HIDE);
		m_date_rem_ctrl.ShowWindow(SW_HIDE);
		m_date_inst_ctrl.ShowWindow(SW_HIDE);

		m_rel_id_ctrl.ShowWindow(SW_HIDE);
		m_rel_name_ctrl.ShowWindow(SW_HIDE);
		m_rel_descr_ctrl.ShowWindow(SW_HIDE);

		m_rel_context.ShowWindow(SW_HIDE);
		m_sel_context_btn.ShowWindow(SW_HIDE);
		m_rel_prop_btn.ShowWindow(SW_HIDE);

		int cy=180;
		RECT rect;

		m_cancel_btn.GetWindowRect(&rect);
		ScreenToClient(&rect);
		rect.top-=cy;
		rect.bottom-=cy;
		m_cancel_btn.MoveWindow(&rect);

		m_ok_btn.GetWindowRect(&rect);
		ScreenToClient(&rect);
		rect.top-=cy;
		rect.bottom-=cy;
		m_ok_btn.MoveWindow(&rect);

		GetWindowRect(&rect);
		rect.bottom-=cy;

		SetSize(cy);

		MoveWindow(&rect);
	}

	m_Tab.InitStates();
	SetAnchors();

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//**********************************************************************
void CPrdInstDlg::OnOK() 
{
	// TODO: Add extra validation here
	COleDateTime odt_ins, odt_rem, odt0,odt1;

	if(!UpdateData(true))
		return;
	if(m_id==_T(""))
	{
		AfxMessageBox( APL_T("   !"));
		return;
	}

	CaplAttrValue tst_values[2];

	if(m_pdf==0)
	{
		AfxMessageBox( APL_T("    !!!"));
		return;
	}
	
	CaplEntity *e_pi=apidata.GetEntityBN(_T("apl_product_instance"));
	tst_values[0].value.Set((LPCTSTR)m_id);
	tst_values[0].attr=apidata.GetAttrDefinition(e_pi,S::id);
	tst_values[1].value.Set(m_pdf);
	tst_values[1].attr=apidata.GetAttrDefinition(e_pi,S::formation);

	if(!apidata.NET_TestUniqueAttrValues(e_pi,m_inst,2,&tst_values[0],false))
	{
		AfxMessageBox( APL_T("    !!!\n    (   ) "));
		return;
	}

	if(m_sn!=_T(""))
	{
		tst_values[0].value.Set((LPCTSTR)m_sn);
		tst_values[0].attr=apidata.GetAttrDefinition(e_pi,_T("serial_number"));

		if(!apidata.NET_TestUniqueAttrValues(e_pi,m_inst,2,&tst_values[0], false))
		{
			AfxMessageBox( APL_T("     !!! \n    (   )"));
			return;
		}
	}

	if(m_inst_rel!=0 || m_par_inst!=0)
	{
		m_date_inst_ctrl.GetTime(odt0);
		m_time_inst_ctrl.GetTime(odt1);
		odt_ins.SetDateTime(odt0.GetYear(),odt0.GetMonth(),odt0.GetDay(),
							odt1.GetHour(),odt1.GetMinute(),odt1.GetSecond());

		m_date_rem_ctrl.GetTime(odt0);
		m_time_rem_ctrl.GetTime(odt1);
		odt_rem.SetDateTime(odt0.GetYear(),odt0.GetMonth(),odt0.GetDay(),
							odt1.GetHour(),odt1.GetMinute(),odt1.GetSecond());

		if(m_date_has_removed_ctrl.GetCheck()>0)
		{
			if(odt_rem<=odt_ins) 
			{
				AfxMessageBox( APL_T("      "));
				return;
			}
		}
	}

	CString old_state=_T(""),state=_T("");
	CaplInstance *pdf=0,*lot=0;
	CString id,sn,descr,s_dt_old;
	int i=m_lot_ctrl.GetCurSel();
	if(i!=-1)
		m_lot=(CaplInstance*)m_lot_ctrl.GetItemData(i);
	if(m_inst==0) 
		m_inst=apidata.CreateInstanceBN(_T("apl_product_instance"));
	else
	{
		apidata.GetAttrBN(m_inst,S::id,id);
		apidata.GetAttrBN(m_inst,S::description,descr);
		apidata.GetAttrBN(m_inst,_T("serial_number"),sn);
		apidata.GetAttrBN(m_inst,_T("date_time"),s_dt_old);
		apidata.GetAttrBN(m_inst,_T("lot"),lot);
		apidata.GetAttrBN(m_inst,S::formation,pdf);
		apidata.GetAttrBN(m_inst,_T("state"),old_state);

	}
	if(m_pdf!=pdf) 
		apidata.PutAttrBN(m_inst,S::formation,m_pdf);
	if(m_lot!=lot) 
		apidata.PutAttrBN(m_inst,_T("lot"),m_lot);
	if(m_id!=id) 
		apidata.PutAttrBN(m_inst,S::id,m_id);
	if(m_sn!=sn) 
		apidata.PutAttrBN(m_inst,_T("serial_number"),m_sn);

	COleDateTime odt;
	CString s_dt;
	m_date_manuf_ctrl.GetTime(odt);
	if(odt.GetStatus()==COleDateTime::valid)
	{
		odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),0,0,0);
		aplDate2String(odt,s_dt);
	}
	if(s_dt!=s_dt_old) apidata.PutAttrBN(m_inst,_T("date_time"),s_dt);


	if(m_descr!=descr) 
		apidata.PutAttrBN(m_inst,S::description,m_descr);
	int cur_state=m_states_ctrl.GetCurSel();
	if(cur_state>-1) 
		m_states_ctrl.GetLBText(cur_state,state);
	if(state!=old_state) 
		apidata.PutAttrBN(m_inst,_T("state"),state);


	if(0!=m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer)
	{
		CaplInstance *inst=0;
		apidata.GetAttr(m_inst,m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer,inst);
		if(inst!=m_customer) apidata.PutAttr(m_inst,m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer,m_customer);
	}

	if(0!=m_api->m_prd_inst_mgr.a_prd_inst_vniis_shipment_date)
	{
		COleDateTime odt;
		CString s_dt,s_dt_old;

		apidata.GetAttr(m_inst,m_api->m_prd_inst_mgr.a_prd_inst_vniis_shipment_date,s_dt_old);
		
		m_date_shipment_ctrl.GetTime(odt);
		if(odt.GetStatus()==COleDateTime::valid)
		{
			odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),0,0,0);
			aplDate2String(odt,s_dt);
		}
		if(s_dt!=s_dt_old) apidata.PutAttr(m_inst,m_api->m_prd_inst_mgr.a_prd_inst_vniis_shipment_date,s_dt);
	}


	//  
	if(m_par_inst!=0)
	{
		m_inst_rel=apidata.CreateInstance(m_api->m_prd_inst_mgr.e_apl_component);
		apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_relating,m_par_inst);
		apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_related,m_inst);
	}
	if(m_inst_rel!=0)
	{
		CString buf,buf1;
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_id,buf);
		if(buf!=m_rel_id) 
			apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_id,m_rel_id);
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_name,buf);
		if(buf!=m_rel_name) 
			apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_name,m_rel_name);
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_descr,buf);
		if(buf!=m_rel_descr) 
			apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_descr,m_rel_descr);
		
		aplDate2String(odt_ins,buf1);
		apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
		if(buf!=buf1) 
			apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf1);

		if(m_context_changed) 
			apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,m_rel_contexts);
		
		if(m_date_has_removed_ctrl.GetCheck()>0)
		{
			aplDate2String(odt_rem,buf1);
			apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
			if(buf!=buf1) 
				apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf1);
		}
		else
		{
			apidata.GetAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
			if(buf!=_T("")) 
				apidata.PutAttr(m_inst_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed,_T(""));
		}
	}
	apidata.NET_SaveChanges();

	GetAccessString();

	CaplResizableDialog::OnOK();
}

//**********************************************************************
void CPrdInstDlg::UpdateLotInfo()
{
	if(m_api==0) return;

	CaplInstance *inst0;
	CaplAggr aggr;
	CaplInstance *old_value=0;
	CString buf;
	int index4set=-1;
	int i,j;
	i=m_lot_ctrl.GetCurSel();
	if(i!=-1) old_value=(CaplInstance*)m_lot_ctrl.GetItemData(i);
	m_lot_ctrl.ResetContent();
	i=m_lot_ctrl.AddString(_T(""));
	m_lot_ctrl.SetCurSel(i);
	m_lot_ctrl.SetItemData(i,0);


	if(0!=old_value)
	{
		apidata.GetAttr(old_value,m_api->m_prd_inst_mgr.a_lot_pdf,inst0);
		if(inst0!=0 && inst0!=m_pdf) old_value=0;
	}


	if(m_pdf!=0)
	{
		aplExtent ext_lot;
		m_api->m_prd_inst_mgr.FindAllPdfLoot(m_pdf,ext_lot);

		for(i=0;i<ext_lot.Size;i++)
		{
			CaplInstance *lot=ext_lot[i];
			apidata.GetAttr(lot,m_api->m_prd_inst_mgr.a_lot_id,buf);
			j=m_lot_ctrl.AddString(buf);
			m_lot_ctrl.SetItemData(j,(long)lot);

			if(lot==old_value) index4set=j;
		}
	}
	if(index4set>=0) m_lot_ctrl.SetCurSel(index4set);
}

void CPrdInstDlg::OnHasRemoved() 
{
	if(m_date_has_removed_ctrl.GetCheck()==0)
	{
		m_time_rem_ctrl.EnableWindow(FALSE);
		m_date_rem_ctrl.EnableWindow(FALSE);
	}
	else
	{
		m_time_rem_ctrl.EnableWindow(TRUE);
		m_date_rem_ctrl.EnableWindow(TRUE);
	}
}

void CPrdInstDlg::OnSelContext() 
{
	if(m_api->m_doc_mgr.ChangeItemContext(m_rel_contexts))
	{
		CString buf;
		m_api->m_doc_mgr.PrintItemContextInString(m_rel_contexts,buf);
		m_rel_context.SetWindowText(buf);
		m_context_changed=true;
	}		
}

void CPrdInstDlg::OnRelProperty() 
{
	if(m_inst_rel==0)
	{
		AfxMessageBox( APL_T("    !!!"),MB_OK|MB_ICONSTOP);return;
	}
	if(m_inst_rel) m_api->m_charact_mgr.ShowItemProperties(m_inst_rel);
	
}

void CPrdInstDlg::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CaplPropsView* pView	=NULL;
	
	BOOL	bDis	=TRUE;
	BOOL	bHide	=FALSE;

	if(0==m_Tab.GetCurSel())
		bDis=FALSE;

	ChangeViewBtnsState(bDis,!bDis);

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	if(NULL!=pView)
	{
		pView->InitView();
		pView->ChangeCtrlsState();
	}
	
	*pResult = 0;
}

void CPrdInstDlg::OnBPropsAdd() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBAdd();
}

void CPrdInstDlg::OnBPropsDel() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBDel();
}

void CPrdInstDlg::OnBPropsProps() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBProps();
}

void CPrdInstDlg::OnBnClickedDelCustomer()
{
	if(0==m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer) return;
	m_customer=0;
	m_customer_ctrl.SetWindowText(_T(""));
}

void CPrdInstDlg::OnBnClickedSelCustomer()
{
	if(0==m_api->m_prd_inst_mgr.a_prd_inst_vniis_customer) return;
	CaplInstance *cust=0;
	m_api->m_appr_mgr.SelectOrganization(&cust,APL_T(" "));
	if(0==cust) return;

	m_customer=cust;
	CString buf;
	m_api->m_appr_mgr.GetItemName(m_customer,buf);
	m_customer_ctrl.SetWindowText(buf);

}
