// QueryChildFrame.cpp : implementation file
//

#include "stdafx.h"
#include "QueryChildFrame.h"
#include "QueryFormView.h"
#include "QueryTableItemsView.h"


#define WINDOW_TITLE APL_T("  ")

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE(CQuerySplitterWnd, CSplitterWnd)

BEGIN_MESSAGE_MAP(CQuerySplitterWnd, CSplitterWnd)
	//{{AFX_MSG_MAP(CQuerySplitterWnd)
	// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
	ON_WM_SIZE()
END_MESSAGE_MAP()

#ifdef _DEBUG
void CQuerySplitterWnd::AssertValid() const
{
	CSplitterWnd::AssertValid();
}

void CQuerySplitterWnd::Dump(CDumpContext& dc) const
{
	CSplitterWnd::Dump(dc);
}
#endif //_DEBUG

CQuerySplitterWnd::CQuerySplitterWnd()
{

}

CQuerySplitterWnd::~CQuerySplitterWnd()
{

}

LRESULT CQuerySplitterWnd::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	return CSplitterWnd::WindowProc(message, wParam, lParam);
}

BOOL CQuerySplitterWnd::CreateEx(CWnd* pParentWnd,CCreateContext *pContext)
{
	CreateStatic(pParentWnd, 2, 1);
	CreateView(0, 0, RUNTIME_CLASS(CQueryFormView), CSize(1000,100), pContext);
	CreateView(1, 0, RUNTIME_CLASS(CQueryTableItemsView), CSize(200,150), pContext);

	return TRUE;
}

bool CQuerySplitterWnd::Init(CaplAPI *api)
{
	if(api==0) return false;
	CQueryFormView* pQueryView = (CQueryFormView*)(GetPane(0, 0));
	CQueryTableItemsView *pTableView = (CQueryTableItemsView*)(GetPane(1, 0));
	if(pQueryView == 0 || pTableView == 0) return false;
	pQueryView->m_api = api;
	pTableView->m_api = api;
	pTableView->m_Mode = APL_CLASSIFIER_EDITOR;
	pQueryView->m_pTableView = pTableView;

	(CView*)(pQueryView)->SendMessage(WM_INITIALUPDATE);
	(CView*)(pTableView)->SendMessage(WM_INITIALUPDATE);

	int cy = 100;
	SetRowInfo(0, cy, 0);
	RecalcLayout();
	SetWindowText( WINDOW_TITLE );
	return true;
}

BOOL CQuerySplitterWnd::DestroyWindow() 
{
	int cx, tmp;
	GetRowInfo(0, cx, tmp);
	//AfxGetApp()->WriteProfileInt(_T("Query Pane Settings"), _T("Dialog height"), cx);
	return TRUE;
}

void CQuerySplitterWnd::OnSize(UINT nType, int cx, int cy)
{
	CSplitterWnd::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
}


// CQueryChildFrame

IMPLEMENT_DYNCREATE(CQueryChildFrame, CMDIChildWnd)

CQueryChildFrame::CQueryChildFrame()
{

}

CQueryChildFrame::~CQueryChildFrame()
{
}


BEGIN_MESSAGE_MAP(CQueryChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CQueryChildFrame)
	ON_WM_CREATE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CQueryChildFrame message handlers

BOOL CQueryChildFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	return m_wndVSplitter.CreateEx(this,pContext);
}

int CQueryChildFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	CaplSetResourceHandle setres(module_inst);

	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
	{
		return -1;
	}

	SetWindowText( WINDOW_TITLE);
	return 0;
}

bool CQueryChildFrame::Init(CaplAPI *api)
{
	return m_wndVSplitter.Init(api);
}



void CQueryChildFrame::OnSize(UINT nType, int cx, int cy) 
{
	if(::IsWindow(m_wndVSplitter.m_hWnd) && IsWindowVisible() && !IsIconic() && !AfxGetMainWnd()->IsIconic())
	{
		int vpos, tmp;
		m_wndVSplitter.GetRowInfo(0, vpos, tmp);
		CFrameWnd::OnSize(nType, cx, cy);

	}
	else
		CMDIChildWnd::OnSize(nType, cx, cy);
}

void CQueryChildFrame::OnUpdateFrameTitle(BOOL bAddToTitle)
{
	SetTitle( WINDOW_TITLE);

	CMDIChildWnd::OnUpdateFrameTitle(bAddToTitle);
}

