// FaultMiniDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefusalMiniDlg.h"

// CRefusalMiniDlg dialog

IMPLEMENT_DYNAMIC(CRefusalMiniDlg, CaplTranslateDialog)

CRefusalMiniDlg::CRefusalMiniDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefusalMiniDlg::IDD, pParent)
{
	m_api=0;
	m_refusal=0;
	m_bReadOnly=false;

}

CRefusalMiniDlg::~CRefusalMiniDlg()
{
}

void CRefusalMiniDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DOC_NUM, m_RefDocNumCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_REF_TYPE, m_combo_ref_type);
	DDX_Control(pDX, IDC_REF_STATE, m_combo_ref_state);
	DDX_Control(pDX, IDC_REF_DESCR, m_RefDescrCtrl);
	DDX_Control(pDX, IDC_REF_DOC, m_combo_ref_doc);
	DDX_Control(pDX, IDC_REF_DOC_DATE, m_date_ref_doc_date);
}


BEGIN_MESSAGE_MAP(CRefusalMiniDlg, CaplTranslateDialog)
END_MESSAGE_MAP()


// CRefusalMiniDlg message handlers

BOOL CRefusalMiniDlg::OnInitDialog()
{
	if(0==m_api) return FALSE;
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	InitComboType();
	InitComboStage();

	m_combo_ref_state.SelectString(-1, APL_T(""));
	m_combo_ref_doc.SetCurSel(0);

	if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T("")))
	{
		int i=m_combo_ref_doc.AddString(_T(""));
		m_combo_ref_doc.SetCurSel(i);
		m_combo_ref_doc.EnableWindow(FALSE);
		m_RefDocNumCtrl.SetReadOnly();
	}

	if (NULL == m_api->m_expl_mgr)
	{
		return FALSE;
	}

	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(0!=m_refusal)
	{
		aplExtent ext;
		ext.Add(m_refusal);
		mgr->LoadRefusalsInfo(ext);

		if(m_refusal->GetAccessmode()>aplRW)m_bReadOnly=true;

		int i;
		CString buf;
		CaplInstance *inst;
		m_api->m_data.GetAttr(m_refusal,m_api->m_expl_mgr->a_apl_refusal_doc_num,buf);
		m_RefDocNumCtrl.SetWindowText(buf);

		m_api->m_data.GetAttr(m_refusal,m_api->m_expl_mgr->a_apl_refusal_description,buf);
		m_RefDescrCtrl.SetWindowText(buf);

		m_api->m_data.GetAttr(m_refusal, mgr->a_apl_refusal_type, inst); 
		if(0!=inst)
		{
			for(i=0;i<m_combo_ref_type.GetCount();i++)
			{
				if(inst==(CaplInstance*)m_combo_ref_type.GetItemData(i))
				{
					m_combo_ref_type.SetCurSel(i);
					break;
				}
			}
		}

		m_api->m_data.GetAttr(m_refusal, mgr->a_apl_refusal_state, buf);
		m_combo_ref_state.SelectString(-1, buf);

		m_api->m_data.GetAttr(m_refusal, mgr->a_apl_refusal_doc_type, buf);
		m_combo_ref_doc.SelectString(-1, buf);

		m_api->m_data.GetAttr(m_refusal, mgr->a_apl_refusal_doc_date, buf);
		if(buf!=_T(""))
		{
			COleDateTime odt;
			aplString2Date(buf,odt);
			m_date_ref_doc_date.SetTime(odt);
		}
	}

	if(m_bReadOnly)
	{
		m_RefDocNumCtrl.SetReadOnly(true);
		m_RefDescrCtrl.SetReadOnly(true);

		m_combo_ref_type.EnableWindow(FALSE);
		m_combo_ref_doc.EnableWindow(FALSE);
		m_combo_ref_state.EnableWindow(FALSE);
		m_date_ref_doc_date.EnableWindow(FALSE);
		m_ok_btn.EnableWindow(FALSE);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
//************************************************************************************************
void CRefusalMiniDlg::OnOK()
{
	if(m_bReadOnly) {CaplTranslateDialog::OnCancel(); return;}

	int i;
	CString buf, sDocType,sDocId,sDocDate,sState,sDescr;
	CaplInstance *iType=0;
	
	m_RefDocNumCtrl.GetWindowText(sDocId);
	m_RefDescrCtrl.GetWindowText(sDescr);

	i=m_combo_ref_type.GetCurSel();
	if(i>=0) iType=(CaplInstance*)m_combo_ref_type.GetItemData(i);

	m_combo_ref_state.GetWindowText(sState);
	m_combo_ref_doc.GetWindowText(sDocType);

	COleDateTime odt;
	m_date_ref_doc_date.GetTime(odt);
	aplDate2String(odt,sDocDate);

	if(sDescr==_T("")){AfxMessageBox(APL_T("  "),MB_ICONSTOP|MB_OK);return;}

	// doc_id
	if(sDocId==_T("") && 0==m_refusal)
	if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T("")))
	{
		int year=(COleDateTime::GetCurrentTime()).GetYear();
		buf.Format(APL_NO_T("\\_%i"),year);
		int counter=m_api->m_options_mgr.GetCounterWithIncrementBN(buf);
		sDocId.Format(_T("%i-%05i"),year,counter);
	}
	else
	{
		CString sDocType4AutoNum;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "), sDocType4AutoNum,0);
		sDocType4AutoNum.MakeLower();
		buf=sDocType;
		buf.MakeLower();
		if(buf!=_T("") && buf ==sDocType4AutoNum)
		{
			//  
			//COleDateTime odt=COleDateTime::GetCurrentTime();
			int year=(COleDateTime::GetCurrentTime()).GetYear();
			buf.Format(APL_NO_T("\\_%i"),year);
			int counter=m_api->m_options_mgr.GetCounterWithIncrementBN(buf);
			sDocId.Format(_T("%i-%05i"),year,counter);
		}
	}

	if(sDocId==_T("")){AfxMessageBox(APL_T("   "),MB_ICONSTOP|MB_OK);return;}

	if(0==m_refusal) m_refusal=m_api->m_data.CreateInstance(m_api->m_expl_mgr->e_apl_refusal);

	m_api->m_data.PutAttr(m_refusal, m_api->m_expl_mgr->a_apl_refusal_doc_num,sDocId);
	m_api->m_data.PutAttr(m_refusal, m_api->m_expl_mgr->a_apl_refusal_description,sDescr);
	m_api->m_data.PutAttr(m_refusal, m_api->m_expl_mgr->a_apl_refusal_type, iType); 
	m_api->m_data.PutAttr(m_refusal, m_api->m_expl_mgr->a_apl_refusal_state, sState);
	m_api->m_data.PutAttr(m_refusal, m_api->m_expl_mgr->a_apl_refusal_doc_type, sDocType);
	m_api->m_data.PutAttr(m_refusal, m_api->m_expl_mgr->a_apl_refusal_doc_date, sDocDate);

	CaplTranslateDialog::OnOK();
}

//************************************************************************************************
void CRefusalMiniDlg::InitComboType()
{
	CString sName, msg;
	aplExtent aeItems;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_TYPE_CLASSIFIER_LVL,true);
	if(!ciLvl) return;

	m_api->m_classifier_mgr.LoadSubClassifierLevels(ciLvl, aeItems);
	for(int i=0; i<aeItems.Size; i++)
	{
		m_api->m_data.GetAttr(aeItems[i], m_api->m_classifier_mgr.a_apl_classifier_level_name, sName);
		if(sName.IsEmpty()) continue;

		int nIndex = m_combo_ref_type.AddString(sName);
		m_combo_ref_type.SetItemData(nIndex, (DWORD)aeItems[i]);
	}
}

void CRefusalMiniDlg::InitComboStage()
{
	/*CString sName, msg;
	aplExtent aeItems;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_STAGE_CLASSIFIER_LVL,true);
	if(!ciLvl) return;


	m_api->m_classifier_mgr.LoadSubClassifierLevels(ciLvl, aeItems);
	for(int i=0; i<aeItems.Size; i++)
	{
		m_api->m_data.GetAttr(aeItems[i], m_api->m_classifier_mgr.a_apl_classifier_level_name, sName);
		if(sName.IsEmpty()) continue;

		int nIndex = m_combo_ref_state.AddString(sName);
		m_combo_ref_state.SetItemData(nIndex, (DWORD)aeItems[i]);
	}*/
}
