// SSDiferencesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SSDiferencesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSSDiferencesDlg dialog
BOOL CSSDiferencesDlg::m_sdif_show = TRUE;
BOOL CSSDiferencesDlg::m_sdiskc_show = FALSE;
BOOL CSSDiferencesDlg::m_spsm_show = TRUE;
BOOL CSSDiferencesDlg::m_sdoc_recursive = FALSE;
BOOL CSSDiferencesDlg::m_sfolder_recursive = FALSE;
BOOL CSSDiferencesDlg::m_scompare_only = FALSE;


CSSDiferencesDlg::CSSDiferencesDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSSDiferencesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSSDiferencesDlg)
/*	m_dif_show = TRUE;
	m_diskc_show = FALSE;
	m_disk_path = _T("");
	m_psm_name = _T("");
	m_psm_show = TRUE;
	m_api = 0;
	m_doc_recursive = FALSE;
	m_folder_recursive = FALSE;
	m_compare_only = FALSE;*/
	//}}AFX_DATA_INIT
}


void CSSDiferencesDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSSDiferencesDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Check(pDX, IDC_DIFFERENCE_ONLY, m_dif_show);
	DDX_Check(pDX, IDC_DISK_DOCS, m_diskc_show);
	DDX_Text(pDX, IDC_DISK_FOLDER, m_disk_path);
	DDX_Text(pDX, IDC_PSM_FOLDER, m_psm_name);
	DDX_Check(pDX, IDC_PSM_ONLY, m_psm_show);
	DDX_Check(pDX, IDC_RECURSIVE2, m_doc_recursive);
	DDX_Check(pDX, IDC_RECURSIVE, m_folder_recursive);
	DDX_Check(pDX, IDC_DIFFERENCE_ONLY2, m_compare_only);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSSDiferencesDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSSDiferencesDlg)
	ON_BN_CLICKED(IDC_PSM_BROWSE, OnPsmBrowse)
	ON_BN_CLICKED(IDC_DISK_BROWSE, OnDiskBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSSDiferencesDlg message handlers

void CSSDiferencesDlg::OnOK() 
{
	UpdateData();
	if(m_diskc_show==FALSE && m_psm_show==FALSE && m_dif_show == FALSE && m_compare_only == FALSE) 
	{
		AfxMessageBox( APL_T("   ."));
		return;
	}
	if(m_disk_path==_T("") || m_folder==0)
	{
		AfxMessageBox( APL_T("   ."));
		return;
	}
	m_sdif_show = m_dif_show;
	m_sdiskc_show = m_diskc_show;
	m_spsm_show = m_psm_show;
	m_sdoc_recursive = m_doc_recursive;
	m_sfolder_recursive = m_folder_recursive;
	m_scompare_only = m_compare_only;
	
	CaplTranslateDialog::OnOK();
}

void CSSDiferencesDlg::OnPsmBrowse() 
{
	CaplInstance *folder = m_api->m_doc_mgr.SelectInstance(APL_MODE_SELECT_FOLDER, APL_T("   "));
	if(folder)
	{
		m_folder = folder;
		m_api->m_data.GetAttr(folder,m_api->m_folder_mgr.a_folder_name,m_psm_name);
		UpdateData(FALSE);
	}
}

void CSSDiferencesDlg::OnDiskBrowse() 
{
	CaplSelectFolderDialog dlg(FALSE,m_disk_path);
	if(dlg.DoModal()==IDOK)
	{
		m_disk_path = dlg.GetSelectedPath();
		UpdateData(FALSE);
	}
}

BOOL CSSDiferencesDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	if(m_api==0)
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("    CaplAPI"));
#endif
		EndDialog(0);
		return FALSE;
	}
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_dif_show = m_sdif_show;
	m_diskc_show = m_sdiskc_show;
	m_psm_show = m_spsm_show;
	m_doc_recursive = m_sdoc_recursive;
	m_folder_recursive = m_sfolder_recursive;
	m_compare_only = m_scompare_only;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
