// SelectInstanceDlgEx.cpp : implementation file
//

#include "stdafx.h"
#include "SelectInstanceDlgEx.h"
#include "SelectInstanceFrame.h"
#include "SelectInstanceView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectInstanceDlgEx dialog


CSelectInstanceDlgEx::CSelectInstanceDlgEx(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CSelectInstanceDlgEx::IDD, pParent)
	, m_api(NULL)
	, m_pFrame(NULL)
	, m_pView(NULL)
	, m_oldOpenedItems(NULL)
	, m_BaseItems(NULL)
	, m_fn(NULL)
	, m_fn2(NULL)
	, m_data(NULL)
{
	//{{AFX_DATA_INIT(CSelectInstanceDlgEx)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_sTitle=  APL_T("   ");
	m_SelectedInstances.Clear();
}

void CSelectInstanceDlgEx::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectInstanceDlgEx)
	DDX_Control(pDX, IDC_SELECT_INST_FRAME_STATIC, m_frameWnd);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectInstanceDlgEx, CaplResizableDialog)
	//{{AFX_MSG_MAP(CSelectInstanceDlgEx)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_WM_ACTIVATE()
	ON_WM_SETFOCUS()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectInstanceDlgEx message handlers

int CSelectInstanceDlgEx::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplResizableDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CRect rect; GetClientRect(&rect);
	
    m_pFrame = (CSelectInstanceFrame*)(RUNTIME_CLASS(CSelectInstanceFrame)->CreateObject());
	m_pFrame->m_bShowToolBar = ((m_mode & APL_MODE_HIDE_TOOLBAR) > 0) ? false : true;
    m_pFrame->Create(NULL, NULL, WS_VISIBLE|WS_CHILD/*|WS_BORDER*/, rect, this);
	
	m_pView= (CSelectInstanceView*)m_pFrame->GetActiveView();
	if (m_pView)
	{
		m_pView->m_api = m_api;
		m_pView->m_BaseItems = m_BaseItems;
		m_pView->m_selectMode = m_mode;
		m_pView->m_enableBtn = &m_okBtn;
		m_pView->m_pDlg= this;
		
		m_pView->SendMessage(WM_INITIALUPDATE);
	}
	return 0;
}

BOOL CSelectInstanceDlgEx::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);

	SetWindowText(m_sTitle);
	
	CRect rect;
	m_frameWnd.GetWindowRect(&rect);
	ScreenToClient(&rect);
	//rect.DeflateRect(-1,-1, 2, 2);
	//rect.DeflateRect(0,0, 0, 2);
	m_pFrame->MoveWindow(rect);
	
	m_okBtn.EnableWindow(FALSE);
	
	if(m_pView)
	{
		m_pView->SetMultiSelect((bool)((m_mode & APL_MODE_SELECT_MULTY) > 0));
		
		CPoint point;
		CRect rect;
		
		if(m_pView->m_lastSelectedItem)	
		{
			m_pView->GetTreeCtrl().GetItemRect(m_pView->m_lastSelectedItem->m_item, rect, TRUE);
			m_pView->OnLButtonDown(1, CPoint(rect.left+1, rect.top+1));
		}
	}
	
	m_frameWnd.ShowWindow(SW_HIDE);

	AddAnchor(m_pFrame->m_hWnd, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectInstanceDlgEx::OnOK() 
{
	m_SelectedInstances.Clear();
	if(m_pView)
	{
		if(m_mode&APL_MODE_SELECT_MULTY)
			m_pView->GetSelectedItems(m_SelectedInstances);
		else
			m_SelectedInstances.Add(m_pView->m_selectedInstance);
	}
	if(m_fn)
		if(!m_fn(m_api,m_SelectedInstances))
			return;
	if(m_fn2)
		if(!m_fn2(m_api,m_SelectedInstances,m_data))
			return;
	CaplResizableDialog::OnOK();
}

void CSelectInstanceDlgEx::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CaplResizableDialog::OnCancel();
}

void CSelectInstanceDlgEx::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
	CaplResizableDialog::OnActivate(nState, pWndOther, bMinimized);
	m_pFrame->Invalidate();
	m_pView->Invalidate();
}

void CSelectInstanceDlgEx::OnSetFocus(CWnd* pOldWnd)
{
	CaplResizableDialog::OnSetFocus(pOldWnd);
	m_pFrame->Invalidate();
	m_pView->Invalidate();
}
