// TableValDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dictionary.h"
#include "apl_api.h"

#include "StrValueDlg.h"
#include "RealValueDlg.h"
#include "MoneraryValDlg.h"
#include "EnumValDlg.h"
#include "DataTimeDlg.h"
#include "TableValDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTableValDlg dialog


CTableValDlg::CTableValDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CTableValDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTableValDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_aggr_val.SetUniqueName(_T("apl_psm_aggr_in_aggr_val"));
	m_data=0;
	m_charact_mgr=0;
	m_value=0; m_old_value=0;
	m_unit=0;
	m_parent_value=0;
}


void CTableValDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTableValDlg)
	DDX_Control(pDX, IDC_STATIC_FON, m_satic_fon);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_BOTTOM, m_bottom_btn);
	DDX_Control(pDX, IDC_TOP, m_top_btn);
	DDX_Control(pDX, IDC_SAVE_TO_FILE, m_save_to_file);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTableValDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CTableValDlg)
	ON_BN_CLICKED(IDC_SAVE_TO_FILE, OnSaveToFile)
	ON_WM_CONTEXTMENU()
	ON_BN_CLICKED(IDC_TOP, OnTop)
	ON_BN_CLICKED(IDC_BOTTOM, OnBottom)
	ON_NOTIFY(NM_DBLCLK, IDC_AGGR_VAL, OnDblclkAggrVal)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTableValDlg message handlers

BOOL CTableValDlg::OnInitDialog() 
{
	RECT rect={5,5,10,10};
	m_aggr_val.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDC_AGGR_VAL);

	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	// TODO: Add extra initialization here

	m_satic_fon.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_aggr_val.MoveWindow(&rect);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_TOP, MIDDLE_LEFT);
	AddAnchor(IDC_BOTTOM, MIDDLE_LEFT);
	AddAnchor(IDC_SAVE_TO_FILE, BOTTOM_LEFT);
	AddAnchor(IDC_AGGR_VAL, TOP_LEFT, BOTTOM_RIGHT);

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_save_to_file.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_save_to_file.SetFlat(FALSE);

	m_top_btn.SetIcon(GetAplTableIco(APL_TABLE_TOP));
	m_bottom_btn.SetIcon(GetAplTableIco(APL_TABLE_BOTTOM));


    ListView_SetExtendedListViewStyle(m_aggr_val.m_hWnd,
		ListView_GetExtendedListViewStyle(m_aggr_val.m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_INFOTIP);


 	// Create table header
	m_ColumnListMap.Clear();
	m_aggr_val.DeleteAllItems();
	CArray <int,int> widths;
	int i,w;
	while(1)
	{
		i=m_aggr_val.GetColumnWidth(0);
		if(!m_aggr_val.DeleteColumn(0)) break;
		if(i>0) widths.Add(i);
	}
	if(m_unit==0) return false;
	if(m_data->IsKindOf(m_unit,m_charact_mgr->e_table_unit))
	{
		m_aggr_val.InsertColumn(0, APL_T(""),LVCFMT_LEFT,25);
		m_aggr_val.CListCtrl::SetColumnWidth(0,25);
		w=100;

		CString buf;
		int colums=0;
		CaplInstance *val0;
		CaplAggr aggr0;
		m_data->GetAttrBN(m_unit,_T("columns"),aggr0);
		for(i=0;i<aggr0.GetSize();i++)
		{
			aggr0.GetByIndex(i,val0);
			if(val0==0) continue;
			m_data->GetAttrBN(val0,_T("name"),buf);
			colums++;
			w=100;
			if(widths.GetSize()>colums) w=widths[colums];
			m_aggr_val.InsertColumn(colums,buf,LVCFMT_LEFT,w);
			m_ColumnListMap.Add((long)val0,colums-1);
		}
	} 
	else if(m_data->IsKindOf(m_unit,m_charact_mgr->e_apl_aggr_unit))
	{
		m_aggr_val.InsertColumn(0, APL_T(""),LVCFMT_LEFT,25);
		m_aggr_val.CListCtrl::SetColumnWidth(0,25);
		w=100;
		if(widths.GetSize()>1) w=widths[1];
		m_aggr_val.InsertColumn(1,_T("0"),LVCFMT_LEFT,w);
	}
	else return false;
	
	m_no_del_val_if_selchange=true;
	if(m_value!=0)
	{
		if(m_value->GetType()!=0)
		{
			if(m_ReadOnly)
			{
				m_mode=_T("View");
				m_ReadOnly=true;
				m_ok_btn.EnableWindow(FALSE);	
				m_top_btn.ShowWindow(SW_SHOW);
				m_bottom_btn.ShowWindow(SW_SHOW);
				m_save_to_file.ShowWindow(SW_SHOW);			}
			else 
			{
				if(m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val))
				{
					m_old_value=m_value;
					m_value=m_charact_mgr->CreateCopyCharacteristicVal(m_value);
				}
				else if(m_data->IsKindOf(m_value,m_charact_mgr->e_table_val))
				{
					m_old_value=m_value;
					m_value=m_charact_mgr->CreateCopyCharacteristicVal(m_value,0,&m_val_map);
				}
				else if(m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val_ver))
				{
					m_old_value=m_value;
					m_value=m_charact_mgr->CreateCharValVersion(m_value,_T("-1"),false,true);
				}
				else if(m_data->IsKindOf(m_value,m_charact_mgr->e_table_val_ver))
				{
					m_old_value=m_value;
					m_value=m_charact_mgr->CreateCharValVersion(m_value,_T("-1"),false,true);
				}
			}
		}
	}
	else
	{
		bool is_value_ver=false;
		if(m_parent_value) 
			if(m_data->IsKindOf(m_parent_value,m_charact_mgr->e_apl_charact_value_ver))
				is_value_ver=true;
		if(m_data->IsKindOf(m_unit,m_charact_mgr->e_apl_aggr_unit))
		{
			if(is_value_ver) m_value=m_data->CreateInstance(m_charact_mgr->e_aggr_val_ver);
			else m_value=m_data->CreateInstance(m_charact_mgr->e_aggr_val);
		}
		else if(m_data->IsKindOf(m_unit,m_charact_mgr->e_table_unit))
		{
			if(is_value_ver) m_value=m_data->CreateInstance(m_charact_mgr->e_table_val_ver);
			else m_value=m_data->CreateInstance(m_charact_mgr->e_table_val);
		}
	}
	if(m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val) || m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val_ver)) PrintAggrInList(m_value);
	else if(m_data->IsKindOf(m_value,m_charact_mgr->e_table_val) || m_data->IsKindOf(m_value,m_charact_mgr->e_table_val_ver)) PrintTableInList(m_value);
	
	//SetFromInst(0,m_value);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//*******************************************************************
void CTableValDlg::PrintAggrInList(CaplInstance *val)
{
	m_aggr_val.DeleteAllItems();
	CArray <int,int> widths;
	int i,j,w;
	while(1)
	{
		i=m_aggr_val.GetColumnWidth(0);
		if(!m_aggr_val.DeleteColumn(0)) break;
		if(i>0) widths.Add(i);
	}

	m_aggr_val.InsertColumn(0, APL_T(""),LVCFMT_LEFT,25);
	m_aggr_val.CListCtrl::SetColumnWidth(0,25);
	w=100;
	if(widths.GetSize()>1) w=widths[1];
	m_aggr_val.InsertColumn(1,_T("0"),LVCFMT_LEFT,w);
	//m_aggr_val.CListCtrl::SetColumnWidth(1,w);
	int colums=1;

	if(val==0) return;
	if(!m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val)) 
		if(!m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val_ver)) 
			return;
	CString buf;
	int row=0;
	CaplInstance *val0,*val1;
	CaplAggr aggr0;
	m_data->GetAttrBN(m_value,_T("values"),aggr0);
	for(i=0;i<aggr0.GetSize();i++)
	{
		aggr0.GetByIndex(i,val0);
		if(val0==0) continue;
		row++;
		row=m_aggr_val.InsertItem(row,_T(""));
		buf.Format(_T("%i"),row);
		m_aggr_val.SetItemText(row,0,buf);
		m_aggr_val.SetItemData(row,row);

		if(m_data->IsKindOf(val0,m_charact_mgr->e_aggr_val) || m_data->IsKindOf(val0,m_charact_mgr->e_aggr_val_ver))
		{
			CaplAggr aggr1;
			if(m_data->IsKindOf(val0,m_charact_mgr->e_aggr_val))
				m_data->GetAttr(val0,m_charact_mgr->a_apl_charact_val_aggr_val,aggr1);
			else
				m_data->GetAttr(val0,m_charact_mgr->a_apl_charact_val_ver_aggr_val,aggr1);

			for(j=0;j<aggr1.GetSize();j++)
			{
				aggr1.GetByIndex(j,val1);
				while (colums<j+1)
				{
					buf.Format(_T("%i"),colums);
					colums++;
					w=100;
					if(widths.GetSize()>colums) w=widths[colums];
					m_aggr_val.InsertColumn(colums,buf,LVCFMT_LEFT,w);
				}
				if(val1==0) continue;
				m_charact_mgr->PrintCharacteristicValue(val1,0,buf);
				m_aggr_val.SetItemText(row,j+1,buf);
			}
		}
		else
		{
			m_charact_mgr->PrintCharacteristicValue(val0,0,buf);
			m_aggr_val.SetItemText(row,1,buf);
		}
	}
}
//*****************************************************************
bool CTableValDlg::PointToVal(CPoint *point, int &i,int &j, CaplInstance **val, CaplInstance **unit,int &type)
{
	*val=0; *unit=0;
	type=-1;

	CaplInstance *unit1=0,*unit2=0;
	if(m_data->IsKindOf(m_unit,m_charact_mgr->e_apl_aggr_unit))
	{
		m_data->GetAttrBN(m_unit,_T("element_type"),unit1);
		if(m_data->IsKindOf(unit1,m_charact_mgr->e_apl_aggr_unit))
		{
			m_data->GetAttrBN(unit1,_T("element_type"),unit2);
			*unit=unit2;
			type=2;
		} else {*unit=unit1; type=1;}
	}
	else if(m_data->IsKindOf(m_unit,m_charact_mgr->e_table_unit)) type=3;
	else type=-1;

	if(point!=0)
	{
		i=-1;j=-1; 
		if(FALSE==m_aggr_val.IsWindowVisible()) return false;
		
		CRect rect;
		m_aggr_val.GetWindowRect(&rect);
		if(!rect.PtInRect(*point)) return false;

		CPoint m_point_context_menu=*point;
		m_aggr_val.ScreenToClient(&m_point_context_menu);
	
		//    header
		CHeaderCtrl*head= m_aggr_val.GetHeaderCtrl();
		head->GetWindowRect(&rect);
		if(rect.PtInRect(*point)) return false;

		LVHITTESTINFO lvhti;
		lvhti.pt = m_point_context_menu;
		m_aggr_val.SubItemHitTest(&lvhti);
		
		i=lvhti.iItem;
		if(i<0) return true;
		j=lvhti.iSubItem-1;
		if(j<0) return true;;
	}
	if(type<0) return false;
	i=m_aggr_val.GetItemData(i);
	if(i<0) return true;

	CaplAggr aggr,aggr1; CaplInstance* val_el;

	m_data->GetAttrBN(m_value,_T("values"),aggr);
	aggr.GetByIndex(i,val_el);
	if(type==2) // 
	{
		m_data->GetAttrBN(val_el,_T("values"),aggr1);
		aggr1.GetByIndex(j,val_el);					
	}
	else if(type==3) // 
	{
		m_data->GetAttrBN(val_el,_T("items"),aggr1);
		val_el=0;
		CaplInstance *cell,*column,*i_column=(CaplInstance*)m_ColumnListMap.GetByOut(j);
		if((long)i_column==-1)i_column=0;
		if(i_column)
		{
			m_data->GetAttrBN(i_column,_T("unit"),*unit);
			int k=0;
			while(k<aggr1.GetSize())
			{
				aggr1.GetByIndex(k,cell);
				k++;
				if(!cell) continue;
				if(m_data->IsKindOf(cell,m_charact_mgr->e_table_cell))
					m_data->GetAttr(cell,m_charact_mgr->a_table_cell_column,column);
				else
					m_data->GetAttr(cell,m_charact_mgr->a_table_cell_ver_column,column);
							
				if(column!=i_column) continue;
				if(m_data->IsKindOf(cell,m_charact_mgr->e_table_cell))
					m_data->GetAttr(cell,m_charact_mgr->a_table_cell_val,val_el);
				else
					m_data->GetAttr(cell,m_charact_mgr->a_table_cell_ver_val,val_el);
				break;
			}
		}
	}
	*val=val_el;
	return true;
}

//*****************************************************************
void CTableValDlg::PrintTableInList(CaplInstance *val)
{
	m_aggr_val.DeleteAllItems();
	if(val==0) return;
	if(!m_data->IsKindOf(val,m_charact_mgr->e_table_val)) 
		if(!m_data->IsKindOf(val,m_charact_mgr->e_table_val_ver)) 
			return;
	CString buf;
	int i,j,row=0,column=0;
	CaplInstance *val0,*val1,*val2;
	CaplAggr aggr0;
	if(m_data->IsKindOf(val,m_charact_mgr->e_table_val))
		m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_table_val,aggr0);
	else
		m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_table_val,aggr0);
	for(i=0;i<aggr0.GetSize();i++)
	{
		aggr0.GetByIndex(i,val0);
		if(val0==0) continue;
		row++;
		row=m_aggr_val.InsertItem(row,_T(""));
		buf.Format(_T("%3i"),row);
		m_aggr_val.SetItemText(row,0,buf);
		m_aggr_val.SetItemData(row,row);

		if(!m_data->IsKindOf(val0,m_charact_mgr->e_table_row)) 
			if(!m_data->IsKindOf(val0,m_charact_mgr->e_table_row_ver)) 
				continue;
		
		CaplAggr aggr1;
		if(m_data->IsKindOf(val0,m_charact_mgr->e_table_row)) 
			m_data->GetAttr(val0,m_charact_mgr->a_table_row_items,aggr1);
		else if(m_data->IsKindOf(val0,m_charact_mgr->e_table_row_ver))
			m_data->GetAttr(val0,m_charact_mgr->a_table_row_ver_items,aggr1);
		for(j=0;j<aggr1.GetSize();j++)
		{
			aggr1.GetByIndex(j,val1);
			if(val1==0) continue;
			CaplInstance *i_column;
			if(m_data->IsKindOf(val1,m_charact_mgr->e_table_cell))
				m_data->GetAttr(val1,m_charact_mgr->a_table_cell_column,i_column);
			else
				m_data->GetAttr(val1,m_charact_mgr->a_table_cell_ver_column,i_column);
			column=m_ColumnListMap.GetByIn((long)i_column);
			if(column==-1) column=0;
			if(column>=0)
			{
				if(m_data->IsKindOf(val1,m_charact_mgr->e_table_cell))
					m_data->GetAttr(val1,m_charact_mgr->a_table_cell_val,val2);
				else
					m_data->GetAttr(val1,m_charact_mgr->a_table_cell_ver_val,val2);
				m_charact_mgr->PrintCharacteristicValue(val2,0,buf,true);
				m_aggr_val.SetItemText(row,column+1,buf);
			}
		}
	}
}
//*****************************************************************
void CTableValDlg::OnSaveToFile() 
{
	if(m_aggr_val.IsWindowVisible()) apl_SaveListCtrlToFile(&m_aggr_val,0);
}
//*****************************************************************
void CTableValDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	if(m_ReadOnly) return;
	int i=0,j=0,type=0;
	CaplInstance *val=0, *unit=0;
	if(false==PointToVal(&point,i,j,&val,&unit,type)) return;

	if(type<1) return;

	bool is_value_ver=false;
	if(m_parent_value) 
	{
		if(m_data->IsKindOf(m_parent_value,m_charact_mgr->e_apl_charact_value_ver))
			is_value_ver=true;
	}
	else if(m_value)
	{
		if(m_data->IsKindOf(m_value,m_charact_mgr->e_apl_charact_value_ver))
			is_value_ver=true;
	}

	CaplAggr aggr,aggr1;
	CaplInstance *n_val=0,*val_el=0;
	m_data->GetAttrBN(m_value,_T("values"),aggr);
	if(i>=0)
	{
		if(type==2)
		{
			aggr.GetByIndex(i,val_el);
			m_data->GetAttrBN(val_el,_T("values"),aggr1);
		}
		if(type==3)
		{
			aggr.GetByIndex(i,val_el);
			m_data->GetAttrBN(val_el,_T("items"),aggr1);
		}
	}

    CaplMenu menu;CMenu* pPopup;
    VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
	CaplMenu::Install(this);

	pPopup = menu.GetSubMenu(type);
	switch(type)
	{
	case 1:
		if(val==0)
		{
			 pPopup->RemoveMenu(ID_AGGR_VALUE, MF_BYCOMMAND );
			 pPopup->RemoveMenu(ID_AGGR_DUP_VAL, MF_BYCOMMAND );
			 pPopup->RemoveMenu(ID_AGGR_DEL_VAL, MF_BYCOMMAND);
		}
		//else pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND);
		break;
	case 2:
		if(val==0)
		{
			pPopup->RemoveMenu(ID_AGGR_VALUE, MF_BYCOMMAND );
			pPopup->RemoveMenu(ID_AGGR_DEL_VAL, MF_BYCOMMAND);
		}
		//else pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND); 
		if(i<0)
		{
			pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGROFAGGR_LEFT, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGROFAGGR_RIGHT, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGR_VALUE, MF_BYCOMMAND );
			pPopup->RemoveMenu(ID_AGGR_DEL_VAL, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGR_DEL_ROW, MF_BYCOMMAND);
		}
		else
		{
			if(j<0) 
			{
				//pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND);
				pPopup->RemoveMenu(ID_AGGROFAGGR_LEFT, MF_BYCOMMAND);
				pPopup->RemoveMenu(ID_AGGROFAGGR_RIGHT, MF_BYCOMMAND);
			}
			else
			{
				if(j>=aggr1.GetSize()-1)
					pPopup->RemoveMenu(ID_AGGROFAGGR_RIGHT, MF_BYCOMMAND);
				if(j==0) pPopup->RemoveMenu(ID_AGGROFAGGR_LEFT, MF_BYCOMMAND);
			}
		}
		break;
	case 3:
		if(val==0)
		{
			pPopup->RemoveMenu(ID_AGGR_VALUE, MF_BYCOMMAND );
			pPopup->RemoveMenu(ID_AGGR_DEL_VAL, MF_BYCOMMAND);
		}
		else pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND); 
		if(i<0)
		{
			pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGR_VALUE, MF_BYCOMMAND );
			pPopup->RemoveMenu(ID_AGGR_DEL_VAL, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGR_DUP_ROW, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_AGGR_DEL_ROW, MF_BYCOMMAND);
		}
		else
		{
			if(j<0) 
			{
				pPopup->RemoveMenu(ID_AGGR_CREATE_VAL, MF_BYCOMMAND);
				pPopup->RemoveMenu(ID_AGGR_VALUE, MF_BYCOMMAND );
				pPopup->RemoveMenu(ID_AGGR_DEL_VAL, MF_BYCOMMAND);
			}
		}
		break;
	}

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON |TPM_RETURNCMD,	point.x, point.y,this); // use main window for cmds

	switch (type)
	{
	case 1: //  
		{
			switch(res)
			{
			case ID_AGGR_VALUE:EditVal(i,j,&val,unit); break;
			case ID_AGGR_CREATE_VAL:
				if(EditVal(i,j,&n_val,unit))
				{
					if((i>=0)&&(i<aggr.GetSize()))
					{
						CaplValue v; v.Set(n_val);
						aggr.Insert(i,v);
					}
					else aggr.Add(n_val);
					m_data->PutAttrBN(m_value,_T("values"),aggr);
				}
				break;
			case ID_AGGR_DUP_VAL:
				{
					if((i>=0)&&(i<aggr.GetSize()))
					{
						CaplInstance *new_item=0;
					    if(is_value_ver) new_item=m_charact_mgr->CreateCharValVersion(val,_T("-1"),false,true);
						else new_item=m_charact_mgr->CreateCopyCharacteristicVal(val,0);
						CaplValue v; v.Set(new_item);
						aggr.Insert(i,v);
					}
					else aggr.Add(n_val);
					m_data->PutAttrBN(m_value,_T("values"),aggr);
				}
				break;
			case ID_AGGR_DEL_VAL:
				m_changed_aggr=true;
				m_charact_mgr->DeleteCharacteristic(val);
				aggr.Remove(i);
				m_data->PutAttrBN(m_value,_T("values"),aggr);
				break;
			}
			PrintAggrInList(m_value);
		}
		break;
	case 2:  // AGGR OF AGGR
		{
			switch(res)
			{
			case ID_AGGR_INS_ROW:
				{
					CaplInstance *new_item=0;
					if(is_value_ver) new_item=m_data->CreateInstance(m_charact_mgr->e_aggr_val_ver);
					else new_item=m_data->CreateInstance(m_charact_mgr->e_aggr_val);
					if((i>=0)&&(i<aggr.GetSize()))
					{
						CaplValue v; v.Set(new_item);
						aggr.Insert(i,v);
					}
					else aggr.Add(new_item);
					m_changed_aggr=true;
					m_data->PutAttrBN(m_value,_T("values"),aggr);
				}
				break;
			case ID_AGGR_DEL_ROW:
				{
					if((i>=0)&&(i<aggr.GetSize()))
					{
						m_changed_aggr=true;
						CaplInstance *val_el;
						aggr.GetByIndex(i,val_el);
						m_charact_mgr->DeleteCharacteristic(val_el);
						aggr.Remove(i);
						m_data->PutAttrBN(m_value,_T("values"),aggr);
					}
				}
				break;
			case ID_AGGR_VALUE: EditVal(i,j,&val,unit); break;
			case ID_AGGR_CREATE_VAL:
				{
					if((i>=0)&&(i<aggr.GetSize()))
					{
						if(EditVal(i,j,&n_val,unit))
						{
							if((j>=0)&&(j<aggr1.GetSize()))
							{
								CaplValue v; v.Set(n_val);
								aggr1.Insert(j,v);
							}
							else aggr1.Add(n_val);
							m_data->PutAttrBN(val_el,_T("values"),aggr1);
						}
					}
				}
				break;
			case ID_AGGR_DEL_VAL:
				if((j>=0)&&(j<aggr1.GetSize()))
				{
					m_changed_aggr=true;
					m_charact_mgr->DeleteCharacteristic(val);
					aggr1.Remove(j);
					m_data->PutAttrBN(val_el,_T("values"),aggr1);
				}
				break;
			case ID_AGGROFAGGR_LEFT:
				if((i>=0)&&(i<aggr.GetSize()))
				{
					if((j>0)&&(j<aggr1.GetSize()))
					{
						m_changed_aggr=true;
						CaplValue *v=aggr1.aggr.Data[j-1];
						aggr1.aggr.Data[j-1]=aggr1.aggr.Data[j];
						aggr1.aggr.Data[j]=v;
						m_data->PutAttrBN(val_el,_T("values"),aggr1);
					}
				}
				break;
			case ID_AGGROFAGGR_RIGHT:
				if((i>=0)&&(i<aggr.GetSize()))
				{
					if((j>=0)&&(j<aggr1.GetSize()-1))
					{
						m_changed_aggr=true;
						CaplValue *v=aggr1.aggr.Data[j+1];
						aggr1.aggr.Data[j+1]=aggr1.aggr.Data[j];
						aggr1.aggr.Data[j]=v;
						m_data->PutAttrBN(val_el,_T("values"),aggr1);
					}
				}
				break;		
			}
			PrintAggrInList(m_value);
		}
		break;
	case 3: // 
		{
			switch(res)
			{
			case ID_AGGR_INS_ROW:
				{
					CaplInstance *new_item=0;
					if(is_value_ver) new_item=m_data->CreateInstance(m_charact_mgr->e_table_row_ver);
					else new_item=m_data->CreateInstance(m_charact_mgr->e_table_row);
					CaplValue v; v.Set(new_item);
					if((i>=0)&&(i<aggr.GetSize())) aggr.Insert(i,v);
					else aggr.Add(v);
					m_changed_aggr=true;
					m_data->PutAttrBN(m_value,_T("values"),aggr);
				}
				break;
			case ID_AGGR_DEL_ROW:
				{
					if((i>=0)&&(i<aggr.GetSize()))
					{
						m_changed_aggr=true;
						CaplInstance *val_el;
						aggr.GetByIndex(i,val_el);
						m_charact_mgr->DeleteCharacteristic(val_el);
						aggr.Remove(i);
						m_data->PutAttrBN(m_value,_T("values"),aggr);
					}
				}
				break;
			case ID_AGGR_VALUE: EditVal(i,j,&val,unit); break;
			case ID_AGGR_CREATE_VAL:
				{
					if((i>=0)&&(i<aggr.GetSize()))
					{
						if(EditVal(i,j,&n_val,unit))
						{
							CaplInstance *i_column=(CaplInstance*)m_ColumnListMap.GetByOut(j);
							if((long)i_column==-1)i_column=0;

							CaplInstance *ceel=0;
							if(is_value_ver) 
							{
								ceel=m_data->CreateInstance(m_charact_mgr->e_table_cell_ver);
								m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_ver_val,n_val);
								m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_ver_column,i_column);
							}
							else 
							{
								ceel=m_data->CreateInstance(m_charact_mgr->e_table_cell);
								m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_val,n_val);
								m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_column,i_column);
							}

							if((j>=0)&&(j<aggr1.GetSize()))
							{
								CaplValue v; v.Set(ceel);
								aggr1.Insert(j,v);
							}
							else aggr1.Add(ceel);
							m_data->PutAttrBN(val_el,_T("items"),aggr1);
						}
					}
				}
				break;
			case ID_AGGR_DEL_VAL:
				if((j>=0)&&(val!=0))
				{
					CaplInstance *i_column=(CaplInstance*)m_ColumnListMap.GetByOut(j);
					m_changed_aggr=true;
					m_charact_mgr->DeleteCharacteristic(val);
					if((long)i_column==-1)i_column=0;
					int k=0;
					while(k<aggr1.GetSize())
					{
						CaplInstance *cell,*column;
						aggr1.GetByIndex(k,cell);
						k++;
						if(!cell) continue;
						if(is_value_ver) m_data->GetAttr(cell,m_charact_mgr->a_table_cell_ver_column,column);
						else m_data->GetAttr(cell,m_charact_mgr->a_table_cell_column,column);
						if(column!=i_column) continue;
						aggr1.Remove(k-1);	
						m_data->DeleteInstance(cell);
						m_data->PutAttrBN(val_el,_T("items"),aggr1);
						break;
					}
				}
				break;
			case ID_AGGR_DUP_ROW:
				{
					CaplInstance *new_item=0;
					if(is_value_ver) new_item=m_charact_mgr->CreateCharValVersion(val_el,_T("-1"),false,true);
					else new_item=m_charact_mgr->CreateCopyCharacteristicVal(val_el,0);

					if((i>=0)&&(i<aggr.GetSize()))
					{
						CaplValue v; v.Set(new_item);
						aggr.Insert(i,v);
					}
					else aggr.Add(new_item);
					m_changed_aggr=true;
					m_data->PutAttrBN(m_value,_T("values"),aggr);
				}
				break;
			}
			PrintTableInList(m_value);
		}
		break;
	}	
}
//*****************************************************************
bool CTableValDlg::EditVal(int i,int j,CaplInstance **value, CaplInstance *unit)
{
	if(m_data==0) return false;
	if(value==0) return false;
	if(unit==0) return false;
	CaplInstance *val= *value;
	CString buf;
	bool is_value_ver=false;
	if(val!=0) 
	{
		if(m_data->IsKindOf(val,m_charact_mgr->e_apl_charact_value_ver))
			is_value_ver=true;
	}
	else if(m_value)
	{
		if(m_data->IsKindOf(m_value,m_charact_mgr->e_apl_charact_value_ver))
			is_value_ver=true;
	}
	else if(m_parent_value)
	{
		if(m_data->IsKindOf(m_parent_value,m_charact_mgr->e_apl_charact_value_ver))
			is_value_ver=true;
	}
	if(m_data->IsKindOf(unit,m_charact_mgr->e_apl_descript_unit))
	{
		CStrValueDlg dlg;
		if(val!=0) 
		{
			if(is_value_ver)
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_descr_val,dlg.m_val);
			else
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_descr_val,dlg.m_val);
		}
		if(dlg.DoModal()!=IDOK) return false;
		if(val==0) 
		{
			if(is_value_ver)
				val=m_data->CreateInstance(m_charact_mgr->e_descr_value_ver);
			else
				val=m_data->CreateInstance(m_charact_mgr->e_descr_value);
		}
		if(is_value_ver)
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_descr_val,dlg.m_val);
		else
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_descr_val,dlg.m_val);
	}
	else if(m_data->IsKindOf(unit,m_charact_mgr->e_apl_monetary_unit))
	{
		CMoneraryValDlg dlg;
		m_charact_mgr->GetUnitName(unit,dlg.m_unit_name);
		if(val!=0)
		{
			if(is_value_ver)
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_monet_val,dlg.m_val);
			else
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_monet_val,dlg.m_val);
		}
		if(dlg.DoModal()!=IDOK) return false;
		if(val==0)
		{
			if(is_value_ver)
				val=m_data->CreateInstance(m_charact_mgr->e_monet_value_ver);
			else
				val=m_data->CreateInstance(m_charact_mgr->e_monet_value);
		}
		if(is_value_ver)
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_monet_val,dlg.m_val);
		else	
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_monet_val,dlg.m_val);

	}
	else if(m_data->IsKindOf(unit,m_charact_mgr->e_apl_reference_unit))
	{
		CaplInstance *old_inst=0;
		if(val!=0)
		{
			if(is_value_ver)
				m_data->GetAttr(val,m_charact_mgr->a_apl_reference_val_ver_val,old_inst);
			else
				m_data->GetAttr(val,m_charact_mgr->a_apl_reference_val,old_inst);
		}
		CaplInstance *new_inst=m_charact_mgr->BrowseReferenceVal(unit);
		if(new_inst!=0)
		{
			if(val==0)
			{
				if(is_value_ver)
					val=m_data->CreateInstance(m_charact_mgr->e_apl_reference_value_ver);
				else
					val=m_data->CreateInstance(m_charact_mgr->e_apl_reference_value);
			}
			if(old_inst!=new_inst)
			{
				if(is_value_ver)
				{
					m_data->PutAttr(val,m_charact_mgr->a_apl_reference_val_ver_val,new_inst);
					//m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_unit,unit);
				}
				else
				{
					m_data->PutAttr(val,m_charact_mgr->a_apl_reference_val,new_inst);
					m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_unit,unit);
				}
			}
		}
	}
	else if(m_data->IsKindOf(unit,m_charact_mgr->e_apl_enum_unit))
	{
		CEnumValDlg dlg;
		if(val!=0)
		{
			if(is_value_ver)
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_enum_val,dlg.m_val);
			else
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_enum_val,dlg.m_val);
		}
		CaplAggr aggr;
		m_data->GetAttrBN(unit,_T("values"),aggr);
		for(int i=0;i<aggr.GetSize();i++)
		{
			if(aggr.GetByIndex(i,buf)) dlg.m_values.Add(buf);
		}
		if(dlg.DoModal()!=IDOK) return false;
		if(val==0)
		{
			if(is_value_ver)
				val=m_data->CreateInstance(m_charact_mgr->e_enum_value_ver);
			else
				val=m_data->CreateInstance(m_charact_mgr->e_enum_value);
		}
		if(is_value_ver)
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_enum_val,dlg.m_val);
		else
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_enum_val,dlg.m_val);
	}
	else if(m_data->IsKindOf(unit,m_charact_mgr->e_apl_time_unit))
	{
		CDataTimeDlg dlg;
		CString dt_s,dt_s1;
		if(val!=0) 
		{
			if(is_value_ver)
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_time_val_s,dt_s);
			else
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_time_val_s,dt_s);
		}
		aplString2Date(dt_s,dlg.m_dt);
		if(dlg.DoModal()!=IDOK) return false;
		aplDate2String(dlg.m_dt,dt_s1);
		if(dt_s!=dt_s1)
		{
			if(val==0) 
			{
				if(is_value_ver)
					val=m_data->CreateInstance(m_charact_mgr->e_time_val_ver);
				else
					val=m_data->CreateInstance(m_charact_mgr->e_time_val);
			}
			if(is_value_ver)
				m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_time_val_s,dt_s1);
			else
				m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_time_val_s,dt_s1);
		}
	}
	else if(m_data->IsKindOf(unit,m_charact_mgr->e_apl_step_unit))
	{
		CRealValueDlg dlg;
		if(val!=0)
		{
			if(is_value_ver)
			{
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_meas_val,dlg.m_val);
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_meas_max,dlg.m_max_dev);
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_ver_meas_min,dlg.m_min_dev);
			}
			else
			{
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_meas_val,dlg.m_val);
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_meas_max,dlg.m_max_dev);
				m_data->GetAttr(val,m_charact_mgr->a_apl_charact_val_meas_min,dlg.m_min_dev);
			}
		}
		m_charact_mgr->GetUnitName(unit,dlg.m_unit_name);
		if(dlg.DoModal()!=IDOK) return false;
		if(val==0) 
		{
			if(is_value_ver)
				val=m_data->CreateInstance(m_charact_mgr->e_meas_value_ver);
			else
				val=m_data->CreateInstance(m_charact_mgr->e_meas_value);
		}
		if(is_value_ver)
		{
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_meas_val,dlg.m_val);
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_meas_max,dlg.m_max_dev);
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_ver_meas_min,dlg.m_min_dev);
		}
		else
		{
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_meas_val,dlg.m_val);
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_meas_max,dlg.m_max_dev);
			m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_meas_min,dlg.m_min_dev);
		}
	}
	else if(m_data->IsKindOf(unit,m_charact_mgr->e_table_unit))
	{
		CTableValDlg dlg;

		dlg.m_data=m_data;
		dlg.m_charact_mgr=m_charact_mgr;
		dlg.m_value=val;
		dlg.m_unit=unit;
		dlg.m_ReadOnly=m_ReadOnly;

		//m_charact_mgr->GetUnitName(unit,dlg.m_unit_name);

		if(dlg.DoModal()!=IDOK) return false;
		
/*		if(val==0) val=m_data->CreateInstanceBN(e_meas_value);
		m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_meas_val,dlg.m_val);
		m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_meas_max,dlg.m_max_dev);
		m_data->PutAttr(val,m_charact_mgr->a_apl_charact_val_meas_min,dlg.m_min_dev);
*/
	
	}
	else return false;
	if(*value!=0)
	{
		CString buf;
		m_charact_mgr->PrintCharacteristicValue(val,0,buf,true);
		m_aggr_val.SetItemText(i,j+1,buf);
	}
	m_changed_aggr=true;
	*value=val;
	return true;
}
//*******************************************************************************
void CTableValDlg::OnCancel() 
{
	long wait_dlg=aplStartWaitDlg( APL_T("  ..."));
	if(m_old_value!=0)
	{
		CaplInstance *temp=m_value;
		m_value=m_old_value;
		m_old_value=temp;
	}
	else
	{
		//  
		if(m_value!=0)
		{
			if(m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val))
			{
				m_charact_mgr->DeleteCharacteristic(m_value);
				m_value=0;
			}
			else if(m_data->IsKindOf(m_value,m_charact_mgr->e_table_val))
			{
				m_charact_mgr->DeleteCharacteristic(m_value);
				m_value=0;
			}
		}
	}
	if(m_old_value) m_charact_mgr->DeleteCharacteristic(m_old_value);
	aplEndWaitDlg(wait_dlg);

	CResizableDialog::OnCancel();
}
//*******************************************************************************

void CTableValDlg::OnOK() 
{
	//  
	//long wait_dlg=aplStartWaitDlg(APL_T("  ..."));

	if(m_value!=0)
	{
		if(m_data->IsKindOf(m_value,m_charact_mgr->e_apl_charact_value_ver))
		{
	/*		if(m_data->IsKindOf(m_unit,m_charact_mgr->e_apl_aggr_unit))
			{
				if(m_old_value)
				{
					CaplAggr aggr0,aggr1;
					m_data->GetAttr(m_old_value,m_charact_mgr->a_apl_charact_val_aggr_val, aggr0);
					m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_aggr_val, aggr1);
					m_data->PutAttr(m_old_value,m_charact_mgr->a_apl_charact_val_aggr_val, aggr1);
					for(int i=0;i<aggr0.GetSize();i++){
						CaplInstance *t_inst;
						aggr0.GetByIndex(i,t_inst);
						if(!t_inst) continue;
						if(t_inst!=m_value) m_charact_mgr->DeleteCharacteristic(t_inst);
					}
					m_data->DeleteInstance(m_value);
					m_value=m_old_value;
				}
			}
			else if(m_data->IsKindOf(m_unit,m_charact_mgr->e_table_unit))
			{
				if(m_old_value)
				{
					int i;
					for(i=0;i<m_val_map.Size;i++)
					{
						if((CaplInstance*)(m_val_map[i].out)==m_value) continue;
						if(((CaplInstance*)(m_val_map[i].out))->GetType()==0) continue;
						((CaplInstance*)(m_val_map[i].out))->id=((CaplInstance*)(m_val_map[i].in))->id;
						((CaplInstance*)(m_val_map[i].in))->id=0;
					}
					CaplAggr aggr0,aggr1;
					m_data->GetAttr(m_old_value,m_charact_mgr->a_apl_charact_val_table_val, aggr0);
					m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_table_val, aggr1);
					m_data->PutAttr(m_old_value,m_charact_mgr->a_apl_charact_val_table_val, aggr1);
					for( i=0;i<aggr0.GetSize();i++){
						CaplInstance *t_inst;
						aggr0.GetByIndex(i,t_inst);
						if(!t_inst) continue;
						if(t_inst!=m_value) m_charact_mgr->DeleteCharacteristic(t_inst);
					}
					m_data->DeleteInstance(m_value);
					m_value=m_old_value;
				}
			}*/

			if(m_data->IsKindOf(m_unit,m_charact_mgr->e_apl_aggr_unit))
			{
				if(m_old_value)
				{
					CaplAggr aggr0,aggr1;
					
					if(m_charact_mgr->IsValueChanged(m_old_value,m_value)) 
					{
						m_data->GetAttr(m_old_value,m_charact_mgr->a_apl_charact_val_ver_aggr_val, aggr0);
						m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_ver_aggr_val, aggr1);
						m_data->PutAttr(m_old_value,m_charact_mgr->a_apl_charact_val_ver_aggr_val, aggr1);
					
					}
					else
						m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_ver_aggr_val, aggr0);
					for(int i=0;i<aggr0.GetSize();i++)
					{
						CaplInstance *t_inst;
						aggr0.GetByIndex(i,t_inst);
						if(!t_inst) continue;
						if(t_inst!=m_value) m_charact_mgr->DeleteCharacteristic(t_inst);
					}
					m_data->DeleteInstance(m_value);
					m_value=m_old_value;
					m_old_value=0;
				}
			}
			else if(m_data->IsKindOf(m_unit,m_charact_mgr->e_table_unit))
			{
				if(m_old_value)
				{
					CaplAggr aggr0,aggr1;
					if(m_charact_mgr->IsValueChanged(m_old_value,m_value)) 
					{
						m_data->GetAttr(m_old_value,m_charact_mgr->a_apl_charact_val_ver_table_val, aggr0);
						m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_ver_table_val, aggr1);
						m_data->PutAttr(m_old_value,m_charact_mgr->a_apl_charact_val_ver_table_val, aggr1);
					}
					else
						m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_ver_table_val, aggr0);

					for( int i=0;i<aggr0.GetSize();i++){
						CaplInstance *t_inst;
						aggr0.GetByIndex(i,t_inst);
						if(!t_inst) continue;
						if(t_inst!=m_value) m_charact_mgr->DeleteCharacteristic(t_inst);
					}
					m_data->DeleteInstance(m_value);
					m_value=m_old_value;
					m_old_value=0;
				}

			}
			else
			{
				if(m_data->IsKindOf(m_unit,m_charact_mgr->e_apl_aggr_unit))
				{
					if(m_old_value)
					{
						CaplAggr aggr0,aggr1;
						m_data->GetAttr(m_old_value,m_charact_mgr->a_apl_charact_val_aggr_val, aggr0);
						m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_aggr_val, aggr1);
						m_data->PutAttr(m_old_value,m_charact_mgr->a_apl_charact_val_aggr_val, aggr1);
						for(int i=0;i<aggr0.GetSize();i++){
							CaplInstance *t_inst;
							aggr0.GetByIndex(i,t_inst);
							if(!t_inst) continue;
							if(t_inst!=m_value) m_charact_mgr->DeleteCharacteristic(t_inst);
						}
						m_data->DeleteInstance(m_value);
						m_value=m_old_value;
					}
				}
				else if(m_data->IsKindOf(m_unit,m_charact_mgr->e_table_unit))
				{
					if(m_old_value)
					{
						int i;
						for(i=0;i<m_val_map.Size;i++)
						{
							if((CaplInstance*)(m_val_map[i].out)==m_value) continue;
							if(((CaplInstance*)(m_val_map[i].out))->GetType()==0) continue;
							((CaplInstance*)(m_val_map[i].out))->SetId(((CaplInstance*)(m_val_map[i].in))->GetId());
							((CaplInstance*)(m_val_map[i].in))->SetId(0);
						}
						CaplAggr aggr0,aggr1;
						m_data->GetAttr(m_old_value,m_charact_mgr->a_apl_charact_val_table_val, aggr0);
						m_data->GetAttr(m_value,m_charact_mgr->a_apl_charact_val_table_val, aggr1);
						m_data->PutAttr(m_old_value,m_charact_mgr->a_apl_charact_val_table_val, aggr1);
						for( i=0;i<aggr0.GetSize();i++){
							CaplInstance *t_inst;
							aggr0.GetByIndex(i,t_inst);
							if(!t_inst) continue;
							if(t_inst!=m_value) m_charact_mgr->DeleteCharacteristic(t_inst);
						}
						m_data->DeleteInstance(m_value);
						m_value=m_old_value;
					}
				}
			}
		}	
	}
	CResizableDialog::OnOK();
}
//*****************************************************************
void CTableValDlg::OnTop() 
{
	if(m_ReadOnly) return;
	CaplAggr aggr0;
	m_data->GetAttrBN(m_value,_T("values"),aggr0);

	if(FALSE==m_aggr_val.IsWindowVisible()) return ;
	int k=m_aggr_val.GetNextItem(0,LVNI_SELECTED);
	
	int k1=k-1;
	if(k<1) return;
	if(k>aggr0.GetSize()-1) return;
	k=m_aggr_val.GetItemData(k);
	if(k<0) return;
	
	k1=m_aggr_val.GetItemData(k1);
	if(k1<0) return;

	m_changed_aggr=true;
	CaplValue *v=aggr0.aggr.Data[k1];
	aggr0.aggr.Data[k1]=aggr0.aggr.Data[k];
	aggr0.aggr.Data[k]=v;
	m_data->PutAttrBN(m_value,_T("values"),aggr0);
	if(m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val) || m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val_ver)) PrintAggrInList(m_value);
	else if(m_data->IsKindOf(m_value,m_charact_mgr->e_table_val) || m_data->IsKindOf(m_value,m_charact_mgr->e_table_val_ver)) PrintTableInList(m_value);
	m_aggr_val.SetItemState(k-1,LVIS_SELECTED,-1);
}
//*****************************************************************
void CTableValDlg::OnBottom() 
{
	if(m_ReadOnly) return;
	CaplAggr aggr0;
	m_data->GetAttrBN(m_value,_T("values"),aggr0);

	if(FALSE==m_aggr_val.IsWindowVisible()) return ;
	
	int k=m_aggr_val.GetNextItem(-1,LVNI_SELECTED);
	int k1=k+1;
	
	if(k<0)  return;
	if(k>aggr0.GetSize()-2) return;
	
	k=m_aggr_val.GetItemData(k);
	if(k<0)  return;

	k1=m_aggr_val.GetItemData(k1);
	if(k1<0)  return;

	m_changed_aggr=true;
	CaplValue *v=aggr0.aggr.Data[k1];
	aggr0.aggr.Data[k1]=aggr0.aggr.Data[k];
	aggr0.aggr.Data[k]=v;
	m_data->PutAttrBN(m_value,_T("values"),aggr0);
	if(m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val) || m_data->IsKindOf(m_value,m_charact_mgr->e_aggr_val_ver)) PrintAggrInList(m_value);
	else if(m_data->IsKindOf(m_value,m_charact_mgr->e_table_val) || m_data->IsKindOf(m_value,m_charact_mgr->e_table_val_ver)) PrintTableInList(m_value);
	m_aggr_val.SetItemState(k+1,LVIS_SELECTED,-1);
}

//*****************************************************************
void CTableValDlg::OnDblclkAggrVal(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	*pResult = 0;

	if(m_ReadOnly) return;
	if(lpnmitem==0) return;
	
	int i=lpnmitem->iItem,j=lpnmitem->iSubItem-1,type=0;

	if(i<0) return;
	if(j<0) return;
	CaplInstance *val=0, *unit=0;

	if(false==PointToVal(0,i,j,&val,&unit,type)) return;

	if(unit==0) return;

	if(type==1) {EditVal(i,j,&val,unit); return;}

	CaplAggr aggr,aggr1;
	CaplInstance *n_val=0,*val_el=0;
	m_data->GetAttrBN(m_value,_T("values"),aggr);
	if(type==2)
	{
		if((i>=0)&&(i<aggr.GetSize()))
		{
			aggr.GetByIndex(i,val_el);
			m_data->GetAttrBN(val_el,_T("values"),aggr1);
			bool ins=false;
			if(val==0)
			{
//				if(IDYES!=AfxMessageBox(APL_T("  ?"),MB_YESNO|MB_ICONQUESTION))
//					return;
				ins = true;
			}
			if(EditVal(i,j,&val,unit))
			{
				if(ins)
				{
					if((j>=0)&&(j<aggr1.GetSize()))
					{
						CaplValue v; v.Set(val);
						aggr1.Insert(j,v);
					}
					else aggr1.Add(val);
					m_data->PutAttrBN(val_el,_T("values"),aggr1);
					PrintAggrInList(m_value);
				}
			}
		}
		return;
	}
	if(type==3)
	{
		if((i>=0)&&(i<aggr.GetSize()))
		{
			aggr.GetByIndex(i,val_el);
			m_data->GetAttrBN(val_el,_T("items"),aggr1);
			bool ins=false;
			if(val==0)
			{
//				if(IDYES!=AfxMessageBox(APL_T("  ?"),MB_YESNO|MB_ICONQUESTION))
//					return;
				ins = true;
			}
			if(EditVal(i,j,&val,unit))
			{
				if(ins)
				{
					CaplInstance *i_column=(CaplInstance*)m_ColumnListMap.GetByOut(j);
					if((long)i_column==-1)i_column=0;
					CaplInstance *ceel=0;

					if(m_data->IsKindOf(val,m_charact_mgr->e_apl_charact_value))
					{
						ceel=m_data->CreateInstance(m_charact_mgr->e_table_cell);
						m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_val,val);
						m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_column,i_column);
					}
					else
					{
						ceel=m_data->CreateInstance(m_charact_mgr->e_table_cell_ver);
						m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_ver_val,val);
						m_data->PutAttr(ceel,m_charact_mgr->a_table_cell_ver_column,i_column);
					}


					if((j>=0)&&(j<aggr1.GetSize()))
					{
						CaplValue v; v.Set(ceel);
						aggr1.Insert(j,v);
					}
					else aggr1.Add(ceel);
					m_data->PutAttrBN(val_el,_T("items"),aggr1);
					PrintTableInList(m_value);
				}
			}
		}
		return;
	}
}