// aplDocsView.cpp : implementation file
//

#include "stdafx.h"
#include "aplDocsView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplDocsView

IMPLEMENT_DYNCREATE(CaplDocsView, CaplPropsView)

CaplDocsView::CaplDocsView()
{
}

CaplDocsView::~CaplDocsView()
{
}


BEGIN_MESSAGE_MAP(CaplDocsView, CaplPropsView)
	//{{AFX_MSG_MAP(CaplDocsView)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplDocsView drawing

void CaplDocsView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CaplDocsView diagnostics

#ifdef _DEBUG
void CaplDocsView::AssertValid() const
{
	CaplPropsView::AssertValid();
}

void CaplDocsView::Dump(CDumpContext& dc) const
{
	CaplPropsView::Dump(dc);
}
#endif //_DEBUG

BOOL CaplDocsView::InitColumns(void)
{
	CListCtrl*	pList		=NULL;

	CString		csTxt[]		={ APL_T(""), APL_T(""), APL_T(""), APL_T(""), APL_T(""),
							   APL_T(""), APL_T("")};
	int			iSz[]		={100,150,100,100,100,100,100};

	int			i;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	for(i=0;i<sizeof(iSz)/sizeof(int);i++)
		pList->InsertColumn(i,csTxt[i],LVCFMT_LEFT,iSz[i]);

	long lStyles=::GetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE);
	lStyles|=LVS_SINGLESEL|LVS_SHOWSELALWAYS;
	::SetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE,lStyles);

	return TRUE;
}

void CaplDocsView::ChangeCtrlsState(void)
{
	CaplInstance*	cit	=NULL;

	POSITION pos		=NULL;

	CListCtrl*	pList	=NULL;

	BOOL	bEnAdd		=FALSE;
	BOOL	bEnDel		=FALSE;
	BOOL	bEnProps	=FALSE;

	int		ipos;

	if(!IsWindowVisible())
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	pos=pList->GetFirstSelectedItemPosition();
	if(NULL!=m_inst)
	{
		if(m_inst->GetAccessmode()<aplRO)
		{
			bEnAdd=TRUE;
			if(NULL!=pos)
			{
				ipos=pList->GetNextSelectedItem(pos);
				cit=(CaplInstance*)pList->GetItemData(ipos);
				if(m_api->m_data.IsMyInstance(cit, true))
				{
					if(cit->GetAccessmode()<aplRO)
						bEnDel=TRUE;
					bEnProps=TRUE;
				}
			}
			
		}
		else
		if(m_inst->GetAccessmode()==aplRO)
			if(NULL!=pos)
				bEnProps=TRUE;
	}

	m_pAdd->EnableWindow(bEnAdd);
	m_pDel->EnableWindow(bEnDel);
	m_pProps->EnableWindow(bEnProps);
}

BOOL CaplDocsView::LoadData(void)
{
	aplExtent	aet1,aet2;

	if(NULL==m_api)
		return TRUE;

	if(NULL==m_inst)
		return TRUE;

	if(false==m_api->m_doc_mgr.FindAssociatedDocuments(m_inst,m_aeItems,aet1))
		return FALSE;
	if(apidata.IsKindOf(m_inst,m_api->m_prd_mgr.e_apl_pdf))
	{
		CaplInstance*	cit	=NULL;
		if(false==apidata.GetAttr(m_inst,m_api->m_prd_mgr.a_pdf_prd,cit))
			return FALSE;
		if(false==m_api->m_doc_mgr.FindAssociatedDocuments(cit,aet2,aet1))
			return FALSE;
		m_aeItems.Append(aet2);
	}

	return TRUE;
}

BOOL CaplDocsView::_FillItem(int iPos,CaplInstance* ciIn)
{
	CaplInstance*		cit		=NULL;
	CaplInstance*		cit2	=NULL;

	CListCtrl*			pList	=NULL;

	COleDateTime		codt;

	CString				cst,cst2;

	int					i;

	if(NULL==m_api)
		return FALSE;

	if(NULL==ciIn)
		return FALSE;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	pList->SetImageList(aplGetInstImageList(),LVSIL_SMALL);

	if(pList->GetItemCount()<=iPos)
		iPos=pList->InsertItem(iPos,_T(""),m_api->GetInstIco(ciIn));

	for(i=0;i<pList->GetHeaderCtrl()->GetItemCount();i++)
		pList->SetItemText(iPos,i,_T(""));


	apidata.GetAttr(ciIn,m_api->m_doc_mgr.a_doc_id,cst);
	pList->SetItemText(iPos,0,cst);cst=_T("");

	apidata.GetAttr(ciIn,m_api->m_doc_mgr.a_doc_name,cst);
	pList->SetItemText(iPos,1,cst);cst=_T("");

	apidata.GetAttr(ciIn,m_api->m_doc_mgr.a_apl_doc_active,cit);
	if(NULL!=cit)
	{
		if(apidata.IsKindOf(cit,m_api->m_doc_mgr.e_apl_digital_document))
		{
			apidata.GetAttr(cit,m_api->m_doc_mgr.a_apl_doc_rev_id,cst);
			pList->SetItemText(iPos,2,cst);cst=_T("");
		}
	}

	apidata.GetAttr(ciIn,m_api->m_doc_mgr.a_doc_kind,cit);
	if(NULL!=cit)
	{
		apidata.GetAttr(cit,m_api->m_doc_mgr.a_dt_pdt,cst);
		pList->SetItemText(iPos,3,cst);cst=_T("");
	}

	apidata.GetAttr(ciIn,m_api->m_doc_mgr.a_apl_doc_lock,cit);
	if(NULL!=cit)
	{
		apidata.GetAttr(cit,m_api->m_doc_mgr.a_apl_doc_rev_user,cst);
		pList->SetItemText(iPos,4,cst);cst=_T("");

		apidata.GetAttr(cit,m_api->m_doc_mgr.a_apl_doc_rev_start_s,cst2);
		if(aplString2Date(cst2,codt))
			cst=codt.Format(_T("%d.%m.%Y %H:%M"));
		else
			cst=_T("");
		pList->SetItemText(iPos,5,cst);cst=_T("");

		apidata.GetAttr(cit,m_api->m_doc_mgr.a_apl_doc_rev_edit_path,cst);
		pList->SetItemText(iPos,6,cst);cst=_T("");
	}

	pList->SetItemData(iPos,(DWORD)ciIn);

	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
// CaplDocsView message handlers
void CaplDocsView::OnBAdd(void)
{
	CListCtrl*		pList	=NULL;

	CaplInstance*	cit		=NULL;

	if(0==m_inst->GetType())
		return;
	if(m_inst->GetAccessmode()>aplRO)
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	cit=m_api->m_doc_mgr.CreateDocument(NULL,NULL,NULL,NULL,NULL,true,m_inst);
	if(NULL!=cit)
	{
		_FillItem(m_aeItems.GetSize(),cit);
		m_aeItems.Add(cit);
	}
	
	ReSort();
}

void CaplDocsView::OnBDel(void)
{
	CaplInstance*	cit		=NULL;
	CaplInstance*	cit1	=NULL;

	aplExtent		aet;

	CListCtrl*		pList	=NULL;

	POSITION		pos		=NULL;

	int				i,iPos,iRet;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;
	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	iPos=pList->GetNextSelectedItem(pos);

	cit=(CaplInstance*)pList->GetItemData(iPos);
	if(NULL==cit)
		return;

	if(cit->GetAccessmode()>=aplRO)
	{
		AfxMessageBox( APL_T(" !"),MB_ICONSTOP|MB_OK);
		return;
	}

	iRet=AfxMessageBox( APL_T(" ?"),MB_ICONQUESTION|MB_YESNO);
	if(IDNO==iRet)
		return;

	cit1=m_api->m_doc_mgr.FindAssociation(m_inst,cit);
	if(NULL!=cit1)
		if(cit1->GetAccessmode()==aplOWN)
			if(true==apidata.DeleteInstance(cit1))
			{
				for(i=0;i<m_aeItems.GetSize();i++)
					if(cit==m_aeItems.GetAt(i))
					{
						m_aeItems.Remove(i);
						break;
					}

				pList->DeleteItem(iPos);
			}

	apidata.NET_SaveChanges( APL_T(" "));
}

void CaplDocsView::OnBProps(void)
{
	CaplInstance*	cit		=NULL;

	CListCtrl*		pList	=NULL;

	POSITION		pos		=NULL;

	int				iPos;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;
	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	iPos=pList->GetNextSelectedItem(pos);

	cit=(CaplInstance*)pList->GetItemData(iPos);
	if(NULL==cit)
		return;

	if(true==m_api->m_doc_mgr.ShowDocProperties(cit))
		_FillItem(iPos,cit);
}
