// aplStepManager.h

#pragma once

#include <StepData.h>
#include <aplNetStepData.h>
#include <apl_gui.h>
#include <aplCryptManager.h>
#include <aplpacket.h>
#include <map>
#include <list>
#include <vector>
//class CaplNetStepData;
//class CaplLoadData;
//class CaplQLQuery;

class CaplMgrPrgsDlg;
///////////////////////
//definies  //
///////////////////////
#define ICON_NULL 0
#define ICON_DESKTOP 1
#define ICON_FOLDERS 2
#define ICON_FOLDER 4
#define ICON_PERS_FOLDER 8
#define ICON_PERSON_LOCK_FOLDER 9
#define ICON_PERSON_LOCK_FOLDER_OPEN 10
#define ICON_VIRTUAL_DOC_FOLDER 11
#define ICON_CATEGORIES	12

#define ICON_CLASSIFIER_SYSTEM	ICON_CATEGORIES+2
#define ICON_CLASSIFIER_ELEMENT_M	ICON_CLASSIFIER_SYSTEM+2
#define ICON_CLASSIFIER_ELEMENT_S	ICON_CLASSIFIER_SYSTEM+3
#define ICON_CLASSIFIER_ELEMENT_M_DELETED ICON_CLASSIFIER_SYSTEM+4
#define ICON_CLASSIFIER_ELEMENT_S_DELETED ICON_CLASSIFIER_SYSTEM+5
#define ICON_CLASSIFIER_ELEMENT_M_ANALOGUE ICON_CLASSIFIER_SYSTEM+6
#define ICON_CLASSIFIER_ELEMENT_M_KIT ICON_CLASSIFIER_SYSTEM+7
#define ICON_CLASSIFIER_ELEMENT_S_ANALOGUE ICON_CLASSIFIER_SYSTEM+8
#define ICON_CLASSIFIER_ELEMENT_S_KIT ICON_CLASSIFIER_SYSTEM+9
#define ICON_FINAL_ITEM ICON_CLASSIFIER_SYSTEM+10
#define ICON_LSS_SYSTEM ICON_CLASSIFIER_SYSTEM+11
#define ICON_LSS_TASK	ICON_CLASSIFIER_SYSTEM+12
#define ICON_LSS_TASK_CHECK_OUT	ICON_CLASSIFIER_SYSTEM+13
#define ICON_LSS_TASK_DELETED	ICON_CLASSIFIER_SYSTEM+14
#define ICON_LSS_TASK_Z	ICON_CLASSIFIER_SYSTEM+15
#define ICON_LSS_TASK_Z_CHECK_OUT	ICON_CLASSIFIER_SYSTEM+16
#define ICON_LSS_TASK_Z_DELETED	ICON_CLASSIFIER_SYSTEM+17
#define ICON_LSS_FINAL_ITEM_TANK	ICON_CLASSIFIER_SYSTEM+18

#define ICON_APPR_INDEX					40
#define ICON_MSG_INDEX					60
#define ICON_DOC_INDEX					80
#define ICON_CHARACT_INDEX				100
#define ICON_INST_INDEX					120
#define ICON_ORGSTRUCT_INDEX			140
#define ICON_ALERT_INDEX				160
#define ICON_WF_INDEX					180
#define ICON_PRODUCT_INDEX				220
#define ICON_PRJ_INDEX					270
#define ICON_CONTINUE_INDEX				300
#define ICON_QUERY_INDEX				360
#define ICON_CONFIG_INDEX				400
#define ICON_STATICTREEITEMS_INDEX		420

#define ICON_MESSAGES ICON_MSG_INDEX+1
#define ICON_MESSAGES_LOST ICON_MSG_INDEX+3


#define ICON_APPROVAL	ICON_APPR_INDEX

#define ICON_DOCUMENT					ICON_DOC_INDEX
#define ICON_DOCUMENT_CHECKOUTED		ICON_DOCUMENT+2
#define ICON_DOCUMENT_REV				ICON_DOCUMENT+3
#define ICON_DOCUMENT_ACTIVE_REV		ICON_DOCUMENT+5
#define ICON_DOCUMENT_COPY				ICON_DOCUMENT+7
#define ICON_DOCUMENT_COPY_OUT_OF_DATE	ICON_DOCUMENT+8
#define ICON_DOCUMENT_MARKUP        	ICON_DOCUMENT+9
#define ICON_DOCUMENT_ACT				ICON_DOCUMENT+10
#define ICON_REQUIMENT					ICON_DOCUMENT+11
#define ICON_REQUIMENT_SEVERAL			ICON_DOCUMENT+12
#define ICON_REQUIMENT_NO_NEED			ICON_DOCUMENT+13
#define ICON_NOTE						ICON_DOCUMENT+14
#define ICON_NOTE_WITH_MARKUP			ICON_DOCUMENT+15
#define ICON_NOTE_EDIT					ICON_DOCUMENT+16

#define ICON_CHARACTERISTIC_GROUP ICON_CHARACT_INDEX
#define ICON_CHARACTERISTIC ICON_CHARACTERISTIC_GROUP+3

#define ICON_BP_RES		ICON_INST_INDEX
#define ICON_BP			ICON_BP_RES+1
#define ICON_BP_VERTICS	ICON_BP+4
#define ICON_BP_QM		ICON_BP_VERTICS+2
#define ICON_BP_INST	ICON_BP_QM+2
#define ICON_BP_INST_CO	ICON_BP_INST+2
#define ICON_REFUSAL	ICON_BP_INST_CO+4

#define ICON_LOT        ICON_PRODUCT_INDEX+1
#define ICON_PRD_INST   ICON_PRODUCT_INDEX+2
#define ICON_PROD       ICON_PRODUCT_INDEX+3

#define ICON_ZONE		ICON_PROD+1
#define ICON_SYSTEM		ICON_PROD+2
#define ICON_COMPONENT	ICON_PROD+3
#define ICON_MODULE		ICON_PROD+4
#define ICON_KOMPLEX    ICON_PROD+5
#define ICON_ASSEMBLY   ICON_PROD+6
#define ICON_PART       ICON_PROD+7
#define ICON_MATERIAL   ICON_PROD+8
#define ICON_KIT        ICON_PROD+9
#define ICON_OTHER      ICON_PROD+10

#define ICON_CHANGE   ICON_OTHER+1

#define ICON_PRD_DELTA_VERSION   30
#define ICON_PRD_DELTA_MATER     25
#define ICON_PRD_DELTA_MAKE      20
#define ICON_PRD_DELTA_ALTERNATE 15
#define ICON_PRD_DELTA_SUPLIED   10
#define ICON_PRD_DELTA_WHERE_USED 5


#define ICON_TASK            ICON_WF_INDEX+2
#define ICON_LOG_TASK        ICON_TASK+4
#define ICON_PROCESS         ICON_WF_INDEX+8
#define ICON_PROCESS_TMPL    ICON_WF_INDEX+10
#define ICON_ACTIVITY        ICON_WF_INDEX+11

#define ICON_PROJECT ICON_PRJ_INDEX+1

#define ICON_ORGANIZATION ICON_ORGSTRUCT_INDEX
#define ICON_OFFICIAL ICON_ORGANIZATION + 1
#define ICON_PERSON ICON_OFFICIAL + 1
#define ICON_ORGANIZATION_DELETE ICON_PERSON + 1 //  

#define ICON_ALERT ICON_ALERT_INDEX


#define ICON_QUERYES ICON_QUERY_INDEX
#define ICON_FIND ICON_QUERYES+1
#define ICON_QUERY			ICON_QUERY_INDEX+2
#define ICON_QUERY_SAVED	ICON_QUERY+1
#define ICON_QUERY_N		ICON_QUERY+2
#define ICON_QUERY_N_SAVED	ICON_QUERY+3
#define ICON_QUERY_Q		ICON_QUERY+4
#define ICON_QUERY_Q_SAVED	ICON_QUERY+5
#define ICON_COMB_TABLE		ICON_QUERY+6
#define ICON_COMB_TABLE_SAVED	ICON_QUERY+7

#define ICON_FILE			ICON_COMB_TABLE_SAVED+1

#define ICON_OPTION			ICON_CONFIG_INDEX
#define ICON_OPTION_VALUE	ICON_CONFIG_INDEX+1
#define ICON_RULE			ICON_CONFIG_INDEX+2
#define ICON_BASIS			ICON_CONFIG_INDEX+3
#define ICON_CONFIG			ICON_CONFIG_INDEX+4

#define ICON_CLIPBOARD		ICON_STATICTREEITEMS_INDEX

///////////////////////
//definies  //
///////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////
//                                 definies                         //
//////////////////////////////////////////////////////////////////////////////////////////////
#define ICO_REL_VER			1
#define ICO_REL_MATER		2
#define ICO_REL_MAKE		3
#define ICO_REL_ALTERNATE	4
#define ICO_REL_SUPLIED		5
#define ICO_REL_WHERE_USED	6
#define ICO_REL_ACTIVE_VER	7
#define ICO_REL_DEPEND_DOC	8
#define ICO_REL_WO_4NOTE	10
#define ICO_REL_RULE		11

#define ICO_EFF_NO			0
#define ICO_EFF_EFF			1
#define ICO_EFF_CON			2
#define ICO_EFF_EFFCON		3
#define ICO_EFF_NOT_USED	7
#define ICO_EFF_HIGH		8
#define ICO_EFF_NORMAL		9
#define ICO_EFF_LOW			10
#define ICO_EFF_LINK		14


#define ICO_STATE_WORKING 1
#define ICO_STATE_APPROVING 2
#define ICO_STATE_APPROVED 3
#define ICO_STATE_CHANGING 4
#define ICO_STATE_APPROVING_CHANGE 5
#define ICO_STATE_CANCELED 6
#define ICO_STATE_MUST_REVISION 7

#define ICO_SUBTYPE_NO 0
#define ICO_SUBTYPE_UNIFIED 1
#define ICO_SUBTYPE_HAS_REF 8


/////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                     //
//////////////////////////////////////////////////////////////////////////////////////////////

#define APL_NOT_TEST_POSSIBLE_STATES 1

//    
#define CHECK_ZERO_ATTR(par1,par2) par1=par2;m_AllAttrDefined&=(par1!=0);
//     .      
#define a_access_form a_apl_doc_rev_access_form


#ifdef APL_STEP_MGR_IMPL
#define CLASS_DECL_APL_STEP_MGR  _declspec(dllexport)
#else
#define CLASS_DECL_APL_STEP_MGR  _declspec(dllimport)
#endif


#define API_DLG_TEST if(m_api==0) {EndDialog(0); return FALSE;}

/**      */
int AFX_EXT_API aplState2Ico(LPCTSTR state, int default_ico=-1);



/**      */
bool AFX_EXT_API aplSelectDateTime(COleDateTime &odt, const TCHAR *title=0);

/**      */
bool AFX_EXT_API aplGetStringValue(CString &val);

/**          
		@param m_data    
		@param ext  
		@param left	,     
		@param right ,     
		@param date_attr ,    
		@return true    */
bool AFX_EXT_API aplSortByDate(CaplNetStepData* m_data, aplExtent &ext, int left, int right, CaplAttr* date_attr);
bool AFX_EXT_API aplSortByDate(CaplNetStepData* m_data, aplExtent &ext, int left, int right, CaplAttr* date_attr1, CaplAttr* date_attr2);

int AFX_EXT_API aplQFindInstInExtentByAttr(CaplNetStepData* m_data, aplExtent &ext, CaplAttr* attr, CaplValue *val, bool full_cycle = true);
/**        
		@param m_data    
		@param ext  
		@param left	,     
		@param right ,     
		@param attr ,    
		@return true    */
bool AFX_EXT_API aplQSortByAttr(CaplNetStepData* m_data, aplExtent &ext, int left, int right, CaplAttr* attr);
/**    ,    2   )  ,  
	 pdf   product.id (pdf->of_product->id;      aplINSTANCE
		@param m_data    
		@param ext  
		@param left	,     
		@param right ,     
		@param attr1 ,    
		@param attr2 ,    
		@return true    */
bool AFX_EXT_API aplQSortByAttr(CaplNetStepData* m_data, aplExtent &ext, int left, int right, CaplAttr* attr1, CaplAttr* attr2);

/**       ( ,    
		@param m_data    
		@param ext  
		@param attr1  ,    
		@param attr2  ,     ( ,     )
		@param attr3  ,     ( ,       )
		@param attr4  ,    
		@param attr5  ,    
		@return true    */
bool AFX_EXT_API aplQSortByMultiAttr(CaplNetStepData* m_data, aplExtent &ext, CaplAttr* attr1, CaplAttr* attr2=0, CaplAttr* attr3=0, CaplAttr* attr4=0, CaplAttr* attr5=0);


//   2    ,        (,   )
int AFX_EXT_API aplCompare2StringAsClassifier(CString &str1, CString &str2);

/** 
	     
		@return      */
CString AFX_EXT_API GetMyDocPath();

CImageList AFX_EXT_API *aplGetInstImageList();
CImageList AFX_EXT_API *aplGetRelImageList();
CImageList AFX_EXT_API *aplGetEffImageList();
CImageList AFX_EXT_API *aplGetStateImageList();
CImageList AFX_EXT_API *aplGetObjStateImageList();
CImageList AFX_EXT_API *aplGetItemSubtypeImageList();
CImageList AFX_EXT_API *aplGetTabCtrlImageList();


#ifndef APL_NO_INSET_IN_DOC
//   
class CaplOldSelInstItem
{
public:
	CaplOldSelInstItem(CaplOldSelInstItem *parent, CaplInstance *inst)
	{
		m_parent=parent;
		m_inst=inst;
		m_item=0;
	};
	CaplOldSelInstItem *m_parent;
	CaplInstance *m_inst;
	HTREEITEM m_item;
};

typedef CaplTAggr <CaplOldSelInstItem*, CaplOldSelInstItem*, APLAGGR_UNIQUE|APLAGGR_LIST|APLAGGR_AUTOKILLREF> TUAKListPCaplOldSelInstItem;
#endif

class CaplAPI;
class CDocCopyFilter;

// llback   selectinst
typedef bool (*fnValidateInst)(CaplAPI *, aplExtent&);
typedef bool (*fnValidateInst2)(CaplAPI *, aplExtent&, DWORD data);

/**    API*/
class CLASS_DECL_APL_STEP_MGR CaplStepManager
{
public:
	CaplStepManager(); /**< */
	~CaplStepManager();

	// Attributes
	CaplNetStepData *m_data;
	CaplAPI *m_api;

	static void SaveGlobalParams();  //      
	static void LoadGlobalParams();

#ifndef APL_NO_INSET_IN_DOC

	TUAKListPCaplOldSelInstItem m_old_items;
#endif

	//WFState
	
	CaplEntity *e_wf_state_history;
	CaplAttr *a_wf_new_state;
	CaplAttr *a_wf_old_state;
	CaplAttr *a_wf_date;
	CaplAttr *a_wf_item;
	CaplAttr *a_wf_user;

	//Notes
	CaplEntity *e_note;
	CaplAttr *a_note_item;
	CaplAttr *a_note_author;
	CaplAttr *a_note_date;
	CaplAttr *a_note_source;
	CaplAttr *a_note_descr;
	CaplAttr *a_note_parent;
	CaplAttr *a_note_markup;
	CaplAttr *a_note_date_revocation;
	CaplAttr *a_note_approval;
	CaplAttr *a_note_nohide;

	/**@name  */
	//@{
	/**         (  true)*/
	bool m_AutoSave;
	
	/**     " " c  SaveChanges  .     (  true)*/
	bool m_AutoUsurpire;

	/**        (  true)*/
	//bool m_ModeInteractive;  03.05.2006     m_api->m_ModeInteractive

	static bool m_bUseVersions; /**<  */

	/**      1 */
	int m_MaxItemsLoad;

	/** true ,     entity  */
	bool m_AllAttrDefined;
	
	/** true ,    */
	bool m_TestUnique;

	/**   ,    */
	bool *m_bContinue;

	//@}


	/**@name  ( ) */
	//@{
	CaplEntity *e_pd_context; /**<product_definition_context */
	CaplAttr *a_pd_context_name;/**<product_definition_context -> name */
	CaplAttr *a_pd_context_life_cycle_stage;/**<product_definition_context -> life_cycle_stage */
	//@}

	/**@name  ( )  -  CaplAutorizationManager */ 
	//@{
//	CaplEntity *e_user;		/**<apl_user */
//	CaplAttr *a_user_name;	/**<apl_user -> name */
//	CaplAttr *a_user_po;	/**<apl_user -> personality */
	//@}

	/**@name  ( ) */
	//@{
	CaplEntity *e_alt_bidir;					/**<alternate_product_relationship_bidirect */
	CaplAttr *a_alt_bidir_type;					/**<alternate_product_relationship_bidirect -> type */
	CaplAttr *a_alt_bidir_type_descr;			/**<alternate_product_relationship_bidirect -> type_descr */
	CaplAttr *a_alt_bidir_reserved;				/**<alternate_product_relationship_bidirect -> reserved */
	CaplAttr *a_alt_base_pdf;					/**<alternate_product_relationship_bidirect -> base_pdf */
	CaplAttr *a_alt_alt_pdf;					/**<alternate_product_relationship_bidirect -> alt_pdf */
	CaplAttr *a_alt_alt_interchange_type;		/**<alternate_product_relationship_bidirect -> interchange_type */
	//@}

	// Methods
	/**   (    ) 
	    @return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach(); /**    < */
	

	/**     
		@param  SelectMode         
				
		  APL_MODE_SELECT_CATEGORY			-   <br>
		  APL_MODE_SELECT_FOLDER			-   <br>
		  APL_MODE_SELECT_PRD				-    <br>
		  APL_MODE_SELECT_PDF				-    <br>
		  APL_MODE_SELECT_DOC				-   <br>
		  APL_MODE_SELECT_BP				-   -<br>
		  APL_MODE_SELECT_CHARACT			-   -<br>
		  APL_MODE_SELECT_CHARACT_REVISION	-    -<br>
		  APL_MODE_SELECT_DOC_REVISION		-    <br>
		  APL_MODE_SELECT_BP_REVISION		-    -<br>
		  APL_MODE_SELECT_CATEG_REVISION	-    -<br>
		  APL_MODE_SELECT_ORG				-    <br>
		  -- APL_MODE_SELECT_PERSON			-   ,    <br>
		  -- APL_MODE_SELECT_PERSORG		-       ,    <br>

		@param  title     
		@param  base_items     
		
		@return   	*/
	CaplInstance *SelectInstance(long SelectMode, const TCHAR *title=0, aplExtent *base_items=0, fnValidateInst fn = NULL);
	CaplInstance *SelectInstanceEx(long SelectMode, const TCHAR *title=0, aplExtent *base_items=0, fnValidateInst fn = NULL);
	bool SelectInstanceEx(long SelectMode, aplExtent &res, const TCHAR *title=0, aplExtent *base_items=0, fnValidateInst fn = NULL);
	CaplInstance *SelectInstanceEx2(long SelectMode, const TCHAR *title=0, aplExtent *base_items=0, fnValidateInst2 fn = NULL, DWORD data = NULL);
	bool SelectInstanceEx2(long SelectMode, aplExtent &res, const TCHAR *title=0, aplExtent *base_items=0, fnValidateInst2 fn = NULL, DWORD data = NULL);
	
	//     
	// SelectMode   SelectInstance
	// ext -  
	// title -  
	// list title -  
	// sprav - ,   0,     
	//  true,    "OK",  false,  ""
	bool EditExtent(long SelectMode, aplExtent &ext, const TCHAR *title=0, const TCHAR *list_title=0, CaplInstance *sprav=0);

	#define APL_MODE_SELECT_CATEGORY			0x00000001
	#define APL_MODE_SELECT_FOLDER				0x00000002
	#define APL_MODE_SELECT_PRD					0x00000004
	#define APL_MODE_SELECT_PDF  				0x00000008
	#define APL_MODE_SELECT_DOC  				0x00000010
	#define APL_MODE_SELECT_BP					0x00000020
	#define APL_MODE_SELECT_LOT					0x00000040
	#define APL_MODE_SELECT_PRDINST				0x00000080
	#define APL_MODE_SELECT_DOC_REVISION		0x00000100
	#define APL_MODE_SELECT_BP_REVISION			0x00000200
	#define APL_MODE_SELECT_CATEG_REVISION		0x00000400
	#define APL_MODE_SELECT_PROJECT				0x00000800
	
	#define APL_MODE_SELECT_ORG					0x00001000
	#define APL_MODE_SELECT_PERSORG				0x00002000
	#define APL_MODE_SELECT_PERSON				0x00004000
	#define APL_MODE_SELECT_OFFICIAL			0x00008000
	#define APL_MODE_SELECT_BPINST				0x00010000   //  , ..  
	#define APL_MODE_SELECT_CHANGE				0x00020000
	#define APL_MODE_SELECT_CLASSIF_SYSTEM		0x00040000
	#define APL_MODE_SELECT_CLASSIF_ELEMENT		0x00080000
			
	#define APL_MODE_SELECT_CHARACT				0x00100000
	#define APL_MODE_SELECT_CHARACT_REVISION	0x00200000
	#define APL_MODE_SELECT_USER				0x00400000
	#define APL_MODE_SELECT_USER_GROUP			0x00800000
	#define APL_MODE_SELECT_BP_RES				0x01000000
	#define APL_MODE_SELECT_ORDER				0x02000000
	#define APL_MODE_SELECT_REQUIREMENT			0x04000000

	#define APL_MODE_SELECT_DBLCLICK			0x08000000  //     

	#define APL_MODE_SELECT_MULTY				0x10000000
	#define APL_MODE_HIDE_TOOLBAR				0x20000000	//   
	#define APL_MODE_HIDE_ASSOCIATED_DOCS		0x40000000	//    
	#define APL_MODE_NO_RESTORE					0x80000000	//    

	/**      item 
	    @return true     false    */
	bool GetItemName(CaplInstance * item, CString &buf);

	/**       ,   ext 
	    @return true     false    */
	bool LoadExtentInfo(aplExtent &ext);

	/**@name    */
	//@{

	/**        
	    @return true     false    */
	bool LoadContextInfo();

	/**      
		   
	    @return true     false    */
	bool ChangeItemContext(aplExtent &ext);

	/**    ,  devider */
	void Split(const CString &str, CString devider, std::vector<CString> &result, bool bParseAsCsv = false);

	/**        
	    @return true     false    */
	bool PrintItemContextInString(CaplInstance *item,CString &buf);

	/**       aggr  
	    @return true     false    */
	bool PrintItemContextInString(aplExtent &ext,CString &buf);

	/**    item    context 
	    @return true    false   */
	bool IsItemInContext(CaplInstance *item, CaplInstance *context, CaplAttr *attr=0);
	
	/**  extent ext_in     ext_context.
		attr -   ,    ext_in.
		   ext_out.
	    @return true     false    */
	bool FilterExtentByContext(aplExtent &ext_in, aplExtent &ext_contexts, aplExtent &ext_out, CaplAttr *attr=0);
	//@}
	
	/** ,      
	    @return true    false   */
	bool IsAdmin();
	
	/** ,     
		@param bIsSystemAdmin -  true,   .  =     
	    @return true    false   */
	bool IsAdmin(CaplInstance* pUser, bool* bIsSystemAdmin=NULL);
	
/**   
		@param bLoadFromDB -       
	    @return   NULL,    */
	CaplInstance* GetAdminGroup(bool bLoadFromDB=false);

	/**   "all" ( )
		@return ,    ,    */
	CaplInstance* GetAllUsersGroup();

	/** ,     
		@return   NULL,     */
	CaplInstance* GetCurrentPerson();

	/**  ,       .
	   @param status -    (out)
	   @param doc_types -     (out)
	   @param contexts -    (out)
	   @return true -      false   */
	
	/**   
		@param inst  (,     )
		@param nState  
		@param flag  0,  ,  ,   APL_NOT_TEST_POSSIBLE_STATES,    
		@return     */
	CaplInstance* ChangeWFState(CaplInstance *inst, const TCHAR *nState, UINT flag = 0);

	/**   .    .   . 
		@param ext   (,     )*/
	bool ChangeWFState(aplExtent &ext);
	
	/**   ,     
		@param inst  (,     )
		@param states  
		@return   */
	CString GetPossibleWFState(CaplInstance *inst, CStringArray &states);

	/**           */
	CString TranslateMkState(const CString &state);

	/**    
		@param inst  (,     )*/
	bool ShowWFStateHistory(CaplInstance *inst);

	/**	     
		@param state   
		@return  */
	static CString GetWFStateName(CString state);
	
	/**	     
		@param state   
		@return  */
	static CString GetWFStateNameEng(CString state);

	/**	   
		@param inst     
		@param parent       
		@return true      false    */
	bool CreateNote(CaplInstance *inst, CaplInstance *parent = NULL, CaplInstance **ciNote = NULL);
	
	/**	  
		@param inst 
		@param ciNote       
		@reurn true      false   */
	bool ShowNotes(CaplInstance *inst, CaplInstance *ciNote=NULL, bool bShowTree=true);

	/**	  
		@param ciNote 
		@reurn true      false   */
	bool ShowNote(CaplInstance *ciNote, bool bReadOnly=true);

	//  
	bool DeleteNote(CaplInstance *ciNote);

	/**	  
		@param inst      
		@paran notes  */
	bool FindAssociatedNotes(CaplInstance *inst, aplExtent &notes);
	
	/**	  CaplRichEditCtrl     
		@param richedit   CaplRichEditCtrl
		@param inst 
		@return true     false   */
	bool SetRTFToRichEdit(CaplRichEditCtrl *richedit, CaplInstance *inst);
	
	CaplInstance* FindContextByName(LPCTSTR sName);

	bool GetListTopLevelEntities(TUListPEntity &list_entities);


public:

	CaplEntity* e_apl_object_locker;
	CaplAttr* a_apl_object_locker_item; //  
	CaplAttr* a_apl_object_locker_user; //  
	CaplAttr* a_apl_object_locker_description; // 


	/**	   
	@param pInst  
	@return NULL   */
	CaplInstance* FindLockInstance(const CaplInstance* pInst);

	/**	     
	@param pInst  
	@return true  */
	bool IsInstanceLocked(const CaplInstance* pInst);

	/**	 
	@param pInst  
	@param pUser 
	@param message  
	@return      */
	CaplInstance* SetInstanceLocked(const CaplInstance* pInst, const CaplInstance* pUser, const CString& description = _T("")  );

	/**	 
	@param pInst  
	@return      */
	bool SetInstanceUnLocked(const CaplInstance* pInst );

	/**	    
	@param pInst 
	@param pUser 
	@param message  
	@return true  */
	bool GetLockInfo(const CaplInstance* pInst, CaplInstance** ppUser, CString *pDescription /* = NULL */ );

};

// *************************************************************************
// *************************************************************************
//    !!
/**  */
class CLASS_DECL_APL_STEP_MGR CaplCategoryManager: public CaplStepManager
{
public:
	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	// Attributes

	/**@name product_category ( ) */
	//@{
	CaplEntity *e_categ;				/**<product_category */
	CaplAttr *a_categ_id;				/**<product_category -> id */
	CaplAttr *a_categ_name;				/**<product_category -> name */
	CaplAttr *a_categ_descr;			/**<product_category -> description */
	CaplEntity *e_prd_rel_prd_categ;	/**<product_related_product_category */
	CaplAttr *a_categ_products ;		/**<product_related_product_category -> products */
	CaplAttr *a_categ_charact;			/**<product_related_product_category -> characteristics*/
	CaplAttr *a_categ_all_charact;		/**<product_related_product_category -> all_characteristics*/
	//@}

	/**@name product_category_relationship ( ) */
	//@{
	CaplEntity *e_categ_rel;			/**<product_category_relationship */
	CaplAttr *a_categ_rel_category;		/**<roduct_category_relationship -> category */
	CaplAttr *a_categ_rel_sub_category; /**<product_category_relationship -> sub_category */
	//@}

	/**@name  ( ) */
	//@{
	// 
	CaplEntity *e_apl_product_category_ver; /**<apl_product_category_version */
	CaplAttr *a_categ_ver_categ;			/**<apl_product_category_version -> category */
	CaplAttr *a_categ_ver_id;				/**<apl_product_category_version -> id */
	CaplAttr *a_categ_ver_name;				/**<apl_product_category_version -> name */
	CaplAttr *a_categ_ver_descr;			/**<apl_product_category_version -> description */
	CaplAttr *a_categ_ver_products;			/**<apl_product_category_version -> products */
	CaplAttr *a_categ_ver_author;			/**<apl_product_category_version -> author */
	CaplAttr *a_categ_ver_start;			/**<apl_product_category_version -> start_date */
	CaplAttr *a_categ_ver_end;				/**<apl_product_category_version -> end_date */
	CaplAttr *a_categ_ver_num;				/**<apl_product_category_version -> number */
	CaplAttr *a_categ_ver_prev;				/**<apl_product_category_version -> previous */
	CaplAttr *a_categ_act;					/**<product_category -> active_version */
	CaplAttr *a_categ_lock;					/**<product_category -> locker */
	//@}
	
	CaplEntity* e_categ_content;
	CaplAttr* a_categ_content_id;
	CaplAttr* a_categ_content_content;
	CaplAttr* a_local_query_name;

	CaplEntity* e_local_query;
	CaplAttr* a_local_query_text;
	CaplAttr* a_local_query_person;
	CaplAttr* a_local_query_date;

	// 
public:

	/**          
		@param load_products - true, ec      
		@return true     false    */
	bool Load(bool load_products=false);

	/**          
		@param bLoadPrdInfo - true,         */
	bool LoadCategoryInfo(CaplInstance *categ, bool bLoadPrdInfo= false);
	
	/**      ext     
		@param bLoadPrdInfo - true,         */
	bool LoadCategoryInfo(aplExtent &ext, bool bLoadPrdInfo= false);

	/**         NULL       */
	CaplInstance *FindCateg(const TCHAR *id);


	/**@name   */
	//@{
	// **************************************************
	//  
	// **************************************************

	//*************************************************************
	/**    ext    categ 
		@param categ  .  categ == 0 ,    
		@param ext    
		@param recursive        
		@param load_prd          
		@return true     false    */
	bool GetAllSubCategory(CaplInstance *categ, aplExtent &ext, bool recursive=false, bool load_prd=false);
	
	/**    ext    categ 
		@param categ  .  categ == 0 ,    
		@param ext    
		@param rel    
		@param recursive        
		@param load_prd          
		@return true     false    */
	bool GetAllSubCategory2(CaplInstance *categ, aplExtent &ext, aplExtent &rels, bool recursive=false, bool load_prd=false);
	
	/**   ext      categ 
		@return true     false    */
	bool GetAllParentCategory(CaplInstance *categ, aplExtent &ext);

	/**   sub   base 
		@return true     false    */
	bool InsertSubCategory(CaplInstance *base, CaplInstance *sub);

	/**   sub   base 
		@return true     false    */
	bool RemoveSubCategory(CaplInstance *base, CaplInstance *sub);

	/**   
		@param id  
		@param descr  
		@return    NULL    */
	CaplInstance *CreateCategory(const TCHAR *id, const TCHAR *name, const TCHAR *descr);

	/**     
		@param id    
		@param name    
		@param descr    
		@return true     false    */
	bool GetCategoryAttr(CaplInstance *categ, CString &id, CString &name, CString &descr);

	/**       
		@return true     false    */
	bool RemoveCategory(CaplInstance *categ);

	/**   
		@return true     false   
		*/
	bool RefreshRootCategories();
	//@}

	/**@name    */
	//@{

	// **************************************************
	//   
	// **************************************************

	/**   ext     categ
		 all==true =>      
		@param bLoadPrdInfo - true,         
		@return true     false    */
	bool GetCategoryContents(CaplInstance *categ, aplExtent &ext, bool all=false, bool bLoadPrdInfo= false);


	/**      
		@param categ 
		@param is_hide_move_button
		@param redraw
		@return true     false    */	
	bool MakeTable(CaplInstance *categ,bool is_hide_move_button=true,bool *redraw=0);

	/**  true,  prd   categ
		 all==true =>      */
	bool FindProductInCategory(CaplInstance *prd, CaplInstance *categ,bool all=false);

	/**  prd  categ 
		@return true     false    */
	bool AddPrdToCategory(CaplInstance *prd, CaplInstance *categ,bool bLoadCategInfo=true);

	/**  prd  categ 
		@return true     false    */
	bool RemovePrdFromCategory(CaplInstance *prd, CaplInstance *categ,bool bLoadCategInfo=true);

	/**   ext  ,   prd 
		@return true     false    */
	bool GetProductCategories(CaplInstance *prd, aplExtent &ext);
	
	/**   
		@param categ  . 
		@return true     false    */
	bool CategoryHistory(CaplInstance *categ);

	//@}
	
	/**@name  */
	//@{

	// **************************************************
	// 
	// **************************************************
	
	/**     */
	bool CheckOut( CaplInstance *categ);

	/**      */
	bool CheckIn( CaplInstance *categ,bool make_new_version_active=true);

	/**            */
	CaplInstance *GetLock(CaplInstance *categ, bool bShowMessages);

	/**     ,         */
	CaplInstance *CheckMyLock(CaplInstance *categ, bool bShowMessages);

	/**   */
	bool UndoCheckOut( CaplInstance *categ);

	/**     
		@param categ 
		@param outExt     ()
		@return true     false    */
	bool GetAllCategoryVersion(CaplInstance *categ,aplExtent &outExt);

	/**          .
		@param categ - 
		@param inExt -   (    );
		@param outExt -   (     )
		@return 1 -    , 0        .*/
	int IsProductsInCategory(aplExtent &categ, aplExtent &inExt, aplExtent &outExt);
	
	/**        ""    
		@param categ    
		@param num   
		@param make_active      
		@return      0    */
	CaplInstance *CaplCategoryManager::CreateCategoryVersion(CaplInstance *categ,CString num,bool make_active=true);
	/**    
		@param categ  - 
		@return true     false    */
	bool MakeCategoryVersionActive(CaplInstance *categ_ver);
	//@}
};


// *************************************************************************
// *************************************************************************
// *************************************************************************
/**  */
#define APL_DOC_DEPENDENCE _T("depend")
#define APL_DOC_RELATION _T("relation")
#define APL_DOCUMENT_RELATION 1
#define APL_DOCUMENT_DEPENDENCE 2

#define APL_SETACTIVEVER 1

#define APL_COPY_DOCS 0
#define APL_CHECKOUT_DOCS 1
#define APL_PRINT_DOCS 2

#define APL_SHOW_REV_HISTORY 0
#define APL_SHOW_OWNER_HISTORY 1

class CDocCopyFilter
{
public:
	CDocCopyFilter() {m_id=_T("");m_doc=0;m_owner=0;m_place_of_use=0;m_state=_T("");m_date_begin=_T("");m_date_end=_T("");m_b_only_out_of_order=true;};
	~CDocCopyFilter(){};
	CString m_id;
	CaplInstance *m_doc;
	CaplInstance *m_owner;
	CaplInstance *m_place_of_use;
	CString m_state;
	CString m_date_begin;
	CString m_date_end;
	BOOL m_b_only_out_of_order;
};
class mymsiMap;
class CLASS_DECL_APL_STEP_MGR CaplDocManager: public CaplStepManager
{
	// 
private:
	BOOL m_lastflag;
public:
	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	static BOOL m_bUseAplMarkView;

	// Attributes
protected:
	BOOL GetLastFlag();
	aplExtent m_service_ext;
	bool m_service_ext_lock;
public:	
	CaplEntity *e_apl_doc_ref;					///<     
	CaplAttr *a_apl_doc_ref_item;				///< 
	CaplAttr *a_apl_doc_ref_inner_label;		///<  (    )
	CaplAttr *a_apl_doc_ref_doc;				///< 
	CaplAttr *a_apl_doc_ref_src;				
	CaplAttr *a_doc_rel_frames_of_reference;	///< 
	CaplAttr *a_apl_doc_ref_type;				///<  
	CaplAttr *a_apl_doc_ref_start_date;				///<  
	CaplAttr *a_apl_doc_ref_end_date;	

	CaplEntity *e_doc;					///< 
	CaplAttr *a_doc_id;					///<  
	CaplAttr *a_doc_name;				///<  
	CaplAttr *a_doc_descr;				///<  
	CaplAttr *a_doc_kind;				///<  
	CaplAttr *a_doc_code;				///<  
	CaplAttr *a_doc_authentic;			///<   
	CaplAttr *a_doc_add_dt_code;		///<    
	CaplAttr *a_doc_code_depend_desp;	///<       
	CaplAttr *a_doc_struct_kind;		///<   
	CaplAttr *a_doc_incl_in_doc;		///<   
	CaplAttr *a_doc_format;				///< 
	CaplAttr *a_doc_sheets;				///< 
	CaplAttr *a_doc_total_sheets_count;	///< 
	CaplAttr *a_doc_total_sheets_count_a4;	 ///<     4
	CaplAttr *a_doc_litera;				///< 
	CaplAttr *a_doc_part;				///< 
	CaplAttr *a_doc_accept_archive_date;	///<    
	CaplAttr *a_doc_released_by;			///<  
	CaplAttr *a_doc_accept_approval;		///<      
	CaplAttr *a_doc_pdf_code;				///<  
	CaplAttr *a_doc_is_dublicate;			///<  
	CaplAttr *a_doc_dublicate_inv_num;		///<   
	CaplAttr *a_doc_subst_inv_num;			///<   
	CaplAttr *a_doc_inv_num;				///<  
	CaplAttr *a_doc_mail_list;				///<  
	CaplAttr *a_doc_src_item;				///<     (  - )
	CaplAttr *a_doc_guid;	
	CaplAttr *a_doc_external_ref;           ///<    

	CaplAttr *a_doc_from;		// 
	CaplAttr *a_doc_to;			//   (  a_doc_recipients)
	CaplAttr *a_doc_recipients;	// 
	CaplAttr *a_doc_urgency;						// 
	CaplAttr *a_doc_date;							//  
	CaplAttr *a_doc_date_of_execution_required;		//   
	CaplAttr *a_doc_of_execution_planned;			//   
	CaplAttr *a_doc_of_execution_fact;				//   


	CaplEntity *e_dt;				///<  
	CaplAttr *a_dt_pdt;				///<   
	CaplAttr *a_dt_id;				///<   
	CaplAttr *a_dt_entries; 		///<   
	CaplAttr *a_dt_sort_num;		///<   
	CaplAttr *a_dt_auth_formats;	///<  
	CaplAttr *a_dt_basis;			///< 
		
	CaplEntity *e_dt_entry;			///<  
	CaplAttr   *a_dt_entry_opt;		///<     
	CaplAttr   *a_dt_entry_status;	///<  ,   
	CaplAttr   *a_dt_entry_entry;	///<   

	CaplEntity *e_doc_entry_val;		///<   
	CaplAttr   *a_doc_entry_val_val;	///< 
	CaplAttr   *a_doc_entry_val_prev;	///<   
	CaplAttr   *a_doc_entry_val_entry;	///< 
	CaplAttr   *a_doc_entry_val_stored; ///<     
	CaplAttr   *a_doc_entry_val_descr;	///< 

	CaplEntity *e_entry;			// 
	CaplAttr   *a_entry_id;			//  
	CaplAttr   *a_entry_name;		//  
	CaplAttr   *a_entry_descr;		//  
	CaplAttr   *a_entry_basis;		//    
	CaplAttr   *a_entry_val;		//  
	CaplAttr   *a_entry_card_field; //    

	CaplEntity *e_apl_doc;			///<  PSS
	CaplAttr *a_apl_doc_wf_state;
	CaplAttr *a_apl_doc_active;		///<   
	CaplAttr *a_apl_doc_lock;		///<  
	CaplAttr *a_apl_doc_system;		///< C  
	CaplAttr *a_apl_doc_inner_label;		///<  (    )
	CaplAttr *a_apl_doc_reg_num;	///<   (   )
	CaplAttr *a_apl_doc_reg_type;	///<  (, , )    
	CaplAttr *a_ils_doc_type;		///<  (  )

	CaplEntity *e_apl_doc_rev;		///<  
	CaplAttr *a_apl_doc_rev_id;		///<   
	CaplAttr *a_apl_doc_rev_doc;	///<   
	CaplAttr *a_apl_doc_rev_label;
	CaplAttr *a_apl_doc_rev_format;
	CaplAttr *a_apl_doc_rev_litera;
	CaplAttr *a_apl_doc_rev_descr;
	CaplAttr *a_apl_doc_rev_crc;
	CaplAttr *a_apl_doc_rev_base;
	CaplAttr *a_apl_doc_rev_start_s;
	CaplAttr *a_apl_doc_rev_end_s;
	CaplAttr *a_apl_doc_rev_user;
	CaplAttr *a_apl_doc_rev_autor;
	CaplAttr *a_apl_doc_rev_edit_path;
	CaplAttr *a_apl_doc_rev_access_form;
	CaplAttr *a_apl_doc_rev_char_val_versions;
	CaplAttr *a_apl_doc_rev_pictures;
	CaplAttr *a_apl_doc_rev_entries;
	CaplAttr *a_apl_doc_rev_sheets;				///<  
	CaplAttr *a_apl_doc_rev_total_sheets;		///<    
	CaplAttr *a_apl_doc_rev_total_sheets_count_a4;	 ///<     4
	CaplAttr *a_apl_doc_rev_src_doc_ver;		///<       
	CaplAttr *a_apl_doc_rev_inner_label;		///<  (    )
	CaplAttr *a_apl_doc_rev_it_needs_work;		///  -  

	CaplAttr *a_apl_doc_rev_src_author;
	CaplAttr *a_apl_doc_rev_src_date;
	CaplAttr *a_apl_doc_rev_language;
	CaplAttr *a_apl_doc_rev_stored_on; ///<  ,         

	CaplAttr *a_apl_doc_rev_gen_by_software;
	CaplAttr *a_apl_doc_rev_lss_dic_ver;

	CaplEntity *e_apl_digital_document;

	CaplEntity *e_apl_stored_document;
	CaplAttr *a_apl_stored_document_file_name, *a_apl_stored_document_source;
	CaplAttr *a_apl_stored_document_code;

	CaplEntity *e_apl_assigned_document;
	CaplAttr *a_apl_assigned_document_location_path;

	CaplEntity *e_apl_doc_change;
	CaplAttr *a_apl_doc_change_id,*a_apl_doc_change_name,*a_apl_doc_change_descr,*a_apl_doc_change_user,*a_apl_doc_change_person;
	CaplAttr *a_apl_doc_change_doc,*a_apl_doc_change_old,*a_apl_doc_change_new,*a_apl_doc_change_date_s;
	CaplAttr *a_apl_doc_change_attachment, *a_apl_doc_change_basis;

	CaplEntity *e_dt_group;			///<   
	CaplAttr *a_dt_group_id;		///<    
	CaplAttr *a_dt_group_name;		///<    
	CaplAttr *a_dt_group_descr;		///<    
	CaplAttr *a_dt_group_par;		///<      
	CaplAttr *a_dt_group_content;	///<    

	CaplEntity *e_doc_copy;			///<  
	CaplAttr *a_doc_copy_id;
	CaplAttr *a_doc_copy_state;
	CaplAttr *a_doc_copy_first_rev;
	CaplAttr *a_doc_copy_cur_rev;
	CaplAttr *a_doc_copy_issue_date;
	CaplAttr *a_doc_copy_last_update;
	CaplAttr *a_doc_copy_owner;
	CaplAttr *a_doc_copy_place_of_use;
	CaplAttr *a_doc_copy_doc;
	CaplAttr *a_doc_copy_pur_order;
	CaplAttr *a_doc_copy_real_state;	///<    
	CaplAttr *a_doc_copy_who;			///<  ,     
	CaplAttr *a_doc_copy_destroy_act;	///<       ,     

	CaplEntity*		e_apl_order_issue;				///<   -
	CaplAttr*		a_apl_order_issue_order;		///<  -
	CaplAttr*		a_apl_order_issue_shop;			///<  
	CaplAttr*		a_apl_order_issue_date;			///< 
	CaplAttr*		a_apl_order_issue_doc_number;	///<      
	CaplAttr*		a_apl_order_issue_reciever;		///<   
	CaplAttr*		a_apl_order_issue_document;		///<   
	
	CaplEntity	*e_doc_copy_order;			///< -    
	CaplAttr	*a_purchase_order_els;		///<  -
	CaplAttr	*a_purchase_order_id;		///<  -
	CaplAttr	*a_purchase_order_order;	///<   (  -)
	CaplAttr	*a_purchase_order_code;		///< 
	CaplAttr	*a_purchase_order_introd;	///<   
	CaplAttr	*a_purchase_order_descr;	///< 
	CaplAttr	*a_purchase_order_date;		///<   
	CaplAttr	*a_purchase_order_cust;		///< 
	CaplAttr	*a_purchase_order_type;		///<   (   ,   )
	CaplAttr	*a_purchase_order_hc;		///<    (   )
	CaplAttr	*a_purchase_order_of_change;///< ,    -

	CaplEntity	*e_order_elem;				///<  -
	CaplAttr	*a_order_elem_count;		///<   
	CaplAttr	*a_order_elem_doc;			///<    
	CaplAttr	*a_order_elem_order;		///<   -

	CaplEntity *e_doc_copy_rev_change;	///<     
	CaplAttr *a_doc_copy_rev_change_doc_change;
	CaplAttr *a_doc_copy_rev_change_author;
	CaplAttr *a_doc_copy_rev_change_apply_date;
	CaplAttr *a_doc_copy_rev_change_hard_copy;

	CaplEntity *e_doc_copy_owner_change;	///<  
	CaplAttr *a_doc_copy_owner_change_basis;
	CaplAttr *a_doc_copy_owner_change_hand_date;
	CaplAttr *a_doc_copy_owner_change_new_owner;
	CaplAttr *a_doc_copy_owner_change_new_place_of_use;
	CaplAttr *a_doc_copy_owner_change_hard_copy;
	
	CaplEntity *e_apl_xml_index;	///  
	CaplAttr *a_apl_xml_index_cur_doc_rev;
	CaplAttr *a_apl_xml_index_lps_system;
	CaplAttr *a_apl_xml_index_sys_id;
	CaplAttr *a_apl_xml_index_type;
	CaplAttr *a_apl_xml_index_id;
	CaplAttr *a_apl_xml_index_name;
	CaplAttr *a_apl_xml_index_name_eng;
	CaplAttr *a_apl_xml_index_type_name;
	CaplAttr *a_apl_xml_index_config_info;
	CaplAttr *a_apl_xml_index_ref_guid;
	CaplAttr *a_apl_xml_index_cfg;

//	CaplEntity *e_apl_xml_index_relation;	///  
//	CaplAttr *a_apl_xml_index_relation_relating;
//	CaplAttr *a_apl_xml_index_relation_related;

	CStringArray m_sel_doc_types_names;
	// 
private:
	/**   avred,     ,   
		   " "   AutoVue 
		( 2D/3D   )
		@param doc **/
	bool DeleteAvred(CaplInstance *doc);	
public:

	/**@name  */
	//@{

	/**       
		@param doc_or_revision    
		@param item_rel      
		@return true     false    */ 
	bool ShowDocProperties(CaplInstance *doc_or_revision, CaplInstance* item_rel=0);

	/**    
		@pDocument - ,   
		@bReadOnly -   
		@bOffset -       */
	bool ShowCardAccount(CaplInstance *pDocument, bool bReadOnly);

	/**     */
	CString GetDefaultMailList(CaplInstance *pDocument) const;

	/**  ( )  "_3\\ "*/
	bool CreateDefaultPdfSeriesOption() const;

	/**  ( )  "_3\\   "*/
	bool CreateDefaultInventoryBookSearchNumberOption() const;

	/**    
		@param doc_copy  
		@return true     false    */ 
	bool ShowDocCopyProperties(CaplInstance *doc_copy);

	/**       
		@param filter       */
	void ShowAllDocCopyes(CDocCopyFilter *filter=0);
	
	/**       */
	bool LoadDictionary();

	/**        (id)  NULL,    .*/
	CaplInstance *FindDocById(const TCHAR *id);

	/**         (id)  NULL,    .*/
	CaplInstance *FindDocRevById(CaplInstance *doc, const TCHAR *id);

	/**        (id)  nbge  NULL,    .*/
	CaplInstance *FindDocByIdAndType(const TCHAR *id, CaplInstance *doc_type);

	/**      GUID  ( )*/
	CaplInstance *FindDocByGUID(const TCHAR *s_guid);

	/**        (  )*/
	CaplInstance *GetLastDocumenrRevision(CaplInstance *doc);

	/**           (type)  NULL,    .*/  
	CaplInstance *GetDocumentTypeBN(const TCHAR *type);

	/**           (id)  NULL,    .*/  
	CaplInstance *GetDocumentTypeByID(const TCHAR *id);

	/**   buf     
		@param doc_or_revision    
		@param buf     
		@return true     false    */ 
	bool GetFileName(CaplInstance *doc_or_revision, CString &buf);

	/**   buf    ( )
		@param doc_or_revision    
		@param buf     
		@return true     false    */ 
	bool GetFullFileName(CaplInstance *doc_or_revision, CString &buf);

	/**             
	@param selected_doc_type      
	@param selected_group     
	@param m_show_all_doc  true -    .  false -      
	@param b_select_group  true,   
	@return instance   ,  0 */ 
	CaplInstance *SelectDocType(CaplInstance *selected_doc_type=0,CaplInstance *selected_group=0,bool m_show_all_types=false, bool b_select_group=false);

	/**    ext_dt    
	@param bRecursive   true,    
	@return true     false    */ 
	bool GetAllDocTypeInGroup(CaplInstance *group, aplExtent &ext_dt, bool bRecursive);


	//@}

	// *************************************************************************
	//  
		// doc_or_revision -    
		// path -  
		// 	  ,     
		//     (  '\') -    
		//    NULL -  
	// *************************************************************************

		/**@name    */
		//@{

	/**     ( -  ==0 -   ) 
		@param id  
		@param name  
		@param descr  
		@param type  
		@param path    
		@param stored true       
		@param item     
		@param created_rel   item  
		@param bAlwaysShowDlg  true -   
		 false,      
		@return    
		 -    ,      */
	CaplInstance *CreateDocument(const TCHAR *id, const TCHAR *name, const TCHAR *descr,
		CaplInstance *type, const TCHAR *path, bool stored=true, CaplInstance *item=0, CaplInstance **created_rel=0,
		UINT apl_type = APL_DOCUMENT_RELATION, bool bAlwaysShowDlg=false, bool bShowCRCCalcDlg = true, LPCTSTR sFormat=0);


	/**      
		@param doc 
		@param path    
		@param stored true         
		 false,      
		@param set_active true       	 false   
		@param base_rev      
		@param bShowDlg     
		@return   */
	CaplInstance *CreateDocumentRevision(CaplInstance *doc,
		const TCHAR *path, bool stored=true, bool set_active=false, CaplInstance *base_rev=0, bool bShowDlg=false);
	
	/**          
		@param path     
		@param stored true       
		 false,      
		@return   */
	CaplInstance *CreateFile(const TCHAR *path, bool stored=true);

	/**        
		@param rev   
		@param make_change true    
		@param show_dlg true,    
		@return   */
	CaplInstance *CreateChange(CaplInstance *rev, bool make_change=true, bool show_dlg = true, bool bLSS = false);

	/**    
		@param doc 
		@return true */
	bool ShowDocChanges(CaplInstance *doc);

	/**           RO 
		@param doc_or_revision    
		@param path    <br>
		 	<ol>   ,      </ol>
			<ol>    (  '\') -     </ol>
			<ol>   NULL -  </ol>
		@param iUseSubDoc +1,     , -1,   , 0,   
		@return   */
	bool LoadRevision(CaplInstance *doc_or_revision, const TCHAR *path, int iUseSubDoc=0,bool bSetRO=true);

	/**             RO 
		@param doc_or_revisions     
		@param path   ,      <br>
			<ol>     -      </ol>
			<ol>   NULL -   </ol>
		@param names -   ,     .       
		@param bUseSubDoc - true,      
		@return   */
	bool LoadMultyRevisions(aplExtent doc_or_revisions, const TCHAR *path,CStringArray &names, bool bUseSubDoc=false,bool bSetRO=true);

	bool CopyDocsOnDisk(aplExtent &docs, CString &defpath, int mode = APL_COPY_DOCS);

	/**       RO   
		c      ,       
		@param doc_or_revision    
 		@param show_app_dlg true,     
		@param iUseSubDoc +1,     , -1,   , 0,   
		@return true     false    */
	bool View(CaplInstance *doc_or_revision, bool show_app_dlg=false, int iUseSubDoc=0 );

	//      
	//       -  .   bOpenInNewProcess== true -   
	// bOpenInNewProcess:  0 -  , 1 -  , -1 -  shift
	bool ViewWithMarkView(CaplInstance *doc_or_revision, int bOpenInNewProcess=-1);


	//   std c  
	bool ViewESI(CaplInstance *doc_or_revision);

	/**       RO   
		c      ,       
		@param doc_or_revision    
 		@param show_app_dlg true,     
		@return true     false    */
	bool Print(CaplInstance *doc_or_revision, bool show_app_dlg=false);

	/**    (doc - )
		 bAlwaysShowDlg ->    
		@param doc  
		@param path   .    ,    
		@param set_active true       	 false   
		@param bAlwaysShowDlg      (      ).
				true    false   
		@param bIgnoreState - true,     
		@param bCharact - true,      
		@return true     false    */
	bool CheckIn(CaplInstance *doc, const TCHAR *path, bool set_active=false, bool bAlwaysShowDlg=false, bool bUseSubDoc=false, bool bIgnoreState = false,bool bCharact = true, bool bLoadInfo = true, bool bLSS = false);
	
	/**          (doc - )
		@param bShowMsg       
		@return true    false     */
	bool TestMakeVersionActive(CaplInstance *doc,bool bShowMsg=false);

	/**    (doc - )
		 bAlwaysShowDlg ->    
		@param doc  
		@param path   .    ,    
		@param set_active true       	 false   
		@param bAlwaysShowDlg      (      ).
				true    false   
		@param bIgnoreState - true,     
		@return true     false    */
	bool CheckInEx(CaplInstance *doc, const TCHAR *path, bool set_active=false, bool bAlwaysShowDlg=false, bool bUseSubDoc=false, bool bIgnoreState = false);

	/**     
		@param doc 
		@param path   
		@param set_active true         false   
		@param bSetRO true    "  ".
		@param bIgnoreState - true,     
		@param bIgnoreState - true,     
		@return true     false    */
	bool CheckInOut(CaplInstance *doc, const TCHAR *path, bool bSetActive=false, bool bSetRO = false, bool bAlwaysShowDlg=false, bool bUseSubDoc=false, bool bIgnoreState = false);

	/**       
		  c     
		@param doc_or_revision    
		@param path   .    ,    
 		@param show_app_dlg true,     
		@param bIgnoreState - true,     
		@return true     false    */
	bool Edit(CaplInstance *doc_or_revision, const TCHAR *path,bool show_app_dlg=false, bool bUseSubDoc= false, bool bIgnoreState = false);

	int CheckForCheckOut(CaplInstance* doc_or_revision);

	/**     
		@param doc_or_revision    
		@param path   .    ,    
		@param bAlwaysShowDlg      (      ).
		true    false   
		@param bUseSubDoc - true,      
		@param bIgnoreState - true,     
		@param bIgnoreState - true,     
		@param bCharact - true,       
		@param bGenNewName - true,           
		@param bLoadInfo - true,        
		@return true     false    */
	bool CheckOut(CaplInstance *doc_or_revision, const TCHAR *path, bool bAlwaysShowDlg=false, bool bUseSubDoc=false, bool bIgnoreState = false, bool bCharact = true, bool bGenNewName = false, bool bLoadInfo = true);
	
	/**      
		@param ext_doc_or_revision     
		@param path   .    ,    
		@param bAllMustCheckOut false              
		@param ext_doc_or_revision     
		@param pCheckOutExt     ,   ,   NULL.
		true    false   
		@param bUseSubDoc - true,      
		@return true     false    */
	bool MultiCheckOut(aplExtent &ext_doc_or_revision, const TCHAR *path, CStringArray& filenames, bool bAllMustCheckOut = true,aplExtent * pCheckOutExt = 0, bool bAlwaysShowDlg=false, bool bUseSubDoc=false);
	
	/**        
		@param doc_or_revision    
		@param path   .    ,    
		@param bAlwaysShowDlg      (      ).
		true    false   
		@param bUseSubDoc - true,      
		@param bIgnoreState - true,     
		@return true     false    */
	bool CheckOutEx(CaplInstance *doc_or_revision, const TCHAR *path, bool bAlwaysShowDlg =false, bool bUseSubDoc =false, bool bIgnoreState = false);

	/**    
		@param doc 
		@param bIgnoreState - true,     
		@param bCharact - true,      
 		@return true     false    */
	bool UndoCheckOut(CaplInstance *doc, bool bUseSubDoc=false, bool bIgnoreState = false, bool bCharact = true, bool bFromDB = true);
	
	/**    
		@param doc 
		@param bIgnoreState - true,     
 		@return true     false    */
	bool UndoCheckOutEx(CaplInstance *doc, bool bUseSubDoc=false, bool bIgnoreState = false);

	/**  (doc - ) 
		@param doc 
 		@return true     false    */
	bool DeleteDoc(CaplInstance *doc);

	/**   
		@param rev    
		@param delete_doc        - true.             -  
		@return true     false    */
	bool DeleteRevision(CaplInstance *rev, bool delete_doc = false, bool bLoadInfo = true, bool bAdditionalCheck = true);

	/**    /
		@param ciItem     
		@return true     false    */
	bool DeleteAssociatedEntries(CaplInstance *ciItem);
	
	/**   
		@param doc_copy    
		@return true     false    */
	bool DeleteDocHardCopy(CaplInstance *doc_copy);

	/**        
		@param doc_copy   
		@param author  ,  
		@param doc_change    '' 
		@param apply_date   
		@return true     false    */
	bool ApplyHardCopyRevChanges(CaplInstance *doc_copy,CaplInstance *author=0,CaplInstance *doc_change=0,const TCHAR *apply_date=0);
	
	/**  ,    
		@param doc_copy   
		@return true     false    */
	bool ShowHardCopyRevChanges(CaplInstance *doc_copy);

	/**     
		@param doc_copy   
		@return true     false    */
	bool ShowHardCopyOwnerChanges(CaplInstance *doc_copy);
	//@}

	HANDLE RunFile(const TCHAR *file, bool bShowAppDlg = false);
	//     
	bool AfterSaveDocumentFile(CaplInstance *doc, LPCTSTR lpszFileName);

	// *************************************************************************
	//   
	// *************************************************************************

	/**@name   */
	//@{

	/**    
		@param sEntryName   */
	CaplInstance* GetEntryBN(LPCTSTR sEntryName);
	
	/**   (  )   ()  
		@param ciRev   ( ,   )
		@param sEntryName   */
	CaplInstance* GetEntryValBN(CaplInstance *ciRev, LPCTSTR sEntryName, bool bLoadInfo = true);
	
	/**  (  )   ()   ""
		@param ciRev   ( ,   )
		@param bLoadInfo    
		@param Entry */
	CaplInstance* GetEntryVal(CaplInstance *ciRev, CaplInstance *Entry, bool bLoadInfo = true);
	
	/**  (  )    
		@param ciRev   ( ,   )
		@param Entry 
		@param bLoadInfo    
		@param value    
		*/
	bool GetEntryVal(CaplInstance *ciRev, CaplInstance *Entry,  CString &Value, bool bLoadInfo = true);

	/**  (  )    
		@param ciRev   ( ,   )
		@param EntryName  
		@param bLoadInfo    
		@param value    
		*/	
	bool GetEntryValBN(CaplInstance *ciRev, LPCTSTR EntryName, CString &Value, bool bLoadInfo = true);


	/**      
		@param ciActRev   
		@param ciItem ,    */
	bool CreateDefaultEntries(CaplInstance *ciActRev, CaplInstance *ciItem = NULL);

	/**   (  )  
	@param ciItem -   
	@param aeResult -  
	*/
	bool GetActualEntriesVal(CaplInstance *ciItem, aplExtent &aeResult);
	
	/**        
		@param ciRev	   
		@param bLoadFromBase    
		@param sMisingEntry  ,     */
	bool HasAllNecessaryEntries(CaplInstance *ciRev, bool bLoadFromBase = true, CString *sMisingEntry=0);

	/**         (  - )
		@param ciRev	   
		@param bLoadFromBase    */
	bool HasAllNecessaryDocRevAttr(CaplInstance *ciRev);

	/**            
		@param ciRev   
		@param ciSource    
		@param bLoadInfo     */
	bool CopyEntryValues(CaplInstance *ciRev, CaplInstance *ciSource, bool bLoadInfo = true);

	//        ,   
	bool CopyDocRevAttrsToNewRev(CaplInstance *from_rev, CaplInstance *to_rev);

	/**           
		@param pReciever   
		@param pSource    
		@param entries  ,    */
	bool UpdateEntryValues(CaplInstance *pSource, CaplInstance *pReciever, const CStringArray &entries) const;


	/**           
		@param ciRev  */
	bool FromEntryValToDoc(CaplInstance *ciRev);

	/**       
		@param ciRev  
		@param sCardField  
		@param sCardValue 	*/
	bool GetCardValue(CaplInstance *ciRev, LPCTSTR sCardField, CString &sCardValue);


	/**	     
		@param cit			     
		@param sEntryName	 
		@param sValue		 
		@param bShowErrorMsg	/ ,    */
		bool CreateEntryVal(CaplInstance *cit, CString sEntryName, CString sValue, bool bShowErrorMsg = true, bool bCopyToDocAttr = true, bool bFindPrevValue = true);



	/**  ciEntry,       
		       (sValue)*/
		bool ChangeDocAttrByEntryVal(CaplInstance *ciRev, CaplInstance *ciEntry, CString sValue);

	/**     ,       
		     ()  */
		bool ChangeEntriesValByDocAttr(CaplInstance *ciRevision);

	/**    
		@param DocTypeEntry_Entry    
		@return true     false    */ 
	bool ShowEntryValProperties(CString &sValue, CaplInstance *DocTypeEntry_Entry);

	/**         */
	bool EntryForDocumentVersion(const CString &sCardField);
	bool EntryForDocumentVersion(CaplInstance *ciEntry);

	/**     
		@ciEntry - 
		@ciDT -  
		@bOptional -    */
	bool AddEntryToDocType(CaplInstance *ciEntry, CaplInstance *ciDT, bool bOptional = true);

	/**    */
	CString GetEntryFormatName() const;
	CString GetEntryInventoryNumberName() const;
	CString GetEntryMailListName() const;
	CString GetEntryTotalListCountName() const;
	CString GetEntryReleasedByName() const;
	CString GetEntryAcceptApprovalName() const;
	CString GetEntryPdfCodeName() const;
	CString GetEntrySubstInventoryNumberName() const;
	CString GetEntryDublicateInentoryNumberName() const;
	CString GetEntryDublicateName() const;
	CString GetEntryArchiveAcceptDateName() const;

	//     
	static bool LoadRequisiteFromFile(LPCTSTR sFileName, CaplStrStrMap &mapRequisite);

	//     
	// bAddReqToDocType -      
	bool SaveRequisiteToRevision(CaplInstance *rev, CaplStrStrMap &mapRequisite, bool bAddNewReqToDocType);

	//@}	
	/**@name   */
	//@{

	/**   out_ext    Instance 
		@param inst  ,     
		@param out_ext        ()
		@param out_rel        ()
		@param context       ()
		@return true     false    */
	bool FindAssociatedDocuments(CaplInstance *inst, aplExtent &out_ext, aplExtent &out_rel, CaplInstance *context=0,bool from_base=true); 
	
	/**   out_ext       ext
		@param ext   ,     
		@param out_ext        ()
		@param out_rel        ()
		@param context       ()
		@return true     false    */
	bool FindAssociatedDocuments(aplExtent &ext, aplExtent &out_ext, aplExtent &out_rel, CaplInstance *context=0,bool from_base=true);
	
	/**   out_ext       ext    
		@param ext   ,     
		@param out_ext           
		@param out_rel           
		@param context       ()
		@return true     false    */
	bool FindAssociatedDocumentsRec(aplExtent &ext, aplExtent &out_ext, aplExtent &out_rel, CaplInstance *context=0);
	
	/**  ,     inst (  FindAssociatedDocuments)
		  out_ext    Instance 
		@param inst  ,     
		@param out_ext        ()
		@param out_rel        ()
		@param context       ()
		@return true     false    */
	bool FindAssociatingDocuments(CaplInstance *inst, aplExtent &out_ext, aplExtent &out_rel, CaplInstance *context=0,bool from_base=true); 
	
	/**  ,      ext (  FindAssociatedDocuments)
		  out_ext       ext
		@param ext   ,     
		@param out_ext        ()
		@param out_rel        ()
		@param context       ()
		@return true     false    */
	bool FindAssociatingDocuments(aplExtent &ext, aplExtent &out_ext, aplExtent &out_rel, CaplInstance *context=0,bool from_base=true);
	
	/**   inst c doc 
		@param inst  ,     
		@param doc  ,   
		@param     
		@param source    
		@return    NULL    */
	CaplInstance *CreateAssociation(CaplInstance *inst,CaplInstance *doc, aplExtent *contexts=0, const TCHAR * source=0, UINT apl_type = APL_DOCUMENT_RELATION, bool bCheckExist = true);

	///    extDocs   item( item==0,    )
	bool CreateAssociation( CaplInstance *item, aplExtent &extDocs, aplExtent *contexts=0, const TCHAR * source=0);

	/**     inst 
		@param inst  ,     
		@param doc  ,   
		@return    NULL     */
	CaplInstance *FindAssociation(CaplInstance *inst,CaplInstance *doc);

	/**    
		@param out_ext       
		@param id   
		@param doc  
		@param owner  .  
		@param place_of_use     -   
		@param state  (,,)
		@param change_date_behin      
		@param change_date_end      
		@param b_only_out_of_date     
		return true     false    */
	bool FindHardCopyes(aplExtent &out_ext,const TCHAR *id=0,CaplInstance *document=0,CaplInstance *owner=0,CaplInstance *place_of_use=0,const TCHAR *state=0,const TCHAR *change_date_begin=0,const TCHAR *change_date_end=0,BOOL b_only_out_of_date=false);

	/**          
		@param doc_or_revizion     
		@return true      false    */
	bool CheckSubDocument(CaplInstance *doc_or_revision);

	/**   ,         
		@param doc_or_revizion     
		@return true     false    */
	bool CheckSuperDocument(CaplInstance *doc_or_revision);

	//@}

	// *************************************************************************
	//   
	// *************************************************************************

	/**@name    */
	//@{

	/**       
		@param doc  ,      
		@return true     false    */
	bool LoadDocInfo(CaplInstance *doc);
	/**       
		@param ext   ,      
		@param bLoadEntries    
		@return true     false    */
	bool LoadDocInfo(aplExtent &ext, bool bLoadEntries=false);

	/**       
		@param doc  ,   
		@param rev_ext       ()
		@return true     false    */
	bool LoadAllDocumentRevision(CaplInstance *doc, aplExtent &rev_ext);

	/**    */
	CaplInstance *GetLasRevision(CaplInstance *doc);

	/**       
		@param doc_copy   ,      
		@return true     false    */
	bool CaplDocManager::LoadDocCopyInfo(CaplInstance *doc_copy);
	
	/**       
		@param ext    ,      
		@return true     false    */
	bool CaplDocManager::LoadDocCopyInfo(aplExtent &ext);
	//@}

	//    
	//  true,  ok  false,  
	//  app  -  
	bool SelectApp(const TCHAR *file, CString &app);

	/**    
		@param i_doc - 
		@param m_inst ,       
		@return     */
	CaplInstance *CreateDocumentByDot(CaplInstance *i_doc, CaplInstance *inst);
	
	/**   
		@param doc 
		@param docs     
		@param ref  
		@return true     false    */
	bool FindDependenceDocuments(CaplInstance *doc, aplExtent &docs, aplExtent&ref);

	/**   
		@param doc 
		@param docs        
		@param ref     
		@return true     false    */
	CaplInstance* IsDependenceDocument(CaplInstance *doc, aplExtent *docs=0, aplExtent *ref=0);

	/**   
		@param deps   
		@return true      */
	bool TestOnChange(aplExtent &deps);

	/**   -
		@param subItems   -
		@param bLoadFromBase    
		@return true     false    */
	bool GetAllPurchaseOrder(aplExtent &subItems, bool bLoadFromBase=true);

	/**       	   0 - , 1 -  , -1 - */
	int CompareRevisionWithFile(CaplInstance *doc_or_rev, LPCTSTR file_path);
	

	// *************************************************************************
	//  -  ,   
	// *************************************************************************

	bool SetupApprovalFieldsInReports();
	
	// *************************************************************************
	//   
	// *************************************************************************
	/**   
		@param doc 
		@param id 
		@param owner 
		@param place_of_use  
		@param basis  
		@param issue_date  
		@param b_show_dlg        
		@return true   ,  - false*/
	CaplInstance *CaplDocManager::CreateDocumentHardCopy(CaplInstance *doc=0,const TCHAR *id=0,CaplInstance *owner=0,CaplInstance *place_of_use=0,const TCHAR *basis=0,const TCHAR *issue_date=0,bool b_show_dlg=true);
	/**     
		@param doc 
		@return     ,  -1*/
	int CaplDocManager::GetNextHardCopyNumber(CaplInstance *doc);
	/************************************************************************/
	/*                            */
	/************************************************************************/
	//++       
	/**     
		@param extIn  ,      
		@param extPdfs  pdf',   
		@param extPrds    pdf'
		@param extRefs       apl_dpc_ref
		@return true        pdf,  false*/
	bool FindAssociatedPdfs(aplExtent& extIn, aplExtent& extPdfs, aplExtent& extPrds, aplExtent& extRefs);
	//++       
	/**     -  
		@param sFileName  
		@param sOnlyName   -  
		@return true    */
	bool GetOnlyName(const CString& sFileName, CString &sOnlyName);
	//++       
	/**        pdf'e
		@param api mapi
		@param ld loaddata
		@param data*/
	static void AddPdfDocRefInfo(CaplAPI *api, CaplLoadData &ld, DWORD data);
	//++       
	/**      
		@param siMapOptions -  */
	void LoadOptions(mymsiMap& siMapOptions);

	/**       */
	CaplInstance* AddXmlUsedItem( CaplInstance *currentDocRevision, CaplInstance *lpsSystem,
					const CString& sysId, int type,const CString& typeName, const CString& id, const CString& name, const CString& name_eng,
					const CString& configInfo,
					const CString& refGuid,
					CaplInstance *cfgInst);

	/** ,       sys id  1 */
	bool IsUsedInXml( const CString& sysId );

	/** ,      xml */
	bool IsUsedInXml(const aplExtent& in_ext,  std::map<CaplInstance*, bool>& outMap);

	bool FindXmlUsedRefs(const CString& sysId, aplExtent& out_ext);
	bool FindXmlUsedRefs(const std::list<CString>& in_sysIds, aplExtent& out_ext);
	bool FindXmlUsedRefs(const aplExtent& in_ext, std::map<CaplInstance*, std::vector<CaplInstance*>>& out_map);

	//       
	void ClearAllXmlUsages( CaplInstance *doc_or_revision );

	/**       .
		@param lockInst
			.
		@param filename
			 ,   .
	*/
	bool LoadFileFromLocker( CaplInstance * lockInst, const CString& filename );

	/**     .
		@param lockInst
			.
		@param filename
			     .
	*/
	bool SaveFileToLocker( CaplInstance* lock, const CString& filename );

	//        
	CString GetAttrByCardField(CaplInstance *ciRevision, const CString &name);

	//      
	int GetMaxDocRevId(CaplInstance *doc);

	//  -    4     ;  ""   
	bool CalcA4SheetsCount(LPCTSTR sFormat, LPCTSTR sSheetsCount, CString &sA4Count);

	//       (      )
	//   -   .
	//     
	bool GetPrdIdFromDocId(CaplInstance *doc, CString &prd_id, CString &prd_ver);

	//   ,     .
	//   ,    ,   
	bool AttachDocToPrd(CaplInstance *doc);

	//      
	//      ,     
	// (    document->total_sheets_count)
	//    format_description,         
	//    countA4,      ,    4
	//       ,  1)    2)   format_description   
	//     3)  countA4     
	static int CalcAllSheetsFromMultiFormats(LPCTSTR scOfLists, CString* format_description = 0, int *countA4=0);

	//      
	//      ,     
	// (    document->total_sheets_count)
	//    list_formats,       
	static int GetListFormats(LPCTSTR scOfLists, CString* list_formats = 0);

	// 
	void LogDocAccess(CaplInstance *inst, LPCTSTR function, LPCTSTR fpath);

	//       
	bool LoadKdFields(CaplInstance *rev, CaplStrStrMap &map_params);

protected:
	bool CaplDocManager::SetRevisionAccessOnCreate(CaplInstance *rev);
};

// *************************************************************************
// *************************************************************************
// *************************************************************************
//    double
//typedef CaplTAggr <double,long*,0> aplRealArray;
typedef CArray <double,double> aplRealArray;
typedef CaplTAggr <CaplInstance*,long*,0> aplInstArray;

#define APL_LOAD_ASSEMBLY_COMPONENT_USAGE 1
#define APL_LOAD_MAKE_FROM_USAGE_OPTION 2
#define APL_LOAD_DESING_MAKE_FROM_RELATIONSHIP 4

typedef enum {aplModeEdit, aplModeCreateProduct, aplModeCreateVersion, aplModeCreateSubProduct,aplModeCreateProductIfNew} aplPrdDlgmode;

/**  */
class CLASS_DECL_APL_STEP_MGR CaplProductManager: public CaplStepManager
{
	static bool FnNULLInst(const CaplInstance *&inst){return (inst == NULL);}
	
	// 
public:
	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	// Attributes
public:	

	/**@name  ( ) */
	//@{
	CaplEntity *e_prd;		/**<product */
	CaplAttr *a_prd_id;		/**<product -> id */
	CaplAttr *a_prd_name;	/**<product -> name */
	CaplAttr *a_prd_descr;  /**<product -> description */
	CaplAttr *a_prd_code;	/**<product -> code */
	CaplAttr *a_prd_guid;	
	//@}
	

	/**@name   ( ) */
	//@{
	CaplEntity *e_pdf;		/**<product_definition_formation */
	CaplAttr *a_pdf_id;		/**<product_definition_formation -> id */
	CaplAttr *a_pdf_prd;	/**<product_definition_formation -> of_product */
	CaplAttr *a_pdf_descr;	/**<product_definition_formation -> description */
	CaplAttr *a_pdf_code;	/**<product_definition_formation -> code */
	CaplAttr *a_pdf_code1;	/**<product_definition_formation -> code2 */
	CaplAttr *a_pdf_code2;	/**<product_definition_formation -> code3 */
	CaplAttr *a_pdf_okpd_code; //*<product_definition_formation -> okpd_code */
	CaplAttr *a_pdf_ils_component;

	CaplAttr*    a_apl_pdf_grpz_id;
	CaplAttr*    a_apl_pdf_grpz_name;
	CaplAttr*    a_apl_pdf_grpz_pdf_id;

	 
	CaplEntity *e_apl_pdf;			/**apl_product_definition_formation< */
	CaplAttr *a_pdfwss_source;		/**<apl_product_definition_formation -> make_or_buy */
	CaplAttr *a_apl_pdf_type;		/**<apl_product_definition_formation -> formation_type */
	CaplAttr *a_apl_pdf_standard;	/**<apl_product_definition_formation -> is_standard_part */
	CaplAttr *a_apl_pdf_state;		/**<product_definition_formation -> cp_state*/
	CaplAttr *a_apl_pdf_relevance;		/**<product_definition_formation -> relevance   */
	CaplAttr *a_apl_pdf_cp_state;		/**<product_definition_formation -> state*/
	CaplAttr *a_apl_pdf_unit;		/**<product_definition_formation -> unit*/
	CaplAttr *a_apl_pdf_logbook;	/**<product_definition_formation -> logbook_type*/
	CaplAttr *a_apl_pdf_first_usage;/**<product_definition_formation -> first_usage*/
	CaplAttr *a_apl_pdf_additional_data;/**<product_definition_formation -> additional_data*/
	CaplAttr *a_apl_pdf_average_life_refusal;	/**<product_definition_formation -> average_life_refusal*/
	CaplAttr *a_apl_pdf_par_flow_refusal;	/**<product_definition_formation -> par_flow_refusal*/
	CaplAttr *a_apl_pdf_average_life_removal;	/**<product_definition_formation -> average_life_removal*/
	CaplAttr *a_apl_pdf_locker;
	CaplAttr *a_apl_pdf_parent;
	CaplAttr *a_apl_pdf_guid;
	CaplAttr *a_apl_pdf_cataloging_params;
	CaplAttr *a_apl_pdf_refusal_count;
	//@}

	// 
	CaplEntity*  e_apl_tech_process;
	CaplAttr*    a_tech_process_id;
	CaplAttr*    a_tech_process_pdf;
	CaplAttr*    a_tech_process_processing_class;
	CaplAttr*    a_tech_process_minimum_quantity;
	CaplAttr*    a_tech_process_type;
	CaplAttr*    a_tech_process_author;
	CaplAttr*    a_tech_process_create_date;
	CaplAttr*    a_tech_process_last_edit_person;
	CaplAttr*    a_tech_process_last_edit_date;
	CaplAttr*    a_tech_process_xml_material;
	CaplAttr*    a_tech_process_xml_material_value;
	CaplAttr*    a_tech_process_approved_date;
	CaplAttr*    a_tech_process_canceled_date;
	CaplAttr*    a_tech_process_ver;
	CaplAttr*    a_tech_process_x;
	CaplAttr*    a_tech_process_y;
	CaplAttr*    a_tech_process_z;
	CaplAttr*    a_tech_process_l;
	CaplAttr*	 a_tech_process_fiber_direction;
	CaplAttr*	 a_tech_process_angel_90;
	CaplAttr*	 a_tech_process_samples_count;
	CaplAttr*	 a_tech_process_lots_count;
	CaplAttr*	 a_tech_process_sample_size;

	//  ,       
	CaplEntity*	 e_apl_pez_import_item;
	CaplAttr*    a_pez_item_pdf;
	CaplAttr*    a_pez_item_position;
	CaplAttr*    a_pez_item_print_id;
	CaplAttr*    a_pez_item_print_name;
	CaplAttr*    a_pez_item_foreign_name;
	CaplAttr*    a_pez_item_print_unit;
	CaplAttr*    a_pez_item_price;
	CaplAttr*    a_pez_item_count;

	//  
	CaplEntity*  e_apl_supply_contract;
	CaplAttr*    a_sc_document;
	CaplAttr*    a_sc_abonent;
	CaplAttr*    a_sc_registration_date;
	CaplAttr*    a_sc_activation_date;
	CaplAttr*    a_sc_end_date;
	CaplAttr*    a_sc_notes;
	CaplAttr*    a_sc_author;
	CaplAttr*	 a_sc_annulate_date;

	//  
	CaplEntity*  e_apl_tech_process_operation;
	CaplAttr*    a_tpo_production_time;
	CaplAttr*    a_tpo_laboriousness;
	CaplAttr*    a_tpo_worker_category;
	CaplAttr*    a_tpo_id;
	CaplAttr*    a_tpo_operation;
	CaplAttr*    a_tpo_process;
	CaplAttr*    a_tpo_profession;
	CaplAttr*    a_tpo_work_condition;
	CaplAttr*    a_tpo_workers_count;
	CaplAttr*    a_tpo_limit_operation;
	CaplAttr*    a_tpo_fictive_operation;
	CaplAttr*    a_tpo_units_at_same_time;
	CaplAttr*    a_tpo_preporation_time;
	CaplAttr*    a_tpo_one_unit_time;
	CaplAttr*	 a_tpo_laboriousness_show_in_minutes;
	CaplAttr*	 a_tpo_locker;
	CaplAttr*	 a_tpo_check_out_date;
	CaplAttr*	 a_tpo_check_in_date;
	CaplAttr*	 a_tpo_edit_person;
	CaplAttr*	 a_tpo_new_revision;
	CaplAttr*	 a_tpo_base_revision;
	CaplAttr*	 a_tpo_internal_number;

	//  ->  
	CaplEntity*  e_kit_unload_item;
	CaplAttr*    a_kit_unload_item_kit;
	CaplAttr*    a_kit_unload_item_ks;
	CaplAttr*    a_kit_unload_item_ts;
	CaplAttr*    a_kit_unload_item_date;
	CaplAttr*    a_kit_unload_item_person;


	//  
	CaplEntity*  e_apl_tech_operation;
	CaplAttr*    a_tech_operation_pdf;
	CaplAttr*    a_tech_operation_operation_level;
	CaplAttr*    a_tech_operation_shop;
	CaplAttr*    a_tech_operation_level;
	CaplAttr*    a_tech_operation_fictive;
	CaplAttr*    a_tech_operation_limit;


	//  
	CaplEntity* e_apl_complectation_card;
	CaplAttr*    a_complectation_card_parent_pdf;
	CaplAttr*    a_complectation_card_id;
	CaplAttr*    a_complectation_card_name;
	CaplAttr*    a_complectation_card_stage;
	CaplAttr*    a_complectation_card_dscr;
	CaplAttr*    a_complectation_card_time;

	/**@name    ( ) */
	//@{
	CaplEntity *e_pdr;					/**<product_definition_relationship */
	CaplEntity *e_acu;					/**<assembly_component_usage */
	CaplAttr *a_acu_ref_des;			/**<assembly_component_usage -> reference_designator */

	CaplEntity *e_nauo;					/**<next_assembly_usage_occurrence */
	CaplEntity *e_apl_qacu;				/**<apl_quantified_assembly_component_usage */
	 
	CaplEntity *e_qacu_nauo;			/**<apl_quantified_assembly_component_usage+next_assembly_usage_occurrence */
	CaplAttr *a_pdr_id;					/**<product_definition_relationship -> id */
	CaplAttr *a_pdr_name;				/**<product_definition_relationship -> name */
	CaplAttr *a_pdr_descr;				/**<product_definition_relationship -> description */
	CaplAttr *a_pdr_r_ting;				/**<product_definition_relationship -> relating_product_definition */
	CaplAttr *a_pdr_r_ted;				/**<product_definition_relationship -> related_product_definition */
	CaplAttr *a_apl_qacu_unit;			/**<apl_quantified_assembly_component_usage -> unit_component */
	CaplAttr *a_apl_qacu_value;			/**<apl_quantified_assembly_component_usage -> value_component */
	CaplAttr *a_pdr_frames_of_reference;/**<product_definition_relationship -> apl_frames_of_reference */
	CaplAttr *a_pdr_inner_id;			/**<product_definition_relationship -> assembly_item_id */
	CaplAttr *a_pdr_parent_reference;	/**<product_definition_relationship -> parent_reference */
	CaplAttr *a_pdr_parent_reference_type;/**<product_definition_relationship -> parent_reference_type */
	CaplAttr *a_pdr_guid;
	//@}

	//    1 ()
	CaplEntity*  e_apl_1c_upload_item;
	CaplAttr*    a_1c_upload_item_zakaz;
	CaplAttr*    a_1c_upload_item_sklad;
	CaplAttr*    a_1c_upload_item_ceh;
	CaplAttr*    a_1c_upload_item_nn;
	CaplAttr*    a_1c_upload_item_num_lim;
	CaplAttr*    a_1c_upload_item_pdf_name;
	CaplAttr*    a_1c_upload_item_pdf_id;
	CaplAttr*    a_1c_upload_item_export_result;
	CaplAttr*    a_1c_upload_item_pdf_unit;
	CaplAttr*    a_1c_upload_item_type_lim;
	CaplAttr*    a_1c_upload_item_prim_lim;
	CaplAttr*    a_1c_upload_item_post_date;
	CaplAttr*    a_1c_upload_item_create_date;
	CaplAttr*    a_1c_upload_item_color_flag;
	CaplAttr*    a_1c_upload_item_kol;
	CaplAttr*    a_1c_upload_item_last_upload_kol;	
	CaplAttr*	 a_1c_upload_item_mat_rel;
	CaplAttr*	 a_1c_upload_item_last_last_upload_kol;

	CaplEntity*  e_limit_change_upload_history;
	CaplAttr*	 a_limit_change_upload_history_item;
	CaplAttr*	 a_limit_change_upload_history_zakaz;
	CaplAttr*	 a_limit_change_upload_history_num_lim;
	CaplAttr*	 a_limit_change_upload_history_type_lim;

	/**@name    ( ) */
	//@{
	CaplEntity *e_shared_pdf_rel;		/**<shared_pdf_relationship */
	CaplAttr *a_shared_pdf_rel_ed;		/**<shared_pdf_relationship -> related_pdf */
	CaplAttr *a_shared_pdf_rel_ing;		/**<shared_pdf_relationship -> related_pdf */

	/**@name  ( ) */
	//@{
	CaplEntity *e_pd_eff;			/**<product_definition_effectivity */
	CaplAttr *a_pde_id;				/**<product_definition_effectivity -> id */
	CaplAttr *a_pde_usage;			/**<product_definition_effectivity -> usage */
	CaplAttr *a_pde_prev;			/**<product_definition_effectivity -> previouse */
	CaplAttr *a_pde_not_active;		/**<product_definition_effectivity -> is_not_active */

	CaplEntity *e_sn_eff;		/**<serial_numbered_effectivity */
	CaplAttr *a_sn_eff_start;	/**<serial_numbered_effectivity -> effectivity_start_id */
	CaplAttr *a_sn_eff_end;		/**<serial_numbered_effectivity -> effectivity_end_id */
	
	CaplEntity *e_dat_eff;		/**<dated_effectivity */
	CaplAttr *a_dat_eff_start_s;/**<dated_effectivity -> effectivity_start_date_s */
	CaplAttr *a_dat_eff_end_s;	/**<dated_effectivity -> effectivity_end_date_s */
	//@}
	 
	/**@name  ( ) */
	//@{
	CaplEntity *e_make_from;					/**<apl_make_from_usage_option */
	CaplEntity *e_design_make_from;				/**<design_make_from_relationship */
	CaplAttr *a_make_from_ranking;				/**<apl_make_from_usage_option -> ranking */
	CaplAttr *a_make_from_ranking_rationale;	/**<apl_make_from_usage_option -> ranking_rationale */
	CaplAttr *a_make_from_value;				/**<apl_make_from_usage_option -> value_component */
	CaplAttr *a_make_from_unit;					/**<apl_make_from_usage_option -> unit_component */
	CaplAttr *a_make_from_derive_value;			/**<apl_make_from_usage_option -> derive_value_component */
	CaplAttr *a_make_from_derive_unit;			/**<apl_make_from_usage_option -> derive_unit_component */
	CaplAttr *a_make_from_assortment;			/**<apl_make_from_usage_option -> apl_assortment */
	CaplAttr *a_make_from_param;				/**<apl_make_from_usage_option -> parameter_of_sortament */
	CaplAttr *a_make_from_waste;				/**<apl_make_from_usage_option -> from_waste */
	//@}

	CaplEntity *e_spr;	/**<supplied_part_relationship */

	/**@name  ( ) */
	//@{
	CaplEntity *e_alt;		/**<alternate_product_relationship */
	CaplAttr *a_alt_base;	/**<alternate_product_relationship -> base */
	CaplAttr *a_alt_alt;	/**<alternate_product_relationship -> alternate */
	CaplAttr *a_alt_basis;	/**<alternate_product_relationship -> basis */
	CaplAttr *a_alt_name;	/**<alternate_product_relationship -> name */
	CaplAttr *a_alt_descr;	/**<alternate_product_relationship -> description */
	CaplAttr *a_alt_koeff;	/**<alternate_product_relationship -> koeff */
	//@}

	/**@name   ( ) */
	//@{
	CaplEntity *e_alt_pdf;		
	CaplAttr *a_alt_pdf_base;	
	CaplAttr *a_alt_pdf_alt;	
	CaplAttr *a_alt_pdf_id;			
	CaplAttr *a_alt_pdf_basis;	
	CaplAttr *a_alt_pdf_descr;
	CaplAttr *a_alt_pdf_koeff;	
	//@}

	/**@name  ( ) */
	//@{
	 
	CaplEntity *e_assortment;			/**<apl_assortment */
	CaplEntity *e_assortment_shape;		/**<apl_assortment_shape */
	CaplEntity *e_prd_assortment;		/**<apl_product_assortment */
	 
	CaplAttr *a_assortment_id;			/**<apl_assortment -> id */
	CaplAttr *a_assortment_name;		/**<apl_assortment -> name */
	CaplAttr *a_assortment_descr;		/**<apl_assortment -> description */
	CaplAttr *a_assortment_std;			/**<apl_assortment -> standard */
	CaplAttr *a_assortment_shape;		/**<apl_assortment -> shape */
	 
	CaplAttr *a_assortment_dim_name;	/**<apl_assortment -> dimension_name */
	CaplAttr *a_assortment_possible_dim;/**<apl_assortment -> possible_dimensions */
	CaplAttr *a_assortment_shape_id;	/**<apl_assortment_shape -> id */
	CaplAttr *a_assortment_shape_name;	/**<apl_assortment_shape -> name */
	CaplAttr *a_assortment_shape_descr;	/**<apl_assortment_shape -> description */
	CaplAttr *a_assortment_shape_unit;	/**<apl_assortment_shape -> unit */
	CaplAttr *a_prd_assortment_prd;		/**<apl_product_assortment -> of_product */
	CaplAttr *a_prd_assortment_assort;	/**<apl_product_assortment -> assortment */
	//@}

	/**@name      ( ) */
	//@{
	CaplEntity *e_pdf_subst;			/**<product_definition_substitute */

	CaplAttr *a_pdf_subst_id;			/**<product_definition_substitute -> id */
	CaplAttr *a_pdf_subst_name;			/**<product_definition_substitute -> name */
	CaplAttr *a_pdf_subst_description;	/**<product_definition_substitute -> description */
	CaplAttr *a_pdf_subst_pdr;			/**<product_definition_substitute -> context_relationship */
	CaplAttr *a_pdf_subst_pdf;			/**<product_definition_substitute -> substitute_definition */
	CaplAttr *a_pdf_subst_value;		/**<product_definition_substitute -> value_component */
	CaplAttr *a_pdf_subst_unit;			/**<product_definition_substitute -> unit_component */
	CaplAttr *a_pdf_subst_parent_item;	/**<product_definition_substitute -> parent_item */
	CaplAttr *a_pdf_subst_guid;
	//@}

	/**@name ,         */
	//@{
	CaplEntity *e_apl_language;			/**<apl_language */
	
	CaplAttr *a_apl_language_name;	/**<apl_language -> name */
	//@}

	/**@name         */
	//@{
	CaplEntity *e_apl_export_product;			/**<apl_export_product */
	
	CaplAttr *a_apl_export_product_ofproduct;	/**<apl_export_product -> of_product */
	CaplAttr *a_apl_export_product_language;	/**<apl_export_product -> language */
	CaplAttr *a_apl_export_product_id;			/**<apl_export_product -> id */
	CaplAttr *a_apl_export_product_name;		/**<apl_export_product -> name */
	CaplAttr *a_apl_export_product_code;		/**<apl_export_product -> code */
	CaplAttr *a_apl_export_product_pdf_id;		/**<apl_export_product -> pdf_id */
	CaplAttr *a_apl_export_product_pdf_code;	/**<apl_export_product -> pdf_code */
	CaplAttr *a_apl_export_product_pdf_code1;	/**<apl_export_product -> pdf_code1 */
	CaplAttr *a_apl_export_product_pdf_code2;	/**<apl_export_product -> pdf_code2 */
	CaplAttr *a_apl_export_product_descr;		/**<apl_export_product -> description */
	//@}

	/**@name    */
	//@{
	CaplEntity *e_apl_product_attrs_change;			/**<apl_product_attrs_change */
	
	CaplAttr *a_apl_product_attrs_change_item;	/**<apl_product_attrs_change -> item */
	CaplAttr *a_apl_product_attrs_change_id;	/**<apl_product_attrs_change -> id */
	CaplAttr *a_apl_product_attrs_change_name;	/**<apl_product_attrs_change -> name */
	CaplAttr *a_apl_product_attrs_change_code;	/**<apl_product_attrs_change -> code */
	CaplAttr *a_apl_product_attrs_change_pdf_id;	/**<apl_product_attrs_change -> pdf_id */
	CaplAttr *a_apl_product_attrs_change_pdf_code;	/**<apl_product_attrs_change -> pdf_code */
	CaplAttr *a_apl_product_attrs_change_pdf_code1;	/**<apl_product_attrs_change -> pdf_code1 */
	CaplAttr *a_apl_product_attrs_change_pdf_code2;	/**<apl_product_attrs_change -> pdf_code2 */

	CaplAttr *a_apl_product_attrs_change_person;	/**<apl_product_attrs_change -> person */
	CaplAttr *a_apl_product_attrs_change_datetime;	/**<apl_product_attrs_change -> datetime */
	CaplAttr *a_apl_product_attrs_change_status;	/**<apl_product_attrs_change -> status */
	CaplAttr *a_apl_product_attrs_change_next;	/**<apl_product_attrs_change -> prev */
	//@}
	/**@name   ,    ( ) */
	//@{
	CaplEntity* e_comp_mf;					/**<apl_component_make_from */
	CaplAttr* a_comp_mf_id;					/**<apl_component_make_from -> id */
	CaplAttr* a_comp_mf_ting;				/**<apl_component_make_from -> product_definition */
	CaplAttr* a_comp_mf_ted;				/**<apl_component_make_from -> material */
	CaplAttr* a_comp_mf_unit;				/**<apl_component_make_from -> unit */
	CaplAttr* a_comp_mf_value;				/**<apl_component_make_from -> value */
	CaplAttr* a_comp_mf_derived_unit;		/**<apl_component_make_from -> derived_unit */
	CaplAttr* a_comp_mf_derived_value;		/**<apl_component_make_from -> derived_value */
	CaplAttr* a_comp_mf_type_id;			/**<apl_component_make_from -> type_id */
	CaplAttr* a_comp_mf_type;				/**<apl_component_make_from -> type */
	CaplAttr* a_comp_mf_descr;				/**<apl_component_make_from -> description */
	//@}				

	//**@name    */
	//@{
	CaplEntity* e_order_eff;				//*<apl_order_effectivity */
	CaplAttr*    a_order_eff_type;			//*<apl_order_effectivity -> type */
	CaplAttr*    a_order_eff_number;		//*<apl_order_effectivity -> number */
	//@]
	
	//**@name   */
	CaplEntity* e_rule_rels;				//*<apl_rule_select_relation */
	CaplAttr*	a_rule_rels_item;				//*<apl_rule_select_relation -> item */
	CaplAttr*	a_rule_rels_rule;				//*<apl_rule_select_relation -> rule */
	CaplAttr*	a_rule_rels_type;				//*<apl_rule_select_relation -> relation_type */

	CaplEntity*	e_rule_cont;				//*<apl_rule_container */
	CaplAttr*	a_rule_cont_rule;				//*<apl_rule_container -> rule */
	//@]

	//     
	CaplEntity* e_apl_mat_limit_change_rel;
	CaplAttr*    a_mat_limit_change_rel_pdf;
	CaplAttr*    a_mat_limit_change_rel_basis;

	//    
	CaplEntity*  e_apl_mat_limit_change_basis;
	CaplAttr*    a_mat_limit_change_basis_id;
	CaplAttr*    a_mat_limit_change_basis_pdf;
	CaplAttr*    a_mat_limit_change_basis_person;
	CaplAttr*    a_mat_limit_change_basis_date_create;
	CaplAttr*    a_mat_limit_change_basis_date_approved;
	CaplAttr*	 a_mat_limit_change_basis_state;
	
	//    
	CaplEntity*  e_apl_mat_limit_change_item;
	CaplAttr*    a_mat_limit_change_item_change;
	CaplAttr*    a_mat_limit_change_item_descr;
	CaplAttr*    a_mat_limit_change_item_date;
	CaplAttr*    a_mat_limit_change_item_delta;
	CaplAttr*    a_mat_limit_change_item_new_value;
	CaplAttr*	 a_mat_limit_change_item_relation;
	CaplAttr*    a_mat_limit_change_item_material_relation;
	CaplAttr*    a_mat_limit_change_item_new_material;
	CaplAttr*    a_mat_limit_change_item_old_material;
	CaplAttr*    a_mat_limit_change_item_old_warehouse;
	CaplAttr*    a_mat_limit_change_item_new_warehouse;
	CaplAttr*    a_mat_limit_change_item_old_shop;
	CaplAttr*    a_mat_limit_change_item_new_shop;	

	bool bNoCreateAndChangePDF;  //     pdf      .   PSM    
	int (*funcCompareSN)(CString&, CString&); //     .
	CString (*funcGetPrevSN)(CString&); //      .
	CString (*funcGetNextSN)(CString&); //      .
	BOOL (*funcIsKVZSN)(CString&); //         .
	BOOL (*funcIntervalIsVerified)(CString&, CString&); //            .

	// 
public:

	//   
	CString GetProductId(CaplInstance *pdfOrProduct, CString *name = 0);

	//       
	bool FindPdfsByIds(const std::set<CString> &ids, aplExtent &result, bool loadAttrs) const;
	
	//     
	BOOL InitCompareSNLibrary();

	//        
	bool DeleteLimit(CaplInstance *nrm);

	/**     */
	bool GenerateLimitByPdf(CaplInstance *nrm, CaplInstance *pdf);

	/**     */
	CaplInstance* GenerateComplectByPdf(CaplInstance *order, CaplInstance *pdf);

	/**       */
	CaplInstance *FindPdfRelation(CaplInstance* PdfRelating, CaplInstance* PdfRelated);

	/**        */
	bool LoadAssortment();

	/**   pdf       /   */
	bool ChangeMkState(CaplInstance *pdf);
	bool ChangeMkState(aplExtent &pdfs);

	/**    
		@param prd  t (PRD)
		@param out_ext      
		@return true     false    */
	bool LoadPrdAssortment(CaplInstance *prd, aplExtent &out_ext);

	/**    
		@param exp_pdf -    
		@return true     false    */
	bool StartCompareProduct(aplExtent &exp_pdf);

	/**      
		@param ci  ( )
		@param context  ( )
		@param prd  (PRD)
		@param out_ext        (PDF)
		@param ext_pdf         (PDF)
		@param ext_rel       (NAUO)
		@param from_base      .  false    
		@return true     false    */
	bool LoadAllSubProduct(CaplInstance *ci, CaplInstance *context,
		CaplInstance *prd, aplExtent &out_ext, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true);
	
	/**    
		@param ci  ( )
		@param context  ( )
		@param pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (NAUO)
		@param from_base      .  false    
		@return true     false    */
	bool LoadAllSubProduct(CaplInstance *ci, CaplInstance *context,
		CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true);
	bool LoadAllSubProduct(aplExtent &parents, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true);
	/**    
		@param ci  ( )
		@param context  ( )
		@param pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (NAUO)
		@param from_base      .  false    
		@return true     false    */
	bool LoadAllSubProductEx(CaplInstance *ci, CaplInstance *context,
		CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true,
		UINT flag = APL_LOAD_ASSEMBLY_COMPONENT_USAGE|APL_LOAD_MAKE_FROM_USAGE_OPTION|APL_LOAD_DESING_MAKE_FROM_RELATIONSHIP);

	/**   ()        
		@param pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (MFUO)
		@param include_design     design_make_from_relationship.  true  
		@param from_base      .  false    
		@return true     false    */
	bool LoadAllZagotov(CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf,
		bool include_design = false ,bool from_base=true);

	/**   ()       
		@param ext_pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (MFUO)
		@param include_design     design_make_from_relationship.  true  
		@param from_base      .  false    
		@param show_status_dlg     (    )
		@return true     false    */
	bool CaplProductManager::LoadAllZagotov(aplExtent &ext_pdf, aplExtent &ext_rel, aplExtent &out_ext,
		bool include_design , bool from_base=true,bool show_status_dlg=false);

	/**   ()        
		@param pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (MFUO)
		@param from_base      .  false    
		@return true     false    */
	bool LoadAllOGmet(CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf,
		bool from_base=true);

	/**          
		@param ext_pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (MFUO)
		@param from_base      .  false    
		@param show_status_dlg     (    )
		@return true     false    */
	bool LoadAllOGmet(aplExtent &ext_pdf, aplExtent &ext_rel, aplExtent &out_ext,
		bool from_base,bool show_status_dlg=false);

	/**  -   
		@param pdr  (PDR)
		@param ext_rel       (PRODUCT_DEFINITION_SUBSTITUTE)
		@param ext_pdf        (PDF)
		@param from_base      .  false    
		@return true     false    */
	bool LoadAllSubstitutes(CaplInstance *pdr, aplExtent &ext_rel, aplExtent &ext_pdf,bool from_base=true);

	/**   ,  /  
		@param ciItem -      
		@param ciLot -  
		@param bOnlyPrdIns -    prd_inst,   pdf
		@param bDisableLot -    
		@param bDisablePrdInst -     
		@param sSpravId -   */
	bool FindPKIEx(CaplInstance **ciItem, CaplInstance **ciLot, bool bOnlyPrdIns=false, bool bDisableLot=false, bool bDisablePrdInst=false,LPCTSTR sSpravId=0);

	/**   ,      
		@param subst_pdf  ,     (PDF)
		@param ext_rel       (PRODUCT_DEFINITION_SUBSTITUTE)
		@param ext_pdr      ' ' (NAUO)
		@param from_base      .  false    
		@return true     false    */
	bool WhereUsedAsSubstitute(CaplInstance *subst_pdf, aplExtent &ext_rel, aplExtent &ext_pdr,bool from_base);

	/**         
		@param pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (NAUO)
		@param from_base      .  false    
		@param bPdr     
		@param bAlt   
		@return true     false    */
	bool WhereUsedProduct(CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true, bool bPdr=true, bool bAlt=true);
	bool WhereUsedProduct(aplExtent &pdfs, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true, bool bPdr=true, bool bAlt=true);

	/**        
		@param pdf   (PDF)
		@param out_ext        (PDF)
		@param out_rel       (SPR)
		@param from_base      .  false    
		@return true     false    */
	bool LoadSupliedProduct(CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf, bool from_base=true);

		/**     
		@param prd   (PDF)
		@param out_ext       (PRD)
		@param out_rel       (alternate)
		@return true     false    */
	bool LoadProductAlternates(CaplInstance *prd, aplExtent &ext_rel, aplExtent &ext_prd);

		/**      
		@param prd    (PDF)
		@param ext_rel       (apl_alternate_pdf_relation)
		@param ext_pdf        (apl_alternate_pdf_relation)
		@return true     false    */
	bool LoadPdfAlternates(CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf);


		/**      
		@param prd    (PDF)
		@param ext_rel       (apl_alternate_pdf_relation)
		@param ext_pdf        (apl_alternate_pdf_relation)
		@return true     false    */
	bool LoadPdfAlternateReady(CaplInstance *pdf, aplExtent &ext_rel, aplExtent &ext_pdf);

		/**     (     c    (e_alt_bidirect))
		@param prd   (PDF)
		@param out_ext       (PRD)
		@param out_rel       (alternate)
		@return true     false    */
	bool LoadProductBidirectAlternates(CaplInstance *prd, aplExtent &ext_relBase, aplExtent &ext_prdBase, aplExtent &ext_relAlt, aplExtent &ext_prdAlt);

		/**     (   )
		@param context  
		@param pdf   (PDF)
		@param ext_rel      (ACU)  
		@param ext_out       (PDF)   pdf
		@param count_array    i-      pdf i-  ext_pdf
		@param ext_unit     i-      ext_pdf
		@param not_disas_types  ,    
		@param not_disas_sources  ,    
		@return true     false    */
	bool DisassemblyProduct(CaplInstance *context,CaplInstance *pdf,aplExtent &ext_rel,aplExtent &ext_out, aplRealArray &count_array, aplExtent &ext_unit,const TCHAR *filter_date=0,const TCHAR *filter_sn=0,bool ReturnOnlyPart=false,CStringArray *not_disas_types=0,CStringArray *not_disas_sources=0, CaplInstance *pComplectation = NULL);

	/**     
		@param ci  
		@param context  ( )
		@param pdf   (PDF)
		@param ext_pdf       (PDF)   pdf
		@param count_array    i-      pdf i-  ext_pdf
		@param ext_unit     i-      ext_pdf
		@param ReturnOnlyPart          .  ReturnOnluPart
		ReturnOnlyPart == true,   ,       
		@return true     false    */
	bool DisassemblyProduct(CaplInstance *ci, CaplInstance *context,	CaplInstance *pdf, 
		aplInstArray &ext_pdf, aplRealArray &count_array, aplInstArray &ext_unit, bool ReturnOnlyPart=true, CaplInstance *pComplectation = NULL);

	/**     c  
		@param ci  
		@param context  ( )
		@param pdf   (PDF)
		@param ext_pdf       (PDF)   pdf
		@param count_array    i-      pdf i-  ext_pdf
		@param ext_unit     i-      ext_pdf
		@param ReturnOnlyPart          .  ReturnOnluPart
		ReturnOnlyPart == true,   ,       
		@param pComplectation  (  )
		@param IsNoDisasemblyItem -      pdf
		@return true     false    */
	bool DisassemblyProductEx(CaplInstance *ci, CaplInstance *context,	CaplInstance *pdf, 
		aplInstArray &ext_pdf, aplRealArray &count_array, aplInstArray &ext_unit,
		COleDateTime *time=0, const TCHAR *sn=0, bool ReturnOnlyPart=true, CaplInstance *pComplectation = NULL,
		bool (*IsNoDisasemblyItem)(CaplInstance *pdf)=0);

	bool DisassemblyProductEx2(CaplInstance *ci, CaplInstance *context,	CaplInstance *pdf, 
		aplInstArray &ext_pdf, aplRealArray &count_array, aplInstArray &ext_unit,
		COleDateTime *time=0, const TCHAR *sn=0, bool ReturnOnlyPart=true, CaplInstance *pComplectation = NULL,
		bool (*IsNoDisasemblyItem)(CaplInstance *pdf)=0);

	/**     (NAUO)     
		@param inExt     (NAUO)  
		@param sn   
		@param out_rel      (NAUO) ()
		@return true     false    */
	bool FilterlBySN(aplExtent &inExt, const TCHAR *sn, aplExtent &outExt);

	/**   (    "")   (NAUO) 		
		@param inExt     (NAUO)  
		@param out_rel      (NAUO) ()
		@return true     false    */
	bool FilterlByLastSN(aplExtent &inExt, aplExtent &outExt);

	/**    (NAUO)   
		@param inExt     (NAUO)  
		@param time 
		@param out_rel      (NAUO) ()
		@return true     false    */
	bool FilterlByDate(aplExtent &inExt, COleDateTime &time, aplExtent &outExt);

	/**   (apl_qacu)  
	  @param rels -    (apl_qacu)
	  @param change -  (apl_change)
	  @param extOut -   (!  qacu  psc!)
	  @param extParents - ,        ( NULL,     )
	  @param bLoadFromBase -         */
	bool FilterByChange(aplExtent &rels, CaplInstance *change, aplExtent &extOut, aplExtent *extParents = NULL, bool bLoadFromBase = false);

	/**       ,   
		@param time   
		@param sn    
		@param context  
		@param chosen_context  
		@return true     false    */
	bool SelectDateSN(CString &sn, COleDateTime &time, CaplInstance *context,CaplInstance **chosen_context);
	
	/**      
		@param pPdf ,     
		@param pConfiguration  
		@param pOrder  ,   
	*/
	bool SelectConfiguration(CaplInstance *pPdf, CaplInstance** pConfiguration, CaplInstance** pOrder=NULL);

	/**     
		@param prd  
		@param prds  
		@param outExt     ()
		@return true     false    */
	bool GetAllProductVersion(CaplInstance *prd,aplExtent &outExt);
	bool GetAllProductVersion(aplExtent &prds,aplExtent &outExt);

	/**   (PRD)   
		@param id   
		@return   (PRD)  NULL    */
	CaplInstance *FindPrdById(const TCHAR *id, bool bIgnoreSpaces= false);

	/**    (PDF)  
		@param prd   (PRD)
		@param id    
		@return   (PDF)  NULL    */
	CaplInstance *FindPdfById(CaplInstance *prd, const TCHAR *id, bool bIgnoreSpaces= false);

	/**    (PDF)  
		@param code    
		@return   (PDF)  NULL    */
	CaplInstance *FindPdfByCode(const TCHAR *code, bool bIgnoreSpaces= false);
	CaplInstance *FindPdfByCode1(const TCHAR *code1, bool bIgnoreSpaces= false);


	/**         
		@param prd   (PRD  PDF)
		@return true     false    */
	bool LoadPrdInfo(CaplInstance *inst);

	/**         
		@param ext    (PRD  PDF)
		@return true     false    */
	bool LoadPrdInfo(aplExtent &ext);
	
	/**    
		@param id   
		@param name   
		@param ver    
		@param testunique       . true    false   
		@return    (PDF)  NULL     */
	CaplInstance *CreatePdf(const TCHAR *id,const TCHAR *name, const TCHAR *ver, bool testunique=true);
	CaplInstance *CreatePdf(CaplInstance* prd, const TCHAR *ver, bool testunique=true);
	
	/**   "  " (NAUO)    
		@param context  ( )
		@param relating_pdf    
		@param related_pdf    
		@param id    ()
		@param name   
		@param count  
		@param unit    
		@return   (NAUO)  NULL     */
	CaplInstance *CreatePdfRelation(CaplInstance *context,
		CaplInstance *relating_pdf, CaplInstance *related_pdf,
		const TCHAR *id,const TCHAR *name, double count, CaplInstance *unit=0, bool bTestUnique=false, bool bTestForCycle = true);
	
	/**   ""    
		@param context  ( )
		@param base_pdf   
		@param alternate_pdf   
		@param name   
		@param descr  
		@param type   
		@param type_descr   
		@param reserved    (    )
		@return   (NAUO)  NULL     */
	CaplInstance *CreatePdfAlternateRelation(CaplInstance *context,
		CaplInstance *base_pdf, CaplInstance *alternate_pdf,
		const TCHAR *name, const TCHAR *descr, int type, const TCHAR* type_descr, const TCHAR* reserved, bool bTestUnique=false);

	/**    ""   
	@return <b>false</b>     <b>true</b>   */
	bool TestCycleInAlternateRelation (CaplEntity *ent, CaplAttr *in_attr, CaplAttr *out_attr, CaplInstance *in_val, CaplInstance *out_val);

	/**   "   " (PDF_SUBSTITUTE)  
		@param context_pdr  (.)
		@param subst_pdf   ()  
		@param id      ()
		@param descr  
		@param count 
		@param unit    
		@return   (NAUO)  NULL     */
	CaplInstance *CaplProductManager::CreateSubstitute(CaplInstance *context_pdr,
		CaplInstance *subst_pdf,const TCHAR *id=0,const TCHAR *name=0,const TCHAR *descr=0, double count=0, CaplInstance *unit=0);
	CaplInstance *CaplProductManager::CreateSubstitute(CaplInstance *pdr, CaplInstance *subst_pdf, CaplInstance *parent_pdf, const TCHAR *id=0, double count=0, CaplInstance *unit=0);

	/**	    .   ATLAS*/
	bool FindPdfSubstitutes(CaplInstance *pdr, CaplInstance *parent_item, aplExtent &ext_pdfs, aplExtent *ext_subst = NULL, bool bFromBase = true);
	
	/**	    .   ATLAS*/
	bool FindPdfSubstitutes(aplExtent &pdrs, CaplInstance *parent_item, aplExtent &ext_pdfs, aplExtent *ext_subst = NULL, bool bFromBase = true);

	/**    
		@param ci  ( )
		@param context  ( )
		@param pdf   (PDF)
		@param rel   (ACU)
		@return true     false    */
	bool StartEffectivityManager(CaplInstance *ci, CaplInstance *pdf, CaplInstance *context, CaplEntity * rel);

	/**          
		@param inInst   (pdf)
		@param recursive     (true  )
		@return true     false    */
	bool DeleteProductVersion(CaplInstance *pdf, bool recursive=false);
	bool DeleteProductWithAllVersion(CaplInstance *prd, bool recursive=false);

	/**        item
	@param item   ,     
	@param res     , , , 
	@return   ( )  NULL   */
	CaplInstance *CreatePdfByDot(CaplInstance *item, aplExtent &res);

	/**  ,  , .
	@param Inst ,  
	@param lpszEditMode  :aplPrdDlgmode
	@param rel 
	@param subs -
	@return true  ,      false   */
	bool ShowProperties(CaplInstance* Inst, aplPrdDlgmode editMode = aplModeEdit, CaplInstance* rel = NULL, CaplInstance* subst = NULL);

	/** ,  , .
	@param Inst  ,   
	@param lpszEditMode  :aplPrdDlgmode
	@return true  ,      false   */
	CaplInstance* CreateProduct(CaplInstance* Inst = NULL, aplPrdDlgmode editMode = aplModeCreateVersion);
	bool CreateSubProduct(CaplInstance* Parent, CaplInstance **BaseItem, CaplInstance** nuao);

	/**   */
	bool CreateProductCopy(CaplInstance* Parent, CaplInstance **BaseItem, CaplInstance** nuao);

	/**  .    */
	static	const TCHAR *StrConvertPdfType2Rus(const TCHAR *type);

	/**      .*/
	static	const TCHAR *StrConvertRus2PdfType(const TCHAR *type);

	//*  .    */
	static	const TCHAR *StrConvertMakeOrBuy2Rus(const TCHAR *src);

	//*      .*/
	static	const TCHAR *StrConvertRus2MakeOrBuy(const TCHAR *src);

	/**     
	@param name  
	@return       */
	CaplInstance* CreateLanguage(LPCTSTR lpszName);

	/**    ()    
	@param techprocess   */
	bool IsTechprocessContainsLockers(CaplInstance *techprocess);

	/**     
	return true     false   */
	bool DeleteLanguage(CaplInstance* Language);

	/**     
	@param <in>  - <out>  
	return true         false   */
	bool SelectLanguage(CaplInstance** SelectedLanguage = NULL);

	/**      
	@param Prd  ( ),       
	@param language ,     
	@param lpszId     language
	@param lpszName     language
	@param lpszCode     language
	@return      */
	CaplInstance* CreateExportProduct(CaplInstance* Item, CaplInstance* language, LPCTSTR lpszId = NULL, LPCTSTR lpszName = NULL, LPCTSTR lpszCode = NULL,
		LPCTSTR lpszPdfId = NULL, LPCTSTR lpszPdfCode = NULL, LPCTSTR lpszPdfCode1 = NULL, LPCTSTR lpszPdfCode2 = NULL, LPCTSTR lpszDescr = NULL);
	
	/**      
	@param Product ,       
	@param ExPrds  
	@param Langs     
	@return true     false    */
	bool FindExportProducts(CaplInstance* Product, aplExtent &ExPrds, aplExtent *Langs = NULL);

	/**      
	@param Product ,       
	@param Language 
	@param bFromBase          
	@return        NULL   */
	CaplInstance* GetExportProduct(CaplInstance* Product, CaplInstance* Language, bool bFromBase = true);

	/**      
	@param Product ,       
	@param Language    
	@return true     false    */
	bool ShowExportProduct(CaplInstance* Product, CaplInstance* Language = NULL);

	/**      */
	bool LoadDictionary();

	/**     
	@param Item       ,    
	@param lpszId   
	@param lpszName   
	@param lpszCode   
	@return    */
	CaplInstance* CreateProductAttrsChange(CaplInstance* Item, LPCTSTR lpszId = NULL, LPCTSTR lpszName = NULL, LPCTSTR lpszCode = NULL, 
		LPCTSTR lpszPdfId = NULL, LPCTSTR lpszPdfCode = NULL, LPCTSTR lpszPdfCode1 = NULL, LPCTSTR lpszPdfCode2 = NULL);

	/**      (     <>  <   >)
	@param Item       
	@param bFromBase          
	@return      NULL,    */
	CaplInstance* FindLastestAttrChange(CaplInstance* Item, bool bFromBase);
	
	/**     
	@param Item       
	@param ext   
	@return true     false    */
	bool FindallAttrsChanges(CaplInstance* Product, aplExtent &ext);

	/**     
	@param Item       ,    
	@return true     false    */
	bool ShowHistory(CaplInstance* Item);

	/**     product_definition_relationship
	@param Pdr  
	@param ext  
	@param load_from_server bcrfnm  
	@return true     false    */
	bool FindAllPDFEffectiviti(CaplInstance* Pdr, aplExtent &ext, bool load_from_server=false);

	/**         
	@param tpo   
	@param bSaveChanes     */
	void ReNumberOperations(aplExtent &tpo, bool bSaveChanes);

	/**         
	@param ext    (PDF_substitute)
	@return true     false    */
	bool LoadSubstituteInfo(aplExtent &ext);

	/**      */
	void FillTechProcessTypeCombo(CComboBox &combo, CaplInstance *process);

	/**      */
	void FillTechProcessClassCombo(CComboBox &combo, CaplInstance *process);

	/**          */
	void SaveTechProcessClass(CComboBox &combo, CaplInstance *process);
	void SaveTechProcessClass(const CString &clas, CaplInstance *process);

	/**          */
	void SaveTechProcessType(CComboBox &combo, CaplInstance *process);
	void SaveTechProcessType(const CString &type, CaplInstance *process);

	/**    "" */
	bool IsGalvanicKvzShop(LPCTSTR shop);
	
	//*    - ,   ..*/
	CArray<CString,CString> m_list_pdf_types;
	
	//*    - ,   ..*/
	CArray<CString,CString> m_list_mob_types;

	/**  -   */
	std::vector<std::pair<CString, CString>> m_techProcessType;

	/**  -   */
	std::vector<std::pair<CString, CString>> m_techProcessClass;

	/**      */
	std::set<CString> m_kvzTermoShops;

	//    PDF    (   ) 
	//    
	// num_change -       
	// bShowResultMessage -    
	// sLog -     ( )
	CaplInstance *GenerateESI(CaplInstance *pdf, LPCTSTR num_change, bool bShowResultMessage, CString *sLog=0);


	bool GenerateESI4Ext(aplExtent &ext,  bool bShowResultMessage);

	//        
	bool CompareDocWintESI(CaplInstance *doc_or_revision);
};


// *************************************************************************
// *************************************************************************
// *************************************************************************
/**  */
class CLASS_DECL_APL_STEP_MGR CaplFolderManager: public CaplStepManager
{
private:
	long m_wait_dialog;
	// 

public:
	static BOOL m_create_assoc_folder_doc;

	CMap<DWORD, DWORD, CString, CString> *m_folders_map;
	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	CaplEntity *e_folder;
	CaplAttr *a_folder_name,*a_folder_descr,*a_folder_parent, *a_folder_guid;
	CaplAttr 	*a_folder_content, *a_folder_contexts;
	CaplAttr 	*a_folder_packet_date,*a_folder_packet_size,*a_folder_packet_body;
	// 
public:
	/**      
		@param folder 
		@param bLoadContent  true,      ,   .   
		@return true     false    */	
	bool LoadFolderInfo(CaplInstance *folder, bool bLoadContent = true);

	/**      
		@param ext 
		@param bLoadContent  true,      ,   .   
		@return true     false    */	
	bool LoadFolderInfo(aplExtent &ext, bool bLoadContent = true);

	/**    
		@param folder 
		@param out_ext    ()
		@param recursive  true    .  false -    
		@param bLoadContent  true,      ,   .   
		@return true     false    */
	bool GetAllSubFolder(CaplInstance *folder,aplExtent &out_ext,bool recursive=false, bool bLoadContent = true);

	/**   
		@param parent  
		@param name  
		@param descr  
		@return    NULL     */
	CaplInstance *CreateFolder(CaplInstance *parent, const TCHAR * name, const TCHAR *descr);

	/**   
		@param folder 
		@return true     false    */
	bool DeleteFolder(CaplInstance *folder);

	/**    
		@param folder  (   )
		@param out_ext    ()
		@return true     false    */
	bool GetFolderContents(CaplInstance *folder,aplExtent &out_ext, bool bWithAttrs = true);
	/**  item  folder 
		@param folder 
		@param item  
		@return true  , - false */
	bool FindInFolder(CaplInstance *folder, CaplInstance *item);

	/**  ,    item 
		@param item  
		@param folders  
		@return true     false    */
	bool FindFolderContained(CaplInstance *item, aplExtent &folders);

	/**  item  folder 
		@param folder 
		@param item  
		@return true     false    */
	bool AddToFolder(CaplInstance *folder, CaplInstance *item);
	bool AddToFolder(CaplInstance *folder, aplExtent &items);
	
	/**  item  folder 
		@param folder 
		@param item  
		@return true     false    */
	bool RemoveFromFolder(CaplInstance *folder,CaplInstance *item);
	bool RemoveFromFolder(CaplInstance *folder, aplExtent &items);

	/**    
		@param folder 
		@return true     false    */
	bool ShowFolderProperties(CaplInstance *folder);

	/**    
		@param folder  
		@param parent     
		@param message -    NULL,    ,     
		@return true     false    */	
	bool MoveFolder(CaplInstance *folder, CaplInstance *parent, CString *message = NULL);

	/**      
		@param folder 
		@param is_hide_move_button
		@param redraw
		@return true     false    */	
	bool MakeTable(CaplInstance *folder,bool is_hide_move_button=true,bool *redraw=0,bool show_assoc_doc=false,bool is_context_menu_categ = false);

	//      SourceSafe
	
	/**        
	    @param folder  
		@param defpath   
		@param checkout        
		@return true     false    */	
	bool CopyDocOnDisk(CaplInstance *folder, CString &defpath, int mode = APL_COPY_DOCS);

	/**        ,       ,     
	    @param folder  
		@param defpath   
		@param checkout        
		@param rec_doc   
		@param set_RO     "  "
		@return true     false    */	
	bool CopyDocOnDisk(aplExtent &docs, CString path, bool recursive = true, int mode = APL_COPY_DOCS, bool rec_doc = true, bool set_RO = true);

	/**	        
		@param doc 
		@param path   
		@param checkout       
		@return true     false    */	
	bool RecursiveCopyDocs(CaplInstance *doc, CString path, int mode = APL_COPY_DOCS, bool set_RO = true);
	
	/**    
		@param folder ,     
		@param defpath   
		@return true     false    */	
	bool AddDocFromDisk(CaplInstance *folder, CString &defpath);
	
	/**     
		@param folder ,     
		@param defpath   
		@return true     false    */	
	bool AddDocFromPath(CaplInstance *folder, CString &defpath);

	/**     
		@param folder ,     
		@param path   
		@param recirsive   
		@return true     false    */	
	bool AddDocPath(CaplInstance *folder, CString path, bool recursive, BOOL UnSetRO = false);
	
	/**  .    
		@param folder  
		@param defpath   
		@return true     false    */	
	bool CheckInAllDocs(CaplInstance *folder, CString &defpath);	
	
	/**  .    
		@param folder   
		@param checkoutdocs       
		@param recursive   
		@param rec_doc   
		@param activate    
		@return true     false    */	
	bool CheckInAllDocs(aplExtent &folder, aplExtent &checkoutdocs, bool recursive = true, bool rec_doc = true, bool activate = true);

	/**  
		@param folder  
		@return true     false    */	
	bool UndoCheckOut(CaplInstance *folder);

	/**  .    
		@param folder   
		@param cdoc     
		@return true     false    */	
	bool UndoCheckOut(aplExtent &folder, aplExtent &cdocs);

	/**	     
		@param folder  
		@param docs    
		@param recursive   
		@return true     false    */	
	bool GetAllSubDocuments(CaplInstance *folder, aplExtent &docs, bool recursive = true);

	/**        
		@param folder   
		@param defpath   
		@return true     false    */	
	bool CompareFolders(CaplInstance *folder, CString &defpath);
	
	/**	    
		@param name  
		@param parent  
		@return     NULL    */
	CaplInstance *FindFolderByName(const TCHAR *name, CaplInstance *parent = 0);

	///    GUID
	CaplInstance *FindFolderByGUID(const TCHAR *s_guid);
	
	/**	   
		@param folder     
		@return true     false   */
	bool CreateFolderOndisk(CString folder);

};
// *************************************************************************
// *************************************************************************
// *************************************************************************
/**  */
class CLASS_DECL_APL_STEP_MGR CaplCharacteristicManager: public CaplStepManager
{
	// 

public:
	struct SCharType
	{
	public:
		SCharType(CaplInstance *charact0, CaplInstance *type0)
		{charact=charact0; type=type0;};
		CaplInstance *charact;
		CaplInstance *type;
	};
	

	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	CStringArray m_sel_charact_names;

	CaplEntity *e_apl_charact;
	CaplAttr *a_apl_charact_id,	*a_apl_charact_name, *a_apl_charact_descr;
	CaplAttr *a_apl_charact_unit, *a_apl_charact_code, *a_apl_charact_full_name;
	CaplAttr *a_apl_charact_module, *a_apl_charact_method;
	CaplAttr *a_apl_charact_dynamic, *a_apl_charact_system,*a_apl_charact_GUID;
	CaplAttr *a_apl_charact_mask_input;
	
	//  
	CaplEntity	*e_apl_change_charact;
	CaplAttr	*a_apl_change_charact_old_val;
	CaplAttr	*a_apl_change_charact_new_val;
	CaplAttr	*a_apl_change_charact_charact;
	CaplAttr	*a_apl_change_charact_delta;
	CaplAttr	*a_apl_change_charact_type;
	CaplAttr	*a_apl_change_charact_basis;

	CaplEntity *e_apl_charact_union;
	CaplAttr *a_apl_charact_union_id,*a_apl_charact_union_name, *a_apl_charact_union_descr;
	CaplAttr *a_apl_charact_union_characteristics;

	CaplEntity *e_apl_charact_value,*e_meas_value, *e_descr_value;
	CaplEntity *e_enum_value, *e_monet_value;
	CaplEntity *e_apl_reference_value;
	CaplEntity *e_aggr_val, *e_time_val;
	CaplEntity *e_table_val, *e_table_row, *e_table_cell;
	CaplEntity *e_apl_reference_comp_unit,	*e_apl_reference_maint_unit, *e_apl_reference_proc_chart_unit;

	CaplAttr *a_apl_charact_val_item, *a_apl_charact_val_charact;
	CaplAttr *a_apl_charact_val_type,*a_apl_charact_val_num,*a_apl_charact_val_scope;
	CaplAttr *a_apl_charact_val_group, *a_apl_charact_val_function;
	CaplAttr *a_apl_charact_val_system, *a_apl_charact_val_notes;

	CaplAttr *a_apl_charact_val_meas_val, *a_apl_charact_val_meas_max, *a_apl_charact_val_meas_min;
	CaplAttr *a_apl_charact_val_descr_val, *a_apl_charact_val_enum_val;
	CaplAttr *a_apl_charact_val_monet_val, *a_apl_charact_val_time_val_s;
	CaplAttr *a_apl_charact_val_aggr_val,*a_apl_charact_val_table_val;
	CaplAttr *a_apl_charact_val_unit;
	CaplAttr *a_apl_charact_val_element;
	CaplAttr *a_apl_charact_val_guid;

	CaplAttr *a_table_cell_column,	*a_table_cell_val;
	CaplAttr *a_table_row_items;
	CaplAttr *a_apl_reference_val;

	CaplEntity *e_apl_charact_type;
	CaplAttr *a_apl_charact_type_name;

	CaplEntity *e_charact_val_group;
	CaplAttr *a_charact_val_group_item,*a_charact_val_group_def;

	CaplEntity *e_apl_unit,*e_apl_aggr_unit,*e_apl_descript_unit;
	CaplEntity *e_apl_time_unit,*e_apl_enum_unit,*e_apl_monetary_unit;
	CaplEntity *e_apl_step_unit,*e_apl_named_unit,*e_apl_derived_unit;
	CaplEntity *e_apl_conv_base_unit,*e_apl_si_unit,*e_apl_cont_dep_unit, 
			   *e_apl_alp_base_unit, *e_mission_apl_alp_base_unit, *e_year_apl_alp_base_unit, *e_flight_days_apl_alp_base_unit;
	CaplEntity *e_table_unit,*e_table_column,*e_apl_reference_unit;
	
	CaplAttr *a_table_column_name,*a_table_column_unit;

	CaplAttr *a_apl_unit_id, *a_apl_unit_shown_id, *a_apl_unit_name, *a_apl_unit_name_eng, *a_apl_unit_prefix, *a_apl_unit_descr, *a_apl_unit_code;

	CaplAttr *a_apl_reference_types,*a_apl_reference_base,*a_apl_reference_format;

	CaplEntity *e_apl_unit_group;
	CaplAttr *a_apl_unit_group_id,*a_apl_unit_group_name,*a_apl_unit_group_description,*a_apl_unit_group_content,*a_apl_unit_group_parent;

	CaplEntity *e_apl_charact_group;
	CaplAttr *a_apl_charact_group_id,*a_apl_charact_group_name,*a_apl_charact_group_description,*a_apl_charact_group_content,*a_apl_charact_group_parent;

	CaplEntity *e_apl_charact_union_group;
	CaplAttr *a_apl_charact_union_group_id,*a_apl_charact_union_group_name,*a_apl_charact_union_group_description,*a_apl_charact_union_group_content,*a_apl_charact_union_group_parent;


	CaplAttr *a_apl_charact_val_act_ver,*a_apl_charact_val_lock_ver,*a_apl_charact_val_base_item;
	
	// 
	CaplEntity *e_apl_charact_value_ver;
	CaplEntity *e_enum_value_ver, *e_monet_value_ver,*e_meas_value_ver;
	CaplEntity *e_apl_reference_value_ver, *e_time_val_ver,*e_descr_value_ver;
	CaplEntity *e_aggr_val_ver, *e_table_val_ver;
	CaplEntity *e_table_row_ver, *e_table_cell_ver;


	CaplAttr *a_apl_charact_val_ver_char_value,*a_apl_charact_val_ver_author,*a_apl_charact_val_ver_start_date;
	CaplAttr *a_apl_charact_val_ver_end_date,*a_apl_charact_val_ver_version_num,*a_apl_charact_val_ver_base;
	CaplAttr *a_apl_charact_val_ver_item,*a_apl_charact_val_ver_charact,*a_apl_charact_val_ver_scope;
	CaplAttr *a_apl_charact_val_ver_num,*a_apl_charact_val_ver_type;
	CaplAttr *a_apl_charact_val_ver_is_changed, *a_apl_charact_val_ver_function;
	
	CaplAttr *a_apl_charact_val_ver_meas_val, *a_apl_charact_val_ver_meas_max, *a_apl_charact_val_ver_meas_min;
	CaplAttr *a_apl_charact_val_ver_descr_val, *a_apl_charact_val_ver_enum_val;
	CaplAttr *a_apl_charact_val_ver_monet_val, *a_apl_charact_val_ver_time_val_s,*a_apl_reference_val_ver_val;
	CaplAttr *a_apl_charact_val_ver_aggr_val;
	CaplAttr *a_apl_charact_val_ver_table_val,*a_table_row_ver_items;
	CaplAttr *a_table_cell_ver_column,	*a_table_cell_ver_val;

	// ,    
	CaplEntity	*e_apl_characteristic_and_type;
	CaplAttr	*a_apl_characteristic_and_type_base_item;
	CaplAttr	*a_apl_characteristic_and_type_characteristic;
	CaplAttr	*a_apl_characteristic_and_type_type;
	CaplAttr	*a_apl_characteristic_and_type_required;
	
	//	,       .
	CaplEntity	*e_apl_unit_convertion;
	CaplAttr	*a_apl_unit_convertion_item;
	CaplAttr	*a_apl_unit_convertion_base_unit;
	CaplAttr	*a_apl_unit_convertion_add_unit;
	CaplAttr	*a_apl_unit_convertion_base_unit_koef;
	CaplAttr	*a_apl_unit_convertion_add_unit_koef;
	

		
	static bool m_bUseVersions;
	// 
public:
	/**              
	@param selected_charact_union      
	@param selected_group     
	@return instance   ,  0 */ 	
	CaplInstance *SelectCharactUnionGroup(CaplInstance *selected_charact_union=0,CaplInstance *selected_group=0);

	/**           
	@param selected_characteristic     
	@param selected_group     
	@return instance  ,  0 */ 
	CaplInstance *SelectCharacteristic(CaplInstance *selected_characteristic=0,CaplInstance *selected_group=0);
	
	/**             
	@param selected_unit   .   
	@param selected_group     
	@return instance   ,  0 */ 
	CaplInstance *SelectUnit(CaplInstance *selected_unit=0,CaplInstance *selected_group=0);
	/**       . . 
		@return true     false    */ 
	bool LoadDictionary();

	/**        
		@param id    
		@return       NULL    */
	CaplInstance *GetUnitById(const TCHAR * id);

	/**       
		@param id   
		@return      NULL    */
	CaplInstance *GetCharacteristicById(const TCHAR * id);

	/**       
		@param name   
		@return      NULL    */
	CaplInstance *GetCharacteristicBN(const TCHAR * name);


	/**     
		@param inst  
		@param characteristic  
		@return      NULL    */
	CaplInstance * GetInstCharacteristic(CaplInstance *inst,CaplInstance *characteristic);

	/**    
		@param ass -  
		@return true     false    */ 
	bool LoadCharacteristicChange(CaplInstance *val);

	/**     
		@param aggr -   
		@return true     false    */ 
	bool LoadCharacteristicChange(aplExtent& ext);

	/**    
		@param ass -  
		@return true     false    */ 
	bool LoadCharacteristic(CaplInstance *val);
	/**     
		@param aggr -   
		@return true     false    */ 
	bool LoadCharacteristic(CaplAggr &aggr);
	/**     
		@param ext -   
		@return true     false    */ 
	bool LoadCharacteristic(aplExtent &ext,bool show_status_dlg=false);

	/**         
		@param item  
		@param ext    
		@param characreristic */
	bool FindAssociatedCharacteristicChange(CaplInstance *item, aplExtent &ext, CaplInstance *characreristic = 0);

	/**        
		@param item  
		@param characreristic 
		@param type   */ 
	CaplInstance *FindCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type,bool find_in_all_versions=false,bool load_from_bd=true);
	/**      
		@param inst  
		@param out_ext         ()
		@param out_group        ()
		@param load_table  true,       
		@param find_in_all_versions  true,         
		@param from_base      .  false    
		@return      NULL    */
	bool FindAssociatedCharacteristic(CaplInstance *inst, aplExtent &out_ext, aplExtent &out_group,bool load_table=false,bool find_in_all_versions=false, bool from_base=true, bool with_system=true);
	bool FindAssociatedCharacteristic(CaplInstance *inst, aplExtent &out_ext, bool load_table=false,bool find_in_all_versions=false,bool show_status_dlg=false, bool from_base=true, bool with_system=true);
	bool FindAssociatedCharacteristics(CaplInstance *inst, aplExtent &out_ext, bool bFromBase=true);
	/**       
		@param ext  
		@param out_ext         ()
		@param out_group        ()
		@param load_table  true,       
		@param find_in_all_versions  true,         
		@param show_status_dlg     (   )
		@return      NULL    */
	bool FindAssociatedCharacteristic(aplExtent &ext, aplExtent &out_ext, aplExtent &out_group,bool load_table=false,bool find_in_all_versions=false,bool show_status_dlg=false, bool from_base=true, bool with_system=true);
	bool FindAssociatedCharacteristic(aplExtent &ext, aplExtent &out_ext, bool load_table=false,bool find_in_all_versions=false,bool show_status_dlg=false, bool from_base=true, bool with_system=true);
	bool FindAssociatedCharacteristics(aplExtent &ext, aplExtent &out_ext, bool bFromBase=true);
	/**     
		@param  
		@param out_ext         ()
		@return true     false    */ 
	bool GetGroupContents(CaplInstance *group,aplExtent &ext_out);
	/**      
		@param type    
		@return      NULL    */
	CaplInstance *GetCharacteristicType(const TCHAR * type);


	/**     
		@param val -   
		@return true     false    */ 
	bool ShowProperties(CaplInstance *val,bool locked_type=false);
	
	/**     
		@param  item -  
		@return true     false    */ 
	bool ShowItemProperties(CaplInstance *item);

	/**      
		@param  group -  
		@return true     false    */ 

	bool ShowGroupProperties(CaplInstance *group);
	/**    c   
		@param item  
		@param base_val -    (   )
		@param val -   
		@param new_charact -  
		@param val_ver -   
		@param check_out -    ( )
		@return true     false    */ 
	bool CreateCharacteristic(CaplInstance *item, CaplInstance *base_val, CaplInstance **val, CaplInstance *new_charact=0,CaplInstance **val_ver=0,bool check_out=false,CaplInstance *group=0,bool show_dlg=true,CaplInstance *new_type=(CaplInstance*)-1);

	/**     c   
		@param item  
		@param base_group -   (   )
		@param group -  
		@return true     false    */ 
	bool CreateCharacteristicGroup(CaplInstance *item, CaplInstance **group, CaplInstance *base_group=0,bool show_dlg=true);

	/**         
		@param unit    
		@param name    
		@return    NULL    */
	CaplInstance *GetColumnByName(CaplInstance *unit, const TCHAR * name);

	/**       
		@param row   
		@param column   
		@return    NULL    */
	CaplInstance *GetColumnValue(CaplInstance *row, CaplInstance *column);

	/**       
		@param table_value    
		@param row    
		@param column   
		@return    NULL    */
	CaplInstance *GetColumnValue(CaplInstance *table_value, int row, CaplInstance *column);

	/**  ()     
		@param row   
		@param column   
		@param value    
		@return     NULL     */
	CaplInstance *PutCellInRow(CaplInstance *row, CaplInstance *column, CaplInstance *value);

	/**       
		@param val -   
		@param delete_all -    (        (  ))
		@param delete_only_version -     (  -) 
		@return true     false    */
	bool DeleteCharacteristic( CaplInstance *val,bool delete_all=false,bool delete_only_version=false, bool bLoadFromBase = true);
	
	/**    
		@param group -  
		@return true     false    */
	bool DeleteCharacteristicGroup(CaplInstance *group);
	
	/**        item*/
	bool DeleteAllAssociatedCharacteristic(CaplInstance *item);

	/**      
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance *CreateDescriptiveCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, const TCHAR *value);
	
	/**      
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@param max_dev     
		@param min_dev     
		@return     NULL     */
	CaplInstance *CreateMeasuredCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, double value, double max_dev,  double min_dev);

	/**      
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance *CreateMonetaryCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, double value);

	/**     
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance *CreateEnumerationCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, const TCHAR *value);

	/**     
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance *CreateReferenceCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, CaplInstance *value);
	
	/**       
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance *CreateDateTimeCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, COleDateTime &value);
	/**       
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance *CreateDateTimeCharacteristic(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, const TCHAR *s_value);

	/**    
		@param item  
		@param characteristic  
		@param type   
		@param value    
		@return     NULL     */
	CaplInstance* CreateAggrCharacteristicValue(CaplInstance *item,CaplInstance *characreristic, CaplInstance *type, aplExtent& value);

	/**     
		@param unit  
		@param buf     
		@param bAlwaysReturnName  true -   ,  false -   ,    
		@return true     false    */
	bool GetUnitName(CaplInstance *unit, CString &buf, bool bAlwaysReturnName=false);

	/**      
		@param val  
		@param unit  
		@param buf     
		@return true     false    */
	bool PrintCharacteristicValue(CaplInstance *val,CaplInstance *unit,CString &buf, bool full_print=false);

	/**   
		@param old_inst   
		@param new_inst   ( 0 -    )
		@return     NULL     */
	CaplInstance* CreateCopyCharacteristicVal(CaplInstance* old_inst, CaplInstance* new_inst=0, CaplMap *inst_map=0);

	/**        
		@param val  
		@param ext  extent
		@return true     false    */
	bool AppendExtReferenceValues(CaplInstance *val, aplExtent &ext);

	/**      
		@param unit     
		@return    NULL   o  */
	CaplInstance* BrowseReferenceVal(CaplInstance* unit);
	/**    
		@param val     
//		@param create_new_version    ( == false, 
		 ,    ,    ) 
		@return true     false    */
//	bool CheckOut(CaplInstance *val,bool create_new_version=true);
	bool CheckOut(CaplInstance *val);
	/**    
		@param val  
		//@param create_new_version     ( == false,     )
		@param make_new_version_active     
		@return true     false    */
	bool CheckIn(CaplInstance *val,bool make_new_version_active=true);
//	bool CheckIn(CaplInstance *val,bool create_new_version=true,bool make_new_version_active=true);
	/**    
		@param ext    
		@param ext_out    
		@return true     false    */
	CaplInstance *GetLock(CaplInstance *val,bool bShowMessages); 
	/**     
		@param val     
		@param bShowMessages       
		@return instance   */
	CaplInstance *CheckMyLock(CaplInstance *val,bool bShowMessages); 
	/**   
		@param val  
		@param ask_before_undo     
		@return instance  */
	bool UndoCheckOut(CaplInstance *val,bool ask_before_undo=true);
	/**     
		@param group  
		@return true     false    */
	bool CheckOutGroup(CaplInstance *group);
	/**    
		@param group  
		@return true     false    */
	bool CheckInGroup(CaplInstance *group);
	/**    
		@param group  
		@param ask_before_undo   
		@return true     false    */
	bool UndoCheckOutGroup(CaplInstance *group,bool ask_before_undo=true);
	/**         
		@param val     
		@param val_ver   
		@return true   ,  - false*/
	bool IsValueChanged(CaplInstance *val,CaplInstance *val_ver);	
	/**     
		@param val     
		@param ext_out   ()
		@return true    , false*/
	bool GetAllCharactVersion(CaplInstance *val,aplExtent &outExt, bool bLoadFromBase = true);
	/**     
		@param vals     
		@param ext_out   ()
		@return true    , false*/
	bool GetAllCharactVersion(aplExtent& vals, aplExtent &outExt, bool bLoadFromBase = true);
	/**    
		@param val     
		@param num    (  "-1"   )
		@param make_active     (        )
		@param only_values       (   )
		@return instance   */
	CaplInstance *CreateCharValVersion(CaplInstance *val,CString num=_T("-1"),bool make_active=true,bool only_values=false);
	/**   ( )  
		@param val  
		@param num   
		@return instance    0    */
	CaplInstance *GetLatestCharValVersion(CaplInstance *val,CString &num, bool load_from_db=true);
	/**       
		@param val_ver   
		@param val   ( 0,  ) 
		@param load_from_db         ( true,  )
		@return instance    */
	CaplInstance *CopyValVersionToVal(CaplInstance *val_ver,CaplInstance *val=0);
	/**    
		@param val_ver   
		@return true    , false*/
	bool MakeCharValVersionActive(CaplInstance *val_ver);
	/**	     delta
		@param value  
		@param delta  
		@param type   
		@param bp_inst        
		@param new_val     
		@return   */
	CaplInstance* ChangeCharactValue(CaplInstance* value, double delta, CaplInstance* bp_inst, CString type = _T("delta"), CaplInstance **new_val_ver=0);

	/**	       .
		@param map  .   -   long ,    0;
		@param characteristic   
		@param type    
		@param num_izm  .   -1,       
		@return true     false   .        map.*/

	bool GetInstancesCharact(CaplMap &map, CaplInstance *charact, CaplInstance *type,bool load_from_bd=true, int num_izm=-1);

	/**	 -    
		@param characteristic 
		@param type  
		@param item  ,    
		@param required   
		@param ext_mode  true,       ""
		@param ext_tested   ,       -
	   ;     ,    - 
	 
		@return   -       0   */
	CaplInstance* CreateCharacteristicAndType(CaplInstance* characteristic, CaplInstance* type, CaplInstance *item=0,bool required=false,bool ext_mode=false,aplExtent *ext_tested=0);

	/**	  -    
		@param characteristic_and_type   - 
		@return true     false   .*/
	bool CharacteristicAndTypeProperties(CaplInstance* characteristic_and_type,bool forced_ro=false,bool ext_mode=false);

	/**	
		@param 
		@param 
		@param 
		@param 
		@return   -       0   */
	int ShowCharacteristicAndTypeDialog(CaplInstance** characteristic, CaplInstance** type, bool &required,bool ext_mode=false);

	/**	
		@param item       
		@param 
		@return true   , false   */
	bool IsCharacteristicNumber(CaplInstance* item);

		/**	
		@param item       
		@param 
		@return true     , false   */
	bool IsCharacteristicDate(CaplInstance* item);
	
	/**      */
	bool ShowCharactChanges(CaplInstance *characteristic);

	/**      */
	bool SetupUnitConvertion(CaplInstance *ciPdf, CaplInstance *ciUnit, double dBaseCount);


	/**         - pdf*/
	void GetPossiblePdfUnits( CaplInstance *ciPdf, aplExtent &unitsExt );

};

// *************************************************************************
// *************************************************************************
// *************************************************************************
// *************************************************************************
// *************************************************************************
// *************************************************************************
/**  -*/
class CLASS_DECL_APL_STEP_MGR CaplBPManager: public CaplStepManager
{
	// 
public:
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	/**@name - ( ) */
	//@{
	CaplEntity *e_bp;		/**<apl_business_process */
	CaplAttr *a_bp_id;		/**<apl_business_process -> id */
	CaplAttr *a_bp_name;	/**<apl_business_process -> name */
	CaplAttr *a_bp_descr;	/**<apl_business_process -> description */
	CaplAttr *a_bp_code;	/**<apl_business_process -> code */
	CaplAttr *a_bp_elements;/**<apl_business_process -> elements */ 
	CaplAttr *a_bp_type;	/**<apl_business_process -> type */
	CaplAttr *a_bp_lock;	/**<apl_business_process -> locker */
	CaplAttr *a_bp_act;		/**<apl_business_process -> active_version */
	CaplAttr *a_bp_res;		/**<apl_business_process -> resources */
	CaplAttr *a_bp_parent;	/**<apl_business_process -> main_parent */
	CaplAttr *a_bp_label;	/**<apl_business_process -> label */
	CaplAttr *a_bp_state;	/**<apl_business_process -> state */
	CaplAttr *a_bp_guid;	/**<apl_business_process -> guid */
	CaplAttr *a_bp_date_time;	/**<apl_business_process -> date_time */
	CaplAttr *a_bp_customized;	/**<apl_business_process -> customized */
	CaplAttr *a_bp_optional;	/**<apl_business_process -> optional */
	CaplAttr *a_bp_source;		/**<apl_business_process -> source */

	CaplAttr *a_bp_org;	/**<apl_business_process -> organization */
	CaplAttr *a_bp_class;	/**<apl_business_process ->  class*/
	CaplAttr *a_bp_percentage_of_otk;	/**<apl_business_process -> percentage_of_otk */
	CaplAttr *a_bp_number_of_simultaneously_processed_parts;	/**<apl_business_process -> number_of_simultaneously_processed_parts */
	CaplAttr *a_bp_t_sht;	/**<apl_business_process -> t_sht */
	CaplAttr *a_bp_t_pz;	/**<apl_business_process -> t_pz */
	CaplAttr *a_bp_coat;	/**<apl_business_process -> coat */
	CaplAttr *a_bp_directive;	/**<apl_business_process -> directive */


	//@}

	/**@name  - ( ) */
	//@{
	CaplEntity *e_bp_rel;					/**<apl_business_process_relation */
	CaplAttr *a_bp_rel_id;					/**<apl_business_process_relation -> id */
	CaplAttr *a_bp_rel_name;				/**<apl_business_process_relation -> name */
	CaplAttr *a_bp_rel_descr;				/**<apl_business_process_relation -> description */
	CaplAttr *a_bp_rel_from;				/**<apl_business_process_relation -> from */
	CaplAttr *a_bp_rel_to;					/**<apl_business_process_relation -> to */
	//@}

	/**@name  - ( ) */
	//@{
	CaplEntity *e_bp_type;		/**<apl_business_process_type */
	CaplAttr *a_bp_type_name;	/**<apl_business_process_type -> name */
	//@}

	/**@name  - ( ) */
	//@{
	CaplEntity *e_bp_ref;					/**<apl_business_process_reference */
	CaplAttr *a_bp_ref_item;				/**<apl_business_process_reference -> item */
	CaplAttr *a_bp_ref_process;				/**<apl_business_process_reference -> assigned_process */
	CaplAttr *a_bp_ref_id;					/**<apl_business_process_reference -> id */
	CaplAttr *a_bp_ref_name;				/**<apl_business_process_reference -> name */
	CaplAttr *a_bp_ref_ranking;				/**<apl_business_process_reference -> ranking */
	CaplAttr *a_bp_ref_ranking_rat;			/**<apl_business_process_reference -> ranking_rationale */
	CaplAttr *a_bp_ref_frames_of_reference;	/**<apl_business_process_reference -> apl_frames_of_reference */
	CaplAttr *a_bp_ref_zagotov;				/**<apl_business_process_reference -> zagotov */
	CaplAttr *a_bp_ref_guid;
	//@}

	/**@name  ( ) */
	//@{
	CaplEntity *e_bp_res;					/**<apl_business_process_resource */
	CaplAttr *a_bp_res_id;					/**<apl_business_process_resource -> id */
	CaplAttr *a_bp_res_name;				/**<apl_business_process_resource -> name */
	CaplAttr *a_bp_res_descr;				/**<apl_business_process_resource -> description */
	CaplAttr *a_bp_res_type;				/**<apl_business_process_resource -> type */
	CaplAttr *a_bp_res_object;				/**<apl_business_process_resource -> object */
	 
	CaplAttr *a_bp_res_val;					/**<apl_business_process_resource -> value_component */
	CaplAttr *a_bp_res_unit;				/**<apl_business_process_resource -> unit -> component */
	CaplAttr *a_bp_res_process;				/**<apl_business_process_resource -> process */
	CaplAttr *a_bp_res_derive_val;			/**<apl_business_process_resource -> derive_value_component */
	CaplAttr *a_bp_res_derive_unit;			/**<apl_business_process_resource -> derive_unit_component */
	CaplAttr *a_bp_res_assortment;			/**<apl_business_process_resource -> apl_assortment */
	CaplAttr *a_bp_res_ranking;				/**<apl_business_process_resource -> ranking */
	CaplAttr *a_bp_res_ranking_rationale;	/**<apl_business_process_resource -> ranking_rationale */
	//@}

	/**@name   ( ) */
	//@{
	CaplEntity *e_bp_res_type;				/**<apl_business_process_resource_type */
	CaplAttr *a_bp_res_type_name;			/**<apl_business_process_resource_type -> name */
	//@}

	/**@name  ( ) */
	//@{
	CaplEntity *e_apl_bp_ver;				/**<apl_business_process_version */
	CaplAttr *a_bp_ver_bp;					/**<apl_business_process_version -> process */
	CaplAttr *a_bp_ver_id;					/**<apl_business_process_version -> id */
	CaplAttr *a_bp_ver_name;				/**<apl_business_process_version -> name */
	CaplAttr *a_bp_ver_descr;				/**<apl_business_process_version -> description */
	CaplAttr *a_bp_ver_code;				/**<apl_business_process_version -> code */
	CaplAttr *a_bp_ver_type;				/**<apl_business_process_version -> type */
	CaplAttr *a_bp_ver_author;				/**<apl_business_process_version -> author */
	CaplAttr *a_bp_ver_start;				/**<apl_business_process_version -> start_date */
	CaplAttr *a_bp_ver_end;					/**<apl_business_process_version -> end_date */
	CaplAttr *a_bp_ver_num;					/**<apl_business_process_version -> number */
	CaplAttr *a_bp_ver_elements;			/**<apl_business_process_version -> elements */
	CaplAttr *a_bp_ver_base;				/**<apl_business_process_version -> base */
	CaplAttr *a_bp_ver_res;					/**<apl_business_process_version -> resources */
	CaplAttr *a_bp_ver_label;				/**<apl_business_process_version -> label */
	CaplAttr *a_bp_ver_char_val_versions;	/**<apl_business_process_version -> characteristic_value_versions */
	CaplAttr *a_bp_ver_basis;				/**<apl_business_process_version -> basis */
	CaplAttr *a_bp_ver_guid;				/**<apl_business_process_version -> guid */
	CaplAttr *a_bp_ver_customized;				/**<apl_business_process_version -> customized */
	CaplAttr *a_bp_ver_optional;			/**<apl_business_process_version -> optional */

	CaplAttr *a_bp_ver_org;				/**<apl_business_process_version -> org */
	CaplAttr *a_bp_ver_class;				/**<apl_business_process_version -> class */
	CaplAttr *a_bp_ver_percentage_of_otk;				/**<apl_business_process_version -> percentage_of_otk */
	CaplAttr *a_bp_ver_number_of_simultaneously_processed_parts;				/**<apl_business_process_version -> number_of_simultaneously_processed_parts */
	CaplAttr *a_bp_ver_t_sht;				/**<apl_business_process_version -> t_sht */
	CaplAttr *a_bp_ver_t_pz;				/**<apl_business_process_version -> t_pz */
	CaplAttr *a_bp_ver_coat;				/**<apl_business_process_version -> coat */
	CaplAttr *a_bp_ver_directive;				/**<apl_business_process_version -> directive */

	//@}
	
	/**@name  - ( ) */
	//@{
	CaplEntity *e_apl_bp_inst;				/**<apl_business_process_instance */
	CaplAttr *a_bp_inst_id;					/**<apl_business_process_instance -> id */
	CaplAttr *a_bp_inst_name;				/**<apl_business_process_instance -> name */
	CaplAttr *a_bp_inst_descr;				/**<apl_business_process_instance -> description */
	CaplAttr *a_bp_inst_process;			/**<apl_business_process_instance -> process */
	CaplAttr *a_bp_inst_elements;			/**<apl_business_process_instance -> elements */
	CaplAttr *a_bp_inst_res;				/**<apl_business_process_instance -> resources */
	CaplAttr *a_bp_inst_date_time;          /**<apl_business_process_instance -> date_time */
	CaplAttr *a_bp_inst_state;				/**<apl_business_process_instance -> new_state> */
	CaplAttr *a_bp_inst_end_datetime;		/**<apl_business_process_instance -> end_date> */
	CaplAttr *a_bp_inst_basis;				/**<apl_business_process_instance -> basis> */
	CaplAttr *a_bp_inst_duration;			/**<apl_business_process_instance -> duration> */
	CaplAttr *a_bp_inst_guid;
	//@}

	/**@name   - ( ) */
	//@{
	CaplEntity *e_bp_inst_ref;					 /**<apl_business_process_instance_reference */
	CaplAttr *a_bp_inst_ref_item;				 /**<apl_business_process_instance_reference -> item */
	CaplAttr *a_bp_inst_ref_process;			 /**<apl_business_process_instance_reference -> assigned_process_instance */
	CaplAttr *a_bp_inst_ref_id;					 /**<apl_business_process_instance_reference -> id */
	CaplAttr *a_bp_inst_ref_name;				 /**<apl_business_process_instance_reference -> name */
	CaplAttr *a_bp_inst_ref_frames_of_reference; /**<apl_business_process_instance_reference -> apl_frames_of_reference */
	CaplAttr *a_bp_inst_ref_guid;
	//@}

	static bool m_bShowId;
	static bool m_bShowName;
	static bool m_bShowType;
	static bool m_bRecursive;
	static bool m_bCheckUniqs;

	#define APL_MODE_COPY_BP      0x00000
	#define APL_MODE_CREATE_BP    0x00001

	CString m_sIdPostfixForCreateBPCopy; //      CreateBPCopy.  ,   "_" 

	//    
	bool m_apply_to_all;/**        **/
	bool m_undo_check_out;/**      **/
protected:
	//     / 
	bool m_status_dlg_created;/**    **/ 
	int m_status_count;/**    **/
	int m_level;
	
	//,     -/ 
	aplExtent ext_bps;

	// 
public:
	/**         -*/
	bool LoadDictionary();

	/**   - 
	  @param  base_bp   - 
	  @param  item  ,      - 
	  @param  id  id -   
	  @param  name  -   
	  @param  type  -   
	  @param  creation_mode      - 
  		  APL_MODE_COPY_BP -    - (base_bp) <br>
		  APL_MODE_CREATE_BP -   -<br>
	  @param  rel    -  item				
	  @param  context     
	  @param  descr  -  
	  @param  code  -  
	  @param  label  -  
	  @param  show_dlg    - (   id   (      ))
	  @return   	*/
	CaplInstance *CreateBP(CaplInstance *base_bp=0,CaplInstance *item=0, const TCHAR *id=0, const TCHAR *name=0, CaplInstance *type=0,long creation_mode=APL_MODE_CREATE_BP,CaplInstance **rel=0,CaplInstance *context=0,const TCHAR *descr=0,const TCHAR *code=0,const TCHAR *label=0,bool show_dlg=true);

	/**   - 
	  @param  base_bp  -,    
	  @param  id   -
	  @param  name  - 
	  @param  descr  -
	  @param  item  ,      - 
	  @param  context    c item
	  @param  rel    -  item				
	  @param  parent_bp -  (    )
	  @param  recursive     
	  @return   	*/
	CaplInstance *CreateBPCopy(CaplInstance *base_bp,const TCHAR *id=0, const TCHAR *name=0,const TCHAR *descr=0,CaplInstance *item=0, CaplInstance *context=0,CaplInstance **rel=0,CaplInstance *parent_bp=0,bool recursive=true);

	/**     -
	  @param  inst -   - 
	  @param  base_res_or_pdr    pdr
	  @param  object ,    
	  @param  id  
	  @param  name  
	  @param  descr  
	  @param  type  
	  @param  show_dlg         (   object) 
	  @return   	*/	
	CaplInstance *CreateBPResource(CaplInstance *inst,CaplInstance *base_res_or_pdr=0,CaplInstance *object=0,const TCHAR *id=0, const TCHAR *name=0,const TCHAR *descr=0, CaplInstance *type=0,bool show_dlg=true);

	/**     - */
	bool ShowBPProperties(CaplInstance *bp,CaplInstance *bp_ref=0,bool *is_ok=0);

	/**      - 
	  @param  res  - 
	  @param  new_res  -    
	  @param  bp_rev  - (      ) */
	bool CaplBPManager::ShowBPResourceProperties(CaplInstance *res,CaplInstance **new_res,CaplInstance *bp_rev=0);

	/**      - */
	bool LoadBPInfo(CaplInstance *bp,bool bLoadSubBpInfo=true);

	/**       - */
	bool LoadBPInfo(aplExtent  &ext,bool bLoadSubBpInfo=false,bool show_status_dlg=false);

	/**     */
	bool DeleteBP(CaplInstance *bp, bool delete_sub_bp=true, CaplInstance *deleted_parent=0);

	/**  -        NULL      */
	CaplInstance *FindBPById(const TCHAR *id, bool bAutoLoadInfo = true);

	/**    -,    - ()
		@param bp -
		@param ext       - ()
		@return true     false    */
	bool WhereUsedBP(CaplInstance *bp, aplExtent &ext, aplExtent *refs = NULL, bool bReferenceOnly = false);
	bool WhereUsedBP(aplExtent &items, aplExtent &ext, aplExtent *refs = NULL, bool bReferenceOnly = false);

	/**   out_ext  -  Instance 
		@param inst  ,     
		@param out_ext       - ()
		@param out_rel        ()
		@param context    ( ==0  )
		@return true     false    */
	bool FindAssociatedBP(CaplInstance *inst, aplExtent &out_ext, aplExtent &out_rel,CaplInstance *context=0,bool from_base=true); 
	/**   out_ext  -   ext 
		@param ext  ,     
		@param out_ext       - ()
		@param out_rel        ()
		@param context    ( ==0  )
		@param show_status_dlg     (   )
		@return true     false    */
	bool FindAssociatedBP(aplExtent &ext, aplExtent &out_ext, aplExtent &out_rel,CaplInstance *context=0,bool b_loadInfo=true,bool show_status_dlg=false); 
	/**   inst c bp 
		@param inst  ,     
		@param bp  -,    
		@param id    
		@param zagotov       (pdr)
		@return    NULL    */
	CaplInstance *CreateAssociation(CaplInstance *inst,CaplInstance *bp, const TCHAR *id=0,CaplInstance *zagotov=0);
	/**     inst 
		@param inst  ,     
		@param bp  -,   
		@return    NULL     */
	CaplInstance *FindAssociation(CaplInstance *inst,CaplInstance *bp);

	/**      */
	bool LoadAllBPResources(CaplInstance *bp, aplExtent &ext);

	/**  -   -
		@param base_bp -,   
		@param sub_bp   - */
	bool AddBPToBP(CaplInstance *sub_bp, CaplInstance *base_bp);
	
	/**    -  
		@param bp -
		@param outExt    - ()
		@return true     false    */
	bool CaplBPManager::GetAllBPVersion(CaplInstance *bp,aplExtent &outExt);
	bool CaplBPManager::GetAllBPVersion(aplExtent& bp_ext,aplExtent &outExt);

	/**    -
		@param sub_bp 
		@param base_bp      ()
		@return true     false    */
	bool DeleteBPRelation(CaplInstance *sub_bp,CaplInstance *base_bp);

	/**  ()   -.
		        
		. 
		@param bp -   
		@param ext_out    
		@return true     false    */
	bool GetAllSubBP(CaplInstance *bp,aplExtent &ext_out);
		/**  ()    -
		        
		. 
		@param bp_ext  -  
		@param ext_out    
		@return true     false    */
	bool GetAllSubBP(aplExtent &bp_ext,aplExtent &ext_out);

	/**    -   -
		@param bp_ext  -
		@param ext_out    - 
		@return true     false    */
	bool GetBPInstForBP(aplExtent &bp_ext,aplExtent &ext_out);

	/**    -  -
		@param bp -
		@param ext_out    - 
		@return true     false    */
	bool GetBPInstForBP(CaplInstance* bp,aplExtent &ext_out);
	
		/**  ()   ,     
		@param inst  -
		@param ext_out    
		@return true     false    */
	bool GetAllSubBPInst(CaplInstance *inst, aplExtent &ext);

	/**     -        
		@param selected_doc_type   -   
		@param selected_group     -   
		@return instance   -,  0 */ 
	CaplInstance* SelectBpType(CaplInstance *selected_bp_type,CaplInstance *selected_group);

	/**   customized ()       
		@param bp  
		@param bustomized  
		@return true     false    */
	bool SetCustomizedRecursive(CaplInstance *bp, bool bustomized);

	/**@name    */
	//@{

	// **************************************************
	//   
	// **************************************************
	
	/**  -   
		@param bp  -    */
	bool CheckOut( CaplInstance *bp,bool recursive=false);
	/**  -   c   
		@param bp  -    
		@param recursive      - */
	bool CheckOutWithRequest( CaplInstance *bp,bool &recursive=m_bRecursive);

	/**    -  
		@param bp  - 
		@param recursive     - 
		//@param create_new_version     ( == false,     )
		@param make_new_version_active     */
	//bool CheckIn( CaplInstance *bp,bool recursive=false,bool create_new_version=true,bool make_new_version_active=true);
	bool CheckIn(CaplInstance *bp,bool recursive=false,bool make_new_version_active=true);
	/**   - c   
		@param bp  - 
		@param recursive     - */
	bool CheckInWithRequest( CaplInstance *bp,bool &recursive=m_bRecursive);

	/**    */
	bool UndoCheckOut( CaplInstance *bp,bool recursive=false);
	/**   - c   
		@param bp  - */
	bool UndoCheckOutWithRequest(CaplInstance *bp,bool &recursive=m_bRecursive);

	/**   ,          
		@param bp   -   
		@return  -, 0 */
	CaplInstance *GetLock(CaplInstance *bp, bool bShowMessages);

	/**     ,          */
	CaplInstance *CheckMyLock(CaplInstance *bp, bool bShowMessages);

	/** ,  -    
		@param bp   -   
		@return true,   ,false -   .  ,    */
	bool CheckMyLockAndCheckOut(CaplInstance *bp);
	/**    - (  )
		@param bp  - 
		@param num   
		@return   -,0    */
	CaplInstance *GetLatestBPVersion(CaplInstance *bp,CString &num);
	/**   -
		@param bp  -   
		@param num    (-1   )
		@param make_active    
		@return   -, 0    */
	CaplInstance *CreateBPVersion(CaplInstance *bp,CString num=_T("-1"),bool make_active=true);
	/**   - 
		@param bp  - 
		@return true     false    */
	bool MakeBPVersionActive(CaplInstance *bp_ver);
	/** ,   -    .
		@param bp -
		@param bp_ver  -
		@return true   (  )  false   */
	bool IsBPChanged(CaplInstance *bp,CaplInstance *bp_ver);
	/**     - */
	bool ShowBPChanges(CaplInstance *bp);
	// **************************************************
	//  -
	// **************************************************
	/**    - 
	  @param  base_bp_inst  - - 
	  @param  id  id  -   
	  @param  name   -   
	  @param  descr   -   
	  @param  bp   - 
	  @param  item     
	  @param  context     
	  @param  rel    -  item				
	  @param  show_dlg     - (   id)
	  @return   	*/
	CaplInstance *CreateBPInst(CaplInstance *base_bp_inst=0,const TCHAR *id=0,const TCHAR *name=0,const TCHAR *descr=0,CaplInstance *bp=0,CaplInstance *item=0,CaplInstance *context=0,CaplInstance **rel=0,bool show_dlg=true);
	/**    - 
	  @param  base_bp_inst  -,    
	  @param  id    -
	  @param  name   - 
	  @param  descr   -
	  @param  bp   - 
	  @param  item  ,       - 
	  @param  context    c item
	  @param  rel     -  item				
	  @param  parent_bp  -  (    )
	  @param  recursive     
	  @return   	*/
	CaplInstance *CreateBPInstCopy(CaplInstance *base_bp_inst,const TCHAR *id=0, const TCHAR *name=0,const TCHAR *descr=0,CaplInstance *bp=0,CaplInstance *item=0, CaplInstance *context=0,CaplInstance **rel=0,CaplInstance *parent_bp_inst=0,bool recursive=true);
	/**       - 
	  @param  bp_inst  - 
	  @return true     false    */
	bool LoadBPInstInfo(CaplInstance *bp_inst,bool bLoadSubBpInfo=true);
	/**        - 
	  @param  ext  -
	  @return true     false    */
	bool LoadBPInstInfo(aplExtent &ext,bool bLoadSubBpInfo=true);
	/**      
	    @return true     false    */
	bool LoadBPResourcesInfo(CaplInstance *res);
	/**       
	    @return true     false    */
	bool LoadBPResourcesInfo(aplExtent &ext);

	/**    - c   
		@param item  ,     
		@param bp_inst  -,    
		@param context ,     
		@param id    
		@return    NULL    */
	CaplInstance *CreateInstanceAssociation(CaplInstance *item,CaplInstance *bp_inst,CaplInstance *context=0, const TCHAR *id=0, bool bTestUnique = true);
	/**      - 
		@param bp_inst  - 
		@param bp_inst_ref      -    
		@return true     false    */
	bool ShowBPInstProperties(CaplInstance *bp_inst,CaplInstance *bp_inst_ref=0);
	/**   -    -
		@param sub_bp_inst  - ()
		@param base_bp_inst  - ()
		@return true     false    */
	bool AddBPInstToBPInst(CaplInstance *sub_bp_inst, CaplInstance *base_bp_inst);
	/**     -,     - ()
		@param bp_inst  -
		@param ext       - ()
		@param bFromBase       
		@param bReferenceOnly    (bp_inst_reference)
		@return true     false    */
	bool WhereUsedBPInst(CaplInstance *bp_inst, aplExtent &ext, bool bFromBase = true, bool bReferenceOnly = false);
	bool WhereUsedBPInst(aplExtent &bp_insts, aplExtent &ext, bool bFromBase = true, bool bReferenceOnly = false);
	bool WhereUsedBPInst(aplExtent &bp_insts, aplExtent &ext, aplExtent &refs, bool bFromBase = true);
	/**     -
		@param sub_bp 
		@param base_bp   
		@return true     false    */
	bool DeleteBPInstRelation(CaplInstance *sub_bp_inst,CaplInstance *base_bp_inst);
	/**     - 
		@param bp_inst  -
		@param delete_sub_bp_inst    
		@param deleted_parent     (,   ) 
		@return true     false    */
	bool DeleteBPInst(CaplInstance *bp_inst, bool delete_sub_bp_inst=true, CaplInstance *deleted_parent=0);
	/**       -
		@param item ,     
		@param bp_inst  -,  c  
		@return    NULL     */
	CaplInstance *FindInstanceAssociation(CaplInstance *item,CaplInstance *bp_inst);
	/**    -  item   -
		@param item ,     
		@param out_ext        - ()
		@param out_rel        ()
		@param context  ,    
		@return true     false    */
	bool FindAssociatedBPInst(CaplInstance *item, aplExtent &out_ext, aplExtent &out_rel,CaplInstance *context=0,bool from_base=true) ;
	/**    -   ext   -
		@param ext  ,     
		@param out_ext        - ()
		@param out_rel        ()
		@param context  ,    
		@return true     false    */
	bool FindAssociatedBPInst(aplExtent &ext, aplExtent &out_ext, aplExtent &out_rel,CaplInstance *context=0) ;
	/**  -   -,  item   
		@param item ,     
		@param ext_bp       - ()
		@param ext_bp_inst        - ()	*/
	bool ItemWhereUsedAsResource(CaplInstance *item,aplExtent &ext_bp,aplExtent &ext_bp_inst);
	/**	 Instance      .
		@param lpctstrName    
		@return Instance    NULL    */
	CaplInstance* GetBpTypeByName(LPCTSTR lpctstrName);

	/**	   .
		@param BpFrom -   
		@param BpTo -   
		@param bTestUnique -    .
		@param id -   (  )
		@param name -   (  )
		@param descr -   (  )
		@return  */
	CaplInstance* CreateBPRelation(CaplInstance* BpFrom, CaplInstance* BpTo, bool bTestUnique = true, TCHAR* id=0, TCHAR* name=0, TCHAR* descr=0);

	/**	      .
		@param Bp -   
		@param ext -   
		@param rels -  (  )*/
	bool FindBpFrom(CaplInstance* Bp, aplExtent &ext, aplExtent* rel = NULL);

	/**	      .
		@param Bp -   
		@param ext -   
		@param rels -  (  )*/
	bool FindBpTo(CaplInstance* Bp, aplExtent &ext, aplExtent* rel = NULL);
	
	//	      

	/**	 ,   ciRootBP   
		@param ciRootBP		-  -
		@param ciOffsetChar	- ,     
		@param csDepotSep	-  
		@param csGrpSep		-  
		@param bReadGrps	-   
		@param csOutRasc	-   */
	bool GetRascString(CaplInstance* ciRootBP,CaplInstance* ciOffsetChar,
			CString& csDepotSep,CString& csGrpSep,bool bReadGrps,CString& csOutRasc);

	/**  ,   ciRootBP.   -, 
		-,  ,   . 
		  ! 
		(   !).
		@param ciRootBPRel	-     -
		@param bDelRoot		-   -*/
	bool DeleteRasc(CaplInstance* ciRootBPRel,bool bDelRoot);

	/**     -       
		
		@param csInRasc		-   
		@param csDepotSep	-  
		@param csGrpSep		-  */
	bool ValidateRasc(CString& csInRasc,CString& csDepotSep,CString& csGrpSep);

	/**     
		@param ciInPdf		- ,      
		@param ciBPRascType	-   -
		@param ciBPDepotType-  - - 
		@param ciShopChar	-  -    
		@param ciOffsetChar -  -  
		@param csInRasc		-   
		@param csDepotSep	-  
		@param csGrpSep		-  
		@param aeOutRasc	-     */
	bool CreateRasc(CaplInstance* ciInPdf,
			CaplInstance* ciBPRascType,CaplInstance* ciBPDepotType,
			CaplInstance* ciShopChar,CaplInstance* ciOffsetChar,
			CString& csInRasc,CString& csDepotSep,CString& csGrpSep,
			aplExtent& aeOutRasc);



	//	     

	/**      (   !)
		@param ciInst		- ,    
		@param ciChar		- ,    */
	CaplInstance* GetInstCharVal(CaplInstance* ciInst,CaplInstance* ciChar);

	/**	          .
		 csapOutDepots  csapOutGrps  NULL -     .
		     .
		@param csInRasc		-   
		@param csDepotSep	-  
		@param csGrpSep		-  
		@param csapOutDepots-    
		@param csapOutGrps	-     */
	void ParseRasc(CString& csInRasc,CString& csDepotSep,CString& csGrpSep,
			CStringArray* csapOutDepots,CStringArray* csapOutGrps);

	/**	 ,   .  -, 
		-,  ,   .
		  ! 
		(   !).
		@param ciRootBPRel	-     -
		@param aeOutInsts	-    
		@param bIncludeRoot	-         */
	void GetRascInsts(CaplInstance* ciRootBPRel,aplExtent& aeOutInsts,bool bIncludeRoot);

	/**   - 
		@param ciInItem			- ,    -
		@param csBPId			-  -
		@param ciRootBPType		-  -
		@param ciOutRootBP		-  -  
		@param ciOutRootBPRev	-   -  
		@param aeOutRasc		-     */
	void CreateRootRascBP(CaplInstance* ciInItem,
			CString& csBPId,CaplInstance* ciRootBPType,CaplInstance*& ciOutRootBP,
			CaplInstance*& ciOutRootBPRev,aplExtent& aeOutRasc);
	
	/**	  .  -, - -   ,
		- -   ( )
		@param ciInParentBP		-  -  
		@param csBPIdPrefix		-   -
		@param iNum				-    
		@param csDepot			- 
		@param csGrp			-  
		@param ciDepotBPType	-  - - 
		@param ciShopChar		-  -   
		@param ciOffsetChar		-  -  
		@param ciOutDepotBP		-  -  
		@param aeOutRasc		-     */
	void CreateRascItem(CaplInstance* ciInParentBP,CString& csBPIdPrefix,int iNum,
			CString& csDepot,CString& csGrp,CaplInstance* ciDepotBPType,
			CaplInstance* ciShopChar,CaplInstance* ciOffsetChar,
			CaplInstance*& ciOutDepotBP,aplExtent& aeOutRasc);

	/**  -  .
		@param ciInParentBP		-  -  
		@param ciBPType			-  -
		@param ciOutBP			-  -  
		@param ciOutBPRev		-   -  */
	void CreateRascBP(CaplInstance* ciInParentBP,CaplInstance* ciBPType,
			CaplInstance*& ciOutBP,CaplInstance*& ciOutBPRev);

	/**    
		@param ciItem			- ,     
		@param ciChar			- ,    
		@param ciVal			-  -  
		@param ciOutCV			-   
		@param ciOutCVRev		-    */
	void CreateRascRefCV(CaplInstance* ciItem,CaplInstance* ciChar,CaplInstance* ciVal,
			CaplInstance*& ciOutCV,CaplInstance*& ciOutCVRev);

	/**   measured 
		@param ciItem			- ,     
		@param ciChar			- ,    
		@param dVal				-  -  
		@param ciOutCV			-   
		@param ciOutCVRev		-    */
	void CreateRascMeasuredCV(CaplInstance* ciItem,CaplInstance* ciChar,double dVal,
			CaplInstance*& ciOutCV,CaplInstance*& ciOutCVRev);
	
	/**     ""   - 
		@param iBP				-   -*/
	void RebuildCharactRasc(CaplInstance *iBP);


	/**   -        NULL      */
	CaplInstance *FindBPInstById(const TCHAR *id, bool bAutoLoadInfo = true);

	//@}

};

// *************************************************************************
// *************************************************************************
// *************************************************************************
/**   */
class CLASS_DECL_APL_STEP_MGR CaplPrdInstManager: public CaplStepManager
{
	// 

public:
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();
	
	// 
	CaplEntity *e_prd_inst;
	CaplAttr *a_prd_inst_id,*a_prd_inst_descr,*a_prd_inst_pdf,*a_prd_inst_sn;
	CaplAttr *a_prd_inst_rfid;
	CaplAttr *a_prd_inst_lot;
	CaplAttr *a_prd_inst_guid;
	CaplAttr *a_prd_inst_seria;
	CaplAttr *a_prd_inst_ils_product_instance;

	CaplEntity *e_prd_inst_rel,*e_apl_component;
	CaplAttr *a_prd_inst_rel_id, *a_prd_inst_rel_name, *a_prd_inst_rel_descr,*a_prd_inst_rel_pdr;
	CaplAttr *a_prd_inst_rel_relating, *a_prd_inst_rel_related;
	CaplAttr *a_prd_inst_rel_date_installed, *a_prd_inst_rel_date_removed;
	CaplAttr *a_prd_inst_rel_frames_of_reference;
	CaplAttr *a_prd_inst_rel_position;
	CaplAttr *a_prd_inst_rel_place;
	CaplAttr *a_prd_inst_rel_person;
	CaplAttr *a_prd_inst_rel_prototipe;
	CaplAttr *a_prd_inst_rel_guid;

	CaplAttr *a_prd_inst_datetime;
	CaplAttr *a_prd_inst_state;
	CaplAttr *a_prd_inst_baseitem;
	CaplAttr *a_prd_inst_additional_data;
	CaplAttr *a_prd_inst_code;

	CaplAttr *a_prd_inst_vniis_shipment_date;
	CaplAttr *a_prd_inst_vniis_customer;

//	CaplAttr *a_prd_inst_place;
	// 
	CaplEntity *e_lot;
	CaplAttr *a_lot_id,*a_lot_descr,*a_lot_pdf,*a_lot_size, *a_lot_parent;

	// 
	CaplEntity *e_pi_subst;
	CaplAttr *a_pi_subst_predecessor;
	CaplAttr *a_pi_subst_successor;
	CaplAttr *a_pi_subst_reason;
	CaplAttr *a_pi_subst_bp;
	CaplAttr *a_pi_subst_description;
	CaplAttr *a_pi_subst_job;//  - ,    
	CaplAttr *a_pi_subst_date;//  - ,  --//--
	CaplAttr *a_pi_subst_guid;
	

	CaplEntity *e_mwu;
	CaplAttr *a_mwu_val,*a_mwu_unit;

	bool m_bUseIlsProducrInstance; //    ILS

	// 
public:
	/**     */
	CaplInstance *CreatePrdInst(CaplInstance *pdf=0,CaplInstance *lot=0);

	/**      */
	CaplInstance *CopyPrdInst(CaplInstance *base_inst=0);

	/**     */
	bool ShowPrdInstProperties(CaplInstance *pi,CaplInstance *pi_rel=0);
	
	/**          */
	bool LoadPrdInstInfo(CaplInstance *inst);

	/**          */
	bool LoadPrdInstInfo(aplExtent &ext);
	
	/**      */
	bool DeletePrdInst(CaplInstance *inst);
	
	/**   out_ext    pdf */
	bool FindAllPdfInstances(CaplInstance *pdf, aplExtent &out_ext);
	bool FindAllPdfInstances(aplExtent &pdf, aplExtent &out_ext);

	/**         
		@param pdf -  
		@param lpszSN -  
		@return    Instance  NULL   */
	CaplInstance* FindPrdInstByPDFSN(CaplInstance *pdf, LPCTSTR lpszSN);

	/**      */
	CaplInstance *InsertInPI(CaplInstance *parent_prdinst, CaplInstance *sub_prdinst, CaplInstance *pdr=0);

	/**    
	@param old_rel -     
	@param new_pi  -   
	@return   -   0    */
	CaplInstance *ChangePIinPI(CaplInstance *old_rel, CaplInstance *new_pi = 0);
	
	/**      */
	bool LoadInsertedInstances(CaplInstance *prdinst, aplExtent &out_rel, aplExtent &out_ext);
	bool LoadInsertedInstances(aplExtent &prdinsts, aplExtent &out_rel, aplExtent &out_ext);

	/**       */
	bool WhereUsedPIinPI(CaplInstance *prdinst, aplExtent &out_rel, aplExtent &out_ext);
	
	//   

	/**     */
	CaplInstance *CreateLot(CaplInstance *pdf=0, CaplInstance *parent_lot=0);

	/**       */
	bool ShowLotProperties(CaplInstance *lot);

	/**          */
	bool LoadLotInfo(CaplInstance *lot);

	/**           */
	bool LoadLotInfo(aplExtent &ext);

	/**      */
	bool DeleteLot(CaplInstance *lot);
	
	/**   out_ext     PDF */
	bool FindAllPdfLoot(CaplInstance *pdf, aplExtent &out_ext);

	/**   out_ext      lot */
	bool FindAllLotProductInstance(CaplInstance *lot, aplExtent &out_ext, bool bFromBalse = true);
	bool FindAllLotProductInstance(aplExtent &lots, aplExtent &out_ext, bool bFromBalse = true);
	
	/**        */
	bool LoadIncomingLots(CaplInstance *lot, aplExtent &out_ext);
	
};
// *************************************************************************
// *************************************************************************
// *************************************************************************

enum TypeAdj {adj_appr=0,adj_char=1,adj_doc=2,adj_res=3,adj_blob=4,adj_class=5};

enum TypeFindObject{
	FindObject_NDef=-1,
	FindObject_Product=0,
	FindObject_ProductVer=1,
	FindObject_Document=2,
	FindObject_Lot=3,
	FindObject_ProductInst=4,
	FindObject_BP=5,
	FindObject_BPInst=6,
	FindObject_Category=7,
	FindObject_Folder=8,
	FindObject_Project=9,
	FindObject_Person=10,
	FindObject_Organization=11,
	FindObject_Find=12,
	FindObject_All=13,
	FindObject_Change=14,
	FindObject_CombinedTable=15,
	FindObject_ClassifSystem=16,
	FindObject_ClassifLevel=17,
	FindObject_Process=18,
	FindObject_Task=19,
	FindObject_Requirement=20,
	FindObject_Refusal=21,
	FindObject_MAX=22 //     -       ,    !!!
	//         !!!
};

enum TypeFOAttr{
	TFO_Id		=	0,// -   
	TFO_Name	=	1,// -   (   )
	TFO_Descr	=	2,// -  
	TFO_Type	=	3,// -  () 
	TFO_Code	=	4,// -      
	TFO_Source	=	5,// - 
	TFO_Ver		=	6,// -   
	TFO_CodeVer1=	7,// -    1,  -  
	TFO_CodeVer2=	8,// -    2
	TFO_CodeIzd=	9,// -   
	TFO_VerDescr=	10,// -   ,  -  
	TFO_Standart=	11,// -   -   
	TFO_Part	=	12,//  
	TFO_Label	=	13,//  - 
	TFO_InAggr  =   14,//  -  
	TFO_VerList	=	15,//  - 
	TFO_VerLists=	16,//  - 
	TFO_VerFormat=	17,//  - ,  - 
	TFO_VerLitera=	18,//  - 
	TFO_DocCode1=	19,//  ,  - 
	TFO_DocCode2=	20,//  - ,  - 
 	TFO_RelContext=	21,// , 
	TFO_ProjCustomer	=22,	// - ,  - 
	TFO_ProjKurator		=23,		// - ,  - ,  - 
	TFO_ProjExecutors	=24,	// - ,  - 
	TFO_ProjCoexecutors	=25,	// - 

	TFO_Date1	=	26,// -    ;   -   //  -  
	TFO_Date2	=	27,// -    ,  -  ,  -    //  -  
	TFO_Date3	=	28,// -    ,  -  . . //  -  
	TFO_Date4	=	29,// -    ,  -  . .
	TFO_DocUrgency = 30, //  - 
	TFO_StrExt		= 31, //  -  

	TFO_RefDocType		= 32, //  -  
	TFO_RefDocNum		= 33, //  -  
	TFO_RefState		= 34, //  - 

	TFO_RefOrg			= 35, //  - ,   
	TFO_RefSector		= 36, //  - ,   
	TFO_RefCulprit		= 37, //  - 
	TFO_RefStage		= 38, //  - 

	TFO_RefMainPDF		= 39, //  -  
	TFO_RefMainItem		= 40, //  -   
	TFO_RefSystem		= 41, // !!! !!!  - 
	TFO_RefFailedItem	= 42, //  -  ()
	TFO_RefFailedPart	= 43, //  -  
	TFO_RefConditions	= 44, //  -  
	TFO_RefDof			= 45, //  - 
	TFO_RefFaultReason	= 46, //  - 
	TFO_RefMethod		= 47, //  -  
	TFO_RefConsequence	= 48, //  - 
	TFO_RefManif		= 49, //  - 
	TFO_RefManifDescr	= 50, //  -  
	
	TFO_ProcTaskId = 51,	//  -  
	TFO_ProcTaskName = 52,	//  -  
	TFO_ProcTaskPerformer = 53,	//  -  
	TFO_ProcTaskExpired = 54,	//  -  
	TFO_ProcTaskExpiredNDays = 55,	//  -       
	TFO_ProcState = 56,	//  - 

	TFO_ProcRefusalCulprit = 57,	//  -  .  ,    
	TFO_ProcTemplate = 58,	//  - 
	TFO_ProcActivity = 59,	//  -  ( )
	TFO_ProcOwner = 60,	//  - 
	TFO_DocMaillist = 61, //  -  
	TFO_State = 62 //   , , -      "".

	
// 	TFO_RelPos	=	91,// -  - 
// 	TFO_RelPosId=	92,// -  -  
// 	TFO_RelName	=	93,// -  - 
// 	TFO_RelDescr=	94// -  - 
};



////////////////////////////////////////////////////////
//   :
// 
struct ElValChar{
	ElValChar(){Init();};
	ElValChar(ElValChar* old){
		Init();
		if(old!=0){
			*this = old;
		}
	}
	~ElValChar(){if(dtt!=0){delete dtt;}};
	void Init(){is_exist=true;apl_char=0;b_val=false;b_max=false;b_min=false;dtt=0;dtt_max=0;type=0;m_cur_ref_val=0;};
	void operator = (ElValChar* old){
		if(old==0){return;}
		is_exist=old->is_exist;
		apl_char=old->apl_char;
		b_val=old->b_val;
		log_relation=old->log_relation;
		val=old->val;
		b_max=old->b_max;
		log_relation_max=old->log_relation_max;
		val_max=old->val_max;
		b_min=old->b_min;
		log_relation_min=old->log_relation_min;
		val_min=old->val_min;
		if(old->dtt!=0){dtt=new COleDateTime(*old->dtt);}else{dtt=0;}
		type=old->type;
		m_cur_ref_val=old->m_cur_ref_val;
	}
	bool Compare(ElValChar* par){
		if(par==0)return false;
		if(is_exist!=par->is_exist)return false;
		if(apl_char!=par->apl_char)return false;
		if(b_val!=par->b_val)return false;
		if(log_relation!=par->log_relation)return false;
		if(val!=par->val)return false;
		if(b_max!=par->b_max)return false;
		if(log_relation_max!=par->log_relation_max)return false;
		if(val_max!=par->val_max)return false;
		if(b_min!=par->b_min)return false;
		if(log_relation_min!=par->log_relation_min)return false;
		if(val_min!=par->val_min)return false;
		if(dtt!=par->dtt)return false;
		if(type!=par->type)return false;
		if(m_cur_ref_val!=par->m_cur_ref_val)return false;
		return true;
	}
	bool is_exist;
	CaplInstance* apl_char;
	bool b_val;
	CaplQLQuery::aplQLLogRelation log_relation;
	CString val;//
	bool b_max;
	CaplQLQuery::aplQLLogRelation log_relation_max;
	CString val_max;//
	bool b_min;
	CaplQLQuery::aplQLLogRelation log_relation_min;
	CString val_min;//
	COleDateTime *dtt;
	COleDateTime *dtt_max;
	CaplInstance* type;
	CaplInstance* m_cur_ref_val;
};
//  
struct ElValBLOB{
	ElValBLOB(){is_equal=false;word=_T("");}
	ElValBLOB(ElValBLOB *old){is_equal=old->is_equal;word=old->word;}
	bool Compare(ElValBLOB* par){
		if(is_equal!=par->is_equal)return false;
		if(word!=par->word)return false;
		return true;
	}
	bool is_equal;
	CString word;
};
// 
struct ElValDoc{
	ElValDoc(){Init();}
	ElValDoc(ElValDoc *old){
		if(old==0){Init();return;}
		is_exist=old->is_exist;
		name=old->name;
		is_eq_name=old->is_eq_name;
		id=old->id;
		is_eq_id=old->is_eq_id;
		type=old->type;
	}
	void Init(){is_exist=true;type=0;}
	bool Compare(ElValDoc *par){
		if(par==0)return false;
		if(is_exist!=par->is_exist)return false;
		if(name!=par->name)return false;
		if(is_eq_name!=par->is_eq_name)return false;
		if(id!=par->id)return false;
		if(is_eq_id!=par->is_eq_id)return false;
		if(type!=par->type)return false;
		return true;
	}
	bool is_exist;
	CString name;
	bool is_eq_name;
	CString id;
	bool is_eq_id;
	CaplInstance* type;
};
// 
struct ElValClass{
	ElValClass(){Init();}
	ElValClass(ElValClass *old){
		if(old==0){Init();return;}
		is_exist=old->is_exist;
		classif=old->classif;
		//is_eq=old->is_eq;
	}
	void Init(){is_exist=true;classif=0;}
	bool Compare(ElValClass *par){
		if(par==0)return false;
		if(is_exist!=par->is_exist)return false;
		//if(is_eq!=par->is_eq)return false;
		if(classif!=par->classif)return false;
		return true;
	}
	bool is_exist;
	CaplInstance* classif;
	//bool is_eq;
};
// 
struct ElValRes{
	enum TypeResObj{TRONoType=0,TROProduct=1,TROPerson=2,TROOrg=3};
	ElValRes(){Init();}
	ElValRes(ElValRes *old){
		if(old==0){Init();return;}
		is_exist=old->is_exist;
		name_res=old->name_res;
		name_obj=old->name_obj;
		is_eq_name_res=old->is_eq_name_res;
		is_eq_name_obj=old->is_eq_name_obj;
		id_res=old->id_res;
		id_obj=old->id_obj;
		is_eq_id_res=old->is_eq_id_res;
		is_eq_id_obj=old->is_eq_id_obj;
		type_res=old->type_res;
		type_obj=old->type_obj;
	}
	void Init(){is_exist=true;type_res=0;type_obj=TRONoType;}
	bool Compare(ElValRes *par){
		if(par==0)return false;
		if(is_exist!=par->is_exist)return false;
		if(name_res!=par->name_res)return false;
		if(name_obj!=par->name_obj)return false;
		if(is_eq_name_res!=par->is_eq_name_res)return false;
		if(is_eq_name_obj!=par->is_eq_name_obj)return false;
		if(id_res!=par->id_res)return false;
		if(id_obj!=par->id_obj)return false;
		if(is_eq_id_res!=par->is_eq_id_res)return false;
		if(is_eq_id_obj!=par->is_eq_id_obj)return false;
		if(type_res!=par->type_res)return false;
		if(type_obj!=par->type_obj)return false;
		return true;
	}
	bool is_exist;
	CString name_res;
	CString name_obj;
	bool is_eq_name_res;
	bool is_eq_name_obj;
	CString id_res;
	CString id_obj;
	bool is_eq_id_res;
	bool is_eq_id_obj;
	CaplInstance* type_res;
	TypeResObj type_obj;
};
// 
struct ElValApproval{
	ElValApproval(){Init();}

	ElValApproval(ElValApproval* old)
	{
		if(old==0){Init();return;}
		is_exist=old->is_exist;
		is_dig_sign=old->is_dig_sign;
		status=old->status;
		person=old->person;
		pers_org_role=old->pers_org_role;
		descr=old->descr;
		descr_relation=old->descr_relation;
		pers_org_role_eq=old->pers_org_role_eq;
		is_single_date=old->is_single_date;
		if(old->date_time_beg){date_time_beg=new COleDateTime(*old->date_time_beg);}else{date_time_beg=0;}
		if(old->date_time_end){date_time_end=new COleDateTime(*old->date_time_end);}else{date_time_end=0;}
		if(old->revoc_date_time_beg){revoc_date_time_beg=new COleDateTime(*old->revoc_date_time_beg);}else{revoc_date_time_beg=0;}
		if(old->revoc_date_time_end){revoc_date_time_end=new COleDateTime(*old->revoc_date_time_end);}else{revoc_date_time_end=0;}
	}
	~ElValApproval()
	{
		if(date_time_beg!=0)delete date_time_beg;
		if(date_time_end!=0)delete date_time_end;
		if(revoc_date_time_beg!=0)delete revoc_date_time_beg;
		if(revoc_date_time_end!=0)delete revoc_date_time_end;
	}
	void Init()
	{
		is_exist=true;status=0;person=0;pers_org_role=_T("");descr=_T("");descr_relation=CaplQLQuery::aplLIKE;is_dig_sign=-1;
		date_time_beg=0;date_time_end=0;
		is_single_date=true;
		revoc_date_time_beg=0;revoc_date_time_end=0;
	}
	bool Compare(ElValApproval* par)
	{
		if(par==0)return false;
		if(is_exist!=par->is_exist)return false;
		if(is_dig_sign!=par->is_dig_sign)return false;
		if(status!=par->status)return false;
		if(person!=par->person)return false;
		if(pers_org_role!=par->pers_org_role)return false;
		if(descr!=par->descr)return false;
		if(descr_relation!=par->descr_relation)return false;
		if(pers_org_role_eq!=par->pers_org_role_eq)return false;
		if(is_single_date!=par->is_single_date)return false;
		if(date_time_beg!=par->date_time_beg)return false;
		if(date_time_end!=par->date_time_end)return false;
		if(revoc_date_time_beg!=par->revoc_date_time_beg)return false;
		if(revoc_date_time_end!=par->revoc_date_time_end)return false;
		return true;
	}
	bool IsEmpty()
	{
		return (status==0 && person==0 && pers_org_role==_T("") && descr==_T("") && 
		date_time_beg==0 && date_time_end==0 &&
		revoc_date_time_beg==0 && revoc_date_time_end==0 && is_dig_sign==-1);
	}
	bool is_exist;
	int is_dig_sign;
	CaplInstance* status;
	CaplInstance* person;
	CString pers_org_role;
	CString descr;
	//    descr_relation
	//	aplLIKE=9,// ""
	//	aplNOTLIKE=10,// " "
	// 	aplEQUAL=5,//""
	// 	aplNOTEQUAL=6,//" "
	CaplQLQuery::aplQLLogRelation descr_relation;
	bool pers_org_role_eq;
	bool is_single_date;
	COleDateTime* date_time_beg;
	COleDateTime* date_time_end;
	COleDateTime* revoc_date_time_beg;
	COleDateTime* revoc_date_time_end;
};

class CFindDlg;

/**     */
class CLASS_DECL_APL_STEP_MGR CaplQueryManager: public CaplStepManager
{
	// 
public:
	CaplQueryManager();
	~CaplQueryManager();
	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();
	
	// 
public:

	/**         */
	bool LoadCombinedTableInfo(CaplInstance *ct,bool load_content=false,bool hide_error=false);
	
	/**         */
	bool LoadCombinedTableInfo(aplExtent  &ext,bool load_content=false,bool hide_error=false);
	
	/**          */
	bool ReadCombinedTableColumnsInfo(CaplInstance *ct,CaplDataBuf &dbuf,bool hide_error=false);
	/**          */
	bool SaveCombinedTableColumnsInfo(CaplInstance *ct,CaplDataBuf &dbuf,bool hide_error=false);
	/**              */
	CaplInstance* ShowCombinedTable(CaplInstance *basic,CString name=_T(""));

	/**        */
	bool LoadQueryInfo(CaplInstance *query,bool load_content=false,bool hide_error=false);
	
	/**        */
	bool LoadQueryInfo(aplExtent  &ext,bool load_content=false,bool hide_error=false);
	
	/**            
	  
		@param query -  .    0 -  
		@param dbuf - !!!  - ,      
		@param name -  ,      " "
		@param only_lng -  true,       
		@param can_make_table -      "   "
		@param can_save -  true,      
		@param mode_slave -  true,    ( ,   ..);  false -   (   ,   SelectDialog)
		@param mode -   .  :
			"Query" (    "") -   
			"Query_niiao" -    -  pdf-product_instance-bisness process
			    
		@param type_find_object -   ,       ""
		@param text_query -     .      
			 ;      ,     
			  only_lng      .
		@return         0    */
	CaplInstance* PrepareQuery(CaplInstance *query/*,CaplDataBuf *dbuf=0*/,CString name=_T(""),
				bool only_lng=false,bool can_make_table=true,bool can_save=true,bool mode_slave=false,
				CString mode_quiery=_T(""),long type_find_object=0,CString text_query=_T(""),bool *is_new_window=0);

	CaplInstance* PrepareQueryOld(CaplInstance *query/*,CaplDataBuf *dbuf=0*/,CString name=_T(""),
				bool only_lng=false,bool can_make_table=true,bool can_save=true,bool mode_slave=false,
				CString mode_quiery=_T(""),long type_find_object=0,CString text_query=_T(""));
	CaplInstance* PrepareQueryNew(CaplInstance *query/*,CaplDataBuf *dbuf=0*/,CString name=_T(""),
				bool only_lng=false,bool can_make_table=true,bool can_save=true,bool mode_slave=false,
				CString mode_quiery=_T(""),long type_find_object=0,CString text_query=_T(""),bool *is_new_window=0);

	CaplInstance* CopyQuery(CaplInstance *query,bool force_temporary);

	void SetStyleDlg(DWORD m_show_old_query_dlg);

	bool m_is_old_dlg;
public:
	/**    
		@param query -  .    0 -  
		@param dbuf - !!!  - ,      
		@param mode -    .  :
			"product"
			"document"
			"lot"
			"product_instance"
			"bp"
		@param predef_id -  id      
			.     predef_name ,    , 
			  .
		@param predef_name -  name      
			.     predef_id ,    , 
			  .
		@return         0    */
	CaplInstance* PrepareFind(CaplInstance *query/*,CaplDataBuf *dbuf=0*/,CString mode=_T(""),
								CString predef_id=_T(""),CString predef_name=_T(""));
		
	/**    
		@param query -  . 
		@param mode -    .  :
			"product"
			"document"
			"lot"
			"product_instance"
			"bp"
		@param is_id -      id
		@param id -     id
		@param is_name -       (  )
		@param name -      (  )
		@param is_equal -  true,     ,  
						 false -   ,     
		@return true     false    */
	bool GetFindParams(CaplInstance *query,CString &mode,BOOL &is_id,CString &id,
								BOOL &is_name,CString &name,BOOL &is_equal);
	bool GetFindParams(CaplInstance *query,CFindDlg *dlg=0);
	
	/**    
		@param query -  . 
		@param mode -    .  :
			"product"
			"document"
			"lot"
			"product_instance"
			"bp"
		@param is_id -      id
		@param id -     id
		@param is_name -       (  )
		@param name -      (  )
		@param is_equal -  true,     ,  
						 false -   ,     
		@return true     false    */
	bool SetFindParams(CaplInstance *query,CString &mode,BOOL is_id,CString &id,
								BOOL is_name,CString &name,BOOL is_equal);
	bool SetFindParams(CaplInstance *query,CFindDlg *dlg=0);
	
	/**  ,      MakeQueryLngWithDlg.
		@param item -  
		@param out_ext -     
		@return true     false    */
	bool ExecuteQuery(CaplInstance *query,aplExtent &out_ext);

	/**  ,      MakeQueryLngWithDlg.
		@param query -  
		@param out_ext -     
		@return true     false    */
	bool ExecuteQuery(CString query,aplExtent &out_ext);

	bool ExecuteFind(CaplInstance *query/*,CaplDataBuf &dbuf*/,aplExtent &out_ext);

	bool CheckRemoveLowLevelInstances(aplExtent &ckecked_ext);

	/**     
		@param item -  
		@param out_ext -     
		@param time -   
		@return true     false    */
	bool GetFindResult(CaplInstance *query,aplExtent &out_ext,COleDateTime &time,bool only_temporary=false);

	/**    ,    item.   is_hide_move_button 
		 false,   "  ".       
		@return true     "  "  false    ""*/
	//bool MakeTable(CaplInstance *query,bool is_hide_move_button,bool ignore_flag=false,aplExtent* ext_in=0);

	/**   name   item*/
	bool GetName(CaplInstance *query,CString &name,CString &description);

	/**     (    )*/
	bool TestNameQuery(CString name,CaplInstance *query,bool report=true);

	/**     (    )*/
	bool TestNameCombinedTable(CString name,CaplInstance *ct,bool report=true);

	/**   item*/
	bool DeleteQuery(CaplInstance *query);
	
	/**    */
	bool FindIntoContent(CaplInstance *pdf);

	/**      -       |  &    */
	bool MakeAttrConditionWithGroup(CString &str_par,CString &attr,CString &name4user,bool is_brackets,CString &attr_condition, const TCHAR* str_rel = _T("LIKE"));
	
	/**  */
	bool SaveQuery(CaplInstance *query);

	bool UpdateTypeQuery(CaplInstance *query);
	
public:
	// Attributes
	CaplEntity *e_apl_query;
	CaplAttr *a_apl_query_name;
	CaplAttr *a_apl_query_description;
	CaplAttr *a_apl_query_is_text_query;	
	CaplAttr *a_apl_query_text_query;	
	CaplAttr *a_apl_query_dialog_data;	
	CaplAttr *a_apl_query_content;	
	CaplAttr *a_apl_query_execution_date;	
	CaplAttr *a_apl_query_execution_size;	
	CaplAttr *a_apl_query_make_table;
	CaplAttr *a_apl_query_temp_data_index;
	CaplAttr *a_apl_query_mode;
	CaplAttr *a_apl_query_combined_table;
	CaplAttr *a_apl_query_type;
	CaplAttr *a_apl_query_dot_name;
	CaplAttr *a_apl_query_folder;

	CaplEntity *e_apl_ct;
	CaplAttr *a_apl_ct_name;
	CaplAttr *a_apl_ct_description;
	CaplAttr *a_apl_ct_columns_data;
	CaplAttr *a_apl_ct_temp_data_index;
	CaplAttr *a_apl_ct_query;

	CaplMap m_ListTopLevelEntities;
	
};	
// *************************************************************************
// *************************************************************************
// *************************************************************************
/**  (  )*/
class CLASS_DECL_APL_STEP_MGR CaplAutorizationManager: public CaplStepManager
{
	// 
public:

	CaplAutorizationManager();
	~CaplAutorizationManager();

	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	/**      ,   */
	bool LoadOrgStruct(aplExtent *ext=NULL);

	bool LoadDictionary(); //      LoadOrgStruct

	/**    Item*/
	// bReturnRevocated -  true    
	bool LoadItemApproval(CaplInstance* item, aplExtent &ext_approval,bool from_base=true, bool bReturnRevocated=false);
	bool LoadItemApproval(aplExtent &ext, aplExtent &ext_approval,bool from_base=true, bool bReturnRevocated=false);

	bool LoadApprovalInfo(aplExtent &ext_approval);


	/**    item (    );
	  @param  item   
	  @param  status  
	  @param  level 
	  @param  person_org   ,  
	  @param  app_owner    
	  @param  role  
	  @param  date_time   
	  @param  system   (,  item     )
	  @param  key      
	  @param  password    
	  @param  statusesToHide  ,      
	  @param  bNoCheckRepeatStatus  true,       */
	CaplInstance *CreateApproval(CaplInstance *item,CaplInstance *status=0,const TCHAR *level=0,CaplInstance *person_org=0,CaplInstance *app_owner=0,const TCHAR *role=0,const TCHAR *date_time=0,
		const TCHAR* sSignMethod= 0, const TCHAR* sKeyPath= 0, const TCHAR* sPassword= 0,LPCTSTR sign_owner=NULL, LPCTSTR cert_file=NULL, aplExtent *statusesToHide=NULL,
		bool bNoCheckRepeatStatus=false,bool CheckStatusForRole=true);
	int CreateApprovalMulti(aplExtent *items,CaplInstance *status=0,const TCHAR *level=0,CaplInstance *person_org=0,CaplInstance *app_owner=0,const TCHAR *role=0,const TCHAR *date_time=0,
		const TCHAR* sSignMethod= 0, const TCHAR* sKeyPath= 0, const TCHAR* sPassword= 0,LPCTSTR sign_owner=NULL, LPCTSTR cert_file=NULL, aplExtent *statusesToHide=NULL);
	CaplInstance* CreateWfApproval(CaplInstance* task, CaplInstance* item, CaplInstance *defStatus= NULL);
	bool PostUpdateApprovalItems(aplExtent& items);

	bool AddLabel4DocRevision(CaplInstance *doc_rev, LPCTSTR sLabel); // 
	bool SetNeedWork4DocRevision(CaplInstance *doc_rev, bool bSetNeedWork, bool bFromCreateApproval=false); // 
	
	/**       
	  @param  inst      (doc | doc_rev |PDF )
	  @param  system  
	  @param  key      
	  @param  password    
	  @param  sSign   ( )
	  @param  sHash  - ( )
	  @param  sOpenKey   ( )
	  @param  UserName   ( )
	  @param  CertFileName    ( )
	  @param  sInventory   
	  @param  sShapShot    
	  @param  person  ,  0,  .  -2 -    .  

	  @return true     false   */	
	bool SignObject(CaplInstance* inst, const TCHAR* system,  
		CString &sSign, CString &sHash, CString &sOpenKey,CString &UserName, CString &CertFileName,
		CString &sInventory, CString &sShapShot, CaplInstance **pPerson=0);

	/**      */
	int GetDSInfo(CaplInstance *ciDoc, char *&addInfo);	

	/**      
		@param ciEntry 
		@param sEntryName  
		@param ciDocType       */
	bool IsEntryUsedInEDS(CaplInstance *ciEntry, CaplInstance *ciDocType = 0);
	bool IsEntryUsedInEDS(CString sEntryName, CaplInstance *ciDocType = 0);

	/**    ,    IsEntryUsedInEDS*/ 
	bool LoadDTinfoOfApprovalItem(aplExtent &aeApproval);

	/**    ( )*/
	bool ShowCertificateProperties(CaplInstance *ciCert);

	/**        */
	int CheckApproval(CaplInstance* approval, bool bShowResult= true);

	/**      */
	bool IsApprovalActual(CaplInstance *ciApproval);

	/**   */
	bool ShowApproval(CaplInstance *appr);

	//**     ()     */
	CString  GetOperatorName(); 

	/**        nMaxNameLen      */
	bool GetPersonName(CaplInstance* po, CString &buf,bool is_short=true,bool reverse_user=false, int nMaxNameLen=-1);
	
	/**  ext  ,   
	 -    - bOwner= true
	 -    - bOwner= false */
	bool GetPersonOfficials(CaplInstance* person, aplExtent& officials, bool bOwner= false);

	///  ext  ,    .   bActualOnly==false,   ,   
	bool GetPersonOrganizations(CaplInstance* person, aplExtent& organizations, bool bActualOnly = true);

	/**	     
		return <b>true</b>       OK  <b>false</b>   */
	bool SelectOrganization(CaplInstance **inst, LPCTSTR lpszTitle = NULL, aplExtent *RootItems = NULL);
	
	/**      ()   */
	bool SelectPersonsOrganizations(long lMode, aplExtent &ext, 
		bool bShowUserWG= true, bool Traverse= true,
		CString sTitle= _T(""), CString sTreeTitle= _T(""), aplExtent* rootPO= NULL, 
		bool bExpand= false);
	
	/**      */
	CaplInstance* SelectPersonOrOrganization(long lMode, aplExtent &rootPO, 
		CString sTitle= _T(""), CString sTreeTitle= _T(""), bool bExpand= false);

	/**      */
	CaplInstance* SelectAplUserOrGroup(long lMode,  
		CString sTitle= _T(""), CString sTreeTitle= _T(""), bool bExpand= false);

	/**    */
	void ShowOfficialHistory(CaplInstance* official, int hist_type =0);

	/**    */
	void ShowPersonOfficials(CaplInstance* person);

	/**   */
	CaplInstance *CreateOfficial(const TCHAR *id,const TCHAR *descr=0);

	/**     id*/
	CaplInstance *FindOfficialById(const TCHAR *id,bool bLoadFromBase=false);

	/**    */
	void GetKVZShops(CStringArray &shops) const;

	/**    */
	void GetKVZDepartments(CStringArray &departments) const;

	/**     */ 
	bool FindPersonOrganizations(CaplInstance *person,aplExtent &ext_out, bool bFromBase = false);

	/**     */
	CaplInstance *CreateApprovalStatus(const TCHAR *name);
	
	/**     */
	CaplInstance *FindApprovalStatusBN(const TCHAR *name,bool bLoadFromBase=false, bool bCreateIfNotFound=false);

	/**    */
	CaplInstance *FindRoleBN(const TCHAR *name,bool bLoadFromBase, bool bCreateIfNotFound=false);

	/**         item*/
	CaplInstance *CaplAutorizationManager::FindRoleApproval(CaplInstance *item,const TCHAR *role,CaplInstance *status);

	/**  */
	bool DeleteApproval(CaplInstance *approval);

	/**     item*/
	bool DeleteAllApproval(CaplInstance *item);

	/**    c     item*/
	bool DeleteAllApprovalByStatus(CaplInstance *item,aplExtent &ext_status);

	/**    */	
	CaplInstance* FindOrganizationById(const TCHAR* id, bool bFromBase = false, bool bLoadAttrs = false);
	
	/**   */	
	bool FindPersonById(const TCHAR *id,aplExtent &ext_out,bool is_substring=false);
	
	/**   */
	CaplInstance *CreatePerson(const TCHAR *id,const TCHAR *last_name=0,const TCHAR *first_name=0,CaplAggr *mid_names=0, bool bTestUnique = true);
	CaplInstance *CreatePerson(const TCHAR *id,const TCHAR *last_name,const TCHAR *first_name, const TCHAR *mid_name, bool bTestUnique = true);

	/*    */
	bool GetAllSubOrganization(CaplInstance *inst, aplExtent &out, aplExtent *rel = 0);
	bool GetAllSubOrganization(aplExtent &inExt, aplExtent &out, bool bRecursive);
	
	/*    person  official*/
	bool GetAllSubPerson(CaplInstance *inst, aplExtent &out, aplExtent &pers_org);

	/*    person  official*/
	bool ShowPersonProperties(CaplInstance *inst);

	/*    */
	bool ShowOrganizationProperties(CaplInstance *inst);
	
	bool GetUserEnveroment(aplExtent &status, aplExtent &doc_types, aplExtent &contexts);
	
	//   ,        
	bool GetUserPatterns(CaplInstance *user,aplExtent &patterns);

	//    
	CaplInstance *CreateOrgRel(CaplInstance *relating_org,CaplInstance *related_org);

	//    . 
	CaplInstance* FindOrgRel(CaplInstance *relating_org, CaplInstance *related_org);

	//  
	bool WhereUsedOrg(CaplInstance *org, aplExtent &ext, aplExtent *rels = NULL, bool bFromBase = false);

	//       .
	CaplInstance* CreateOrganization(CaplInstance* org = NULL, bool bCanEdit = false);
	CaplInstance* CreateOrganization(LPCTSTR lpszId, LPCTSTR lpszName);

	//   
	CaplInstance* CreateOrganizationType(LPCTSTR lpName);

	//     
	CaplInstance* GetOrganizationTypeBN(LPCTSTR lpName);

	bool DeleteOrganization(CaplInstance* nInst);

	//   ,    (  apl_doc_revision)
	void CreateEntryApproval(CaplInstance *ciItem, CaplInstance *ciAppr);
	
	//    ,   
	// E bReturnOrg==true -  ,  person_organization 
	CaplInstance*	GetActualPersOrg(CaplInstance *pers, bool bReturnOrg=false); // bReturnOrg==false  PO,   ORG
	
	//   ,    
	// E bReturnOrg==true -  ,  person_organization
	bool GetActualPersOrgs(CaplInstance *pers, aplExtent &ext_org, bool bReturnOrg);
	
	//   ,        
	// ext_org  
	// bWithOfficials  true,   ,      
	bool GetAllActualPersOrgs(CaplInstance *pers, aplExtent &ext_org, bool bWithOfficials=true);
	
	bool GetUserData(CaplInstance* item, CaplInstance** user, CaplInstance** pers, CaplInstance **po);
	bool GetPersonByUser(CaplInstance* user, CaplInstance** pers, CaplInstance **po);
	bool GetUserByPerson(CaplInstance* pers, CaplInstance** user, CaplInstance **po);
	bool GetUserByPO(CaplInstance* po, CaplInstance** user, CaplInstance **pers);


	///     person.  true,    .
	///   person==0 ,  
	///           '|'.  true,        
	bool CheckPersonRole(CaplInstance *person, LPCTSTR role);

	///   person       option.  true,    .
	///       true
	///   person==0 ,  
	///  bShowMsg==true -   " "
	///           '|'.  true,        
	bool CheckPersonRoleByOption(CaplInstance *person, LPCTSTR option, bool bShowMsg);


	///        
	///         " ",  ext_doc_types  ,  bAllDocTypes   true
	///    ext_doc_types    ,  bAllDocTypes   false
	///   ,  ext_doc_types     bAllDocTypes   false
	bool GetPersonDocumentTypes(CaplInstance *person, aplExtent &ext_doc_types, bool &bAllDocTypes);

	//      status   role  inst.  role   -  .
	//  ext_approvals   
	bool CheckItemStatus(CaplInstance *inst, CaplInstance *status, LPCTSTR role=0, aplExtent *ext_approvals=0);


	//     -  ,      item 
	// person -  ,  0,  
	// item -     
	// status_name -  
	//  true,  ,    
	bool CheckPersonInWgApproval(CaplInstance *person, CaplInstance *item, LPCTSTR status_name, LPCTSTR role_name );

	bool CreateSnapShot4DigSign(CaplInstance *inst, CString & sData, CString& sInventoy);
	//    
	// psOldData -   
	// psDiff -    ,      
	bool CreateSnapShotByInventory(CString &sInventoy, CString &sData, CString *psOldData=0, CString *psDiff=0);

	//      ( )
	bool LoadHolydaysInCash();

	//     . day     ( )
	bool IsDayHolyday(CString &day);
	
	//     .
	bool IsDayHolyday(COleDateTime day);

	//        (  ,       1 )
	bool GetHolydayCount(COleDateTime day_start,COleDateTime day_end, int &day_count);

	//       (     1 ,    )
	bool GetWorkdayCount(COleDateTime day_start,COleDateTime day_end, int &day_count);

	//    iWorkDayCount    first_date ( 1      ,   )
	bool AddWorkdayToDate(COleDateTime first_date, int iWorkDayCount, COleDateTime &new_date);
	bool AddWorkdayToDate(COleDateTime first_date, double dWorkDayCount, COleDateTime &new_date);
	
	//        
	bool ShowItemApprovals(CaplInstance* item);

	//     
	CaplInstance *CreateDigSignCert4Person(CaplInstance *person, CaplCryptographicManager::TCertInfo &certInfo, bool bSaveKeyInBase);

	//       
	bool CreateDigSignCert4CurrentPerson();

protected:
	
	CaplCryptographicManager m_Crypto;
	bool m_bHolydeysLoaded;

public:

	CaplMap m_holydays_map;

	bool m_bAllowCreateOrgInSelect; //       
	bool m_bAllowCreatePersonInSelect; //      

	ESignMode SeSignModeForCryptMgr(ESignMode mode, bool bResetPassword=false); // bResetPassword==true -   

	//CCryptographicProvider *GetCryptProv();
	bool ConfidentialCertExistInBase(CString sIssure);

// Attributes
	CaplEntity *e_official, *e_official_hist;
	CaplAttr *a_official_id, *a_official_descr, *a_official_roles,*a_official_owner, *a_official_owner_hist;
	CaplAttr *a_official_act_person, *a_official_act_person_hist, *a_official_possible_persons;
	CaplAttr *a_off_hist_person, *a_off_hist_date, *a_off_hist_descr, *a_off_hist_user;
	
	CaplEntity *e_apl_appr,*e_apl_appr_pers_org;
	CaplAttr *a_appr_status,*a_appr_level,*a_appr_item,*a_appr_role,*a_appr_active;
	CaplAttr *a_appr_state,*a_appr_pers_org;
	CaplAttr *a_appr_notes;
	CaplAttr *a_appr_attachment;
	CaplAttr *a_appr_revocation_date_time;
	CaplAttr *a_appr_dg_sign_hash,*a_appr_dg_sign_met,*a_appr_dg_sign,*a_appr_dg_sign_open_key;
	CaplAttr *a_appr_dg_sign_author,*a_appr_dg_sign_cert;
	CaplAttr *a_appr_dg_sign_inventory,*a_appr_dg_sign_snapshot;
	CaplAttr *a_appr_appr_date_time_s,*a_appr_appr_owner;
	CaplAttr *a_appr_po_entries, *a_appr_po_item_note;
	CaplAttr *a_appr_entries_used;
	CaplAttr *a_appr_format;				///< 
	CaplAttr *a_appr_total_sheets_count;	///< 
	CaplAttr *a_appr_total_sheets_count_a4;	 ///<     4
	
	CaplEntity *e_appr_rel;
	CaplAttr *a_appr_rel_name,*a_appr_rel_descr,*a_appr_rel_relating,*a_appr_rel_related;
	
	CaplEntity	*e_appr_status;
	CaplAttr	*a_appr_status_name;
	CaplAttr	*a_appr_status_icon;
	CaplAttr	*a_appr_status_set_state;
	CaplAttr	*a_appr_status_str4label;
	CaplAttr	*a_appr_status_set_needs_work; //   " "
	CaplAttr	*a_appr_status_unset_needs_work; //   " " (    15   )
	CaplAttr	*a_appr_status_need_description; //   

	CaplEntity*  e_appr_cont;
	CaplAttr*    a_appr_cont_abbreviation;
	CaplAttr*    a_appr_cont_description;
	CaplAttr*    a_appr_cont_approval;
	CaplAttr*	 a_appr_cont_person;
	CaplAttr*	 a_appr_cont_item;
	CaplAttr*	 a_appr_cont_status_code;
	CaplAttr*	 a_appr_cont_date;
		
	CaplEntity	*e_po_role;
	CaplAttr	*a_po_role_name;
	CaplAttr	*a_po_role_system;

	CaplAttr *a_po_role_contexts;
	CaplAttr *a_po_role_document_types;
	CaplAttr *a_po_role_status;
	CaplAttr *a_po_role_specified_contexts_set;
	CaplAttr *a_po_role_specified_document_types_set;
	CaplAttr *a_po_role_specified_status_set;
	CaplAttr *a_po_role_system_buf;
	CaplAttr *a_po_role_ro_buf;
	CaplAttr *a_pers_forum_last_visit_date;
	CaplAttr *a_po_role_interface_elements;
	CaplAttr* a_po_role_data_class;
	CaplAttr* a_po_role_auto_save_user_column_settings;

	CaplEntity *e_person;
	CaplAttr *a_pers_id;
	CaplAttr *a_pers_last_name;
	CaplAttr *a_pers_first_name;
	CaplAttr *a_pers_code;
	CaplAttr *a_pers_roles;
	CaplAttr *a_pers_middle_names;
	CaplAttr *a_pers_prefix_titles;
	CaplAttr *a_pers_suffix_titles;
	CaplAttr *a_pers_descr;
	CaplAttr *a_pers_phone;
	CaplAttr *a_pers_e_mail;
	CaplAttr *a_pers_actual_address;
	CaplAttr *a_pers_send_copy_message_to_email;
	CaplAttr *a_pers_mail_template; 
	CaplAttr *a_pers_options; 
	
	CaplEntity *e_pers_org;		/**<person_and_organization */
	CaplAttr *a_po_the_pers;	/**<person_and_organization -> the_person*/
	CaplAttr *a_po_the_org;		/**<person_and_organization -> the_organization*/
	CaplAttr *a_po_start_date;	/**<person_and_organization -> start_date*/
	CaplAttr *a_po_end_date;	/**<person_and_organization -> end_date*/
	CaplAttr *a_po_person_pos;	/**<person_and_organization -> person_position*/
	CaplAttr *a_po_code;		/**<person_and_organization -> code */

	CaplEntity *e_org;				/**<organization */ 
	CaplAttr *a_org_id;				/**<organization -> id */
	CaplAttr *a_org_name;			/**<organization -> name */
	CaplAttr *a_org_name_eng;		/**<organization -> name_eng */
	CaplAttr *a_org_descr;			/**<organization -> description */
	CaplAttr *a_org_type;			/**<organization -> type */
	CaplAttr *a_org_warehouse;		/**<organization -> recalc_goods_count */
	CaplAttr *a_org_tranz_counter;	/**<organization -> tranzaction_counter */
	CaplAttr *a_org_successor;		/**<organization -> successor */
	CaplAttr *a_org_guid;			/**<organization -> guid */

	CaplAttr *a_org_inn;		/**<organization -> org_inn */
	CaplAttr *a_org_kpp;		/**<organization -> org_kpp */
	CaplAttr *a_org_ogrn;		/**<organization -> org_ogrn */
	CaplAttr *a_org_okpo;		/**<organization -> org_okpo */
	CaplAttr *a_org_cage_code;	/**<organization -> cage_code */
	CaplAttr *a_org_legal_address;		/**<organization -> org_legal_address */
	CaplAttr *a_org_actual_address;		/**<organization -> org_actual_address */
	CaplAttr *a_org_postal_address;		/**<organization -> org_postal_address */
	CaplAttr *a_org_start_date;		/**<organization -> org_start_date */
	CaplAttr *a_org_end_date;		/**<organization ->org_end_date */
	CaplAttr *a_org_phone;		/**<organization -> org_phone */
	CaplAttr *a_org_fax;		/**<organization -> org_fax */
	CaplAttr *a_org_e_mail;		/**<organization -> org_e_mail */
	CaplAttr *a_org_web;		/**<organization -> org_web */
	CaplAttr *a_org_bik;				/**<organization -> bik */
	CaplAttr *a_org_default_account;	/**<organization -> default_account */
	CaplAttr *a_org_chief;				/**<organization -> chief */
	CaplAttr *a_org_country;
	CaplAttr *a_org_federal_subject;	/**<organization -> federal_subject */
	CaplAttr *a_org_classes;
	CaplAttr *a_org_date_actual;		/**<organization -> date_actual */
	CaplAttr *a_org_city;				/**<organization -> city */
	CaplAttr *a_org_coordinates;		/**<organization -> coordinates */

	CaplEntity *e_org_account;
	CaplAttr *a_org_account_org;	/**<organization_account -> organization */
	CaplAttr *a_org_account_bank;	/**<organization_account ->  bank*/
	CaplAttr *a_org_account_type;	/**<organization_account -> type */
	CaplAttr *a_org_account_number;	/**<organization_account ->  number*/
	CaplAttr *a_org_account_description;	/**<organization_account -> description */
	CaplAttr *a_org_account_cor_account;	/**<organization_account -> correspondent_account */


	CaplEntity *e_org_rel;
	CaplAttr *a_org_rel_name;
	CaplAttr *a_org_rel_descr;
	CaplAttr *a_org_rel_relating;
	CaplAttr *a_org_rel_related;
	
	
	CaplEntity	*e_apl_org_type;
	CaplAttr	*a_apl_org_type_name;

	CaplEntity *e_calendar_holyday;
	CaplAttr *a_calendar_holyday_day;

	CaplEntity *e_apl_user;
	CaplEntity *e_apl_access_agent;
	CaplEntity *e_apl_workgroup;
	CaplAttr *a_apl_user_for_web_server;
	CaplAttr *a_apl_user_name,*a_apl_user_po,*a_apl_user_descript,*a_apl_user_groups;
	CaplAttr *a_apl_user_is_ro,*a_apl_user_is_ar,*a_apl_user_is_disabled, *a_apl_user_access_pattern;

	CaplEntity *e_apl_acc_pat;
	CaplAttr *a_apl_acc_pat_name,*a_apl_acc_pat_pattern;

	//  '
	CaplEntity	*e_arm;
	CaplAttr	*a_arm_name;
	CaplAttr	*a_arm_roles;

	CaplEntity	*e_arm_role;
	CaplAttr	*a_arm_unwork_role;
	CaplAttr	*a_arm_unwork_status;
	CaplAttr	*a_arm_role_name;
	CaplAttr	*a_arm_role_rules;

	CaplEntity	*e_role_rule;
	CaplAttr	*a_role_rule_set;
	CaplAttr	*a_role_rule_name;


	CaplEntity*             e_apl_digital_sign_open_key;
	CaplAttr*				a_apl_digital_sign_open_key_person;
	CaplAttr*				a_apl_digital_sign_open_key_open_key_metod;
	CaplAttr*				a_apl_digital_sign_open_key_open_key_cert_serial_num;
	CaplAttr*				a_apl_digital_sign_open_key_open_key_cert_issuer;
	CaplAttr*				a_apl_digital_sign_open_key_open_key_cert_subject;
	CaplAttr*				a_apl_digital_sign_open_key_open_key_cert_blob;
	CaplAttr*				a_apl_digital_sign_open_key_open_key;
	CaplAttr*				a_apl_digital_sign_open_not_before;
	CaplAttr*				a_apl_digital_sign_open_not_after;
	CaplAttr*				a_apl_digital_sign_open_revocation_date;
	CaplAttr*				a_apl_digital_sign_open_key_container;
	CaplAttr*				a_apl_digital_sign_open_key_author;
	CaplAttr*				a_apl_digital_sign_cert_type;
	CaplAttr*				a_apl_digital_sign_open_key_confidential;

	CaplEntity	*e_role_colset;
	CaplAttr	*a_role_colset_role;
	CaplAttr	*a_role_colset_view_name;
	CaplAttr	*a_role_colset_column_set;

};

// *************************************************************************
// *************************************************************************
// *************************************************************************
#define MESSAGE_DLG_CANCEL -1
#define MESSAGE_DLG_REPLY 1
#define MESSAGE_DLG_FORWARD 3
#define MESSAGE_DLG_DELETE 4
#define MESSAGE_DLG_SEND 5
#define MESSAGE_DLG_SAVE 6
#define MESSAGE_DLG_OPEN_NOMODAL 7
#define MESSAGE_DLG_REPLY_ALL 8

/**  */
class CLASS_DECL_APL_STEP_MGR CaplMessageManager: public CaplStepManager
{
	//  
public:
	const static TCHAR m_alert_state_active[];
	const static TCHAR m_alert_state_completed[];
	// Attributes
	CaplEntity *e_message;
	CaplAttr *a_message_sender;
	CaplAttr *a_message_recipient;
	CaplAttr *a_message_recipient_in_copy;
	CaplAttr *a_message_subject;
	CaplAttr *a_message_content_lenght; //    0
	CaplAttr *a_message_content_source; // blob c 
	CaplAttr *a_message_content;        //   (  ,    BLOB)
	CaplAttr *a_message_content_format;	// html  rtf
	CaplAttr *a_message_items;
	CaplAttr *a_message_priority;
	CaplAttr *a_message_ask_notify;
	CaplAttr *a_message_status;
	CaplAttr *a_message_date_send;
	CaplAttr *a_message_date_received;
	CaplAttr *a_message_prev_message;
	CaplAttr *a_message_forward;
	CaplAttr *a_message_sender_kill;
	CaplAttr *a_message_recipient_kill;

	
	CaplAttr *a_message_copy;
	CaplAttr *a_message_copies;
	CaplAttr *a_message_sender_folder;
	CaplAttr *a_message_recipient_folder;
	CaplAttr *a_message_complete_date;
	CaplAttr *a_message_required_complete_date;
	CaplAttr *a_message_message_type;
	
	CaplAttr *a_message_rec_offisial;
	CaplAttr *a_message_rec_nick;
	CaplAttr *a_message_send_nick;

	CaplAttr *a_message_code;
	CaplAttr *a_message_last_reply;
	CaplAttr *a_message_note;

	CaplAttr *a_message_kurator;
	CaplAttr *a_message_complete_date2;
	CaplAttr *a_message_required_complete_date2;
	
	CaplAttr *a_message_counter;
	CaplAttr *a_message_parent;

	CaplAttr *a_message_sender_color;
	CaplAttr *a_message_recipient_color;


	CaplEntity *e_subscr;
	CaplAttr *a_subscr_item;
	CaplAttr *a_subscr_subscriber;
	
	CaplEntity* e_alert;
	CaplAttr* a_alert_person;
	CaplAttr* a_alert_item;
	CaplAttr* a_alert_code;
	CaplAttr* a_alert_date;
	CaplAttr* a_alert_next_date;
	CaplAttr* a_alert_text;
	CaplAttr* a_alert_span;
	CaplAttr* a_alert_module;
	CaplAttr* a_alert_function;
	CaplAttr* a_alert_author;
	CaplAttr* a_alert_state;
	CaplAttr* a_alert_delete_completed;
	CaplAttr* a_alert_notify_author;

public:
	// 
	/**   (    ) 
		@return true     false   . */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();
	
	/**   
		@param recipient   .
		@param subject   .
		@param content   .
		@param ext     .
		@param priority      : 0, 1, 2.
		@param status   .   : "draft", "sendet", "readed", "replyed".
		@param ask_notify         true<\b>   false<\b>   .
		@param silent      true<\b>    false<\b>    .
		@param sArrayFiles     ,      .
		@return    NULL   .  */	
	CaplInstance* CreateMessage(CaplInstance* sender, CaplInstance* recipient, 
		const TCHAR* subject, const TCHAR* content, aplExtent& items, 
		int priority= 1, const TCHAR* status= _T("sendet"),
		bool ask_notify= false, bool silent= false,
		CaplInstance* copy= NULL, aplExtent* possibleRecipient= NULL,
		CStringArray *sArrayFiles=NULL);

	//      exe
	bool CreateMessageExternal(CStringArray *sArrayFiles=NULL); 

	
	/**     
		@param message  ,  .
		@return    NULL   .*/
	CaplInstance* Forward(CaplInstance *message);


	//      exe
	bool ForwardExternal(CaplInstance *message);

	/**    
		@param message  ,    .
		@param bForAll  true,  
		@return    NULL   .*/
	CaplInstance* Reply(CaplInstance *message, bool bForAll=false);

	//       exe
	bool ReplyExternal(CaplInstance *message);


	/**        (
		@param message  .
		@return true<\b>    false<\b>   */	
	bool IsUserSenderOrRecipient(CaplInstance *message);
	
	/**      
		@param message  .
		@return 0<\b> -    , 1<\b> -  , 2<\b> -    , 3<\b> -     .*/
	int ShowMessageProperty(CaplInstance *message, bool bNoActionMode=false);

	/**      
		@param message  .
		@return */
	bool OpenMessageNoModal(CaplInstance *message);
	
	/**        
		@param message  .
		@return true<\b>     false<\b>   .*/
	bool ShowDispMessageState(CaplInstance *message);
	/**       
		@param message  ,      .
		@return true<\b>     false<\b>   .*/
	bool LoadMessageInfo(CaplInstance* message);
	bool LoadMessageInfo(aplExtent &messages);
	/**     
		@param out_extent   .
		@return true<\b>     false<\b>   .*/
	bool GetAllMessages(aplExtent &out_extent);
	
	bool GetPersonDraftedMessages(aplExtent &out_extent, CaplInstance* person= NULL, bool bWithFolder= false);
	bool GetPersonSendedMessages(aplExtent &out_extent, CaplInstance* person= NULL, bool bWithDeleted= false, bool bWithFolder= false);
	bool GetPersonIncomingMessages(aplExtent &out_extent, CaplInstance* person= NULL, bool bWithDeleted= false, bool bWithLosted= false, bool bWithFolder= false);
	int SendDraftMessage(CaplInstance *message, bool bShowDlg= true);

	/**    ,    ,     
		@param out_extent    .
		@return true<\b>     false<\b>   .*/		
	bool GetAllLostMessages(aplExtent &out_extent, CString sStartDate= _T(""), CString sEndDate= _T(""));
	
	/**   
		@param message  ,  .
		@param end_operation  ,   true,     
		@return true<\b>     false<\b>   */
	bool DeleteMessage(CaplInstance *message, bool *end_operation=0);
	
	
	/**     
		@param sender  .  sender==NULL,   .
		@param recipientes   .
		@param subject   .
		@param content   .
		@param items     .
		@return    NULL   .*/	
	CaplInstance* SendNotifyMessage(CaplInstance* sender, aplExtent &recipientes, const TCHAR* subject, 
		const TCHAR* content, aplExtent &items, bool bSubscribe= false);

	/**     
		@param sender  .  sender==NULL,   .
		@param possible_recipients  
  	    @param recipients   (   )
		@param subject   .
		@param content   .
		@param items     .
		@return true<\b>     false<\b>   .*/	
	bool SendGroupMessage(CaplInstance* sender, aplExtent &possible_recipients, aplExtent &recipients, const TCHAR *subject,const TCHAR *content, aplExtent &items);

	/**      
		@param item  .
		@param person ,    .  person==NULL,     .
		@param bSave    .  bSave==true,     .
		@return     NULL   .*/
	CaplInstance* CreateSubscribe(CaplInstance* item, CaplInstance* person= NULL, bool bSave= true);

	/**      
		@param item  .
		@param persons ,    .  person==NULL,     .
		@param bSave    .  bSave==true,     .
		@return     NULL   .*/
	CaplInstance* CreateSubscribe(CaplInstance* item, aplExtent &persons, bool bSave= true);
	
	/**          
		@param item   .
		@return true<\b>     false<\b>   .*/		
	bool EditItemSubscribeList(CaplInstance* item);

	/**      
		@param sbscr    .
		@param bSave    .  bSave==true,     .
		@return true<\b>     false<\b>   .*/		
	bool DeleteSubscribe(CaplInstance* sbscr, bool bSave= true);

	/**   ,    
		@param person ,    .  person==NULL,   .
		@param ext  ,    .
		@return true<\b>     false<\b>   .*/		
	bool GetPersonSubscribeList(CaplInstance* person, aplExtent &ext);

	/**   ,    
		@param item  .
		@param ext ,     .
		@return true<\b>     false<\b>   .*/
	bool GetItemsSubscribers(CaplInstance* item, aplExtent &ext);
	
	/**   
		@param message 
		@param content  
		@return true<\b>     false<\b>   .*/
	bool GetMessageContent(CaplInstance *message,CString &content);
		/**   
		@param message 
		@param content  
		@return true<\b>     false<\b>   .*/
	bool SetMessageContent(CaplInstance *message,CString &content);

	// 
	CaplInstance* CreateAlert(CaplInstance* person, CaplInstance* item, const TCHAR* text, const TCHAR* code,
		COleDateTime alert_date, COleDateTime next_date, COleDateTimeSpan alert_span,
		CString sModule= _T(""), CString sFunction= _T(""),
		CaplInstance* author=0,bool delete_completed=false,bool notify_author=false);
	bool FindAlerts(aplExtent &alerts, CaplInstance* person, CaplInstance* item, const TCHAR* code= NULL);
	//   ext_alerts    person
	// bAsPerson -  , bAsAuthor -  
	bool LoadPersonAlerts(CaplInstance* person, bool bAsAuthor, bool bAsPerson, aplExtent &ext_alerts);
	bool ShowAlert(CaplInstance* alert);
	bool ShowAlert(aplExtent &alert);
	bool DeleteAlert(CaplInstance* alert);
	bool ShowAlertProperties(CaplInstance *alert);
	/**  ()  
		@param alert 
		@param state   ( : m_alert_state_active,m_alert_state_completed); 
		@return true<\b>     false<\b>   .*/
	bool SetAlertState(CaplInstance* alert,const TCHAR *state);
	CaplInstance *CaplMessageManager::CreateAlert(CaplInstance *recipient=0);
	/**       
		@param alert ,      .
		@return true<\b>     false<\b>   .*/
	bool LoadAlertInfo(CaplInstance* alert);
	bool LoadAlertsInfo(aplExtent &alerts);
	bool ShowPersonAlerts(CaplInstance *person);
	bool AddItemToAlert(CaplInstance *alert,CaplInstance *item);
	bool DeleteItemFromAlert(CaplInstance *alert);

	/**         .        create  true -   
		@param create    ,       
		@return            0 -   */
	CaplInstance* GetAddressBook(bool create=false);

	/**     ()  ()
		@param item    
		@param items   / 
		@return true<\b>     false<\b>   .*/
	bool Add2AddressBook(CaplInstance *item);
	bool Add2AddressBook(aplExtent &items);

	/**    ,   -  
	 ,     
		@param item  
		@param recipients ,     
		@return true<\b>     false<\b>   .*/
	bool GetMessageRecipients(CaplInstance *item,aplExtent &recipients);

	/**     / . 
		@param messages    
		@param folder ,     .   ,      
		@return true<\b>     false<\b>   .*/
	bool MoveMessages2Folder(aplExtent &messages, CaplInstance *folder=0);
	bool RemoveMessagesFromFolder(aplExtent &messages);

	/**      eml        .
		    - ,      " .txt"   
		      (   GetItemName).
		    ,     10  -         " .txt"
		      _max_size_mail,       ,   
		    .
		  /    ;       .
		       GetMessageRecipients
		@param message 
		@body_eml    
		@eml_file        
		@_max_size_mail       
		@return true<\b>     false<\b>   .*/
	bool SaveMessageToEml(CaplInstance *message, CaplDataBuf &body_eml, int _max_size_mail = -1);
	bool SaveMessageToEml(CaplInstance *message, LPCTSTR eml_file, int _max_size_mail = -1);

	/**      ,     Email:
	"Email\\Server"
	"Email\\Port"
	"Email\\Login"
	"Email\\Password"
	"Email\\IsProtocoling"
		         -      ,     .
		     ;        Email. 
		  "Email\IsProtocoling"   1,     (  PSM.exe.log)       .
		     Email,       email.    -        "Email\Login" 
		@param message 
		@param err_mess  ,          
		@return true<\b>     false<\b>   .*/
	bool SendMessageToEmlServer(CaplInstance *message, CString *err_mess = 0);


	//  html       .
	//  sResultTempFile     
	bool static SaveHtmlContentToTempFile(const CString &sContent, CString &sResultTempFile);


protected:
	//
	bool RunExternalCmd(LPCTSTR cmd);

};

// *************************************************************************
// *************************************************************************
// *************************************************************************
/**       -*/

class CLASS_DECL_APL_STEP_MGR CaplExternalSender
{
	virtual void SetText(const TCHAR *txt){}
	virtual void SetRange(long range){}
	virtual void SetPos(long pos){}
	virtual void SetRange(long pos,long max_pos){}
};

struct CLASS_DECL_APL_STEP_MGR SParamExchangeManager
{
	SParamExchangeManager();
	BOOL m_ExportProductInstance;
	BOOL m_ExportSubCategory;
	BOOL m_ExportClassifiers;
	BOOL m_ExportSubProduct;
	BOOL m_ExportProductMaterial;
	BOOL m_ExportProductCharacteristics;
	BOOL m_ExportRequirments;
	BOOL m_ExportAssDocuments;
	BOOL m_ExportApproval;
	BOOL m_ExportPrj;
	BOOL m_ExportPrjVer;
	BOOL m_ExportFolders;
	BOOL m_ExportBP;
	BOOL m_ExportBPRes;
	BOOL m_ExportNotes;
	BOOL m_bFormateETDPacket;
	BOOL m_bDeleteTempraryFiles;
	BOOL m_bIgnoreAddDict;
	CaplExternalSender* m_ext_sender;
};
/**    */
class CSelectName;
class CLASS_DECL_APL_STEP_MGR CaplExchangeManager: public CaplStepManager  
{
	friend CSelectName;
	// 
public:
	CaplExchangeManager();

	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();
	
	aplExtent m_array;
	aplExtent m_exported_prd;
	aplExtent m_exported_pdf;
	aplExtent m_exported_doc;
	aplExtent m_exported_bp;
	aplExtent m_exported_bp_res;
	aplExtent m_exported_obj_inst;

	aplExtent m_exported_items_4_approval;

	CaplTAggr <CaplValue*,CaplValue*, APLAGGR_DEFAULT> m_changed_values;
	CStringArray m_changed_values_new;
	CStringArray m_changed_values_old;

	CaplAPI	*m_fileApi;
	CaplNetStepData *m_FileData;

	//  
	static BOOL m_ExportProductInstance;
	static BOOL m_ExportSubCategory;
	static BOOL m_ExportClassifiers;
	static BOOL m_ExportSubProduct;
	static BOOL m_ExportProductMaterial;
	static BOOL m_ExportProductCharacteristics;
	static BOOL m_ExportRequirments;
	static BOOL m_ExportAssDocuments;
	static BOOL m_ExportApproval;
	static BOOL m_ExportPrj;
	static BOOL m_ExportPrjVer;
	static BOOL m_ExportFolders;
	static BOOL m_ExportBP;
	static BOOL m_ExportBPRes;
	static BOOL m_ExportNotes;
	static BOOL m_IgnoreAddDict;

	static BOOL m_ExportDocWithOriginalNames;
	static BOOL m_ExportDocReqvToExtFile;

	CString m_OutPath;
	CString m_OutFile;
	CString m_LastErrDescr;

	//  
	static BOOL m_ImportCategory;
	static BOOL m_ImportClassifiers;
	static BOOL m_ImportProductStruct;
	static BOOL m_ImportProductMaterial;
	static BOOL m_ImportProductCharacteristics;
	static BOOL m_ImportAssDocuments;
	static BOOL m_ImportApproval;
	static BOOL m_ImportProductInst;
	static BOOL m_ImportFolders;
	static BOOL m_ImportProject;
	static BOOL m_ImportBP;
	static BOOL m_ImportBPRes;
	BOOL	m_ImportRequirement;
	CString m_InPath;
	CString m_InFile;


public:	
	/**   (    )   WinETD*/
	bool SaveDocsToWinETDpackage(CaplInstance *ciItem, bool bShowMsg = true);
	bool FormateWinETDPacket(LPCTSTR lpszFileName, CaplInstance* inst, bool bDeleteTempraryFiles,CString *err_mess=0);
//	/**  
//		@param data -    
//		@return true<\b>     false<\b>   */
//	bool ExportDictionary(CaplNetStepData * data);
	/**  
		@param  -     
		@return true<\b>     false<\b>   */
	bool ExportDictionary(const TCHAR * filename=0);
	/**     
		@param ext_copy -    
		@param map		-       
		@param data		- ,  
		@return true<\b>     false<\b>   */
	bool CopyData(aplExtent &ext_copy, CaplMap &map, CaplStepData * data);

	/**     WinETD 
		@param packet -  WinETD
		@param pFileDS -   WinETD
		@param	ciItem -    
	*/
	bool AddEntriesAndApprovalToDataSet(CaplStepData &data, CaplPacket &packet, CFileDataSet *pFileDS, CaplInstance *ciItem, CString &sAddInfoMsg, bool bInstFromFile = true, CString sDir = _T(""));		
	
	/**     
		@return true<\b>     false<\b>   */
	bool ImportDictionary(CaplMap &map, aplExtent &ext_copy);
	
	/**     
		@param filename -  
		@return true<\b>     false<\b>   */
	bool ImportDataFromFile(const TCHAR *filename, CaplInstance *packet = NULL);

	/**     
		@param inst -  
		@param filename -  
		@param bRecursive - true -     (  ,   )
		@return true<\b>     false<\b>   */
	bool ExportInstance(CaplInstance * inst, const TCHAR *filename=0,
						bool bRecursive=false,SParamExchangeManager* params=0,CString *err_mess=0);
	/**     
		@param ext -   
		@param filename -  
		@param bRecursive - true -     (  ,   )
		@return true<\b>     false<\b>   */
	bool ExportExtent(aplExtent &ext, const TCHAR *filename=0,
		bool bRecursive=false,SParamExchangeManager* params=0,CString *err_mess=0);
	
	/**       
		@param inst -  
		@return true<\b>     false<\b>   */
	bool ExportCharacteristic(CaplInstance * inInst);

	/**       
		@param ext -     
		@return true<\b>     false<\b>   */
	bool ExportCharacteristic(aplExtent &ext);
	 
	/**         
		@param inst -  
		@return true<\b>     false<\b>   */
	bool ExportFolder(CaplInstance * inInst);

	/**         
		@param inst -  
		@return true<\b>     false<\b>   */
	bool ExportProject(CaplInstance * inInst);

	/**    
		@param inst -  
		@return true<\b>     false<\b>   */
	bool ExportItemApproval(CaplInstance * item);

	/**    
		@param ext - 
		@return true<\b>     false<\b>   */
	bool ExportItemsApproval(aplExtent &ext);

	/**     
		@param inst -  
		@param path -    
		@return true<\b>     false<\b>   */
	bool ExportDocument(CaplInstance *inInst, const TCHAR* path=0);
	
	/**     
		@return true<\b>     false<\b>   */
	bool ExportCategory(CaplInstance *category);

	/**        
		@return true<\b>     false<\b>   */
	bool ExportClassifier(CaplInstance *classifier);
	
	/**     
		@return true<\b>     false<\b>   */
	bool ExportProduct(CaplInstance *inInst);
	
	/**  -   
		@return true<\b>     false<\b>   */
	bool ExportBP(CaplInstance *inInst);
	
	/**    
		@return true<\b>     false<\b>   */
	bool ExportProductInst(CaplInstance *inInst);
	
	/**   
		@return true<\b>     false<\b>   */
	bool ExportNotes(CaplInstance *inInst);

	/**    
		@return true<\b>     false<\b>   */
	bool ExportOrg(CaplInstance *inInst);

	/**   
		@return true<\b>     false<\b>   */
	bool ExportRoles(CaplInstance *inInst);

	/**   
		@return true<\b>     false<\b>   */
	bool ExportOptions(CaplInstance *inInst);
	
	bool ExportLogbookAccess(CaplInstance *inInst);
	bool ExportPrdInstRelations(CaplInstance *inInst);
	
	/**   
		@return true<\b>     false<\b>   */
	bool ExportMessages(CaplInstance *inInst);

	/**   
		@return true<\b>     false<\b>   */
	bool ExportCharacteristicType(CaplInstance *inInst);
	
	/**    
		@return true<\b>     false<\b>   */
	bool ExportDocumentType(CaplInstance *inInst);

	/**   
		@return true<\b>     false<\b>   */
	bool ExportChange(CaplInstance* inInst);

	/**   
	@return true<\b>     false<\b>   */
	bool ExportRequirement(CaplInstance *inInst);

	/**    
	@return true<\b>     false<\b>   */
	bool ExportConfigartionOptions(CaplInstance* inInst);

	/**    
	@return true<\b>     false<\b>   */
	bool ExportAppearance(CaplInstance* inInst);

	/**    .<->
	@return true<\b>     false<\b>   */
	bool ExportAppLimitRel(CaplInstance* inInst);

	/**   
	@return true<\b>     false<\b>   */
	bool ExportAppLimit(CaplInstance* inInst);

	/**    .<->
	@return true<\b>     false<\b>   */
	bool ExportAppOptionRel(CaplInstance* inInst);

	/**   
	@return true<\b>     false<\b>   */
	bool ExportComplectation(CaplInstance* inInst);

	/**    
	@return true<\b>     false<\b>   */
	bool ExportOptionValue(CaplInstance* inInst);

	/**      
	@return true<\b>     false<\b>   */
	bool ExportClassifierAssociation(CaplInstance* inInst);

	/**       
		@param inst -  
		@param filename -  
		@return true<\b>     false<\b>   */
	bool ExportTechAssemblies(aplExtent &ext, const TCHAR *filename=0,
						CString *err_mess=0);

	/**
	 .     
	*/
	bool UndoAptc(CaplInstance *change);

	bool SaveArr2File();
protected:
	int m_recurs_level;	
	CaplMgrPrgsDlg *m_prgs_dlg;
	void ImportCharacteristics(CaplMap &map,aplExtent &ext_copy,  int &prgs_count);
	void ImportCategory(CaplMap& map ,aplExtent& ext_copy );
	void ImportProject(CaplMap& map ,aplExtent& ext_copy);
	void ImportChanges(CaplMap& map ,aplExtent& ext_copy);
	void ImportBP(CaplMap &map,aplExtent &ext_copy,  int &prgs_count);
	void ImportPI(CaplMap &map,aplExtent &ext_copy,  int &prgs_count);
	void ImportClassifierEsquisse(CaplInstance* inst_api,CaplInstance* inst_file);
};

// *************************************************************************
// *************************************************************************
// *************************************************************************
/**  */
class CLASS_DECL_APL_STEP_MGR CaplChangeManager: public CaplStepManager  
{
	// 
public:
	/**   (    ) 
		@return true     false    */
	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	/**@name  */
	//@{
	CaplEntity* e_chng;				/**<apl_change */
	CaplAttr* a_chng_id;			/**<apl_change -> id */
	CaplAttr* a_chng_pdf;			/**<apl_change -> pdf */
	CaplAttr* a_chng_name;			/**<apl_change -> name */
	CaplAttr* a_chng_dscr;			/**<apl_change -> description */
	CaplAttr* a_chng_user;			/**<apl_change -> user */
	CaplAttr* a_chng_autor;			/**<apl_change -> autor */
	CaplAttr* a_chng_create_user;	/**<apl_change -> create_user */
	CaplAttr* a_chng_create_autor;	/**<apl_change -> create_autor */
	CaplAttr* a_chng_create_date;	/**<apl_change -> create_state */
	CaplAttr* a_chng_apply_date;	/**<apl_change -> apply_state */
	CaplAttr* a_chng_state;			/**<apl_change -> state */
	CaplAttr* a_chng_items;			/**<apl_change -> items */
	CaplAttr* a_chng_basis;			/**<apl_change -> basis */
	CaplAttr* a_chng_stock;			/**<apl_change -> stock */
	CaplAttr* a_chng_stock_ceh;		/**<apl_change -> stock_ceh       */
	CaplAttr* a_chng_asm_pdf;		/**<apl_change -> assembly_pdf */
	CaplAttr* a_chng_changed_assemlies;		/**<apl_change -> changed_assemlies */
	CaplAttr* a_chng_is_modify;		
	CaplAttr* a_chng_eff_type;			/**<apl_change -> effectivity_type */
	CaplAttr* a_chng_start_date;		/**<apl_change -> start_date */
	CaplAttr* a_chng_end_date;			/**<apl_change -> end_date */
	CaplAttr* a_chng_start_num;			/**<apl_change -> start_number */
	CaplAttr* a_chng_end_num;			/**<apl_change -> end_number */
	CaplAttr* a_chng_export_num;		/**<apl_change -> export_num */
	CaplAttr* a_chng_order_directive;	/**<apl_change -> order_directive */
	CaplAttr* a_chng_type;				/**<apl_change -> type */
	CaplAttr* a_chng_event_number;		/**<apl_change -> event_number */
	CaplAttr* a_chng_rejection_reason;	/**<apl_change -> rejection_reason */
	CaplAttr* a_chng_helicopter_usage;	/**<apl_change -> helicopter_usage */
	CaplAttr* a_chng_handmade_copy;		/**<apl_change -> handmade_copy */
	CaplAttr* a_chng_base;				/**<apl_change -> base  ( )*/
	CaplAttr* a_chng_src_pi;			/**<apl_change ->    )*/
	CaplAttr* a_chng_urgency;			/**<apl_change -> urgency   */
	CaplAttr* a_chng_issue_date;		/**<apl_change -> ssue_date     */
	CaplAttr* a_chng_validity_pi_date;	/**<apl_change -> validity_pi_date     */
	CaplAttr* a_chng_validity_pi_date_actual;	/**<apl_change -> validity_pi_date      (  )*/
	
	CaplAttr* a_chng_org_code;			/**   */
	CaplAttr* a_chng_grp_num;			/**   */
	CaplAttr* a_chng_doc_id;			/**   */
	CaplAttr* a_chng_basis_code;		/**    */
	CaplAttr* a_chng_usage;				/**  */
	CaplAttr* a_chng_complect_num;		/**   . . */
	CaplAttr* a_chng_list;				/**   */
	CaplAttr* a_chng_stock_introd;		/**    */
	CaplAttr* a_chng_stock_introd_type; /**      */
	CaplAttr* a_chng_to_date;			/**    */
	CaplAttr* a_chng_otd_date;			/**     */
	CaplAttr* a_chng_critical_date;		/**   */
	CaplAttr* a_chng_plan_lead_date;	/**      */
	CaplAttr* a_chng_plan_otd_date;		/**      */
	CaplAttr* a_chng_date_of;			/**   */
	CaplAttr* a_chng_usage_ing;			/**  (   ) */
	CaplAttr* a_chng_group_id;			/**  */
	CaplAttr* a_chng_notice;			/**    -  */
	CaplAttr* a_chng_dependent_items;	

	//    
	CaplEntity*  e_rasc_chng_log;
	CaplAttr*    a_rasc_chng_log_pdf;
	CaplAttr*    a_rasc_chng_log_change;
	CaplAttr*    a_rasc_chng_log_position;
	CaplAttr*    a_rasc_chng_log_shop;
	CaplAttr*    a_rasc_chng_log_date;


	//   ,   	    
	//      workflow.
	CaplEntity*	 e_stock_introd_signal;
	CaplAttr*    a_stock_intr_signal_pdf;
	CaplAttr*    a_stock_intr_signal_stock_introd;
	CaplAttr*    a_stock_intr_signal_event_number;
	CaplAttr*    a_stock_intr_signal_blank_changed;
	CaplAttr*    a_stock_intr_signal_change;
	CaplAttr*    a_stock_intr_signal_pdf_from;
	CaplAttr*    a_stock_intr_signal_stock_introd_series;
	CaplAttr*    a_stock_intr_signal_rasc;
	CaplAttr*    a_stock_intr_signal_signal_number;
	CaplAttr*    a_stock_intr_signal_notes;
	CaplAttr*    a_stock_intr_signal_production_series;

	//    
	CaplEntity*  e_apl_introd_change_by_shop;
	CaplAttr*    a_intr_chng_shop_view_tech;
	CaplAttr*    a_intr_chng_shop_view_master;
	CaplAttr*    a_intr_chng_shop_view_pdb;
	CaplAttr*    a_intr_chng_shop_view_btk;
	CaplAttr*    a_intr_chng_shop_introd_tech;
	CaplAttr*    a_intr_chng_shop_introd_master;
	CaplAttr*    a_intr_chng_shop_introd_pdb;
	CaplAttr*    a_intr_chng_shop_introd_btk;
	CaplAttr*    a_intr_chng_shop_introd_customer;
	CaplAttr*    a_intr_chng_shop_is_printed;
	CaplAttr*    a_intr_chng_shop_date;
	CaplAttr*    a_intr_chng_shop_change;
	CaplAttr*    a_intr_chng_shop_shop;
	CaplAttr*    a_intr_chng_shop_short_descr;	
	CaplAttr*    a_intr_chng_shop_result_check;
	CaplAttr*    a_intr_chng_shop_view_tech_date;
	CaplAttr*    a_intr_chng_shop_view_master_date;
	CaplAttr*    a_intr_chng_shop_view_pdb_date;
	CaplAttr*    a_intr_chng_shop_view_btk_date;
	CaplAttr*    a_intr_chng_shop_introd_tech_date;
	CaplAttr*    a_intr_chng_shop_introd_master_date;
	CaplAttr*    a_intr_chng_shop_introd_pdb_date;
	CaplAttr*    a_intr_chng_shop_introd_btk_date;
	CaplAttr*    a_intr_chng_shop_result_check_date;




	//   
	CaplEntity*  e_apl_chng_rel;
	CaplAttr*    a_chng_rel_related;
	CaplAttr*    a_chng_rel_relating;
						
	//@}
	
	/**@name   */
	//@{
	CaplEntity* e_chng_item;			/**<apl_changed_item */
	CaplAttr* a_chng_item_id;			/**<apl_changed_item -> id */
	CaplAttr* a_chng_item_name;			/**<apl_changed_item -> id */
	CaplAttr* a_chng_item_dscr;			/**<apl_changed_item -> description */
	CaplAttr* a_chng_item_notes;		/**<apl_changed_item -> notes */
	CaplAttr* a_chng_item_basis;		/**<apl_changed_item -> basis */
	CaplAttr* a_chng_item_stock;		/**<apl_changed_item -> stock */
	CaplAttr* a_chng_item_attachment;	/**<apl_changed_item -> attachment */
 	CaplAttr* a_chng_item_autor;		/**<apl_changed_item -> autor */
 	CaplAttr* a_chng_item_user;			/**<apl_changed_item -> user */
 	CaplAttr* a_chng_item_accept_date;	/**<apl_changed_item -> accept_date */
	CaplAttr* a_chng_item_of_chng;		/**<apl_changed_item -> of_change */
	CaplAttr* a_chng_item_item;			/**<apl_changed_item -> item_of_basis */
	CaplAttr* a_chng_item_replace_state;			/**<apl_changed_item -> replace_state */
	//@}

	/**@name   */
	//@{
	CaplEntity* e_basis_item;			/**<apl_basis_item */
	CaplAttr*	a_basis_item_parent;	/**<apl_basis_item -> parent_basis */
	CaplAttr*	a_basis_item_old_rasc;	/**<apl_basis_item -> old_rasc */
	CaplAttr*	a_basis_item_new_rasc;	/**<apl_basis_item -> new_rasc */
	CaplAttr*	a_basis_item_old_count;	/**<apl_basis_item -> old_count */
	CaplAttr*	a_basis_item_new_count;	/**<apl_basis_item -> new_count */
	CaplAttr*	a_basis_item_old_unit;	/**<apl_basis_item -> old_unit */
	CaplAttr*	a_basis_item_new_unit;	/**<apl_basis_item -> new_unit */
	CaplAttr*	a_basis_item_old_mat;	/**<apl_basis_item -> old_mat */
	CaplAttr*	a_basis_item_new_mat;	/**<apl_basis_item -> new_mat */
	CaplAttr*	a_basis_item_pdf;		/**<apl_basis_item -> pdf */
	CaplAttr*	a_basis_item_pdr;		/**<apl_basis_item -> pdr */
	CaplAttr*	a_basis_item_old_cust;	/**<apl_basis_item -> old_customer */
	CaplAttr*	a_basis_item_new_cust;	/**<apl_basis_item -> new_customer */
	CaplAttr*	a_basis_item_old_gab;	/**<apl_basis_item -> old_gabarit  */
	CaplAttr*	a_basis_item_new_gab;	/**<apl_basis_item -> new_gabarit  */
	CaplAttr*	a_basis_item_old_fw;	/**<apl_basis_item -> old_from_waste  */
	CaplAttr*	a_basis_item_new_fw;	/**<apl_basis_item -> new_from_waste  */
	CaplAttr*	a_basis_item_rasc_owner;	
	CaplAttr*	a_basis_item_mat_owner;		
	//@}

	CaplEntity* e_psc;					/**<apl_product_structure_change */
	CaplAttr* a_psc_changed_product;	/**<apl_product_structure_change -> changed_product */
	CaplAttr* a_psc_changing_product;	/**<apl_product_structure_change -> changing_product */
	CaplAttr* a_psc_position;			/**<apl_product_structure_change -> position */
	CaplAttr* a_psc_position_num;		/**<apl_product_structure_change -> position_number */
	CaplAttr* a_psc_value;				/**<apl_product_structure_change -> value */
	CaplAttr* a_psc_unit;				/**<apl_product_structure_change -> unit */
	CaplAttr* a_psc_eff_type;			/**<apl_product_structure_change -> effectivity_type */
	CaplAttr* a_psc_start_date;			/**<apl_product_structure_change -> start_date */
	CaplAttr* a_psc_end_date;			/**<apl_product_structure_change -> end_date */
	CaplAttr* a_psc_start_num;			/**<apl_product_structure_change -> start_number */
	CaplAttr* a_psc_end_num;			/**<apl_product_structure_change -> end_number */
	CaplAttr* a_psc_addit;				/**<apl_product_structure_change -> additional */
	CaplAttr* a_psc_frames_of_reference;/**<apl_product_structure_change -> apl_frames_of_reference */
	CaplAttr* a_psc_cancel_set;			/**<apl_product_structure_change -> canceled_effectivities */
	CaplAttr* a_psc_add_set;			/**<apl_product_structure_change -> added_effectivities */
	CaplAttr* a_psc_modif_set;			/**<apl_product_structure_change -> modified_effectivities */
	CaplAttr* a_psc_created_pdr;		/**<apl_product_structure_change -> created_pdr */
	
	CaplEntity* e_mat;				/**<apl_material_change */
	CaplAttr* a_mat_renking;		/**<apl_material_change -> ranking*/
	CaplAttr* a_mat_der_value;		/**<apl_material_change -> derive_value*/
	CaplAttr* a_mat_der_unit;		/**<apl_material_change -> derive_unit*/
	CaplAttr* a_mat_assort;			/**<apl_material_change -> assortment*/
	CaplAttr* a_mat_size;			/**<apl_material_change -> billet_size*/
	CaplAttr* a_mat_requir;			/**<apl_material_change -> requirements*/

	CaplEntity* e_avc;				/**<apl_document_change_item */
	CaplAttr* a_avc_new_rev;		/**<apl_document_change -> new_revision*/
	CaplAttr* a_avc_old_rev;		/**<apl_document_change -> old_revision*/
	CaplAttr* a_avc_doc;			/**<apl_document_change -> document*/
	CaplAttr* a_avc_method;			/**<apl_document_change -> method*/
	CaplAttr* a_avc_items_for_add_relation;			/**<apl_document_change -> items_for_add_relation*/
	CaplAttr* a_avc_items_for_del_relation;			/**<apl_document_change -> items_for_add_relation*/
	
	CaplEntity* e_abpc;				/**<apl_business_process_change */
	CaplAttr* a_abpc_new_rev;		/**<apl_business_process_change -> new_revision */
	CaplAttr* a_abpc_old_rev;		/**<apl_business_process_change -> old_revision */
	CaplAttr* a_abpc_bp;			/**<apl_business_process_change -> business_process */

	CaplEntity* e_char_change;		/**<apl_characteristic_change_item */
	CaplAttr* a_char_change_new_rev;/**<apl_characteristic_change_item -> new_revision*/
	CaplAttr* a_char_change_old_rev;/**<apl_characteristic_change_item -> old_revision*/
	CaplAttr* a_char_change_val;	/**<apl_characteristic_change_item -> characteristic*/

	/**@name    */
	//@{
	CaplEntity* e_cmf_change_item;			/**<apl_component_make_from_change_item*/
	CaplAttr*    a_cmf_comp_mf;				/**<apl_component_make_from_change_item -> make_from*/
	CaplAttr*    a_cmf_pdf;					/**<apl_component_make_from_change_item -> product_definition*/
	CaplAttr*    a_cmf_mat;					/**<apl_component_make_from_change_item -> material*/
	CaplAttr*    a_cmf_unit;				/**<apl_component_make_from_change_item -> unit*/
	CaplAttr*    a_cmf_value;				/**<apl_component_make_from_change_item -> value*/
	CaplAttr*    a_cmf_derived_unit;		/**<apl_component_make_from_change_item -> derived_unit*/	
	CaplAttr*    a_cmf_derived_value;		/**<apl_component_make_from_change_item -> derived_value*/
	CaplAttr*    a_cmf_type_id;				/**<apl_component_make_from_change_item -> type_id*/		
	CaplAttr*    a_cmf_type;				/**<apl_component_make_from_change_item -> type*/
	CaplAttr*    a_cmf_descr;				/**<apl_component_make_from_change_item -> description*/
	CaplAttr*    a_cmf_id;					/**<apl_component_make_from_change_item -> id*/
	CaplAttr*    a_cmf_author;				/**<apl_component_make_from_change_item -> author*/
	CaplAttr*    a_cmf_new_mat;				/**<apl_component_make_from_change_item -> new_material*/
	CaplAttr*    a_cmf_new_unit;			/**<apl_component_make_from_change_item -> new_unit*/
	CaplAttr*    a_cmf_new_value;			/**<apl_component_make_from_change_item -> new_value*/
	CaplAttr*    a_cmf_new_derived_unit;	/**<apl_component_make_from_change_item -> new_derived_unit */
	CaplAttr*    a_cmf_new_derived_value;	/**<apl_component_make_from_change_item -> new_derived_value*/
	CaplAttr*    a_cmf_new_type_id;			/**<apl_component_make_from_change_item -> new_type_id*/
	CaplAttr*    a_cmf_new_type;			/**<apl_component_make_from_change_item -> new_type*/
	CaplAttr*    a_cmf_new_descr;			/**<apl_component_make_from_change_item -> new_description*/
	CaplAttr*    a_cmf_new_id;				/**<apl_component_make_from_change_item - >new_id*/
	CaplAttr*    a_cmf_of_change;			/**<apl_component_make_from_change_item -> of_change*/
	CaplAttr*    a_cmf_action;				/**<apl_component_make_from_change_item -> action*/
	//@}

	CaplEntity* e_cmf_chng;					/**<apl_component_make_from_change*/
	CaplAttr*    a_cmf_chng_of_change;		/**<apl_component_make_from_change -> of_change*/
	CaplAttr*    a_cmf_chng_items;			/**<apl_component_make_from_change -> items*/

	/**@name    */
	//@{
	CaplEntity* e_cmf_char_ch_item;			/**<apl_component_make_from_characteristic_change_item*/
	CaplAttr*    a_cmf_char_ch_of_change;	/**<apl_component_make_from_characteristic_change_item -> of_change*/
	CaplAttr*    a_cmf_char_ch_pdf;			/**<apl_component_make_from_characteristic_change_item -> product_defnition_formation*/
	CaplAttr*    a_cmf_char_ch_old_rev;		/**<apl_component_make_from_characteristic_change_item -> old_revision*/
	CaplAttr*    a_cmf_char_ch_new_rev;		/**<apl_component_make_from_characteristic_change_item -> new_revision*/
	CaplAttr*    a_cmf_char_ch_char;		/**<apl_component_make_from_characteristic_change_item -> characteristic*/
	//@}

	/**@name       */
	//@{
	CaplEntity* e_order_directive;					/**<apl_order_directive*/
	CaplAttr*    a_order_directive_numbers;			/**<apl_order_directive -> numbers */
	CaplAttr*    a_order_directive_org;				/**<apl_order_directive -> org */
	CaplAttr*    a_order_directive_id;				/**<apl_order_directive -> id */
	CaplAttr*    a_order_directive_name;			/**<apl_order_directive -> name */
	CaplAttr*    a_order_directive_description;		/**<apl_order_directive -> description */
	//@}

	/**@name   */
	//@{
	CaplEntity* e_order_number;						/**<apl_order_number*/
	CaplAttr*    a_order_number_directive;			/**<apl_order_number -> directive */
	CaplAttr*    a_order_number_id;					/**<apl_order_number -> id */
	//@}
	
	/**   
		@param change - 
		@param paeWrongRels -  ,  - 
		@return true     false   */
	#define APL_CH_NO_TECH_APPLY	0x00100000
	#define APL_CH_NO_TECH_CHECK	0x00200000
	#define APL_CH_NO_DRAFT_CHECK	0x00400000

	#define APL_CN_NO_ERR		 1
	#define APL_CH_STD_ERR		 2
	#define APL_CH_MAT_CH_ERR	 4
	#define APL_CH_SHOP_CH_ERR	 8
	#define APL_CH_OGM_ERR		16
	#define APL_CH_STATE_ERR	32

	int ApplyChange(CaplInstance* change, aplExtent *paeWrongRels = NULL, DWORD flag= 0);

	int ApplyChangeGrpz(CaplInstance* change); //    ,   ApplyChange

	bool CheckGrpzChangeGroupById(aplExtent &ext_ch, CString &sErr);
	
	bool ReturnChangeToEdit(CaplInstance* change); //     (   

protected:
	int ApplyChangeContent(aplExtent &extAccess, CaplInstance* change, aplExtent *paeWrongRels = NULL, DWORD flag= 0, bool bKVZ=false); //   ,   ApplyChange
public:
	
	/**   
		@param chnage - 
		@return true     false   */		
	bool UndoChange(CaplInstance* chnage);

	/**   
		@param id -  .
		@param name -  .
		@param dscr -  .
		@param user - ,  .
		@param person - ,  .
		@return     NULL   .*/
	CaplInstance* CreateChange(const TCHAR* id, const TCHAR* name, const TCHAR* dscr,
		const TCHAR* user, CaplInstance* person, aplExtent &chngItems, CaplInstance *base_change=0);

	//    
	CaplInstance* CreateRepaymentChange(CaplInstance *pi_change);

	//    ()
	CaplInstance* CreateLinkedChange(CaplInstance *old_change);

	//    "  "
	enum EStockIntrodType {helicopter_number, date, complect, competition, series, pdo_signal, none};
		
	/**    
		@param change - .
		@return true<\b>     false<\b>   */
	bool DeleteChange(CaplInstance* change);
	
	/**       
		@param pdf_or_doc -    .
		@param changes -  .
		@return true<\b>     false<\b>   */
	bool GetAllChanges(CaplInstance* pdf_or_doc, aplExtent &changes, bool bNotAppliedOnly= false);

	/**     change   */
	bool GetSubChanges(CaplInstance *change, aplExtent &ext_subchanges);

	//     
	CaplInstance *FindRepaymentChange(CaplInstance *pi_change);
	
	/**       
		@param change - .
		@return true<\b>     false<\b>   */
	bool LoadChangeInfo(aplExtent& changes, bool bFullLoad= true);
	bool LoadChangeInfo(CaplInstance* change, bool bFullLoad= true);
	
	/**        
		@param item -  .
		@return true<\b>     false<\b>   */
	bool LoadItemInfo(CaplInstance* item);
	
	/**        
		@param items -  .
		@return true<\b>     false<\b>   */
	bool LoadItemInfo(aplExtent& items);
	
	/**      
		@param change - .
		@return          */
	int ShowChangeProperties(CaplInstance* change);
	
	/**       
		@param change - ,    .
		@return true<\b>     false<\b>   */
	bool ShowChangesTree(CaplInstance* change);

	///      ( change==0,    )
	bool AddItemsToChange(aplExtent &extItems, CaplInstance *change);
	
	/**    ( )    
		@param pdf  
		@return        */
	CString	GetPSCId(CaplInstance *pdf);

	/**    ( )   
		@param doc_rev    
		@return        */
	CString	GetAVCId(CaplInstance *doc_rev);
	
	/**    ( )   -
		@param bp_ver -   -
		@return        */
	CString	GetBPCId(CaplInstance *bp_ver);
	
	/**    ( )    
		@param pdf  
		@return        */
	CString	GetMFCId(CaplInstance *pdf);
	
	/**    ( )   
		@param ch_ver    
		@return        */
	CString GetCHCId(CaplInstance* ch_ver);
	
	CaplInstance* FoundCharactAndType();
	
	/**         
		@param change -  
		@return true      false   */
	bool SetChangeEffectivity(CaplInstance* change, CString& sEffType, CString& sStartCond, CString& sEndCond);
	// 
	CaplInstance* CreateProductStructureChange(const TCHAR* id, const TCHAR* basis, const TCHAR* zadel,
		CaplInstance* pdr_or_pd, CaplInstance* pdf, CaplInstance* value, CaplInstance* unit, 
		const TCHAR* effType, const TCHAR* start_cond, const TCHAR* end_cond);
	/**           
		@param item -      .  item   apl_product_structure_change  apl_document_change_item
		@return 1      0   */
	int ShowPSCItemProperty(CaplInstance* item);
	/**        
		@param pdf -  
		@param change -  
		@param newItems - ,        
		@return true     false    */
	bool ShowAssemblyChanges(CaplInstance* pdf, CaplInstance* change, aplExtent&newItems);
	/**         
		@param pdf -  
		@param change -  
		@param items - ,    
		@return true     false    */
	bool GetPdfChangeItems(CaplInstance* pdf, CaplInstance* change, aplExtent& items);

	/**   */
	bool GetLinkedChange(CaplInstance* change, aplExtent &ext_linked_chagesext_linked_chages);

	bool GenerateChangeId(CString &change_id);  //    

	bool IsChangeAptc(CaplInstance *change);

	/**
	 .     
	*/
	bool UndoAptc(CaplInstance *change);

	CString GetAdditionalMakeChangeLog() { return m_sAdditionalMakeChangeLog; }


	//     
	bool LoadChangeFields(CaplInstance *change, CaplStrStrMap &map_params);

private:
	bool GetPrdEffectivity(CaplInstance* pdr, CString sType, CString sStart, CString sEnd,
		aplExtent &eff_ext, aplExtent *pdrEff = 0);
	bool ResetPrdEffectivity(CaplInstance* eff, 
		CString sType, CString sStart, CString sEnd,
		aplExtent &pdr_ext, aplExtent &eff_ext);
	bool CreateDatedEffSet(BOOL bReset, 
		CString sId, CString sStart, CString sEnd, CaplInstance* pdr_ed, 
		aplExtent &pdr_ext, aplExtent &eff_ext, CaplInstance* pdr_ing= NULL);
	bool CreateNumedEffSet(BOOL bReset, CString sId, CString sStart,
		CString sEnd, CaplInstance* pdr_ed, 
		aplExtent &pdr_ext, aplExtent &eff_ext, CaplInstance* pdr_ing= NULL);
	bool CreateFictiveEff(aplExtent &pdr_ext, CString sType);

	//  eff_set    
	bool FillEffChain(aplExtent &eff_set);
	
	bool SetActive(CaplInstance* bp, CaplInstance* bp_ver);

	aplExtent m_addedEffSet;
	aplExtent m_deletedEffSet;
	aplExtent m_chngedEffSet;

	//      
	CString m_sAdditionalMakeChangeLog;
};

// *************************************************************************
// *************************************************************************
// *************************************************************************
/**   */
class CLASS_DECL_APL_STEP_MGR CaplUnitExchangeManager: public CaplStepManager  
{
public:

#ifndef APL_NO_INSET_IN_DOC

    class BASE //""  
    {  
	public:
		BASE();
		CaplInstance *cUnit;// 
		double conv_factor;//     (  )
		CString id;
		CString name;
		//  
		double length;
		double mass;
		double time;
		double electric_cur;
		double therm_temp;
		double am_of_sub;
		double lum_intens;
    };
	
#endif

	/**        
	@param load_units - true ec      */
	virtual bool Attach(CaplAPI *api);
	
	/**     */
	bool LoadUnits();

	/**   */
	bool InitUnitsBases();

	/**      */
	bool GetPrdUnits(aplExtent &units);

	//   
	bool IsSameBase(BASE *first_base,BASE *second_base);
	
	/**   */
	bool IsSameBase(CaplInstance *first_unit,CaplInstance *second_unit);
	
	/**       */
	bool FindUnitsWithSameBase(CaplInstance *unit,aplExtent *units);
	
	/** amount_to_convert ..whatUnit  result ..inWhatUnit*/
	bool Convert(CaplInstance *whatUnit,CaplInstance *inWhatUnit,double amount_to_convert,double &result);
	
	CaplAttr *a_apl_named_unit_dimensions;
	CaplAttr *a_apl_conv_base_unit_conv_factor;
	CaplAttr *a_apl_derived_unit_elements;
	CaplAttr *a_apl_si_unit_prefix;
	CaplAttr *a_apl_unit_name;
	CaplAttr *a_apl_unit_id;

	CaplEntity	*e_apl_measure_with_unit;
	CaplAttr *a_apl_measure_with_unit_unit_comp,*a_apl_measure_with_unit_value_comp;

	CaplEntity	*e_apl_derived_unit_element;
	CaplAttr *a_apl_derived_unit_element_exponent,*a_apl_derived_unit_element_unit;
	
	CaplEntity *e_apl_dimensional_exponents;
	CaplAttr *a_apl_dim_exp_length_exponent,*a_apl_dim_exp_mass_exponent,*a_apl_dim_exp_time_exponent;
	CaplAttr *a_apl_dim_exp_electric_current_exponent,*a_apl_dim_exp_thermodynamic_temperature_exponent;
	CaplAttr *a_apl_dim_exp_amount_of_substance_exponent,*a_apl_dim_exp_luminous_intensity_exponent;
	
	CaplUnitExchangeManager();
	virtual ~CaplUnitExchangeManager();
protected:
	bool attached;//   

	//    
	CArray<BASE,BASE> all_unit_bases;

	//   
	BASE *GetBase(CaplInstance *unit);

	aplExtent m_ext_prd_unit; //  . .  - 


	//        -  
	bool GetSiAndContextUnitsBases();
	
	//    
	bool GetAllOtherUnitsBases();
	bool GetConvBasedUnitBase(CaplInstance *convUnitAttr,CaplInstance *Unit,double exponent=1,double conv_factor=1);
	bool GetDerUnitBases(CaplInstance *derUnitAttr,CaplInstance *Unit,double exponent=1,double conv_factor=1);
	bool AddUnitBase(CaplInstance *inst,CaplInstance *Unit,double exponent=1,double conv_factor=1);
};

class AFX_EXT_CLASS CaplDeclareWorkflowManager : public CaplStepManager
{
	//  
public:
	/**   (    ) <p>
	@return true     false    */
	virtual bool Attach(CaplAPI *api){return true;}
	virtual void Detach(){;}
	
	/*,       CaplWorkFlowManager*/
	/*.  CaplWorkFlowManager*/
	virtual bool GetUserTaskList(CaplInstance* performer, aplExtent&task_list, bool bCompleted=true, bool bCanceled=true, bool bSuspended=true){return true;}
	virtual bool GetWorkObjects(CaplInstance* task_or_process, aplExtent&objects){return true;}

	virtual bool FindProcessContained(CaplInstance *ciItem, aplExtent &aeExtOut){return false;}
	virtual bool FindProcessContained(aplExtent& extItems, aplExtent& extOut){return false;}
	virtual bool LoadProcessInfo(CaplInstance* process){return false;}
	virtual bool LoadProcessInfo(aplExtent& process){return false;}
	virtual bool GetUserProcessTempList(CaplInstance* owner, aplExtent& proc_tmpls){return false;}

	#define APL_MODE_WFL_SELECT_TEMPLATE			0x00000001
	#define APL_MODE_WFL_SELECT_ACTIVITI			0x00000002


	/**       
	@param templates -    
	@param sel_template -   
	@param bShowAllTemplates -      
	@param SelectMode -        <br>

		APL_MODE_WFL_SELECT_TEMPLATE -    
		APL_MODE_WFL_SELECT_ACTIVITI -   apl_activity

	@return   	*/
	virtual CaplInstance *SelectTemplateSchema(aplExtent &templates, CaplInstance *sel_template=0, bool bShowAllTemplates = true, long SelectMode = APL_MODE_WFL_SELECT_TEMPLATE){return false;}

	virtual void LoadParamsFromDB(){};
};

class AFX_EXT_CLASS CaplPreConfigurationMgr : public CaplStepManager
{
	//  
public:
	CaplPreConfigurationMgr() { m_bReadOnlyWindow = false; };

	/**   (    ) <p>
	@return true     false    */
	virtual bool Attach(CaplAPI *api){return true;}
	virtual void Detach(){;}		

	/**     ,    .      
		readonly   ,    =)) */
	bool m_bReadOnlyWindow;
};

class AFX_EXT_CLASS CaplPreForumManager : public CaplStepManager
{
	//  
public:
	CaplPreForumManager() {};
	~CaplPreForumManager() {};

	/**   (    ) <p>
	@return true     false    */
	virtual bool Attach(CaplAPI *api){return true;}
	virtual void Detach(){;}

	virtual CaplInstance* ShowRefusalQuestions(CaplInstance *refusalInst) { return NULL; };
};

class AFX_EXT_CLASS CaplPreProjectManager : public CaplStepManager 
{
public:
/**   (    ) <p>
	@return true     false    */
	virtual ~CaplPreProjectManager(){;}
	
	bool Attach(CaplAPI *api);
	void Detach();
	bool LoadDictionary();

	//      .    bLoadPrevRelations==true -     (  )
	bool LoadProjectInfo(CaplInstance *project, bool bLoadPrevRelations=false);
	bool LoadProjectInfo(aplExtent &ext, bool bLoadPrevRelations=false);

	//      
	bool IsProjectInContentOfParent(CaplInstance *project);

	//*************************************************************************
	//******        ********************************
	//*************************************************************************

	//       
	bool FindAssociatedItems(CaplInstance *project, aplExtent &out_ext, aplExtent &out_rel); 
	
	//     
	bool FindAssociatedProjects(CaplInstance *item, aplExtent &out_ext, aplExtent &out_rel); 

	//  
	CaplInstance *CreateAssociation(CaplInstance *project,CaplInstance *item,const TCHAR *id=0,const TCHAR *name=0,CaplInstance *control_status=0);
	
	//  
	bool DeleteAssociation(CaplInstance *project,CaplInstance *item);
	
	//  
	CaplInstance *FindAssociation(CaplInstance *project,CaplInstance *item);

	//        
	bool LoadProjectReferenceInfo(CaplInstance *project);
	bool LoadProjectReferenceInfo(aplExtent &ext);


	//*************************************************************************
	//******     () **********************
	//*************************************************************************

	//   .  previous_only==true -      
	bool GetProjectSequenceRelation(CaplInstance *prj, aplExtent &ext_rel, bool previous_only, bool bLoadFromDB=true);

	//      .  previous_only==true -      
	bool LoadProjectsSequenceRelations(aplExtent &projects, aplExtent &ext_rel, bool previous_only, bool bLoadFromDB=true);


	//*************************************************************************
	//******           ******************************************
	//*************************************************************************
	CaplInstance *GetLatestProjectVersion(CaplInstance *project,CString &num);
	/**   
	@param project     
	@param num    (-1   )
	@param make_active    
	@return   , 0    */

	CaplInstance *CreateProjectVersion(CaplInstance *project,CString num=_T("-1"),bool make_active=true);
	/**    
	@param project   
	@return true     false    */

	/**    
	@param project   
	@return true     false    */
	bool MakeProjectVersionActive(CaplInstance *project_ver);

	/**   ,          
	@param project      
	@return  , 0 */
	CaplInstance *GetLock(CaplInstance *project, bool bShowMessages);
	
	/**     ,          */
	CaplInstance *CheckMyLock(CaplInstance *project, bool bShowMessages);


	// , ..       
	virtual bool ShowProjectProperties(CaplInstance *project,bool b_read_only=false){return true;};
	virtual CaplInstance *CreateProject(CaplInstance *base_project=0,const TCHAR id=0,bool add_to_contents=true,CaplInstance *item=0,CaplInstance **rel=0){return 0;};
	virtual bool InsertProjectIntoParent(CaplInstance *project,CaplInstance *parent_project,bool add_to_content=false){return true;};
	virtual void GetAllSubProject(aplExtent &project_ext,aplExtent &ext_out,bool recursive=false,bool include_associated=false,bool from_base=true){ext_out.Clear();return;}

public:
	CaplEntity* e_project;
	CaplAttr* a_project_id;
	CaplAttr* a_project_name;
	CaplAttr* a_project_descr;
	CaplAttr* a_project_descr2;
	CaplAttr* a_project_owner;
	CaplAttr* a_project_kurator;
	CaplAttr* a_project_executors;
	CaplAttr* a_project_co_executors;
	CaplAttr* a_project_co_customers;
	CaplAttr* a_project_prev_sequences;
	CaplAttr* a_project_customer;
	CaplAttr* a_project_date_planned_begin;
	CaplAttr* a_project_date_planned_end;
	CaplAttr* a_project_date_planned_end2;
	CaplAttr* a_project_date_planned_duration;
	CaplAttr* a_project_date_set_mask;
	CaplAttr* a_project_date_actual_begin;
	CaplAttr* a_project_date_actual_end;
	CaplAttr* a_project_date_actual_end2;
	CaplAttr* a_project_labor_useness;             //   [  labor_useness_value,  value_component + unit_component]
	CaplAttr* a_project_labor_useness_actual;      //   [  labor_useness_value,  value_component + unit_component]
	CaplAttr* a_project_labor_useness_actual_date; //    
	CaplAttr* a_project_labor_of_item;             //     (    ) [  labor_useness_value]
	CaplAttr* a_project_persentage;
	CaplAttr* a_project_state;
	CaplAttr* a_project_parent;
	CaplAttr* a_project_content;
	CaplAttr* a_project_type;
	CaplAttr *a_project_prototype;
	CaplAttr *a_project_prd_amount_planned;         //    [real]  (    )
	CaplAttr *a_project_prd_amount_actual;			//    [real] (    )
	CaplAttr *a_project_calc_by_amount;				//    %     ( ) [bool]
	CaplAttr *a_project_prd_amount_unit;			//     (    )
	CaplAttr *a_project_control_type;
	CaplAttr *a_project_transactions;
	CaplAttr *a_project_number;

	CaplAttr *a_project_taken_measures;
	CaplAttr *a_project_payment_condition;
	CaplAttr *a_project_note1;
	CaplAttr *a_project_note2;
	CaplAttr *a_project_note3;
	
	CaplEntity* e_labor_useness_value;
	CaplAttr* a_labor_value;
	CaplAttr* a_labor_unit;
	
	CaplEntity* e_project_type;
	CaplAttr* a_project_type_name;
	
	/*-------------------------------------------*/
	CaplAttr* a_project_act_adm_version;
	CaplAttr* a_project_locker_adm_version;
	CaplAttr* a_project_act_cont_version;
	CaplAttr* a_project_locker_cont_version;
	
	CaplEntity* e_project_adm_ver;
	CaplAttr* a_project_adm_ver_id;
	CaplAttr* a_project_adm_ver_name;
	CaplAttr* a_project_adm_ver_number;
	CaplAttr* a_project_adm_ver_descr;
	CaplAttr* a_project_adm_ver_type;
	CaplAttr* a_project_adm_ver_customer;
	CaplAttr* a_project_adm_ver_labor_useness;
	CaplAttr* a_project_adm_ver_labor_of_item;
	CaplAttr* a_project_adm_ver_persentage;
	CaplAttr* a_project_adm_ver_kurator;
	CaplAttr* a_project_adm_ver_executors;
	CaplAttr* a_project_adm_ver_co_executors;
	CaplAttr* a_project_adm_ver_co_customers;
	CaplAttr* a_project_adm_ver_prev_sequences;

	CaplAttr* a_project_adm_ver_date_planned_begin;
	CaplAttr* a_project_adm_ver_date_planned_end;
	CaplAttr* a_project_adm_ver_date_planned_end2;
	CaplAttr* a_project_adm_ver_date_planned_duration;
	CaplAttr* a_project_adm_ver_date_set_mask;
	CaplAttr* a_project_adm_ver_project;
	CaplAttr* a_project_adm_ver_num;
	CaplAttr *a_project_adm_ver_author;
	CaplAttr *a_project_adm_ver_start;
	CaplAttr *a_project_adm_ver_end;	
	CaplAttr *a_project_adm_ver_content;
	CaplAttr *a_project_adm_ver_parent;
	CaplAttr *a_project_adm_ver_basis;
	CaplAttr *a_project_adm_ver_prd_amount_planned;
	CaplAttr *a_project_adm_ver_prd_amount_unit;
	CaplAttr *a_project_adm_ver_calc_by_amount;
	CaplAttr *a_project_adm_ver_control_type;
	
	
	CaplEntity* e_project_cont_ver;
	CaplAttr* a_project_cont_ver_project;
	CaplAttr* a_project_cont_ver_num;
	CaplAttr* a_project_cont_ver_act_content;
	/*---------------------------------------------------*/

	/*  -------------------------------------------*/

	CaplEntity* e_project_ref;
	CaplAttr* a_project_ref_item;
	CaplAttr* a_project_ref_project;
	CaplAttr* a_project_ref_id;
	CaplAttr* a_project_ref_name;
	CaplAttr* a_project_ref_control_status;

	CaplEntity* e_project_seg;
	CaplAttr* a_project_seq_prev;
	CaplAttr* a_project_seq_next;
	CaplAttr* a_project_seq_type;
	CaplAttr* a_project_seq_offset;
	
	bool m_bShowMessages;
	int m_show_ass_projects;//  ,      -

	//Money Transaction
	CaplEntity* e_money_transaction;//
	CaplAttr* a_money_transaction_id;//  (, )
	CaplAttr* a_money_transaction_name;//
	CaplAttr* a_money_transaction_descr;//
	CaplAttr* a_money_transaction_type;//
	CaplAttr* a_money_transaction_date;//
	CaplAttr* a_money_transaction_summ;//
	CaplAttr* a_money_transaction_account;//
	CaplAttr* a_money_transaction_nds;//  %
};
 
class AFX_EXT_CLASS CaplOptionsManager : public CaplStepManager 
{
public:
/**   (    ) <p>
	@return true     false    */
	bool Attach(CaplAPI *api);
	void Detach();
public:
	CaplEntity *e_str;
	CaplEntity *e_int;
	CaplEntity *e_inst;
	CaplEntity *e_ext;
	CaplEntity *e_double;
	CaplAttr *a_str_name;
	CaplAttr *a_str_value;
	CaplAttr *a_int_name;
	CaplAttr *a_int_value;
	CaplAttr *a_inst_name;
	CaplAttr *a_inst_value;
	CaplAttr *a_ext_name;
	CaplAttr *a_ext_value;
	CaplAttr *a_double_name;
	CaplAttr *a_double_value;
	/*---------------------------------------------------*/
	#define OPTION_TYPE_STRING 0x00000001
	#define OPTION_TYPE_INT 0x00000002

	bool m_bShowMessages;

	CaplStrMap m_params;
	CaplMap m_paterns;

protected:
	CString m_sInstallCode; //   " "     

public:
	bool LoadDictionary();
	bool LoadOptionsInfo(CaplInstance *option);
	bool LoadOptionsInfo(aplExtent &ext);

	bool InitDefaultOptions();


	int GetCounterWithIncrementBN(const TCHAR *name); //    1    .     .

	CaplInstance *FindOptionBN(const TCHAR *name);

	bool GetOptionValueBN(const TCHAR *name,CaplInstance **val, CaplInstance* DefVal = NULL);
	bool GetOptionValueBN(const TCHAR *name,CString &val,const TCHAR *def_value=_T(""));
	bool GetOptionValueBN(const TCHAR *name,int &val, int def_value=0);
	bool GetOptionValueBN(const TCHAR *name, aplExtent& val);
	bool GetOptionValueBN(const TCHAR *name,double &val, double def_value=0);
	int GetIntOptionValueBN(const TCHAR *name, int def_value);
	CaplInstance *GetInstOptionValueBN(const TCHAR *name, CaplInstance* DefVal = NULL);

	CaplInstance *CreateOption(const TCHAR *name,const TCHAR *value);
	CaplInstance *CreateOption(const TCHAR *name,int value);
	CaplInstance *CreateOption(const TCHAR *name,CaplInstance* value);
	CaplInstance *CreateOption(const TCHAR *name, aplExtent &ext);
	CaplInstance *CreateOption(const TCHAR *name, double value);
	CaplInstance *CreateOption(const TCHAR *name);
	
	bool ShowOptionProperties(CaplInstance *option);
	bool DeleteOption(CaplInstance *option);

	bool GetOptionName(CaplInstance *option, CString &name);
	bool WherePatternUsed(CString &pattern_name, CString &option_used);
	
	CaplInstance* GetDefPatern(CaplEntity* entity);
	BOOL GetDefTmplName(CaplEntity* entity, CString& sTmplName);
	BOOL GetDefPatern(CaplEntity* entity, CString& sPatern);

	bool SetPattern4AutoAccess();
	bool SetFirewallProperties();
	
	inline CString GetPdfSeriesOptionName() const;
	inline CString GetInventoryBookOrderFromOptionName() const;

	INT_PTR CreateDlgADProperties ();

	//    (  ).     code -  true.  false
	//     LoadDictionary
	bool CheckInstallCode(LPCTSTR code);

	//   " "
	bool EditPersonalOptions();

	//          "|".  
	bool DivideStringOptions(LPCTSTR str, CStringArray &strings);

	
	//   
	bool LoadPersonalOptionString(CString &sOptions, CaplInstance *person=0); //     .  0==person,   
	bool SavePersonalOptionString(CString &sOptions); //         

	int GetIntPersonalOptionValueBN(CString &sOptions, const TCHAR *name, int def_value); //   
	bool SetIntPersonalOptionValueBN(CString &sOptions, const TCHAR *name, int value); //   
	bool DeletePersonalOptionValueBN(CString &sOptions, const TCHAR *name); //   

	//       
	//    -  0.  0==person,   
	int GetIntPersonOption(CaplInstance *person, LPCTSTR sOption); 
};

class CLASS_DECL_APL_STEP_MGR CaplFormManager : public CaplStepManager
{
protected:

	/**  2003  2005      
		 callback ...
	*/
	BOOL (*m_FShowFormI)(CaplAPI*, CaplInstance*,
		aplExtent& aeInInsts,aplExtent& aeOutInsts,
		aplExtent* aeChars,LPCTSTR csInstChg,
		CString csPath/*=""*/,
		BOOL bAutoSave/*=TRUE*/, BOOL bTst/*=FALSE*/,
		BOOL bHideAdd /*=FALSE*/);

public:
	CaplFormManager();

	/**   (    ) 
		@return true     false    */
	virtual bool			Attach(CaplAPI *api);
	virtual void			Detach();

	void					LoadData();
	BOOL					LoadInstAttrs(CaplInstance* cit);
	BOOL					LoadLockerAttrs(CaplInstance* ciLocker);
	BOOL					GetFormEntityName(CaplInstance* form,CString &entity_name);
	CaplInstance*			GetFormBN(LPCTSTR lpszName);
	bool					ShowForm(CaplInstance* form,
		aplExtent& aeInInsts, aplExtent& aeOutInsts, aplExtent* aeChars, LPCTSTR csInstChg,
							   CString csPath=_T(""), BOOL bAutoSave=TRUE, BOOL bTst=FALSE, BOOL bHideAdd=FALSE);
	inline bool				TestFormCompatible(CaplInstance* form,CString &test_entity_name);
	inline bool				TestFormCompatible(CaplInstance* form,CaplEntity *test_entity);

	CaplEntity*				e_form;
	CaplAttr*				a_form_name;
	CaplAttr*				a_form_width;
	CaplAttr*				a_form_height;
	CaplAttr*				a_form_instances;
	CaplAttr*				a_form_elements;
	CaplAttr*				a_form_active;
	CaplAttr*				a_form_locker;
	CaplAttr*				a_form_descr;
	
	CaplEntity*				e_form_revision;
	CaplAttr*				a_form_rev_id;
	CaplAttr*				a_form_rev_name;
	CaplAttr*				a_form_rev_width;
	CaplAttr*				a_form_rev_height;
	CaplAttr*				a_form_rev_start_date;
	CaplAttr*				a_form_rev_end_date;
	CaplAttr*				a_form_rev_author;
	CaplAttr*				a_form_rev_user;
	CaplAttr*				a_form_rev_of_form;
	CaplAttr*				a_form_rev_elements;
	CaplAttr*				a_form_rev_instances;
	CaplAttr*				a_form_rev_descr;
							
	CaplEntity*				e_form_instance;
	CaplAttr*				a_form_instance_base_instance;
	CaplAttr*				a_form_instance_base_instance_attr_name;
	CaplAttr*				a_form_instance_entity_name;
	CaplAttr*				a_form_instance_child_instances;
	CaplAttr*				a_form_instance_attrs;
	
	CaplEntity*				e_form_el_access;
	CaplAttr*				a_form_el_acc_type;
	CaplAttr*				a_form_el_acc_dis;
	CaplAttr*				a_form_el_acc_roles;
							
	CaplEntity*				e_form_element;
	CaplAttr*				a_form_element_point;
	CaplAttr*				a_form_element_cx;
	CaplAttr*				a_form_element_cy;
	CaplAttr*				a_form_element_text;
	CaplAttr*				a_form_element_form_instance;
	CaplAttr*				a_form_element_tab_order;
	CaplAttr*				a_form_element_is_req;
	CaplAttr*				a_form_element_access;
							
	CaplEntity*				e_characteristic_element;
	CaplAttr*				a_characteristic_element_characteristic;
	CaplAttr*				a_characteristic_element_characteristic_type;
							
	CaplEntity*				e_attr_element;
	CaplAttr*				a_attr_element_attr_name;
	CaplAttr*				a_attr_element_attr_id;
	CaplAttr*				a_attr_element_subst_form;
							
	CaplEntity*				e_text_element;
	CaplEntity*				e_frame_element;

	CaplEntity*				e_inst_select_element;
	CaplAttr*				a_inst_select_element_name;
	CaplAttr*				a_inst_select_element_instance_name;
	
	CaplEntity*				e_picture_element;
	CaplAttr*				a_pic_element_mode;
	CaplAttr*				a_pic_element_pic;

	CaplEntity*				e_chars_list_element;
	CaplAttr*				a_chars_list_element_name;
	CaplAttr*				a_chars_list_element_chars_list;	

};

class CLASS_DECL_APL_STEP_MGR CaplRequirementMgr : public CaplStepManager
{
protected:

public:
	//CaplRequirementMgr();

	/**   (    ) 
	@return true     false    */
	virtual bool			Attach(CaplAPI *api);
	virtual void			Detach();

	//     
	bool LoadReqInfo(aplExtent &aeItems, bool bLoadDocuments = false);
	bool LoadReqInfo(CaplInstance *ciRequirement, bool bLoadDocuments = false);
	
	//  
	bool ShowProperties(CaplInstance *ciRequirement);

	//  
	bool DeleteRequirement(CaplInstance *ciRequirement, bool bShowMsg = true, bool bSaveChanges = true);

	//         
	CaplInstance* AddChild(CaplInstance *ciParent, CaplInstance *ciChild);
	
	//  
	CaplInstance* CreateRequirement(CaplInstance *ciParent = 0);

	//     
	bool MoveRequirement(CaplInstance *ciMoved, CaplInstance *ciTo);

	//      
	bool RequirementHasChild(CaplInstance *ciRequirement);

	//        ()
	bool IsRequirementUniqueId(CaplInstance *ciParent, CaplInstance *ciRequirement, CString sId);

	//       html
	bool ReplaceReferenceInHTML(CString &html, CString oldSource, CString newSource);

	//        
	CaplInstance* CreateRequirementInderect(CaplInstance *ciParent, CString id, CString name, CString html);

	//    XML,     Word 2003
	bool ImportRequirementsFromXMLword2003(aplExtent &aeRootItems, CString sPath = _T(""), CaplInstance *ciParent = 0);

	//      HTML
	bool GetUnformattedTextFromHTML( CString &sText, CString sHTML );

	//        
	void LoadChildsFromBase(CaplInstance *ciRequirement, aplExtent &aeChild, bool bRecursive);

	//        
	void LoadChildsFromCash(CaplInstance *ciRequirement, aplExtent &aeChild, bool bRecursive);

	//   
	CaplInstance* CreateRequirementCopy(CaplInstance *ciRequirement);

	//    
	void CopyRequirementsRecursive(CaplInstance *ciParent, CaplInstance *ciParentCopy, CaplInstance *ciSource);

	//   
	bool LoadRequirementId(aplExtent &aeItems);	 
	bool LoadRequirementId(CaplInstance *ciRequirement);

	//    html
	bool ExportBasisToHTML(CaplInstance *ciRequirement, CString sPath = _T(""));

	//   ,        
	bool ExportAssociatedDocumentsToHTML(CaplInstance *ciRequirement, CString sPath = _T(""));

	//    - 
	CString GetFilePath(BOOL open, CString sExtension, CString sFilter);

	//     
	CString GetInitialRequirementState();

	//        
	CString ConvertForRequirementSort( CString str );

	//      
	bool SubstituteImgReferencesWithFilesNames(CString &html, CStringArray &saImgReferences);

	//     ,      
	bool CreateFilesByBlobs(CaplInstance *ciReq, CString sPath, CStringArray &saBlobsAndFileNames);

	//     25   TXT,    PDF
	bool ImportAP25FromTxt(aplExtent &aeRootItems, CaplInstance *ciRequirement, CString sPath = _T(""));

	//      
	CaplInstance* CreateAssociation(CaplInstance *ciReq, CaplInstance *ciItem);

	//   ,   
	bool FindAssociatedReqs(CaplInstance *ciItem, aplExtent &aeReq, aplExtent &aeAssoc, bool bLoadFromBase = true);

	//   
	bool FindAssociatedItems(CaplInstance *ciReq, aplExtent &aeItems, aplExtent &aeAssoc, bool bLoadFromBase = true);

	//    ()      ciReq
	bool SetAttrForChilds(CaplInstance *ciReq);

protected:

	//     
	CaplInstance* ShowPropertiesDialog(CaplInstance *ciRequirement, CaplInstance *ciParent, CString &sVS, CString &sDeveloper);

	//    UTF-8  Win1251
	CString ConvertFromUTF8toWIN1251(CString sSource);

	//     
	bool DeleteAllRequirementFromBase();

	//   
	void GetChildsRecursiveFromBase(aplExtent &aeParents, aplExtent &aeChild, bool bRecursive);

	//    ( )
	void BuildHTMLTable(CaplInstance *ciRequirement, CString &html);

	//   
	void GetChildsRecursiveFromCash(aplExtent &aeParents, aplExtent &aeChild, bool bRecursive);

	//      (   )
	int GetRequirementIdLastIndex(CString str);

public:
	
	// 
	CaplEntity*				e_requirement;
	CaplAttr*    			a_req_state;
	CaplAttr*    			a_req_parent;
	CaplAttr*    			a_req_root_parent;
	CaplAttr*    			a_req_source;
	CaplAttr*    			a_req_id;
	CaplAttr*    			a_req_name;
	CaplAttr*    			a_req_html;
	CaplAttr*    			a_req_files;
	CaplAttr*    			a_req_no_need;
	CaplAttr*    			a_req_last_updated;
	CaplAttr*    			a_req_updated_person;
	CaplAttr*    			a_req_mos;
	CaplAttr*    			a_req_executor;
	CaplAttr*    			a_req_equivalence_date;
	CaplAttr*    			a_req_pictures;
	CaplAttr*    			a_req_developer;
	CaplAttr*    			a_req_vs;
	CaplAttr*				a_req_wf_state;
	CaplAttr*				a_req_notes;

	CaplEntity*				e_requirement_association;
	CaplAttr*				a_req_assoc_item;
	CaplAttr*				a_req_assoc_req;

	CaplEntity*  			e_requirement_stage;
	CaplAttr*    			a_req_stage_requirement;
	CaplAttr*    			a_req_stage_mos;
	CaplAttr*    			a_req_stage_project;
	CaplAttr*				a_req_cfg_oject;
};

class CLASS_DECL_APL_STEP_MGR CaplPreWMSManager : public CaplStepManager
{
public:
	CaplPreWMSManager();
	virtual ~CaplPreWMSManager();

	/**   (    ) 
	@return true     false    */
	virtual bool			Attach(CaplAPI *api);
	virtual void			Detach(); 
	 	
public:

	// 
	CaplEntity*		e_wms_tranzaction; 
	CaplAttr*		a_wms_tranz_source;
	CaplAttr*		a_wms_tranz_recipient;
	CaplAttr*		a_wms_tranz_type;
	CaplAttr*		a_wms_tranz_state;
	CaplAttr*		a_wms_tranz_priority;
	CaplAttr*		a_wms_tranz_items;
	CaplAttr*		a_wms_tranz_inner_moving_items;
	CaplAttr*		a_wms_tranz_last_update;
	CaplAttr*		a_wms_tranz_parent;
	CaplAttr*		a_wms_tranz_id;
	CaplAttr*		a_wms_tranz_descr;
	CaplAttr*		a_wms_tranz_project;
	CaplAttr*		a_wms_tranz_plan_date;
	CaplAttr*		a_wms_tranz_log;
	CaplAttr*		a_wms_tranz_last_edit;
	CaplAttr*		a_wms_tranz_last_planed;
	CaplAttr*		a_wms_tranz_last_reserved;
	CaplAttr*		a_wms_tranz_last_ready;
	CaplAttr*		a_wms_tranz_last_distribute;
	CaplAttr*		a_wms_tranz_last_accepted; 
	CaplAttr*		a_wms_tranz_last_closed; 
	CaplAttr*		a_wms_tranz_last_complect;
	CaplAttr*		a_wms_tranz_total_nds;
	CaplAttr*		a_wms_tranz_user_nds;
	CaplAttr*		a_wms_tranz_sum_with_nds;
	CaplAttr*		a_wms_tranz_user_sum_with_nds;
	CaplAttr*		a_wms_tranz_sum_without_nds;
	CaplAttr*		a_wms_tranz_user_sum_without_nds;
	CaplAttr*		a_wms_tranz_demand_ref;
	CaplAttr*		a_wms_tranz_transporter;
	CaplAttr*		a_wms_tranz_region;
	CaplAttr*		a_wms_tranz_doc_number;
	CaplAttr*		a_wms_tranz_doc_target;
	CaplAttr*		a_wms_tranz_doc_date;
	CaplAttr*		a_wms_tranz_doc2_number;
	CaplAttr*		a_wms_tranz_doc2_date;
	CaplAttr*		a_wms_tranz_doc3_number;
	CaplAttr*		a_wms_tranz_doc3_date;
	CaplAttr*		a_wms_tranz_doc3_type;
	CaplAttr*		a_wms_tranz_account;

	CaplAttr*		a_wms_tranz_ticket_number;
	CaplAttr*		a_wms_tranz_ticket_date;
	CaplAttr*		a_wms_tranz_expeditor;

	CaplAttr*		a_wms_tranz_purchase_schedule;
	CaplAttr*		a_wms_tranz_purchase_stage;
	CaplAttr*		a_wms_tranz_positions_allowing_state;
	CaplAttr*		a_wms_tranz_note;

	CaplEntity*		e_wms_tranzaction_item;
	CaplAttr*		a_wms_tranz_item_tranz;
	CaplAttr*		a_wms_tranz_item_parent;
	CaplAttr*		a_wms_tranz_item_pdf;
	CaplAttr*		a_wms_tranz_item_storage_source;
	CaplAttr*		a_wms_tranz_item_storage_recipient;
	CaplAttr*		a_wms_tranz_item_id;
	CaplAttr*		a_wms_tranz_item_count_plan;
	CaplAttr*		a_wms_tranz_item_count_fact;
	CaplAttr*		a_wms_tranz_item_prd_inst; 
	CaplAttr*		a_wms_tranz_item_lot;
	CaplAttr*		a_wms_tranz_item_cell;
	CaplAttr*		a_wms_tranz_item_confirm;
	CaplAttr*		a_wms_tranz_item_tot_quantity;
	CaplAttr*		a_wms_tranz_item_one_quantity;
	CaplAttr*		a_wms_tranz_item_massa;
	CaplAttr*		a_wms_tranz_item_cost;
	CaplAttr*		a_wms_tranz_item_nds;
	CaplAttr*		a_wms_tranz_item_sum_nds;
	CaplAttr*		a_wms_tranz_item_sum_with_nds;
	CaplAttr*		a_wms_tranz_item_sum_without_nds;
	CaplAttr*		a_wms_tranz_item_package;
	CaplAttr*		a_wms_tranz_item_acceptance;
	CaplAttr*		a_wms_tranz_item_release_date;
	CaplAttr*		a_wms_tranz_item_is_import;
	CaplAttr*		a_wms_tranz_item_unit;
	CaplAttr*		a_wms_tranz_item_provider_id;
	CaplAttr*		a_wms_tranz_item_remain;
	CaplAttr*		a_wms_tranz_item_dispatch;
	CaplAttr*		a_wms_tranz_item_card_number;
	CaplAttr*		a_wms_tranz_item_supplier_cost;
	CaplAttr*		a_wms_tranz_item_supplier_unit;
	CaplAttr*		a_wms_tranz_item_supplier_count;

	CaplAttr*		a_wms_tranz_item_delivery_doc_number;
	CaplAttr*		a_wms_tranz_item_delivery_doc_date;
	CaplAttr*		a_wms_tranz_item_self_cost;
	CaplAttr*		a_wms_tranz_item_prd_instances;
	CaplAttr*		a_wms_tranz_item_responsible;
	CaplAttr*		a_wms_tranz_item_description;

	CaplEntity*		e_wms_dispatch_info;
	CaplAttr*		a_wms_dispatch_waybill_item;
	CaplAttr*		a_wms_dispatch_count;

	CaplEntity*		e_wms_storage_item;
	CaplAttr*		a_wms_storage_item_pdf;
	CaplAttr*		a_wms_storage_item_available;
	CaplAttr*		a_wms_storage_item_ordered;
	CaplAttr*		a_wms_storage_item_reserved;
	CaplAttr*		a_wms_storage_item_last_update;
	CaplAttr*		a_wms_storage_item_org;
	CaplAttr*		a_wms_storage_item_unit;
	CaplAttr*		a_wms_storage_item_acc_type;
	CaplAttr*		a_wms_storage_item_transferred;
	CaplAttr*		a_wms_storage_item_ready;
	CaplAttr*		a_wms_storage_item_order_point;
	CaplAttr*		a_wms_storage_item_last_inv_count;
	CaplAttr*		a_wms_storage_item_last_inv;
	CaplAttr*		a_wms_storage_item_last_inv_item;
	CaplAttr*		a_wms_storage_item_opt_lot;
	CaplAttr*		a_wms_storage_item_base_provider;
	CaplAttr*		a_wms_storage_item_cost;
	CaplAttr*		a_wms_storage_item_min_order_volume;
	
	CaplEntity*		e_wms_cell;
	CaplAttr*		a_wms_cell_organization;
	CaplAttr*		a_wms_cell_id;
	CaplAttr*		a_wms_cell_zone;
	CaplAttr*		a_wms_cell_parent;
	CaplAttr*		a_wms_cell_type;
	CaplAttr*		a_wms_cell_weight;
	CaplAttr*		a_wms_cell_lenght_outter;
	CaplAttr*		a_wms_cell_width_outter;
	CaplAttr*		a_wms_cell_height_outter;
	CaplAttr*		a_wms_cell_lenght_inner;
	CaplAttr*		a_wms_cell_width_inner;
	CaplAttr*		a_wms_cell_height_inner;
	CaplAttr*		a_wms_cell_seats_number;
	CaplAttr*		a_wms_cell_authorized_products;
	CaplAttr*		a_wms_cell_zoom_scheem;

	CaplEntity*		e_wms_authorized_product;
	CaplAttr*		a_wms_ap_pdf;
	CaplAttr*		a_wms_ap_priority;

	CaplEntity*		e_wms_provider_item;
	CaplAttr*		a_wms_provider_item_pdf;
	CaplAttr*		a_wms_provider_item_org;
	CaplAttr*		a_wms_provider_item_price;
	CaplAttr*		a_wms_provider_item_unit;
	CaplAttr*		a_wms_provider_item_duration;
	CaplAttr*		a_wms_provider_item_id;
	CaplAttr*		a_wms_provider_item_priority;
	CaplAttr*		a_wms_provider_item_price_date;
	CaplAttr*		a_wms_provider_item_nds;

	CaplEntity*		e_wms_inner_moving_item;
	CaplAttr*		a_wms_inner_moving_item_item;
	CaplAttr*		a_wms_inner_moving_item_new_cell;
	CaplAttr*		a_wms_inner_moving_item_old_cell;
	CaplAttr*		a_wms_inner_moving_item_id;

	CaplEntity*		e_wms_demand_ref;
	CaplAttr*		a_wms_demand_ref_count;
	CaplAttr*		a_wms_demand_ref_item;
	CaplAttr*		a_wms_demand_ref_pdf;
	CaplAttr*		a_wms_demand_ref_project;

	CaplEntity*		e_wms_zoom_scheem;
	CaplAttr*		a_wms_zoom_scheem_objects;
	CaplAttr*		a_wms_zoom_scheem_cx;
	CaplAttr*		a_wms_zoom_scheem_cy;

	CaplEntity*		e_wms_zoom_scheem_object;
	CaplAttr*		a_wms_zoom_scheem_object_cell;

	CaplEntity*		e_wms_zoom_scheem_rect_object;
	CaplAttr*		a_wms_rect_object_x;
	CaplAttr*		a_wms_rect_object_y;
	CaplAttr*		a_wms_rect_object_cx;
	CaplAttr*		a_wms_rect_object_cy;

	CaplEntity*		e_wms_zoom_scheem_triangle_object;
	CaplAttr*		a_wms_triangle_object_direction;
	CaplAttr*		a_wms_triangle_object_entrance;

	CaplEntity*		e_wms_zoom_scheem_way_object;
	CaplAttr*		a_wms_way_object_points;

	CaplEntity*		e_wms_change_state_log;
	CaplAttr*		a_wms_change_state_log_tranzaction;
	CaplAttr*		a_wms_change_state_log_person;
	CaplAttr*		a_wms_change_state_log_person_organization;
	CaplAttr*		a_wms_change_state_log_date;
	CaplAttr*		a_wms_change_state_log_from_state;
	CaplAttr*		a_wms_change_state_log_to_state;
};

/**    
	@param api   
	@param pdf  ,    
	@param mode   ( 1)   ( 0) .  -1, 
		    
	@return true<\b>     false<\b>   */
bool AFX_EXT_API DoShowContentsDialog(CaplAPI *api,CaplInstance *pdf=0,int mode=-1);

/**         (,
			  )
	@param columns      
	@param items  ,      
	@param mask      
	@param dialog_name  
	@param left_name    
	@param right_name      
	@return <b>true<\b>     <b>false<\b>   */
bool AFX_EXT_API DoChooseCharacteristicsDlg(CStringArray *columns,
			CaplTAggr<CStringArray*,CStringArray*,APLAGGR_AUTOKILLREF|APLAGGR_LIST> *items,
			CUIntArray *mask,CString dialog_name=_T(""),CString left_name=_T(""),CString right_name=_T(""));

/**      ;       
		      
	@param api   
	@param ext    
	@param is_hide_move_button  <b>true<\b>,    "  "
	@param res_move     "  ",   true
	@param can_delete  <b>true<\b>,       "  "
	@param id_changed          "  ",  <b>true<\b>
	@param delete_message  ,        "  "
	@return true<\b>     false<\b>   */
bool AFX_EXT_API MakeInstListTable(CaplAPI *api,aplExtent *ext,
								   bool is_hide_move_button,bool *res_move=0,
								   bool can_delete=false,bool *id_changed=0,CString *delete_message=0,bool is_context_menu_categ = false);
/*
bool AFX_EXT_API MakeNIIAOFindResult(CaplAPI *api,aplExtent *ext,
								   bool is_hide_move_button,bool *res_move=0);
*/

/**      pdf-pi-bpi;       
		      
	@param api   
	@param ext    
	@return true<\b>     false<\b>   * /
bool AFX_EXT_API AnalizeGroupInstances(CaplAPI *api,CaplInstance *basic=0);
*/

CaplInstance AFX_EXT_API *aplSelectPrdInst(CaplInstance* Pdf_or_PrdInst, CaplAPI* api,
							   CStringArray* FName = NULL, CStringArray *FId = NULL, CStringArray *FVer = NULL, CStringArray *FSN = NULL,
							   bool bNFN = true, bool bNFI = true, bool bNFV = true, bool bNFS = true);

bool AFX_EXT_API LoadInstanceTree(CaplInstance *inst, aplExtent &array,CaplExchangeManager* exch_mgr=0);


/**     ;  , ,   
	@param api   */
void AFX_EXT_API EditAccessPattern(CaplAPI *m_api);

/**     ;    
	@param api   
	@param curr_pattern    
	@return     0      (  Cancel)*/
CaplInstance AFX_EXT_API *SelectAccessPattern(CaplAPI *m_api,CaplInstance *curr_pattern=0);

/**      */
CMDIChildWnd AFX_EXT_API *aplCreateClassifiersFrame(CMDIFrameWnd *pMainFrame, CaplAPI* api, CaplInstance *Classifier, UINT nFrameResourceID);

/**  child         */
CMDIChildWnd AFX_EXT_API *aplCreateQueryFrame(CMDIFrameWnd *pMainFrame, CaplAPI* api, UINT nFrameResourceID);
/**           */
CSplitterWnd AFX_EXT_API *aplCreateQuerySplitter(CWnd* pParentWnd, CaplAPI* api, CCreateContext *pContext);


void AFX_EXT_API aplShowAboutDlg(CaplAPI *api, const TCHAR* text, const TCHAR* title = NULL, HICON logo_icon = NULL);

int AFX_EXT_API aplErrorMessage(const TCHAR* message,CaplInstance* inst=0);

bool AFX_EXT_API aplShowFilterDlg(CaplAPI *api, LPCTSTR StringNameQuery, long vis_mode, CaplDataBuf &filter_query_buf, 
									CString &out_extents, CString &out_fields, CString &out_descrtiption, CString &stepql_query);