#if !defined(AFX_TASKDLG_H__91502161_CE77_4DEB_B2A7_AA46F604BEE9__INCLUDED_)
#define AFX_TASKDLG_H__91502161_CE77_4DEB_B2A7_AA46F604BEE9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TaskDlg.h : header file
//

#include "resource.h"
#include <aplNetStepData.h>
#include "ProcessDlg.h"
#include <apl_gui.h>
#include "afxwin.h"

class CaplAPI;
class CaplWorkFlowManager;
/////////////////////////////////////////////////////////////////////////////
// CTaskDlg dialog

class CTaskDlg : public CaplResizableDialog 
{
// Construction
public:
	CTaskDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CTaskDlg)
	enum { IDD = IDD_TASK_DIALOG };
	CSortListCtrl	m_woList;
	CTabCtrl	m_woTabCtrl;
	CaplButton	m_deleteWoBtn;
	CaplButton	m_addWoBtn;
	CaplButton	m_addFileBtn;
	CaplButton	m_perDeleteBtn;
	CaplButton	m_mgrDeleteBtn;
	CaplButton	m_perResBtn;
	CaplButton	m_mgrResBtn;
	CaplButton	m_okBtn;
	CaplButton	m_cancelBtn;
	CButton	m_checkEnd;
	CButton	m_checkCheck;
	CButton	m_startCheck;
	CButton	m_acceptBtn;
	CSliderCtrl	m_percentCtrl;
	CEdit	m_manager_wnd;
	CEdit	m_performer_wnd;
	CEdit	m_name;
	CEdit	m_dscr;
	CEdit	m_id;
	CaplStatic	m_to;
	CComboBox	m_state;
	CComboBox	m_prior;
	CDateTimeCtrl	m_d_start_ctrl;
	CDateTimeCtrl	m_d_finish_ctrl;
	CDateTimeCtrl	m_d_check_ctrl;
	CDateTimeCtrl	m_t_start_ctrl;
	CDateTimeCtrl	m_t_check_ctrl;
	CDateTimeCtrl	m_t_finish_ctrl;
	COleDateTime	m_d_check;
	COleDateTime	m_d_finish;
	COleDateTime	m_d_start;
	COleDateTime	m_t_check;
	COleDateTime	m_t_finish;
	COleDateTime	m_t_start;
	int		m_iPrior;
	int		m_iState;
	int		m_iPercent;
	CString	m_sActId;
	CString	m_sDscr;
	CString	m_sId;
	CString	m_sName;
	CString m_sPercent;
	CString	m_sFactDate;
	CString	m_sPlanDate;
	CString	m_sManager;
	CString	m_sPerformer;
	BOOL	m_bStartCheck;
	BOOL	m_bCheckCheck;
	BOOL	m_bEndCheck;
	//}}AFX_DATA

	CaplAPI *m_api;
	CaplWorkFlowManager *m_wf_mgr;
	
	CaplInstance* m_task;
	CaplInstance* m_taskProt;
	CaplInstance* m_activity;
	CaplInstance* m_process;
	
	BOOL m_bReadOnly;
	COleDateTime m_curDate;

	CString m_sPriority;
	CString m_sState;
	CString m_sOldState;
	CString m_sLastState;
	CString m_sTitle;

	aplExtent m_wo_items; //  
	aplExtent m_del_wo_items;
	
	aplExtent m_personOfficials;

	aplExtent m_taskPer;
	aplExtent m_taskMgr;

	CStringArray m_fileItemsSprav;
	CStringArray m_fileItems;

	long m_lAction;
	long m_lRestart;
	CaplInstance* m_manager;
	CaplInstance* m_performer;
	CaplInstance* m_newManager;
	CaplInstance* m_newPerformer;
	CaplInstance* m_up_level_task;
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTaskDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	BOOL IsValidDates();
	void ShowWorkObjects(BOOL bWo= APL_WFWO_FORWORK);
	CString GetTypeName(CaplInstance* inst);
	void ProcessWorkObjects();

	// Generated message map functions
	//{{AFX_MSG(CTaskDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	void AddAnchors();
	afx_msg void OnSelchangeTaskPriority();
	afx_msg void OnSelchangeTaskState();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnTaskAcceptButton();
	afx_msg void OnTaskPerformerResources();
	afx_msg void OnTaskManagerResources();
	afx_msg void OnTaskManagerDelete();
	afx_msg void OnTaskPerformerDelete();
	afx_msg void OnTaskStartDate();
	afx_msg void OnTaskEndDate();
	afx_msg void OnTaskCheckDate();
	afx_msg void OnProcAddWo();
	afx_msg void OnProcDeleteWo();
	afx_msg void OnProcAddFile();
	afx_msg void OnSelchangeProcTab(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedTaskView();
	CaplButton m_viewBtn;
	afx_msg void OnBnClickedResetDStart();
	CButton m_ResetStartDateBtn;
	afx_msg void OnNMRClickTaskWoListctrl(NMHDR *pNMHDR, LRESULT *pResult);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TASKDLG_H__91502161_CE77_4DEB_B2A7_AA46F604BEE9__INCLUDED_)
