// PdfItem.h: interface for the CPdfItem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PDFITEM_H__F38B651F_1990_4FED_B3B6_295FBC2D8D56__INCLUDED_)
#define AFX_PDFITEM_H__F38B651F_1990_4FED_B3B6_295FBC2D8D56__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CPdfItem  
{
public:
	
	enum
	{
		m_eWeightChar=0,
		m_eCostChar,

		m_eFirstChar=m_eWeightChar,
		m_eLastChar=m_eCostChar
	};

	//	 -    ( )
	//	     invalid,      .
	//	       ,    
	//	  
	CPdfItem(CaplAPI* api,CaplInstance* inst,COleDateTime codtDTFilter,CString& csSNFilter,
			 CaplInstance* ciContext);
	//	 -   ( )
	virtual ~CPdfItem();

	//		    + 1 ( )
	int		GetCount(void);

	//		  -     
	//		caCharVals -  ,    -
	//		. -  - m_api->m_charact_mgr.a_apl_charact_val_meas_val
	//			   - m_api->m_charact_mgr.a_apl_charact_val_monet_val
	//		caChars -    instance - -  
	//		ipChars -  , ,  - 
	//		iCharCount - - -  
	void	LoadChars(CaplTAggr<CaplAttr*,CaplAttr*,APLAGGR_LIST>& caCharVals,
					  CaplTAggr<CaplInstance*,CaplInstance*,APLAGGR_LIST>& caChars,
					  int* ipChars,int iCharCount);

	//		  -
	//		dpRetVals -       -
	//		ipChars -  , ,  - .
	//		iCharCount - - -  
	//		aeTypesOrder -   -,  .
	void	CalcChars(double* dpRetVals,int* ipChars,int iCharCount,aplExtent& aeTypesOrder);

	//		     
	void	GetChilds(CPtrArray& paChilds);
	//		   
	void	GetInfo(CStringList& csInfo);


protected:

	CaplAPI*		m_api;
	CaplInstance*	m_inst;

	COleDateTime	m_codtDTFilter;
	CString			m_csSNFilter;
	CaplInstance*	m_ciContext;

	CPdfItem**		m_pChildItems;
	int				m_iChildsCount;

	CString			m_csPrdID;
	CString			m_csPrdName;
	CString			m_csPdfID;
	CString**		m_pcsCharTypes;

	double**		m_pdInitialValues;
	double**		m_pdCalculatedValues;

	//	
	double			m_dQuantity;


	CaplMap**		m_pChars;


	//				    ,    .
	void			FilterChilds(aplExtent& aeRelsNfd,aplExtent& aePdfsNfd,aplExtent& aeRelsFd,
								 aplExtent& aePdfsFd);
	//				   
	void			LoadInfo(void);
};

#endif // !defined(AFX_PDFITEM_H__F38B651F_1990_4FED_B3B6_295FBC2D8D56__INCLUDED_)
