// functions.cpp

#include "stdafx.h"
#include <apl_api.h>
#include <apl_gui.h>
#include <CommonClasses.h>
#include "resource.h"

extern HINSTANCE _hDllInst;

bool GetInstanceInfo(CaplAPI *m_api, CaplInstance *m_inst, CString &sInfo);

//***********************************************************************************

bool add_function_0_1(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI,aplExtent &out_ext, int &out_cmd)
{
	if(!api || !api->m_data.IsConnected()) return false;

	if(bUpdateUI) return true; //      

	AfxMessageBox("add_function_0_1");

	return true;
}

//***********************************************************************************


bool add_function_0_2(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI,aplExtent &out_ext, int &out_cmd)
{
	if(!api || !api->m_data.IsConnected()) return false;

	if(bUpdateUI) return true; //      

	AfxMessageBox("add_function_0_2");

	return true;
}

//***********************************************************************************

bool add_references(CaplAPI* m_api, aplExtent& inExtent, bool bUpdateUI, aplExtent &out_ext, int &out_cmd)
{
	if(!m_api || !m_api->m_data.IsConnected()) return false;
	if(inExtent.GetSize()<1)  return false;

	CaplInstance *inst=inExtent[0];  //       

	if(0==inst)  return false;
	if(inst->IsDeleted())  return false;
	if(inst->GetAccessmode()>aplRO)  return false;

	if(bUpdateUI)
	{
		//    .   true -  .    false -  .

		if(m_api->m_data.IsKindOf(inst,m_api->m_prd_mgr.e_pdf)) 
		{
			if(inst->GetAccessmode()<=aplRW)  return true;
		}

		return false; //     
	}


	//        

	if(m_api->m_data.IsKindOf(inst,m_api->m_prd_mgr.e_pdf)) 
	{
		if(inst->GetAccessmode()>aplRW)  {AfxMessageBox("  !",MB_OK|MB_ICONSTOP); return false;}
		
		//   
		CaplInstance *doc=m_api->m_doc_mgr.FindDocById("   10018-2014");

		if(0==doc) //   - 
		{
			//   
			//     " ", " ",
			// " ", " ", "   " 
			//   
			//
			// !       ,          (    )
			CaplInstance *i_doc_type=m_api->m_doc_mgr.GetDocumentTypeBN(_T(" "));

			//      
			CString sRef="https://beeline.ru";

			//  ,    blob  
			doc= m_api->m_doc_mgr.CreateDocument("   10018-2014",
				" .        ",
				"",i_doc_type,sRef,false);

			if(0==doc){AfxMessageBox("  ",MB_OK|MB_ICONSTOP); return false;};

			//          
			m_api->m_data.PutAttr(doc, m_api->m_doc_mgr.a_apl_doc_system,"kAssist" );
		}

		//       (  )
		CaplInstance *doc_ref=m_api->m_doc_mgr.CreateAssociation(inst,doc);

		if(0==doc_ref){AfxMessageBox("  ",MB_OK|MB_ICONSTOP); return false;};

		m_api->SaveChanges(); //        

		AfxMessageBox("!",MB_OK|MB_ICONINFORMATION);
		return true; //   
		
	}

	return false; //   
}

//***********************************************************************************


bool check_references(CaplAPI* m_api, aplExtent& inExtent, bool bUpdateUI,aplExtent &out_ext, int &out_cmd)
{
	if(!m_api || !m_api->m_data.IsConnected()) return false;
	if(inExtent.GetSize()<1)  return false;

	CaplInstance *inst=inExtent[0];  //       

	if(0==inst)  return false;
	if(inst->IsDeleted())  return false;
	if(inst->GetAccessmode()>aplRO)  return false;

	if(bUpdateUI)
	{
		//    .   true -  .    false -  .

		if(m_api->m_data.IsKindOf(inst,m_api->m_prd_mgr.e_pdf)) 
		{
			if(inst->GetAccessmode()<=aplRW)  return true;
		}

		return false; //     
	}

	//        

	//        ""

	aplExtent ext_docs, ext_refs;
	m_api->m_doc_mgr.FindAssociatedDocuments(inst,ext_docs,ext_refs);
	m_api->m_doc_mgr.LoadDocInfo(ext_docs);

	CString sText,sId,sBuf;
	int i;
	for(i=0;i<ext_docs.GetSize();i++)
	{
		CaplInstance *doc=ext_docs[i];

		if(doc->GetAccessmode()>aplRO) continue; //  ,      

		m_api->m_data.GetAttr(doc,m_api->m_doc_mgr.a_doc_id,sId);
		
		sBuf=sId;
		sBuf.MakeUpper();
		if(sBuf.Find("")<0) continue;
		
		if(sText!="") sText+="\n";
		sText+=sId;

		m_api->m_doc_mgr.GetFullFileName(doc,sBuf);
		if(sBuf!="")  {sText+="  ";	sText+=sBuf;}

		m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_apl_doc_system,sBuf);
		if(sBuf=="kAssist") sText+=" ( kAssist)";
	}
	if(sText=="") AfxMessageBox("  \"\"  !",MB_OK|MB_ICONINFORMATION);
	else aplShowBigMsg(sText,"  \"\"");

	return false; //   ,  false
}

//***********************************************************************************

//   sInfo    inst
bool GetInstanceInfo(CaplAPI *m_api, CaplInstance *m_inst, CString &sInfo)
{
	sInfo=_T("");
	if(0==m_inst) return false;
	if(m_inst->IsDeleted()) return false;
	if(m_inst->GetAccessmode()>aplRO) return false; //     

	//    
	if(m_api->m_data.IsKindOf(m_inst,m_api->m_doc_mgr.e_apl_doc)   //   
		|| m_api->m_data.IsKindOf(m_inst,m_api->m_doc_mgr.e_apl_doc_rev)) //   
//		|| m_api->m_data.IsKindOf(m_inst,m_api->m_doc_mgr.e_apl_stored_document)) //  
	{
		m_api->m_doc_mgr.LoadDocInfo(m_inst);

		CaplInstance *doc=0; // 
		CaplInstance *rev=0; //  

		if(m_api->m_data.IsKindOf(m_inst,m_api->m_doc_mgr.e_apl_doc))
		{
			sInfo=_T(" :\r\n");
			doc=m_inst;
			m_api->m_data.GetAttr(m_inst,m_api->m_doc_mgr.a_apl_doc_active,rev);
		}
		else if(m_api->m_data.IsKindOf(m_inst,m_api->m_doc_mgr.e_apl_doc_rev))
		{
			sInfo=_T("  :\r\n");
			rev=m_inst;
			m_api->m_data.GetAttr(m_inst,m_api->m_doc_mgr.a_apl_doc_rev_doc, doc);
		}

		if(0==rev || 0==doc) return false; // -    .
		if(doc->GetAccessmode()>aplRO) return false; //    
		if(rev->GetAccessmode()>aplRO) return false; //     

		CString sId,sName,sVer,sFileName;
		m_api->m_data.GetAttr(doc,m_api->m_doc_mgr.a_doc_id,sId);
		m_api->m_data.GetAttr(doc,m_api->m_doc_mgr.a_doc_name,sName);
		m_api->m_data.GetAttr(rev,m_api->m_doc_mgr.a_apl_doc_rev_id, sVer);

		sInfo+=_T(": "); sInfo+= sId;  sInfo+=_T("\r\n");
		sInfo+=_T(": "); sInfo+= sName;  sInfo+=_T("\r\n");
		sInfo+=_T(": "); sInfo+= sVer;  sInfo+=_T("\r\n");

		CaplInstance *stor=0; //  
		m_api->m_data.GetAttr(rev,m_api->m_doc_mgr.a_apl_doc_rev_access_form,stor);
		if(0==stor) return false;
		if(stor->GetAccessmode()>aplRO) return false;  //    

		m_api->m_data.GetAttr(stor,m_api->m_doc_mgr.a_apl_stored_document_file_name,sFileName);
		sInfo+=_T(": "); sInfo+= sFileName;  sInfo+=_T("\r\n");
	}
	else if(m_api->m_data.IsKindOf(m_inst,m_api->m_prd_mgr.e_prd)   //  
		|| m_api->m_data.IsKindOf(m_inst,m_api->m_prd_mgr.e_pdf)) //   
	{
		m_api->m_prd_mgr.LoadPrdInfo(m_inst);

		CaplInstance *prd=0; // 
		CaplInstance *pdf=0; //  

		if(m_api->m_data.IsKindOf(m_inst,m_api->m_prd_mgr.e_prd)) 
		{
			sInfo=_T(" :\r\n");
			prd=m_inst;
		}
		else if(m_api->m_data.IsKindOf(m_inst,m_api->m_prd_mgr.e_pdf))
		{
			sInfo=_T("  :\r\n");
			pdf=m_inst;
			m_api->m_data.GetAttr(m_inst,m_api->m_prd_mgr.a_pdf_prd, prd);
		}

		if(0==prd) return false; // -    .
		if(prd->GetAccessmode()>aplRO) return false; //    

		CString sId,sName,sVer;
		m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_id,sId);
		m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_name,sName);
		
		sInfo+=_T(": "); sInfo+= sId;  sInfo+=_T("\r\n");
		sInfo+=_T(": "); sInfo+= sName;  sInfo+=_T("\r\n");
		
		if(0!=pdf)
		{
			if(pdf->GetAccessmode()>aplRO) return true; //     

			m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_pdf_id,sVer);
			sInfo+=_T(": "); sInfo+= sVer;  sInfo+=_T("\r\n");
		}

	}
	else if(m_api->m_data.IsKindOf(m_inst,m_api->m_classifier_mgr.e_apl_classifier_system))   //  
	{
		CString sId,sName;
		m_api->m_data.GetAttr(m_inst,m_api->m_classifier_mgr.a_apl_classifier_system_id,sId);
		m_api->m_data.GetAttr(m_inst,m_api->m_classifier_mgr.a_apl_classifier_system_name,sName);

		sInfo=_T(" :\r\n");
		sInfo+=_T(": "); sInfo+= sId;  sInfo+=_T("\r\n");
		sInfo+=_T(": "); sInfo+= sName;  sInfo+=_T("\r\n");
	}
	else if(m_api->m_data.IsKindOf(m_inst,m_api->m_classifier_mgr.e_apl_classifier_level)) //   
	{
		CaplInstance *system=0;
		m_api->m_data.GetAttr(m_inst,m_api->m_classifier_mgr.a_apl_classifier_level_system,system);

		if(0==system) return false;
		if(system->GetAccessmode()>aplRO) return false; //     

		CString sId,sName;
		m_api->m_data.GetAttr(system,m_api->m_classifier_mgr.a_apl_classifier_system_id,sId);
		m_api->m_data.GetAttr(system,m_api->m_classifier_mgr.a_apl_classifier_system_name,sName);
		
		sInfo=_T("   \r\n");
		
		sInfo+=_T("\r\n");
		sInfo=_T("C:\r\n");
		sInfo+=_T(": "); sInfo+= sId;  sInfo+=_T("\r\n");
		sInfo+=_T(": "); sInfo+= sName;  sInfo+=_T("\r\n");

		m_api->m_data.GetAttr(m_inst,m_api->m_classifier_mgr.a_apl_classifier_level_id,sId);
		m_api->m_data.GetAttr(m_inst,m_api->m_classifier_mgr.a_apl_classifier_level_name,sName);

		sInfo+=_T("\r\n");
		sInfo+=_T(" :\r\n");
		sInfo+=_T(": "); sInfo+= sId;  sInfo+=_T("\r\n");
		sInfo+=_T(": "); sInfo+= sName;  sInfo+=_T("\r\n");
	}
	return true;
}