// DlgAccessPatternProp.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DlgAccessPatternProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgAccessPatternProp dialog


CDlgAccessPatternProp::CDlgAccessPatternProp(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CDlgAccessPatternProp::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgAccessPatternProp)
	m_Name = _T("");
	m_Definition = _T("");
	//}}AFX_DATA_INIT
	m_data = 0;
	m_pattern = _T("");
	m_inst = 0;
	m_ro = false;
	m_is_temp_users = false;
	m_show_base_patterns = false;
}


void CDlgAccessPatternProp::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgAccessPatternProp)
	DDX_Control(pDX, IDC_NAME, m_EdtName);
	DDX_Control(pDX, ID_CREATE_PATTERN, m_ButCreatePattern);
	DDX_Text(pDX, IDC_NAME, m_Name);
	DDX_Text(pDX, IDC_PATTERN_DEFINITION, m_Definition);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOk);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, ID_BTN_SHOW_PATTERN_USED, m_BtnPatternUsed);
	DDX_Control(pDX, IDC_PATTERN_DEFINITION, m_EditPatternDef);
}


BEGIN_MESSAGE_MAP(CDlgAccessPatternProp, CaplResizableDialog)
	//{{AFX_MSG_MAP(CDlgAccessPatternProp)
	ON_BN_CLICKED(ID_CREATE_PATTERN, OnCreatePattern)
	ON_BN_CLICKED(ID_BTN_SHOW_PATTERN_USED, OnShowPatternUsed)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgAccessPatternProp message handlers

BOOL CDlgAccessPatternProp::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_data == 0)
	{
		EndDialog(IDCANCEL);
		return FALSE;
	}
	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(m_data);

	AddAnchor(IDC_NAME,TOP_LEFT,TOP_RIGHT);

	AddAnchor(IDC_PATTERN_DEFINITION,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(ID_CREATE_PATTERN,TOP_RIGHT,TOP_RIGHT);

	AddAnchor(ID_BTN_SHOW_PATTERN_USED,BOTTOM_RIGHT,BOTTOM_RIGHT);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);


	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);

	if(m_ro){
		m_BtnOk.EnableWindow(FALSE);
		m_ButCreatePattern.EnableWindow(FALSE);
		m_EdtName.EnableWindow(FALSE);
	}

	if(m_show_base_patterns)
	{
		m_Definition += _T("\r\n\r\n");
		m_Definition += m_pattern;
		UpdateData(FALSE);
	}

	/*if(!m_data->NET_IsUsedAccessPattern(m_inst))
	{
		m_BtnPatternUsed.EnableWindow(FALSE);
	}*/

	return TRUE;

}


void CDlgAccessPatternProp::OnCreatePattern() 
{
	// TODO: Add your control notification handler code here
	CString pattern = m_pattern, Definition = m_Definition;
	UpdateData(TRUE);
	while(true)
	{
		if(!m_data->PrepareAccessStringPattern(pattern, &Definition))
			return;

		if(m_inst!=0 && (pattern.Left(2) == _T("1:") || pattern.Left(2) == _T("2:") ||
			pattern.Find(_T(";1:")) != -1 || pattern.Find(_T(";2:")) != -1 ) &&
			m_data->NET_IsUsedAccessPattern(m_inst))
		{
			if(IDNO == AfxMessageBox( APL_T("        ,           .\n   ?"), MB_ICONERROR|MB_YESNO))
			{
				return;
			}
		}
		else
		{
			m_pattern = pattern;
			m_Definition = Definition;
			break;
		}
	}

	if(m_show_base_patterns)
	{
		m_Definition += _T("\r\n\r\n");
		m_Definition += m_pattern;
	}
	UpdateData(FALSE);
}

void CDlgAccessPatternProp::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	if(m_Name == _T(""))
	{
		AfxMessageBox( APL_T("    !!!"));
		return;
	}
	if(m_pattern == _T(""))
	{
		AfxMessageBox( APL_T("   !!!"));
		return;
	}
	//  name
	CaplAttrValue tst_values[1];               
	tst_values[0].value.Set((LPCTSTR)m_Name); 
	tst_values[0].attr = m_data->m_attr_apl_acc_pat__name;     
	if(!m_data->NET_TestUniqueAttrValues(m_data->m_ent_apl_access_pattern,m_inst,1,&tst_values[0], false))
	{
		AfxMessageBox( APL_T("         !!!"));
		return;
	}
	if(m_pattern.Left(2) == _T("1:") || m_pattern.Left(2) == _T("2:") || 
		m_pattern.Find(_T(";1:")) != -1 || m_pattern.Find(_T(";2:")) != -1 )
	{
		if(m_data->NET_IsUsedAccessPattern(m_inst))
		{
			AfxMessageBox( APL_T("        ,           .  ."), MB_ICONERROR);
			return;
		}
		else
		{
			if(IDNO == AfxMessageBox( APL_T("        .         .     ?"), MB_YESNO))
				return;
		}

		m_is_temp_users = true;
	}

	CaplResizableDialog::OnOK();
}

void CDlgAccessPatternProp::OnShowPatternUsed() 
{
	if(!m_data->NET_IsUsedAccessPattern(m_inst))
	{
		AfxMessageBox(APL_T("      ."),MB_OK|MB_ICONINFORMATION);
		return;
	}


	CUIntArray users;
	CString str_mess, str1(_T("")), str2;
	int max_show = 1000;

	if(m_data->NET_WherePatternUsed(m_inst, users))
	{
		if(users.GetCount() > max_show)
		{	
			str_mess.Format(APL_T("      %i .   %i: \n"), users.GetCount(), max_show);
		}
		else
		{
			str_mess.Format(APL_T("      %i .  : \n"), users.GetCount());
			max_show = users.GetCount();
		}

		for(int i=0; i<max_show; i++)
		{
			str2.Format(_T("#%i"), users.GetAt(i));
			if(i > 0) str1 += _T(", ");
			str1 += str2;
			if(str1.GetLength() > 100){str_mess += str1 + _T("\n"); str1.Empty();}
		}
		if(str1.GetLength() > 0){str_mess += str1;}

		aplShowBigMsg(str_mess, APL_T(",    "));
	}
}