// DlgTuneListConnections.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DlgTuneListConnections.h"
#include "DlgTuneConnection.h"
#include "TransportSocketClient.h"

extern bool fbChecIniWrite();

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgTuneListConnections dialog


CDlgTuneListConnections::CDlgTuneListConnections(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CDlgTuneListConnections::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgTuneListConnections)
	m_ClearUserList = FALSE;
	//}}AFX_DATA_INIT
	m_data = 0;
	m_last_selected=-1;

	m_bReadOnly=false;
	m_bExitAfterClose=false;
}

CDlgTuneListConnections::~CDlgTuneListConnections()
{
}

void CDlgTuneListConnections::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgTuneListConnections)
	DDX_Control(pDX, IDC_CLEAR_USER_LIST, m_CtrlClearUserList);
	DDX_Control(pDX, IDC_STATIC_TEXT, m_StatText);
	DDX_Control(pDX, IDC_UP, m_BtnUp);
	DDX_Control(pDX, IDC_DOWN, m_BtnDown);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDC_REMOVE, m_BtnRemove);
	DDX_Control(pDX, IDC_EDIT, m_BtnEdit);
	DDX_Control(pDX, IDC_ADD, m_BtnAdd);
	DDX_Control(pDX, IDC_FIND, m_BtnFind);
	DDX_Control(pDX, IDC_LIST_CONNECTIONS, m_ListConnections);
	DDX_Check(pDX, IDC_CLEAR_USER_LIST, m_ClearUserList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgTuneListConnections, CaplResizableDialog)
	//{{AFX_MSG_MAP(CDlgTuneListConnections)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_CONNECTIONS, OnDblclkListConnections)
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_BN_CLICKED(IDC_DOWN, OnDown)
	//}}AFX_MSG_MAP
	//ON_NOTIFY_EX(TTN_NEEDTEXT, 0, OnToolTipShow)
	ON_NOTIFY(NM_CLICK, IDC_LIST_CONNECTIONS, &CDlgTuneListConnections::OnNMClickListConnections)
	ON_BN_CLICKED(IDC_FIND, &CDlgTuneListConnections::OnBnClickedFind)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgTuneListConnections message handlers


BOOL CDlgTuneListConnections::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	EnableToolTips(TRUE);

	if(m_data== 0) return FALSE;

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(m_data);


	// TODO: Add extra initialization here
	m_BtnAdd.SetIcon(GetAplTableIco(APL_TABLE_NEW));
	m_BtnRemove.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));m_BtnCancel.SetFlat(FALSE);
	m_BtnEdit.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_BtnUp.SetIcon(GetAplTableIco(APL_TABLE_TOP));
	m_BtnDown.SetIcon(GetAplTableIco(APL_TABLE_BOTTOM));
	m_BtnFind.SetIcon(GetAplTableIco(APL_TABLE_FIND));

// 	m_BtnUp.EnableWindow(FALSE);
// 	m_BtnDown.EnableWindow(FALSE);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_REMOVE,TOP_RIGHT);
	AddAnchor(IDC_EDIT,TOP_RIGHT);
	AddAnchor(IDC_ADD,TOP_RIGHT);
	AddAnchor(IDC_DOWN,TOP_RIGHT);
	AddAnchor(IDC_UP,TOP_RIGHT);
	AddAnchor(IDC_FIND,TOP_RIGHT);
	AddAnchor(IDC_LIST_CONNECTIONS,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_STATIC_TEXT,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_CLEAR_USER_LIST, BOTTOM_LEFT);

	/* -    .       CaplTranslate.
	if(m_data->m_lang_england)
	{
		SetWindowText(_T("Tuning connections list"));
		m_BtnCancel.SetWindowText(_T("Cancel"));
		m_StatText.SetWindowText(_T("Connections list"));
		m_CtrlClearUserList.SetWindowText(_T("Clear users list"));
	}*/


	HWND hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_CONNECTIONS);
	ListView_SetExtendedListViewStyle(hWnd, 
		ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT /*| LVS_EX_GRIDLINES */);

	CRect rect;
	m_ListConnections.GetClientRect(rect);
	/* if(m_data->m_lang_england)  -    .       CaplTranslate.
	{
		m_ListConnections.InsertColumn(0,_T("Connection name"),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(1,_T("Server name"),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(2,_T("Port"),LVCFMT_LEFT,rect.Width()*1/10);
		m_ListConnections.InsertColumn(3,_T("Database name"),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(4,_T("Default username"),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(5,_T("Protocol"),LVCFMT_LEFT,rect.Width()/10);
		m_ListConnections.InsertColumn(6,_T("Proxy"),LVCFMT_LEFT,rect.Width()/10);
	}
	else
	{
		m_ListConnections.InsertColumn(0,APL_T(" "),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(1,APL_T(" "),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(2,APL_T(" "),LVCFMT_LEFT,rect.Width()/10);
		m_ListConnections.InsertColumn(3,APL_T(" "),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(4,APL_T("  "),LVCFMT_LEFT,rect.Width()*2/10);
		m_ListConnections.InsertColumn(5,APL_T(""),LVCFMT_LEFT,rect.Width()/10);
		m_ListConnections.InsertColumn(6,_T("Proxy"),LVCFMT_LEFT,rect.Width()/10);
	}*/

	m_ListConnections.InsertColumn(0,APL_T(" "),LVCFMT_LEFT,rect.Width()*2/10);
	m_ListConnections.InsertColumn(1,APL_T(" "),LVCFMT_LEFT,rect.Width()*2/10);
	m_ListConnections.InsertColumn(2,APL_T(" "),LVCFMT_LEFT,rect.Width()/10);
	m_ListConnections.InsertColumn(3,APL_T(" "),LVCFMT_LEFT,rect.Width()*2/10);
	m_ListConnections.InsertColumn(4,APL_T("  "),LVCFMT_LEFT,rect.Width()*2/10);
	m_ListConnections.InsertColumn(5,APL_T(""),LVCFMT_LEFT,rect.Width()/10);
	m_ListConnections.InsertColumn(6,_T("Proxy"),LVCFMT_LEFT,rect.Width()/10);

	m_data->ReadConnectionsInfo();

	UpdateData(FALSE);
	RedrawList();

	if(!m_data->CheckIniWrite()) 
	{
		//AfxMessageBox(APL_T("     aplTranport.ini !\n\n  .\n\n       ."),MB_ICONWARNING|MB_OK);

		CString sMsg=APL_T("       \n\"");
		sMsg+=GetIniFullName();
		sMsg+=_T("\".\n\n");
		sMsg+=APL_T("  .");
		sMsg+=_T("\n\n");
		sMsg+=APL_T("    ,\n      !");
		sMsg+=_T("\n\n");
		sMsg+=APL_T("     () ?\n      () ?");

		if(IDYES==AfxMessageBox(sMsg,MB_YESNO|MB_ICONWARNING))
		{
			bool sStarted=false;
			TCHAR *sCurPathBuf = new TCHAR[MAX_PATH];
			memset(sCurPathBuf,0,MAX_PATH*sizeof(TCHAR));
			if (GetModuleFileName(NULL, sCurPathBuf, MAX_PATH))
			{
				HINSTANCE hRes=ShellExecute(NULL, _T("runas"), sCurPathBuf, 0, 0, SW_SHOWNORMAL);
				//      SE_ERR_ACCESSDENIED == 5
				if((DWORD)hRes>32) sStarted=true;
			}
			delete sCurPathBuf; sCurPathBuf=0;

			if(!sStarted) AfxMessageBox(_T("      !"), MB_OK|MB_ICONSTOP);
			else
			{
				m_bExitAfterClose=true;
				PostQuitMessage(0);
			}
			EndDialog(FALSE);
			return FALSE;
		}

		m_bReadOnly=true;
		m_BtnOk.EnableWindow(FALSE);
		m_BtnAdd.EnableWindow(FALSE);
		m_BtnRemove.EnableWindow(FALSE);
		m_BtnUp.EnableWindow(FALSE);
		m_BtnDown.EnableWindow(FALSE);
	}

	aplInstallFindInTable(&m_ListConnections);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgTuneListConnections::OnOK() 
{
	if(m_data != 0)
	{
		ActualizeList();

		if(!m_data->WriteConnectionsInfo())
		{
			AfxMessageBox( APL_T("    . ,        !"));
			return;
		}
	}
	CaplResizableDialog::OnOK();
}

void CDlgTuneListConnections::ActualizeList()
{
	int num_curr = -1;
	CConnectInfo *cif = 0;
	int curr_item;
	int i;

	CaplTAggr<CConnectInfo*,CConnectInfo*,APLAGGR_LIST> local_list_connection;

	if(m_data== 0)
		return;


	m_last_selected = m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	do{
		num_curr= m_ListConnections.GetNextItem( num_curr , LVNI_ALL | LVNI_ALL );
		if( num_curr == -1) break;
		curr_item=m_ListConnections.GetItemData(num_curr);
		cif = new CConnectInfo();
		cif->Set(m_data->m_list_connection.GetAt(curr_item));
		local_list_connection.Add(cif);

	}while(num_curr != -1);

	m_data->m_list_connection.Clear();
	for(i = 0;i<local_list_connection.Size;i++)
	{
		cif=local_list_connection.GetAt(i);
		m_data->m_list_connection.Add(cif);
		m_ListConnections.SetItemData(i,i);
	}
}

void CDlgTuneListConnections::OnAdd() 
{
	// TODO: Add your control notification handler code here
	if(m_data== 0)
		return;

	if(m_bReadOnly) return;

	CDlgTuneConnection dlg;
	dlg.m_data=m_data;
	int pos_new = 0;
	CConnectInfo *cif = 0;
	CArray<CString,CString> m_missed_names;
	//    
	for(int i = 0;i<m_data->m_list_connection.GetSize();i++)
	{
		m_missed_names.Add(m_data->m_list_connection.GetAt(i)->name);
	}
	dlg.m_missed_names=&m_missed_names;

	short state=GetKeyState(VK_MENU);
	if((state & 0xff00) != 0)
	{
		int num_curr= m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
		if( num_curr!= -1)
		{
			//   
			int curr_item=m_ListConnections.GetItemData(num_curr);
			CConnectInfo *cif=m_data->m_list_connection.GetAt(curr_item);
			dlg.m_CompName=cif->comp_name;
			dlg.m_PortEdit=cif->port;
		}
	}

	if(dlg.DoModal()==IDOK)
	{
		ActualizeList();

		cif=new CConnectInfo();
		cif->id = 0;
		cif->name		=dlg.m_NameConnect;
		cif->comp_name	=dlg.m_CompName;
		cif->port		=dlg.m_PortEdit;
		cif->base_name	=dlg.m_BaseName;
		cif->def_user_name=dlg.m_DefUserName;
		cif->proxy=dlg.m_Proxy;
		cif->protocol=dlg.m_Protocol;
		m_data->m_list_connection.Insert(++m_last_selected,cif);
		RedrawList();
	}
}

void CDlgTuneListConnections::OnRemove() 
{
	// TODO: Add your control notification handler code here
	if(m_data== 0)
		return;
	CUIntArray deleted_vis;
	CString buf1 = _T(""),buf;
	int curr_item;
	int num_curr= m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	while(num_curr!= -1)
	{
		//   
		deleted_vis.Add(num_curr);
		curr_item = m_ListConnections.GetItemData(num_curr);
		if(buf1 != _T(""))buf1+=_T(",");
		buf1+=_T("'") + m_data->m_list_connection.GetAt(curr_item)->name + _T("'");

		num_curr= m_ListConnections.GetNextItem( num_curr , LVNI_ALL | LVNI_SELECTED );
	}

	if(deleted_vis.GetCount() > 0)
	{
		if(deleted_vis.GetCount() == 1)
			buf = APL_T("e ") + buf1 + APL_T("    \n ?");
		else
			buf = APL_T(" ") + buf1 + APL_T("    \n ?");
		if(MessageBox(buf, APL_T(""),MB_YESNO | MB_ICONQUESTION)==IDYES )
		{
			for(int i=deleted_vis.GetCount()-1;i >= 0;i--)
			{
				curr_item = deleted_vis[i];
				m_ListConnections.DeleteItem(curr_item);
			}
			m_last_selected = curr_item;
		}
		ActualizeList();
	}else
		MessageBox( APL_T("   "), APL_T(" "),MB_ICONERROR);

}

void CDlgTuneListConnections::OnEdit() 
{
	// TODO: Add your control notification handler code here
	if(m_data== 0)
		return;
	int num_curr= m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr!= -1){
		//   
		int curr_item=m_ListConnections.GetItemData(num_curr);
		CDlgTuneConnection dlg;
		dlg.m_data=m_data;
		dlg.m_bReadOnly=m_bReadOnly;
		CConnectInfo *cif=m_data->m_list_connection.GetAt(curr_item);
		dlg.m_NameConnect=cif->name;
		dlg.m_CompName=cif->comp_name;
		dlg.m_PortEdit=cif->port;
		dlg.m_BaseName=cif->base_name;
		dlg.m_DefUserName=cif->def_user_name;
		dlg.m_Proxy=cif->proxy;
		dlg.m_Protocol=cif->protocol;
		CArray<CString,CString> m_missed_names;
		//    
		for(int i = 0;i<m_data->m_list_connection.GetSize();i++){
			if(i!=curr_item)
				m_missed_names.Add(m_data->m_list_connection.GetAt(i)->name);
		}
		dlg.m_missed_names=&m_missed_names;
		if(dlg.DoModal()==IDOK)
		{
			ActualizeList();
			CConnectInfo *cif=m_data->m_list_connection.GetAt(curr_item);
			cif->name		=dlg.m_NameConnect;
			cif->comp_name	=dlg.m_CompName;
			cif->port		=dlg.m_PortEdit;
			cif->base_name	=dlg.m_BaseName;
			cif->def_user_name=dlg.m_DefUserName;
			cif->proxy=dlg.m_Proxy;
			cif->protocol=dlg.m_Protocol;
			m_last_selected = num_curr;
			RedrawList();
			return;
		};
	}
	else
	{
		MessageBox( APL_T(" !"), APL_T(""),MB_ICONERROR);
	}
}

void CDlgTuneListConnections::RedrawList()
{
	if(m_data== 0)
		return;
	m_ListConnections.DeleteAllItems();
	CString str;
	CConnectInfo *cif = 0;
	for(int i = 0;i<m_data->m_list_connection.GetSize();i++)
	{
		cif=m_data->m_list_connection.GetAt(i);
		m_ListConnections.InsertItem(i,cif->name);
		m_ListConnections.SetItemText(i,1,cif->comp_name);
		str.Format(_T("%i"),cif->port);
		m_ListConnections.SetItemText(i,2,str);
		m_ListConnections.SetItemText(i,3,cif->base_name);
		m_ListConnections.SetItemText(i,4,cif->def_user_name);
		if(cif->protocol== 0){str = _T("");}else{str=_T("Http");}
		m_ListConnections.SetItemText(i,5,str);
		if(cif->protocol==1)
		{
			if(cif->proxy==_T("IE") || cif->proxy== _T(""))
			{
				str = PROXY_TEXT__USE_IE;
			}
			else if(cif->proxy==_T("DIRECT"))
			{
				str = PROXY_TEXT__USE_DIRECT;
			}
			else
			{
				str = cif->proxy;
			}
		}
		m_ListConnections.SetItemText(i,6,str);

		m_ListConnections.SetItemData(i,(DWORD)i);

	}
	if(-1 != m_last_selected)
	{
		m_ListConnections.EnsureVisible( m_last_selected, TRUE);
		m_ListConnections.SetItemState(m_last_selected, LVIS_SELECTED, LVIS_SELECTED);
		m_ListConnections.SetFocus();
	}
	UpdateData(FALSE);
	//m_ListConnections.ReSort(); -        -    ,    
	CheckButton();
}

void CDlgTuneListConnections::OnDblclkListConnections(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	OnEdit();	
	*pResult = 0;
}

void CDlgTuneListConnections::OnUp() 
{
	// TODO: Add your control notification handler code here
	if(m_data== 0)
		return;
	m_last_selected = m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	int num_curr = m_last_selected;
	if( num_curr!= -1)
	{
		ActualizeList();
		//   
		int curr_item=m_ListConnections.GetItemData(num_curr);
		if(curr_item== 0)
			return;
		CConnectInfo *cif1 = 0,*cif2 = 0;
		int num = 0;
		m_data->m_list_connection.AutoKillReference = false;
		cif1=m_data->m_list_connection.GetAt(curr_item);
		cif2=m_data->m_list_connection.GetAt(curr_item-1);
		num=cif1->id;cif1->id=cif2->id;cif2->id=num;
		m_data->m_list_connection.SetAt(curr_item,cif2);
		m_data->m_list_connection.SetAt(curr_item-1,cif1);
		m_data->m_list_connection.AutoKillReference = true;
		m_last_selected = curr_item-1;
		RedrawList();
	}
	else
	{
		MessageBox( APL_T(" !"), APL_T(""),MB_ICONERROR);
	}	
}

void CDlgTuneListConnections::OnDown() 
{
	// TODO: Add your control notification handler code here
	if(m_data== 0)
		return;
	int num_curr= m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr!= -1)
	{
		ActualizeList();
		//   
		int curr_item=m_ListConnections.GetItemData(num_curr);
		if(curr_item>=m_data->m_list_connection.Size-1)
			return;
		CConnectInfo *cif1 = 0,*cif2 = 0;
		int num = 0;
		m_data->m_list_connection.AutoKillReference = false;
		cif1=m_data->m_list_connection.GetAt(curr_item);
		cif2=m_data->m_list_connection.GetAt(curr_item+1);
		num=cif1->id;cif1->id=cif2->id;cif2->id=num;
		m_data->m_list_connection.SetAt(curr_item,cif2);
		m_data->m_list_connection.SetAt(curr_item+1,cif1);
		m_data->m_list_connection.AutoKillReference = true;
		m_last_selected = num_curr+1;
		RedrawList();
	}
	else
	{
		MessageBox( APL_T(" !"), APL_T(""),MB_ICONERROR);
	}	
	
}

// :    CaplTranslateDialog
/*BOOL CDlgTuneListConnections::OnToolTipShow( UINT id, NMHDR * pNMHDR, LRESULT * pResult )
{
	TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pNMHDR;
	UINT nID = pNMHDR->idFrom;

	if (pTTT->uFlags & TTF_IDISHWND){
		nID = ::GetDlgCtrlID((HWND)nID);
 		CString tooltip_text;
 		tooltip_text.LoadString(nID);
		tooltip_text = CaplTranslate::Translate(tooltip_text);
		_strncpy(pTTT->szText, tooltip_text.GetBuffer(), 79);
		pTTT->szText[79] = _T('\0');
// 		pTTT->lpszText = _tcsdup(tooltip_text);

		//pTTT->hinst = AfxGetResourceHandle();
		//pTTT->lpszText = MAKEINTRESOURCE(nID);

		return(true);
	}
	return false;
}*/



void CDlgTuneListConnections::OnNMClickListConnections(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;
	CheckButton();
}

void CDlgTuneListConnections::CheckButton()
{
	int num_selected = 0;
	int num_curr= m_ListConnections.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	while(num_curr!= -1)
	{
		num_selected++;
		num_curr= m_ListConnections.GetNextItem( num_curr , LVNI_ALL | LVNI_SELECTED );
	}
	BOOL state = TRUE;
	
	if(num_selected>1 || num_selected== 0)
		state = FALSE;

	if(m_bReadOnly) state=FALSE;

	m_BtnOk.EnableWindow(state);
	m_BtnEdit.EnableWindow(state);
	m_BtnUp.EnableWindow(state);
	m_BtnDown.EnableWindow(state);

	if(num_selected== 0 || m_bReadOnly)
		state = FALSE;
	else
		state = TRUE;

	m_BtnRemove.EnableWindow(state);

	m_ListConnections.SetFocus();

}



BOOL CDlgTuneListConnections::DestroyWindow()
{
	// TODO: Add your specialized code here and/or call the base class
	aplDeInstallFindInTable(&m_ListConnections);

	return CaplResizableDialog::DestroyWindow();
}

void CDlgTuneListConnections::OnBnClickedFind()
{
	aplShowFindInTable(&m_ListConnections);
}
