#if !defined(AFX_APLSOCKETTRANSPORT_H__0867BCA7_426B_401B_BB45_CB4DF4675759__INCLUDED_)
#define AFX_APLSOCKETTRANSPORT_H__0867BCA7_426B_401B_BB45_CB4DF4675759__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxsock.h>		// MFC socket extensions
#include <StepData.h>

#ifndef _WININET_
# ifndef _WINDOWS_
#  include <windows.h>
# endif
# ifndef INTERNET_DEFAULT_PORT
#  include <wininet.h>
# endif
#endif

#define POINTER_FORMAT  _T("0x%08X")
#define THREAD_FORMAT   _T("t0x%04X")
#define LOGSERV_THREAD_FORMAT _T("s%05i:") THREAD_FORMAT _T(" ")
#define LOGSERV_FORMAT _T("s%05i ")

//      
#ifdef __linux__
	#define aplMissedDirRazd _T('\\')
#else
	#define aplMissedDirRazd _T('/')
#endif

typedef void (__cdecl *_PostProcessing)(LPVOID);

#ifndef _UNICODE
	// #define OUTPUT_MY_MESS
#endif // #ifndef _UNICODE

#ifdef _DEBUG
	#ifdef OUTPUT_MY_MESS

		#undef OutputDebugStringWithSrs
		#undef EnterCriticalSectionODS
		#undef LeaveCriticalSectionODS
		#undef DeleteCriticalSectionODS

		#ifdef this
			#define OutputDebugStringWithSrs( MESSAGE, ...) {CString dmd;SYSTEMTIME SystemTime;GetLocalTime(&SystemTime); dmd.Format( _T(" %2i:%02i:%02i.%03i " ## MESSAGE ## " Thread: " THREAD_FORMAT ", this: " POINTER_FORMAT ", Src: %s  %s str %i\n"), SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond,SystemTime.wMilliseconds, ##__VA_ARGS__, GetCurrentThreadId(), this, _T(__FILE__), _T(__DATE__), __LINE__); OutputDebugString(dmd);}
		#else
			#define OutputDebugStringWithSrs( MESSAGE, ...) {CString dmd;SYSTEMTIME SystemTime;GetLocalTime(&SystemTime); dmd.Format( _T(" %2i:%02i:%02i.%03i ") ## MESSAGE ## _T(" Thread: ") THREAD_FORMAT _T(", Src: %s  %s str %i\n"), SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond,SystemTime.wMilliseconds, ##__VA_ARGS__, GetCurrentThreadId(), _T(__FILE__), _T(__DATE__), __LINE__); OutputDebugString(dmd);}
		#endif

		#define OutputDebugStringWithSrs2( MESSAGE, ... ) {CString dmd;SYSTEMTIME SystemTime;GetLocalTime(&SystemTime); dmd.Format( _T(" %2i:%02i:%02i.%03i ") ## MESSAGE ## _T(" Thread: ") THREAD_FORMAT _T(", this: ") POINTER_FORMAT _T(", Src: %s  %s str %i\n"), SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond,SystemTime.wMilliseconds, ##__VA_ARGS__, GetCurrentThreadId(), this, file, date, line); OutputDebugString(dmd);}

		#define EnterCriticalSectionODS( param ) EnterCriticalSection( param ); OutputDebugStringWithSrs(_T("EnterCriticalSection" # param ))
		#define LeaveCriticalSectionODS( param ) OutputDebugStringWithSrs(_T("LeaveCriticalSection" # param ) ); LeaveCriticalSection( param )
		#define DeleteCriticalSectionODS( param ) OutputDebugStringWithSrs(_T("DeleteCriticalSection" # param ) );  DeleteCriticalSection( param )

	#else //#ifdef OUTPUT_MY_MESS

		#define OutputDebugStringWithSrs( MESSAGE, ... ) 
		#define OutputDebugStringWithSrs2( MESSAGE, ... )

		#define EnterCriticalSectionODS( param ) EnterCriticalSection( param )
		#define LeaveCriticalSectionODS( param ) LeaveCriticalSection( param )
		#define DeleteCriticalSectionODS( param )  DeleteCriticalSection( param )

	#endif //#ifdef OUTPUT_MY_MESS
#else // #ifdef _DEBUG

	#define OutputDebugStringWithSrs( MESSAGE, ... ) 
	#define OutputDebugStringWithSrs2( MESSAGE, ... ) 

	#define EnterCriticalSectionODS( param ) EnterCriticalSection( param )
	#define LeaveCriticalSectionODS( param ) LeaveCriticalSection( param )
	#define DeleteCriticalSectionODS( param )  DeleteCriticalSection( param )

#endif // #ifdef _DEBUG


// aplSocketTransport.h : header file
//
#ifdef SOCKET_TRANSPORT_EXPORTS
#define SOCKET_TRANSPORT_API __declspec(dllexport)
#else
#define SOCKET_TRANSPORT_API __declspec(dllimport)
#endif

#ifndef APL_SOCKETTRANSPORT_NOAUTOLIB
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"aplSocketTransport_ud.lib")
#else
#pragma comment (lib,"aplSocketTransportD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"aplSocketTransport_u.lib")
#else
#pragma comment (lib,"aplSocketTransport.lib")
#endif
#endif
#endif

//      
#define ID_TIMER_BLOCK  1002
#define ID_TIMER_RENEW  1003
#define ID_TIMER_PROCESS_CLIENT_OVER_HTTP  1005

#define ID_TIMER_START_CLIENT_ID  1015

#define WWW_PORTION_SIZE 1024*1024

#define TIMEOUT_RECEIVE 15000
//#define TIMEOUT_WAIT_NODIALOG 600000
#define TIMEOUT_WAIT_NODIALOG 1000*60*60*24
#define TIMEOUT_BEFORE_WAITDIALOG 2000
#define TIMEOUT_LIFE_NOACTIVE_HTTP 15*60*1000

//   apl socket transport
enum ASC_ERROR_CODES{
	ASC_NO_ERROR				=0,
	ASC_ERROR_PROCESSED			=1,
	ASC_MISSED_PARAM			=2,	   
	ASC_TIMEOUT					=3,
	ASC_MISSED_RECEIVE_SIZE		=4,
	ASC_MISSED_SENT_SIZE		=5,
	ASC_BREAK_CALL				=6,
	ASC_ALREADY_CONNECTED		=7,
	ASC_TOO_MANY_CLIENTS_ON_SERVER	=8,
	ASC_ERROR_INIT_SERVER		=9,
	ASC_ERROR_IN_SOCKET			=10,
	ASC_ERROR_SOCKET_CLOSE		=11,
	ASC_ERROR_IN_CONNECT		=12,
	ASC_ERROR_MISSED_VERSION	=13,
	ASC_OPERATION_IN_PROGRESS	=14,
	ASC_ERROR_PROCESSED_ON_SERVER	=15,
	ASC_MISSED_RECEIVE_SIZE_ON_SERVER =16,
	ASC_HOST_INACCESSIBLE		=17,
	ASC_MISSED_SERVER			=18,
	ASC_ERROR_IN_WININET		=19,
	ASC_ERROR_IN_HTTP_REQ		=20,
	ASC_ERROR_SERVER_UNICODE	=21,
	ASC_UNKNOWN_PROTOCOL		=22,
	ASC_DNS_ERROR				=23,
	ASC_SERVER_STOPPED			=24
};

//          
#define SAD_MEMORY_EXEPTION 9999

#define ADD_PVAR_2_STR(pVar) \
	if( pVar !=0){ \
		str1.Format(_T(" ") _T(#pVar) _T(" %i;"), \
			*pVar); str+=str1;}

//       . !            OnTimer  Processed !!!
#define RETRANSLATE_CMEMORY_EXEPTION catch(CMemoryException* e){\
			TCHAR   szCause[255];e->GetErrorMessage(szCause,255);\
			throw(SaplErrorDescription(SAD_MEMORY_EXEPTION,_T(__FILE__),_T(__DATE__),__LINE__,szCause,SaplErrorDescriptionLevel_Server,__APL_FUNC__,m_class_info));}

#define APL_CATCH_ALL_EXEPTION( ext_code_prev , LOG_FUNCTION_NAME, ext_code_post ) \
	catch(CMemoryException* e){ \
		TCHAR   szCause[255];  szCause[0]=_T('\0'); e->GetErrorMessage(szCause,255);CString str,str1;str.Format(APL_T("CMemoryException!!! Srs %s  %s str %i "),_T(__FILE__),_T(__DATE__),__LINE__);str+=szCause; \
		aplGetDescriptionSystemError(GetLastError(),str1);str+=APL_T("\n  : ")+str1; \
		ext_code_prev \
		LOG_FUNCTION_NAME (str); \
		ext_code_post \
	}catch (CException* e){ \
		TCHAR   szCause[255]; szCause[0]=_T('\0'); e->GetErrorMessage(szCause,255);CString str,str1;str.Format(APL_T("CException!!! Srs %s  %s str %i "),_T(__FILE__),_T(__DATE__),__LINE__);str+=szCause; \
		aplGetDescriptionSystemError(GetLastError(),str1);str+=APL_T("\n  : ")+str1; \
		ext_code_prev \
		LOG_FUNCTION_NAME (str); \
		ext_code_post \
	}catch(...){ \
		CString str,str1;str.Format(APL_T(" Unknown Exception!!! Srs %s  %s str %i "),_T(__FILE__),_T(__DATE__),__LINE__); \
		aplGetDescriptionSystemError(GetLastError(),str1);str+=APL_T("\n  : ")+str1; \
		ext_code_prev \
		LOG_FUNCTION_NAME (str); \
		ext_code_post \
	}



//        .
//   ,     
#define MANAGE_ABSENT 0
//#define MANAGE_TIMEOUT 1
//        .    !
#define MANAGE_WAITDLG 2

//    
// !!!         !
enum aplTransportCommands{
	CMDGetServerStatus	=	0,	// K->S          .     CMDConnectionOKNew
	CMDConnectionOK		=	1,	// S->K   .       
	CMDGetVersionBuffer	=	3,	// ->S     
	CMDTooManyClients	=	5,	// S->K      
	CMDErrorServerProcessed	=10,	// S->K      
	CMDErrorReceiveData	=11,		// S->K    
	CMDErrorInitServer		=12,	// S->K   
	CMDErrorMissedSocketType		=13,		// S->K    (    )
	CMDErrorMissedData		=14,	// S->K   
	CMDDisconnect		=15,		// ->S  
	CMDBreakOperation		=20,		// ->S    ,       4 
	CMDSetProgress		=21,		// S->K   4      
	CMDDeadTime			=25,		// S->K   ;   4      ( )
	CMDRenewClientState		=26,		// S->K  ,   
	CMDBreakOk				=27,		// S->K  ,   
	CMDSetProgressText		=28,		// S->K   4    ,   
	CMDNeedReconnect		=40,		// S->K   ,              
	CMDNeedRelogin			=41,		// S->K (Qt)   ,       
	CMDConnectionOKNew		=	101,	// S->K    ( ).     ,   -    
	CMDCriticalError		=	102,	// S->K   (     ),    prossed .      APLAPIERR_...  StepData.h
};

//
//     . ,         
//
typedef enum {
	LL_undefine = -1, //   
	LL_error = 0, //   
	LL_warning = 1, // + 
	LL_info = 2, // +  
	LL_debug = 3, // +  
} aplLogLevel;

//    -        
#define LogLevelOnlyCriticalError	LL_error
#define LogLevelAllError			LL_warning
#define LogLevelFunctionInfo		LL_info
#define LogLevelAllMessage			LL_debug


//     
#define DEF_ERROR_LOG_FILE _T("errors.log")

//       ,     
//   VERSION_INFO      !  _T   !
// !!!         !
#define VERSION_INFO "Apl SocketTransport v1.06"
#define VERSION_INFO_U "Apl SocketTransport u1.06"
#define VERSION_NUMBER 106
// !!!         !
//   VERSION_PSS_OVER_HTTP: #define VERSION_NUMBER_HTTP 100
#define VERSION_PSS_OVER_HTTP 100

/////////////////////////////////////////////////////////////////////////////
//      
//     
#define GLOBAL_SERVER_ID_FORMAT _T("Global\\PSS_SERV_0x%04X_")
#define LOCAL_SERVER_ID_FORMAT _T("Local\\PSS_SERV_0x%04X_")

//     
#define EMERGENCY_LOG_MUTEX _T("ins_log_mutex")
#define EMERGENCY_LOG_MAIN_SERV_MUTEX _T("ins_log_main_serv_mutex")
#define EMERGENCY_LOG_SHARED_MEMORY_NAME _T("PssServ4Memory4InsLog")
//      
#define EMERGENCY_LOG_BUFFER_SIZE 4000000

//#define ERR_MESS_SERVER_A_CLIENT_U APL_T("  unicode        .    Unicode.")
#define ERR_MESS_SERVER_A_CLIENT_U_DEBUG APL_T(" unicode,  ansi.     .")

#define ERR_MESS_SERVER_U_CLIENT_A APL_T("   ansi-  unicode .  unicode     unicode .")
#define ERR_MESS_SERVER_U_CLIENT_A_DEBUG APL_T("   ansi-  unicode .     .")

///////////////////////////////////////////////////////////////////
//         http   rest 
// !!!         !
//
#define HTTP_NAME_REST_URI _T("rest")
#define HTTP_NAME_APPLICATION_BASE _T("PSS_CLIENT_OVER_HTTP")
#define HTTP_NAME_APPLICATION_VER _T(" 0.1")
#define HTTP_CLIENT_ID_HEADER _T("PSS_Client_Id")
#define HTTP_USER_AGENT _T("User-Agent")
#define HTTP_CONTENT_LENGTH _T("Content-length")
#define HTTP_TRANSFER_ENCODING _T("Transfer-Encoding")
#define HTTP_CLIENT_SESSION_KEY _T("X-Apl-SessionKey")
#define HTTP_SPEC_REQUEST_INDEX _T("SPEC_REQUEST_INDEX")
#define HTTP_SPEC_REQUEST_DATA_SIZE _T("SPEC_REQUEST_DATA_SIZE")
#define HTTP_SPEC_ORIGINAL_DATA_SIZE _T("SPEC_ORIGINAL_DATA_SIZE")
#define HTTP_SPEC_ANSWER_INDEX _T("SPEC_ANSWER_INDEX")
#define HTTP_SPEC_ANSWER_DATASIZE _T("SPEC_ANSWER_DATASIZE")
#define HTTP_SPEC_ANSWER_CRC_ORIGINAL _T("SPEC_ANSWER_CRC_ORIGINAL")
#define HTTP_SPEC_ANSWER_CRC_ENCODED _T("SPEC_ANSWER_CRC_ENCODED")

//       -
enum EClientType
{
	ECT_Unknown = -1,		// -   .
	ECT_Standart = 0,		// -    
	ECT_ClientOverHttp = 1,	// -   http
	ECT_Rest = 2,			// - rest ,       
	ECT_WwwMail = 3,			// -  www,      ,   .
};

inline CString EClientType2Str(EClientType type)
{
	CString ret = _T("Unknown");
	switch(type)
	{
	case ECT_Unknown: ret = _T("ECT_Unknown");break;
	case ECT_Standart: ret = _T("ECT_Standart");break;
	case ECT_ClientOverHttp: ret = _T("ECT_ClientOverHttp");break;
	case ECT_Rest: ret = _T("ECT_Rest");break;
	case ECT_WwwMail: ret = _T("ECT_WwwMail");break;
	}
	return ret;
}


//  URI  rest 
struct SOCKET_TRANSPORT_API SUriElement
{
	SUriElement(){m_base=_T("");m_source=_T("");}
	SUriElement(SUriElement* prev){Set(prev);}
	void Set(SUriElement* prev);
	void Clear();

	CString m_base;
	CString m_source;
	//	CStringArray m_vals;
	CaplStrStrMap m_params;
};

//   URI  rest 
struct SOCKET_TRANSPORT_API SUriData
{
	SUriData(){Clear();}
	void Clear(){m_http_ver = _T(""); m_type = _T(""); m_uri_path = _T(""); m_uri_full = _T(""); m_elements.Clear(); m_num_base_elements = -1;}

	int GetSize(){return m_elements.GetSize();}

	inline CString GetStringAt(int index) const
	{if(index<0) return CString(_T("")); if(index>=m_elements.Size) return CString(_T(""));return m_elements.Data[index]->m_source;}

	inline CString GetBaseStringAt(int index) const
	{if(index<0) return CString(_T("")); if(index>=m_elements.Size) return CString(_T(""));return m_elements.Data[index]->m_base;}

	CString m_http_ver; //  http
	CString m_type; //  HTTP 

	//        ?   ""
	CaplTAggr<SUriElement*, SUriElement*, APLAGGR_LIST|APLAGGR_AUTOKILLREF> m_elements;

	//     '?'.   '?'  ,  -1
	int m_num_base_elements;
	//     (  '?')
	CString m_uri_path;
	//     c  (  '?'    )
	CString m_uri_full;

	//  (  '?')
	// CString m_uri_params; - .     '?'    m_num_base_elements
};

//
// :         http   rest 
///////////////////////////////////////////////////////////////////


class CaplTimeMeter;

//   
class SOCKET_TRANSPORT_API CaplLog  
{
public:
	CaplLog();
	virtual ~CaplLog();
	bool SetFileName(const CString &LogFileName, const CString &first_info = _T(""), bool is_single_log=true, void (__cdecl *prevGetAddDescription)(CString &descr)=0);
	bool AddFirstInfo(const CString &first_info);
	//    
	virtual bool LogMessage(LPCTSTR ErrDescr, bool is_warning=true, bool is_time=true, bool is_write=true, bool is_line=false,
					LPCTSTR funct=0, LPCTSTR class_info=0, LPCTSTR ExtDescr=0,
					LPCTSTR srs_file=0, LPCTSTR srs_date=0, DWORD srs_line=0);

	bool SetCVSHeader(LPCTSTR header);
	bool LogCSV(CStringArray &data, bool is_date_time=true, bool is_proc_thread=false);

	static CString GetLogLevelName(aplLogLevel level);	

	static void DeleteOldestFiles(LPCTSTR fileMask, size_t numSaved);

	//    "   " -   
	CString m_stored_info;
	//         -   ,  ,     ..
	CString m_const_info;
	
	//     
	aplLogLevel m_LogInfoLevel;
	
	bool m_IsPrintThread;
	bool m_isLogTick;
	//  true -          . 
	//  false -      
	bool m_isAlwaysLogStart;
	//        
	bool m_isChangeLogWithDate;

	//    -1 -        2      -    , 
	//       
	int m_TimeForChangeLog;

	DWORD m_MaxLogSize;
	DWORD m_NumCopies;
	
	//   
	CString m_LogFileName;

	void ClearFirst();

	static CString CorrectLinefeed(LPCTSTR message);

	//     
	CRITICAL_SECTION m_HandlesProtect;

	//   - 
	HANDLE m_hFileEmergencyLogMapping;
	PVOID m_EmergencyLogPregion;
	HANDLE m_Emergency_log_mutex;

	//    4   -       
	long *m_Emergency_log_last_active;
	//    
	BYTE *m_Emergency_log_data;
	DWORD m_Emergency_log_size;

	CString m_class_info;

	//   -  
	bool InitEmergencyLog(bool global);
	//   -  
	void ClearEmergencyHandles();
	//     
	bool LogMess2EmergencyLog(LPCTSTR Mess);
	//     
	void ParseEmergencyLog(PVOID EmergencyLogPregion, DWORD Emergency_log_size, CStringArray &records);
	//         
	void PrintMyEmergencyLog(CStringArray* records = 0, LPCTSTR description=0);


protected:
	
	bool m_need_change_log4time;
	bool m_is_csv;

	CRITICAL_SECTION m_logManager;
	HANDLE m_log_global_mutex;

	FILE *m_ErrLogFile;

	bool m_is_single_log;

	void (__cdecl *GetAddDescription)(CString &descr);
	bool Write2FileWithCheck(LPCTSTR line, bool force_change = false);
	
};

class CManageThread;
class CTransportWaitDlg;
class CServerStopDlg;

/////////////////////////////////////////////////////////////////////////////
//    
class SOCKET_TRANSPORT_API CaplSocketClient : public CSocket
{
friend CTransportWaitDlg;
// Attributes
protected:
	bool m_operation_in_progress;
	ASC_ERROR_CODES m_LastAscError;
	int m_LastWsaError;
	CServerStopDlg* m_server_stop_dlg;
	AFX_THREADPROC m_renew_function;
	LPVOID m_parameter_renew_function;
	CString m_class_info;

	bool (__cdecl *m_ApplicationLevelLogMessage)(LPCTSTR message);

	bool m_isCall;
public:
	bool m_NeedAutoDelete;
	bool m_ServerStopping;
	bool m_hide_mode;

	//        
	bool m_need_relogin;

	bool m_ServerAnsi;
#ifndef _UNICODE
//	bool m_DenyServerUnicode;
#endif

	DWORD m_LastReadyData;
	CWnd* m_parent_wnd;
	//    - CTransportSocketClient -       ,   ..
	LPVOID m_upper_container;

	DWORD m_thread_id;
	
// Operations
public:
	CaplSocketClient();
	CaplSocketClient(LPCTSTR ip, UINT port);
	virtual ~CaplSocketClient();

	//    is_process  false -     ..  
	//  WM_PAINT.    ILS.    NetStepData.
	static bool SetGlobalProcessWmPaint(bool is_process);

	bool GetHostName(CString &name);
	//  ip     -  ip  ,   4 .  0
	UINT32 GetCompIp();
	//   ,     
	CString GetCompName(){return m_server_name;};

	void SetBreak(bool state);
	bool IsBreak();
	bool IsBreakWaitData();

	void SetApplicationLevelLogMessage(bool (__cdecl *_ApplicationLevelLogMessageDlg)(LPCTSTR message));

// Overrides
public:
	
	//   
	CString	GetDescriptionLastError();
	ASC_ERROR_CODES GetLastAscError();
	int GetLastWsaError();	

	//  ' 
	bool SetTimeOut(DWORD timeout_waitdlg, DWORD timeout_my_receive=TIMEOUT_RECEIVE);
	
	//      ip   port
	//  prev_ping==true          
	//   (     )
	//  reserved        CaplSocketClientH::Connect;    
	virtual bool Connect(LPCTSTR ip, UINT port, bool prev_ping=true, LPCTSTR reserved=0, int num_prev_ping=3); //      CaplSocketClientH!!!
	virtual bool Connect(UINT ip, UINT port, bool prev_ping=true, LPCTSTR reserved=0, int num_prev_ping=3); //      CaplSocketClientH!!!
	virtual void Disconnect();

	virtual bool Call(void** data, DWORD &length, void* lpBuf2=0, DWORD nBufLen2=0, bool can_break=true, bool pause_wait_dlg=true, bool wait_answer=true, bool detach_buffer = false); //      CaplSocketClientH!!!
	void ClearInternalData();
	void SetErrProtocolMess(const CString &err_protocol_mess){m_err_protocol_mess=err_protocol_mess;}

	void SetRenewFunction(AFX_THREADPROC renew_function,LPVOID parameter_renew_function);
	//  
	bool IsConnected();
	bool IsHalted();
//	bool IsTimeOutDlg();
	bool IsWaitDlg();
	bool IsActiveWaitDlg();
	bool IsOperated();
	//     
	void SetManageMode(long manage_mode);
	long GetManageMode(){return InterlockedExchangeAdd(&m_manage_mode,0);}
	void SetWaitDlgText(LPCTSTR waitdlg_text);
	bool IsReadyData();

	void SetHalt(){InterlockedIncrement(&m_halt);}
	
	//   OnClose      (  )
	void (__cdecl *external_close_funct)(LPVOID param);
	//           
	void (__cdecl *external_reconnect_funct)(LPVOID param);
	
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplSocketClient)
public:
	virtual void OnReceive(int nErrorCode);
	virtual void OnSend(int nErrorCode);
	virtual void OnClose(int nErrorCode);
	//}}AFX_VIRTUAL

	// Generated message map functions
	//{{AFX_MSG(CaplSocketClient)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

// Implementation
protected:
	//    
	DWORD m_num_send;
	int MyReceive(void* data, DWORD length);
	int MySend(const void* lpBuf1, DWORD nBufLen1, const void* lpBuf2=0, DWORD nBufLen2=0, const void* lpBuf3=0, DWORD nBufLen3=0, bool is_throw=true);
	//    length     (letgth>0)   (==0)
	//  true     false   
	// !!!       ASC_ERROR_CODES
	bool FullRead(DWORD length);

	//      
	DWORD m_server_class;
	//     " ."
	DWORD m_waitdlg_time;
	//    ""
	CString m_waitdlg_text;
	//       (0- )
	DWORD m_timeout_call;
	//      (receive) (0- - 50 000 )
	DWORD m_timeout_my_receive;
	//     
	bool m_IsConnected;
	//     
	bool m_flag_break;
	//  /  .
	bool m_is_buffer_full;

	//
	bool ProcessedCommand(DWORD command);
	
	CString m_err_protocol_mess;
	
	//  ,      
	//      NetStepData ,         !
	BYTE* m_InternalData;
	DWORD m_size_InternalData;
	CRITICAL_SECTION m_IsBlockedInternalBuf;

	//    
	long m_manage_mode;

	// ,      
	CString m_server_name;
	UINT m_server_port;

	CTransportWaitDlg* m_wt_dlg;
	//  >0   .    
	long m_halt;

	CRITICAL_SECTION m_ManageOperate;
private:
	void InitVar();
};


/////////////////////////////////////////////////////////////////////////////
//      http
//     wininet.h
class SOCKET_TRANSPORT_API CHTTPReader
{
public:
	CHTTPReader();
	CHTTPReader(LPCTSTR lpszServerName, INTERNET_PORT port=0, bool bUseSSL=false, LPCTSTR proxy =0);
	~CHTTPReader();

	bool SetServer(LPCTSTR lpszServerName, INTERNET_PORT port=0, bool bUseSSL=false, LPCTSTR proxy =0);

	bool  OpenInternet     (LPCTSTR lpszAgent);
	void  CloseInternet    ();
	bool  OpenConnection   (LPCTSTR lpszServerName=NULL);
	void  CloseConnection  ();

	bool  Get              (LPCTSTR lpszAction, LPCTSTR lpszReferer=NULL);
	bool  Post             (LPCTSTR lpszAction, LPVOID lpszData, DWORD DataLength, LPCTSTR lpszReferer=NULL);
	void  CloseRequest     ();

	BYTE *GetData          (BYTE *lpszBuffer, DWORD dwSize, DWORD *lpdwBytesRead=NULL);
	BYTE *GetData          (DWORD *lpdwBytesRead=NULL);
	DWORD GetDataSize      ();
	void  SetDataBuffer    (DWORD dwBufferSize);

	void  SetDefaultHeader (LPCTSTR lpszDefaultHeader);
	DWORD GetError         () const { return m_dwLastError; }
	bool QueryAnswerHeaders();

	ASC_ERROR_CODES GetAscErrorCode(){return m_asc_code;};

	DWORD	  m_ClientId;

	CString m_hdr_server;
	DWORD m_hdr_version_num;
	DWORD m_dwStatus;
	CString m_StatusText;
	DWORD m_hdr_spec_answer_index;
	DWORD m_hdr_spec_answer_datasize;
	long m_hdr_spec_answer_crc_original;
	long m_hdr_spec_answer_crc_encoded;
	long m_hdr_spec_original_data_size;

	ASC_ERROR_CODES m_asc_code;

	CString m_hdr_all;

	//CaplLog m_log;

protected:
	bool CheckError (bool bTest);
	void StrDup     (LPTSTR& lpszDest, LPCTSTR lpszSource);
	bool SendRequest(LPCTSTR lpszVerb, LPCTSTR lpszAction, LPVOID lpszData=0, DWORD DataLength=0, LPCTSTR lpszReferer=0);

	HINTERNET m_hInternet;
	HINTERNET m_hConnection;
	HINTERNET m_hRequest;

	DWORD     m_dwLastError;
	bool      m_bUseSSL;
	CString   m_lpszServerName;
	INTERNET_PORT m_port;
	CString   m_lpszDefaultHeader;
	BYTE     *m_lpszDataBuffer;
	DWORD     m_dwBufferSize;

	CString m_ProxyName;
	CString m_ProxyLogin;
	CString m_ProxyPassword;

	bool m_first;

	long m_HTTP_SPEC_REQUEST_INDEX;

	CString m_class_info;

};

/////////////////////////////////////////////////////////////////////////////
//      http
//
class SOCKET_TRANSPORT_API CaplSocketClientH : public CaplSocketClient
{
public:
	CaplSocketClientH();
	~CaplSocketClientH();

	//      ip   port
	//  prev_ping==true          
	//   (     )
	bool Connect(LPCTSTR ip, UINT port, bool prev_ping=true, LPCTSTR proxy = 0, int num_prev_ping=3 );
	bool Connect(UINT ip, UINT port, bool prev_ping=true, LPCTSTR proxy = 0, int num_prev_ping=3 );
	void Disconnect();
	bool Call(void** data, DWORD &length, void* lpBuf2=0, DWORD nBufLen2=0, bool can_break=true, bool pause_wait_dlg=true, bool wait_answer=true, bool detach_buffer = false);


	CHTTPReader *m_http_reader;

};

//////////////////////////////////////////////////////////////
//             
//
class SOCKET_TRANSPORT_API CaplStrStrMapLo :protected CaplStrMap
{
public:
	struct SStrMapLoItem
	{
		SStrMapLoItem(LPCTSTR _key_orig, LPCTSTR _val){key_orig=_key_orig; val=_val;}
		CString key_orig;
		CString val;
	};
	~CaplStrStrMapLo(){Clear();}
	void Clear();

	int Add(LPCTSTR str, LPCTSTR val);
	int Add(LPCTSTR _str, int ival);
	int FindByIn(LPCTSTR str) const;	/**<    */
	CString Get(LPCTSTR str) const;		/**<    */
	CString Get(int indx) const;		/**<    */
	CString GetKey(int indx) const;		/**<    */

	CString PrintList(bool html_table=false);

protected:
	int GetSize() const { return items.GetSize();} /**<  */
};


/////////////////////////////////////////////////////////////////////////////

//   
class CPssServWnd;
class CSocketThread;
/////////////////////////////////////////////////////////////////////////////
// CaplSocketServ command target

class SOCKET_TRANSPORT_API CaplSocketServ : public CSocket
{
	friend CSocketThread;
	friend CPssServWnd;
// Attributes
protected:
	CString m_client_ip_s;
	DWORD m_client_ip;
	UINT m_client_port;
	CString m_server_ip_str;
	UINT m_server_ip;
	UINT m_server_port;
	CString m_class_info;
	// -         
	//    -     .
	CString m_funct_info;
	//     
	COleDateTime m_start_time;  //?

	//	true      pss- ,    http- 
	// bool m_client_over_http; -    m_client_type

// Operations
public:
	CaplSocketServ();
	virtual ~CaplSocketServ();

	//        
	virtual void MakeClassInfo(LPCTSTR additional = _T(""));
	
	DWORD GetServerIp(){return m_server_ip;}
	UINT GetServerPort();
	void GetServerIpPortString(CString &str);
	DWORD GetClientIp();
	void GetClientIpPortString(CString &str);
	UINT GetClientPort(){return m_client_port;}

// Overrides
public:
	int m_LastWsaError;

	SOCKET m_temp_socket;
	// 
	bool m_detach_after_send;
	//bool m_close_after_send;
	bool StartListen(UINT port, int &error, bool show_err_mess=false, bool mode_www=false, int count_hide_attempt = 0, bool mode_mail=false);
	bool SendData(BYTE *data1, DWORD length1, BYTE *data2, DWORD length2);
	bool SendCommand(int command, INT32 ext_data=-1, INT32 ext_data_2=-1, LPCTSTR mess=0);

	//    ,    
	void SetMaxClient(DWORD size);
	//       
	bool SendPercentage(UINT32 percentage);
	bool SendPercentageText(LPCTSTR mess);
		
	//        . 
	//      
//	inline void LogItemC(SaplLogItem &log_item);
//	inline void LogItemA(SaplLogItem &log_item);

	inline bool IsLogAll();
	
	//    -      ,    obj
	virtual bool BreakOperation(CaplSocketServ* obj){return false;};
	//    -        
	virtual bool Processed(CaplDataBuf &dbuf_in, CaplDataBuf &dbuf_head, CaplDataBuf &dbuf_out){return true;};
	//    -          ,    
	virtual bool PostProcessed(){return true;};
	//    -           
	//	,   http   rest.
	virtual bool ProcessExternalHTTPClient(){return true;};
	//    -       (    ) 
	//	 ,   http   rest.
	virtual bool DispatchHTTPClient(){return true;};
	//    -       
	virtual CaplSocketServ* NewDataSocket(){return new CaplSocketServ();};
	//    -       
	// .    false  ,  
	virtual bool Init(){return true;};
	//      
	bool PrevInit();
	//    -       
	//  ,     
	virtual void Exit(){return;};
	//     HTTP  (      
	//	,   http   rest).
	//      HTML          
	virtual bool ProcessedHTTP(){m_terminate_after=1; return true;};

	//    MAIL    . 
	virtual bool ProcessedMail(){m_terminate_after=1; return true;};

	//    http:  URI; http ;      REST.
	//        http
	//    http ( get   post) -     0
	bool ParseHttpHeaders();
	void CompletionUriData(SUriData &m_uri_data);

	//   ,    .     0
	CaplSocketServ* m_pool;
	//   
	virtual bool ProcessBreakThread(int param);
	//    ,    
	DWORD GetNumAllConnected();
	//     HTTP
	DWORD GetNumDataConnected();

	
	//    (),       
	//    .  ==0   
	//    -  ,   
	//    ,      ,    
	void SetStopTime(long stop_time);
	long GetStopTime();
	
	//   
	CAplAtomicLong m_stop_time;

	bool IsReadyData();
	DWORD m_LastReadyData;

	bool m_connect_status;
	//    
	CPssServWnd* m_wnd;
	//   
	CSocketThread* m_thread;

	//  ,         
	//   -    
	UINT32 m_serv_seans_id;

	//    ,    ,     (, HTTP, )     
	void ProcessedReceive(int nErrorCode);

	//  http         (  )
	bool ReadNextHttpFromSocket();

	//      "  ".     !
	void RenewClientState();

	BOOL Create(UINT nSocketPort, bool show_err_mess, int count_hide_attempt = 0);

	//   ,  ,    ..
	BOOL DisconnectAll();

	//        m_OperateList!
	//            -   !
	BOOL KillThread(int pos, bool forsed=false, LPCTSTR text=0);

	//     -  dll-   WWW 
	bool IsModeWWW();
	//     -  dll-    
	bool IsModeMail();

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplSocketServ)
//public:
protected:
	virtual void OnClose(int nErrorCode);
	virtual void OnAccept(int nErrorCode);
	virtual void OnReceive(int nErrorCode);

	//      
	long m_supress_command;
	//      
	bool m_wait_reconnect;

	bool TestErrOnHalt();
	//}}AFX_VIRTUAL

	// Generated message map functions
	//{{AFX_MSG(CaplSocketServ)
	//}}AFX_MSG

// Implementation
public:
	
	//        
	CaplSocketServ* GetSocketFromList(DWORD pos);

	virtual CaplSocketServ* GetSocketFromListByParam(long param){return 0;};

	DWORD m_thread_id;

	//    -     (in)/(out)
	int PoolAddSocketThread(CSocketThread* thread);
	bool PoolRemoveSocketThread(CSocketThread* thread);
	inline void PoolOperateListEnter();
	inline void PoolOperateListLeave();

	//    ,    
	bool AttachTempSocket();

	//  ,       elapse        NetStepData
	UINT SetUserTimer(DWORD elapse, AFX_THREADPROC lpfnTimer);
	//  
	bool KillUserTimer(UINT timer_id);
	//    (in  , out    
	CaplMap m_clients_timers;
	//   
	bool ProcessUserTimer(UINT timer_id);

	bool GetCookie(LPCTSTR, CString &value);

protected:
	//    -    (in)/(out)
	CArray<CSocketThread*,CSocketThread*> m_list;

	//          
	CaplTimeMeter m_LastPercentageTimer;
	//   ,    .     
	DWORD m_num_data_connects;

	// true -  http-  .       ,   
	//bool m_web_query;

	//    ID_TIMER_BLOCK
	DWORD m_ClearedTimeInterval;

	//    -    .      - 0
	DWORD m_max_client;
	// Event.    () ,       (  
	//      ,    ..).      -    ,   
	HANDLE m_free;

	// ,   . ,   ( REST     -       )
	CaplDataBuf m_session_data;
	//  ,      
	int m_size_waited;
	//  true   .    
	//long m_halt;

	//    OnClose.             
	CAplAtomicLong m_onclose_enter;

	//     .  1,        
	CAplAtomicLong m_terminate_after;

	/////////////////////////////////////////
	//      http-
	//   m_URI -  m_uri_data.m_uri_path
	//
	//  http -
	CaplStrStrMapLo m_http_headers_in;
	// 
	CaplStrStrMapLo m_cookies;
	//  URI    
	SUriData m_uri_data;
	//      
	DWORD m_indx_start_data;
	//    http
	EClientType m_client_type;
	//       (  REST  PSS  HTTP)
	DWORD m_ClientId;
	CString m_session_key;

	//////////////////////////////////////////
	//    http 
	// -  
	int m_http_code; //--
	// -    html
	CString m_csHtmlAnswer; //--
	// -    .    .   , 
	//	    m_csHtmlAnswer
	CaplDataBuf m_dbufFileBody; //--
	// - http- 
	CaplStrStrMapLo m_smHttpHeadersOut; //--
#ifdef _DEBUG
	//        
	//CString m_csXDebugHeader;
#endif

	//          - 
	virtual void CheckCompliteHttpHeaders();

	//     http-       http
	void ClearAnswerData(int http_code=0);

public:
	inline void AddHttpHeader(LPCTSTR header, LPCTSTR val){m_smHttpHeadersOut.Add(header, val);}
	inline void AddHttpHeader(LPCTSTR header, int val){m_smHttpHeadersOut.Add(header, val);}
	void AddHttpHeaderExpires(int sec);

	int SetHttpCode(int http_code);

	//          m_cdbAnswer
	//        ,  m_cdbAnswer 
	ULONGLONG PrepareHttpAnswer(ULONGLONG ullExtSize=-1);

	CString MakeHttpCodeWithHeaders();

protected:

	//   .         0,
	//	         
	CaplDataBuf m_cdbAnswer;
	//
	//      http-
	/////////////////////////////////////////


	//  ,   
	CRITICAL_SECTION m_MultithreadVarProtect;

	CRITICAL_SECTION m_OperateList;

	//    ,   ..
	//       m_PostProcessingObj,      
	//       m_PostProcessingObj.
	_PostProcessing m_PostProcessing;
	LPVOID m_PostProcessingObj;
};




class SOCKET_TRANSPORT_API CSocketThread :public CWinThread{
public:
	CSocketThread(CaplSocketServ *pool,CaplSocketServ* pSocket);
	virtual ~CSocketThread();
	BOOL InitInstance();
	int ExitInstance();

	//       ,       terminate-
	CaplTimeMeter m_tick_kill_timer;
	long m_state_kill;

// 	HANDLE m_event;
	CaplSocketServ* m_pSocket;
	
	CString m_class_info;

protected:
	CaplSocketServ *m_pool;

};

class SOCKET_TRANSPORT_API CPSSServiceDescriptor 
{
public:
	CPSSServiceDescriptor();
	CPSSServiceDescriptor(const CString &_service_name, int _process_id, int _service_port);
	void Set(CPSSServiceDescriptor &source);
	CString m_service_name;
	int m_process_id;
	int m_service_port;
};



class SOCKET_TRANSPORT_API CPSSServicesList : public CObject
{
public:
	CPSSServicesList(const CString &_service_name, int _service_port);
	virtual ~CPSSServicesList();
	
	void GetHtmlTable(const CString &curr_server_name, CString &html_table);
	
protected:
	CString m_class_info;

	void Clear();
	void Reload(bool add=true);

	CPSSServiceDescriptor m_i_m;

	HANDLE m_hFileServicesList;
	PVOID m_GlobalServicesListData;

	long *m_pListSize;
	PVOID m_pRegionData;
	HANDLE m_MutexServicesListProcessed;

#ifdef _UNICODE

	HANDLE m_hFileServicesListU;
	PVOID m_GlobalServicesListDataU;

	long *m_pListSizeU;
	PVOID m_pRegionDataU;

	HANDLE m_MutexServicesListProcessedU;
#endif

	CaplTAggr<CPSSServiceDescriptor*,CPSSServiceDescriptor*,APLAGGR_AUTOKILLREF> m_local_list;
	CRITICAL_SECTION m_local_list_protect;
	CaplTimeMeter m_last_local_list_reload_timer;
};



AFX_EXT_API void GetDescriptionTransportError(ASC_ERROR_CODES error, int LastWsaError, CString &buffer);
AFX_EXT_API void GetDescription_FILE_Error(int &error_id, CString &buffer);
AFX_EXT_API void GetDescriptionSystemError(int error_id, CString &buf);
//AFX_EXT_API TCHAR *GetDescriptionSocketError(int error);
AFX_EXT_API void GetDescriptionWininetError(int error, CString &buffer);
AFX_EXT_API void GetDescriptionHTTPAnswer(int answer, CString &buffer);
AFX_EXT_API CString GetDescriptionTransportCommand(int command);

//  IPv4 ,  ,  
//  is_win == true  IP      (windows, sin_addr.s_addr)
//  is_win == false  IP      (Qt)
AFX_EXT_API CString Ip2String(DWORD ip_num, bool is_win = true);
//  IPv4 ,  ,  
//  is_win == true  IP      (windows, sin_addr.s_addr)
//  is_win == false  IP      (Qt)
AFX_EXT_API inline void Ip2String(DWORD ip_num, CString &ip_str, bool is_win = true){ip_str = Ip2String(ip_num, is_win);}

//  IP-     ,   .
//   ,    IP    
//	     DNS.     DNS    .
//   IP      (windows, sin_addr.s_addr)
AFX_EXT_API CString Ip2Name(DWORD ip_num);

AFX_EXT_API bool ParseListIpDiapazon(CString &pattern, CaplMap &out_list);
AFX_EXT_API bool MakeListIpDiapazon(CaplMap &in_list, CString &pattern);

// ,      id 
AFX_EXT_API bool PSSCheckProcessDead(int process_id);

AFX_EXT_API long StartTransportWaitDlg(LPCTSTR text=0);
AFX_EXT_API bool IsBreakTransportWaitDlg(long dialog);
AFX_EXT_API bool SetTransportWaitDlgText(long thread, LPCTSTR text);
AFX_EXT_API void EndTransportWaitDlg(long dialog, bool foreground_main_wnd=true);

AFX_EXT_API bool LogDebugMessageReal(LPCTSTR ErrDescr, LPCTSTR funct, LPCTSTR source, LPCTSTR file, LPCTSTR date, int line, bool carry=true);
AFX_EXT_API bool LogDebugMessageReal(CString& ErrDescr, LPCTSTR funct, LPCTSTR source, LPCTSTR file, LPCTSTR date, int line, bool carry=true);
//AFX_EXT_API void SetModuleLogFileName(const CString &file_mane);
//        
AFX_EXT_API void SetModuleLog(CaplLog *ModuleLog);

AFX_EXT_API BOOL TransportPing(LPCTSTR strHost);

AFX_EXT_API bool aplIsUserAdmin();
AFX_EXT_API void aplGetOSUser(CString &user, CString &domain);

AFX_EXT_API bool CreateSecurityAttributes (ACCESS_MASK amAccessRights,PSECURITY_ATTRIBUTES* ppSecurityAttributes);

AFX_EXT_API bool DecodeFromBase64( const char* encoded_string, DWORD size_string, CaplDataBuf &dbuf_out);
AFX_EXT_API CString EncodeToBase64( CaplDataBuf &dbuf_in);
AFX_EXT_API CString EncodeToBase64( const BYTE* BYTEs_to_encode, unsigned int in_len);

//   UTF8  1251  
AFX_EXT_API CString ConvertFromUTF8toWIN1251(CString sSource);
AFX_EXT_API CString ConvertFromWIN1251toUTF8(CString sSource);

//     (UTF8  ANSI)      
//        SaplErrorDescription
AFX_EXT_API CString DecodeURLString(CStringA &sSource);

AFX_EXT_API void SetFunctionGlobalExit(void (__cdecl *prevSetGlobalExit)());
AFX_EXT_API void SetApplicationGlobalExit(bool _is_set_global_exit);

enum enumEnvProtect
{
	EnvProtectEnter = 1,
	EnvProtectLeave = 2
};

AFX_EXT_API void SetFunctionGlobalEnvProtect(void (__cdecl *prevOracleEnvProtect)(enumEnvProtect param));
AFX_EXT_API void SetFunctionProcessAplExeption(void (__cdecl *prevProcessAplExeption)(SaplErrorDescription &error));
AFX_EXT_API long GetSocketInitErrors();

AFX_EXT_API long GetNumErrdataSocket();

//        
AFX_EXT_API DWORD aplReadServUILang(bool only_read = false);
AFX_EXT_API bool aplSaveServUILang(DWORD curUILang);

//     .  ,      aplCryptQt
AFX_EXT_API bool internalCryptGetHash(LPCTSTR lpMethod, LPCTSTR str_in, CString &csHash, CString &errMess);

//        
AFX_EXT_API bool internalHashGetMethod(LPCTSTR lpHash, CString &csMethod);

/**
	@brief aplCheckPassword     
	@param pwdClient  ,   . 
	@param pwdDb  ,   .
	@return true     false   .
*/
AFX_EXT_API bool aplCheckPassword(LPCTSTR pwdClient, LPCTSTR pwdDb);

/** @brief aplSelectFolder    .
	@param hWnd  
	@param start_dir ,      
	@param title    .
	@return        ,   .
	*/
AFX_EXT_API CString aplSelectFolder(HWND hWnd, LPCTSTR start_dir, LPCTSTR title);

/** @brief aplSelectComputer    .
	@param hWnd  
	@param title    .
	@return       ,   .
	*/
AFX_EXT_API CString aplSelectComputer(HWND hWnd, LPCTSTR title);

//////////////////////////////////////////////////
//     http-


//        
inline void ParseFilename(CString csFilePath, CString &csName, CString &csExt)
{
	csExt.Empty();
	csName.Empty();
	int pos;

	pos=csFilePath.ReverseFind('.');
	if(pos!=-1)
		csExt=csFilePath.Mid(pos+1);

	pos=csFilePath.ReverseFind(aplDirRazd);
	if(pos!=-1)
		csName=csFilePath.Mid(pos+1);

}

//    
inline CString GetContentType(CString csExt, bool &is_text)
{
	CString csContentType=_T("");
	is_text = false;

	if(csExt==_T("css")){csContentType=_T("text/css;");}
	else if(csExt==_T("gif")){csContentType=_T("image/gif");}
	else if(csExt==_T("gz")){csContentType=_T("application/gzip");}
	else if(csExt==_T("htm") || csExt==_T("html")){csContentType=_T("text/html;");is_text=true;}
//	else if(csExt==_T("htm") || csExt==_T("html")){csContentType=_T("text/html; charset=UTF-8;");is_text=true;}
	else if(csExt==_T("mpeg") || csExt==_T("mpg") || csExt==_T("mpe")){csContentType=_T("video/mpeg");}
	else if(csExt==_T("jpg") || csExt==_T("jpeg") || csExt==_T("jpe")){csContentType=_T("image/jpeg");}
	else if(csExt==_T("js")){csContentType=_T("application/javascript;");}
	else if(csExt==_T("pdf")){csContentType = _T("application/pdf");}
	else if(csExt==_T("png")){csContentType=_T("image/png");}
	else if(csExt==_T("rtx") || csExt==_T("rtf")){csContentType=_T("text/richtext");}
	else if(csExt==_T("soap")){csContentType=_T("application/soap+xml;");}
	else if(csExt==_T("sgml")){csContentType=_T("text/sgml;");}
	else if(csExt==_T("tiff") || csExt==_T("tif")){csContentType=_T("image/tiff");}
	else if(csExt==_T("txt")){csContentType=_T("text/plain;");is_text=true;}
	else if(csExt==_T("wav")){csContentType=_T("application/x-wav");}
	else if(csExt==_T("xhtml")){csContentType=_T("application/xhtml+xml");}
	else if(csExt==_T("xml")){csContentType=_T("text/xml");}
	else if(csExt==_T("zip")){csContentType=_T("application/zip");}
	else if(csExt==_T("")){
		/*if(is_strong)
		{
			//     
			//APL_THROW_EX(APL_NET_CLI_MISSED_DATA,"     : "+ext);
			csContentType=_T("");
		}
		else*/
		{
			csContentType=_T("application/force-download");
		}
	}
	else
	{
		csContentType=_T("application/force-download");
	}
	return csContentType;
}

inline CString ReplaseServiceSymbols(CString &str)
{
	str.Replace(_T("\n"), _T(""));
	str.Replace(_T("\r"), _T(""));
	str.Replace(_T("\t"), _T(""));
	return str;
}

//     -  win-1251   
AFX_EXT_API CString DeleteNon1251Symbols(LPCSTR str_in);

// ,   IP   
// bool is_win -  true,       ,  sin_addr.s_addr
//	 false,   ,   Qt
AFX_EXT_API inline bool IsIpLocal(UINT32 ip_num, bool is_win)
{
	if(is_win)
		return (ip_num&0x0FF) == 0x7f; //  0x7f   

	return ((ip_num>>24)&0x0FF) == 0x7f;//  0x7f   ,   
}


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_APLSOCKETTRANSPORT_H__0867BCA7_426B_401B_BB45_CB4DF4675759__INCLUDED_)
