// HtmlGen.cpp: implementation of the CHtmlGen class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HtmlGen.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHtmlGen::CHtmlGen(BYTE items, BYTE rows, CString dot_name, CString file_name, char sep)
{
	SetDotName(dot_name);
	m_file_name = file_name;
	m_sep = sep;
	m_items = items;
	m_rows = rows;
	add_row = 0;
}

CHtmlGen::~CHtmlGen()
{
}

bool CHtmlGen::SetFileName(CString file_name)
{
	m_file_name = file_name;
	return true;
}

void CHtmlGen::SetDotName(CString file_name)
{
	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		CString path;
		path=app->m_pszHelpFilePath;
		m_dot_name = path.Left(path.ReverseFind(_T('\\'))+1);
	}
	m_dot_name += file_name;

	//m_dot_name = file_name;
}

int CHtmlGen::CreateTitle(CString params)
{
	if(!m_of.Open(m_dot_name,CFile::modeRead)) 
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -1;//  
	}
	if(!m_rf.Open(m_file_name,CFile::modeCreate | CFile::modeWrite))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("   ")+m_file_name, MB_OK|MB_ICONSTOP);
#endif
		return -2; //   
	}

	CString str;
	int sec=0;
	int i = 0; 
	while(m_of.ReadString(str) && i<m_items)
	{
		if(str.Find(_T("sec=0"),0)>-1)
		{
			str.Replace(_T("##"),GetNextString(params));
			i++;
		}
		if(str.Find(_T("sec=1"),0)>-1) sec = 1;
		if(str.Find(_T("##"),0)>-1 && sec == 1)
		{
			str.Replace(_T("##"),GetNextString(params));
			i++;
		}
		m_rf.WriteString(str+_T("\n"));
	}
	m_rf.WriteString(str+_T("\n"));
	int ok=1;
	while(sec!=2 && ok!=0)
	{
		m_pos = (DWORD)m_of.GetPosition();
		cur_pos = m_pos;
		ok = m_of.ReadString(str);
		if(str.Find(_T("sec=2"),0)>-1)
			sec=2;
		else
			m_rf.WriteString(str);
	}
	m_of.Close();
	m_rf.Close();
	return 0;
}

CString CHtmlGen::GetNextString(CString &str)
{
	CString rez;
	if(str.Find(m_sep,0)>=0)
	{
		rez = str.Left(str.Find(m_sep,0));
		str = str.Right(str.GetLength()-str.Find(m_sep,0)-1);
	}
	else
	{
		rez = str;
		str = _T("");
	}
	return rez;
}

int CHtmlGen::AddRow(CString row, COLORREF color)
{
	if(!m_of.Open(m_dot_name,CFile::modeRead))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -1;//  
	}
	if(!m_rf.Open(m_file_name,CFile::modeWrite))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -2; //   
	}

	CString str;
	int sec=0;
	int i = 0;
	m_of.Seek(m_pos,CFile::begin);
	m_rf.Seek(0,CFile::end);
	while(m_of.ReadString(str) && i<m_rows)
	{
		if(str.Find(_T("#000000"),0)>-1)
		{
			CString col=_T(""), tmp;
			int r,g,b;
			r = GetRValue(color);
			g = GetGValue(color);
			b = GetBValue(color);
			col.Format(_T("%X"),r);
			while(col.GetLength()<2)
				col+=_T("0");
			tmp.Format(_T("%X"),g);
			col+=tmp;
			while(col.GetLength()<4)
				col+=_T("0");
			tmp.Format(_T("%X"),b);
			col+=tmp;
			while(col.GetLength()<6)
				col+=_T("0");
			str.Replace(_T("000000"),col);
		}
		if(str.Find(_T("##"),0)>-1)
		{
			CString t = GetNextString(row);
			if(t==_T("") || t==_T(" ")) t=_T("&nbsp");
			str.Replace(_T("##"),t);
			i++;
		}
		m_rf.WriteString(str+_T("\n"));
	}
	if(str.Find(_T("</tr>"),0)>-1)
	{
		m_rf.WriteString(str+_T("\n"));
		m_of.Seek(m_pos,CFile::begin);
	}

	m_of.Close();
	m_rf.Close();
	return 0;	
}

int CHtmlGen::CreatePS(CString post_script)
{
	if(!m_of.Open(m_dot_name,CFile::modeRead))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -1;//  
	}
	if(!m_rf.Open(m_file_name,CFile::modeWrite))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -2; //   
	}

	CString str;
	int sec=0;
	int i = 0;
	m_of.Seek(m_pos,CFile::begin);
	m_rf.Seek(0,CFile::end);
	while(m_of.ReadString(str))
	{
		if(str.Find(_T("sec=3"),0)>-1)
			sec = 3;
		if(sec==3 && str.Find(_T("##"),0)>-1)
			str.Replace(_T("##"),GetNextString(post_script));
		if(sec==3)
			m_rf.WriteString(str+_T("\n"));
	}
	m_of.Close();
	m_rf.Close();
	return 0;	
}
int CHtmlGen::ReadHtmlToString(CString *html,CStdioFile &f)
{
	CString str;
	while(f.ReadString(str))
		*html+=str+_T("\n");
	return 0;
}

CString CHtmlGen::GetBody(CString *html)
{
	html->MakeLower();
	int body_begin = html->Find(_T("<body>"),0);
	int body_end = html->Find(_T("</body>"),0);
	CString rez = html->Mid(body_begin+7,body_end-body_begin);
	return rez;
}
int CHtmlGen::WriteStrToFile(LPCTSTR html,CString fname,BYTE flag)
{
	if((flag & HG_CREATE_FILE) && (flag & HG_ADD_TO_FILE)) return -2;//  
	CStdioFile f;
	if(flag & HG_CREATE_FILE) 
	{
		if(!f.Open(fname,CFile::modeCreate | CFile::modeWrite)) return -2; //   
	}
	else
	{
		if(!f.Open(fname,CFile::modeWrite)) return -2; //   
	}
	if(flag & HG_ADD_TO_FILE) f.SeekToEnd();
	f.WriteString(html);
	f.Close();
	return 0;
}

bool CHtmlGen::GenerateByListCtrl(CListCtrl *ListCtrl, CString m_file_name, BYTE flag, CUIntArray *h_cols)
{
	if(ListCtrl==NULL) return false;
	if((flag & HG_CREATE_FILE) && (flag & HG_ADD_TO_FILE)) return false;
	CString str=_T("");
	CHeaderCtrl *head = ListCtrl->GetHeaderCtrl();
	int cols = head->GetItemCount();
	str=_T("<table border=\"1\"  style=\"font-size: 9pt;\" cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"0\" cellpadding=\"3\" style='border-collapse:collapse' color=0 bordercolorlight=\"#000000\" bordercolordark=\"#000000\" bordercolor=\"#000000\" width=100%>\n<tr>");
	CString name;
	int i,width=0;
	for( i=0; i<cols;i++)
	{
		bool add=  true;
		if(h_cols!=0)
			for(int c=0; c<h_cols->GetSize();c++)
				if((int)h_cols->GetAt(c)==i) add=false;
		if(add)
		{
			HDITEM item;
			item.mask = HDI_WIDTH;
			head->GetItem(i,&item);
			width+=item.cxy;
		}
	}
	for(i=0; i<cols;i++)
	{
		bool add=  true;
		if(h_cols!=0)
			for(int c=0; c<h_cols->GetSize();c++)
				if((int)h_cols->GetAt(c)==i) add= false;
		if(add)
		{
			HDITEM item;
			TCHAR buf[256];
			item.mask = HDI_TEXT | HDI_WIDTH;
			item.pszText = buf;
			item.cchTextMax = 256;
			head->GetItem(i,&item);
			int percent = (int)((float)item.cxy/(float)width*100);
			CString t=_T("");
			t.Format(_T("%i"),percent);
			str=str+_T("<td width=\""+t+"%\"><center><b>"+item.pszText+"</b></center></td>\n");
		}
	}
	str+=_T("</tr>\n");
	int rcount = ListCtrl->GetItemCount();	
	
	int index= 0;

	if(flag & HG_SELECTED_ITEMS){
		index= ListCtrl->GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	}else{
		index=0;
	}
	i=index;
	while(true){
		if(i>=rcount || i==-1){
			break;
		}
		str+=_T("<tr>\n");
		for(int c=0; c<cols;c++)
		{
			bool add=  true;
			if(h_cols!=0)
				for(int cc=0; cc<h_cols->GetSize();cc++)
					if((int)h_cols->GetAt(cc)==c) add= false;
					if(add)
					{
						CString val = ListCtrl->GetItemText(i,c);
						if(val==_T("") | val==_T(" ")) val=_T("&nbsp");
						str+=_T("<td>")+val+_T("</td>\n");
					}
		}
		str+=_T("</tr>\n");

		if(flag & HG_SELECTED_ITEMS){
			i= ListCtrl->GetNextItem(index, LVNI_ALL|LVNI_SELECTED);
			index=i;
		}else{
			i++;
		}
	}

	str+=_T("</table>\n");
	CStdioFile f;
	if(flag & HG_CREATE_FILE)
		f.Open(m_file_name, CFile::modeCreate | CFile::modeWrite);
	if(flag & HG_ADD_TO_FILE)
		if(!f.Open(m_file_name,CFile::modeWrite))
			f.Open(m_file_name, CFile::modeCreate | CFile::modeWrite);
	f.SeekToEnd();
	f.WriteString(str);
	f.Close();
	return true;
}

bool CHtmlGen::AppendItem2Html(CaplTreeListCtrl *ListCtrl, HTREEITEM hItem, CString &html, bool bSelectdOnly, bool bOnlyWithData, int level, CUIntArray *h_cols)
{
	if(hItem!=TVI_ROOT)
	{
		int state = ListCtrl->GetItemState(hItem, TVIS_SELECTED/*|TVIS_DROPHILITED*/);
		if(state&TVIS_SELECTED || !bSelectdOnly)
		{
			/*CString line;
			CHeaderCtrl* pHeadC = (CHeaderCtrl*)&(m_tree.m_wndHeader);
			int SubItemCount = pHeadC->GetItemCount();

			for (int nSubItem = 0; nSubItem < SubItemCount; nSubItem++)
			{
				if (nSubItem!=0) line += razd;
				line +=_T('"');
				if (nSubItem==0) {for(int i=0;i<level;i++) line+= spacer;}
				line += m_tree.GetItemText(hItem, nSubItem);
				line +=_T('"');
			}
			line += _T("\n");
			txt+=line;*/
			CaplTreeListHeaderCtrl *head = &ListCtrl->m_wndHeader;
			int cols = head->GetItemCount();

			html+=_T("<tr>\n");
			CString txt;
			for(int c=0; c<cols;c++)
			{
				bool add=  true;
				if(h_cols!=0)
					for(int cc=0; cc<h_cols->GetSize();cc++)
						if((int)h_cols->GetAt(cc)==c) add= false;
				if(add)
				{
					txt = ListCtrl->GetItemText(hItem,c);
					if(txt==_T("")) txt =_T("&nbsp");
					html+=_T("<td>");
					
					if(c==0 && level>0)
					{
						for(int k=0; k<level;k++) html+=_T("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
					}

					html+=txt+_T("</td>\n");
				}
			}
			html+=_T("</tr>\n");
		}
	}

	level++;
	HTREEITEM hChildItem = ListCtrl->GetNextItem(hItem, TVGN_CHILD);
	while (hChildItem)
	{
		int data=1;
		if(bOnlyWithData) data= ListCtrl->GetItemData(hChildItem);
		if(data!=0) AppendItem2Html(ListCtrl, hChildItem, html, bSelectdOnly, bOnlyWithData, level,h_cols);
		hChildItem = ListCtrl->GetNextItem(hChildItem, TVGN_NEXT);
	}
	return true;
}

bool CHtmlGen::GenerateByListCtrl(CaplTreeListCtrl *ListCtrl, CString m_file_name, BYTE flag, CUIntArray *h_cols)
{
	if(ListCtrl==0) return false;
	if((flag & HG_CREATE_FILE) && (flag & HG_ADD_TO_FILE)) return false;
	if((flag & HG_ALL_ITEMS) && (flag & HG_VISIBLE_ITEMS)) return false;
	CaplTreeListHeaderCtrl *head = &ListCtrl->m_wndHeader;
	CString str;
	UINT state;
	int cols = head->GetItemCount();
	str=_T("<table border=\"1\"  style=\"font-size: 9pt;\" cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"0\" cellpadding=\"3\" style='border-collapse:collapse' color=0 bordercolorlight=\"#000000\" bordercolordark=\"#000000\" bordercolor=\"#000000\" width=100%>\n<tr>");
	CString name;
	int i,width=0;
	for(i=0; i<cols;i++)
	{
		bool add = true;
		if(h_cols!=0)
			for(int c=0; c<h_cols->GetSize();c++)
				if((int)h_cols->GetAt(c)==i) add= false;
		if(add)
		{
			HDITEM item;
			item.mask = HDI_WIDTH;
			head->GetItem(i,&item);
			width+=item.cxy;
		}
	}
	for(i=0; i<cols;i++)
	{
		bool add = true;
		if(h_cols!=0)
			for(int c=0; c<h_cols->GetSize();c++)
				if((int)h_cols->GetAt(c)==i) add= false;
		if(add)
		{
			HDITEM item;
			TCHAR buf[256];
			item.mask = HDI_TEXT | HDI_WIDTH;
			item.pszText = buf;
			item.cchTextMax = 256;
			head->GetItem(i,&item);
			int percent = (int)((float)item.cxy/(float)width*100);
			CString t=_T("");
			t.Format(_T("%i"),percent);
			str=str+_T("<td width=\""+t+"%\"><center><b>"+item.pszText+"</b></center></td>\n");
		}
	}
	str+=_T("</tr>\n");
	if(flag & HG_VISIBLE_ITEMS)
	{
		//ReadTable.
		HTREEITEM ht = ListCtrl->GetFirstVisibleItem();
		while(ht!=NULL)
		{
			str+=_T("<tr>\n");
			CString txt;
			for(int c=0; c<cols;c++)
			{
				bool add=  true;
				if(h_cols!=0)
					for(int cc=0; cc<h_cols->GetSize();cc++)
						if((int)h_cols->GetAt(cc)==c) add= false;
				if(add)
				{
					txt = ListCtrl->GetItemText(ht,c);
					if(txt==_T("")) txt =_T("&nbsp");
					str+=_T("<td>")+txt+_T("</td>\n");
				}
			}
			str+=_T("</tr>\n");
			ht = ListCtrl->GetNextVisibleItem(ht);
		}
	}
	else if(flag & HG_SELECTED_ITEMS)
	{
		//ReadTable.
		HTREEITEM ht = ListCtrl->GetFirstVisibleItem();
		while(ht!=NULL)
		{
			state = ListCtrl->GetItemState(ht, TVIS_SELECTED/*|TVIS_DROPHILITED*/);
			if(state&TVIS_SELECTED){
				str+=_T("<tr>\n");
				CString txt;
				for(int c=0; c<cols;c++)
				{
					bool add=  true;
					if(h_cols!=0)
						for(int cc=0; cc<h_cols->GetSize();cc++)
							if((int)h_cols->GetAt(cc)==c) add= false;
							if(add)
							{
								txt = ListCtrl->GetItemText(ht,c);
								if(txt==_T("")) txt =_T("&nbsp");
								str+=_T("<td>")+txt+_T("</td>\n");
							}
				}
				str+=_T("</tr>\n");
			}

			ht = ListCtrl->GetNextVisibleItem(ht);
		}
	}
	else if(flag & HG_ALL_ITEMS)
	{
		//ReadTable.
		AppendItem2Html(ListCtrl,TVI_ROOT,str,false,true,-1,h_cols);
		/*HTREEITEM ht = ListCtrl->GetRootItem();
		while(ht!=NULL)
		{
			if(!ListCtrl->IsItemFictive(ht))
			{
				str+="<tr>\n";
				CString txt;
				for(int c=0; c<cols;c++)
				{
					bool add=  true;
					if(h_cols!=0)
						for(int cc=0; cc<h_cols->GetSize();cc++)
							if((int)h_cols->GetAt(cc)==c) add= false;
					if(add)
					{
						txt = ListCtrl->GetItemText(ht,c);
						if(txt=="") txt ="&nbsp";
						str+="<td>"+txt+"</td>\n";
					}
				}
				AddAllRows(ListCtrl,str,ht,cols,h_cols);
				str+="</tr>\n";
			}
			ht = ListCtrl->GetNextItem(ht,TVGN_NEXT);
		}*/
	}
	str+=_T("</table>\n");

	//save to file
	CStdioFile f;
	if(flag & HG_CREATE_FILE)
		f.Open(m_file_name, CFile::modeCreate | CFile::modeWrite);
	if(flag & HG_ADD_TO_FILE)
		if(!f.Open(m_file_name,CFile::modeWrite))
			f.Open(m_file_name, CFile::modeCreate | CFile::modeWrite);
	f.SeekToEnd();
	f.WriteString(str);
	f.Close();
	return true;
}

bool CHtmlGen::AddAllRows(CaplTreeListCtrl *ListCtrl, CString &str, HTREEITEM parent, int cols, CUIntArray *h_cols)
{
	HTREEITEM ht = ListCtrl->GetChildItem(parent);
	if(ht==NULL) return false;
	while(ht!=NULL)
	{
		if(!ListCtrl->IsItemFictive(ht))
		{
			str+=_T("<tr>\n");
			CString txt;
			for(int c=0; c<cols;c++)
			{
				bool add=  true;
				if(h_cols!=0)
					for(int cc=0; cc<h_cols->GetSize();cc++)
						if((int)h_cols->GetAt(cc)==c) add= false;
				if(add)
				{
					txt = ListCtrl->GetItemText(ht,c);
					if(txt==_T("")) txt =_T("&nbsp");
					str+=_T("<td>")+txt+_T("</td>\n");
				}
			}
			AddAllRows(ListCtrl,str,ht,cols,h_cols);
			str+=_T("</tr>\n");
		}
		ht = ListCtrl->GetNextItem(ht,TVGN_NEXT);
	}
	return true;
}

int CHtmlGen::AddParam(CString param, CString color, CString bkcolor)
{
	if(add_row>0) 
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  -  !!!!    "));
		return -3;
#endif
	}
	if(!m_of.Open(m_dot_name,CFile::modeRead))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -1;//  
	}
	if(!m_rf.Open(m_file_name,CFile::modeWrite))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -2; //   
	}

	CString str;
	int sec=0;
	int i = 0;
	m_of.Seek(cur_pos,CFile::begin);
	m_rf.Seek(0,CFile::end);
	bool find = false;
	while(m_of.ReadString(str) && !find)
	{
		if(str.Find(_T("##"),0)>-1)
		{
			str.Replace(_T("##"),param);
			str.Replace(_T("bcolor"),bkcolor);
			str.Replace(_T("fcolor"),color);
			find = true;
		}
		else if(str.Find(_T("</tr>"))>-1)
		{
			find = true;
			cur_pos = m_pos;
		}
		m_rf.WriteString(str+_T("\n"));
	}
	cur_pos = (DWORD) m_of.GetPosition();
	m_of.Close();
	m_rf.Close();
	return 0;	
}

int CHtmlGen::CreateEmptyTitle(CString file_name)
{
	CStdioFile m_rf;
	if(!m_rf.Open(file_name,CFile::modeWrite|CFile::modeCreate))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -2; //   
	}
	m_rf.WriteString(_T("<HEADER>\n"));
	m_rf.WriteString(_T("<TITLE>\n"));
	m_rf.WriteString(_T("</TITLE>\n"));
	m_rf.WriteString(_T("</HEADER>\n"));
	m_rf.WriteString(_T("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Windows-1251\">\n"));
	m_rf.WriteString(_T("<BODY>\n"));
	m_rf.Close();
	return 0;
}

int CHtmlGen::CreateEmptyPS(CString file_name)
{
	CStdioFile m_rf;
	if(!m_rf.Open(file_name,CFile::modeWrite))
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  "), MB_OK|MB_ICONSTOP);
#endif
		return -2; //   
	}
	m_rf.SeekToEnd();
	m_rf.WriteString(_T("</BODY>\n"));
	m_rf.Close();
	return 0;
}
