// ProgressDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ProgressDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProgressDlg dialog


CProgressDlg::CProgressDlg(CWnd* pParent /*=NULL*/, CStatusDlgThread *pThread, bool bSlave)
	: CaplTranslateDialog(CProgressDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProgressDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_bBreak = false;
	m_bSlave = bSlave;
	m_pThread = pThread;
}


void CProgressDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProgressDlg)
	DDX_Control(pDX, IDC_BREAK, m_break_btn);
	DDX_Control(pDX, IDC_PROGRESS, m_ProgressCtrl);
	DDX_Control(pDX, IDC_DESCR, m_DescrCtrl);
	DDX_Control(pDX, IDC_PROGRESS2, m_ProgressCtrl2);
	DDX_Control(pDX, IDC_DESCR2, m_DescrCtrl2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProgressDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CProgressDlg)
	ON_BN_CLICKED(IDC_BREAK, OnBreak)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProgressDlg message handlers

BOOL CProgressDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	if (!m_bSlave)
	{
		CRect rect, d2_rect, btn_rect;
		m_DescrCtrl2.GetWindowRect(d2_rect);
		ScreenToClient(d2_rect);
		m_break_btn.GetWindowRect(btn_rect);
		ScreenToClient(btn_rect);
		int delta = d2_rect.top - btn_rect.top;
		btn_rect.top = d2_rect.top;
		btn_rect.bottom += delta;
		m_break_btn.MoveWindow(btn_rect);

		GetWindowRect(rect);
		ClientToScreen(btn_rect);
		rect.bottom = btn_rect.bottom+10;
		MoveWindow(rect);

		//MoveWindow(0, 0, 416, 66);
		//CRect rect1(CPoint(175,46),CSize(65,16));
		//m_break_btn.MoveWindow(rect1);
		m_ProgressCtrl2.ShowWindow(SW_HIDE);
		m_DescrCtrl2.ShowWindow(SW_HIDE);

		m_break_btn.Invalidate();
	}

	m_break_btn.SetFlat(FALSE);
	m_break_btn.SetIcon(GetAplStdIco16(APL_STD_24CANCEL));
	m_DescrCtrl.SetWindowText(_T(""));

	if(m_pThread)
	{
		if(!m_pThread->m_bShowBreakBtn)
		{
			m_break_btn.ShowWindow(SW_HIDE);
			CRect rect, btn_rect;
			m_break_btn.GetWindowRect(btn_rect);
			GetWindowRect(rect);
			rect.bottom = btn_rect.top;
			MoveWindow(rect);
			CenterWindow();
		}
		//     
		if(m_pThread->m_bShowOnTop)
		{
			if(m_pThread->m_pParent)
				SetWindowPos(m_pThread->m_pParent, 0, 0, 0, 0, SWP_NOSIZE|SWP_SHOWWINDOW|SWP_NOMOVE);
			else
				SetWindowPos(&CWnd::wndTopMost, 0, 0, 0, 0, SWP_NOSIZE|SWP_SHOWWINDOW|SWP_NOMOVE);
		}
		else
		{
			//SetWindowPos(&CWnd::wndNoTopMost, 0, 0, 0, 0, SWP_NOSIZE|SWP_SHOWWINDOW|SWP_DRAWFRAME);
			ModifyStyle(NULL, WS_CAPTION|WS_DLGFRAME|WS_BORDER|WS_ACTIVECAPTION);

			CRect rect;
			GetWindowRect(rect);
			rect.bottom += 20;
			MoveWindow(rect);
			CenterWindow();
		}
	}

	CenterWindow();

	SetFocus();

	if(m_pThread)
		m_pThread->m_bInitialed = true;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CProgressDlg::OnBreak() 
{
	if(!m_pThread->m_sBreakMsg.IsEmpty())
	{
		if(AfxMessageBox(m_pThread->m_sBreakMsg, MB_ICONQUESTION|MB_YESNO)!=IDYES) return;
	}
	m_pThread->m_bBreak = true;
	if(!m_pThread->m_sBreakStatusMsg.IsEmpty())
		m_pThread->SetText(m_pThread->m_sBreakStatusMsg);

	m_break_btn.EnableWindow(FALSE);
}

void CProgressDlg::OnCancel()
{
	if(m_pThread)
	{
		if(m_pThread->m_bEnd)
		{
			CaplTranslateDialog::OnCancel();
			return;
		}
	}
	OnBreak();
}

void CProgressDlg::OnOK()
{
	if(m_pThread)
	{
		if(m_pThread->m_bEnd)
			CaplTranslateDialog::OnOK();
	}
}
