// CaplFindInTableDlgBar.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"
#include "resource.h"
#include "aplFindInTableDlg.h"

// CaplFindInTableDlgBar dialog

CaplFindInTableDlg m_findIntableDlg;


IMPLEMENT_DYNAMIC(CaplFindInTableDlgBar, CDialogBar)

CaplFindInTableDlgBar::CaplFindInTableDlgBar()
{
	m_treelist=0;
	m_list=0;
}

CaplFindInTableDlgBar::~CaplFindInTableDlgBar()
{
}

void CaplFindInTableDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialogBar::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_FIND_FIRST, m_btnFindFirst);
	DDX_Control(pDX, IDC_FIND_NEXT, m_btnFindNext);
	DDX_Control(pDX, IDC_FIND_PREV, m_btnFindPrev);
	DDX_Control(pDX, IDC_TEXT, m_text_ctrl);
	DDX_Control(pDX, IDC_COLUMN_NAME, m_colums_box);
}


BEGIN_MESSAGE_MAP(CaplFindInTableDlgBar, CDialogBar)
	ON_COMMAND(IDC_FIND_FIRST, OnBnClickedFindFirst)
	ON_UPDATE_COMMAND_UI(IDC_FIND_FIRST, EnableButtons)

	ON_COMMAND(IDC_FIND_NEXT, OnBnClickedFindNext)
	ON_UPDATE_COMMAND_UI(IDC_FIND_NEXT, EnableButtons)

	ON_COMMAND(IDC_FIND_PREV, OnBnClickedFindPrev)
	ON_UPDATE_COMMAND_UI(IDC_FIND_PREV, EnableButtons)

	//ON_CBN_DROPDOWN(IDC_COLUMN_NAME, OnCbnDropdownComboColumn)
	ON_WM_CREATE()
END_MESSAGE_MAP()


// CaplFindInTableDlgBar message handlers

//void CaplFindInTableDlgBar::OnCbnDropdownComboColumn(){}

void CaplFindInTableDlgBar::FindNextItem(int delta)
{
	if(0==m_treelist && 0==m_list)   return;

	if(0!=m_treelist)
	{
		if(!IsWindow(m_treelist->m_hWnd))return;
	}
	if(0!=m_list)
	{
		if(!IsWindow(m_list->m_hWnd))return;
	}

	CString text;
	m_text_ctrl.GetWindowText(text);
	if(text==_T("")){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING);m_text_ctrl.SetFocus(); return;}
	text.MakeLower();

	int col=m_colums_box.GetCurSel()-1;
	//if(col<0) {AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING); column_ctrl->SetFocus(); return;}

	if(0!=m_treelist) CaplFindInTableDlgBar::FindNextTreeListItem(m_treelist, text,delta, col);
	else if(0!=m_list) CaplFindInTableDlgBar::FindNextListItem(m_list, text,delta, col);
}


void CaplFindInTableDlgBar::FindNextTreeListItem(CaplTreeListCtrl *treelist, LPCTSTR text, int delta, int col, bool bFindWholeString /*= false*/)
{
	if(0==treelist) return;
	if(!IsWindow(treelist->m_hWnd))return;
	if(0==text)  return;
	if(text[0]==_T('\0'))  return;

	HTREEITEM cur_hitem=0; //TVI_ROOT;
	if(1==delta || -1==delta) cur_hitem=treelist->GetSelectedItem();

	CString buf;
	if(0==delta) delta=1;
	while(true)
	{
		cur_hitem=aplGetNextTreeItem(treelist,cur_hitem,delta);
		if(0==cur_hitem) return;
		bool bFound=false;
		if(col<0) // 
		{
			int i;
			for (i=0;i<treelist->GetColumnsNum(); i++)
			{
				buf=treelist->GetItemText(cur_hitem,i);
				buf.MakeLower();
				if (bFindWholeString)
				{
					if (buf==text) { bFound = true; break; }
				}
				else if(buf.Find(text)>=0) {bFound=true; break;}
			}
		}
		else
		{
			buf=treelist->GetItemText(cur_hitem,col);
			buf.MakeLower();
			if (bFindWholeString)
			{
				if (buf == text) { bFound = true; }
			}
			else if(buf.Find(text)>=0)bFound=true;
		}
		if(bFound)
		{
			treelist->SingleSelectItem(cur_hitem);
			treelist->EnsureVisible(cur_hitem);
			return;
		}
	}
}

void CaplFindInTableDlgBar::FindNextListItem(CListCtrl *list, LPCTSTR text, int delta, int col, bool bFindWholeString /*= false*/)
{
	if(0==list) return;
	if(!IsWindow(list->m_hWnd))return;
	if(0==text)  return;
	if(text[0]==_T('\0'))  return;

	int cur_list_item=-1;

	if(1==delta || -1==delta) cur_list_item=list->GetNextItem ( -1, LVIS_SELECTED | LVIS_FOCUSED ); 

	CString buf;
	if(0==delta) delta=1;

	while(true)
	{
		cur_list_item+=delta;
		if(cur_list_item<0 || cur_list_item > list->GetItemCount()) return;
		bool bFound=false;
		if(col<0) // 
		{
			int i;
			CHeaderCtrl *header=list->GetHeaderCtrl();
			if(0==header) return;
			for (i=0;i<header->GetItemCount(); i++)
			{
				buf=list->GetItemText(cur_list_item,i);
				buf.MakeLower();
				if (bFindWholeString)
				{
					if (buf == text) { bFound = true; break; }
				}
				else if(buf.Find(text)>=0) {bFound=true; break;}
			}
		}
		else
		{
			buf=list->GetItemText(cur_list_item,col);
			buf.MakeLower();
			if (bFindWholeString)
			{
				if (buf == text) { bFound = true; }
			}
			else if(buf.Find(text)>=0)bFound=true;
		}
		if(bFound)
		{	
			//  
			POSITION pos = list->GetFirstSelectedItemPosition();
			while (pos)
			{
				int nItem = list->GetNextSelectedItem(pos);
				list->SetItemState(nItem,0,LVIS_SELECTED|LVIS_FOCUSED); 
			}

			//  
			list->SetItemState(cur_list_item,LVIS_SELECTED|LVIS_FOCUSED,LVIS_SELECTED|LVIS_FOCUSED); 
			list->EnsureVisible(cur_list_item,FALSE);
			return;
		}
	}
}


void CaplFindInTableDlgBar::OnBnClickedFindFirst(){
	//m_findIntableDlg.Show(m_treelist);
	FindNextItem(0);
}
void CaplFindInTableDlgBar::OnBnClickedFindNext()
{
	//m_findIntableDlg.Install(m_treelist);

	FindNextItem(1);
	/*HTREEITEM cur_hitem=m_treelist->GetSelectedItem();
	if(0==cur_hitem) return;
	HTREEITEM next_hitem=aplGetNextTreeItem(m_treelist, cur_hitem,1);
	if(0!=next_hitem)m_treelist->SingleSelectItem(next_hitem);*/
}
void CaplFindInTableDlgBar::OnBnClickedFindPrev() 
{	
	FindNextItem(-1);
	/*HTREEITEM cur_hitem=m_treelist->GetSelectedItem();
	if(0==cur_hitem) return;
	HTREEITEM next_hitem=aplGetNextTreeItem(m_treelist, cur_hitem,-1);
	if(0!=next_hitem)m_treelist->SingleSelectItem(next_hitem);*/
}


void CaplFindInTableDlgBar::Init(CWnd *table_wnd, DWORD dwStyle, DWORD dwDockStyle, UINT nDockBarID )
{
	if(0==table_wnd) return;

	if(table_wnd->IsKindOf(RUNTIME_CLASS(CaplTreeListCtrl))) m_treelist=(CaplTreeListCtrl*)table_wnd;
	else 	if(table_wnd->IsKindOf(RUNTIME_CLASS(CListCtrl))) m_list=(CListCtrl*)table_wnd;
	else 
	{
		#ifdef _DEBUG
			AfxMessageBox(APL_T("  CaplFindInTableDlgBar::Init.    CListCtrl  CaplTreeListCtrl."),MB_OK|MB_ICONSTOP);
		#endif
		return; 
	}		

	//  ;
	CFrameWnd *frame=0;
	CWnd *parent=table_wnd;
	while(parent!=0)
	{
		parent=parent->GetParent();
		if(0==parent) break;
		if(parent->IsFrameWnd()) {frame=(CFrameWnd *)parent; break;}
	}

	if(0==frame)
	{
		#ifdef _DEBUG
				AfxMessageBox(APL_T("  CaplFindInTableDlgBar::Init.         "),MB_OK|MB_ICONSTOP);
		#endif
		return; 
	}

	CaplSetResourceHandle setres(module_inst);

	if(!Create(frame, IDD_FIND_BAR, dwStyle, IDD_FIND_BAR))
	{
		TRACE0("Failed to create dialog bar\n");
		return ;      // fail to create		
	}
	UpdateData(FALSE);
	m_btnFindFirst.SetFlat(FALSE);
	m_btnFindNext.SetFlat(FALSE);
	m_btnFindPrev.SetFlat(FALSE);
	m_btnFindFirst.SetIcon(GetAplTableIco((APL_TABLE_FIND)));
	m_btnFindNext.SetIcon(GetAplTableIco((APL_TABLE_BOTTOM)));
	m_btnFindPrev.SetIcon(GetAplTableIco((APL_TABLE_TOP)));


	//SetBarStyle(GetBarStyle() CBRS_BOTTOM | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC|CBRS_BORDER_3D|CBRS_GRIPPER);
	if(0!=dwDockStyle) EnableDocking( dwDockStyle /*CBRS_ALIGN_ANY*/);
	if(0!=nDockBarID) frame->DockControlBar(this,nDockBarID/*AFX_IDW_DOCKBAR_BOTTOM*/);

	UpdateColumnsList();
}

void CaplFindInTableDlgBar::UpdateColumnsList()
{
	if(0==m_treelist) return;
	CHeaderCtrl *header=0;
	if(0!=m_treelist)header=&m_treelist->m_wndHeader;
	else if(m_list!=0) header=m_list->GetHeaderCtrl();
	if(0==header) return;

	CaplFindInTableDlgBar::UpdateColumnsList(header,&m_colums_box);
}

void CaplFindInTableDlgBar::UpdateColumnsList(CHeaderCtrl *headerctrl, CComboBox *combo)
{
	if(0==combo) return;
	combo->ResetContent();
	int i=combo->AddString(APL_T("***   ***"));
	combo->SetCurSel(i);
	//combo->SetItemData(i,-1);

	if(0==headerctrl) return;

	HDITEM hdi;
	hdi.mask = HDI_TEXT;
	enum   { sizeOfBuffer = 256 };
	TCHAR  lpBuffer[sizeOfBuffer];
	hdi.pszText = lpBuffer;
	hdi.cchTextMax = sizeOfBuffer;


	for(i=0;i<headerctrl->GetItemCount();i++)
	{
		if(headerctrl->GetItem(i,&hdi))
		{
			combo->AddString(hdi.pszText);
		}
	}
}
