// aplLangSelectDlg.cpp : implementation file
//

#include "stdafx.h"
#include "aplLangSelectDlg.h"
#include <aplguiex.h>

// CaplLangSelectDlg dialog

IMPLEMENT_DYNAMIC(CaplLangSelectDlg, CDialog)

CaplLangSelectDlg::CaplLangSelectDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CaplLangSelectDlg::IDD, pParent)
	, m_iLang(0)
{

}

CaplLangSelectDlg::~CaplLangSelectDlg()
{
}

void CaplLangSelectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LANG, m_lang_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
}


BEGIN_MESSAGE_MAP(CaplLangSelectDlg, CDialog)
END_MESSAGE_MAP()


// CaplLangSelectDlg message handlers

BOOL CaplLangSelectDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	m_ok_btn.SetIcon(aplGetButtonIco(APL_24_OK));
	m_ok_btn.SetFlat(FALSE);

	//     
	m_iLang = 0;
	int iRus = 0;
	TIntSet nums;
	CString sPath;
	GetExePath(GetModuleHandle(NULL), sPath);
	CaplTranslate::GetTranslateFiles(sPath, nums);
	//           
	for(int i=0; i<APL_LANG_COUNT; ++i)
	{
		if (apl_langs[i].id==0x0419)
		{
			nums.insert(i);
			iRus = i;
			break;
		}
	}

	//  -
	for(TIntSet_it it=nums.begin(); it!=nums.end(); ++it)
	{
		int ind = m_lang_ctrl.AddString(apl_langs[*it].description);
		m_lang_ctrl.SetItemData(ind, (DWORD_PTR)(*it));
		if (*it==iRus)
		{
			m_lang_ctrl.SetCurSel(ind);
		}
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CaplLangSelectDlg::OnOK()
{
	// TODO: Add your specialized code here and/or call the base class
	int iSel = m_lang_ctrl.GetCurSel();
	if (iSel==CB_ERR)
		m_iLang = -1;
	else
		m_iLang = (int)m_lang_ctrl.GetItemData(iSel);

	CDialog::OnOK();
}
