// aplTabCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplTabCtrl

CaplTabCtrl::CaplTabCtrl()
{
}

CaplTabCtrl::~CaplTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CaplTabCtrl, CTabCtrl)
	//{{AFX_MSG_MAP(CaplTabCtrl)
	ON_NOTIFY_REFLECT_EX(TCN_SELCHANGE, OnSelchange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CaplTabCtrl::ClearExcludeIDs(void)
{
	m_iaExcludeIDs.RemoveAll();
}

void CaplTabCtrl::AddExcludeIDs(CArray<int,int>& caIDs)
{
	m_iaExcludeIDs.Append(caIDs);
}

void CaplTabCtrl::ClearTabs(void)
{
	m_paTabs.RemoveAll();
}

void CaplTabCtrl::AddTab(int iTab,CWnd* pWnd)
{
	m_paTabs.SetAtGrow(iTab,pWnd);
}

void CaplTabCtrl::InitStates(void)
{
	CWnd*	pParent	=NULL;
	CWnd*	pChild	=NULL;

	LONG	lStyle;
	WORD	wState;
	
	pParent=GetParent();
	if(NULL==pParent)
		return;

	pChild=pParent->GetTopWindow();
	while(NULL!=pChild)
	{
		lStyle=::GetWindowLong(pChild->m_hWnd,GWL_STYLE);
		if(lStyle&WS_VISIBLE)
			wState=SW_SHOW;
		else
			wState=SW_HIDE;

		m_mWinStates.SetAt(pChild,wState);

		pChild=pChild->GetNextWindow(GW_HWNDNEXT);
	}
}

void CaplTabCtrl::ChangeCtrlsState(BOOL bShow)
{
	CWnd*		pParent	=NULL;
	CWnd*		pChild	=NULL;

	POSITION	pos		=NULL;

	WORD		wState;

	BOOL		bFound	=FALSE;

	int			iID,i;

	pParent=GetParent();
	if(NULL==pParent)
		return;

	pos=m_mWinStates.GetStartPosition();
	while(NULL!=pos)
	{
		m_mWinStates.GetNextAssoc(pos,(void*&)pChild,wState);
		if(!::IsWindow(pChild->m_hWnd))
			continue;
		if(pChild==this)
			continue;
		iID=pChild->GetDlgCtrlID();
		if(0==iID)
			continue;
		if(IDOK==iID || IDCANCEL==iID)
			continue;
		bFound=FALSE;
		for(i=0;i<m_iaExcludeIDs.GetSize();i++)
			if(iID==m_iaExcludeIDs.GetAt(i))
			{
				bFound=TRUE;break;
			}
		if(TRUE==bFound)
			continue;
		if(TRUE==bShow)
			pChild->ShowWindow(wState);
		else
			pChild->ShowWindow(SW_HIDE);
	}
}

void CaplTabCtrl::ChangeViewsState(int iShow)
{
	CWnd*	pParent	=NULL;
	CWnd*	pwnd	=NULL;

	int		i;

	pParent=GetParent();

	for(i=0;i<m_paTabs.GetSize();i++)
	{
		pwnd=(CWnd*)m_paTabs.GetAt(i);
		if(NULL==pwnd)
			continue;
		if(!::IsWindow(pwnd->m_hWnd))
			continue;
		LONG lc=::GetWindowLong(pwnd->m_hWnd,GWL_STYLE);
		CRect rt;
		pwnd->GetWindowRect(rt);
		if(i==iShow)
		{
			pwnd->ShowWindow(SW_SHOW);
			pwnd->BringWindowToTop();
		}
		else
			pwnd->ShowWindow(SW_HIDE);

//		pwnd->SetWindowPos(pParent/*&CWnd::wndTop*/,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
//		pwnd->BringWindowToTop();
		
	}
}

BOOL CaplTabCtrl::GetTabView(int iTab,CWnd*& pWndOut)
{
	if(iTab<0 || iTab>=m_paTabs.GetSize())
		return FALSE;
	if(0==iTab)
		pWndOut=NULL;
	else
		pWndOut=(CWnd*)m_paTabs.GetAt(iTab);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CaplTabCtrl message handlers
BOOL CaplTabCtrl::OnSelchange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int		iSel=GetCurSel();
	
	if(-1==iSel)
		return FALSE;

	if(0==iSel)
	{
//		TRACE("0\n");
		ChangeCtrlsState(TRUE);
		ChangeViewsState(-1);
	}
	else
	{
//		TRACE("!0\n");
		ChangeCtrlsState(FALSE);
		ChangeViewsState(iSel);
	}
	
	*pResult = 0;

	return FALSE;
}
