// apl_gui.h

#if !defined(APL_GUI_H__C8F05508_3C3D_11D3_A148_000000000000__INCLUDED_)
#define APL_GUI_H__C8F05508_3C3D_11D3_A148_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxtempl.h>
#include <afxcview.h>
#include <afxpriv.h>    // for CDockContext
#include <afxole.h>
#include <afxhtml.h>
#include <afxdtctl.h>
#include <aplAggr.h>
#include <set>
#include <map>

#ifndef APL_GUI_NOAUTOLIB
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"apl_gui_ud.lib")
#else
#pragma comment (lib,"apl_gui_d.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"apl_gui_u.lib")
#else
#pragma comment (lib,"apl_gui.lib")
#endif
#endif
#endif

#ifdef APL_GUI_IMPL
#define CLASS_DECL_APL_GUI  _declspec(dllexport)
#else
#define CLASS_DECL_APL_GUI  _declspec(dllimport)
#endif

//      CALS  MOMA.
//         MOMA   
#ifdef _UNICODE
#define _MOMA_
#endif

//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplSetResourceHandle
{
public:
	CaplSetResourceHandle(HINSTANCE inst);
	~CaplSetResourceHandle();
	void RestoreHandle();
protected:
	HINSTANCE  m_old_inst_resources;
};


//*************************************************************************
//*************************************************************************
//*** CaplHyperLink window  ***********************************************
//*************************************************************************
//*************************************************************************
// Structure used to get/set hyperlink colors
#define WM_SPLITTER_MOVED	WM_USER+1000

class CLASS_DECL_APL_GUI CaplHyperLink : public CStatic
{
	DECLARE_DYNAMIC(CaplHyperLink)

public:
	typedef struct tagHYPERLINKCOLORS {
		COLORREF	crLink;
		COLORREF	crActive;
		COLORREF	crVisited;
		COLORREF	crHover;
	} HYPERLINKCOLORS;

// Link styles
	static const DWORD StyleUnderline;
	static const DWORD StyleUseHover;
	static const DWORD StyleAutoSize;
	static const DWORD StyleDownClick;
	static const DWORD StyleGetFocusOnClick;
	static const DWORD StyleNoHandCursor; 
	static const DWORD StyleNoActiveColor;

// Construction/destruction
	CaplHyperLink();
	virtual ~CaplHyperLink();

// Attributes
public:

// Operations
public:	
	static void GetColors(HYPERLINKCOLORS& linkColors);

	static HCURSOR GetLinkCursor();
	static void SetLinkCursor(HCURSOR hCursor);
    
    static void SetColors(COLORREF crLinkColor, COLORREF crActiveColor, 
				   COLORREF crVisitedColor, COLORREF crHoverColor = -1);
    static void SetColors(HYPERLINKCOLORS& colors);

	void SetURL(CString strURL);
    CString GetURL() const;

	DWORD GetLinkStyle() const;
	BOOL ModifyLinkStyle(DWORD dwRemove, DWORD dwAdd, BOOL bApply=TRUE);	
    
	void SetWindowText(LPCTSTR lpszText);
	void SetFont(CFont *pFont);
	
	BOOL IsVisited() const;
	void SetVisited(BOOL bVisited = TRUE);
	
	// Use this if you want to subclass and also set different URL
	BOOL SubclassDlgItem(UINT nID, CWnd* pParent, LPCTSTR lpszURL=NULL) {
		m_strURL = lpszURL;
		return CStatic::SubclassDlgItem(nID, pParent);
	}

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplHyperLink)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);	
	protected:
	virtual void PreSubclassWindow();	
	//}}AFX_VIRTUAL

// Implementation
protected:
	static void SetDefaultCursor();
	static LONG GetRegKey(HKEY key, LPCTSTR subkey, LPTSTR retdata);
	static void ReportError(int nError);	
	static HINSTANCE GotoURL(LPCTSTR url, int showcmd);

	void AdjustWindow();	
	void FollowLink();
	inline void SwitchUnderline();
	
// Protected attributes
protected:
	static COLORREF g_crLinkColor;		// Link normal color
	static COLORREF g_crActiveColor;	// Link active color
	static COLORREF g_crVisitedColor;	// Link visited color
	static COLORREF g_crHoverColor;		// Hover color
	static HCURSOR  g_hLinkCursor;		// Hyperlink mouse cursor

	BOOL	 m_bLinkActive;				// Is the link active?
	BOOL     m_bOverControl;			// Is cursor over control?
	BOOL	 m_bVisited;				// Has link been visited?
	DWORD	 m_dwStyle;					// Link styles
	CString  m_strURL;					// Hyperlink URL string
	CFont    m_Font;					// Underlined font (if required)	
	CToolTipCtrl m_ToolTip;				// The link tooltip	

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplHyperLink)
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg LRESULT OnNcHitTest(CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


class CLASS_DECL_APL_GUI CaplMemDC : public CDC {
private:
	CBitmap m_bitmap; // Offscreen bitmap
	CBitmap* m_oldBitmap; // bitmap originally found in CaplMemDC
	CDC* m_pDC; // Saves CDC passed in constructor
	CRect m_rect; // Rectangle of drawing area.
	BOOL m_bMemDC; // TRUE if CDC really is a Memory DC.
public:
	CaplMemDC(CDC* pDC);
	~CaplMemDC();
	
	CaplMemDC* operator->() {return this;}// Allow usage as a pointer
	operator CaplMemDC*() {return this;}// Allow usage as a pointer
};

//*************************************************************************
//*************************************************************************
//*** CMenuComboBox window  ***********************************************
//*************************************************************************
//*************************************************************************

struct MenuComboBoxItem
{
	long id;
	CString text;
	bool can_select;
	CMenu *menu;
};

struct MenuComboBoxItemRelation
{	
	int in;
	int out;
};
	
class CLASS_DECL_APL_GUI CMenuComboBox : public CStatic
{
// Construction
public:
	CMenuComboBox();
	virtual ~CMenuComboBox();

// Attributes
public:
	void LoadFontFromWnd(CWnd *wnd);

protected:
	CFont *m_Font;
	CString m_SelText;
	long    m_SelId;
	RECT m_ButtonRect;
	int  m_FullTextWidth;
	bool m_ButtonPushed;
	bool m_ReadOnly;
	CArray <MenuComboBoxItem,MenuComboBoxItem&> m_ItemArray;
	CArray <MenuComboBoxItemRelation,MenuComboBoxItemRelation&> m_ItemRelations;

// Operations
public:
	bool SetSelID(long nID);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMenuComboBox)
	public:
	//}}AFX_VIRTUAL

// Implementation
public:
	void CreateMenu(CMenu &menu);
	void Clear();
	bool AddItemsRelation(long in, long out); //  id
	long AddItem(long id, LPCTSTR text, long parent=0,bool can_select=true);
	long GetSelId();
	LPCTSTR GetSelText();
	bool SetReadOnly( bool bReadOnly = true);

	// Generated message map functions
protected:
	bool m_ShowTollTip;

	//{{AFX_MSG(CMenuComboBox)
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
#ifndef	BTNST_OK
#define	BTNST_OK						0
#endif
#ifndef	BTNST_INVALIDRESOURCE
#define	BTNST_INVALIDRESOURCE			1
#endif
#ifndef	BTNST_FAILEDMASK
#define	BTNST_FAILEDMASK				2
#endif
#ifndef	BTNST_INVALIDINDEX
#define	BTNST_INVALIDINDEX				3
#endif
#ifndef	BTNST_INVALIDALIGN
#define	BTNST_INVALIDALIGN				4
#endif

class CLASS_DECL_APL_GUI CaplButton : public CButton
{
public:
    CaplButton();
	~CaplButton();

    enum	{	ST_ALIGN_HORIZ	= 0,			// Icon/bitmap on the left, text on the right
				ST_ALIGN_VERT,					// Icon/bitmap on the top, text on the bottom
				ST_ALIGN_HORIZ_RIGHT,			// Icon/bitmap on the right, text on the left
				ST_ALIGN_OVERLAP				// Icon/bitmap on the same space as text
			};

	enum	{	BTNST_COLOR_BK_IN	= 0,		// Background color when mouse is INside
				BTNST_COLOR_FG_IN,				// Text color when mouse is INside
				BTNST_COLOR_BK_OUT,				// Background color when mouse is OUTside
				BTNST_COLOR_FG_OUT,				// Text color when mouse is OUTside
				BTNST_COLOR_BK_FOCUS,			// Background color when the button is focused
				BTNST_COLOR_FG_FOCUS,			// Text color when the button is focused

				BTNST_MAX_COLORS
			};

	// ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CButtonST)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void PreSubclassWindow();
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

public:
	DWORD SetDefaultColors(BOOL bRepaint = TRUE);
	DWORD SetColor(BYTE byColorIndex, COLORREF crColor, BOOL bRepaint = TRUE);
	DWORD GetColor(BYTE byColorIndex, COLORREF* crpColor);

	DWORD SetCheck(int nCheck, BOOL bRepaint = TRUE);
	int GetCheck();

	DWORD SetURL(LPCTSTR lpszURL = NULL);
	void DrawTransparent(bool mode=true,BOOL bRepaint = FALSE);

	BOOL GetDefault();
	DWORD SetAlwaysTrack(BOOL bAlwaysTrack = TRUE);

	void SetTooltipText(int nText, BOOL bActivate = TRUE);
	void SetTooltipText(LPCTSTR lpszText, BOOL bActivate = TRUE);
	void ActivateTooltip(BOOL bEnable = TRUE);

	DWORD SetBtnCursor(int nCursorId = NULL, BOOL bRepaint = TRUE);

	DWORD SetFlat(BOOL bFlat = TRUE, BOOL bRepaint = TRUE);
	DWORD SetAlign(BYTE byAlign, BOOL bRepaint = TRUE);

	DWORD DrawBorder(BOOL bDrawBorder = TRUE, BOOL bRepaint = TRUE);
	DWORD DrawFlatFocus(BOOL bDrawFlatFocus, BOOL bRepaint = TRUE);

	DWORD SetIcon(int nIconIn, int nIconOut = NULL);
	DWORD SetIcon(HICON hIconIn, HICON hIconOut = NULL);

	DWORD SetBitmaps(int nBitmapIn, COLORREF crTransColorIn, int nBitmapOut = NULL, COLORREF crTransColorOut = 0);
	DWORD SetBitmaps(HBITMAP hBitmapIn, COLORREF crTransColorIn, HBITMAP hBitmapOut = NULL, COLORREF crTransColorOut = 0);

	DWORD SetMenu(UINT nMenu, HWND hParentWnd, BOOL bRepaint = TRUE);

	CToolTipCtrl* GetToolTip() { return &m_ToolTip; };

	static short GetVersionI()		{return 34;}
	static LPCTSTR GetVersionC()	{return (LPCTSTR)_T("3.4");}

protected:
    //{{AFX_MSG(CButtonST)
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSysColorChange();
	afx_msg BOOL OnClicked();
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnEnable(BOOL bEnable);
	afx_msg void OnCancelMode();
	afx_msg UINT OnGetDlgCode();
	//}}AFX_MSG

	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	virtual DWORD OnDrawBackground(CDC* pDC, LPCRECT pRect);
	virtual DWORD OnDrawBorder(CDC* pDC, LPCRECT pRect);

	BOOL		m_bIsFlat;			// Is a flat button?
	BOOL		m_bMouseOnButton;	// Is mouse over the button?
	BOOL		m_bDrawTransparent;	// Draw transparent?
	BOOL		m_bIsPressed;		// Is button pressed?
	BOOL		m_bIsFocused;		// Is button focused?
	BOOL		m_bIsDisabled;		// Is button disabled?
	BOOL		m_bIsDefault;		// Is default button?
	BOOL		m_bIsCheckBox;		// Is the button a checkbox?
	BYTE		m_byAlign;			// Align mode
	BOOL		m_bDrawBorder;		// Draw border?
	BOOL		m_bDrawFlatFocus;	// Draw focus rectangle for flat button?
	COLORREF	m_crColors[BTNST_MAX_COLORS];	// Colors to be used
	HMENU		m_hMenu;			// Handle to associated menu
	HWND		m_hParentWndMenu;	// Handle to window for menu selection
	BOOL		m_bMenuDisplayed;	// Is menu displayed ?
	BOOL		m_bIsBackground;	

protected:
	LRESULT OnSetStyle(WPARAM wParam, LPARAM lParam);
	LRESULT OnMouseLeave(WPARAM wParam, LPARAM lParam);

	void CancelHover();
	void FreeResources(BOOL bCheckForNULL = TRUE);
	void PrepareImageRect(BOOL bHasTitle, RECT* rpItem, CRect* rpTitle, BOOL bIsPressed, DWORD dwWidth, DWORD dwHeight, CRect* rpImage);
	HBITMAP CreateBitmapMask(HBITMAP hSourceBitmap, DWORD dwWidth, DWORD dwHeight, COLORREF crTransColor);
	void DrawTheIcon(CDC* pDC, BOOL bHasTitle, RECT* rpItem, CRect* rpTitle, BOOL bIsPressed, BOOL bIsDisabled);
	void DrawTheBitmap(CDC* pDC, BOOL bHasTitle, RECT *rItem, CRect *rCaption, BOOL bIsPressed, BOOL bIsDisabled);
	void PaintBk(CDC* pDC);

	void InitToolTip();

	HCURSOR		m_hCursor;			// Handle to cursor
	CToolTipCtrl m_ToolTip;			// Tooltip

	CDC			m_dcBk;
	CBitmap		m_bmpBk;

	BOOL		m_bAlwaysTrack;		// Always hilight button?
	int			m_nCheck;			// Current value for checkbox
	UINT		m_nTypeStyle;		// Button style

	TCHAR		m_szURL[_MAX_PATH];	// URL to open when clicked

#pragma pack(1)
	typedef struct _STRUCT_ICONS
	{
		HICON		hIcon;			// Handle to icon
		DWORD		dwWidth;		// Width of icon
		DWORD		dwHeight;		// Height of icon
	} STRUCT_ICONS;
#pragma pack()

#pragma pack(1)
	typedef struct _STRUCT_BITMAPS
	{
		HBITMAP		hBitmap;		// Handle to bitmap
		DWORD		dwWidth;		// Width of bitmap
		DWORD		dwHeight;		// Height of bitmap
		HBITMAP		hMask;			// Handle to mask bitmap
		COLORREF	crTransparent;	// Transparent color
	} STRUCT_BITMAPS;
#pragma pack()

	STRUCT_ICONS	m_csIcons[3];
	STRUCT_BITMAPS	m_csBitmaps[3];

	DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

/// ToolTip   (  )
class CLASS_DECL_APL_GUI CaplToolTip : public CWnd
{
// Construction
public:
	CaplToolTip();
	virtual ~CaplToolTip();

protected:

	static LPCTSTR m_pszWndClass; // Registered class name

	CDC m_orig_dc;		//   
	CBitmap m_orig_bmp;

	CDC m_tip_dc;		//  
	CBitmap m_tip_bmp;

	int m_x,m_y;	//    
	int m_cx,m_cy;
	int m_iMaxWidth; //  
	
	int m_timer_x, m_timer_y;
	CString m_timer_txt;


	CString m_txt;

	//CWnd  *m_pParentWnd; //   .

	UINT m_timer;


	virtual void CreateTip(CDC *dc, int screen_cx=0);
	bool MainShow(int x, int y, LPCTSTR txt); //  

public:

	CFont *m_pFont;			// ,  
	CWnd  *m_pFontWnd;		//     ,    .

	int m_delay_time;		//    Tooltip ().   0

	COLORREF m_txt_color;	//   (  )
	COLORREF m_fon_color;   //   (  )

	int m_text_x_paragr;	//     (  1)
	int m_text_y_paragr;	//    (  1)

	//  
	// iMaxWidth>0 -       bMaxWidth (  )
	// iMaxWidth==0   ,    (  ,   -  )
	bool Show(int x, int y, LPCTSTR txt, int iMaxWidth=0); 
	void Hide();                         //  

	bool IsShowed();		   //  true,     false,  
	bool GetRect(RECT &rect);  //   . true,     false,  

	bool IsNeedHideOnMessage(UINT msg); //  true, eckb     msg   ;

	//bool Attach(CWnd *wnd);
	//bool Detach();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplToolTip)
	//}}AFX_VIRTUAL

// Implementation
public:

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplToolTip)
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CSortableHeaderCtrl : public CHeaderCtrl
{
// Construction
public:
	CSortableHeaderCtrl();
	int  SetSortImage( int nCol, BOOL bAsc );
	int     m_nSortCol;
    BOOL    m_bSortAsc;
	CBitmap m_bmpArrowUp;
	CBitmap m_bmpArrowDown;
// Attributes
	CaplToolTip *m_ToolTip;

protected:
	CaplToolTip m_MyToolTip;
	CFont m_HighFont;
	CFont m_TextFont;
	//CFont *m_OriginalFont;  // ==0,   , !=0,  
	bool m_bUseMultiLine;
	//  ,    
	CRect m_TitledRect;

	// Operations
public:

	void SetAutoHigh(bool bUseMultiLine=true);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSortableHeaderCtrl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult);
	//}}AFX_VIRTUAL

// Implementation
public:
	void RemoveAllSortImages();
	void RemoveSortImage( int iItem );
	const int GetLastColumn() const;
	int m_iLastColumn;
	virtual ~CSortableHeaderCtrl();

	void MyDraw(LPDRAWITEMSTRUCT lpDrawItemStruct);

	// Generated message map functions
protected:
	//{{AFX_MSG(CSortableHeaderCtrl)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	afx_msg void OnEndtrack(NMHDR* pNMHDR, LRESULT* pResult);

	DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************

#define MINCOLWIDTH	       40   // M:18427
#define MAXCOLWIDTH	       600
#define MAX_COLUMNS	       64
#define MULTI_COLUMN_SORT  1
#define SINGLE_COLUMN_SORT 0


enum SORT_STATE{ DESCENDING, ASCENDING };
/////////////////////////////////////////////////////////////////////////////
// CMultiColumnSortListView view

class CLASS_DECL_APL_GUI CMultiColumnSortListView : public CListView
{
protected:
	CMultiColumnSortListView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CMultiColumnSortListView)
	
// Attributes
public:
	BOOL m_bUseAutoSave;

// Operations
public:
	void ReSort();//  ,      .
	void EnableSorting(bool enable);
	void SetUniqueName( LPCTSTR );
	int FindNumericColumnIndex( int );
	void UnsetColumnNumeric( int iCol );
	const int IsColumnNumeric( int ) const;
	void SetColumnNumeric( int );
	void SetColumnDate( int );
	void SetColumnTime(int Col);
	void SetColumnDTSpan(int iCol);
	void SetColumnWidth( int );
	void AutoSizeColumn( int iColumn );
	void AutoSizeAllColumns();
	const int GetRegColumnWidth( int ) const;
	int FindItemInCombedSortedList( int );
	
	void MoveItemInCombinedSortedListToEnd( int );
	
	void EmptyArray( int * );
	const int GetNumCombinedSortedColumns() const;
	
	void SetItemSortState( int, SORT_STATE );
	const SORT_STATE GetItemSortState( int ) const;

	bool NotInCombinedSortedColumnList( int iItem ) const;
	
	const int IsControlPressed() const;
	
	int  InsertColumn( int nCol, LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT, int nWidth = 1, int nSubItem = 1 );
	
	void SortColumn( int, bool = false, bool = false );

	int  LoadColumnWidths();
	void SaveColumnWidths();

	void SetHeaderAutoHigh(bool bUseMultiLine=true);
	
	UINT GetColumnCount();
	void DeleteAllColumns();
	void DeleteAllItems();
	const bool IsSorting() const;
	CString & GetUniqueName () { return m_strUniqueName ; } ;
	bool IsDefaultWidth () {return m_bNoRegColData ; } ;
	void SetAutoSizeMode (bool bMode) { m_bAutoSizeIfNoRegData = bMode ;} ;
	bool GetAutoSizeMode () { return m_bAutoSizeIfNoRegData ;} ;
	__int64       m_lColumnSortStates;
	int           m_aCombinedSortedColumns[MAX_COLUMNS];
	CUIntArray    m_aNumericColumns;
	CUIntArray    m_aDateColumns;
	CUIntArray    m_aTimeColumns;
	CUIntArray	  m_aDTSpanColumns;
	CImageList	  m_ilImageList;
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMultiColumnSortListView)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CMultiColumnSortListView();

	CFont m_my_font;

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	CString				m_strColumnWidthSection;
	CSortableHeaderCtrl m_ctlHeaderCtrl;	
	CString			    m_strUniqueName;
	bool				m_bAutoSizeOnInsert;
	bool				m_bSorting;
	bool				m_bEnableSorting;
	bool				m_bNoRegColData;
	bool				m_bAutoSizeIfNoRegData ;


	CaplToolTip m_ToolTip;
	CRect m_TitledRect;

	//        
	void SwapSelection();
	//   
	void SelectAll();

	//{{AFX_MSG(CMultiColumnSortListView)
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	afx_msg void OnHeaderClicked(NMHDR* pNMHDR, LRESULT* pResult) ;
	
	DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CSortListCtrl : public CListCtrl
{
	friend class CSortClass;
protected:
	int		m_iFillSortData;	//0 - ; 1 -  /; 2 - .
public:
	CSortListCtrl();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CSortListCtrl)
	
// Attributes
	bool m_AutoSaveColumnsWidth;

// Operations
public:

	BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);
	BOOL CreateFromStatic(UINT nID, CWnd* pParent,UINT additional_param=0);
	DWORD_PTR GetItemData(_In_ int nItem) const;
	BOOL SetItemData(_In_ int nItem, _In_ DWORD_PTR dwData);
	//BOOL SetItemDouble( int nItem, int nSubItem, double val,LPCSTR format=_T("%f"));

	void SetUniqueName( LPCTSTR );
	int FindNumericColumnIndex( int );
	void UnsetColumnNumeric( int iCol );
	const int IsColumnNumeric( int ) const;
	void SetColumnNumeric( int );
	void SetColumnDate( int );
	void SetColumnDateTime( int );// -: 27/02/2007 18:25:00
	void SetColumnTime(int Col);
	void SetColumnWidth( int );
	void AutoSizeColumn( int iColumn );
	void AutoSizeAllColumns();
	const int GetRegColumnWidth( int ) const;
	int FindItemInCombedSortedList( int );
	bool SetItemDisabled(int nItem); //   ItemData.  ItemData       -     
	bool GetItemDisabled(int nItem); 
	
	void MoveItemInCombinedSortedListToEnd( int );
	
	void EmptyArray( int * );
	const int GetNumCombinedSortedColumns() const;
	
	void SetItemSortState( int, SORT_STATE );
	const SORT_STATE GetItemSortState( int ) const;

	bool NotInCombinedSortedColumnList( int iItem ) const;
	
	const int IsControlPressed() const;
	
	int  InsertColumn( int nCol, LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT, int nWidth = 80, int nSubItem = 1 );
	BOOL DeleteColumn( int nCol );
		
	void SortColumn( int i, bool b = false );
	void ReSort();

	int  LoadColumnWidths();
	virtual void SaveColumnWidths();

	void SetHeaderAutoHigh(bool bUseMultiLine = true);
	
	UINT GetColumnCount();
	void DeleteAllColumns();
	void DeleteAllItems();
	const bool IsSorting() const;
	static bool& IsSortingEx();
	
	//  09.12.05
	int GetMainSortColumn() const;

	/**     .
	*/
	void SetRowHeight(int iHeight);

	//    .
	int GetRowHeight();
	
	/**       
		.
	*/
	void SetRowHeightVisibleColumns(int iColCount);

	void AllowToSort(bool bAllowToSortList) { m_SortableList = bAllowToSortList; };
	bool IsDefaultWidth () { return m_bNoRegColData ; } ;
	void SetAutoSizeMode (bool bMode) { m_bAutoSizeIfNoRegData = bMode ;} ;
	bool GetAutoSizeMode () { return m_bAutoSizeIfNoRegData ;} ;
protected:
	//CArray<CStringArray*, CStringArray&> m_dates;
	CFont m_my_font;

	__int64       m_lColumnSortStates;
	int           m_aCombinedSortedColumns[MAX_COLUMNS];
	CUIntArray    m_aNumericColumns;
	CUIntArray    m_aDateColumns;
	CUIntArray    m_aTimeColumns;
	CUIntArray    m_aDateTimeColumns;
	CImageList	  m_ilImageList;

	CaplToolTip m_ToolTip;
	CRect m_TitledRect;
	bool m_bNoRegColData ;
	bool				m_bAutoSizeIfNoRegData ;

	//     Owner-draw fixed
	int m_iRowHeight;		//  
	int m_nHighlight;		//  	

	void RepaintSelectedItems();

	CaplMap m_mDisabledItems;

public:
	
	enum EHighlight {HIGHLIGHT_NORMAL, HIGHLIGHT_ALLCOLUMNS, HIGHLIGHT_ROW};

// Overrides

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSortListCtrl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void PreSubclassWindow();
	virtual CString GetItemTextVirtual(const CPoint &point, int i = -1, int j = -1);
	//}}AFX_VIRTUAL

	void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) ;
	afx_msg LRESULT	OnSetFont(WPARAM wParam, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);


// Implementation
public:
	virtual ~CSortListCtrl();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	CString				m_strColumnWidthSection;
	CSortableHeaderCtrl m_ctlHeaderCtrl;	
	CString			    m_strUniqueName;
	bool				m_bAutoSizeOnInsert;
	bool				m_bSorting;
	bool				m_SortableList;
	static bool			m_bSortingEx;
	//{{AFX_MSG(CSortListCtrl)
	afx_msg void OnShowWindow( BOOL bShow, UINT nStatus );
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);	
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint pos);
	//}}AFX_MSG
	afx_msg void OnHeaderClicked(NMHDR* pNMHDR, LRESULT* pResult) ;
	afx_msg void MeasureItem ( LPMEASUREITEMSTRUCT lpMeasureItemStruct );
	afx_msg void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	afx_msg void OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);
	DECLARE_MESSAGE_MAP()
};

// *************************************************************************
// *************************************************************************
// *************************************************************************
/**   ListCtrl  
	@param list  
	@param file  
	@param report_header   
	@param force_save_all    : false -  ,
		    ,     -    ;
		true -        
	@param force_save_selected    : true -        
	 force_save_all==false  force_save_selected==false     -  
	  
	@param showSaveDlg          
	@param fieldSeparator   (  ',')
	 force_save_all==true  force_save_selected==true -    
	@param iOpenMode -    0 -  , 1 -  
			@return true<\b>     false<\b>   */
bool AFX_EXT_API apl_SaveListCtrlToFile(CListCtrl *list, const TCHAR *file, const TCHAR *report_header=0, 
										bool force_save_all=false,bool force_save_selected=false,
										bool showSaveDlg=true,const TCHAR *fieldSeparator=0,
										const TCHAR *initPath=0,bool saveHeader=true, CString *filePath=0, int iOpenMode = 0);	


/**   (direct==-1)    (direct==1)   ,    */
HTREEITEM AFX_EXT_API aplGetNextTreeItem(CTreeCtrl *tree, HTREEITEM hitem, int direct);

/**  f  */
bool AFX_EXT_API apl_CopyStr2Clipboard(LPCTSTR str);

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

#if defined(_SCB_MINIFRAME_CAPTION) && !defined(_SCB_REPLACE_MINIFRAME)
    #error "_SCB_MINIFRAME_CAPTION requires _SCB_REPLACE_MINIFRAME"
#endif

/////////////////////////////////////////////////////////////////////////
// CSCBDockBar dummy class for access to protected members

class CSCBDockBar : public CDockBar
{
    friend class CSizingControlBar;
};

/////////////////////////////////////////////////////////////////////////
// CSizingControlBar control bar styles

#define SCBS_EDGELEFT       0x00000001
#define SCBS_EDGERIGHT      0x00000002
#define SCBS_EDGETOP        0x00000004
#define SCBS_EDGEBOTTOM     0x00000008
#define SCBS_EDGEALL        0x0000000F
#define SCBS_SHOWEDGES      0x00000010
#define SCBS_SIZECHILD      0x00000020

/////////////////////////////////////////////////////////////////////////
// CSizingControlBar control bar

#ifndef baseCSizingControlBar
#define baseCSizingControlBar CControlBar
#endif

class CSizingControlBar;
typedef CTypedPtrArray <CPtrArray, CSizingControlBar*> CSCBArray;

class CLASS_DECL_APL_GUI CSizingControlBar : public baseCSizingControlBar
{
    DECLARE_DYNAMIC(CSizingControlBar);

// Construction
public:
    CSizingControlBar();

    virtual BOOL Create(LPCTSTR lpszWindowName, CWnd* pParentWnd,
        CSize sizeDefault, BOOL bHasGripper,
        UINT nID, DWORD dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP);
    virtual BOOL Create(LPCTSTR lpszWindowName, CWnd* pParentWnd,
        UINT nID, DWORD dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP);

// Attributes
public:
    const BOOL IsFloating() const;
    const BOOL IsHorzDocked() const;
    const BOOL IsVertDocked() const;
    const BOOL IsSideTracking() const;
    const BOOL GetSCBStyle() const {return m_dwSCBStyle;}

// Operations
public:
#if defined(_SCB_REPLACE_MINIFRAME) && !defined(_SCB_MINIFRAME_CAPTION)
    void EnableDocking(DWORD dwDockStyle);
#endif
    virtual void LoadState(LPCTSTR lpszProfileName);
    virtual void SaveState(LPCTSTR lpszProfileName);
    static void GlobalLoadState(CFrameWnd* pFrame, LPCTSTR lpszProfileName);
    static void GlobalSaveState(CFrameWnd* pFrame, LPCTSTR lpszProfileName);
    void SetSCBStyle(DWORD dwSCBStyle)
        {m_dwSCBStyle = (dwSCBStyle & ~SCBS_EDGEALL);}

// Overridables
    virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);

// Overrides
public:
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CSizingControlBar)
    public:
    virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz);
    virtual CSize CalcDynamicLayout(int nLength, DWORD dwMode);
    //}}AFX_VIRTUAL

// Implementation
public:
    virtual ~CSizingControlBar();
    
protected:
    // implementation helpers
    UINT GetEdgeHTCode(int nEdge);
    BOOL GetEdgeRect(CRect rcWnd, UINT nHitTest, CRect& rcEdge);
    virtual void StartTracking(UINT nHitTest, CPoint point);
    virtual void StopTracking();
    virtual void OnTrackUpdateSize(CPoint& point);
    virtual void OnTrackInvertTracker();
    virtual void NcPaintGripper(CDC* pDC, CRect rcClient);
    virtual void NcCalcClient(LPRECT pRc, UINT nDockBarID);

    virtual void AlignControlBars();
    void GetRowInfo(int& nFirst, int& nLast, int& nThis);
    void GetRowSizingBars(CSCBArray& arrSCBars);
    void GetRowSizingBars(CSCBArray& arrSCBars, int& nThis);
    BOOL NegotiateSpace(int nLengthTotal, BOOL bHorz);

public:

	CString	m_BarName;

    CSize   m_szHorz;
    CSize   m_szVert;
    CSize   m_szFloat;
    CSize   m_szMinHorz;
    CSize   m_szMinVert;
    CSize   m_szMinFloat;

	CWnd *GetSubWnd() {return m_subWnd;};
	void SetSubWnd (CWnd *wnd) {m_subWnd=wnd;};

protected:
    DWORD   m_dwSCBStyle;
    UINT    m_htEdge;

//    CSize   m_szHorz;
//    CSize   m_szVert;
//    CSize   m_szFloat;
//    CSize   m_szMinHorz;
//    CSize   m_szMinVert;
//    CSize   m_szMinFloat;
    int     m_nTrackPosMin;
    int     m_nTrackPosMax;
    int     m_nTrackPosOld;
    int     m_nTrackEdgeOfs;
    BOOL    m_bTracking;
    BOOL    m_bKeepSize;
    BOOL    m_bParentSizing;
    BOOL    m_bDragShowContent;
    UINT    m_nDockBarID;
    int     m_cxEdge;

	CWnd *m_subWnd;

// Generated message map functions
protected:
    //{{AFX_MSG(CSizingControlBar)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnNcPaint();
    afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
    afx_msg LRESULT OnNcHitTest(CPoint point);
    afx_msg void OnCaptureChanged(CWnd *pWnd);
    afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnNcLButtonDown(UINT nHitTest, CPoint point);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnWindowPosChanging(WINDOWPOS FAR* lpwndpos);
    afx_msg void OnPaint();
    afx_msg void OnClose();
    afx_msg void OnSize(UINT nType, int cx, int cy);
    //}}AFX_MSG
    afx_msg LRESULT OnSetText(WPARAM wParam, LPARAM lParam);

    DECLARE_MESSAGE_MAP()


#ifdef _SCB_REPLACE_MINIFRAME
    friend class CSCBMiniDockFrameWnd;
#endif //_SCB_REPLACE_MINIFRAME
};

#ifdef _SCB_REPLACE_MINIFRAME
#ifndef _SCB_MINIFRAME_CAPTION
/////////////////////////////////////////////////////////////////////////
// CSCBDockContext dockcontext

class CSCBDockContext : public CDockContext
{
public:
// Construction
    CSCBDockContext(CControlBar* pBar) : CDockContext(pBar) {}

// Drag Operations
    virtual void StartDrag(CPoint pt);
};
#endif //_SCB_MINIFRAME_CAPTION

/////////////////////////////////////////////////////////////////////////
// CSCBMiniDockFrameWnd miniframe

#ifndef baseCSCBMiniDockFrameWnd
#define baseCSCBMiniDockFrameWnd CMiniDockFrameWnd
#endif

class CLASS_DECL_APL_GUI CSCBMiniDockFrameWnd : public baseCSCBMiniDockFrameWnd
{
    DECLARE_DYNCREATE(CSCBMiniDockFrameWnd)

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CSCBMiniDockFrameWnd)
    public:
    virtual BOOL Create(CWnd* pParent, DWORD dwBarStyle);
    //}}AFX_VIRTUAL

// Implementation
public:
    CSizingControlBar* GetSizingControlBar();

    //{{AFX_MSG(CSCBMiniDockFrameWnd)
    afx_msg void OnNcLButtonDown(UINT nHitTest, CPoint point);
    afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
    afx_msg void OnWindowPosChanging(WINDOWPOS FAR* lpwndpos);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};
#endif //_SCB_REPLACE_MINIFRAME

/////////////////////////////////////////////////////////////////////////
// CSCBButton (button info) helper class

class CSCBButton
{
public:
    CSCBButton();

    void Move(CPoint ptTo) {ptOrg = ptTo; };
    CRect GetRect() { return CRect(ptOrg, CSize(11, 11)); };
    void Paint(CDC* pDC);

    BOOL    bPushed;
    BOOL    bRaised;

protected:
    CPoint  ptOrg;
};

/////////////////////////////////////////////////////////////////////////
// CSizingControlBar control bar

#ifndef baseCSizingControlBarG
#define baseCSizingControlBarG CSizingControlBar
#endif

class CLASS_DECL_APL_GUI CSizingControlBarG : public baseCSizingControlBarG
{
    DECLARE_DYNAMIC(CSizingControlBarG);

// Construction
public:
    CSizingControlBarG();

// Attributes
public:
    virtual BOOL HasGripper() const;

// Operations
public:

// Overridables
    virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);

// Overrides
public:
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CSizingControlBarG)
    //}}AFX_VIRTUAL

// Implementation
public:
    virtual ~CSizingControlBarG();
    
protected:
    // implementation helpers
    virtual void NcPaintGripper(CDC* pDC, CRect rcClient);
    virtual void NcCalcClient(LPRECT pRc, UINT nDockBarID);

protected:
    int     m_cyGripper;

    CSCBButton m_biHide;

// Generated message map functions
protected:
    //{{AFX_MSG(CSizingControlBarG)
    afx_msg LRESULT OnNcHitTest(CPoint point);
    afx_msg void OnNcLButtonUp(UINT nHitTest, CPoint point);
    //}}AFX_MSG

    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////
// CSizingControlBarCF

#ifndef baseCSizingControlBarCF
#define baseCSizingControlBarCF CSizingControlBarG
#endif

class CLASS_DECL_APL_GUI CSizingControlBarCF : public baseCSizingControlBarCF
{
    DECLARE_DYNAMIC(CSizingControlBarCF)

// Construction
public:
    CSizingControlBarCF();

// Overridables
    virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);

// Implementation
protected:
    // implementation helpers
    virtual void NcPaintGripper(CDC* pDC, CRect rcClient);

protected:
    BOOL    m_bActive; // a child has focus
    CString m_sFontFace;

// Generated message map functions
protected:
    //{{AFX_MSG(CSizingControlBarCF)
    //}}AFX_MSG
    afx_msg LRESULT OnSetText(WPARAM wParam, LPARAM lParam);

    DECLARE_MESSAGE_MAP()
};


//////////////////////////////////////////////////////////////////////////

class AFX_CLASS_EXPORT CaplSizingControlBarCF : public CSizingControlBarCF
{
    DECLARE_DYNAMIC(CaplSizingControlBarCF)
		// Construction
public:
    CaplSizingControlBarCF();
	
	// Overridables
	// Implementation
protected:
    // implementation helpers
    virtual void NcPaintGripper(CDC* pDC, CRect rcClient);
	
	// Generated message map functions
protected:
    //{{AFX_MSG(CaplSizingControlBarCF)
    //}}AFX_MSG
	
    DECLARE_MESSAGE_MAP()
};


class CLASS_DECL_APL_GUI CaplToolBar : public CToolBar
{
	DECLARE_DYNAMIC(CaplToolBar)

public:
	CaplToolBar();
	virtual ~CaplToolBar();

	//   
	BOOL LoadToolBar(LPCTSTR lpszResourceName);
	BOOL LoadToolBar(UINT nIDResource);

protected:
	DECLARE_MESSAGE_MAP()

	//   
	void TranslateToolbar();

	//   
	BOOL OnTtnNeedText(UINT id, NMHDR * pNMHDR, LRESULT * pResult);

public:
	afx_msg void OnPaint();
//	afx_msg void OnNcPaint();
//	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
class CLASS_DECL_APL_GUI CaplReBar: public CReBar
{
public:
	CaplReBar();
	~CaplReBar();
	void CreateLogoBar(CBitmap *bkbmp, COLORREF mask);
	void StartAnimation(bool bStart);

	void SetBitmap(CBitmap *bkbmp=0);

	void UpdateLogoBarVizible();

protected:
	bool b_logo_created;
	int m_logo_bar_width;
	CaplToolBar m_LogoBar;
	CImageList m_il;


	//   
	static int MaxButtonCount;
	int m_index;
	long m_Timer;

	int GetNoLogoBarsCount(int *logobar_id=0);

public:
	//{{AFX_MSG(CaplReBar)
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	afx_msg void OnSize(UINT nType, int cx, int cy);
//	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
//	afx_msg void OnNcPaint();
//	afx_msg void OnPaint();
//	afx_msg void OnPaint();
	afx_msg void OnRbnChildSize(NMHDR *pNMHDR, LRESULT *pResult);
};




//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplUIColors
{
public:

	static COLORREF m_color_bk_no_sel;		//    
	static COLORREF m_color_gradient;		//    ()
	static COLORREF m_color_bk_popup;   	//     popup menu
	static COLORREF m_color_bk_hotlite;		//    
	static COLORREF m_color_bk_sel;			//    
	static COLORREF m_color_ramka_sel;		//    
	static COLORREF m_color_text;			//  
	static COLORREF m_color_text_sel;		//    
	static COLORREF m_color_text_disabled;  //    

	static void SetScheme(int scheme); // 0 -  ;  1 - xp; 2 - ;

	static int GetCurScheme();
	static void SaveScheme();
	static void LoadScheme();

	static bool bUseGrarient; //    
	static bool bUseBitmap;   //     

	static CBitmap fon_tb;		   //     toolbar
	static CBitmap fon_menu_popup; //      popup 

protected:
	static int m_cur_scheme;   
};




// CaplMenu2 

//  
// 1.   m_icon_size
// 2.    (LoadToolbar)
// 3.    ,         CaplMenu::Install(this);
//     (,  OnCreate, InitDialog)
// 4.   MDI,    CMainFrame::OnUpdateFrameTitle   CaplMenu::UpdateMenu(GetMenu()); CaplMenu::SetMenuBk(this);
// 5.         CMenu.   Install   

class CLASS_DECL_APL_GUI CaplMenu : public CMenu
{
public:
	static CSize m_icon_size; //   

	static bool Install(CWnd *wnd); 
	static void UpdateMenu(CMenu *menu);
	static void DrawItem(CWnd *wnd, int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	static void MeasureItem(CWnd *wnd, int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	
	static void AddIcon(int cmd, HICON icon, bool b_NoWarningIfExist=false); // b_NoWarningIfExist -  ,    id   
	static void RemoveIcon(int cmd);
	static void LoadToolBar(CToolBar &tb, CImageList *il=0);
	static void LoadToolBar(UINT tb_id, UINT bmp_id=0);

	static void ResetColors(CWnd *mainwnd=0);

	static void SetMenuBk(CWnd *wnd);

protected:
	static CBrush m_brush_bk;
	static CBrush m_brush_bk_popup;
	static CFont m_fontMenu;
	static CImageList m_il;
	static CImageList m_il_grayed;
	static CMap <int,int,int,int> m_icons_map;

	static HMENU m_last_menu;

	static BOOL SubclassWindow(HWND hWnd);
	static LRESULT	CALLBACK	MyWndProc(HWND hWnd, UINT nMsg, WPARAM wParam, LPARAM lParam);

	static void DrawPopupMenuBk(CDC &dc, RECT &r1, RECT &r2);
};



//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
class CaplMaskedEditChar;

#define  MAX_CHARS  256

class CLASS_DECL_APL_GUI CaplMaskedEdit : public CEdit
{
public:
	CaplMaskedEdit();
	virtual ~CaplMaskedEdit();

    bool    Init(CString strMask, CString strInitialData = _T(""));
    bool    SetPromptChar(CString strPromptChar);

    void    SetData(const CString& data);
    CString GetData();

	//{{AFX_VIRTUAL(CaplMaskedEdit)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

public:
    bool    Parse(const CString& strMask);
protected:
    bool            m_bInit;
    CString         m_strPrompt;
    CaplMaskedEditChar*     m_Char[MAX_CHARS];
    int             m_iNumChars;
    int             m_iCurrentChar;
    bool            m_bShiftDown;
	bool			m_bEmptyMask;

    bool    SetValidChars(const CString& strMask);
    CString GetRange(CString szLow, CString szHigh);
    //CString GetText(bool bDataOnly = false);
    //CString GetData() { return GetText(true); }
    int     FindNextChar(int iStartPos, bool bStatic, bool bForward);

    //{{AFX_MSG(CaplMaskedEdit)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg	LRESULT	OnPaste( WPARAM, LPARAM );
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
    DECLARE_DYNCREATE(CaplMaskedEdit)
};

void AFXAPI DDX_CaplMaskedEdit(CDataExchange* pDX, int nIDC, CaplMaskedEdit& rControl, CString& data);

//    is_process  false -     ..  
//  WM_PAINT.    ILS.    NetStepData.
bool AFX_EXT_API guiSetGlobalProcessWmPaint(bool is_process);

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplSplitterBar : public CWnd
{
	DECLARE_DYNAMIC(CaplSplitterBar)

	enum DRAGFLAG { DRAG_ENTER=0, DRAG_EXIT=1, DRAGGING=2 };
protected:
	CRect	m_rectSplitter;
	CRect	m_rectDragPrev;
	CRect	m_rectDragCurt;
	BOOL	m_bDragging;

	CWnd	*m_pwndLeftPane;	//left pane window
	CWnd	*m_pwndRightPane;	//right pane window

	int		m_cxLeftMost;		//left most, relative to parent window
	int		m_cxRightMost;		//right most, relative to parent window

	BOOL	m_bHorizontal;
// Construction
public:
	CaplSplitterBar();
	BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, BOOL bHorizontal=FALSE);

// Attributes
public:
	BOOL IsCursorOverSplitter( const CPoint& ptCursor );

// Operations
public:
	void DrawDraggingBar(CPoint point,DRAGFLAG df=DRAGGING);
	void SetPanes(CWnd *pwndLeftPane,CWnd *pwndRightPane);
	void MovePanes();
	virtual BOOL OnEraseBkgnd(CDC* pDC);

	void UpdatePanesLimits(); //   

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSplitterBar)
	//}}AFX_VIRTUAL

// Implementation
public:
	void SetSizes(CRect r1, CRect r2);
	
	virtual ~CaplSplitterBar();

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplSplitterBar)
	afx_msg void OnPaint();
	afx_msg LRESULT OnNcHitTest(CPoint point);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
#ifndef __APL_SIZE_ANCHORS_
#define __APL_SIZE_ANCHORS_

const CSize
	NOANCHOR(-1,-1),
	TOP_LEFT(0,0), TOP_CENTER(50,0), TOP_RIGHT(100,0),
	MIDDLE_LEFT(0,50), MIDDLE_CENTER(50,50), MIDDLE_RIGHT(100,50),
	BOTTOM_LEFT(0,100), BOTTOM_CENTER(50,100), BOTTOM_RIGHT(100,100);
#endif

//////////////////////////////////////////////////////////////////////////
//     (   OnInitDialog)
class CLASS_DECL_APL_GUI CaplTranslateDialog : public CDialog
{
protected:
	CFont m_font;

	bool InitFont();
public:
	CaplTranslateDialog() {}
	CaplTranslateDialog(LPCTSTR lpszTemplateName, CWnd* pParentWnd = NULL);
	CaplTranslateDialog(UINT nIDTemplate, CWnd* pParentWnd = NULL);
	virtual BOOL OnInitDialog();
	BOOL CaplTranslateDialog::OnToolTipShow( UINT id, NMHDR * pNMHDR, LRESULT * pResult );

protected:
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CaplResizableDialog window


class CLASS_DECL_APL_GUI CaplResizableDialog : public CaplTranslateDialog
{
protected:
	bool bResizebleStyle;//    resizeble    .   ,    ""
// Construction
public:
	CaplResizableDialog();
	CaplResizableDialog(UINT nIDTemplate, CWnd* pParentWnd = NULL);
	CaplResizableDialog(LPCTSTR lpszTemplateName, CWnd* pParentWnd = NULL);

// Attributes
private:
	// flags
	BOOL m_bShowGrip;
	BOOL m_bUseMaxTrack;
	BOOL m_bUseMinTrack;
	BOOL m_bUseMaxRect;
	BOOL m_bEnableSaveRestore;

	// internal status
	CString m_sSection;			// section name and
	CString m_sEntry;			// entry for save/restore

	BOOL m_bInitDone;			// if all internal vars initialized

	SIZE m_szGripSize;			// set at construction time

	CRect m_rcGripRect;			// current pos of grip	

	POINT m_ptMinTrackSize;		// min tracking size
	POINT m_ptMaxTrackSize;		// max tracking size
	POINT m_ptMaxPos;			// maximized position
	POINT m_ptMaxSize;			// maximized size

	bool m_showTooltipOnDisableButtons;		//     ,  disabled

	class Layout
	{
	public:
		HWND hwnd;

		BOOL adj_hscroll;
		BOOL need_refresh;

		// upper-left corner
		CSize tl_type;
		CSize tl_margin;
		
		// bottom-right corner
		CSize br_type;
		CSize br_margin;
	
	public:
		Layout()
			: hwnd(NULL), adj_hscroll(FALSE), need_refresh(FALSE),
			tl_type(0,0), tl_margin(0,0),
			br_type(0,0), br_margin(0,0)
		{
		};

		Layout(HWND hw, SIZE tl_t, SIZE tl_m, 
			SIZE br_t, SIZE br_m, BOOL hscroll, BOOL refresh)
		{
			hwnd = hw;

			adj_hscroll = hscroll;
			need_refresh = refresh;

			tl_type = tl_t;
			tl_margin = tl_m;
			
			br_type = br_t;
			br_margin = br_m;
		};
	};

	CArray<Layout, Layout&> m_arrLayout;	// list of repositionable controls

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplResizableDialog)
	//}}AFX_VIRTUAL

	inline void ShowTooltipOnDisabledButtons(bool value) { m_showTooltipOnDisableButtons = value; };

// Implementation
public:
	virtual ~CaplResizableDialog();
	//      
	virtual bool ItemChange(NM_TREEVIEW* pNMTreeView){return true;};//  
	virtual bool CheckItem(){return true;};//       
    virtual bool Expand(UINT action){return true;};//  /
	virtual bool Expand(HTREEITEM hItem,UINT action){return true;};//  /
	virtual bool Expanded(HTREEITEM hItem,UINT action,HWND hWnd=NULL){return true;};// / 
	virtual void RefreshAllItems(){};//   
	virtual void Sort(int nCol){};// 
	virtual void RefreshItem(HTREEITEM hItem){};//  
	virtual void UpdateUserData(){};//  -    
	virtual void LbDown(UINT nFlags, CPoint point) {};//       
	virtual void LbDblClick(UINT nFlags, CPoint point) {};//   2     

// used internally
private:
	void Construct();
	void LoadWindowRect();
	void SaveWindowRect();
	void ArrangeLayout();
protected:
	void UpdateGripPos();

// callable from derived classes
//protected:
public:
	void InitOkCancelButton(CaplButton &okBtn, CaplButton &cancelBtn);

	bool ModifyAnchor(HWND wnd);
	void AddAnchor(HWND wnd, CSize tl_type,
		CSize br_type = NOANCHOR, bool bRefreshAlways = false);	// add anchors to a control
	void AddAnchor(UINT ctrl_ID, CSize tl_type,
		CSize br_type = NOANCHOR, bool bRefreshAlways = false)	// add anchors to a control
	{
		AddAnchor(::GetDlgItem(*this, ctrl_ID), tl_type, br_type, bRefreshAlways);
	};

	// remove an anchored control from the layout, given its HWND
	BOOL RemoveAnchor(HWND wnd);

	// remove an anchored control from the layout, given its ID
	BOOL RemoveAnchor(UINT ctrl_ID)
	{
		return RemoveAnchor(::GetDlgItem(*this, ctrl_ID));
	}

	void ShowSizeGrip(BOOL bShow);				// show or hide the size grip
	void SetMaximizedRect(const CRect& rc);		// set window rect when maximized
	void ResetMaximizedRect();					// reset to default maximized rect
	void SetMinTrackSize(const CSize& size);	// set minimum tracking size
	void ResetMinTrackSize();					// reset to default minimum tracking size
	void SetMaxTrackSize(const CSize& size);	// set maximum tracking size
	void ResetMaxTrackSize();					// reset to default maximum tracking size
	void EnableSaveRestore(LPCTSTR pszSection, LPCTSTR pszEntry);	// section and entry in app's profile

	void SetInitDone(){m_bInitDone=TRUE;};

	static BOOL CALLBACK GetBtnByPoint(HWND hWnd, LPARAM param);

// Generated message map functions

	//{{AFX_MSG(CaplResizableDialog)
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

protected:

	afx_msg LRESULT OnNcHitTest(CPoint point);
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
/////////////////////////////////////////////////////////////////////////////
// CaplTabCtrl
class CLASS_DECL_APL_GUI CaplTabCtrl : public CTabCtrl
{
// Construction
public:
	CaplTabCtrl();

// Attributes
public:

protected:
	
	//	id,       
	CArray<int,int>	m_iaExcludeIDs;
	//	  views,   
	CPtrArray		m_paTabs;

	CMapPtrToWord	m_mWinStates;

	void			ChangeCtrlsState(BOOL bShow);
	void			ChangeViewsState(int iShow);

// Operations
public:

	void			InitStates(void);

	void			ClearExcludeIDs(void);
	void			AddExcludeIDs(CArray<int,int>& caIDs);

	void			ClearTabs(void);
	void			AddTab(int iTab,CWnd* pWnd);
	BOOL			GetTabView(int iTab,CWnd*& pWndOut);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplTabCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplTabCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplTabCtrl)
	afx_msg BOOL OnSelchange(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
/////////////////////////////////////////////////////////////////////////////
// CaplResizablePropertySheet

const UINT RESIZE_LOCKLEFT        = 0x0001; // Distance to left is fixed
const UINT RESIZE_LOCKRIGHT       = 0x0002; // Distance to right is fixed
const UINT RESIZE_LOCKTOP         = 0x0004; // Distance to top is fixed
const UINT RESIZE_LOCKBOTTOM      = 0x0008; // Distance to bottom is fixed
const UINT RESIZE_SHOWHIDE        = 0x0010; // Show/hide if not fully visible

const UINT RESIZE_LOCKALL         = RESIZE_LOCKLEFT|RESIZE_LOCKRIGHT|RESIZE_LOCKTOP|RESIZE_LOCKBOTTOM;
const UINT RESIZE_LOCKTOPLEFT     = RESIZE_LOCKLEFT|RESIZE_LOCKTOP;
const UINT RESIZE_LOCKBOTTOMRIGHT = RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT;

class CLASS_DECL_APL_GUI CDlgItemResizer
{

public:

	CDlgItemResizer();
	virtual ~CDlgItemResizer();

	// Adds a control to the resize list
	void Add(CWnd* pControl,UINT uFlags);

	void Add(CWnd* pWnd,INT nCtrlID,UINT uFlags)
	{ Add(pWnd->GetDlgItem(nCtrlID),uFlags); }

	// Resizes the controls in the form
	void Resize(CFormView* pWnd);

	// Resizes the controls in the window
	void Resize(CWnd* pWnd);

	// Sets the original size of the parent
	void SetInitialSize(INT cx,INT cy)
	{ m_szInitial=CSize(cx,cy); }

	// Sets the original size of the parent
	void SetInitialSize(const CSize& size)
	{ m_szInitial=size; }

	// Returns the initial size
	CSize GetInitialSize() const
	{ return m_szInitial; }

protected:
	CPtrArray m_Controls;
	CSize m_szInitial;
};

class CLASS_DECL_APL_GUI CaplResizablePropertyPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CaplResizablePropertyPage)
//	DECLARE_DYNAMIC(CaplResizablePropertyPage)

public:
	CaplResizablePropertyPage();
	CaplResizablePropertyPage(UINT nIDTemplate,UINT nIDCaption=0);
	CaplResizablePropertyPage(LPCTSTR lpszTemplateName,UINT nIDCaption=0);

	~CaplResizablePropertyPage();

	CDlgItemResizer m_Resizer;

	virtual BOOL	SetAnchors(void);
	virtual BOOL	ValidateData(void);
	virtual BOOL	SaveData(void);


protected:

	// Generated message map functions
	//{{AFX_MSG(CaplResizablePropertyPage)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CLASS_DECL_APL_GUI CaplResizablePropertySheet : public CPropertySheet
{
	DECLARE_DYNAMIC(CaplResizablePropertySheet)

public:
	CaplResizablePropertySheet(UINT nIDCaption, CWnd *pParentWnd = NULL, UINT iSelectPage = 0);
	CaplResizablePropertySheet(LPCTSTR pszCaption, CWnd *pParentWnd = NULL, UINT iSelectPage = 0);

	virtual ~CaplResizablePropertySheet();

	// Returns the size/position of the page
	void			GetPageRect(RECT *pRect);

	//	    -       ID
	BOOL			SetCenterImage(int iID);


protected:

	CaplButton		m_btnOK,m_btnCancel;

	CBitmap			m_CenterBmp;
	CStatic			m_CenterBmpHolder;


	BOOL			InitButtons(void);
	BOOL			InitCenterImage(void);


	//{{AFX_VIRTUAL(CaplResizablePropertySheet)
	public:
	virtual BOOL OnInitDialog();
	protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CaplResizablePropertySheet)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnPaint();
	afx_msg void OnOK();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

	CDlgItemResizer m_Resize;
	CRect m_rcPage;
	CRect m_rcClient;
	CRect m_rcGripper;
};

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************



/////////////////////////////////////////////////////////////////////////////
// CaplRichEditCtrl window
#define WM_FONTUPDATE WM_USER+10
#define APL_RC_ALL SF_RTF
#define APL_RC_SELECTION SF_RTF|SFF_SELECTION

class CLASS_DECL_APL_GUI CaplRichEditCtrl : public CRichEditCtrl
{
// Construction
public:
	CaplRichEditCtrl();

// Attributes
public:
//	LPRICHEDITOLECALLBACK m_pRitchEditCallBack;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplRichEditCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	bool SelectionIsSubscribe();
	bool SelectionIsSuperscribe();
	void SetSubscribe();
	void SetSuperscribe();
	bool SetSelectionCharSet(BYTE charset);
	bool SelectFont();
	long GetSelectionFontSize();
	CString GetSelectionFontName();
	CStringArray m_saFontList;
	void GetSystemFonts(CStringArray &saFontList);
	void SetFontSize(int nPointSize);
	void SetFontName(CString sFontName);
	void SelectColor();
	bool ParagraphIsBulleted();
	void SetParagraphBulleted();
	bool ParagraphIsOrderList();
	void SetParagraphOrderList();

	PARAFORMAT GetParagraphFormat();
	
	bool ParagraphIsRight();
	bool ParagraphIsLeft();
	bool ParagraphIsCentered();
	bool ParagraphIsJustify();
	
	void SetParagraphRight();
	void SetParagraphLeft();
	void SetParagraphCenter();
	void SetParagraphJustify();/*  */
	
	CHARFORMAT GetCharFormat(DWORD dwMask = CFM_COLOR | CFM_FACE | CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_UNDERLINE);
	
	bool SelectionIsBold();
	bool SelectionIsItalic();
	bool SelectionIsUnderlined();
	bool SelectionIsStrikeouted();

	void SetSelectionBold();
	void SetSelectionItalic();
	void SetSelectionUnderlined();
	void SetSelectionStrikeouted();

	void SetSelectionBold(bool bold);
	void SetSelectionItalic(bool italic);
	void SetSelectionUnderlined(bool underline);
	void SetSelectionStrikeouted(bool strikeout);

	COLORREF SetSelectionTextColor(COLORREF color);

	void SetRTF(CString sRTF, UINT flags = APL_RC_ALL);
	CString GetRTF(UINT flags = APL_RC_ALL);
	virtual ~CaplRichEditCtrl();

	UINT OnGetDlgCode();
	void SetParagraphSpacePara1();
	void SetParagraphSpacePara15();
	// Generated message map functions
protected:
	//{{AFX_MSG(CaplRichEditCtrl)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
private:
		void SetCharStyle(int MASK, int STYLE, int nStart, int nEnd);
		static DWORD CALLBACK CBStreamIn(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb);
		static DWORD CALLBACK CBStreamOut(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG* pcb);
		static BOOL CALLBACK CBEnumFonts(LPLOGFONT lplf, LPTEXTMETRIC lptm, DWORD dwType, LPARAM lpData);
};
//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplOleMessageFilter : public COleMessageFilter
{
	virtual BOOL OnMessagePending( const MSG* pMsg );
};


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplSelectFolderDialog : public CFileDialog
{
	DECLARE_DYNAMIC(CaplSelectFolderDialog)

public:
	CaplSelectFolderDialog(BOOL bShowFilesInDir = FALSE, 
				LPCTSTR lpcstrInitialDir = NULL, 
				DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
				LPCTSTR lpszFilter = NULL, CWnd* pParentWnd = NULL);
	~CaplSelectFolderDialog();

	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;

	static WNDPROC m_wndProc;
	virtual void OnInitDone();

	virtual void OnFolderChange();
//	virtual void OnFileNameChange();

	void SetSelectedPath(LPCTSTR lpcstrPath);
	CString GetSelectedPath() const;

	void SetTitle(CString cstrTitle);

	virtual void DoDataExchange(CDataExchange* pDX);

protected:
	//{{AFX_MSG(CaplSelectFolderDialog)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	BOOL m_bShowFilesInDir;
	CString m_cstrPath;
	CEdit *m_pEdit;
	CString m_cstrTitle;
};

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplComboBox : public CComboBox
{
// Construction
public:
	CaplComboBox();

	//     
	void DeleteAllItems();

public:
	BOOL SetReadOnly( BOOL bReadOnly = TRUE );

	DECLARE_MESSAGE_MAP()
};

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplCheckComboBox : public CComboBox
{
public:
	CaplCheckComboBox();
	virtual ~CaplCheckComboBox();

	BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);

	void SetDropDownHeight();
	void GetDefaultDropRectHeight();

	virtual INT SetCheck(INT nIndex, BOOL bFlag);
	virtual BOOL GetCheck(INT nIndex);

	void SelectAll(BOOL bCheck = TRUE);

	void SetUnselectableString(CString str) { m_sUnselectable = str; };
	void SetAllCategoriesString(CString str) { m_sAllCategories = str; };
	void SelectAllCategoriesByFirstString();
	void UnSelectAllCategoriesByFirstString();

	void HideItemsCheckBoxes();
	void ShowItemsCheckBoxes();

	bool GetUseSpecialFirstString() { return m_bUseSpecialFirstString; };
	void SetUseSpecialFirstString(bool use) { m_bUseSpecialFirstString = use; }

	void InvalidateList();
	
protected:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplCheckComboBox)
protected:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CaplCheckComboBox)
	afx_msg LRESULT OnCtlColorListBox(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnGetText(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnGetTextLength(WPARAM wParam, LPARAM lParam);
	afx_msg virtual void OnDropDown();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

public:
	void RecalcText();

	HWND m_hListBox;
	bool m_bUseSpecialFirstString;
	bool m_bHideItemsCheckBoxes;

	CString m_strText;
	CString m_sUnselectable;
	CString m_sAllCategories;

	BOOL m_bTextUpdated;
	BOOL m_bItemHeightSet;

	int m_rctDropDownHeight;
};


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
class CLASS_DECL_APL_GUI CaplHtmlView : public CHtmlView 
{
public:
	CaplHtmlView();
	~CaplHtmlView();
	
	
	BOOL CreateFromStatic(UINT nID, CWnd* pParent);
	BOOL SetEditMode(bool mode=false);

	BOOL GetContents(CString &buf);
	BOOL SetContents(LPCTSTR text);
	BOOL AppendContents(LPCTSTR text);

	bool m_bAlwaysUseShellExecute;

	//   "  ShellExecute".   
	bool SetAlwaysUseShellExecute(bool mode); 

	BOOL Print();

	bool ExecCommand(DWORD command, VARIANT *vin=0, VARIANT *vout=0);
	BOOL CaplHtmlView::queryCommandValue(BSTR command); 

	void SetSelectionBold();
	void SetSelectionItalic();
	void SetSelectionUnderlined();
	void SetSelectionStrikeouted();
	void SetParagraphLeft();
	void SetParagraphCenter();
	void SetParagraphRight();
	void SetParagraphWidth();
	void SetSelectionColor();
	void SetOrderList();
	void SetUnOrderList();
	void SetFontSize(int fontsize);
	void SetFontName(LPCTSTR fontname);

	int GetSelectionFontSize();
	bool GetSelectionFontName(CString &font_name);

	void Cut();
	void Copy();
	void Paste();

	BOOL CanCopy();   //    ?
	BOOL CanPaste();  //    ?

	BOOL IsSelectionBold();
	BOOL IsSelectionItalic();
	BOOL IsSelectionUnderline();
	BOOL IsSelectionStrikeouted();
	BOOL IsParagraphLeft();
	BOOL IsParagraphCenter();
	BOOL IsParagraphRight();
	BOOL IsParagraphWidth();
	BOOL IsOrderList();
	BOOL IsUnOrderList();


	NMHDR m_nmh; //     EN_SELCHANGE  PostMessage

	void ReleseInterfaces();

	
	// Normally, CHtmlView destroys itself in PostNcDestroy,
	// but we don't want to do that for a control since a control
	// is usually implemented as a stack object in a dialog.
	//
	virtual void PostNcDestroy() {  }
	
	// overrides to bypass MFC doc/view frame dependencies
	afx_msg void OnDestroy();
	afx_msg int  OnMouseActivate(CWnd* pDesktopWnd,UINT nHitTest,UINT message);
	
	// override to trap "app:" pseudo protocol
	virtual void OnBeforeNavigate2( LPCTSTR lpszURL,
		DWORD nFlags,
		LPCTSTR lpszTargetFrameName,
		CByteArray& baPostedData,
		LPCTSTR lpszHeaders,
		BOOL* pbCancel );
	
	// override to handle links to "app:mumble...". lpszWhere will be "mumble"
	virtual void OnAppCmd(LPCTSTR lpszWhere);
	
	DECLARE_MESSAGE_MAP();
	DECLARE_DYNAMIC(CaplHtmlView)
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	protected:
		IHTMLDocument2 *m_pIHTMLDocument2;

		bool InitInterfaces();
};


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
class CLASS_DECL_APL_GUI CaplTextRotator
 {
  protected :
              HDC      m_hSourceDC;
              HDC      m_hRotatedMemDC;
              CRect    m_rectRotated;
              UINT     m_uiHorzAlignment;
              UINT     m_uiVertAlignment;
              UINT     m_uiAngle;
              BOOL     m_bDisabled;
              BOOL     m_bDrawBevelLine;
              CString  m_strText;
              COLORREF m_clrBackground;
              COLORREF m_clrText;

              void  AngleBlt(HDC hSourceDC, HDC hDestDC, RECT rectSource, UINT uiAngle);
              void  Clear();
              CSize GetLengthlyTextSize(HDC hDC, CStringArray *parrayText);

  public :
           CaplTextRotator(HDC hSourceDC, LPCTSTR lpszText = _T(""), UINT uiHorzAlignment = DT_LEFT, UINT uiVertAlignment = 0);
           virtual ~CaplTextRotator();

           BOOL BitBltText(int X, int Y);
           BOOL BitBltText(CRect rectSource);
           void GetRotatedDC(CDC *pDC);
           void GetRotatedRect(RECT *pstRect);
           BOOL RotateText(UINT uiAngle = 0);

           // INLINE
           HDC   GetRotatedDC()   { return m_hRotatedMemDC; }
           CRect GetRotatedRect() { return m_rectRotated; }

           void DrawBevelLine(BOOL bDraw)                        { m_bDrawBevelLine = bDraw; }
           void SetBackgroundColor(COLORREF clr)                 { m_clrBackground = clr; }
           void SetDisabledText(BOOL bDisable)                   { m_bDisabled = bDisable; }
           void SetHorzAlignment(UINT uiHorzAlignment = DT_LEFT) { m_uiHorzAlignment = uiHorzAlignment; }
           void SetText(LPCTSTR lpszText)                        { m_strText = lpszText; }
           void SetTextColor(COLORREF clr)                       { m_clrText = clr; }
           void SetVertAlignment(UINT uiVertAlignment = 0)       { m_uiVertAlignment = uiVertAlignment; }
 };

class CLASS_DECL_APL_GUI CaplStatic : public CStatic
{
  public :
           enum
            {
             HORZ_LEFT = 0x01,
             HORZ_CENTER = 0x02,
             HORZ_RIGHT = 0x04,
             VERT_TOP = 0x08,
             VERT_CENTER = 0x10,
             VERT_BOTTOM = 0x20
            };

  protected :
              COLORREF          m_clrBackColor;
              COLORREF          m_clrTextBackColor;
              COLORREF          m_clrTextColor;
              COLORREF          m_clrHightLight;
              COLORREF          m_clrSaveTextColor;
              HBRUSH            m_hBackBrush;
              BOOL              m_bForceNoOwnerDraw;
              BOOL              m_bUseDefaultBackColor;
              BOOL              m_bUseDefaultTextBackColor;
              BOOL              m_bUseDefaultTextColor;
              BOOL              m_bLink;
              BOOL              m_bUseBevelLine;
              BOOL              m_bUseHighLighting;
              BOOL              m_bVerticalText;
              BOOL              m_bInside;
              BOOL              m_bTextFlash;
              BOOL              m_bBackFlash;
              BOOL              m_bFlashTextState;
              BOOL              m_bFlashBackState;
              BOOL              m_bUseToolTip;
              BOOL              m_bUseHighLightingOnlyWithToolTip;
              BOOL              m_bBlockMessage;
              BOOL              m_bLowerCase;
              BOOL              m_bUpperCase;
              BOOL              m_bStretchBitmap;
              LOGFONT           m_stLF;
              CFont             m_cFont;
              HCURSOR           m_hCursor;
              HBITMAP           m_hBackImage;
              UINT              m_uiAlignment;
              UINT              m_uiAngle;
              CString           m_strText;
				
			  //  16.05.06 ZiloT
			  UINT              m_uiImageAlignment;
			  HBITMAP			m_hBackImageMask;

              void    DrawAlignedText(CDC *pDC, LPCTSTR lpszText, RECT stRect, UINT uiAlignment);
              int     GetWindowText(LPTSTR lpszStringBuf, int nMaxCount);
              void    GetWindowText(CString &rString);
              BOOL    IsMultiLineString(LPCTSTR lpszText);
              CString MakeVerticalText(LPCTSTR lpszText = NULL);
              BOOL    ReconstructFont();
              void    SetWindowText(LPCTSTR lpszString);
              void    TrackMouse(BOOL bHover, BOOL bLeave);

			  //  16.05.06 ZiloT
			  HBITMAP CreateBitmapMask(HBITMAP hSourceBitmap, DWORD dwWidth, DWORD dwHeight, COLORREF crTransColor);

  public :
           CaplStatic();
           virtual ~CaplStatic();

           static BOOL IsWindowsNT2000();

           // Color functions
           CaplStatic &SetBkColor(COLORREF clr = ::GetSysColor(COLOR_3DFACE));
           CaplStatic &SetDefaultBkColor();
           CaplStatic &SetDefaultTextBackColor();
           CaplStatic &SetDefaultTextColor();
           CaplStatic &SetHighLightColor(COLORREF clr = ::GetSysColor(COLOR_HIGHLIGHT));
           CaplStatic &SetTextBackColor(COLORREF clr = ::GetSysColor(COLOR_3DFACE));
           CaplStatic &SetTextColor(COLORREF clr = ::GetSysColor(COLOR_WINDOWTEXT));
           
           // Font functions
           CaplStatic &SetFontBold(BOOL bBold);
           CaplStatic &SetFontItalic(BOOL bItalic);
           CaplStatic &SetFontName(LPCTSTR szFaceName);
           CaplStatic &SetFontSize(int iSize);
           CaplStatic &SetFontUnderline(BOOL bUnderline);

           // Other functions
           CaplStatic &FlashBackground(BOOL bActivate, UINT uiTime = 500);
           CaplStatic &FlashText(BOOL bActivate, UINT uiTime = 500);

           void ForceNoOwnerDraw(BOOL bForce);

           BOOL    GetBorder();
           UINT    GetHorzAlignment();
           UINT    GetHorzAlignmentIndex();
           BOOL    GetSunken();
           CString GetText();
           UINT    GetVertAlignment();
           UINT    GetVertAlignmentIndex();

		   //  16.05.06 ZiloT
		   CaplStatic &SetImageAlignment(UINT uiAlign = HORZ_LEFT | VERT_TOP);

           CaplStatic &SetAlignment(UINT uiAlign = HORZ_LEFT | VERT_TOP);
           CaplStatic &SetAngle(UINT uiAngle = 0);

           CaplStatic &SetBackImage(UINT nID = -1);
		   CaplStatic &SetBackImage(UINT nID, COLORREF crTransColor);

           CaplStatic &SetBorder(BOOL bSet);
           CaplStatic &SetCursor(HCURSOR hCursor);
           CaplStatic &SetCursor(UINT uiCursorID);
           CaplStatic &SetDisabled(BOOL bSet);
           CaplStatic &SetLink(BOOL bSet);
           CaplStatic &SetLinkCursor(HCURSOR hCursor);
           CaplStatic &SetLinkCursor(UINT uiCursorID);
           CaplStatic &SetLowerCase(BOOL bSet);
           CaplStatic &SetText(LPCTSTR szText);
           CaplStatic &SetSunken(BOOL bSet);
           CaplStatic &SetUpperCase(BOOL bSet);
           CaplStatic &SetVerticalText(BOOL bSet);
           CaplStatic &StretchBitmap(BOOL bStretch);
           CaplStatic &UseBevelLine(BOOL bUse);
           CaplStatic &UseHighLighting(BOOL bUse);

           // INLINE
           COLORREF GetBkColor()             { return m_clrBackColor; }
           COLORREF GetHighLightColor()      { return m_clrHightLight; }
           COLORREF GetTextBackColor()       { return m_clrTextBackColor; }
           COLORREF GetTextColor()           { return m_clrTextColor; }
           BOOL     IsDefaultBkColor()       { return m_bUseDefaultBackColor; }
           BOOL     IsDefaultTextBackColor() { return m_bUseDefaultTextBackColor; }
           BOOL     IsDefaultTextColor()     { return m_bUseDefaultTextColor; }

           BOOL     GetFontBold()            { return ((m_stLF.lfWeight & FW_BOLD) == FW_BOLD) ? TRUE : FALSE; }
           BOOL     GetFontItalic()          { return m_stLF.lfItalic; }
           CString  GetFontName()            { return m_stLF.lfFaceName; }
           LONG     GetFontSize()            { return m_stLF.lfHeight; }
           BOOL     GetFontUnderline()       { return m_stLF.lfUnderline; }

           UINT     GetAlignment()                   { return m_uiAlignment; }
           UINT     GetAngle()                       { return m_uiAngle; }
           BOOL     GetBevelLine()                   { return m_bUseBevelLine; }
           BOOL     GetLink()                        { return m_bLink; }
           BOOL     GetVerticalText()                { return m_bVerticalText; }
           BOOL     IsBitmapStretched()              { return m_bStretchBitmap; }
           BOOL     IsDisabled()                     { return ((GetStyle() & WS_DISABLED) == WS_DISABLED); }
           BOOL     IsLowerCase()                    { return m_bLowerCase; }
           BOOL     IsToolTipUsed()                  { return m_bUseToolTip; }
           BOOL     IsUpperCase()                    { return m_bUpperCase; }

  public :
	//{{AFX_VIRTUAL(CNewLabel)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void PreSubclassWindow();
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

  protected :
	//{{AFX_MSG(CNewLabel)
	afx_msg void OnEnable(BOOL bEnable);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	afx_msg void OnPaint();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG

  DECLARE_MESSAGE_MAP()
};
//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

/////////////////////////////////////////////////////////////////////////////
// CaplTreeListCtrl window

#define UWM_TV_CHECKBOX    WM_APP   

class CLASS_DECL_APL_GUI CaplTreeListHeaderCtrl : public CHeaderCtrl
{
// Construction
public:
	struct SSortType
	{
		int nCol;
		BOOL bAscending;
	};

	CaplTreeListHeaderCtrl();

// Attributes
	CaplToolTip *m_ToolTip;

protected:
	CFont m_pFont;
	CImageList *m_pImageList;
	CMap< int, int, int, int> m_mapImageIndex;
	
	CaplToolTip m_MyToolTip;

	CPoint m_LastMouseMovePoint;

private:
	BOOL m_bAutofit;
	void Autofit(int nOverrideItemData = -1, int nOverrideWidth = 0);

// Operations
public:
	BOOL m_RTL;

	void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct );
	CImageList* SetImageList( CImageList* pImageList );

	int GetItemImage( int nItem );
	void SetItemImage( int nItem, int nImage );
	void SetAutofit(bool bAutofit = true) { m_bAutofit = bAutofit; Autofit(); }

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplTreeListHeaderCtrl)	
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void CalcWindowRect(LPRECT lpClientRect, UINT nAdjustType = adjustBorder);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplTreeListHeaderCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplTreeListHeaderCtrl)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#define WM_SELCHANGE WM_USER+51

#define APL_COLUMN_STRING 0
#define APL_COLUMN_DATE 1
#define APL_COLUMN_NUMERIC 2


class CLASS_DECL_APL_GUI CaplTreeListCtrl : public CTreeCtrl
{
protected:
	DECLARE_DYNAMIC(CaplTreeListCtrl)
public:	
	struct SSortType
	{
		int nCol;
		int ColType;
		BOOL bAscending;
		CaplTreeListCtrl *pmyTreeListCtrl; 
		bool m_bSortRoot;
	};

	class CTLItem
	{
	public:
		CStringArray m_strings;
		CArray<COLORREF, COLORREF> m_substring_color;		
	public:
		CTLItem();
		CTLItem(const CTLItem& copyItem);
		DWORD itemData;
		HTREEITEM m_parent_item;
		bool m_fictive;
		bool m_expanded;
		CString m_type;
		// visual attributes
		BOOL m_Bold;
		BOOL m_bCrossOutText;
		COLORREF m_Color;

		LPCTSTR GetSubstring(int m_nSub);
		CString GetItemText() { return GetSubstring(0); };
		void SetSubstring(int m_nSub, LPCTSTR m_sText);
		void InsertItem(LPCTSTR m_sText) { SetSubstring(0, m_sText);};
		void SetSubstringColor(int m_nSub, COLORREF color);
		COLORREF GetSubstringColor(int m_nSub);
	};

// Construction
public:
	CaplTreeListCtrl();

	// Attributes
protected:	
	int m_nColumns;
	int m_nColumnsWidth;
	int m_nItems;
	CDWordArray	m_dwaItems;
	CStringArray TreeLayout;
	UINT	m_nHoverTimerID;
	CArray<CTLItem*,CTLItem*> MemItemArray;
	COLORREF m_wndColor;

	bool m_bNoPaint;
	bool m_IsSingleSelect;
	bool m_needDeselectItem;

public:
	CaplTreeListHeaderCtrl m_wndHeader;
	CFont m_headerFont;
	CImageList m_cImageList;
	CImageList m_StatusImageList;
	CaplResizableDialog *m_dlg;

	int m_nOffset;

	enum CheckState{ NOSTATE = 0, UNCHECKED, CHECKED, CHILD_CHECKED, 
		SELF_AND_CHILD_CHECKED };
	enum CheckType{ CHECK, UNCHECK, TOGGLE, REFRESH };

	bool m_bShowHorLiles;		///<   
	bool m_bShowVerLiles;		///<   
	bool m_bAutoSizeLeftColumn; ///<        
	int m_nLeftColumnNum;       ///<    (  0)
	bool m_bSortRoot;           ///<   

	HTREEITEM m_LastSelectedItem;
	bool m_lButtonPressed;


// Operations
public:
	void DeselectAll(bool selected=true,bool droplited=true);
	BOOL SingleSelectItem(HTREEITEM hItem,bool is_select_parent=true);
	BOOL SelectItem(HTREEITEM hItem,bool ButtonDown=true);
	bool SetSelectMode(bool bSingleSelect = true);
	HTREEITEM GetNextSelectedItem(HTREEITEM hItem = NULL);
	bool GetListSelected(CArray<HTREEITEM,HTREEITEM> &list_selected);

	COLORREF GetSubItemColor(HTREEITEM hItem, int nCol);
	BOOL SetSubItemColor(HTREEITEM hItem, int nCol, COLORREF color, BOOL m_bInvalidate = TRUE);
	int GetColType(int Col);
	int SetColumnDate(int Col);
	int SetColumnNum(int Col);
	int GetColumnsNum() { return m_nColumns; };
	int GetColumnsWidth() { return m_nColumnsWidth; };
	int GetItemCount() { return m_nItems; };
	void RecalcColumnsWidth();
	
	void ResetVertScrollBar();

	HTREEITEM GetTreeItem(int nItem);
	int GetListItem(HTREEITEM hItem);

	int InsertColumn( int nCol, LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT, int nWidth = -1, int nSubItem = -1);
	int DeleteColumn(int nCol);
	void DeleteAllColumns();
	int GetColumnWidth(int nCol);
	int GetColumnAlign(int nCol);
	CTLItem* CaplTreeListCtrl::GetTLItem(HTREEITEM hItem);

	BOOL SetItemData(HTREEITEM hItem, DWORD dwData);
	DWORD GetItemData(HTREEITEM hItem) const;

	CString GetItemText( HTREEITEM hItem, int nSubItem = 0 );
	CString GetItemText( int nItem, int nSubItem );

	HTREEITEM InsertItem( LPCTSTR lpszItem, int nImage, int nSelectedImage, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM InsertItem(LPCTSTR lpszItem, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST,bool fictive=false);
	HTREEITEM InsertItem(UINT nMask, LPCTSTR lpszItem, int nImage, int nSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam, HTREEITEM hParent, HTREEITEM hInsertAfter );

	HTREEITEM CopyItem(HTREEITEM hItem, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM MoveItem(HTREEITEM hItem, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM CopyBranch(HTREEITEM hItem, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);

	bool IsItemFictive(HTREEITEM hItem);
	bool SetItemType(HTREEITEM hItem,CString &type);
	bool GetItemType(HTREEITEM hItem,CString &type);

	BOOL DeleteSubItems( HTREEITEM hItem );
	BOOL DeleteItem( HTREEITEM hItem );
	BOOL DeleteItem( int nItem );

	void MemDeleteAllItems(HTREEITEM hParent);
	BOOL DeleteAllItems();

	BOOL SetItemText( HTREEITEM hItem, int nCol ,LPCTSTR lpszItem);

	BOOL SetItemColor( HTREEITEM hItem, COLORREF m_newColor, BOOL m_bInvalidate = TRUE);
	BOOL SetItemBold( HTREEITEM hItem, BOOL m_Bold = TRUE, BOOL m_bInvalidate = TRUE );
	BOOL SetItemCrossOutText( HTREEITEM hItem, BOOL m_bCrossOutText = TRUE, BOOL m_bInvalidate = TRUE);

	static int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
	BOOL SortItems( int nCol, BOOL bAscending, HTREEITEM low);

	void DrawItemText (CDC* pDC, CString text, CRect rect, int nWidth, int nFormat);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplTreeListCtrl)	
	protected:
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL


// Implementation
public:	
	BOOL Expand( HTREEITEM hItem, UINT nCode );
	COLORREF SetBkColor(COLORREF nColor);
	HTREEITEM GetParentItem(HTREEITEM hItem);
	CString GetNextLine(CString &message);
	virtual ~CaplTreeListCtrl();
	int LoadColumnWidths();
	void SaveColumnWidths();
	void SetColumnWidth( int nCol );
	void SetColumnWidth( int nCol, int iWidth );
	const int GetRegColumnWidth( int iColumn ) const ;
	void AutoSizeColumn( int iColumn );
	void SetUniqueName(LPCTSTR lpszUniqueName);
	bool IsDefaultWidth () {return m_bNoRegColData ;} ;
	void SetAutoSizeMode (bool bMode) { m_bAutoSizeIfNoRegData = bMode ;} ;
	bool GetAutoSizeMode () { return m_bAutoSizeIfNoRegData ;} ;

	bool PaintAll(CDC &dc,int cx,int cy);
	bool PaintItem(HTREEITEM hItem, CDC &dc, int level, int &cur_y,int cx);

	// Generated message map functions
protected:
	CDWordArray m_numCols;
	CDWordArray m_dateCols;
	CString	    m_strUniqueName;
	CString		m_strColumnWidthSection;
	bool		m_AutoSaveColumnsWidth;
	bool		m_bNoRegColData;
	bool		m_bAutoSizeIfNoRegData ;
	//{{AFX_MSG(CaplTreeListCtrl)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDestroy();			
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);		
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);		
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);	
	afx_msg void OnClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTimer(UINT nIDEvent);	
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

};

class CLASS_DECL_APL_GUI CaplTreeListCtrlWithToolTip : public CaplTreeListCtrl
{
// Construction
public:
	CaplTreeListCtrlWithToolTip();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplTreeListCtrlWithToolTip)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplTreeListCtrlWithToolTip();

protected:
	CaplToolTip m_ToolTip; 
	CRect m_TitledRect;

	BOOL IsAppActive();

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplTreeListCtrlWithToolTip)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	afx_msg LONG OnContentChanged(UINT, LONG);

	DECLARE_MESSAGE_MAP()

};

#define APL_EXPAND_RECURSIVE 1
#define APL_EXPAND_LEVEL 2

class CLASS_DECL_APL_GUI CaplTreeListCtrlView : public CView
{
protected:
	int m_LastSortCol;
	BOOL m_bAscendingSort;
public: // create from serialization only

	CaplTreeListCtrlView();
	DECLARE_DYNCREATE(CaplTreeListCtrlView)

// Attributes
	
	UINT m_nImageId;
	CImageList m_cImageList;	

//attributes
public:
	BOOL m_RTL;
	CFont m_headerFont;
	CaplTreeListCtrlWithToolTip m_tree;
	CScrollBar m_horScrollBar;
	bool m_bAutofit;
	bool m_bUseCheckboxes;
	bool m_bUseEditlabels;
	bool m_bBreakTooltips;//   tooltip  
	bool n_bNoParentNotify;
	bool m_bManualInit;// true -     false -   .
private:	
	int m_IntervalTime;
	int m_CurrentProgress;
	BOOL m_TLInitialized;
	CString m_file_name;

// Operations
public:
	static LONG FAR PASCAL DummyWndProc(HWND, UINT, WPARAM, LPARAM);
	static CaplTreeListCtrlView *CreateTreeListView(CWnd *parent, RECT rect, int id);

	void Initialize();

public:
	//static void RegisterClass();	
	virtual void SortTree(int nCol, BOOL bAscending, HTREEITEM hParent);	
	virtual void SortTree(HTREEITEM hParent = TVI_ROOT);
	BOOL SetAscending(BOOL bAscending){BOOL bRet=m_bAscendingSort;m_bAscendingSort= bAscending;return bRet;}
	BOOL GetAscending(){return m_bAscendingSort;}
	int GetLastSortCol(){return m_LastSortCol;}
	void ResetScrollBar();

	BOOL VerticalScrollVisible();
	BOOL HorizontalScrollVisible();

	int StretchWidth(int m_nWidth, int m_nMeasure);
	bool SaveListDoc(bool all=true, const TCHAR *file=0, const TCHAR *report_header=0, bool bOnlyWithData=false, bool bOnlyExpanded=true, bool bChilds=false);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplTreeListCtrlView)
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual void OnInitialUpdate();		
	virtual void OnDraw(CDC* pDC);
	//}}AFX_VIRTUAL

// Implementation
public:
	void DeleteAllColumns();
	void Expand(HTREEITEM item, UINT flag = APL_EXPAND_RECURSIVE);
	virtual ~CaplTreeListCtrlView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	bool AppentItem2TextFile(HTREEITEM hItem, CString &txt, CString &razd, CString &spacer, bool bSelectdOnly, bool bOnlyWithData, int level, bool bOnlyExpanded=true, bool bChilds=false);

// Generated message map functions
protected:
	//{{AFX_MSG(CaplTreeListCtrlView)
	afx_msg int OnMouseActivate( CWnd* pDesktopWnd,UINT nHitTest,UINT message);
	afx_msg void OnSize(UINT nType, int cx, int cy);		
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);	    
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);	
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
};

#include <afxcview.h>

#define APL_FONT_DEFAULT		0
#define APL_FONT_ITALIC			1
#define APL_FONT_BOLD			2
#define APL_FONT_STRIKEOUT		4

#ifndef APL_TREE_CTRL_MAX_ICONS
#define APL_TREE_CTRL_MAX_ICONS 6 //    
#endif

#define IDX_IL_TREE_REL_TYPE	0
#define IDX_IL_TREE_EFF			1
#define IDX_IL_TREE_ITEM		2
#define IDX_IL_TREE_STATE		3
#define IDX_IL_TREE_OBJ_STATE	4
#define IDX_IL_TREE_ITEM_SUBTYPE	5


class CaplTreeItemDataFictive
{
public:
	CaplTreeItemDataFictive(){}
	virtual ~CaplTreeItemDataFictive(){}
};

class CLASS_DECL_APL_GUI CaplTreeItemData : public CaplTreeItemDataFictive
{
public:
	HTREEITEM m_item;	
	CTreeCtrl *m_tree;
	RECT m_text_rect;

	void *data;

	char font_style;
	COLORREF color;


	int icons[APL_TREE_CTRL_MAX_ICONS];

	CaplTreeItemData()
	{
		m_item=0; m_tree=0;
		data=0; font_style=0; 
		color=RGB(0,0,0);
		int i;
		for(i=0;i<APL_TREE_CTRL_MAX_ICONS;i++) icons[i]=-1;
	}
	virtual ~CaplTreeItemData(){};

	bool SetItemImage(int image,int index=-1, bool update=true)
	{
		//if(image<0) return false; //      
		if(m_tree==0) return false;
		if(m_item==0) return false;
		if(index>=APL_TREE_CTRL_MAX_ICONS) return false;

		if(index<0) m_tree->SetItemImage(m_item,image,image);
		else
		{
			icons[index]=image;
			if(update) m_tree->Invalidate();
		}
		return true;
	}

	virtual bool InsetItem(LPCTSTR text, int ico, HTREEITEM parent_item)
	{
		if(m_tree==0) 
			return false;
		m_item=m_tree->InsertItem(text,ico,ico,parent_item);
		m_tree->SetItemData(m_item,(DWORD)this);
		return true;
	}
    
	virtual bool RefreshItem(){return true;}
    virtual bool Expand(UINT action){return true;}
	virtual void ShowCmd(long cmd){return;}
};

class CLASS_DECL_APL_GUI CaplTreeView : public CTreeView
{
protected: // create from serialization only
	CaplTreeView();
	DECLARE_DYNCREATE(CaplTreeView)

	CaplToolTip m_ToolTip; 
	CRect m_TitledRect;

	CArray<HTREEITEM,HTREEITEM> m_SelectedItems;	//    
	
	bool m_bMultiSelect;				//    . FALSE  
//	bool m_bWithCtrl;

// Attributes
public:
	static	bool m_xp_mode;
	static	bool m_ShowSelectedOverIcons;

// Operations
public:
	CaplTreeItemData *GetSelectedItemData();

	bool CheckInSelectedArray(HTREEITEM hItem);		// ,    
	bool CheckForRange(HTREEITEM hItem, HTREEITEM selected);		// ,    Shift'a
	int GetCountOfSelect();						//  -  
	HTREEITEM GetSelectedInArray(int index);		//     
	void ChangeSelectedArray(HTREEITEM selected, bool isPressedCtrl, bool isPressedShift);		//    
	int GetItemIndexInArray(HTREEITEM hItem);		//       
	bool GetMultiSelect();							
	void SetMultiSelect(bool bMultiSelect);
	HTREEITEM GetNextItem(HTREEITEM hItem); 

	void SetIconsSize(int cx, int cy);
	void ResetFont();

	bool SetImageList(CImageList *il,int index);
	bool SetItemImage(HTREEITEM hItem, int image, int index=-1, bool update = true);

	static void SaveXpMode();
	static void LoadXpMode();

protected:
	int m_icon_width;
	CImageList m_il_empty;
	CFont m_fonts[8];
	CFont *m_default_font;

	int m_default_item_high;
	
	CImageList *m_ImageLists[APL_TREE_CTRL_MAX_ICONS];
	int m_ImagesHigh[APL_TREE_CTRL_MAX_ICONS];
	int m_ImagesWidth[APL_TREE_CTRL_MAX_ICONS];

	bool m_bNoPaint;
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplTreeView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnInitialUpdate();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CaplTreeView)
	afx_msg void CheckForExpand( NMHDR * pNotifyStruct, LRESULT * result );
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};


/////////////////////////////////////////////////////////////////////////////

class AFX_CLASS_EXPORT CaplDateTimeCtrl : public CDateTimeCtrl
{
	// Construction
public:
	CaplDateTimeCtrl();
	
	// Attributes
public:
	
	// Operations
public:
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplDateTimeCtrl)
public:
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	virtual ~CaplDateTimeCtrl();
	
	// Generated message map functions
protected:
	bool bDropDown;
	//{{AFX_MSG(CaplDateTimeCtrl)
	afx_msg void OnDatetimechange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDropdown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCloseup(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};

class CLASS_DECL_APL_GUI CaplListHeaderCtrl //: public CWnd
{
	friend class CaplSizingListCtrl; 
public:
	struct SSortType
	{
		int nCol;
		BOOL bAscending;
	};

	class CaplHeaderItem
	{
	public:
		LPCTSTR m_lpszColumnHeading;
		int m_nFormat;
		int m_nWidth;
		int m_cx;
		int m_cy;
		CStringArray m_rowText;
		CArray<CRect,CRect> m_itemRect;
		CArray<CRect,CRect> m_textRect;
		bool m_bBold;
		bool m_bItalic;
		COLORREF m_bgrColor;
		COLORREF m_textColor;
		COLORREF m_itemColor;
		long m_sortType;
		CArray<bool,bool> m_bShowTooltip;
		CaplHeaderItem() 
		{
			m_lpszColumnHeading=_T("");
			m_nFormat=0;
			m_nWidth=CaplListHeaderCtrl::m_defItemWidth;
			m_cx=2;
			m_cy=2;
			m_bBold=false;
			m_bItalic=false;
			m_bgrColor=CaplListHeaderCtrl::GetHeaderColor();//::GetSysColor(COLOR_BTNFACE);
			m_textColor=::GetSysColor(COLOR_WINDOWTEXT);
			m_itemColor=CaplListHeaderCtrl::GetHeaderColor();//m_headerColor;//::GetSysColor(COLOR_BTNFACE);
			m_sortType=APL_COLUMN_STRING;
		}
		CaplHeaderItem & operator = (const CaplHeaderItem &data)
		{
			m_lpszColumnHeading=data.m_lpszColumnHeading;
			m_nFormat=data.m_nFormat;
			m_nWidth=data.m_nWidth;
			m_bBold=data.m_bBold;
			m_bItalic=data.m_bItalic;
			m_bgrColor=data.m_bgrColor;
			m_textColor=data.m_textColor;
			m_itemColor=data.m_itemColor;

			m_bShowTooltip.RemoveAll();
			m_bShowTooltip.Append(data.m_bShowTooltip); 
			m_rowText.RemoveAll();
			m_rowText.Append(data.m_rowText); 
			m_itemRect.RemoveAll();
			m_itemRect.Append(data.m_itemRect);
			m_textRect.RemoveAll();
			m_textRect.Append(data.m_textRect);
			m_cx=data.m_cx;
			m_cy=data.m_cy;
			m_sortType=data.m_sortType;
			return *this;
		}
		CaplHeaderItem::CaplHeaderItem(CaplHeaderItem &copyItem)
		{
			m_lpszColumnHeading=copyItem.m_lpszColumnHeading;
			m_nFormat=copyItem.m_nFormat;
			m_nWidth=copyItem.m_nWidth;
			m_bBold=copyItem.m_bBold;
			m_bItalic=copyItem.m_bItalic;
			m_bgrColor=copyItem.m_bgrColor;
			m_textColor=copyItem.m_textColor;
			m_itemColor=copyItem.m_itemColor;

			m_bShowTooltip.RemoveAll();
			m_bShowTooltip.Append(copyItem.m_bShowTooltip); 
			m_rowText.RemoveAll();
			m_rowText.Append(copyItem.m_rowText);
			m_itemRect.RemoveAll();
			m_itemRect.Append(copyItem.m_itemRect);
			m_textRect.RemoveAll();
			m_textRect.Append(copyItem.m_textRect);

			m_cx=copyItem.m_cx;
			m_cy=copyItem.m_cy;
			m_sortType=copyItem.m_sortType;
		}
	};
	CaplListHeaderCtrl();

// Attributes
	CaplSizingListCtrl *m_view;
	CArray<CaplHeaderItem,CaplHeaderItem> m_headerItems;

	int m_defItemHeigth;
	int m_minItemWidth;
	static int m_defItemWidth;
	
	void Autofit(int nOverrideItemData = -1, int nOverrideWidth = 0);
	void PaintHeader(CDC &dc);
protected:
	static COLORREF m_headerColor;
	CFont *m_lFont;
	CImageList *m_pImageList;
	CMap< int, int, int, int> m_mapImageIndex;
	
	CPoint m_LastMouseMovePoint;

	int m_xIndent;
	int m_yIndent;
	int m_nRowsCount;
	int m_sumItemsHeight;
	
private:
	int m_nColumnsWidth;
	BOOL m_bAutofit;
	void DrawItemText(CDC &dc,int nCol,int nRow,int cx,int cy,bool bDraw=true);
// Operations
public:
	BOOL m_RTL;

	CImageList* SetImageList( CImageList* pImageList );

	int GetItemImage( int nItem );
	void SetItemImage( int nItem, int nImage );
	void SetAutofit(bool bAutofit = true) { m_bAutofit = bAutofit; Autofit(); }
	int InsertRow(int nRow);
	int AddItem( LPCTSTR lpszColumnHeading, int nFormat, int nWidth );
	BOOL DeleteItem( int nPos);
	void DeleteAllItems();
	bool SetHeaderItemText(int nRow,int nCol,LPCTSTR lpszText);
	bool SetHeaderColumnColor(int nCol,COLORREF color);
	bool SetHeaderColumnSortType(int nCol,long sort_type);
	long GetHeaderColumnSortType(int nCol);
	bool SetHeaderColumnTextColor(int nCol,COLORREF color);
	bool SetHeaderColumnTextBgrColor(int nCol,COLORREF color);
	int GetColumnWidth(int nCol);
	UINT GetColumnAlign(int nCol);
	int GetColumnsWidth() { return m_nColumnsWidth; };
	void RecalcColumnsWidth();
	static void SetHeaderColor(COLORREF color){m_headerColor=color;};
	static COLORREF GetHeaderColor() {return m_headerColor;};
	CaplHeaderItem* GetResizingColumn(CPoint &point);
	bool GetActiveItem(CPoint &point,int &nCol,int &nRow);

// Implementation
public:
	virtual ~CaplListHeaderCtrl();

};

#define HG_SINGLE_ITEM_SELECT 1
#define HG_MULTI_ITEM_SELECT 2
#define HG_ENTIRE_ROW_SELECT 4
#define HG_SUB_ITEMS_SELECT 8

class CLASS_DECL_APL_GUI CaplSizingListCtrl : public CScrollView
{
public:
	class CaplSizingListItem 
	{
		friend class CaplSizingListCtrl; 
		protected:
		    int m_iItem; 
			int m_iSubItem;
			CRect m_itemRect;
			CRect m_textRect;
			//BYTE m_itemState;
			bool m_bSelected;
			bool m_bShowTooltip;
		public:
			CaplSizingListCtrl *m_listCtrl;
			int m_cx; 
			int m_cy; 
			CString m_sText; 
			int m_iImage; //  
		    DWORD m_dData;
			COLORREF m_bgrColor;//  
			BOOL m_bBold;
			BOOL m_bItalic;
			COLORREF m_textColor;// 
			COLORREF m_itemColor;//  
		public:
			CaplSizingListItem();
			void SetDefaults();
			virtual ~CaplSizingListItem(){};
			int GetItemNum(){return m_iItem;};
			int GetSubItemNum(){return m_iSubItem;};
			CRect GetItemRect() { return m_itemRect; };
			
			CaplSizingListItem & operator = (const CaplSizingListItem &data)
			{
				m_bShowTooltip=data.m_bShowTooltip;
				m_listCtrl=data.m_listCtrl;
				m_cx=data.m_cx; 
				m_cy=data.m_cy; 
				m_iItem=data.m_iItem; 
				m_iSubItem=data.m_iSubItem; 
				m_sText=data.m_sText; 
				m_iImage=data.m_iImage; 
				m_dData=data.m_dData;
				m_bgrColor=data.m_bgrColor;
				m_bBold=data.m_bBold;
				m_bItalic=data.m_bItalic;
				m_textColor=data.m_textColor;
				m_itemRect=data.m_itemRect;
				m_itemColor=data.m_itemColor;
				//m_itemState=data.m_itemState;
				m_bSelected=data.m_bSelected;
				m_textRect=data.m_textRect;
				return *this;
			}		

	};

protected:
	CaplSizingListCtrl();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CaplSizingListCtrl)

// Attributes
public:
	UINT m_nImageId;
	CImageList m_cImageList;	// 
	CImageList *m_cImageItemList;	// 
	CFont *m_headerFont;
	int m_defItemHeigth;
	CFont *m_listFont;

	COLORREF m_wndColor;
	bool m_bShowDrawErrMsg;		//   
	bool m_bAlwaysUseDefaultColorForSelected; //     

// Operations
public:
	static CaplSizingListCtrl* CreateListCtrl(CWnd *parent, RECT rect, int id);
	CaplListHeaderCtrl* GetHeader() {return (CaplListHeaderCtrl*)&m_wndHeader;};
	void SetCtrlIndents(int cx,int cy);

	bool SetImageList(CImageList *cImageList);
	CImageList* GetImageList();

	bool SetItemIco(int nItem, int nSubItem, int ico = -1, bool bInvalidate = true);

	int AddColumn( LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT, int nWidth = -1,int nSubItem=-1);
	int GetColumnWidth(int nCol);
	UINT GetColumnAlign(int nCol);
	void RecalcColumnsWidth();
	int GetColumnsWidth() { return m_nColumnsWidth; };
	int GetColumnCount() { return m_nColumnsCount; };
	int GetItemCount() { return m_nRowsCount; };
	int InsertHeaderRow(int nPos,bool bInvalidate=true);
	bool SetHeaderItemText(int nRow,int nCol,LPCTSTR lpszText,bool bInvalidate=true);
	bool SetHeaderColumnColor(int nCol,COLORREF color,bool bInvalidate=true);
	bool SetHeaderColumnTextColor(int nCol,COLORREF color,bool bInvalidate=true);
	bool SetHeaderColumnTextBgrColor(int nCol,COLORREF color,bool bInvalidate=true);
	bool SetHeaderColumnSortType(int nCol,long sort_type);
	long GetHeaderColumnSortType(int nCol);

	void DeleteAllItems();
	int DeleteItem(int nItem);
	int DeleteColumn(int nCol);
	void DeleteAllColumns();
	
	BOOL SortItems( int nCol, BOOL bAscending);
	void ReSort();

	int GetCurSortColumn(){return m_curSortColumn;}
	BOOL GetCurSortAscending(){return m_bSortAscending;}

	bool EnableSort(bool bEnable); //  /  .   

	bool SetItemsCount(int nCount);
	
	int AddItem();
	int InsertItem(int nItem);

	bool SaveToFile(LPCSTR fname);
	bool GetHtml(CString &html); //  html   (  <table>)
	
	CaplSizingListCtrl::CaplSizingListItem* GetItem(int nItem, int nSubItem);
	CaplSizingListItem *GetItemByPoint(CPoint point);

	bool SetItem(int nItem, int nSubItem,CaplSizingListItem &lItem,BOOL bInvalidate=TRUE);
	bool SetItemText(int nItem, int nSubItem,LPCTSTR lpszText,BOOL bInvalidate=TRUE, BOOL bRecalcItemsRect=TRUE);
	bool SetItemData(DWORD dwData,int nItem, int nSubItem=-1);
	bool SetItemColor(COLORREF newColor,int nItem, int nSubItem=-1, BOOL bInvalidate = TRUE);
	bool SetItemTextColor(COLORREF newColor,int nItem, int nSubItem=-1, BOOL bInvalidate = TRUE);
	bool SetItemBkColor(COLORREF newColor,int nItem, int nSubItem=-1, BOOL bInvalidate = TRUE);
	bool SetItemBold(int nItem, int nSubItem=-1, BOOL bBold = TRUE, BOOL bInvalidate = TRUE );
	bool SetItemItalic(int nItem, int nSubItem=-1, BOOL bItalic = TRUE, BOOL bInvalidate = TRUE );

	DWORD GetItemData(int nItem, int nSubItem=0);
	CString GetItemText(int nItem, int nSubItem=0);
	bool EnsureVisible(int nItem);

	void DeselectAll(BOOL bInvalidate=true);
	//   
	// ,       nSubItem  
	bool SelectItem(int nItem, int nSubItem=-1,bool bSelect=true,BOOL bInvalidate=true);
	//   
	/**HG_SINGLE_ITEM_SELECT -    .      HG_MULTI_ITEM_SELECT
	   HG_MULTI_ITEM_SELECT -    .      HG_SINGLE_ITEM_SELECT
	   HG_ENTIRE_ROW_SELECT -     .     HG_SUB_ITEMS_SELECT
	   HG_SUB_ITEMS_SELECT -     .     HG_ENTIRE_ROW_SELECT**/
	bool SetSelectMode(BYTE flags);
	//  nItemsSelected   
	bool GetListSelected(CUIntArray &nItemsSelected);
	//  sItemsSelected     (   )
	bool GetListSelected(CArray<CaplSizingListItem*,CaplSizingListItem*> &sItemsSelected);
	int GetSelectedItemsCount();
	int GetFirstSelectedItem();

	bool RecalcItemsTextRect(CDC *pDC = 0, int nItem = -1);

	void GetOffsets(int &cx,int &cy);
	void SetCursorColor(COLORREF cursorColor,bool bInvalidate=true){m_highlightColor=cursorColor;if(bInvalidate) Invalidate();}
	void SetCursorTextColor(COLORREF cursorTextColor,bool bInvalidate=true){m_highlightTextColor=cursorTextColor;if(bInvalidate) Invalidate();}
	void SetLineColor(COLORREF lineColor,bool bInvalidate=true){m_lineColor=lineColor;if(bInvalidate) Invalidate();};
	COLORREF GetLineColor(){return m_lineColor;};
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplSizingListCtrl)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnInitialUpdate();     // first time after construct
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL
protected:

	int m_mode;
	bool m_bEnableSort;
	CaplToolTip *m_ToolTip;
	HCURSOR m_hCurCursor;
	HCURSOR m_hDefCursor;
	CaplListHeaderCtrl::CaplHeaderItem *m_resizingCol;
	int m_prev_drag_point_x;

	COLORREF m_highlightColor;
	COLORREF m_highlightTextColor;
	COLORREF m_lineColor;
	CFont *m_lFont;
	CFont *m_hFont;
	CaplListHeaderCtrl m_wndHeader;
	int m_nColumnsWidth;
	int m_nItemsHeight;
	int m_xIndent;
	int m_yIndent;
	
	CaplSizingListItem *m_items;
	CaplSizingListItem *m_sort_items;
	int m_nItemsCount;
	int m_nRowsCount;
	int m_nColumnsCount;
	int m_nItemsMaxCount;
	
	int m_oldSelItem;
	int m_oldSelSubItem;

	int m_curSortColumn;
	BOOL m_bSortAscending;


	BYTE m_btSelectMode;
	
	int GetItemIndex(int nItem, int nSubItem);
	void PaintItems(CDC &dc);
	void PaintGrid(CDC &dc);
	void DrawItemText(CDC &dc,CaplSizingListCtrl::CaplSizingListItem *lItem,int cx,int cy,bool bDraw=true);
	void DrawItemIco(CDC &dc, CaplSizingListCtrl::CaplSizingListItem *lItem, bool bDraw);
	virtual void OnSelChanged(int nItem,int nSubItem) {};
	LRESULT OnMouseLeave(WPARAM wParam, LPARAM lParam);
// Implementation
protected:
	virtual ~CaplSizingListCtrl();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CaplSizingListCtrl)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point); 
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point); 
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg LRESULT OnNcHitTest(CPoint point);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
};


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************

class CLASS_DECL_APL_GUI CaplSelectView : public CScrollView
{
protected: // create from serialization only
	CaplSelectView();
	DECLARE_DYNCREATE(CaplSelectView)

// Attributes
public:

	bool m_bTextBottom;  //  == true,    ,   
	bool m_bElementAsButton;  //  == true,     
	bool m_bAutoFitWidth; // == true,  RecalcSize     

	COLORREF m_color_bk;			//  
	
	COLORREF m_color_group_bk;			//   
	COLORREF m_color_group_head;		//   
	COLORREF m_color_group_head_sel;    //    
	COLORREF m_color_group_ramka;		//    
	
	COLORREF m_color_element_sel;		//    
	COLORREF m_color_element_sel_ramka; //     
	COLORREF m_color_element_hl;		//    

	COLORREF m_color_element_tl;		//       
	COLORREF m_color_element_br;		//       

	COLORREF m_color_txt_group_head;    //     
	COLORREF m_color_txt_element;		//    
	COLORREF m_color_txt_element_sel;	//    

	POINT m_roundpoint_element;		//    
	POINT m_roundpoint_group;       //       

	int m_iMargin;  //   

	
	bool SetColorSchema(int schema); //     
	
	void SetWindowsDefaultSchema();

	void UpdateGDI(); //       

	void RecalcSize(); //   .     .
	void CalcViewSize(CDC *dc, int cx, int &cy); //   RecalcSize
	void RecalcSize4ButttonStyle(); //    ""

	//  .  .     
	bool SetGroupImageList(CImageList *imagelist);
	bool SetElementImageList(CImageList *imagelist);

	//  .      
	bool SetGroupFont(CFont *font);
	bool SetElementFont(CFont *font, CFont *font_sel, CFont *font_highlight);

	static CaplSelectView *CreateSelectView( CWnd *parent ,LPRECT rect,int id, UINT WndStyle=WS_VISIBLE|WS_CHILD);	

	void Clear(); //  .

	//  
	int AddGroup(LPCTSTR txt,int ico=-1,long data=0);
	void SetGroupData(int iPos,void* pData);
	void GetGroupData(int iPos,void*& pData);

	void CloseGroup(int group, bool bClose);
	
	//  .    CaplSelectViewElement,       .
	int AddElement(int group, LPCTSTR txt, int ico, long data);
	void SetElementData(int iGroup,int iElement,void* pData);
	void GetElementData(int iGroup,int iElement,void*& pData);

	// /   ,   AddElement
	bool EnableElement(int element, bool bEnable);

	class CaplSelectViewElement;
	class CaplSelectViewGroup;

	void GetSelected(int &nGrp, int &nEl);
	bool SelectElement(CaplSelectView::CaplSelectViewElement* element);
	bool SelectGroup(CaplSelectView::CaplSelectViewGroup* group);
	bool SelectElement(long element_data);
	bool SelectPrevElement();
	bool SelectGroup(long element_data);
	bool Unselect();
	
	CaplSelectViewElement *GetCurSel(){ return m_sel_element;}

	CaplSelectViewGroup* Point2Group(CPoint& point);
	CaplSelectViewElement *Point2Element(CPoint point); //    
	
	bool DrawElement(CaplSelectViewElement *elem, CDC *pDC,bool bHighLigt=false, int dx=0, int dy=0);

protected:
	void CalcRectSize(CRect& drawrect, CRect& textrect, CPoint& ico_point, CDC* pDC, CFont* pFont, 
		CString& text, int& ico_cx, int& ico_cy, int &ico);
public:	
	class CaplSelectViewElement
	{
	public: 
		CaplSelectViewElement(LPCTSTR text, int ico, long data)
		{
			m_ico=ico;
			m_bEnable =true;
			m_text=text;
			m_data = data;

			m_drawrect = CRect(0,0,0,0);
			m_textrect = CRect(0,0,0,0);
			m_ico_point = CPoint(0,0);
		}

		virtual ~CaplSelectViewElement(){};
		
		//int m_cy;
		//int m_txt_cy;
		CString m_text;
		long m_data;

		int m_ico;

		bool m_bEnable;

		CRect m_drawrect;
		CRect m_textrect;
		CPoint m_ico_point;
	};

	class CaplSelectViewGroup
	{
	public: 

		CaplSelectViewGroup();
		CaplSelectViewGroup(LPCTSTR txt, int ico=-1,long data=0);

		virtual ~CaplSelectViewGroup();

		void	Clear();

		CString	m_text;
		//CIcon m_ico;

		void*	m_pData;
		long m_data;

		//int m_cx;
		int m_cy;
		int m_ico;

		bool	m_bDrawHeader;
		bool	m_bClosed; // true, 

		CRect m_drawrect;
		CRect m_elemrect;
		CRect m_textrect;	//    ""
		CPoint m_ico_point;	//    ""

		CArray <CaplSelectViewElement*,CaplSelectViewElement*> m_elements;
	};


	CArray <CaplSelectViewGroup*,CaplSelectViewGroup*> m_groups;
	CaplSelectViewGroup	m_NonGroupItemsGroup;

	CBrush m_brush_group_bk;
	CBrush m_brush_group_head;
	CBrush m_brush_group_sel_head;
	CBrush m_brush_element_sel;
	CBrush m_brush_element_hl;

	CFont m_fontGroup;
	CFont m_fontElement;
	CFont m_fontElementSel;
	CFont m_fontElementHL;

	CImageList m_il_group;
	CImageList m_il_elements;

	protected:

	CaplSelectViewElement *m_sel_element;       //   
	CaplSelectViewElement *m_prev_sel_element;       //   
	CaplSelectViewElement *m_last_hl_element;

	CaplSelectViewGroup* m_SelectedGroup;	//    ""
	CaplSelectViewGroup* m_HighLightGroup;	//    ""

	HCURSOR m_curCursor;
	HCURSOR m_DefCursor;
	HCURSOR m_HLCursor;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplSelectView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplSelectView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CaplSelectView)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#define SVW_CANCEL			0
#define SVW_NONE			1
#define SVW_CONTINUELOOP	2
#define SVW_STOPLOOP		4

#define SVW_MM_BEGIN		8
#define SVW_MM_STOP			16

class CaplSelectElemWnd : public CWnd
{
// Construction
public:
	CaplSelectElemWnd();
	DECLARE_DYNCREATE(CaplSelectElemWnd);

// Attributes
public:
	CaplSelectView* m_viewWnd;
	CaplSelectView::CaplSelectViewGroup* m_group;
	CaplSelectView::CaplSelectViewElement* m_SelectedElement;
	CaplSelectView::CaplSelectViewElement* m_HighLightElement;
private:
	int m_Flag;
	int m_nSelectResult;
	CPoint m_LLPoint;
	
	int m_ix;
	int m_iy;
	int m_icx;
	int m_icy;

// Operations
public:
	CaplSelectView::CaplSelectViewElement* GetElementByPoint(CPoint &point);
	CPoint &GetLastPoint();
	long ShowElements();
	void SetSizes();
	BOOL Continue();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplSelectElemWnd)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplSelectElemWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplSelectElemWnd)
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
// CXColourPopup messages
#define CPN_SELCHANGE        WM_USER + 1001        // Color Picker Selection change
#define CPN_DROPDOWN         WM_USER + 1002        // Color Picker drop down
#define CPN_CLOSEUP          WM_USER + 1003        // Color Picker close up
#define CPN_SELENDOK         WM_USER + 1004        // Color Picker end OK
#define CPN_SELENDCANCEL     WM_USER + 1005        // Color Picker end (cancelled)

// To hold the colors and their names
typedef struct
{
	COLORREF	crColor;
	TCHAR *		szName;
	int			nSystemColor;
} CaplColorTableEntry;

/////////////////////////////////////////////////////////////////////////////
// CXColourPopup window

class CaplColourPopup : public CWnd
{
// Construction
public:
	CaplColourPopup();

	CaplColourPopup(CWnd * pParentWnd,
				CPoint p,
				COLORREF crColor = RGB(255,255,255),
				COLORREF * pCustomColors = NULL,
				int nSelectedRow = -1,
				int nSelectedCol = -1,
				LPCTSTR szCustomText = NULL);

	virtual ~CaplColourPopup();

// Attributes
public:

// Operations
public:
	BOOL Create(CPoint p, COLORREF crColor, CWnd * pParentWnd,
		LPCTSTR szCustomText = NULL);

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplColourPopup)
public:
	virtual BOOL PreTranslateMessage(MSG * pMsg);
	//}}AFX_VIRTUAL

// Implementation
protected:
	void Init();
	BOOL GetCellRect(int row, int col, const LPRECT & rect);
	void SetWindowSize();
	void CreateToolTips();
	void ChangeSelection(int row, int col);
	void EndSelection(int nMessage);
	void DrawCell(CDC * pDC, int row, int col);
	COLORREF GetColor(int row, int col)
	{
		return (0x00FFFFFF & m_crColors[row * m_nNumColumns + col].crColor);
	}
	void SetColor(int row, int col, COLORREF rgb)
	{
		m_crColors[row * m_nNumColumns + col].crColor = rgb;
	}
	LPCTSTR GetColorName(int row, int col)
	{
		return m_crColors[row * m_nNumColumns + col].szName;
	}

	// protected attributes
protected:
	static CaplColorTableEntry m_crColors[];
	COLORREF *     m_pCustomColors;
	int            m_nNumColors;
	int            m_nNumColumns, m_nNumRows;
	int            m_nBoxSize, m_nMargin;
	int            m_nCurrentRow, m_nCurrentCol;
	int            m_nSelectedRow, m_nSelectedCol;
	BOOL           m_bShowCustom;
	CString        m_strCustomText;
	CRect          m_TextRect, m_WindowRect, m_DividerRect;
	CFont          m_Font;
	COLORREF       m_crInitialColor, m_crColor;
	CToolTipCtrl   m_ToolTip;
	CWnd *         m_pParent;

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplColourPopup)
	afx_msg void OnNcDestroy();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CLASS_DECL_APL_GUI CaplColorStatic : public CStatic
{
// Construction
public:
	CaplColorStatic();
	virtual ~CaplColorStatic();

// Attributes
public:
	void SetBackgroundColor(COLORREF rgb, BOOL bRedraw = TRUE);
	void SetTextColor(COLORREF rgb, BOOL bRedraw = TRUE);
	void SetBold(BOOL bFlag, BOOL bRedraw = TRUE);
	void SetFont(LPCTSTR lpszFaceName, int nPointSize, BOOL bRedraw = TRUE);
	void SetFont(LOGFONT * pLogFont, BOOL bRedraw = TRUE);
	void SetFont(CFont *pFont, BOOL bRedraw = TRUE);
	void SetIcon(HICON hIcon, BOOL bRedraw = TRUE);
	void SetMargins(int x, int y) { m_nXMargin = x; m_nYMargin = y; }

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplColorStatic)
protected:
    virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
protected:
	CFont		m_font;
	COLORREF	m_rgbText;
	COLORREF	m_rgbBackground;
	CBrush *	m_pBrush;
	BOOL		m_bBold;
	int			m_nXMargin, m_nYMargin;
	HICON		m_hIcon;

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplColorStatic)
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

void AFX_EXT_API DDX_ColorPicker(CDataExchange * pDX, int nIDC, COLORREF & crColor);
void AFX_EXT_API DDX_ColorPickerCustom(CDataExchange * pDX, int nIDC, CString & strCustomColors);

class CLASS_DECL_APL_GUI CaplColourPicker : public CButton
{
	DECLARE_DYNCREATE(CaplColourPicker);

// Construction
public:
	CaplColourPicker();
	virtual ~CaplColourPicker();

// Attributes
public:
	int m_nSelectedRow, m_nSelectedCol;
	void SetColor(COLORREF crColor);
	COLORREF GetColor();
	void SetCustomColors(COLORREF * pCustomColors);
	void GetCustomColors(COLORREF * pCustomColors);
	void SetCustomColors(LPCTSTR lpszCustomColors);
	CString GetCustomColors();

// Operations
public:

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplColourPicker)
public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
protected:
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
protected:
	CSize GetArrowSize();

	// protected attributes
protected:
	BOOL	 m_bTrackSelection;
	COLORREF m_crColor;
	COLORREF m_crEnabledColor;
	COLORREF m_CustomColors[16];
	CRect    m_ArrowRect;

	COLORREF m_DefaultColor;
	BOOL	m_bPopupActive;

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplColourPicker)
	afx_msg BOOL OnClicked();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnEnable(BOOL bEnable);
	//}}AFX_MSG
	afx_msg LONG OnSelEndOK(WPARAM wParam, LPARAM lParam);
	afx_msg LONG OnSelEndCancel(WPARAM wParam, LPARAM lParam);
	afx_msg LONG OnSelChange(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

/**     ( ,   )
	  :
		     - '.'
		-    - 6
		-   - 6
		   
		   
*/
class CLASS_DECL_APL_GUI CaplNumEdit : public CEdit
{
	DECLARE_DYNAMIC(CaplNumEdit)

public:
	CaplNumEdit();
	virtual ~CaplNumEdit();

	enum aplErrorCode
	{
		aplNone = -1,

		//    
		aplNegativeValue,

		//    
		aplDecimalValue,

		//       
		aplMaxDigitsAfterDecimal,

		//     
		aplMaxDigits,

		//   ,   
		aplStringValue,

		/*	  
			,      
			 
		*/
		aplInvalidFormat,
	};

	void SetToolTipTitle(const TCHAR* sTitle, int iIconType = 3);

	//       
	void ShowToolTips(bool bShow = true) { m_bUseToolTips = bShow; }

	//  -    
	void SetDecimalChar(UINT chChar) { m_chDecimalChar = chChar; }

	//    
	void AllowNegativeValues(bool bAllow = true) { m_bAllowNegativeValues = bAllow; }

	//    
	void AllowDecimalValues(bool bAllow = true);

	//      
	void SetMaxDigitsAfterDecimal(int iCount);

	//     
	void SetMaxIntDigits(int iCount);

	/**        
		WM_MOVE .
	*/
	void OnParentMove();

	//   
	void ChangeErrorCodeDescr(aplErrorCode eCode, const CString& sDescr);

protected:
	DECLARE_MESSAGE_MAP()

	//      
	bool	m_bAllowNegativeValues;

	//        :)
	bool	m_bInputValid;

	//    
	UINT	m_chDecimalChar;

	// -     
	int		m_iDigitsAfterDecimal;

	// -  ( ,    )
	int		m_iMaxIntDigits;

	int		m_eErrorCode;

	CToolTipCtrl m_ToolTip;
	bool m_bTTVisible;
	bool m_bUseToolTips;

	CStringArray m_ErrorDescr;

	UINT		m_nTimer;
	int			m_nShowDelay;

	virtual bool ValidateChar(UINT nChar);
	virtual bool ValidateString(const TCHAR* sStr, bool bReplace = true);

	void CreateToolTip (CWnd *pParent, const TCHAR *pszText,
		const int iIconType, const TCHAR *pszTitle);

	void DisplayToolTip(bool bDisplay);
	void SetToolTipText(const TCHAR *pszText);

public:

	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg	LRESULT	OnPaste( WPARAM, LPARAM );
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	
protected:

	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnTimer(UINT nIDEvent);

public:
	virtual void PreSubclassWindow();
};


class CLASS_DECL_APL_GUI CaplStateDlg
{
protected:	

	CDialog *pDlg;
public:

	CaplStateDlg();
	~CaplStateDlg();

	void Create(LPCTSTR header=0);  //  (      )
	void Show(LPCTSTR header=0, LPCTSTR text=0);    //  ( )
	void Hide();	//  (   )
	void Repaint(); // 

	void SetText(LPCTSTR text);
	void SetRange(int nLower, int nUpper );
	void SetPos( int nPos );

	CStatic *GetTextCtrl();
};

class CLASS_DECL_APL_GUI CaplShowProgress
{
public:

	CaplShowProgress() {m_Thread = 0;};
	~CaplShowProgress() {};

	bool SetUserBreakText(LPCTSTR break_text);
	bool Show(LPCTSTR title, LPCTSTR text);
	bool SetTitle(LPCTSTR title);
	bool IncreaseValue(int val);
	bool SetValue(int val);
	bool SetText(LPCTSTR text);
	bool DisableBreakButton();
	bool IsCanceledByUser();
	bool Close();

protected:

	long m_Thread;
	CString m_sBreakText;
};


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*************************************************************************
//     VERSION
// appFName -    (exe  dll)
// field_name -  
// buffer -    
void AFX_EXT_API GetVersionString(LPCTSTR appFName, LPCTSTR field_name, CString &buffer);

//     VERSION
// module -  (     - 0 )
// field_name -  
// buffer -    
void AFX_EXT_API GetVersionString(HMODULE module, LPCTSTR field_name, CString &buffer);

long AFX_EXT_API aplStartWaitDlg(LPCTSTR text, LPCTSTR title=NULL, bool setPos = false, HWND windowPos = HWND_TOPMOST);
void AFX_EXT_API aplSetTextWaitDlg(long thread, LPCTSTR text=NULL, LPCTSTR title=NULL);
void AFX_EXT_API aplShowWaitDlg(long thread, BOOL bShow);
void AFX_EXT_API aplEndWaitDlg(long thread);

/**     About
	logo_icon -  ,     
	text -  
	title -   .   " ".
*/

//  
//   !!!!!!!!!!!!!!

#define APLSTDICO_COUNT  39

#define APLSTDICO_OK			0
#define APLSTDICO_CANCEL		1
#define APLSTDICO_PLUS			2
#define APLSTDICO_MINUS			3
#define APLSTDICO_QUERY			4
#define APLSTDICO_INFO			5
#define APLSTDICO_PLAY			6
#define APLSTDICO_REVERSE_PLAY	7
#define APLSTDICO_BLUE_STAR		8
#define APLSTDICO_BLUE_CANCEL	9
#define APLSTDICO_BLUE_OK		10
#define APLSTDICO_BLUE_EQU		11
#define APLSTDICO_UNDO			12
#define APLSTDICO_REDO			13
#define APLSTDICO_OPTIONS		14
#define APLSTDICO_PROPERTIES	15
#define APLSTDICO_DELETE		16
#define APLSTDICO_TOP			17
#define APLSTDICO_BOTTOM		18
#define APLSTDICO_LEFT			19  // back
#define APLSTDICO_RIGHT			20  // forvard
#define APLSTDICO_GEARS			21
#define APLSTDICO_CHARACT		22
#define APLSTDICO_ADD_X3		23
#define APLSTDICO_IMAGE			24
#define APLSTDICO_LEFT_ALL		25
#define APLSTDICO_RIGHT_ALL		26
#define APLSTDICO_STAR			27
#define APLSTDICO_NULL			28
#define APLSTDICO_TREE			29
#define APLSTDICO_STQL			30
#define APLSTDICO_ZOOM_IN		31
#define APLSTDICO_ZOOM_OUT		32
#define APLSTDICO_ZOOM_DYNAMIC	33

#define APLSTDICO_NEW_SECTION	34
#define APLSTDICO_COPY_SECTION	35
#define APLSTDICO_TABLE			36
#define APLSTDICO_SECTION_PROP	37
#define APLSTDICO_COLUMN		38
#define APLSTDICO_ADD_COLUMN	39

#define APLSTDICO_CORRECT		40
#define APLSTDICO_INCORRECT		41

#define APLSTDICO_CUT			42
#define APLSTDICO_COPY			43
#define APLSTDICO_PASTE			44

#define APLSTDICO_VIEV			45
#define APLSTDICO_CHECKOUT		46
#define APLSTDICO_CHECKIN		47
#define APLSTDICO_UNDO_CHECKOUT	48
#define APLSTDICO_VIEW_ITEM		49
#define APLSTDICO_EDIT_ITEM		50
#define APLSTDICO_EDIT			51

#define APLSTDICO_CREATE		52
#define APLSTDICO_MOVE			53
#define APLSTDICO_FIND			54
#define APLSTDICO_OWNER			55
#define APLSTDICO_KEY			56
#define APLSTDICO_SAVE_TABLE	57


#define APL_STD_24OK			APLSTDICO_OK
#define APL_STD_24CANCEL		APLSTDICO_CANCEL
#define APL_STD_24PLUS			APLSTDICO_PLUS
#define APL_STD_24MINUS			3
#define APL_STD_24PROPERTIES	15
#define APL_STD_24DELETE		16
#define APL_STD_24TOP			17
#define APL_STD_24BOTTOM		18
#define APL_STD_24LEFT			19
#define APL_STD_24RIGHT			20
#define APL_STD_24SETUP			21
#define APL_STD_24CHARACTS		22
#define APL_STD_ADD_FIELD		23
#define APL_STD_IMAGE			24
#define APL_STD_24LEFTALL		25
#define APL_STD_24RIGHTALL		26
#define APL_STD_24STAR			27


/*#define APL_STD_24OK			APLSTDICO_COUNT + 1
#define APL_STD_24CANCEL		APLSTDICO_COUNT + 2
#define APL_STD_24PROPERTIES	APLSTDICO_COUNT + 3
#define APL_STD_24DELETE		APLSTDICO_COUNT + 4
#define APL_STD_24TOP			APLSTDICO_COUNT + 5
#define APL_STD_24BOTTOM		APLSTDICO_COUNT + 6
#define APL_STD_24PLUS			APLSTDICO_COUNT + 7
#define APL_STD_24LEFT			APLSTDICO_COUNT + 8
#define APL_STD_24RIGHT			APLSTDICO_COUNT + 9
#define APL_STD_24SETUP			APLSTDICO_COUNT + 10
#define APL_STD_24CHARACTS		APLSTDICO_COUNT + 11
#define APL_STD_24LEFTALL		APLSTDICO_COUNT + 14
#define APL_STD_24RIGHTALL		APLSTDICO_COUNT + 15
#define APL_STD_24STAR			APLSTDICO_COUNT + 16

//   !!!!!!!!!!!!!!!!!!!*/


#define APL_TABLE_NEW     0
#define APL_TABLE_TOP     1
#define APL_TABLE_BOTTOM  2
#define APL_TABLE_LEFT    3
#define APL_TABLE_RIGHT   4 
#define APL_TABLE_DEL     5
#define APL_TABLE_BOLD    6
#define APL_TABLE_ITALIC  7
#define APL_TABLE_UNDERLINE  8
#define APL_TABLE_FONT  9
#define APL_TABLE_TABLE  20
#define APL_TABLE_WIDTH  27
#define APL_TABLE_FIND	25
#define APL_TABLE_CUT	28
#define APL_TABLE_COPY	29
#define APL_TABLE_PASTE	30
#define APL_TABLE_OPEN	31
#define APL_TABLE_SAVE	32
#define APL_TABLE_VIEW	33
#define APL_TABLE_SELECT_DOWN	34
#define APL_TABLE_SELECT_UP	35
#define APL_TABLE_ALL_LEFT	36
#define APL_TABLE_ALL_RIGHT	37
#define APL_TABLE_SELECT_CHAR	38
#define APL_TABLE_REFRESH		39
#define APL_TABLE_ADD_FROM_DISK	40
#define APL_TABLE_GET_LAST_VER	41
#define APL_TABLE_PROP			42
#define APL_TABLE_RUN			43
#define APL_TABLE_TOOLS			44
#define APL_TABLE_1INT			45
#define APL_TABLE_15INT			46
#define APL_TABLE_2INT			47
#define APL_TABLE_STRIKEOUT		48
#define APL_TABLE_PICTURE		49
#define APL_TABLE_OBJECT		50
#define APL_TABLE_NOTE			53
#define APL_TABLE_NOTE_NOTE		54
#define APL_TABLE_NOTE_DELETE	55
#define APL_TABLE_PRINT			56
#define APL_TABLE_NEW_COPY		57
#define APL_TABLE_EDIT			58
#define APL_TABLE_SELECT_ALL	59
#define APL_TABLE_UNSELECT_ALL	60
#define APL_TABLE_FILTER		61
#define APL_TABLE_CLEAR_FILTER	62
#define APL_TABLE_BOLD_EN		63
#define APL_TABLE_ITALIC_EN		64
#define APL_TABLE_UNDERLINE_EN	65


#define APL_ICON_SHOW			0
#define APL_ICON_CHECKOUT		1
#define APL_ICON_CHECKIN		2
#define APL_ICON_UNDOCHECKOUT	3
#define APL_ICON_SAVE			4
#define APL_ICON_LOAD			5
#define APL_ICON_REFRESH		6
#define APL_ICON_NOTES			7


HICON AFX_EXT_API GetAplStdIco32(int index);
HICON AFX_EXT_API GetAplStdIco24(int index);
HICON AFX_EXT_API GetAplStdIco16(int index);
HICON AFX_EXT_API GetAplTableIco(int index);


#define aplGetStdIco16  GetAplStdIco16   //   GUI_EX -  


#define APL_STD_OK				APLSTDICO_OK
#define APL_STD_CANCEL			APLSTDICO_CANCEL
#define APL_STD_PROPERTIES		APLSTDICO_PROPERTIES
#define APL_STD_DELETE			APLSTDICO_DELETE
#define APL_STD_NEW_SECTION		APLSTDICO_NEW_SECTION
#define APL_STD_COPY_SECTION	APLSTDICO_COPY_SECTION
#define APL_STD_TOP				APLSTDICO_TOP
#define APL_STD_BOTTOM			APLSTDICO_BOTTOM
#define APL_STD_TABLE			APLSTDICO_TABLE
#define APL_STD_SECTION_PROP	APLSTDICO_SECTION_PROP
#define APL_STD_COLUMN			APLSTDICO_COLUMN
#define APL_STD_ADD_COLUMN		APLSTDICO_ADD_COLUMN
#define APL_STD_PICTURE			APLSTDICO_IMAGE
#define APL_STD_PLUS			APLSTDICO_PLUS
#define APL_STD_LEFT			APLSTDICO_LEFT
#define APL_STD_RIGHT			APLSTDICO_RIGHT
#define APL_STD_SETUP			APLSTDICO_GEARS
#define APL_STD_CHARACTS		APLSTDICO_CHARACT


HICON AFX_EXT_API GetAplCheckIco(int index,BOOL truecolor);

//     -    .  wnd=0 ,   "DISPLAY"
int AFX_EXT_API aplGetBitPerPixel(CWnd *wnd);

//   srcBitmap
CBitmap AFX_EXT_API *aplCreateCopyBitmap(CBitmap *srcBitmap);

//  bmp   
//  src_color == RGB(0,0,0)        
// iPecision -          
// 0 -        100 -   
bool AFX_EXT_API aplCreateMappedBitmap(CBitmap &bmptrg, CBitmap *bmpsrc, COLORREF src_color, COLORREF trg_color, int iPecision=30);

//   bmptrg    .  . aplCreateMappedBitmap
bool AFX_EXT_API aplLoadMappedBitmap(CBitmap &bmptrg, UINT nIDBitmap, COLORREF src_color, COLORREF trg_color, int iPecision=30);

//     
void AFX_EXT_API aplGetLogoBmp(CBitmap &bmp, CWnd *wnd);

//     
// colorBackground - ,   .    RGB(0,0,0),      .    RGB(255,255,255),    
void AFX_EXT_API aplSetLogoBmp(CBitmap *bmp, COLORREF colorBackground=RGB(0,0,0));
void AFX_EXT_API aplSetLogoBmp(UINT nBmpID, CBitmap *pGlobalBMP);

//  CBitmap    CBitmap
// bmptrg -  CBitmap
// bmpsrc -  CBitmap
// new_cx, new_cy -  
bool AFX_EXT_API aplCreateResizedBitmap(CBitmap &bmptrg, CBitmap *bmpsrc, int new_cx, int new_cy);

//     
// 0 - PSS
// 1 -  
void AFX_EXT_API aplSetStdLogoBmp(int num_bitmap);


//     
// (       ,     .
//     ,         )
//  hInIcon -  
//  cx, cy -  

HICON AFX_EXT_API aplResizeIcon(HICON hInIcon, int cx, int cy);

//      
//  hIcon -  
//  blend -    -      ( 0  100),  100,    
//  MakeGrayed -    
//  BaseColor - ,    ( ).
//  !!!    DestroyIcon

HICON AFX_EXT_API aplIconCopyAsSpecificBlend(HICON hIcon,int blend=50,bool MakeGrayed=false,COLORREF BaseColor=RGB(192,192,192));

//    ImageList   
//  hImageList -  
//  blend -    -      ( 0  100),  100,    
//  MakeGrayed -    
//  BaseColor - ,    ( ).
//  !!!    DestroyObject

HIMAGELIST AFX_EXT_API aplImageListCopyAsSpecificBlend(HIMAGELIST hImageList,int blend=50,bool MakeGrayed=false,COLORREF BaseColor=RGB(192,192,192));



//  CImageList &il  bitmap bitmapID    mask
bool AFX_EXT_API aplCreateImageListFromBitmap(UINT bitmapID, COLORREF mask, CImageList &il);

void AFX_EXT_API PumpTimerPaint();


//     - 
void AFX_EXT_API aplFormatNumericString (CString &sInput);

//    ,      "-10" > "-2"
int AFX_EXT_API aplCompareNumericStr(LPCTSTR pstr1, LPCTSTR pstr2, bool bNoCase=true);


//  RTF  HTML
void AFX_EXT_API aplConvertRTF2HTML(CString &sInputRTF,CString &sOutputHTML,CString &sTitle,bool with_header=true);


//    pearcent    color.    - pearcent < 0
COLORREF AFX_EXT_API aplColor_GetHilightColor(COLORREF color, int pearcent);

//     color1  color2. mixfactor -   
COLORREF AFX_EXT_API aplColor_MixColor(COLORREF color1, COLORREF color2, int mixfactor=50);

//   
COLORREF  AFX_EXT_API aplColor_InvertColor(COLORREF color);

HICON AFX_EXT_API aplConvertCBitmap2HICON(UINT nId, COLORREF clrMask, HINSTANCE hModule = NULL);
HICON AFX_EXT_API aplConvertCBitmap2HICON(HBITMAP bitmap, COLORREF clrMask);

//   
// direction  0 -  , 1-  
void AFX_EXT_API aplDrawGradient(CDC *dc, RECT *rect, COLORREF color_from, COLORREF color_to, int direction );


//      edit-om c .
void AFX_EXT_API aplShowBigMsg(LPCTSTR text, LPCTSTR caption=0);


/////////////////////////////////////////////////////////////////////////////

//      HIDE
////	  
////		   /   ClassView
#if !defined(HIDE)
#define HIDE /##*
#endif


//	 
typedef POSITION HFROW;		//  -

#define FL_ROOT		((HFROW) 0x00000001L)	//
#define FL_LAST		((HFROW) 0x00000002L)	// 
#define FL_FIRST	((HFROW) 0x00000003L)	// 
#define FL_SORTPOS	((HFROW) 0x00000004L)	//

#define FL_UNDEFINED	-1

//  	(  InsertFColumn
#define FL_LEFT		LVCFMT_LEFT		
#define FL_RIGHT	LVCFMT_RIGHT
#define FL_CENTER	LVCFMT_CENTER

//	 		( AddControl/GetControlType/SetControlType)
#define FL_BUTTON			2					//
#define FL_CHECKBOX			4					//
#define FL_EDIT				8					// 
#define FL_COMBOBOX			(16|FL_BUTTON)		// 
//   
#define FL_SORT				32		//   
#define FL_AUTOCHECK		64		//  
#define FL_PLUSBUTTON		128		//   +
#define FL_DATETIME			256					// 

//	 CHECKBOX'	( GetFItemCheck/SetFItemCheck)
#define FL_UNCHECKED		0		// 
#define FL_CHECKED			1		//
#define FL_INDETERMINATE	2		// 



//			( GetFStyle/SetFStyle)
#define FL_READONLY		1			// 
#define FL_LINEAR_TREE	2			//    


//	 
#define FL_NOCOLOR			(0x0100000)	//  
#define FL_DEFCOLOR			(0x0200000)	//  
#define FL_DONTSET			(0x0300000)	//  

#define FL_BACKGROUND		101			// 
#define FL_TEXT				102			//

//	,    
#define FL_FULL				128			// 
#define FL_FCOLUMN			256			//
#define FL_FROW				512			//
#define FL_SELECTED_FROW	1024		// 
#define FL_SELECTED_FITEM	2048		// 


// 			( GetFRect)
#define FLRC_FITEM				201		// 
#define FLRC_FITEM_CLIENT		202
#define FLRC_FITEM_TREEBUTTON	203
#define FLRC_FITEM_CHECKBOX		204
#define FLRC_FITEM_IMAGE		205
#define FLRC_FITEM_COMBOBOX		206
#define FLRC_FITEM_BUTTON		207
#define FLRC_FITEM_TEXT			208
#define FLRC_FROW				209		//
#define FLRC_FROW_TOP			210
#define FLRC_VISIBLE_FROWS		211
#define FLRC_FCOLUMN			212		//

//      
#define FL_MIN_FCOLUMN_WIDTH	30



//	   GetNextFRow
#define FL_FIRST_CHILD		301
#define FL_LAST_CHILD		302
#define FL_NEXT				303
#define FL_NEXT_VISIBLE		304 
#define FL_PREV				305
#define FL_PREV_VISIBLE		306
#define FL_PARENT			307
#define FL_PARENT_VISIBLE	308
#define FL_PARENT_ROOT		309
#define FL_TOP				311
#define FL_BOTTOM			312


//	 
#define FLNM_USER_MSG(x)		(WM_USER+200+x)

//   
#define FL_OK			0	//	
#define FL_CANCEL		1	//
#define FL_CONTINUE		2	// ,    FL_OK  FL_CANCEL

#define FLNM_COLLAPSE		FLNM_USER_MSG(1)	//	/  
#define FLNM_CHECK			FLNM_USER_MSG(2)	//	  
#define FLNM_DELETE			FLNM_USER_MSG(3)	//	 
#define FLNM_SELECT			FLNM_USER_MSG(4)	//	 
#define FLNM_PRECOLLAPSE	FLNM_USER_MSG(5)	//	 "/  "

#define FLNM_EDIT_BEGIN			FLNM_USER_MSG(5)	//	  
#define FLNM_EDIT_END			FLNM_USER_MSG(6)	//	  
#define FLNM_BUTTON_CLICK		FLNM_USER_MSG(7)	//	   
#define FLNM_COMBOBOX_EXPAND	FLNM_USER_MSG(8)	//	   
#define FLNM_DATETIME_BEGIN		FLNM_USER_MSG(9)	//	  


//  ,    
struct FL_NOTIFY{
	NMHDR hdr;
	HFROW	hFRow;				
	int		iFColumn;
	CString strText;
	DWORD	dwUserData;	
	BOOL	bCollapsed;
	int		nCheckState;
	int		iControlProfile;
};


//   
HIDE*/ struct FL_COMBOITEM{			
	CString strText;
	DWORD dwUserData;
};
typedef CArray<FL_COMBOITEM, FL_COMBOITEM> FL_COMBOITEMS;


//	 
class CFListCtrl;
typedef int (CompareFRows)(CFListCtrl* pThis, int iFColumn, HFROW hFRow1, HFROW hFRow2);


//
//		CFListCtrl										CFListCtrl
//					CFListCtrl				CFListCtrl
//								CFListCtrl
//

class CLASS_DECL_APL_GUI CFListCtrl : public CSortListCtrl
{
public:

	BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID) 
	{return CListCtrl::Create(dwStyle, rect, pParentWnd, nID);}

	/**/		//
	/**/		//     

	//	        
	int AddControl(int nControlType=FL_EDIT);
	//	  
	int GetControlCount() {return m_pRefControls->GetSize();}
	//	   ( , . AttachControls)
	void RemoveAllControls();
	//	      
	int GetControlType(int iControlProfile);
	//	      
	void SetControlType(int iControlProfile, int nControlType);
	//	   checkbox  
	void GetControlCheckImages(int iControlProfile, int *piChecked=NULL, int *piUnchecked=NULL, int *piIndeterminate=NULL);
	//	   checkbox  
	void SetControlCheckImages(int iControlProfile, int iChecked=-1, int iUnchecked=-1, int iIndeterminate=-1);
	//	     combobox'    
	void AddControlComboItem(int iControlProfile, CString strText, DWORD dwUserData=0);
	//	     combobox'
	FL_COMBOITEMS* GetControlCombo(int iControlProfile);
	//	     combobox'
	FL_COMBOITEM GetControlComboSel(int iControlProfile);
	//	     combobox'
	void SetControlComboSel(int iControlProfile, CString strText, DWORD dwUserData);
	void SetControlComboSelByRowCol(HFROW hFRow, int iFColumn, CString strText, DWORD dwUserData);
	void SetControlComboItemsDataByRowCol(HFROW hFRow, int iFColumn, DWORD dwUserData);
	//      flist'
	void AttachControls(CFListCtrl* pFList){m_pRefControls=pFList->m_pRefControls;}
	//    
	void DetachControls(){m_pRefControls=&m_aControlProfiles;}

	/**/		//													
	/**/		//    -			

	//	    -
	int InsertFColumn(int iIndex, CString strText, int nWidth, int nFormat=FL_LEFT, int iDefaultControlProfile=FL_UNDEFINED);
	//	 
	void DeleteFColumn(int iIndex);
	//	   
	int GetFColumnCount() {return m_aFColumns.GetSize();}
	//	    
	virtual int GetTree();
	//	 ,     
	void SetTree(int iFColumn=-1);	
	//	  
	CString GetFColumnCaption(int iFColumn);
	//	  
	void SetFColumnCaption(int iFColumn, CString strText);
	//	  
	int GetFColumnWidth(int iFColumn) {return GetColumnWidth(iFColumn);}
	//	  
	void SetFColumnWidth(int iFColumn, int nWidth){CListCtrl::SetColumnWidth(iFColumn, nWidth);}
	//   
	void AllowColumnSelect(bool bValue) { m_bAllowColumnSelect = bValue; };
	//   ,    
	void SetNoSortableColumns(const std::set<int> &nonSortableColumns);
		
	/**/	//
	/**/	//    

	//	    -
	HFROW InsertFRow(HFROW hParent, HFROW hPosition, CString strText, int iImageIndex=-1, int iControlProfile=-1);
	//	 
	void DeleteFRow(HFROW hFRow);	
	//	  
	void DeleteAllFRows();
	//   
	void DeleteAllFColumns(){ while (GetFColumnCount() > 0) DeleteFColumn(0); }
	//	  
	int GetFRowCount(HFROW hParent=FL_ROOT);
	//	     
	HFROW FindIndex(HFROW hParent, int iIndex);
	//	       
	int GetFRowIndex(HFROW hFRow);
	//	  ""  
	HFROW GetNextFRow(HFROW hFRow, int nfrCode=FL_NEXT);
	//	/  
	void Collapse(HFROW hFRow, BOOL bCollapse=TRUE);
	//	 TRUE        
	BOOL IsCollapsed(HFROW hFRow);	
	//	 
	void UpdateFRow(HFROW hFRow);
	//	   
	void ExchangeFRows(HFROW hFRow1, HFROW hFRow2);
	//	 TRUE,      bold ( )
	BOOL IsFRowBold(HFROW hFRow);
	//	   bold   
	void SetFRowBold(HFROW hFRow, BOOL bBoldText=TRUE);
	//	       
	int GetFRowDeep(HFROW hFRow);
	//	       
	void SetFRowControls(HFROW hFRow, int iControlProfile1, ...);
	//	 
	HFROW FindFRow(HFROW hParent, HFROW hFirst, int iFColumn, CString text, BOOL bCompareNoCase=TRUE);
	//	 TRUE,     
	BOOL IsFRowVisible(HFROW hFRow);

	/**/	//
	/**/	//    

	//	 
	CString GetFItemText(HFROW hFRow, int iFColumn);
	//	  
	void SetFItemText(HFROW hFRow, int iFColumn, CString strText);	
	//	  
	int GetFItemImage(HFROW hFRow, int iFColumn);	
	//	 
	void SetFItemImage(HFROW hFRow, int iFColumn, int iImageIndex);	
	//	  
	DWORD GetFItemData(HFROW hFRow, int iFColumn);
	//	  
	void SetFItemData(HFROW hFRow, int iFColumn, DWORD dwUserData);
	//	    ComboBox   
	DWORD GetFComboBoxItemData(HFROW hFRow, int iFColumn, int iIndex );
	//	    ComboBox   
	void SetFComboBoxItemData(HFROW hFRow, int iFColumn, int iIndex, DWORD dwUserData );
	//	    ComboBox   
	DWORD GetFComboBoxSelItemData(HFROW hFRow, int iFColumn);
	//	    ComboBox   
	void SetFComboBoxSelItemData(HFROW hFRow, int iFColumn, DWORD dwUserData );
	//	  ,     
	BOOL EnsureVisible(HFROW hFRow, int iFColumn);
	//	  checkbox'
	int GetFItemCheck(HFROW hFRow, int iFColumn);
	//	  checkbox'a
	void SetFItemCheck(HFROW hFRow, int iFColumn, int nState=FL_CHECKED);	
	//	       
	int GetFItemControl(HFROW hFRow, int iFColumn);
	//	       
	void SetFItemControl(HFROW hFRow, int iFColumn, int iControlProfile);	

	/**/	//
	/**/	// 

	//	  / -
	void Select(HFROW hFRow, int iFColumn=-1, BOOL bEnsureVisible=TRUE);
	//	   
	inline HFROW GetSelectedFRow()	{return GetSel().m_hSelectedFRow;}
	//	   
	inline int GetSelectedFColumn() {return IsReadOnly() ? -1 : GetSel().m_iSelectedFColumn;}
	inline int GetSelectedFColumnEx() { return GetSel().m_iSelectedFColumn; }

	/**/	//
	/**/	// 

	//	  -
	int GetFStyle() {return GetOptions().m_nStyle;}
	//	  -
	void SetFStyle(int nDeleteStyle, int nAddStyle, int nMask=0);	
	//	  readonly
	void SetReadOnly(BOOL bReadOnly=TRUE);
	//	 TRUE,   
	BOOL IsReadOnly()	{return m_opt.m_nStyle&FL_READONLY;}
	//	     / 
	void GetTreeButton(int *piExpandImage, int *piCollapseImage);
	//	    / 
	void SetTreeButton(int iExpandImage, int iCollapseImage);
	//	       	
	int GetTextLineCount()	{return m_opt.m_nTextLineCount;}
	//	       	
	void SetTextLineCount(int nTextLineCount);

	/**/	//
	/**/	// 

	//	   
	virtual BOOL GetFRect(HFROW hFRow, int iFColumn, int nArea, CRect &rect, BOOL bFItemOrigin=FALSE);
	//	  /  ///
	COLORREF GetColor(int nType=FL_TEXT, HFROW hFRow=NULL, int iFColumn=-1);
	//	    
	void SetColor(int nArea, HFROW hFRow, int iFColumn, COLORREF crText=FL_DONTSET, COLORREF crBackground=FL_DONTSET);

	//    
	void SetRowByRowColor(COLORREF clr1, COLORREF clr2);

	//     ( )
	void SetFocusRectAsGrid();

	//    
	void SetSelectionColor(COLORREF clrBk, COLORREF clrText);

	//	      
	void Sort(int iFColumn, BOOL bReverseSort=TRUE);
	//	    
	void Sort(int iFColumn, HFROW hParent, BOOL bSortChild=TRUE);	
	//	 
	CompareFRows *m_pCompareFRowsFunc;		//     		
	//	   ,          
	void UpdateFColumnWidth(int iFColumn);
	//  
	void SetImageList(CImageList *pImageList){CListCtrl::SetImageList(pImageList, LVSIL_SMALL);}

	BOOL HitTestMouseClick(CPoint point, HFROW &hFRow, int &iFColumn);

	void GoThroughExpandedItems(HFROW hRow, int &count);
	int GetVisibleItemsCount();
	void DisableToolTips() { m_bDisableToolTip = true; };
	void DeselectIfNullRowClicked() { m_bDeselectIfNullRowClicked = true; };

	//,    .     
	CWnd* m_pNotifyWnd;


	void SetRedraw(BOOL bRedraw=TRUE, BOOL bClear=FALSE);	
	BOOL IsRedraw();	

	//				go high
	//
	//
	//
	//				RESTRICTED  AREA
	//
	//
	//
	//

	//	IMPLEMENTATION
protected:

	bool		m_bUseSelectionColor;
	bool		m_bUseFocusRectAsGrid;
	bool		m_bUseRowByRowColor;
	COLORREF	m_rowByRowColor1;
	COLORREF	m_rowByRowColor2;
	COLORREF	m_selectionColor;
	COLORREF	m_selectionTextColor;

	int m_nRedrawCounter;

	//   
	bool m_bAllowColumnSelect;

	//  
	bool m_bDisableToolTip;

	//  ,     
	bool m_bDeselectIfNullRowClicked;

	//  ,    
	std::set<int> m_nonSortableColumns;

	HIDE*/ struct XFList_Color{	
		COLORREF crBackground;
		COLORREF crText;
	};

	//CONTROL PROFILE
	HIDE*/class XFList_ControlProfile{
	public:
		int m_nControlType;	
		struct XFList_CheckImages{
			int m_iChecked;
			int m_iUnchecked;
			int m_iIndeterminate;
		}m_checkImages;
		// COMBOBOX
		FL_COMBOITEM m_ciSelect;
		FL_COMBOITEMS m_aComboItems;	

		//
		XFList_ControlProfile()
		{
			m_nControlType=0;			
			m_checkImages.m_iChecked=-1;
			m_checkImages.m_iUnchecked=-1;
			m_checkImages.m_iIndeterminate=-1;			
			m_ciSelect.strText=_T("");
			m_ciSelect.dwUserData=0;
		}
	};	
	HIDE*/ XFList_ControlProfile m_defaultControlProfile;
	HIDE*/ CArray<XFList_ControlProfile*, XFList_ControlProfile*> m_aControlProfiles;
	HIDE*/ CArray<XFList_ControlProfile*, XFList_ControlProfile*> *m_pRefControls;
	HIDE*/ CWnd* m_pInplaceControl;
	HIDE*/ HFROW m_hFRow;
	HIDE*/ int m_iFColumn;
	HIDE*/ UINT m_nChar;
	HIDE*/ XFList_ControlProfile* GetCP(int iControlProfile);		
	HIDE*/ XFList_ControlProfile* GetCP(HFROW hFRow, int iFColumn)
	{return GetCP(GetFItem(hFRow, iFColumn).m_iControlProfile);}	

protected:		//	IMPLEMENTATION

	//COLUMN
	HIDE*/ struct XFList_Column{	
		int m_iDefaultControlProfile;		//  		
		int m_nFormat;						// 
		BOOL m_bReverseSort;				//  						
		XFList_Color m_color;
		int m_nTmpWidth;
	};
	HIDE*/ CArray<XFList_Column, XFList_Column> m_aFColumns;	
	HIDE*/ void InitFColumn(XFList_Column &col)
	{
		col.m_iDefaultControlProfile=FL_UNDEFINED;
		col.m_nFormat=DT_LEFT;
		col.m_bReverseSort=FALSE;					
		col.m_color.crText=FL_NOCOLOR;
		col.m_color.crBackground=FL_NOCOLOR;
		col.m_nTmpWidth=-1;
	}	
	HIDE*/ static int DefaultCompareFRows(CFListCtrl* pThis, int iFColumn, HFROW hFRow1, HFROW hFRow2)
	{
		return pThis->GetFItemText(hFRow1, iFColumn).CompareNoCase(
			pThis->GetFItemText(hFRow2, iFColumn));
	}
	HIDE*/ XFList_Column& GetFColumn(int iFColumn)
	{ 
		ASSERT(iFColumn>=0 && iFColumn<GetFColumnCount());
		return m_aFColumns[iFColumn];
	}


	//
	//					DEEPER
	//

protected:		//	IMPLEMENTATION
	//IMPLEMENTATION
	//ROW
	HIDE*/ class XFList_Row{
	public:
		struct XFList_Item{	
			CString m_strText;
			int		m_iImageIndex;
			int		m_iControlProfile;
			DWORD	m_dwUserData;
			//
			int		m_nCheckState;
		};	
		HIDE*/ static void InitFItem(XFList_Item &item)
		{
			item.m_dwUserData=0;
			item.m_iImageIndex=-1;
			item.m_iControlProfile=-1;			
			item.m_nCheckState=0;
		}

		HIDE*/ CArray<XFList_Item, XFList_Item> m_aFItems;		// 

		HIDE*/ CList<HFROW, HFROW>	m_lstChildFRows;			// 

		HIDE*/ BOOL m_bCollapsed;								//  
		HIDE*/ int	m_nDeep;									// 
		HIDE*/ int m_iListIndex;								//    

		HIDE*/ BOOL m_bBoldText;								// 
		XFList_Color m_color;

		HIDE*/ HFROW	m_hFRow;								//   m_lstFRows
		HIDE*/ HFROW	m_hParentFRow;							// 
		HIDE*/ POSITION m_posParentList;						//   

		//	IMPLEMENTATION

		HIDE*/ XFList_Row()
		{
			m_bCollapsed=TRUE;
			m_nDeep=0;
			m_iListIndex=FL_UNDEFINED;
			m_bBoldText=FALSE;
			m_hFRow=m_hParentFRow=m_posParentList=NULL;			
			m_color.crText=FL_NOCOLOR;
			m_color.crBackground=FL_NOCOLOR;
		}
		HIDE*/ ~XFList_Row(){}

		friend CFListCtrl;

#ifdef _DEBUG
		void AssertValid() const
		{			
			if(m_bCollapsed!=FALSE && m_bCollapsed!=TRUE)
				return;
			ASSERT(m_bCollapsed==FALSE || m_bCollapsed==TRUE);
			ASSERT(m_nDeep>=0);
			ASSERT(m_iListIndex>=-1);
			m_aFItems.AssertValid();
			m_lstChildFRows.AssertValid();			
		}	
#endif
	};
	friend XFList_Row;
	HIDE*/ CList<XFList_Row*, XFList_Row*> m_lstFRows;
	HIDE*/ XFList_Row m_rootFRow;
	HIDE*/ XFList_Row* GetFRow(HFROW hFRow)			
	{
		XFList_Row* pFRow = NULL;
		if(hFRow!=NULL)
		{
			pFRow= hFRow==FL_ROOT ? &m_rootFRow : m_lstFRows.GetAt(hFRow);
			ASSERT((pFRow->AssertValid(), TRUE));
		}
		return pFRow;
	}	

protected:		//	IMPLEMENTATION

	HIDE*/ void ShowFRow(HFROW hFRow, BOOL bShow=TRUE, BOOL bUpdateIndexes=TRUE);	
	HIDE*/ inline XFList_Row::XFList_Item& GetFItem(HFROW hFRow, int iFColumn)
	{			
#ifdef _DEBUG
		static XFList_Row::XFList_Item s_debugFItem;			
		if(iFColumn>=0 && iFColumn<GetFColumnCount())
		{
			XFList_Row* pFRow=GetFRow(hFRow);
			if(iFColumn>=0 && iFColumn<pFRow->m_aFItems.GetSize())
				return pFRow->m_aFItems.ElementAt(iFColumn);
		}
		ASSERT(FALSE);
		return s_debugFItem;
#else
		return GetFRow(hFRow)->m_aFItems.ElementAt(iFColumn);			
#endif
	}	

	//
	//					MORE DEEPER
	//

	//SELECTION
	HIDE*/ class XFList_Selection{
	public:				
		HFROW	m_hSelectedFRow;
		int m_iSelectedFColumn;
		XFList_Color m_colorFRow;
		XFList_Color m_colorFItem;
		//
		XFList_Selection()
		{
			m_hSelectedFRow=NULL;
			m_iSelectedFColumn=-1;
			//
			m_colorFRow.crText=FL_DEFCOLOR;
			m_colorFRow.crBackground=FL_DEFCOLOR;
			m_colorFItem.crText=FL_DEFCOLOR;
			m_colorFItem.crBackground=FL_DEFCOLOR;			
		}		
	}m_selection;
	friend XFList_Selection;
	HIDE*/ XFList_Selection &GetSel()
	{return m_selection;}

protected:		//	IMPLEMENTATION
	//IMPLEMENTATION
	//DRAW SERVICE	
	HIDE*/ CDC m_dcFItem;
	HIDE*/ CBitmap m_bmpFItem;
	HIDE*/ CSize m_szFItem;	
public:
	HIDE*/ int	m_nTextLineHeight;
protected:
	HIDE*/ int GetFRowHeight(BOOL bReal=TRUE)
	{
		if(bReal && GetItemCount()){
			CRect rc;
			GetItemRect(0, &rc, LVIR_BOUNDS);
			return rc.Height();
		}
		return m_nTextLineHeight*GetOptions().m_nTextLineCount+4;
	}

	HIDE*/ void UpdateMemDC(CDC *pDC, CRect rcFItem);
	HIDE*/ void DrawFItem(CDC* pDC, HFROW hFRow, int iFColumn);	
	HIDE*/ virtual BOOL DrawElement(int nType, CDC *pDC, HFROW hFRow, int iFColumn, CRect *prcElement);		
	HIDE*/ void DrawItem(LPDRAWITEMSTRUCT lpDIS);		
	//IMPLEMENTATION
	//OPTIONS
	HIDE*/ struct XFList_Options{
		int m_iExpandButton;  // [+]
		int m_iCollapseButton;// [-]
		int m_nStyle;				
		int m_nTextLineCount;
		int m_iTreeColumn;
	};
	HIDE*/ XFList_Options m_opt;	
	HIDE*/ const XFList_Options &GetOptions() {return m_opt;}	

	//CONSTRUCTION
public:
	void RecurseRedraw(HFROW hMainParent, HFROW hMainChild);
	CFListCtrl();
	~CFListCtrl();	

	//
	//
	//						VERY DANGEROUS
	//
	//	
	//====================================================================================
	//						IMPLEMENTATION
protected:				

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFListCtrl)	
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);	
protected:
	virtual CString GetItemTextVirtual(const CPoint &point, int i = -1, int j = -1);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

protected:		//	IMPLEMENTATION

#ifdef _DEBUG
	HIDE*/ virtual void AssertValid() const
	{		
		CListCtrl::AssertValid();		
	}
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CFListCtrl)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDestroy();		
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);	
	afx_msg void OnSysColorChange();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);		
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);	
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnHeaderClicked(NMHDR* pNMHDR, LRESULT* pResult);	
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnDividerDblClk(NMHDR* pNMHDR, LRESULT* pResult);	
	afx_msg void OnFontChange();
	//}}AFX_MSG
	afx_msg virtual void OnInplaceControlNotify(NMHDR * pNotifyStruct, LRESULT * result);
	afx_msg LRESULT	OnSetFont(WPARAM wParam, LPARAM lParam);
	afx_msg void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	DECLARE_MESSAGE_MAP()
	HIDE*/ void TranslateMouse(UINT nFlags, CPoint point, BOOL bDoubleClick);		

public:
	// NOTIFY
	HIDE*/ void NotifyInit(FL_NOTIFY &notify, HFROW hFRow, int iFColumn, int code);
	HIDE*/ LRESULT NotifySend(FL_NOTIFY &notify);	

protected:	//	IMPLEMENTATION

	// EDIT 	
	HIDE*/struct FL_INPLACE_NOTIFY{
		NMHDR hdr;
		CString strText;
		DWORD	dwUserData;
		HFROW	hFRow;
		int		iFColumn;
		UINT	nChar;
	};
	HIDE*/ virtual LRESULT InplaceControl(UINT code, UINT nChar, FL_INPLACE_NOTIFY* pInplaceNotify=NULL);

	bool m_bSelCombo;
public:
	bool SelCombo() const { return m_bSelCombo; }
	void SelCombo(bool val) { m_bSelCombo = val; }
protected:
	//
	friend class CFList_DateTime;
	friend class CFList_Edit;
	friend class CFList_ComboBox;
};
typedef CFListCtrl flist;

/////////////////////////////////////////////////////////////////////////////
//
//	CFList_Edit
//
HIDE*/class CFList_Edit : public CEdit
{
	UINT m_nChar;
	HFROW m_hFRow;
	int m_iFColumn;

	// Construction
public:	
	CFList_Edit(HFROW hFRow, int iFColumn);
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFList_Edit)
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

	// Implementation
public:
	virtual ~CFList_Edit();

	// Generated message map functions
protected:
	//{{AFX_MSG(CFList_Edit)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnNcDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);	
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

HIDE*/class CFList_DateTime : public CDateTimeCtrl
{
	UINT m_nChar;
	HFROW m_hFRow;
	int m_iFColumn;

	// Construction
public:	
	CFList_DateTime(HFROW hFRow, int iFColumn);
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFList_DateTime)
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

	// Implementation
public:
	virtual ~CFList_DateTime();

	// Generated message map functions
protected:
	//{{AFX_MSG(CFList_DateTime)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnNcDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);	
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDtnDropdown(NMHDR *pNMHDR, LRESULT *pResult);
};


/////////////////////////////////////////////////////////////////////////////
//
//		CFList_ComboBox
//
HIDE*/ class CFList_ComboBox : public CComboBox
{	
	bool m_bSel;
	FL_COMBOITEMS* m_paComboItems;
	FL_COMBOITEM m_ciSelect;	
	HFROW m_hFRow;
	int m_iFColumn;
	UINT	m_nChar;
	CFListCtrl* m_pParent;
	// Construction
public:	
	CFList_ComboBox(CFListCtrl* pParent, HFROW hFRow, int iFColumn, FL_COMBOITEMS* paComboItems, FL_COMBOITEM ciSelect, bool bSel);
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFList_ComboBox)
public:	
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

	// Implementation
public:
	virtual ~CFList_ComboBox();
	// Generated message map functions
protected:
	//{{AFX_MSG(CFList_ComboBox)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnKillFocus();//CWnd* pNewWnd);
	afx_msg void OnNcDestroy();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPaint();
	afx_msg void OnCloseup();
	afx_msg void OnEditChange();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnCbnDropdown();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
};

class CLASS_DECL_APL_GUI CStatusDlgThread : public CWinThread
{
	friend class CProgressDlg;
	DECLARE_DYNCREATE(CStatusDlgThread)
protected:
	CStatusDlgThread();           // protected constructor used by dynamic creation

	// Attributes
	CWnd *m_pParent;
	bool	m_bInitialed;
	bool	m_bShowOnTop;
	bool	m_bShowBreakBtn;
	bool	m_bSlave;
	bool	m_bEnd;

	CString m_sBreakMsg;
	CString m_sBreakStatusMsg;

	HINSTANCE	OldHInst;
	CRITICAL_SECTION m_CriticalSection;
public:
	static CStatusDlgThread *aplCreateStatusThread(CWnd *pParent, bool bShowBreakBtn = true, bool bShowOnTop = true, bool bEnableSlave = false);

	bool IsInitialized()
	{
		if(OldHInst != 0)
			AfxSetResourceHandle(OldHInst);
		OldHInst = 0;
		return m_bInitialed;
	};
	// Operations
public:
	void End();
	void SetParent(CWnd* pParent);
	void StepIt();
	void Slave_StepIt();
	void GetRange(int& iStart, int& iEnd, int& Position);
	void SetRange(int iStart, int iEnd, int Position = 0);
	void Slave_GetRange(int& iStart, int& iEnd, int& Position);
	void Slave_SetRange(int iStart, int iEnd, int Position = 0);
	void SetText(LPCTSTR lpszText);
	void GetText(CString &sText);
	void Slave_SetText(LPCTSTR lpszText);
	bool SetTitle(LPCTSTR lpszTitle);
	//     
	//	lpszMsg -   
	//	lpszBreakStatusMsg -     ,        .
	void SetBreakMsg(LPCTSTR lpszMsg, LPCTSTR lpszBreakStatusMsg);
	void EnableSlave(bool bVisible);
	bool SetMarquee(bool bMarqueeMode, int nInterval);
	void Start();
	void Stop();
	bool Slave_SetMarquee(bool bMarqueeMode, int nInterval);
	void Slave_Start();
	void Slave_Stop();

	bool m_bBreak;

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStatusDlgThread)
public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

	// Implementation
protected:
	virtual ~CStatusDlgThread();

	// Generated message map functions
	//{{AFX_MSG(CStatusDlgThread)
	// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

// --------------------------
// -- Definitions of STYLE --		// LIS = List Item Style ;o)
// --------------------------
#define LIS_BOLD          1			// Set the item to BOLD
#define LIS_ITALIC        2			// Set the item to ITALIC
#define LIS_UNDERLINE     4			// Set the item to UNDERLINE
#define LIS_STROKE		  8			// Set the item to STROKE
#define LIS_TXTCOLOR	  16		// Text color is valid and must be set
#define LIS_BGCOLOR	      32		// BackGround color is valid and must be set
#define LIS_NO_COL_STYLE  64        // The Column Style has no effect on this item / subitem
#define LIS_NO_ROW_STYLE  128		// The Row Stylehas no effect on this item / subitem
#define LIS_FIXED_STYLE	  LIS_NO_COL_STYLE | LIS_NO_ROW_STYLE

#define FONT_NORMAL 1
#define FONT_MERGED 2
#define FONT_ALL    FONT_NORMAL | FONT_MERGED

// -------------------------------------
// -- Definition of LS_item structure --
// -------------------------------------
// This structure allow this derived CSortListCtrl to store for any items/subitems his own style (bold,color,etc..)
// All styles (item & subitems) for an item are accessible with the helpfull of lParam member.
// But for make the usage transparancy, the "lParam" access method is always available and return the pogrammer value ;o)
// because LS_item structure hold the lParam member before override it, and restore it when needed.
//
typedef struct iLS_item
{
	LPARAM lParam;											// The user-32 bits data lParam member
	bool   mParam;											// let you know if the original item have a lParam significant member

	DWORD StyleFlag;										// The style of this item
	bool in_use;											// true if a font style is in use (except for colors)

	COLORREF txtColor;										// Text color if LIS_TXTCOLOR style 		(default otherwise)
	COLORREF bgColor;										// BackGround color if LIS_BGCOLOR style	(default otherwise)

	CArray<struct iLS_item *,struct iLS_item *> subitems;   // Allow to have an individual style for subitems  (this array is empty if it's a subitem structure style instance)
	struct iLS_item * row_style;							// Access to the row style (valid only for the ITEM, subitems structure have NULL on this member)
	struct iLS_item * selected_style;						// The selected style for a component

	CFont * cfont;											// The CFont object pointer used for draw this item or subitem
	bool ifont;												// Allow to know if the CFont is a internal or user Cfont object and allow to know if we must memory manage it !
	CFont * merged_font;									// If a combination of differents font is needed (Style from Columns,Line and Item), this is the last CFont object

} LS_item;

// ---------------------
// -- CListCtrlStyled --
// ---------------------
class CLASS_DECL_APL_GUI CListCtrlStyled : public CSortListCtrl
{
public:
	// -- Construction --
	//
	CListCtrlStyled();

	// ***************************
	// ** Style methods setting **
	// ***************************

	// -- Set the style of an item or subitem (style flag are LIS_BOLD LIS_UNDERLINE LIS_STROKE LIS_ITALIC LIS_TXTCOLOR and LIS_BGCOLOR --
	//
	void SetItemStyle(int nItem,int nSubItem,DWORD Style,bool Redraw = true);				// Set a style for an item or subitem
	void SetItemTxtColor(int nItem,int nSubItem,COLORREF txtColor,bool redraw = true);		// Set a Text Color for an item or subitem
	void SetItemBgColor(int nItem,int nSubItem,COLORREF txtBgColor,bool redraw = true);		// Set a BackGround Color for an item or subitem
	void SetItemFont(int nItem,int nSubItem,CFont * pFont,bool redraw = true);  			// Allow to define a user-font for an item or subitem

	// -- Set the style for an entire row (item+subitems) --
	//
	void SetRowStyle(int nRow,DWORD Style,bool redraw = true);
	void SetRowTxtColor(int nRow,COLORREF txtColor,bool redraw = true);
	void SetRowBgColor(int nRow,COLORREF txtBgColor,bool redraw = true);
	void SetRowFont(int nRow,CFont * pFont,bool redraw = true);

	// -- Set the style for an entire Column  --
	//
	void SetColStyle(int nCol,DWORD Style,bool redraw = true);
	void SetColTxtColor(int nCol,COLORREF txtColor,bool redraw = true);
	void SetColBgColor(int nCol,COLORREF txtBgColor,bool redraw = true);
	void SetColFont(int nCol,CFont * pFont,bool redraw = true);

	// ******************************
	// ** GENERAL HIGHLIGHT Colors **
	// ******************************

	// -- Set HIGHLIGHT Colors value --
	// --
	void SetHighlightTextColor(COLORREF Color);
	void SetHighlightColor(COLORREF Color);

	// ************************************************
	// ** Style methods setting when SELECTED STATUS **
	// ************************************************

	// -- Set "Selected Style" for an Item / SubItem --
	//
	void SetItemSelectedStyle(int nItem,int nSubItem,DWORD Style,bool Redraw = true);				// Set a style for an item or subitem
	void SetItemSelectedTxtColor(int nItem,int nSubItem,COLORREF txtColor,bool redraw = true);		// Set a Text Color for an item or subitem
	void SetItemSelectedBgColor(int nItem,int nSubItem,COLORREF txtBgColor,bool redraw = true);		// Set a BackGround Color for an item or subitem
	void SetItemSelectedFont(int nItem,int nSubItem,CFont * pFont,bool redraw = true);  			// Allow to define a user-font for an item or subitem

	// -- Set "Selected style" for an entire row (item+subitems) --
	//
	void SetRowSelectedStyle(int nRow,DWORD Style,bool redraw = true);
	void SetRowSelectedTxtColor(int nRow,COLORREF txtColor,bool redraw = true);
	void SetRowSelectedBgColor(int nRow,COLORREF txtBgColor,bool redraw = true);
	void SetRowSelectedFont(int nRow,CFont * pFont,bool redraw = true);

	// -- Set "Selected style" for an entire Column  --
	//
	void SetColSelectedStyle(int nCol,DWORD Style,bool redraw = true);
	void SetColSelectedTxtColor(int nCol,COLORREF txtColor,bool redraw = true);
	void SetColSelectedBgColor(int nCol,COLORREF txtBgColor,bool redraw = true);
	void SetColSelectedFont(int nCol,CFont * pFont,bool redraw = true);

	// -------------------------------------------------------------------------------------------------------------------
	// -- Overrided Methods, all CSortListCtrl methods that need to be overrided for let his class a transparancy behaviour --
	// -------------------------------------------------------------------------------------------------------------------

	// -- InsertItem --
	//
	int InsertItem( const LVITEM* pItem );
	int InsertItem( UINT nMask, int nItem, LPCTSTR lpszItem, UINT nState, UINT nStateMask, int nImage, LPARAM lParam );
	int InsertItem( int nItem, LPCTSTR lpszItem );
	int InsertItem( int nItem, LPCTSTR lpszItem, int nImage );

	// -- SetItem --
	//
	BOOL SetItem( const LVITEM* pItem );
	BOOL SetItem(int nItem,int nSubItem,UINT nMask,LPCTSTR lpszItem,int nImage,UINT nState,UINT nStateMask,LPARAM lParam);
	BOOL SetItem(int nItem,int nSubItem,UINT nMask,LPCTSTR lpszItem,int nImage,UINT nState,UINT nStateMask,LPARAM lParam,int nIndent);

	// -- DeleteItem / DeleteAllItems --
	//
	BOOL DeleteItem( int nItem );
	BOOL DeleteAllItems();

	// -- SetItemData / GetItemData --
	//
	BOOL SetItemData( int nItem, DWORD dwData );
	DWORD GetItemData( int nItem );

	// -- InsertColumn / DeleteColumn --
	//
	int InsertColumn( int nCol, const LVCOLUMN* pColumn );
	int InsertColumn( int nCol, LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT, int nWidth = -1, int nSubItem = -1 );
	BOOL DeleteColumn( int nCol );

	// -- SetColumnOrderArray --
	//
	BOOL SetColumnOrderArray( int iCount, LPINT piArray );

	// -- GetItem --
	//
	BOOL GetItem( LV_ITEM* pItem );

	// -- SortItems --
	//
	BOOL SortItems( PFNLVCOMPARE pfnCompare, DWORD dwData );			// use global function (LIS_CompareFunc & LIS_CompFunc)

	// -- FindItem --
	//
	int FindItem( LV_FINDINFO* pFindInfo, int nStart = -1 );

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CListCtrlStyled)
	//}}AFX_VIRTUAL

	// -- Destruction --
	//
	virtual ~CListCtrlStyled();

protected:
	// -------------------------------------------------------------------------------------------------------------
	// -- Hold Old CFont object pointer when CustomDraw is performed, for let this class to restore automatically --
	// -------------------------------------------------------------------------------------------------------------
	CFont*  m_pOldItemFont;
	CFont*  m_pOldSubItemFont;

	CFont*  m_Default_pCFont;
	LOGFONT m_Default_LOGFONT;

	// -- Allow to know if the current Item to be drawing is selected or not
	// --
	bool    m_item_selected;

	// -- Default selected HIGHLIGHT Colors
	// --
	COLORREF m_highlight;
	COLORREF m_highlighttext;

private:
	// -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// -- Let the class to create the appropriate font for an item or return NULL if no special font was needed. This method is call when a item or subitem is being to be draw bu OnCustomDraw --
	// -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	CFont * FontForItem(int nItem,int nSubItem,LPARAM lParam,NMLVCUSTOMDRAW* pNMLVCUSTOMDRAW);

	// -- Init a LVITEM structure with the lParam of an item
	//
	void InitLVITEM(int nItem,int nSubItem,LVITEM * pItem);

	// -- Create a CFont object for a specified Style
	//
	CFont * CreateFont(DWORD StyleFlag);

	// -- Select a CFont from a list of 3 !! it return one only it's the only valid CFont, return NULL otherwise
	// --
	CFont * SelectFont(CFont * pCFont1,CFont * pCFont2,CFont * pCFont3);

	// -- Create a New Font that merge 3 CFonts in comparaison of a Base CFont
	// --
	CFont * MergeFont(CFont * pCFont1,CFont * pCFont2,CFont * pCFont3);

	// -- Merge LogFont information from a base
	// --
	void MergeLogFont(LOGFONT * font,LOGFONT *dest);

	// -- LS_item structure management (initialisation & destruction)
	// --

	void Init_LS_item(LS_item * lpLS_item,bool allow_subitems = true);
	void Free_LS_font(LS_item* lpLS_item,DWORD mask = FONT_ALL);
	void Free_LS_item(LS_item* lpLS_item);

	// -- An Array to hold Columns Style (i don't use the lParam of HDITEM because i don't wand to override an methods for it :-( )
	//
	CArray<struct iLS_item*,struct iLS_item*> columns;

protected:
	//{{AFX_MSG(CListCtrlStyled)
	afx_msg void OnCustomdraw(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

class CaplToolTipListCtrl;

typedef CLASS_DECL_APL_GUI void (*LPGetTooltipText)(const CaplToolTipListCtrl*, int, CString&);
typedef std::map<int,LPGetTooltipText> TMapTooltipTextFunction;
typedef std::map<int,LPGetTooltipText>::iterator TMapTooltipTextFunction_it;

class CLASS_DECL_APL_GUI CaplToolTipListCtrl : public CListCtrl
{
protected:
	CaplToolTip*	m_tooltip_ctrl;

	TMapTooltipTextFunction m_map_tooltip;

	int m_nItem;

public:
	CaplToolTipListCtrl(CaplToolTip* tooltip);
	~CaplToolTipListCtrl();

	void SetItemTooltipFunction(int nItem, LPGetTooltipText pFunction) { m_map_tooltip[nItem]=pFunction; }
	DECLARE_MESSAGE_MAP()
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
};

//    
void AFX_EXT_API aplShowFindInCtrl(CWnd *ctrl);  //       (     -    
void AFX_EXT_API aplInstallFindInCtrl(CWnd *ctrl);  //   ,   CTRL+F    (aplShowFindInCtrl)
void AFX_EXT_API aplShowFindInTable(CWnd *ctrl);  //     
void AFX_EXT_API aplInstallFindInTable(CWnd *ctrl);  //   ,   CTRL+F    (aplShowFindInCtrl)
 
void AFX_EXT_API aplDeInstallFindInCtrl(CWnd *ctrl);  //  ,   (       )
void AFX_EXT_API aplDeInstallFindInTable(CWnd *ctrl); //   ,   (       )

// CaplFindInTableDlgBar      ListCtrl  aplTreeListCtrl
//    FrameWnd (   )
//  :
// 1.   (  view)
// 2.  Init   ,       (     )
// 3.        UpdateColumnsList();

class CLASS_DECL_APL_GUI CaplFindInTableDlgBar : public CDialogBar
{
	DECLARE_DYNAMIC(CaplFindInTableDlgBar)

public:
	CaplFindInTableDlgBar();   // standard constructor
	virtual ~CaplFindInTableDlgBar();

	void Init(CWnd *table_wnd, // ListCtrl  aplTreeListCtrl
		DWORD dwStyle=CBRS_BOTTOM | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC|CBRS_BORDER_3D|CBRS_GRIPPER, // . CControlBar::SetBarStyle
		DWORD dwDockStyle=CBRS_ALIGN_ANY, //  . CControlBar::EnableDocking
		UINT nDockBarID=AFX_IDW_DOCKBAR_BOTTOM // . CFrameWnd::DockControlBar
		);
	void UpdateColumnsList();
	static void UpdateColumnsList(CHeaderCtrl *headerctrl, CComboBox *combo);

	// Dialog Data
	CaplTreeListCtrl *m_treelist;  // ,   
	CListCtrl *m_list;  //,   

	CaplButton m_btnFindFirst;
	CaplButton m_btnFindNext;
	CaplButton m_btnFindPrev;
	CEdit   m_text_ctrl;
	CComboBox m_colums_box;

	static void FindNextTreeListItem(CaplTreeListCtrl *treelist, LPCTSTR text, int delta, int col, bool bFindWholeString = false);
	static void FindNextListItem(CListCtrl *list, LPCTSTR text, int delta, int col, bool bFindWholeString = false);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	void EnableButtons(CCmdUI* pCmdUI){pCmdUI->Enable(TRUE);};

	void FindNextItem(int delta);  // +1 -next, -1 - prev, 0 -  


	afx_msg void OnBnClickedFindFirst();
	afx_msg void OnBnClickedFindNext();
	afx_msg void OnBnClickedFindPrev();
	//afx_msg void OnCbnDropdownComboColumn(); //      ,   

	DECLARE_MESSAGE_MAP()
};

//    
class CLASS_DECL_APL_GUI  CaplDefWindowParam
{
public:
	static CString m_font_face;  //  
	static CString m_system_font_face;  //   


	static int m_font_size; //   
	static int m_system_font_size; //    
	
	static COLORREF m_win_bk_color;
	static COLORREF m_system_win_bk_color;

	static void Save(); //   
	static void Load(); //   
	
	static bool GetDefaultFont(LOGFONT &lf); //  lf   .    ,  

	static bool CopyFontFaceName(const TCHAR *from, TCHAR *to); //     LOGFONT    
};

//    -
class CLASS_DECL_APL_GUI CaplMDIFrameWnd : public CMDIFrameWnd
{
	DECLARE_DYNCREATE(CaplMDIFrameWnd)
protected:
	CaplMDIFrameWnd();           // protected constructor used by dynamic creation
	virtual ~CaplMDIFrameWnd();

protected:
	DECLARE_MESSAGE_MAP()

	LRESULT OnSetMessageString(WPARAM wParam, LPARAM lParam);
};

class CLASS_DECL_APL_GUI CaplFrameWnd : public CFrameWnd
{
	DECLARE_DYNCREATE(CaplFrameWnd)
protected:
	CaplFrameWnd();           // protected constructor used by dynamic creation
	virtual ~CaplFrameWnd();

protected:
	DECLARE_MESSAGE_MAP()

	LRESULT OnSetMessageString(WPARAM wParam, LPARAM lParam);
};

//   
class CLASS_DECL_APL_GUI CaplFormView : public CFormView
{
protected:
	CaplFormView(LPCTSTR lpszTemplateName);
	CaplFormView(UINT nIDTemplate);
	virtual ~CaplFormView();

public:
	virtual void OnInitialUpdate();
};

// CaplDialogBar - -  
class CLASS_DECL_APL_GUI CaplDialogBar : public CDialogBar
{
	DECLARE_DYNAMIC(CaplDialogBar)

public:
	CaplDialogBar();
	virtual ~CaplDialogBar();

protected:
	DECLARE_MESSAGE_MAP()
	afx_msg LRESULT HandleInitDialog(WPARAM, LPARAM);
};



/*   aplPrintDC:
	CDC memDC;
	CBitmap bmp;
	if(!m_gantt_view->m_gantt.Paint2DC(memDC,bmp)) return ;
	aplPrintDC(memDC,APL_T(" "));
	memDC.DeleteDC();
*/
bool AFX_EXT_API aplPrintDC(CDC &dc,LPCTSTR header=0);

///    DC
void AFX_EXT_API aplShowDcInfo(CDC *dc);  


//     wait==true      
long AFX_EXT_API aplCreateProcess(const TCHAR *lpApplicationName, const TCHAR *lpCommandLine, bool wait, bool minimized=false, BOOL bInheritHandles = TRUE);

//    
//  wait==true  ,   ,    psOut      
long AFX_EXT_API aplCreateProcessEx(const TCHAR *lpApplicationName, const TCHAR *lpCommandLine, bool wait, bool minimized, CString *psOut);

//      ,     
//  0==lpOperation,   "open"
//   <32,   .  >32 - 
HINSTANCE AFX_EXT_API aplShellExecute(HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters=0, LPCTSTR lpDirectory=0, INT nShowCmd=SW_SHOWNORMAL, bool bShowMsg=true);


long AFX_EXT_API aplGetWaitDlgImgLst();

//   
typedef CString (*LPAplMakeStrFunction)(LPCTSTR);
bool CLASS_DECL_APL_GUI aplSelectMultilineString(CString& sFullString, LPCTSTR lpTitle = NULL, LPAplMakeStrFunction lpStrFun = NULL, LPCTSTR lpDelimeters = NULL);



//     
//
// 1.   OnCreate   (,  CMainFrame::OnCreate)
//             
//	
//	aplFillLanguageMenu(GetMenu(), _T("&"), _T("Language ( )")); //     
//
// 2.  OnCommand   (,  CMainFrame::OnCommand)
//       
// 
//   aplSetLanguageOnCommandHandler(wParam,lParam,this); //   
//
// 3.  OnCmdMsg   (,  CMainFrame::OnCmdMsg)
//       
// 
//   aplSetLaguageOnCmdMsgHandler( nID, nCode, pExtra); //        



///     
// pMenu - /   ( iSubMenu  lpSubmenuName      pMenu
// lpMenuName -   
// lpSubmenuName -   
// langMenuBase -       (   _APS_NEXT_COMMAND_VALUE   ) 
// :      PSM  "IDR_MAINFRAME->->Language ( )":
//		int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
//		{
//			...
//			#define APL_LANG_MENU_BASE 64000		//      
//
//			aplFillLanguageMenu(GetMenu(), APL_T("&"), APL_T("Language ( )"), APL_LANG_MENU_BASE);
//			...


bool CLASS_DECL_APL_GUI aplFillLanguageMenu(CMenu* pMenu, LPCTSTR lpMenuName = NULL, LPCTSTR lpSubmenuName = NULL, unsigned int langMenuBase = 64000);

//   ,     ,    
//   . 

void CLASS_DECL_APL_GUI aplSetLanguageOnCommandHandler(WPARAM wParam, LPARAM lParam, CWnd *wnd);

//    .         ,   
//   . 

void CLASS_DECL_APL_GUI aplSetLaguageOnCmdMsgHandler(UINT nID, int nCode, void* pExtra);



//         ,   
//  -   
int CLASS_DECL_APL_GUI aplTestSelectLanguage(LPCTSTR lpSection = _T("Settings"), LPCTSTR lpEntry = _T("DefLangCode"));

//   
void CLASS_DECL_APL_GUI aplTranslateMenu(CMenu* menu, bool bRecursive = false);


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.
#elif !defined(HIDE)
//		   //   ClassView
#define HIDE /##*

//


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(APL_GUI_H__C8F05508_3C3D_11D3_A148_000000000000__INCLUDED_)
#pragma once



