// AplGuiEx.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include <afxdllx.h>
#include "resource.h"
#include <aplAggr.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static AFX_EXTENSION_MODULE AplGuiExDLL = { NULL, NULL };

HINSTANCE hDllInst = 0;
//char *DllName = APL_T(" ");
CImageList	*m_buttons_il = NULL;
CImageList	*m_buttons_gray_il = NULL;
CImageList	*m_PssButtonIL = NULL;


extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	// Remove this if you use lpReserved
	UNREFERENCED_PARAMETER(lpReserved);

	hDllInst = hInstance;

	if (dwReason == DLL_PROCESS_ATTACH)
	{
		TRACE0("APLGUIEX.DLL Initializing!\n");
		
		// Extension DLL one-time initialization
		if (!AfxInitExtensionModule(AplGuiExDLL, hInstance))
			return 0;

		// Insert this DLL into the resource chain
		// NOTE: If this Extension DLL is being implicitly linked to by
		//  an MFC Regular DLL (such as an ActiveX Control)
		//  instead of an MFC application, then you will want to
		//  remove this line from DllMain and put it in a separate
		//  function exported from this Extension DLL.  The Regular DLL
		//  that uses this Extension DLL should then explicitly call that
		//  function to initialize this Extension DLL.  Otherwise,
		//  the CDynLinkLibrary object will not be attached to the
		//  Regular DLL's resource chain, and serious problems will
		//  result.

		new CDynLinkLibrary(AplGuiExDLL);

		CBitmap bm;
		if(m_PssButtonIL==NULL)
		{
			m_PssButtonIL = new CImageList;
			HBITMAP hbm = ::LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_BITMAPS));
			bm.Attach(hbm);
			m_PssButtonIL->Attach(::ImageList_Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100));
			m_PssButtonIL->Add(&bm,RGB(192,192,192));
			bm.Detach();
			DeleteObject(hbm);
		}
		if(m_buttons_il==NULL)
		{
			m_buttons_il = new CImageList;
			HBITMAP hbm = ::LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_BUTTON_ICONS));
			bm.Attach(hbm);
			m_buttons_il->Attach(::ImageList_Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100));
			m_buttons_il->Add(&bm, RGB(192,192,192));
			bm.Detach();
			DeleteObject(hbm);
		}
		if (m_buttons_gray_il == NULL)
		{
			m_buttons_gray_il = new CImageList;
			HBITMAP hbm = ::LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_BUTTON_ICONS_GRAY));
			bm.Attach(hbm);
			m_buttons_gray_il->Attach(::ImageList_Create(16, 16, ILC_COLOR24 | ILC_MASK, 0, 100));
			m_buttons_gray_il->Add(&bm, RGB(192, 192, 192));
			bm.Detach();
			DeleteObject(hbm);
		}
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		if(m_buttons_il)
		{
			m_buttons_il->DeleteImageList();
			delete m_buttons_il;
		}
		if (m_buttons_gray_il)
		{
			m_buttons_gray_il->DeleteImageList();
			delete m_buttons_gray_il;
		}
		if(m_PssButtonIL)
		{
			m_PssButtonIL->DeleteImageList();
			delete m_PssButtonIL;
		}
		TRACE0("APLGUIEX.DLL Terminating!\n");
		// Terminate the library before destructors are called
		AfxTermExtensionModule(AplGuiExDLL);
	}
	return 1;   // ok
}

CAplGuiExResourceHandleChange::CAplGuiExResourceHandleChange()
{
	hRes2Restore = AfxGetResourceHandle();
	AfxSetResourceHandle(hDllInst);
}