#pragma once
#include <comdef.h>
#include <comutil.h>
#include <vector>
#include <set>

// CaplExcel

#ifdef APL_EXCEL_IMPL
	#define CLASS_DECL_APL_EXCEL  _declspec(dllexport)
#else
	#define CLASS_DECL_APL_EXCEL  _declspec(dllimport)

#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"apl_excel_ud.lib")
#else
#pragma comment (lib,"apl_excelD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"apl_excel_u.lib")
#else
#pragma comment (lib,"apl_excel.lib")
#endif
#endif

#endif

class CaplExcelFile;
class CaplExcelSheet;

/*
class CLASS_DECL_APL_EXCEL CaplExcel 
{
public:
	CaplExcel();
	virtual ~CaplExcel();

	CaplExcelFile *OpenFile(LPCSTR fname, bool bReadOnly=false); //  

	void SetVisible(bool bVisible); //  true -   Excel  (  )   - false;

protected:
	void *m_pExcel;
};
*/

//******************************************************************
class CLASS_DECL_APL_EXCEL CaplExcelFile //   CaplExcel::OpenFile
{
	friend CaplExcelSheet;
public:
	CaplExcelFile();
	//CaplExcelFile(void *excel,void *book);  //   ! 
	~CaplExcelFile();

	static bool SetVisible(bool bVisible); //  true -   Excel  (  )   - false;  true -  ,  false  

	bool Create();
	bool Open(LPCTSTR fname, bool bReadOnly=false, CString *err = 0); //  
	bool Save();	 //  
	bool SaveAs(LPCTSTR fname);
	bool Close();	 //  . 

	//CaplExcelSheet *OpenSheet(int sheet_num, bool bActivate=true);       //     (  1)
	//CaplExcelSheet *OpenSheet(LPCSTR sheet_name, bool bActivate=true);   //    

	//CaplExcelSheet *AddSheet(LPCSTR sheet_name, bool bActivate=true, int iNum=-1);    //    bNum =-    (0-  , -1-  )

	static bool InitExcel();

	bool IsValid() { return m_bValid; }
	void SetValid(bool bValid) { m_bValid = bValid;  }

protected:

	bool m_bValid;
	void *m_pWorkBook;
};


//******************************************************************
class CLASS_DECL_APL_EXCEL CaplExcelSheet 
{
public:
	CaplExcelSheet(); 
	~CaplExcelSheet();	

	enum aplXlChartType	//    excel9.tlh,       
	{
		xlPie = 5,
		xlColumnClustered = 51,
		xlColumnStacked = 52,
		xlBarClustered = 57,		
		xlXYScatterSmoothNoMarkers = 73,
		xlXYScatterLines = 74
	};

	enum aplXlDataLabelPosition
	{
		xlLabelPositionCenter = -4108,
		xlLabelPositionNone = -1,
		xlLabelPositionAbove = 0,
		xlLabelPositionBelow = 1,
		xlLabelPositionLeft = -4131,
		xlLabelPositionRight = -4152,
		xlLabelPositionOutsideEnd = 2,
		xlLabelPositionInsideEnd = 3,
		xlLabelPositionInsideBase = 4,
		xlLabelPositionBestFit = 5,
		xlLabelPositionMixed = 6,
		xlLabelPositionCustom = 7
	};

	enum aplXlLegendPosition
	{
		aplXlLegendPositionBottom = -4107,
		aplXlLegendPositionRight = -4152
	};

	enum aplXlDirection  //    excel9.tlh,       
	{
		aplxlDown = -4121,
		aplxlToLeft = -4159,
		aplxlToRight = -4161,
		aplxlUp = -4162
	};

	enum aplXlWindowView
	{
		aplxlNormalView = 1,
		aplxlPageBreakPreview = 2,
		aplxlPageLayoutView = 3
	};

	enum aplXlColontilePosition
	{
		aplXlPosLeft,
		aplXlPosCenter,
		aplXlPosRight
	};

	struct SRangeFormula
	{
		int _row1;
		int _col1;
		int _row2;
		int _col2;
	};

	struct STableStyle
	{
		int _row1;
		int _col1;
		int _row2;
		int _col2;

		int _headerRows;
		int _footerRows;

		unsigned long _headerColor;
		unsigned long _footerColor;
		unsigned long _headerFontColor;
		unsigned long _footerFontColor;

		unsigned long _line1Color;
		unsigned long _line2Color;
	};

	class CChartInfo
	{
	public:
		int _rowStart;	
		int _colStart;
		int _rowEnd;
		int _colEnd;

		aplXlChartType				_chartType;
		aplXlLegendPosition 		_legendPosition;
		CRect						_chartRect;
		CString						_chartTitle;
		aplXlDataLabelPosition		_labelPosition;
		double						_dMinXValue;
		double						_dMaxXValue;
		bool						_bXMaxValueIsAuto;
		bool						_bXMinValueIsAuto;
		
		std::vector<CString> _seriesNames;
		std::vector<std::vector<SRangeFormula>> _seriesXValues;
		std::vector<std::vector<SRangeFormula>> _seriesYValues;

		CChartInfo()
		{
			_rowStart = 1;	
			_colStart = 1;
			_rowEnd = 1;
			_colEnd = 1;

			_labelPosition = xlLabelPositionNone;
			_legendPosition = aplXlLegendPositionBottom;
			_chartRect = CRect(0, 0, 200, 100);			
			_dMinXValue=0;
			_dMaxXValue=0;
			_bXMaxValueIsAuto= true;
			_bXMinValueIsAuto= true;
		}
	};	
	static unsigned long createRGB(int r, int g, int b);

	//param sheet_name-  .    32  (  ,  Office 2010  )
	bool AddSheet(CaplExcelFile *file, LPCTSTR sheet_name, bool bActivate=true, int iNum=-1);    //    bNum =-    (0-  , -1-  )
	bool OpenSheet(CaplExcelFile *file, int sheet_num, bool bActivate=true);       //     (  1)
	bool OpenSheet(CaplExcelFile *file, LPCTSTR sheet_name, bool bActivate=true);   //    

	bool DeleteSheet(CaplExcelFile *file, int iNum);
	bool HideSheet(CaplExcelFile *file, int iNum);

	int GetSheetsCount();

	void Close(); //  

	bool Activate(); // 
	bool SetName(LPCSTR newName); //  
	bool GetName(CString &sName); //    
	bool CopyFrom(CaplExcelSheet *sheet);    //   . newName -   

	int GetRowsCount();     //    
	int GetColunmsCount();  //    

	bool SetThroughRows(LPCTSTR rows);			//   .  "$1:$2" -  1  2    	
	bool SetThroughColumns(LPCTSTR columns);	//   .  "$B:$B" -  B    	

	bool SetCellWordBreak(int row, int col);	//     
	bool SetColontileHeader(LPCTSTR text, aplXlColontilePosition pos = aplXlPosCenter);		//   
	bool SetColontileFooter(LPCTSTR text, aplXlColontilePosition pos = aplXlPosCenter);		//   

	bool SetFreezeArea(LPCSTR range); //  ,    

	bool GetVPageBreaks(std::vector<int> &breaks); //       ( )

	int GetColumnBN(LPCSTR name, int max_col=100); //      (  ) max_col - -  

	bool GetColumnWidthInPx(int ColNum, double &width);//     
	bool GetRowHeightInPx(int rowNum, double &height);//     
	bool GetRangeHeightInPx(int rowFrom, int rowTo, double &height);//     
	bool GetRangeWidthInPx(int colFrom, int colTo, double &width);//     
	bool GetRowTopInPx(int rowNum, double &dTop);//      
	int GetRowUnderPx(int nPix, int nBeginRow = 1);	//  1-      nPix

	bool GetColumnWidth(int ColNum, double &width); //   
	bool SetColumnWidth(int ColNum, double  width); //   
	bool SetRowHeight(int rowNum, double height);	//   
	bool SetRowsHeight(int rowNum1, int rowNum2, double height);//   
	bool GetRowHeight(int rowNum, double &height); //   

	bool SetCell(LPCTSTR cell, LPCTSTR val);	   //      (, "B7")
	bool SetCell(int row, LPCTSTR, LPCTSTR val); //          (, "AC")
	bool SetCell(int row, int col, LPCTSTR val=NULL, LPCTSTR sFormat=NULL);//          
	bool SetCell(int row, int col, _variant_t val, LPCTSTR sFormat=NULL);
protected:
	COleSafeArray* m_pBufferArr;
	COleSafeArray* m_pBufferFormatArr;
	COleSafeArray* m_pBufferMergeHorizArr;
	COleSafeArray* m_pBufferMergeVertArr;
	UINT m_iBufferRowStart;
	UINT m_iBufferColStart;
	UINT m_iBufferRowEnd;
	UINT m_iBufferColEnd;
public:
	static void FillSafeArray(_variant_t val, int iRow, int iCol, COleSafeArray* saValue, OLECHAR FAR* valFormat = NULL, COleSafeArray* saFormat = NULL) ;

	COleSafeArray* GetBufferArray() {return m_pBufferArr;};
	COleSafeArray* GetBufferFormatArray() {return m_pBufferFormatArr;};
	COleSafeArray* GetBufferMergeHorizArray() {return m_pBufferMergeHorizArr;};
	COleSafeArray* GetBufferMergeVertArray() {return m_pBufferMergeVertArr;};
	//        SetCell(...)
	void UseBufferArray(int rowStart=1, int colStart=1, int rowEnd=1000, int colEnd=100, bool bUse= true);
	bool SetBufferArray(int row1, int col1, int row2, int col2, COleSafeArray* pValArr, COleSafeArray* pFormatArr=NULL, COleSafeArray* pMergeHorizArr=NULL, COleSafeArray* pMergeVertArr=NULL);
	//""      Excel
	bool SetCellsByBufferArray();
	//    
	void MergeCellsByBuffer();
	//    ,     SetCell(...)  "" 
	void ClearBufferArrayPtrs();

	bool SetCellsByArray(int row1, int col1, int row2, int col2, COleVariant& arr);

	bool GetCellText(int row, int col, CString &val);
	bool GetCell(LPCTSTR cell, CString &val);		 //      (, "B7")
	bool GetCell(int row, LPCTSTR col, CString &val); //          (, "AC")
	bool GetCell(int row, int col, CString &val, _variant_t* varTval=NULL, bool bAsText = false);	 //          

	bool InsertRow(int RowNum); //   RowNum -     ( RowNum=7,    7   )
	bool InsertCol(int ColNum); //  c ColNum -     ( RowNum=7,   7   8)
	bool DeleteRow(int RowNum);
	bool DeleteCol(int ColNum);

	bool Merge(LPCTSTR range, bool bConvertFromR1C1=false); //   range   "B10:C12"
	bool Merge(int row1, int col1, int row2, int col2);

	bool Find(LPCTSTR val, std::set<std::pair<int, int>>& out_row_col);			//      (  -)
	bool Find(LPCTSTR val, int row1, int col1, int row2, int col2, std::set<std::pair<int, int>>& out_row_col); //     
protected:
	bool Find(LPCTSTR val, void* pRange, std::set<std::pair<int, int>>& out_row_col);
public:

	bool SetVertiacalText(int row, int col);
	bool FitContentOnePage();
	bool SortRangeByColumnDescending(SRangeFormula &range);			//  			
	bool FitColumnsInOnePage();										//       ( )
	bool SetLandScapeOrientation();									//    
	bool SetPortraitOrientation();									//    
	bool AutoFitColumns();											//       
	bool MakeCellBorder(int row, int col, bool mediumWeight = false);	//    		
	bool MakeCellColor(int row, int col, int colorIndex);			//   	
	bool Select(LPCTSTR range, bool bConvertFromR1C1=false); 		//  
	bool AddIndentToCell(int row, int col, long indent);			//    
	bool SetCellFontSize(int row, int col, int size);				//   	
	bool SetWrapText(int row, int col);								//    
	bool SetWrapText(int row1, int col1, int row2, int col2);		//    (   
	bool SetCellBold(int row, int col);								//    
	bool SetCellBold(int row1, int col1, int row2, int col2);		//    
	bool SetCellUnderline(int row, int col);						//    
	bool SetCellUnderline(int row1, int col1, int row2, int col2);	//    
	bool MakeAlignCenter(int row, int col);							//     	
	bool MakeAlignCenter(int row1, int col1, int row2, int col2);	//     	
	bool MakeVAlignCenter(int row, int col);						//     	
	bool MakeVAlignCenter(int row1, int col1, int row2, int col2);	//     	
	bool MakeVAlignTop(int row, int col);							//     
	bool MakeVAlignTop(int row1, int col1, int row2, int col2);		//     	
	bool MakeVAlignBottom(int row, int col);						//     	
	bool MakeVAlignBottom(int row1, int col1, int row2, int col2);	//     	
	bool MakeAlignLeft(int row, int col);							//      
	bool MakeAlignLeft(int row1, int col1, int row2, int col2);		//      
	bool MakeAlignRight(int row, int col);							//      
	bool MakeAlignRight(int row, int col, int row2, int col2);		//      

	//      Text Align
	int GetCellTextHAlign(int row, int col);
	int SetCellTextHAlign(int row1, int col1, int row2, int col2, int align);
	int GetCellTextVAlign(int row, int col);
	int SetCellTextVAlign(int row1, int col1, int row2, int col2, int align);

	//    -  
	bool IsCellBold(int row, int col);
	bool IsCellUnderLine(int row, int col);
	bool IsCellBorder(int row, int col);
	bool IsCellMerged(int row, int col);	

	long  GetCellBorder(int row, int col);
	bool  SetCellBorder(int row1, int col1, int row2, int col2, long value);

	//       (   )
	//      IsCellMerged
	int HowMergedRows(int row, int col);
	int HowMergedColumns(int row, int col);

	/**  range = $A$1,   */
	bool RepeatRangeOnPrint(LPCTSTR range);

	bool SetCellFontSize(int row1, int col1, int row2, int col2, int size);				//   
	bool MakeCellBorder(int row1, int col1, int row2, int col2, bool mediumWeight = false);	//    		
	bool MakeCellColor(int row1, int col1, int row2, int col2, int colorIndex);

	//     
	int GetCellFontSize(int row, int col);

	//     hex
	unsigned long GetCellColorRGB(int row, int col);

	bool MakeCellColorRGB(int row1, int col1, int row2, int col2, int r, int g, int b);
	bool MakeTextColorRGB(int row1, int col1, int row2, int col2, int r, int g, int b);
	bool MakeTextColorRGB(int row, int col, int r, int g, int b);
	bool MakeCellColorRGB(int row, int col, int r, int g, int b);
	bool MakeTextColorRGB(int row, int col, COLORREF color);
	bool MakeCellColorRGB(int row, int col, COLORREF color);

	// !!     !!!! 
	bool MakeTextColorRGB(int row1, int col1, int row2, int col2, unsigned long colorInHex);
	bool MakeCellColorRGB(int row1, int col1, int row2, int col2, unsigned long colorInHex);


	bool AddChart(CChartInfo &info);								//       
	bool AddChartEx(CChartInfo &info, CaplExcelSheet* chart_sheet = NULL);								//       
	bool AddImage(CRect &rect, CString &path);						//    
	
	bool CopyRange(LPCTSTR from, LPCTSTR to, aplXlDirection direction, bool bConvertFromR1C1=false); //   
	bool CopyRangeWithoutShift(LPCTSTR from, LPCTSTR to, bool bConvertFromR1C1=false); //   
	bool CopyRangeWithoutShift(int source_row1, int source_col1, int source_row2, int source_col2, int dest_row1, int dest_col1, int dest_row2, int dest_col2);  //   
	bool DeleteRange(LPCTSTR range,  aplXlDirection direction, bool bConvertFromR1C1=false); //  

	//     	(-)
	bool ApplyStyleBlueGray(int row1, int col1, int row2, int col2, int headerRows = 1, int footerRows = 1);

	//     	(-)
	bool ApplyStyleOrangeGray(int row1, int col1, int row2, int col2, int headerRows = 1, int footerRows = 1);	

	//     	(-)
	bool ApplyStyleGrayGray( int row1, int col1, int row2, int col2, int headerRows = 1, int footerRows = 1 );

	//     	(-)
	bool ApplyStyleGreen(int row1, int col1, int row2, int col2, int headerRows = 1, int footerRows = 1);

	//      
	void SetDashInsteadZero(bool value = true) { m_dashInsteadZero = value; };

	//    
	bool AddPageBreak(int row);

	//    
	bool AddPageBreakVert(int col);

	//   
	bool SetPageZoom(int size);

	//     (, ,  )
	bool SetViewMode(aplXlWindowView xlViewMode);

	//     
	bool AddComment(int row, int col, LPCTSTR text);

protected:
	void *m_pWorkSheet;
	bool m_dashInsteadZero;

	bool SetOrientation(int orientation);
	bool ApplyStyleToTable(STableStyle &style);	

	bool IfZeroValue(CString value);
};


