#include "StdAfx.h"
#include "PdfAndStagesReportData.h"

CPdfAndStagesReportData::CPdfAndStagesReportData(CaplAPI *api, CaplPreExploitationMgr *mgr)
{
	m_api = api;
	m_mgr = mgr;

	// 
	COleDateTime time(COleDateTime::GetCurrentTime());
	m_CurrYear.Format(_T("%d"), time.GetYear());
	m_PrevYear.Format(_T("%d"), time.GetYear()-1);

	//  
	CString msg;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(APL_T(" "), true);

	if(!ciLvl) 
	{
		msg = APL_T("    \" \".");
		MessageBox(0, msg, APL_T("  "), MB_ICONEXCLAMATION);
		return;
	}

	m_api->m_classifier_mgr.LoadSubClassifierLevels(ciLvl, m_aeStages);	
}

CPdfAndStagesReportData::~CPdfAndStagesReportData(void)
{
	for(int i=0; i<m_mainMap.Size; i++)
	{
		TRecordData *pData = (TRecordData*)m_mainMap[i].out;
		for(int j=0; j<pData->caItems.GetSize(); j++)
			delete pData->caItems[j];
		
		delete pData;
	}
}

int CPdfAndStagesReportData::Add( CaplInstance *ciPrd, CaplInstance *ciRefusal )
{
	if(!ciPrd) return -1;
	if(!ciRefusal) return -1;

	int nIndex = m_mainMap.QFindByIn( (long)ciPrd );
	return AddNew(ciPrd, ciRefusal, nIndex);	
}

int CPdfAndStagesReportData::AddNew(CaplInstance *ciPrd, CaplInstance *ciRefusal, int nIndex)
{
	if(nIndex == -1)
	{
		CString sDate;
		CaplInstance *ciStageTmpl;

		//    
		m_api->m_data.GetAttr(ciRefusal, m_mgr->a_apl_refusal_stage, ciStageTmpl);
		if(ciStageTmpl == 0) return -1;

		//    
		m_api->m_data.GetAttr(ciRefusal, m_mgr->a_apl_refusal_date_detection, sDate);
		if(sDate.IsEmpty()) return -1;
		if(sDate.Left(4) != m_CurrYear && sDate.Left(4) != m_PrevYear) return -1;

		TRecordData *pData = new TRecordData;
		for(int i=0; i<m_aeStages.Size; i++)
		{
			aplExtent *paeNew = new aplExtent;
			pData->caItems.Add(paeNew);
		}

		m_mainMap.Add((long)ciPrd, (long)pData);
		nIndex = m_mainMap.Size-1;
	}

	if(nIndex >= 0)
	{
		// 
		CString sDate;
		CaplInstance *ciStage = 0, *ciStageTmpl = 0;
		TRecordData *pData = (TRecordData*)m_mainMap.Data[nIndex].out;

		//  
		m_api->m_data.GetAttr(ciRefusal, m_mgr->a_apl_refusal_stage, ciStageTmpl);
		if(ciStageTmpl == 0) return -1;

		//  
		m_api->m_data.GetAttr(ciRefusal, m_mgr->a_apl_refusal_date_detection, sDate);
		if(sDate.IsEmpty()) return -1;

		if(sDate.Left(4) == m_CurrYear || sDate.Left(4) == m_PrevYear)
		{
			//   
			for(int i=0; i<m_aeStages.GetSize(); i++)
			{
				if(m_aeStages[i] == ciStageTmpl)
				{
					pData->caItems[i]->Add(ciRefusal);
					return nIndex;
				}
			}						
		}
	}

	return -1;
}

int CPdfAndStagesReportData::GetCount(int nIndex, CaplInstance *ciStage, CString sYear)
{
	CString sDate;
	int size = 0, i, nStage = -1;
	TRecordData *pData = (TRecordData*)m_mainMap[nIndex].out;

	for(i=0; i<m_aeStages.GetSize(); i++)
	{
		if(m_aeStages[i] == ciStage)
			nStage = i;
	}

	for(i=0; i<pData->caItems.GetSize(); i++)
	{
		if(nStage != -1 && nStage != i) continue;

		aplExtent *paeExt = pData->caItems[i];
		for(int j=0; j<paeExt->GetSize(); j++)
		{
			m_api->m_data.GetAttr(paeExt->GetAt(j), m_mgr->a_apl_refusal_date_detection, sDate);
			if(sDate.Left(4) == sYear) size++;
		}
	}

	return size;
	
}

int CPdfAndStagesReportData::GetTotalSize()
{
	int size = 0;

	for(int i=0; i<m_mainMap.Size; i++)
	{
		TRecordData *pData = (TRecordData*)m_mainMap[i].out;
		for(int j=0; j<pData->caItems.GetSize(); j++)
			size += pData->caItems[j]->GetSize();
		
	}

	return size;
}

bool CPdfAndStagesReportData::FillReportWithData( CDataSource *pDataSource )
{
	int size, totalSize;
	CaplInstance *ciPrd = 0;
	CString sPrd, sStage, sVal1, sVal2;

	totalSize = GetTotalSize();
	for(int i=0; i<m_mainMap.Size; i++)
	{
		sVal1.Empty(); sVal2.Empty();
		TRecordData *pData = (TRecordData*)m_mainMap[i].out;
		
		// 
		CaplInstance *ciPrd = (CaplInstance*)m_mainMap.Data[i].in;
		m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_id, sPrd);

		//  
		size = GetCount(i, 0, m_CurrYear);
		if(size != 0) sVal1.Format(_T("%d - %.2f%%"), size, (float)((size*100)/totalSize) );
		else sVal1 = _T("-");

		//  
		size = GetCount(i, 0, m_PrevYear);
		if(size != 0) sVal2.Format(_T("%d - %.2f%%"), size, (float)((size*100)/totalSize) );
		else sVal2 = _T("-");

		//  ""
		CTableRow *pRow = new CTableRow;
		pRow->AddColumn(sPrd);
		pRow->AddColumn(APL_T(""));
		pRow->AddColumn(sVal1);
		pRow->AddColumn(sVal2);
		pDataSource->AddRow(pRow);

		//   
		for(int j=0; j<pData->caItems.GetSize(); j++)   
		{
			// 
			sStage.Empty();
			if(m_aeStages[j]) m_api->m_data.GetAttr(m_aeStages[j], m_api->m_classifier_mgr.a_apl_classifier_level_name, sStage);

			//  
			size = GetCount(i, m_aeStages[j], m_CurrYear);
			if(size != 0) sVal1.Format(_T("%d - %.2f%%"), size, (float)((size*100)/totalSize) );
			else sVal1 = _T(" - ");

			//  
			size = GetCount(i, m_aeStages[j], m_PrevYear);
			if(size != 0) sVal2.Format(_T("%d - %.2f%%"), size, (float)((size*100)/totalSize) );
			else sVal2 = _T(" - ");

			CTableRow *pRow = new CTableRow;
			pRow->AddColumn(_T(""));
			pRow->AddColumn(sStage);
			pRow->AddColumn(sVal1);
			pRow->AddColumn(sVal2);
			pDataSource->AddRow(pRow);
		}
	}

	return true;
}