#pragma once
#include "stdafx.h"
#include "Condition.h"

#ifdef APL_FAULT_MGR
	#define APL_CLASS_TYPE __declspec(dllexport)
#else
	#define APL_CLASS_TYPE __declspec(dllimport)
#endif

//    
#ifndef APL_FAULT_MGR
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"aplFaultManager_ud.lib")
#else
#pragma comment (lib,"aplFaultManagerD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"aplFaultManager_u.lib")
#else
#pragma comment (lib,"aplFaultManager.lib")
#endif
#endif
#endif

using namespace std;

#define TEST_DEDUCTION_CLASSIFIER_LVL			APL_T("  ")
#define CULPRIT_DEDUCTION_CLASSIFIER_LVL		APL_T("  ")
#define REFUSAL_TYPE_CLASSIFIER_LVL				APL_T(" ")
#define REFUSAL_STAGE_CLASSIFIER_LVL			APL_T(" ")
#define REFUSAL_CONDITIONS_CLASSIFIER_LVL		APL_T(" ")
#define REFUSAL_DOF_CLASSIFIER_LVL				APL_T(" ")
#define REFUSAL_REASON_CLASSIFIER_LVL			APL_T(" ")
#define REFUSAL_METHOD_CLASSIFIER_LVL			APL_T(" ")
#define REFUSAL_CONSEQ_CLASSIFIER_LVL			APL_T("")
#define REFUSAL_MANIF_CLASSIFIER_LVL			APL_T("  ")

class CCondition;
class CaplXMLFile;
class CaplXMLNode;

class APL_CLASS_TYPE CaplFaultMgr
{
public:

	CaplFaultMgr();
	~CaplFaultMgr(void);

	//      
	CArray<CCondition*, CCondition*> m_caConditionTmpl;
	CArray<CConditionOperation*, CConditionOperation*> m_caOperationsTmpl;

protected:

	CaplAPI *m_api;
	CaplPreExploitationMgr *m_ExplMgr;

	// -   
	int m_nItemsPerOneLoad;	

	//    SQL 
	CStringArray m_saSQLparts;

	//      
	CaplStrMap m_mapGuidDocument;

	//  
	CStatusDlgThread *m_pStatus;

public:

	bool m_bReadOnly;

	//   
	CaplAPI* GetAPI() { return m_api; };
	CaplPreExploitationMgr* GetExplMgr() { return m_ExplMgr; };

	//  
	bool IsReadyForWork();

	//     
	bool Attach(CaplAPI *api);

	bool LoadClassifiers(); //     

	//     +   ,    
	bool LoadRefusalInfo(CaplInstance *Refusal);
	bool LoadRefusalInfo(aplExtent &aeRefusal);

	//   GUID'  
	bool LoadRefusalsGUID(aplExtent &aeItems);
	
	//      
	bool LoadRefusalCharacts(aplExtent &aeRefusal);
	
	//      
	bool LoadRefusalDocuments(aplExtent &aeRefusal);
	
	//     ext_doc -  ,     
	// src_refusal -      
	CaplInstance* CreateRefusal(CaplInstance *ciParentRefusal, aplExtent &aeUpdatedRefusal, aplExtent *ext_doc=0, CaplInstance *src_refusal=0, CaplInstance *prd_inst=0);

	//    
	bool ShowRefusalProperty(CaplInstance *ciRefusal, aplExtent &aeUpdatedRefusal);


	bool UpdateRefusalInfoInWF(CaplInstance *ciRefusal,CaplInstance *old_planer); //  

	// / XML
	bool ExportToXML(aplExtent &aeRefusal, CString path = _T(""), bool loadRefusalAttr = false, bool loadRefusalCharacts = false, bool loadRefusalDocs = false);
	bool ImportFromXML(CString path = _T(""));

	//  SQL  ( )  
	//  bUseOR == false -    "AND",  "OR"
	CString BuildSQL(CStringArray &saSQLparts, bool bUseOR=false);

	//      STEP_QL
	bool FindRefusalBySQLFilter(CString &sSQL, bool &b_add_to_last_found);

	//  / base64
	CString EncodeToBase64(unsigned char const* BYTEs_to_encode, unsigned int in_len);
	CString DecodeFromBase64(CString encoded_string);

	//   GUID
	CString CreateGUID();

	//     
	bool GetFileNameFromPath(CString &path);

	//   (, , )  
	CString NullTimeInDate(CString time);

	//  ExplMgr
	/**        
		param PrdInst -  
	return <b>true</b>,    -     <b>false</b>   */
	bool IsPlaner(CaplInstance* PrdInst);

	/**	    
		param ext - .      Instance  */
	bool GetParentPdfs(aplExtent &ext);

	/**       
		param System -   Instance     
		param name - <out> 
		return <b>true</b>       <b>false</b>   */
	bool GetSystemName(CaplInstance* System, CString &name);

	bool GetPlanerName(CaplInstance *Planer, CString& name);
	bool GetPKIName(CaplInstance *pki, CString& name);

	/**  Item     
		param Item -  
		param System - ,     
		param bFromBase -     (   )
		return true,  Item         false   */
	bool IsChildItem(CaplInstance* Item, CaplInstance* Parent, bool bFromBase = true);


	

protected:

	/************************************************************************/
	/*                                                               */
	/************************************************************************/

	//    
	CString GetGuidFromMap(CaplInstance *ciDocument);

	//  
	bool InitConditions();

	//  
	void ClearConditions();	

	//    
	CString AskForPath(BOOL open, CString sExtension, CString sFilter);

	//    
	bool XMLExportRefusalParams(CaplXMLNode *root, CaplInstance *ciRefusal);

	//       ""
	bool XMLExportFaultClassifierLvlsRef(CaplXMLNode *root, CaplInstance *ciRefusal, aplExtent &aeClassifierLvl);
	bool XMLExportFaultClassifierLvlRef(CaplInstance *ciRefusal, CaplXMLNode *root, CaplAttr *attr, CString name, aplExtent &aeClassifierLvl);

	//    
	CaplXMLNode* XMLExportClassifierLvls(CaplXMLNode *root, aplExtent &aeClassifierLvl);
	CString XMLExportClassifierLvl(CaplXMLNode *root, CaplInstance *ciLvl);

	//       ""
	bool XMLExportFaultOrganizationsRef(CaplXMLNode *root, CaplInstance *ciRefusal, aplExtent &aeOrganization);
	bool XMLExportFaultOrganizationRef(CaplInstance *ciRefusal, CaplXMLNode *root, CaplAttr *attr, CString name, aplExtent &aeOrganization);

	//    
	CaplXMLNode* XMLExportOrganizations(CaplXMLNode *root, aplExtent &aeOrganization);
	CString XMLExportOrganization(CaplXMLNode *root, CaplInstance *ciOrg);

	//       ""
	bool XMLExportFaultLotsRef(CaplXMLNode *root, CaplInstance *ciRefusal, aplExtent &aeLot);	
	bool XMLExportFaultLotRef(CaplInstance *ciRefusal, CaplXMLNode *root, CaplAttr *attr, CString name, aplExtent &aeLot);

	//    
	CaplXMLNode* XMLExportLots(CaplXMLNode *root, aplExtent &aeLot);
	CString XMLExportLot(CaplXMLNode *root, CaplInstance *ciLot);

	//    - +     ""
	bool XMLExportCharactsValues(CaplXMLNode *root, CaplInstance *ciRefusal, aplExtent &aeCharact, aplExtent &aeOrganization);
	bool XMLExportCharactValue(CaplInstance *ciCharVal, CaplXMLNode *root, aplExtent &aeCharact, aplExtent &aeOrganization);

	//    
	CaplXMLNode* XMLExportCharacts(CaplXMLNode *root, aplExtent &aeCharact);
	CString XMLExportCharact(CaplXMLNode *root, CaplInstance *ciCharact);

	//    +     " "
	bool XMLExportDocuments(CaplXMLNode *root, CaplInstance *ciRefusal, aplExtent &aeDocType);
	bool XMLExportDocument(CaplXMLNode *root, CaplInstance *ciDocument, aplExtent &aeDocType);
	bool XMLExportDocumentTypeRef(CaplXMLNode *root, CaplInstance *ciDocument, aplExtent &aeDocType);

	//     
	CaplXMLNode* XMLExportDocTypes(CaplXMLNode *root, aplExtent &aeDocType);
	CString XMLExportDocType(CaplXMLNode *root, CaplInstance *ciDocType);

	//       " "
	bool XMLExportFaultPrdInstsRef(CaplXMLNode *root, CaplInstance *ciRefusal, aplExtent &aePrdInst);
	bool XMLExportFaultPrdInstRef(CaplInstance *ciRefusal, CaplXMLNode *root, CaplAttr *attr, CString name, aplExtent &aePrdInst);

	//     
	CaplXMLNode* XMLExportPrdInsts(CaplXMLNode *root, aplExtent &aePrdInst, aplExtent &aePdf);
	CString XMLExportPrdInst(CaplXMLNode *root, CaplInstance *ciPrdInst, aplExtent &aePdf);

	//     ( +  )
	CaplXMLNode* XMLExportPrds(CaplXMLNode *root, aplExtent &aePdf);
	CString XMLExportPrd(CaplXMLNode *root, CaplInstance *ciPdf);

	//     ""
	bool XMLExportFiles(CaplXMLNode *root, CaplInstance *ciRefusal);

	//    ""
	bool XMLExportFile(CaplInstance *ciFile, CaplXMLNode *root);		

	//     " "
	bool XMLExportActiveDocVersion(CaplXMLNode *root, CaplInstance *ciDocument);

	//     
	bool SlaveUpdate(CStatusDlgThread *pStatus, CString text);

	//      
	bool ExportWarningToManyRefusal(int size);

	//  xml 
	CaplXMLNode* CreateNode(CaplXMLNode *root, CString name);

	//  
	void SetReference(CaplMap &map, CaplInstance *ciItem, CString sGuid);

	/************************************************************************/
	/*                                                                */
	/************************************************************************/

	//    
	bool LoadImportantPdfInfo(aplExtent &aeItems);
	bool LoadImportantPrdInstInfo(aplExtent &aeItems);
	bool LoadIPrdInstPdfAndPrdInfo(aplExtent &aeItems);

	//      
	CaplXMLNode* GetChildNodeBN(CaplXMLNode *node, CString name);

	//   xml  
	bool ImportWarningToManyRefusal(CaplXMLFile *file, CString path);

	//     xml
	int XMLImportGetCount(CaplXMLFile *file, CString path);

	//     
	bool GetGUIDfromBase(map<CString, long> &baseGUIDs);

	//   
	bool XMLImportParams(CaplInstance *ciFault, CaplXMLNode *node);

	//    (xml - _)   
	bool XMLGetClassifierLevels(CaplXMLNode *node, map<CString, long> &mapLvl);

	//    (xml - _)   
	bool XMLGetOrganiztions(CaplXMLNode *node, map<CString, long> &mapOrg);

	//    (xml - _)   
	bool XMLGetLots(CaplXMLNode *node, map<CString, long> &mapLot);
	
	//     (xml - _)   
	bool XMLGetDocumentTypes(CaplXMLNode *node, map<CString, long> &mapDT);

	//    (xml - _)   
	bool XMLGetProducts( CaplXMLNode *node, map<pair<CString, CString>, long> &mapProducts );
	
	//     (xml - _)     
	bool XMLGetProductInstances(CaplXMLNode *node, map<CString, long> &mapInstances, map<pair<CString, CString>, long> &mapProducts);

	//    (xml - _)  
	bool XMLGetCharactsAndTypes(CaplXMLNode *node, map<CString, long> &mapCharacts, map<CString, long> &mapCharactTypes);

	//         
	bool GetCharactTypes(map<CString, long> &mapCharactTypes);

	//  
	bool XMLImportPictures(CaplXMLNode *nodeFault, CaplInstance *ciRefusal);

	//  
	bool XMLImprotClassifierLevels(CaplXMLNode *nodeFault, CaplInstance *ciRefusal, map<CString, long> &mapClassifierLevels);

	//  
	bool XMLImprotOrganizations(CaplXMLNode *nodeFault, CaplInstance *ciRefusal, map<CString, long> &mapOrg);

	//  
	bool XMLImprotLots( CaplXMLNode *nodeFault, CaplInstance *ciRefusal, map<CString, long> &mapLots );
	
	//     
	CString CreateTemproryFileByContent(CString sName, CString sContent);

	//   
	bool XMLImportCharValues(CaplXMLNode *nodeFault, CaplInstance *ciRefusal, map<CString, long> &mapCharacts, map<CString, long> &mapCharactTypes, map<CString, long> &mapOrg);

	//   
	bool XMLImportProductInstances(CaplXMLNode *nodeFault, CaplInstance *ciRefusal,  map<CString, long> &mapInstances);

	//  
	bool XMLImprotDocuments(CaplXMLNode *nodeFault, CaplInstance *ciRefusal, map<CString, long> &mapDocTypes, map<CString, long> &mapDocument);

	//     (      "FILE"
	CString CreateTemproryFileFromNode(CaplXMLNode *nodeFile);

	//   
	bool XMLImprotStringAttrs(CaplXMLNode *nodeFault, CaplInstance *ciRefusal, map<CString, long> &mapDocument);

	//       
	bool AppendGuidMap(map<CString, long> &baseGuids, aplExtent &aeNewFaults);

	//  - 
	bool MakeTreeStruct(map<CString, long> &baseGuids, map<CString, long> &childGuids);
	
	//   
	static CaplInstance* SelectClassifier(CaplAPI *api, CaplPreExploitationMgr *mgr, CaplInstance *ciRoot, CString sTitle);
	static CaplInstance* SelectOrg(CaplAPI *api, CaplPreExploitationMgr *mgr,CaplInstance *ciRoot, CString sTitle);
	static CaplInstance*SelectMainPdf( CaplAPI *api, CaplPreExploitationMgr *mgr, CaplInstance *ciRoot, CString sTitle );
	static CaplInstance* SelectSystem( CaplAPI *api, CaplPreExploitationMgr *mgr, CaplInstance *ciRoot, CString sTitle );
	static CaplInstance* SelectItem( CaplAPI *api, CaplPreExploitationMgr *mgr, CaplInstance *ciRoot, CString sTitle );
};
