// GetRefusalDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GetRefusalDlg.h"
#include "RefusalFilterDlg.h"

// CGetRefusalDlg dialog

IMPLEMENT_DYNAMIC(CGetRefusalDlg, CaplResizableDialog)

CGetRefusalDlg::CGetRefusalDlg(CaplAPI *api, CaplFaultMgr *mgr, CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CGetRefusalDlg::IDD, pParent)
{
	m_api = api;
	m_FaultMgr = mgr;
	m_ciParentRef = 0;
	m_ciChildRef = 0;
}

CGetRefusalDlg::~CGetRefusalDlg()
{
}

void CGetRefusalDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_SEARCH, m_search_btn);
}


BEGIN_MESSAGE_MAP(CGetRefusalDlg, CaplResizableDialog)
	ON_BN_CLICKED(IDC_SEARCH, &CGetRefusalDlg::OnBnClickedSearch)
	ON_WM_SIZE()
END_MESSAGE_MAP()

BOOL CGetRefusalDlg::OnInitDialog()
{
	CaplResizableDialog::OnInitDialog();

	InitList();
	InitBtns();

	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);
	AddAnchor(IDC_SEARCH, BOTTOM_LEFT);
	AddAnchor(IDC_LIST, TOP_LEFT, BOTTOM_RIGHT);

	return TRUE;
}

void CGetRefusalDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);

	m_list.InsertColumn(0, APL_T(""),				LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_list.InsertColumn(1, APL_T(""),			LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_list.InsertColumn(2, APL_T(""),			LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_list.InsertColumn(3, APL_T(" "),	LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_list.InsertColumn(4, APL_T(" "),	LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
}

void CGetRefusalDlg::InitBtns()
{
	m_ok_btn.SetFlat(FALSE);	
	m_ok_btn.SetIcon(aplGetButtonIco(APL_24_OK));
	
	m_cancel_btn.SetFlat(FALSE);	
	m_cancel_btn.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	
	m_search_btn.SetFlat(FALSE);	
	m_search_btn.SetIcon(aplGetButtonIco(APL_24_FIND));
}

bool CGetRefusalDlg::CheckForLoop(CaplInstance *ciRef)
{
	int nCount = 0;
	CaplInstance *ciParent = 0;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;	

	while(nCount < 10000)
	{
		m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_parent, ciParent);
		if(!ciParent) return true;

		if(ciParent == m_ciChildRef) return false;
		ciRef = ciParent;
	}

	return true;
}

void CGetRefusalDlg::OnOK()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1)
	{
		MessageBox(APL_T("   ."), APL_T(" "), MB_ICONINFORMATION);
		return;
	}

	m_ciParentRef = (CaplInstance*)m_list.GetItemData(nIndex);
	if(m_ciParentRef == m_ciChildRef)
	{
		MessageBox(APL_T("       !"), APL_T(""), MB_ICONINFORMATION);
		m_ciParentRef = 0;
		return;
	}

	if(!CheckForLoop(m_ciParentRef))
	{
		MessageBox(APL_T("     !"), APL_T(""), MB_ICONINFORMATION);
		m_ciParentRef = 0;
		return;
	}

	CaplResizableDialog::OnOK();
}

void CGetRefusalDlg::OnBnClickedSearch()
{
	CRefusalFilterDlg dlg(m_FaultMgr);
	dlg.m_pSQLparts = &m_saSQLparts;

	if(dlg.DoModal() == IDOK)
	{
		aplExtent aeRefusal;

		//  
		long dID = aplStartWaitDlg(APL_T(" ..."));
		if(!m_api->m_data.NET_QueryEditParse(m_FaultMgr->BuildSQL(m_saSQLparts), false)) return;
		if(!m_api->m_data.NET_QueryExecute(aeRefusal)) return;
		aplEndWaitDlg(dID);

		//  
		m_FaultMgr->LoadRefusalInfo(aeRefusal);

		//  
		ShowRefusal(aeRefusal);

		//   
		SetFocus();
		m_list.SetFocus();
		if(aeRefusal.Size) m_list.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED);

		return;
	}
}

void CGetRefusalDlg::ShowRefusal(aplExtent &aeRefusal)
{
	COleDateTime time;
	CaplInstance *ciType = 0, *ciRef;
	CString sType, sDoc, sDocNum, sDate, sState;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;	

	m_list.DeleteAllItems();
	for(int i=0; i<aeRefusal.Size; i++)
	{		
		ciRef= aeRefusal[i];
		int nIndex = m_list.InsertItem(i, _T(""));

		//  
		m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_type, ciType);
		if(ciType) 
		{
			m_api->m_data.GetAttr(ciType, m_api->m_classifier_mgr.a_apl_classifier_level_name, sType);
			m_list.SetItemText(nIndex, 0, sType);
		}

		// 
		m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_state, sState);
		m_list.SetItemText(nIndex, 1, sState);

		// 
		m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_doc_type, sDoc);
		m_list.SetItemText(nIndex, 2, sDoc);

		//  
		m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_doc_num, sDocNum);
		m_list.SetItemText(nIndex, 3, sDocNum);

		//  
		m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_date_detection, sDate);
		if(!sDate.IsEmpty())
		{
			aplString2Date(sDate, time);
			sDate.Format(_T("%.2d.%.2d.%.4d"), time.GetDay(), time.GetMonth(), time.GetYear());
		}
		m_list.SetItemText(nIndex, 4, sDate);

		m_list.SetItemData(nIndex, (DWORD)ciRef);		
	}
}

void CGetRefusalDlg::OnSize( UINT nType, int cx, int cy )
{
	CaplResizableDialog::OnSize(nType, cx, cy);

	if(m_list)
	{
		int k = m_list.GetHeaderCtrl()->GetItemCount();
		CRect rect;
		m_list.GetWindowRect(&rect);
		ScreenToClient(&rect);
		cx = rect.right - rect.left - 12;

		if(k>0)
		{
			int i;
			int dx=0;
			for(i=0;i<k;i++) dx += m_list.GetColumnWidth(i);

			for(i=0; i<m_list.GetHeaderCtrl()->GetItemCount(); i++)
			{
				int l = m_list.GetColumnWidth(i);
				if(l == 0) break;

				HDITEM pHeader;
				pHeader.mask = HDI_WIDTH;
				m_list.GetHeaderCtrl()->GetItem(i, &pHeader);
				pHeader.cxy = ((cx*l)/dx)+1;
				m_list.GetHeaderCtrl()->SetItem(i, &pHeader);				
			}			
		}
	}		
}